#ifndef __SPARSE_BITPLANES_H__
#define __SPARSE_BITPLANES_H__	1

#ifdef __cplusplus
extern "C" {
#endif

void		*create_sparse_byteplane(int width, int height, char kind);
void		destroy_sparse_byteplane(sparse_byteplane_ptr byteplane, char kind);

int			to_sparse_mimage(mimage_ptr *mimg_ptr);
int			to_dense_mimage(mimage_ptr *mimg_ptr);

mimage_ptr	get_near_dense_mimage(mimage_ptr mimg, fmpixel *fx, fmpixel *dfx);
mimage_ptr	get_level_dense_mimage(mimage_ptr mimg, fmpixel *fx);

mimage_ptr	*split_dense_mimage(mimage_ptr mimg, int *retNumber, image_displacement_ptr *offsets, int **pixels_pop);
mimage_ptr	with_mimage(mimage_ptr mimg_a, mimage_ptr mimg_b);
void		write_to_section_data(mimage_ptr mimg, size_t row_section_index, size_t *current_length, size_t starting_pixel_number, size_t number_of_pixels, int position_in_buffer);

mimage_ptr	clone_mimage_sparse(mimage_ptr mimg);
mimage_ptr	const_smimage(void *values_array, image_dimension_ptr dim_ptr, int kind, int planes_number);

mimage_ptr	unary_op_smimage(mimage_ptr mimg, mpixel (*gray_op )(mpixel ), fmpixel (*float_op )(fmpixel ));
mimage_ptr	binary_op_constant_smimage(mimage_ptr mimg, void *values_array, unsigned char (*gray_op )(unsigned char, unsigned char ), float (*float_op )(float, float ));
mimage_ptr	unimath_smimage(void *user_ptr, void *user_ptr2, mimage_ptr mimg, float (*floating_op)(void *user_ptr, void *user_ptr2, float, int));
mimage_ptr	binary_op_smimage(mimage_ptr mimg_a, mimage_ptr mimg_b, unsigned char (*gray_op)(unsigned char, unsigned char), float (*float_op)(float, float));
mimage_ptr	binary_op_sdmimage(mimage_ptr mimg_a, mimage_ptr mimg_b, unsigned char (*gray_op)(unsigned char, unsigned char), float (*float_op)(float, float));
mimage_ptr	extract_planes_mimage_sparse(mimage_ptr mimg, int from, int to);

int			convert_smimage_to_float(mimage_ptr mimg);
int			convert_smimage_to_discrete(mimage_ptr mimg);

mimage_ptr	shrink_and_cut_mimage(mimage_ptr mimg, image_rect_ptr rect_ptr);

mimage_ptr	rotate_90_sparse(mimage_ptr mimg);
mimage_ptr	rotate_180_sparse(mimage_ptr mimg);
mimage_ptr	rotate_270_sparse(mimage_ptr mimg);

mimage_ptr	flip_h_sparse(mimage_ptr mimg);
mimage_ptr	flip_v_sparse(mimage_ptr mimg);

double 		*sumall_mimage_sparse(mimage_ptr mimg, int power);
float		maxof_mimage_sparse(mimage_ptr mimg);
float		minof_mimage_sparse(mimage_ptr mimg);
void		*sort_mimage_sparse(mimage_ptr mimg, int *elements);

size_t		*histogram_mimage_sparse(mimage_ptr mimg, float *fvalues, size_t fvalues_size);
mimage_ptr	threshold_mimage_sparse(mimage_ptr mimg, float *fvalues, size_t fvalues_size);

void		*get_pixel_mimage_sparse(mimage_ptr mimg, int x, int y);
int			set_pixel_mimage_sparse(mimage_ptr mimg, int x, int y, void *pixel_value_array);

mimage_ptr	set_planes_mimage_sparse(mimage_ptr mimg_res, mimage_ptr mimg, int from, int to);
int 		locate_pixel_mimage_sparse(mimage_ptr mimg, int x, int y, int *r_row_idx, int *r_sect_idx, int *r_offset_in_sect, int *r_position_in_buffer, int *r_previous_reached_line);

mimage_ptr	random_mimage_sparse(mimage_ptr mimg, float r_min, float r_max);
mimage_ptr	rectangle_mimage_sparse(int width, int height, int thickness, int planes_number, int kind, void *values_array);
mimage_ptr	ellipse_mimage_sparse(int width, int height, int thick, int planes_number, int kind, void *values_array);

int			crop_mimage_sparse(mimage_ptr mimg, image_rect_ptr rect);
mimage_ptr	mask_dense_using_sparse(mimage_ptr mimg, mimage_ptr mask_mimage);

int			invert_mimage_sparse(mimage_ptr mimg);
int			offset_mimage_sparse(mimage_ptr mimg, image_displacement_ptr d);

void		copy_pixels_between_mimages(mimage_ptr mimg_dst, mimage_ptr mimg_src, int offset_dst, int offset_src, int len);
void		copy_default_value_at_offset(mimage_ptr target_mimg, mimage_ptr mimg_a, int pixels_in_target_buffer, int pixels_to_copy);

mimage_ptr	lut_mimage_sparse(mimage_ptr mimg, mpixel *LUTs[], int number_of_planes, int target_kind);

int			lex_maxof_mimage_sparse(mimage_ptr mimg, gr_image_displacement *pos);
int			lex_minof_mimage_sparse(mimage_ptr mimg, gr_image_displacement *pos);
mimage_ptr	lex_sort_mimage_sparse(mimage_ptr mimg);

mimage_ptr	create_sparse_mimage(int width, int height, int planes_number, int kind, int section_length, int data_length, int buffer_length);
int			count_numbers_of_colors_sparse(mimage_ptr mimg);
int			stuff_sparse_over_dense(mimage_ptr mimg_sparse, mimage_ptr mimg_dense, gr_image_displacement *delta);
int			flatten_sparse_mimage(mimage_ptr mimg);

mimage_ptr	*split_sparse_mimage(mimage_ptr mimg, int *retNumber, image_displacement_ptr *offsets, int **pixels_pop);
mimage_ptr	clone_default_data_sparse(mimage_ptr mimg, int *pop, gr_image_displacement *offset);

	/* TEST ONLY ROUTINES */
mimage_ptr	sin_smimage(mimage_ptr mimg);

#ifdef __cplusplus
}
#endif

#endif /* __SPARSE_BITPLANES_H__ */
