/*
 */

#ifndef macintosh
 int SysBeep(int);
 int SysBeep(int a) {};
#endif /* !macintosh */

#include "gr_bitplns.h"
#include "gr_ops.h"
#include "gr_sparse_bitplns.h"
#include "gr_boolean_sparse_ops.h"
#include "gr_fourier.h"

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

/*
 * Definitions
 */

#define STRESS_TEST		1			/* execute a test continuosly					*/
#define STRESS_TIMES	1			/* number of times to execute the stress test	*/
#define PARANOIC		1			/* check every error and every pointer			*/
#define VERBOSE			1			/* gimme some extra info (timings etc...)		*/

#ifdef PARANOIC
 #define ERROR_STATEMENT(err, a)	{ printf("<==== %s: %d @ %d [%s] ====>\n", (err), (a), __LINE__, __FILE__); SysBeep(0); abort(); }
 #define CHECK_POINTER(a)	if(!(a)) ERROR_STATEMENT("pointer error",(a));
 #define CHECK_ERROR(a)		if((a)) ERROR_STATEMENT("check error",(a));
 #define TEST_COUNTER		test_counter(__LINE__);
#else
 #define ERROR_STATEMENT(a)	;
 #define CHECK_POINTER(a)	;
 #define CHECK_ERROR(a)		;
#endif

/*
 * Prototypes
 */

/*************************************************************************************
 *                           various procedures good for tests 
 *************************************************************************************/

mimage_ptr	get_sparse_n_plane_mimage(char *filename, int n);
mimage_ptr	mix_a_with_random_b(mimage_ptr mimg_a, mimage_ptr mimg_b);
mimage_ptr	create_test_mimage(char *filename_a, char *filename_b, char *file_name_target);
void		superpose_and_write(mimage_ptr mimg_a, mimage_ptr mimg_b, char *filename_target);

void test_counter(int line);	/* count the test */
void tests2execute();	/* shell for main test */

static float fop_c(float x, float y, int c);   /* function for mimage gradient */

	/*
	 *	Tests
	 */
	 
static void stress_test(char *fname, int last_iteration);	/* MrC performance test */

static void testm1(char *fname, char *ofname);						/* test load and save an mimage */
static void testm1_tiff(char *fname);								/* test load and save a TIFF mimage */
static void testm2(char *fname, char *ofname);						/* test convert to floating back and forth an mimage */
static void testm3(char *fname, char *ofname);						/* test the crop function */
static void testm3s(char *fname, char *ofname);						/* test the crop function for sparse images*/
static void testm4(char *fname, char *fname2, char *ofname);		/* test the stuff function */
static void testm5(char *fname);									/* test shrink image */
static void testm6(char *ofname);									/* test const image */
static void testm7(char *fname, char *fname2, char *ofname);		/* test binary operations */
static void testm8(char *fname);									/* test min and max */
static void testm9(char *fname);									/* test sum all */
static void testm10(char *fname);									/* test sort */
static void testfm10(char *fname);									/* test sort in a floating point image */
static void testm11(char *fname, char *ofname);		 				/* test scale */
static void testfm11(char *fname, char *ofname);					/* test float scale */
static void testm12(char *ofname);									/* test gradient */
static void testm13(char *fname, char *ofname);					 	/* test string conversions */
static void testmf14();												/* test float connected components */
static void testmd14();												/* test discrete connected components */
static void testm15(char *fname, char *ofname);						/* test anaglyph */
static void testm16(char *fname);			   			 			/* sparse mimages conversion test */
static void testm17(char *fname);   								/* sparse mimages conversion (level) test */
static void testm18(char *fname);	   								/* sparse mimages conversion (near) test */
static void testmf18(char *fname);   								/* sparse float mimages conversion (near) test */
static void testm19(char *fname);   								/* sparse mimages conversion (near) test and multiply */
static void testm20(char *fname);   								/* sparse mimages clone test */
static void testdm21();				  								/* sparse discrete mimages const test */
static void testfm21();				   								/* sparse float mimages const test */
static void testm22(char *fname);	   								/* sparse mimages from/to float test */
static void testdm23(char *fname);									/* sparse discrete mimages pre-shrink test */
static void testfm23(char *fname);									/* sparse float mimages pre-shrink test */
static void testm24(char *fname);									/* split test */
static void testm24f(char *fname);									/* split test for float images */
static void testm25(char *fname1, char *fname2, char *ofname);		/* sparse mimages binary operation test */
static void testm26(char *fname, char *ofname);						/* test horizontal flip */
static void testm26s(char *fname, char *ofname);					/* test horizontal flip sparse */
static void testm26f(char *fname, char *ofname);					/* test horizontal flip float */
static void testm27(char *fname, char *ofname);						/* test vertical flip */
static void testm27s(char *fname, char *ofname);					/* test vertical flip sparse */
static void testm28_90(char *fname, char *ofname);					/* test rotate 90 */
static void testm28_180(char *fname, char *ofname);					/* test rotate 180 */
static void testm28_270(char *fname, char *ofname);					/* test rotate 270 */
static void testm29(char *fname1, char *fname2, char *ofname);		/* test sum sparse and dense */
static void testmf29(char *fname1, char *fname2, char *ofname);		/* test sum sparse and dense float */
static void testm30s(char *fname);									/* test get mpixel for sparse images */
static void testm30s_bis(char *fname);								/* test locate sparse images */
static void testm31s(char *fname);									/* test sort for sparse images */
static void	testm32s(char *fname);									/* test maxof and minof for sparse images */
static void	testm33s(char *fname);									/* test histogram for sparse images */
static void	testm34s(char *fname);									/* test sum all for sparse images */
static void testm35s(char *fname);									/* test threshold for sparse images */
static void testm36s_bis();											/* test superpose for sparse images */
static void testm36s_tris();										/* test superpose for sparse images */
static void testm36s_4();
static void testm37d(char *fname);									/* test random for dense images */
static void testm37s(char *fname);									/* test random for sparse images */
static void testm38s();												/* test rectangle for sparse images */
static void testm39s();												/* test ellipse for sparse images */
static void testm40d(char *fname);									/* test invert for normal images */
static void testm40s(char *fname);									/* test invert for sparse images */
static void testm41s(char *fname);									/* test offset for sparse images */
static void testm42();												/* test minvolve */
static void testm43();												/* test mask */
static void testm44d();												/* test lex sort dense */
static void testm44s();												/* test lex sort sparse */
static void testm45s();												/* test color counter sparse */
static void	testm46s();												/* sparse mimages split test */
static void	testm46s_bis();											/* sparse mimages split test */
static void testm47();												/* test fft and its inverse */
static void testm47_bis();											/* test fft and its inverse w/ real image */

static void test_flip_and_rotate_stress(char *fname, char *ofname);	/* stress rotate and flip test */

/*
 * Implementation
 */
 
void tests2execute()
{
	mimg_lib_init();		/* initialize the library */

//#define FULL_TEST
#ifdef FULL_TEST
TEST_COUNTER;	/* 0 */
	testm1("source.jpeg", "tojpeg.jpeg");								/* test load and save an mimage */						/* NO LEAKS */
TEST_COUNTER;	/* 1 */
	testm1_tiff("source.tiff");											/* test load and save a TIFF mimage */					/* NO LEAKS */
TEST_COUNTER;	/* 2 */
	testm2("source.jpeg", "double_converted.jpeg");						/* test convert to floating back and forth an mimage */	/* NO LEAKS */
TEST_COUNTER;	/* 3 */
	testm3("source.jpeg", "cropped.jpeg");								/* test the crop function */							/* NO LEAKS */
TEST_COUNTER;	/* 4 */
	testm3s("v4.tiff", "vcropped.jpeg");								/* test the crop function for sparse images*/
TEST_COUNTER;	/* 5 */
	testm4("source.jpeg", "1tosum.jpeg", "stuffed.jpeg");				/* test the stuff function */							/* NO LEAKS */
TEST_COUNTER;	/* 6 */
	testm5("1tosum.jpeg");												/* test shrink image */									/* NO LEAKS */
TEST_COUNTER;	/* 7 */
	testm6("const.jpeg");												/* test const image */									/* NO LEAKS */
TEST_COUNTER;	/* 8 */
	testm7("1tosum.jpeg", "2tosum.jpeg", "thesum.jpeg");				/* test binary operations */							/* NO LEAKS */
TEST_COUNTER;	/* 9 */
	testm8("source.jpeg");												/* test min and max */									/* NO LEAKS */
TEST_COUNTER;	/* 10 */
	testm9("source.jpeg");												/* test sum all */										/* NO LEAKS */
TEST_COUNTER;	/* 11 */
	testm10("source.jpeg");												/* test sort */											/* NO LEAKS */	
TEST_COUNTER;	/* 12 */
	testfm10("source.jpeg");											/* test sort in a floating point image */				/* NO LEAKS */
TEST_COUNTER;	/* 13 */
	testm11("source.jpeg", "scaled_source.jpeg"); 						/* test scale */										/* NO LEAKS */
TEST_COUNTER;	/* 14 */
	testfm11("source.jpeg", "float_scaled_source.jpeg");				/* test float scale */									/* NO LEAKS */
TEST_COUNTER;	/* 15 */
	testm12("gradient.jpeg");											/* test gradient */										/* NO LEAKS */
TEST_COUNTER;	/* 16 */
	testm13("source.jpeg", "double_converted.jpeg");					/* test string conversions */							/* NO LEAKS */
TEST_COUNTER;	/* 17 */
	testmd14();														 	/* test discrete connected components */				/* NO LEAKS */
TEST_COUNTER;	/* 18 */
	testmf14();												   			/* test float connected components */					/* NO LEAKS */
TEST_COUNTER;	/* 19 */
	testm15("spot.tiff", "anaglyph.tiff");								/* test anaglyph */										/* NO LEAKS */
TEST_COUNTER;	/* 20 */
	testm16("spiral.tiff");				  						 		/* sparse mimages conversion test */					/* NO LEAKS */
TEST_COUNTER; /* 21 */
	testm17("spiral.tiff");												/* sparse mimages conversion (level) test */			/* NO LEAKS */
TEST_COUNTER;	/* 22 */
	testm18("spiral.tiff");												/* sparse mimages conversion (near) test */				/* NO LEAKS */
TEST_COUNTER; /* 23 */
	testmf18("spiral.tiff"); 											/* sparse float mimages conversion (near) test */		/* NO LEAKS */
TEST_COUNTER; /* 24 */
	testm19("spiral.tiff");			  									/* sparse mimages conversion (near) test and mul */		/* NO LEAKS */
TEST_COUNTER; /* 25 */
	testm20("spiral.tiff"); 											/* sparse mimages clone test */							/* NO LEAKS */
TEST_COUNTER; /* 26 */
	testdm21();															/* sparse discrete mimages const test */				/* NO LEAKS */
TEST_COUNTER;	/* 27 */
	testfm21();															/* sparse float mimages const test */					/* NO LEAKS */
TEST_COUNTER;	/* 28 */
	testm22("source.tiff");					 			  				/* sparse mimages from/to float test */					/* NO LEAKS */
TEST_COUNTER; /* 29 */
	testfm23("2.TIFF");													/* sparse float mimages pre-shrink test */				/* NO LEAKS */
TEST_COUNTER; /* 30 */
	testdm23("2.TIFF");													/* sparse discrete mimages pre-shrink test */			/* NO LEAKS */
TEST_COUNTER; /* 31 */
	testm24("4.tiff");													/* split test */										/* NO LEAKS */
TEST_COUNTER; /* 32 */
	testm24f("for_get_level.tiff");										/* float split test */									/* NO LEAKS */
TEST_COUNTER; /* 33 */
	testm25("1tosum.tiff", "2tosum.tiff", "sum.tiff");					/* sparse mimages binary operation test */				/* NO LEAKS */
TEST_COUNTER; /* 34 */
	testm26("orientate.tiff", "orientate_flippedh.tiff");				/* test horizontal flip */								/* NO LEAKS */
TEST_COUNTER; /* 35 */
	testm26f("orientate.tiff", "orientate_flippedh.tiff");				/* test horizontal flip for float */					/* NO LEAKS */
TEST_COUNTER; /* 36 */
	testm26s("signature.tiff", "signature_flippedh.tiff");				/* test horizontal flip sparse */						/* NO LEAKS */
TEST_COUNTER; /* 37 */
	testm26f("orientate.tiff", "orientate_flippedh.tiff");				/* test horizontal flip for float */					/* NO LEAKS */
TEST_COUNTER; /* 38 */
	testm27("orientate.tiff", "orientate_flippedv.tiff");				/* test vertical flip */								/* NO LEAKS */
TEST_COUNTER; /* 39 */
	testm27s("signature.tiff", "signature_flippedv.tiff");				/* test vertical flip sparse */							/* NO LEAKS */
TEST_COUNTER; /* 40 */
	testm28_90("orientate.tiff", "orientate_rotate90.tiff");			/* test rotate 90 */									/* NO LEAKS */
TEST_COUNTER; /* 41 */
	testm28_180("orientate.tiff", "orientate_rotate180.tiff");			/* test rotate 180 */									/* NO LEAKS */
TEST_COUNTER; /* 42 */
	testm28_270("orientate.tiff", "orientate_rotate270.tiff");			/* test rotate 270 */									/* NO LEAKS */
TEST_COUNTER; /* 43 */
	testmf29("signature_8.tiff","spiral.tiff","sparsedenseop.tiff");	/* test sum sparse and dense float */					/* NO LEAKS */
TEST_COUNTER; /* 44 */
	testm29("signature_8.tiff","spiral.tiff","sparsedenseop.tiff");		/* test sum sparse and dense */							/* NO LEAKS */
TEST_COUNTER; /* 45 */
	testm30s("locate.tiff");											/* test get mpixel for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 46 */
	testm30s_bis("locate.tiff");										/* test the locate */
TEST_COUNTER; /* 47 */
	testm31s("small_test.tiff");										/* test sort for sparse images */						/* NO LEAKS */
TEST_COUNTER; /* 48 */
	testm32s("small_test.tiff");										/* test maxof and minof for sparse images */			/* NO LEAKS */
TEST_COUNTER; /* 49 */
	testm33s("small_test.tiff");										/* test histogram for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 50 */
	testm34s("small_test.tiff");										/* test sum all for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 51 */
	testm35s("small_test.tiff");										/* test threshold for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 52 */
	testm36s_bis();														/* test superpose for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 53 */
	testm36s_tris();													/* test superpose for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 54 */
	testm36s_4();														/* test superpose for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 55 */
	testm37d("source.tiff");											/* test random for dense images */						/* NO LEAKS */
TEST_COUNTER; /* 56 */
	testm37s("shape.tiff");												/* test random for sparse images */						/* NO LEAKS */
TEST_COUNTER; /* 57 */
	testm38s();															/* test rectangle for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 58 */
	testm39s();															/* test ellipse for sparse images */					/* NO LEAKS */
TEST_COUNTER; /* 59 */
	testm40d("shape.tiff");												/* test invert for normal images */						/* NO LEAKS */
TEST_COUNTER; /* 60 */
	testm40s("shape.tiff");												/* test invert for sparse images *						/* NO LEAKS */
TEST_COUNTER; /* 61 */
	testm41s("shape.tiff");												/* test offset for sparse images */
TEST_COUNTER; /* 62 */
	testm42();															/* test minvolve */
TEST_COUNTER; /* 63 */
	testm43();															/* test mask */											/* NO LEAKS */
TEST_COUNTER; /* 64 */
	testm44d();															/* test lex sort dense */								/* NO LEAKS */
TEST_COUNTER; /* 65 */
	testm44s();															/* test lex sort sparse */
TEST_COUNTER; /* 66 */
	testm45s();															/* test color counter sparse */
TEST_COUNTER; /* 67 */
	testm46s();															/* sparse mimages split test */
TEST_COUNTER; /* 68 */
	testm47(); 															/* test fft and its inverse */							/* NO LEAKS */
TEST_COUNTER; /* 69 */
	testm47_bis();														/* test fft and its inverse w/ images */				/* NO LEAKS */
#endif

#ifdef SUITE_1_MRC
	stress_test("spot.tiff", 100);
	stress_test("spot.tiff", 200);
	stress_test("spot.tiff", 500);
#else
	stress_test("spot.tiff", 10);
	stress_test("spot.tiff", 20);
	stress_test("spot.tiff", 50);
	stress_test("spot.tiff", 100);
#endif
}

void stress_test(char *fname, int last_iteration)
{
	clock_t begin, end;
#ifdef SUITE_1_MRC
	int i;
	int err, res;
	mimage_ptr mimg, result_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

//	convert_mimage_to_float(mimg);
//	CHECK_POINTER(mimg);

	begin = clock();
	for (i=0;i<last_iteration;i++) {
		result_mimg = anaglyph_mimage(mimg, .05, .5);
		CHECK_POINTER(result_mimg);
		if (i==(last_iteration-1)) {
			res = write_tiff_mimage("stress_test_out.tiff", result_mimg);
			CHECK_ERROR(res);
		}
		destroy_mimage(result_mimg);
	}
	end = clock();
	
	printf("ellapsed time for stress test = %3.2f secs\n", ((float)end-begin)/CLOCKS_PER_SEC);
		
	destroy_mimage(mimg);
#else
	int err;
	int number;
	int i, j;
	int *pixels_pop;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {15., 15., 15.};

	mimage_ptr mimg;
	mimage_ptr *result_mimgs;

	char result_name[256];
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	err = convert_mimage_to_float(mimg);
	CHECK_ERROR(err);
	
	begin = clock();
	for (j=0;j<last_iteration;j++) {

		result_mimgs = split_dense_mimage(mimg, &number, NULL, &pixels_pop);
		CHECK_POINTER(result_mimgs);

		if (number>0) {

			if (i == last_iteration - 1)
				for (i=0;i<number;i++) 
					printf("Population for image #%d = %d\n", i, pixels_pop[i]);

			for (i=0;i<number;i++) {
				err = to_dense_mimage(&result_mimgs[i]);
				CHECK_POINTER(result_mimgs[i]);
				CHECK_ERROR(err);

				sprintf(result_name, "dense_%d.tiff", i);
				
	//			err = write_tiff_mimage(result_name,result_mimgs[i]);
	//			CHECK_ERROR(err);

				destroy_mimage(result_mimgs[i]);
			}
		}
		SMART_FREE(result_mimgs);
		SMART_FREE(pixels_pop);
	}
	
	end = clock();
	printf("ellapsed time for stress test = %3.2f secs\n", ((float)end-begin)/CLOCKS_PER_SEC);
	
	
	destroy_mimage(mimg);
#endif
}


static void testm47_bis()
{
	int i=0, res;
	mimage_ptr mimg, mimg_re, mimg_im;
	mimage_ptr res_mimg;
	fmpixel_ptr buffer;
		
	mimg = read_jpeg_mimage("32by32.jpeg");
	CHECK_POINTER(mimg);
	
	res = fft_mimage(mimg, &mimg_re, &mimg_im);
	CHECK_ERROR(res);
	res = fft_inverse_mimage(mimg_re, mimg_im, &res_mimg);
	CHECK_ERROR(res);

	res = write_jpeg_mimage("fft_out.jpeg", res_mimg);
	CHECK_ERROR(res);
	
	destroy_mimage(mimg);
	destroy_mimage(mimg_re);
	destroy_mimage(mimg_im);
	destroy_mimage(res_mimg);
}

static void testm47()
{
	int i=0, res;
	mimage_ptr mimg, mimg_re, mimg_im;
	mimage_ptr res_mimg;
	fmpixel_ptr buffer;
		
	mimg = create_mimage(16, 16, 1, FLOAT_IMAGE, DENSE_IMAGE);
	CHECK_POINTER(mimg);
		
	buffer = get_fbyteplane_from_mimage(mimg,0)->buffer;

	for (i=0; i < 16*16; i++)
		buffer[i] = i % 2;
		
	res = fft_mimage(mimg, &mimg_re, &mimg_im);
	CHECK_ERROR(res);
	res = fft_inverse_mimage(mimg_re, mimg_im, &res_mimg);
	CHECK_ERROR(res);

	buffer = get_fbyteplane_from_mimage(res_mimg,0)->buffer;
	for (i=0; i < 16*16; i++)
		if (buffer[i] != i % 2)
			CHECK_ERROR(1);		/* exit with an error condition */
	
	destroy_mimage(mimg);
	destroy_mimage(mimg_re);
	destroy_mimage(mimg_im);
	destroy_mimage(res_mimg);
}

static void testm46s_bis()
{
	int i;
	int col_num;
	int retNumber;
	mimage_ptr src_mimg_a, src_mimg_b, src_mimg_c, src_mimg_temp, src_mimg, *mimgs;
	
	image_displacement_ptr offsets;
	int *pixels_pop;
	
	src_mimg_a = get_sparse_n_plane_mimage("small_to_split.TIFF", 1);
	CHECK_POINTER(src_mimg_a);

	src_mimg_b = get_sparse_n_plane_mimage("small_to_split_2.TIFF", 1);
	CHECK_POINTER(src_mimg_b);

	src_mimg_c = get_sparse_n_plane_mimage("small_to_split_3.TIFF", 1);
	CHECK_POINTER(src_mimg_c);
	
	src_mimg_temp = superpose_smimage(src_mimg_a, src_mimg_b);
	CHECK_POINTER(src_mimg);

	src_mimg = superpose_smimage(src_mimg_temp, src_mimg_c);
	CHECK_POINTER(src_mimg);

	write_tiff_mimage("test_out.tiff", src_mimg);
	
	col_num = count_numbers_of_colors_sparse(src_mimg);

	mimgs = split_sparse_mimage(src_mimg, &retNumber, &offsets, &pixels_pop);
	CHECK_POINTER(mimgs);

	for (i=0; i<retNumber; i++) {
		char fileName[80];
		mimage_ptr mimg = mimgs[i];
		
		sprintf(fileName, "split_sparse_res_%2d.tiff", i);
		write_tiff_mimage(fileName, mimg);

		destroy_mimage(mimg);
	}

	SMART_FREE(offsets);
	SMART_FREE(pixels_pop);

	SMART_FREE(mimgs);
	destroy_mimage(src_mimg_a);
	destroy_mimage(src_mimg_b);
	destroy_mimage(src_mimg_c);
	destroy_mimage(src_mimg_temp);
	destroy_mimage(src_mimg);
}

static void testm46s()
{
	int i;
	int col_num;
	int retNumber;
	mimage_ptr src_mimg, rnd_mimg, *mimgs;

	src_mimg = get_sparse_n_plane_mimage("small_to_split.TIFF", 1);
	CHECK_POINTER(src_mimg);
	
	rnd_mimg = random_mimage_sparse(src_mimg, 100., 200.);	/* randomize the contents of this image */
	CHECK_POINTER(rnd_mimg);

	write_tiff_mimage("random_out.tiff", rnd_mimg);
	
	col_num = count_numbers_of_colors_sparse(rnd_mimg);

/*	mimgs = split_sparse_mimage(src_mimg, &retNumber, NULL, NULL);	/* alternative test */
	mimgs = split_sparse_mimage(rnd_mimg, &retNumber, NULL, NULL);
	CHECK_POINTER(mimgs);

	for (i=0; i<retNumber; i++) {
		char fileName[80];
		mimage_ptr mimg = mimgs[i];
		
		sprintf(fileName, "split_sparse_res_%2d.tiff", i);
		write_tiff_mimage(fileName, mimg);

		destroy_mimage(mimg);
	}

	SMART_FREE(mimgs);
	destroy_mimage(rnd_mimg);
	destroy_mimage(src_mimg);
}

static void testm45s()
{
	int n;
	mimage_ptr src_mimg_1, src_mimg_2, target_mimg;
	
	src_mimg_1 = get_sparse_n_plane_mimage("4.tiff", 1);
	CHECK_POINTER(src_mimg_1);

	src_mimg_2 = get_sparse_n_plane_mimage("4.tiff", 2);
	CHECK_POINTER(src_mimg_2);

	target_mimg = superpose_smimage(src_mimg_1, src_mimg_2);
	CHECK_POINTER(target_mimg);

	/*	write_tiff_mimage("4_1_2.tiff", target_mimg);	*/ /* verified is ok */

	n = count_numbers_of_colors_sparse(target_mimg);
	printf("Number of colours is %d\n", n);
	
	destroy_mimage(target_mimg);
	destroy_mimage(src_mimg_1);
	destroy_mimage(src_mimg_2);
}

static void testm44s() 
{
	int err;
	mimage_ptr res_mimg, src_mimg, random_mimg;
	
	src_mimg = get_sparse_n_plane_mimage("4.tiff", 2);
	CHECK_POINTER(src_mimg);

	random_mimg = random_mimage(src_mimg, 0., 255.);

	write_tiff_mimage("44_sparse_random.tiff", random_mimg);

	res_mimg = lex_sort_mimage(random_mimg);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage("lex_sorted_4.tiff", res_mimg);
	CHECK_ERROR(err);
	
	destroy_mimage(random_mimg);
	destroy_mimage(src_mimg);
	destroy_mimage(res_mimg);
}

static void testm44d() 
{
	int err;
	mimage_ptr res_mimg, src_mimg;
	
	src_mimg = read_tiff_mimage("4.tiff");
	CHECK_POINTER(src_mimg);

	res_mimg = lex_sort_mimage(src_mimg);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage("lex_sorted_4.tiff", res_mimg);
	CHECK_ERROR(err);
	
	destroy_mimage(src_mimg);
	destroy_mimage(res_mimg);
}

void testm43()
{
	int err;
	mimage_ptr res_mimg, mask_mimg, src_mimg;
	mpixel values_array[] = { 255., 255., 0. };
	
	src_mimg = read_jpeg_mimage("3.jpeg");
	CHECK_POINTER(src_mimg);

	mask_mimg = ellipse_mimage_sparse(121, 41, 15, RGB_CHANNELS, DISCRETE_IMAGE, values_array);
	CHECK_POINTER(mask_mimg);

	res_mimg = mask_dense_using_sparse(src_mimg, mask_mimg);
	CHECK_POINTER(res_mimg);

	err = write_jpeg_mimage("masked.jpeg", res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(src_mimg);	
	destroy_mimage(mask_mimg);
	destroy_mimage(res_mimg);
}


void testm36s_4()
{
	int err;
	
	mimage_ptr mimg_1, mimg_2;

#ifdef SMALL_TEST_36
	mimg_1 = get_sparse_n_plane_mimage("jack_dense.tiff", 0);
	CHECK_POINTER(mimg_1);
	mimg_2 = get_sparse_n_plane_mimage("jack_dense.tiff", 1);
	CHECK_POINTER(mimg_2);
#else
	mimg_1 = get_sparse_n_plane_mimage("dense_jack.tiff", 0);
	CHECK_POINTER(mimg_1);
	mimg_2 = get_sparse_n_plane_mimage("dense_jack.tiff", 1);
	CHECK_POINTER(mimg_2);
#endif

	err = convert_mimage_to_float(mimg_1);
	CHECK_ERROR(err);
	err = convert_mimage_to_float(mimg_2);
	CHECK_ERROR(err);

	write_tiff_mimage("level0.tiff",mimg_1);
	write_tiff_mimage("level1.tiff",mimg_2);
	
	superpose_and_write(mimg_2, mimg_1, "jack1over2.tiff");
	superpose_and_write(mimg_1, mimg_2, "jack2over1.tiff");
	
 	destroy_mimage(mimg_1); destroy_mimage(mimg_2);
}

void testm36s_tris()
{
	int err;
	
	mimage_ptr mimg_1, mimg_2;

	mimg_1 = get_sparse_n_plane_mimage("box1.tiff", 1);
	CHECK_POINTER(mimg_1);
	mimg_2 = get_sparse_n_plane_mimage("box2.tiff", 1);
	CHECK_POINTER(mimg_2);

	write_tiff_mimage("box2_saved.tiff", mimg_2);

	superpose_and_write(mimg_1, mimg_2, "box2over1.tiff");
	superpose_and_write(mimg_2, mimg_1, "box1over2.tiff");
	
 	destroy_mimage(mimg_1); destroy_mimage(mimg_2);
}

void testm36s_bis()
{
	int err;
	
	mimage_ptr mimg_1, mimg_2, mimg_3, mimg_4, mimg_5, mimg_6, mimg_7;
	mimage_ptr mimg_8, mimg_9, mimg_10, mimg_11, mimg_12, mimg_13, mimg_14;
/*
 */
	mimage_ptr mimg_1_new, mimg_2_new, mimg_3_new, mimg_4_new, mimg_5_new, mimg_6_new, mimg_7_new;
	mimage_ptr mimg_8_new, mimg_9_new, mimg_10_new, mimg_11_new, mimg_12_new, mimg_13_new, mimg_14_new;
	
	mimg_1 = create_test_mimage("superpose_test_01a.tiff", "superpose_test_01b.tiff", "superpose_result_01.tiff");
	mimg_2 = create_test_mimage("superpose_test_02a.tiff", "superpose_test_02b.tiff", "superpose_result_02.tiff");
	superpose_and_write(mimg_1, mimg_2, "superpose_result_01/02.tiff");
	
	mimg_3 = create_test_mimage("superpose_test_03a.tiff", "superpose_test_03b.tiff", "superpose_result_03.tiff");
	mimg_4 = create_test_mimage("superpose_test_04a.tiff", "superpose_test_04b.tiff", "superpose_result_04.tiff");
	superpose_and_write(mimg_3, mimg_4, "superpose_result_03/04.tiff");

	mimg_5 = create_test_mimage("superpose_test_05a.tiff", "superpose_test_05b.tiff", "superpose_result_05.tiff");
	mimg_6 = create_test_mimage("superpose_test_06a.tiff", "superpose_test_06b.tiff", "superpose_result_06.tiff");
	superpose_and_write(mimg_5, mimg_6, "superpose_result_05/06.tiff");

	mimg_7 = create_test_mimage("superpose_test_07a.tiff", "superpose_test_07b.tiff", "superpose_result_07.tiff");
	mimg_8 = create_test_mimage("superpose_test_08a.tiff", "superpose_test_08b.tiff", "superpose_result_08.tiff");
	superpose_and_write(mimg_7, mimg_8, "superpose_result_07/08.tiff");

	mimg_9 = create_test_mimage("superpose_test_09a.tiff", "superpose_test_09b.tiff", "superpose_result_09.tiff");
	mimg_10 = create_test_mimage("superpose_test_10a.tiff", "superpose_test_10b.tiff", "superpose_result_10.tiff");
	superpose_and_write(mimg_9, mimg_10, "superpose_result_09/10.tiff");

	mimg_11 = create_test_mimage("superpose_test_11a.tiff", "superpose_test_11b.tiff", "superpose_result_11.tiff");
	mimg_12 = create_test_mimage("superpose_test_12a.tiff", "superpose_test_12b.tiff", "superpose_result_12.tiff");
	superpose_and_write(mimg_11, mimg_12, "superpose_result_11/12.tiff");

	mimg_13 = create_test_mimage("superpose_test_13a.tiff", "superpose_test_13b.tiff", "superpose_result_13.tiff");
	mimg_14 = create_test_mimage("superpose_test_14a.tiff", "superpose_test_14b.tiff", "superpose_result_14.tiff");
	superpose_and_write(mimg_13, mimg_14, "superpose_result_13/14.tiff");
/*
 */
	mimg_1_new = create_test_mimage("superpose_test_01a_new.tiff", "superpose_test_01b_new.tiff", "superpose_result_01_new.tiff");
	mimg_2_new = create_test_mimage("superpose_test_02a_new.tiff", "superpose_test_02b_new.tiff", "superpose_result_02_new.tiff");
	superpose_and_write(mimg_1_new, mimg_2_new, "superpose_result_01/02_new.tiff");
	
	mimg_3_new = create_test_mimage("superpose_test_03a_new.tiff", "superpose_test_03b_new.tiff", "superpose_result_03_new.tiff");
	mimg_4_new = create_test_mimage("superpose_test_04a_new.tiff", "superpose_test_04b_new.tiff", "superpose_result_04_new.tiff");
	superpose_and_write(mimg_3_new, mimg_4_new, "superpose_result_03/04_new.tiff");

	mimg_5_new = create_test_mimage("superpose_test_05a_new.tiff", "superpose_test_05b_new.tiff", "superpose_result_05_new.tiff");
	mimg_6_new = create_test_mimage("superpose_test_06a_new.tiff", "superpose_test_06b_new.tiff", "superpose_result_06_new.tiff");
	superpose_and_write(mimg_5_new, mimg_6_new, "superpose_result_05/06_new.tiff");

	mimg_7_new = create_test_mimage("superpose_test_07a_new.tiff", "superpose_test_07b_new.tiff", "superpose_result_07_new.tiff");
	mimg_8_new = create_test_mimage("superpose_test_08a_new.tiff", "superpose_test_08b_new.tiff", "superpose_result_08_new.tiff");
	superpose_and_write(mimg_7_new, mimg_8_new, "superpose_result_07/08_new.tiff");

	mimg_9_new = create_test_mimage("superpose_test_09a_new.tiff", "superpose_test_09b_new.tiff", "superpose_result_09_new.tiff");
	mimg_10_new = create_test_mimage("superpose_test_10a_new.tiff", "superpose_test_10b_new.tiff", "superpose_result_10_new.tiff");
	superpose_and_write(mimg_9_new, mimg_10_new, "superpose_result_09/10_new.tiff");

	mimg_11_new = create_test_mimage("superpose_test_11a_new.tiff", "superpose_test_11b_new.tiff", "superpose_result_11_new.tiff");
	mimg_12_new = create_test_mimage("superpose_test_12a_new.tiff", "superpose_test_12b_new.tiff", "superpose_result_12_new.tiff");
	superpose_and_write(mimg_11_new, mimg_12_new, "superpose_result_11/12_new.tiff");

	mimg_13_new = create_test_mimage("superpose_test_13a_new.tiff", "superpose_test_13b_new.tiff", "superpose_result_13_new.tiff");
	mimg_14_new = create_test_mimage("superpose_test_14a_new.tiff", "superpose_test_14b_new.tiff", "superpose_result_14_new.tiff");
	superpose_and_write(mimg_13_new, mimg_14_new, "superpose_result_13/14_new.tiff");
/*
 */
 	destroy_mimage(mimg_1); destroy_mimage(mimg_2); destroy_mimage(mimg_3); destroy_mimage(mimg_4); 
	destroy_mimage(mimg_5); destroy_mimage(mimg_6); destroy_mimage(mimg_7); destroy_mimage(mimg_8); 
	destroy_mimage(mimg_9); destroy_mimage(mimg_10); destroy_mimage(mimg_11); destroy_mimage(mimg_12); 
	destroy_mimage(mimg_13); destroy_mimage(mimg_14); 
/*
 */
 	destroy_mimage(mimg_1_new); destroy_mimage(mimg_2_new); destroy_mimage(mimg_3_new); destroy_mimage(mimg_4_new); 
	destroy_mimage(mimg_5_new); destroy_mimage(mimg_6_new); destroy_mimage(mimg_7_new); destroy_mimage(mimg_8_new); 
	destroy_mimage(mimg_9_new); destroy_mimage(mimg_10_new); destroy_mimage(mimg_11_new); destroy_mimage(mimg_12_new); 
	destroy_mimage(mimg_13_new); destroy_mimage(mimg_14_new); 
}

void testm42()
{
	int err;
	mimage_ptr mimg, res_mimg;
	image_rect rect = {10, 10, 30, 30};

	int i_offset[] = {0,0,0,0,0};
	int j_offset[] = {-2,-1,0,1,2};
	float coeff[] = {1.,1.,1.,1.,1.};

	mimg = read_tiff_mimage("white_dot.tiff");
	CHECK_POINTER(mimg);

	res_mimg = minvolve_mimage(mimg, i_offset, j_offset, coeff, 5);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage("minvolve_output.tiff", res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);
}

void testm3s(char *fname, char *ofname)
{
	int c, no;
	int err;
	mimage_ptr mimg, *mimgs, temp_mimg;
/*	image_rect rect = {0, 2, 3, 3};	*/		/* rect inside the image */
	image_rect rect = {0, 0, 14, 4};		/* rect inside the image */
/*	image_rect rect = {10, 10, 20, 20};	*/	/* rect inside the image */

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	temp_mimg = mimgs[1];	/* get the white plane */

	err = write_jpeg_mimage("verify.jpeg", temp_mimg);
	CHECK_ERROR(err);

	err = crop_mimage_sparse(temp_mimg, &rect);
	CHECK_ERROR(err);

	err = write_jpeg_mimage(ofname, temp_mimg);
	CHECK_ERROR(err);

	return; 	/* la parte dopo da qualche problema perche' dealloca memoria gia' liberata in questo esempio
				 * questo e' dovuto alla conversione a dense nel jpeg che fa uso della funzione clone */
				
	for (c=0; c<no; c++)
		destroy_mimage(mimgs[c]);

	destroy_mimage(mimg);
	SMART_FREE(mimgs);
}

void testm41s(char *fname) {
	int c, no;
	int err;
	mimage_ptr mimg, *mimgs;
	gr_image_displacement d;
	
	d.x = 25;
	d.y = 35;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);
	
	err = offset_mimage_sparse(mimgs[1], &d);
	CHECK_ERROR(err);

	err = write_tiff_mimage("offset_sparse.tiff", mimgs[1]);
	CHECK_ERROR(err);

	for (c=0; c<no; c++)
		destroy_mimage(mimgs[c]);
		
	destroy_mimage(mimg);
	SMART_FREE(mimgs);
}

void testm40s(char *fname)
{
	int c, no;
	int err;
	mimage_ptr mimg, *mimgs;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);
	
	err = invert_mimage(mimgs[1]);	/* invert the second channel */
	CHECK_ERROR(err);

	err = write_tiff_mimage("inverted_sparse.tiff", mimgs[1]);
	CHECK_ERROR(err);

	for (c=0; c<no; c++)
		destroy_mimage(mimgs[c]);
		
	destroy_mimage(mimg);
	SMART_FREE(mimgs);
}

void testm40d(char *fname)
{
	int err;
	mimage_ptr mimg;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	err = invert_mimage(mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("inverted.tiff", mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
}

void testm39s()
{
	int err;
	mimage_ptr res_mimg;
	mpixel values_array[] = { 255., 255., 0. };
	
	res_mimg = ellipse_mimage_sparse(121, 41, 3, RGB_CHANNELS, DISCRETE_IMAGE, values_array);
	CHECK_POINTER(res_mimg);

	err = write_jpeg_mimage("ellipse.jpeg", res_mimg);
	CHECK_ERROR(err);
	
	destroy_mimage(res_mimg);
}

void testm38s()
{
	int err;
	mimage_ptr res_mimg;
	mpixel values_array[] = { 125., 0., 0. };
	
	res_mimg = rectangle_mimage_sparse(100, 100, 10, RGB_CHANNELS, DISCRETE_IMAGE, values_array);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage("rectangle.tiff", res_mimg);
	CHECK_ERROR(err);
	
	destroy_mimage(res_mimg);
}

void testm37s(char *fname)
{
	int c, no;
	int err;
	mimage_ptr mimg, res_mimg, *mimgs;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	res_mimg = random_mimage(mimgs[1], 10., 250.);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage("random_sparse.tiff", res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);

	for (c=0; c<no; c++)
		destroy_mimage(mimgs[c]);

	SMART_FREE(mimgs);
}

void testm37d(char *fname)
{
	int err;
	mimage_ptr mimg, res_mimg;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg)
	
	res_mimg = random_mimage(mimg, 10., 250.);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage("random_dense.tiff", res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);
}

void testm35s(char *fname)
{
	char buffer[256];

	int j, no, err;
	int height, width, comp;
	mimage_ptr mimg, *mimgs, res_mimg;
	float fvalues[] = {0., 96., 192};
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg)
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	destroy_mimage(mimg);

	for (j=0; j<no; j++)
	{
		printf("Analyze j = %d\n", j);
		mimg = mimgs[j];

		get_mimage_info(mimg, &height, &width, &comp, NULL, NULL);

		res_mimg = threshold_mimage_sparse(mimg, fvalues, 3);
		CHECK_POINTER(res_mimg);

		sprintf(buffer, "sparse_thresholded_%d", j);
		err = write_tiff_mimage(buffer, res_mimg);
		CHECK_ERROR(err);
		
		destroy_mimage(res_mimg);

		destroy_mimage(mimg);
	}
	
	SMART_FREE(mimgs);
}

void testm34s(char *fname)
{
	int j;
	int no;
	double *sums;
	mimage_ptr mimg, *mimgs;
	int height, width, comp;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	destroy_mimage(mimg);

	for (j=0; j<no; j++)
	{
		printf("Analyze j = %d\n", j);
		mimg = mimgs[j];

		get_mimage_info(mimg, &height, &width, &comp, NULL, NULL);

		sums = sumall_mimage_sparse(mimg, 3);

		printf("sums = %2.2f:%2.2f\n", sums[0], sums[1], sums[2]);
 
 		SMART_FREE(sums);
		destroy_mimage(mimg);
	}
	
	SMART_FREE(mimgs);
}

void testm33s(char *fname)
{
	int j;
	int no;
	size_t *histo;
	mimage_ptr mimg, *mimgs;
	int height, width, comp;
	float fvalues[] = {0., 128.};
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	destroy_mimage(mimg);

	for (j=0; j<no; j++)
	{
		printf("Analyze j = %d\n", j);
		mimg = mimgs[j];

		get_mimage_info(mimg, &height, &width, &comp, NULL, NULL);

		histo = histogram_mimage_sparse(mimg, fvalues, 2);

		printf("histo = <%3u>:%2.2f:<%3u>:%2.2f:<%3u>\n", histo[0], fvalues[0], histo[1], fvalues[1], histo[2]);
 
 		SMART_FREE(histo);
		destroy_mimage(mimg);
	}
	
	SMART_FREE(mimgs);
}

void testm32s(char *fname)
{
	int j;
	int no;
	float minimum, maximum;
	mimage_ptr mimg, *mimgs;
	int height, width, comp;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	destroy_mimage(mimg);

	for (j=0; j<no; j++)
	{
		printf("Analyze j = %d\n", j);
		mimg = mimgs[j];

		get_mimage_info(mimg, &height, &width, &comp, NULL, NULL);
				
		minimum = minof_mimage_sparse(mimg);
		maximum = maxof_mimage_sparse(mimg);

		printf("max = %f - min = %f\n", maximum, minimum);
 
		destroy_mimage(mimg);
	}
	
	SMART_FREE(mimgs);
}

void testm31s(char *fname)
{
	int i, j;
	int no, el_no;
	mimage_ptr mimg, *mimgs;
	int height, width, comp;
	mpixel_ptr pixel_array;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	destroy_mimage(mimg);

	for (j=0; j<no; j++)
	{
		printf("Analyze j = %d\n", j);
		mimg = mimgs[j];

		get_mimage_info(mimg, &height, &width, &comp, NULL, NULL);
				
		pixel_array = sort_mimage_sparse(mimg, &el_no);

		for (i=0;i<el_no;i++)
			printf("\tpixel_array[%d] = %d\n",i,pixel_array[i]);

		SMART_FREE(pixel_array);

/*
		{
			char buffer[256];
			sprintf(buffer, "mimage_%d", j);
			write_tiff_mimage(buffer, mimg);
		}
 */
 
		destroy_mimage(mimg);
	}
	
	
	SMART_FREE(mimgs);
}

void testm30s_bis(char *fname)
{
	int no;
	mimage_ptr mimg, *mimgs;
	int x, y, n;
	int height, width, comp;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	get_mimage_info(mimg, NULL, NULL, &comp, NULL, NULL);

	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	destroy_mimage(mimg);

	for (n=0;n<no;n++)
	{
		mimg = mimgs[n];

		get_mimage_info(mimg, &height, &width, NULL, NULL, NULL);
		
		for (y=0;y<height;y++)
		{
			for (x=0;x<width;x++)
			{
				int found;
				int row_idx, sect_idx, offset, position_in_buffer, previous_reached_line;
			
				found = locate_pixel_mimage_sparse(mimg, x, y, &row_idx, &sect_idx, &offset, &position_in_buffer, &previous_reached_line);
				if (found)
					printf("[%3d %3d %3d %3d %3d]",row_idx, sect_idx, offset, position_in_buffer, previous_reached_line);
				else
					printf("{%3d %3d %3d %3d %3d}",row_idx, sect_idx, offset, position_in_buffer, previous_reached_line);
			}
			printf("\n");
		}
		
		{
			char buffer[256];
			sprintf(buffer, "!!!mimage_%d", n);
			write_tiff_mimage(buffer, mimg);
		}

		destroy_mimage(mimgs[n]);
		
		printf("----------------------------------------------------------------\n");
	}

	SMART_FREE(mimgs);
}

void testm30s(char *fname)
{
	int no;
	mimage_ptr mimg, *mimgs;
	int x, y, c, n;
	int height, width, comp;
	mpixel_ptr pixel_array;
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	get_mimage_info(mimg, NULL, NULL, &comp, NULL, NULL);

	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	destroy_mimage(mimg);

	for (n=0;n<no;n++)
	{
		mimg = mimgs[n];

		get_mimage_info(mimg, &height, &width, NULL, NULL, NULL);
		
		for (y=0;y<height;y++)
		{
			for (x=0;x<width;x++)
			{
				printf("[");
				pixel_array = get_pixel_mimage_sparse(mimg, x, y);
				if (pixel_array)
					for (c=0;c<comp;c++)
						printf(" %3d",pixel_array[c]);
				else
					for (c=0;c<comp;c++)
						printf(" ---");

				printf(" ]");
				SMART_FREE(pixel_array);
			}
			printf("\n");
		}
		
		{
			char buffer[256];
			sprintf(buffer, "!!!mimage_%d", n);
			write_tiff_mimage(buffer, mimg);
		}

		destroy_mimage(mimgs[n]);
		
		printf("----------------------------------------------------------------\n");
	}

	SMART_FREE(mimgs);
}

void testmf29(char *fname1, char *fname2, char *ofname)
{
	float float_array[] = {255., 255., 255.};
	int err;
	mimage_ptr mimg1, mimg2, res_mimg;
	mimage_ptr sparse1;

	mimg1 = read_tiff_mimage(fname1);
	CHECK_POINTER(mimg1);
	mimg2 = read_tiff_mimage(fname2);
	CHECK_POINTER(mimg2);

	err = convert_mimage_to_float(mimg1);
	CHECK_ERROR(err);

	err = convert_mimage_to_float(mimg2);
	CHECK_ERROR(err);

	sparse1 = get_level_dense_mimage(mimg1, float_array);
	CHECK_POINTER(sparse1);

	destroy_mimage(mimg1);

	res_mimg = binary_op_mimage(sparse1, mimg2,  plus_op, fplus_op);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(sparse1);
	destroy_mimage(mimg2);
	destroy_mimage(res_mimg);
}

void testm29(char *fname1, char *fname2, char *ofname)
{
	float float_array[] = {255., 255., 255.};
	int err;
	mimage_ptr mimg1, mimg2, res_mimg;
	mimage_ptr sparse1;

	mimg1 = read_tiff_mimage(fname1);
	CHECK_POINTER(mimg1);
	mimg2 = read_tiff_mimage(fname2);
	CHECK_POINTER(mimg2);

	sparse1 = get_level_dense_mimage(mimg1, float_array);
	CHECK_POINTER(sparse1);

	destroy_mimage(mimg1);

#ifdef VERIFY_DENSE_IMAGE
	to_dense_mimage(&sparse1);
	CHECK_POINTER(sparse1);

	err = write_tiff_mimage("verify.tiff", sparse1);
	CHECK_ERROR(err);

	destroy_mimage(mimg1);
	
	return;
#endif

	res_mimg = binary_op_mimage(sparse1, mimg2,  plus_op, fplus_op);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(sparse1);
	destroy_mimage(mimg2);
	destroy_mimage(res_mimg);
}

void test_flip_and_rotate_stress(char *fname, char *ofname)
{
	int i, counter = 0;
	int err;
	mimage_ptr mimg, res_mimg;

	res_mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	for (i=0; i<400; i++, counter++) {
		mimg = res_mimg;
		res_mimg = rotate_halfpi(mimg, i);
		CHECK_POINTER(res_mimg);
		destroy_mimage(mimg);
	}
	for (i=0; i<100; i++, counter++) {
		mimg = res_mimg;
		res_mimg = flip_h(mimg);	
		CHECK_POINTER(res_mimg);
		destroy_mimage(mimg);
	}

	for (i=0; i<100; i++, counter++) {
		mimg = res_mimg;
		res_mimg = flip_v(mimg);
		CHECK_POINTER(res_mimg);
		destroy_mimage(mimg);
	}

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(res_mimg);
}

void testm28_90(char *fname, char *ofname)
{
	int err;
	mimage_ptr mimg, res_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	res_mimg = rotate_halfpi(mimg, 1);	/* makes a rotation of 1/2 pi (90 degrees) */
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);
}

void testm28_180(char *fname, char *ofname)
{
	int err;
	mimage_ptr mimg, res_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	res_mimg = rotate_halfpi(mimg, 2);	/* makes a rotation of 1/2 pi (180 degrees) */
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);
}

void testm28_270(char *fname, char *ofname)
{
	int err;
	mimage_ptr mimg, res_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	res_mimg = rotate_halfpi(mimg, 3);	/* makes a rotation of 3/2 pi (270 degrees) */
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);
}

void testm27s(char *fname, char *ofname)
{
	float float_array[] = {255., 255., 255.};
	int err;
	mimage_ptr mimg, res_mimg, sparse;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	sparse = get_level_dense_mimage(mimg, float_array);
	CHECK_POINTER(sparse);

	res_mimg = flip_v(sparse);
	CHECK_POINTER(res_mimg);

	to_dense_mimage(&res_mimg);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(sparse);
	destroy_mimage(res_mimg);
}

void testm27(char *fname, char *ofname)
{
	int err;
	mimage_ptr mimg, res_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	res_mimg = flip_v(mimg);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);
}

void testm26f(char *fname, char *ofname)
{
	float float_array[] = {255., 255., 255.};
	int err;
	mimage_ptr mimg, res_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	err = convert_mimage_to_float(mimg);
	CHECK_ERROR(err);

	res_mimg = flip_h(mimg);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);
}

void testm26s(char *fname, char *ofname)
{
	float float_array[] = {255., 255., 255.};
	int err;
	mimage_ptr mimg, res_mimg, sparse;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	sparse = get_level_dense_mimage(mimg, float_array);
	CHECK_POINTER(sparse);

	res_mimg = flip_h(sparse);
	CHECK_POINTER(res_mimg);

	to_dense_mimage(&res_mimg);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(sparse);
	destroy_mimage(res_mimg);
}

void testm26(char *fname, char *ofname)
{
	int err;
	mimage_ptr mimg, res_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	res_mimg = flip_h(mimg);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(ofname, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(res_mimg);
}

void testm25(char *fname1, char*fname2, char *ofname)
{
	int err;
	float float_array[] = {255., 255., 255.};

	mimage_ptr mimg1, mimg2;
	mimage_ptr result_mimg;
	mimage_ptr sparse1, sparse2;

	mimg1 = read_tiff_mimage(fname1);
	CHECK_POINTER(mimg1);
	mimg2 = read_tiff_mimage(fname2);
	CHECK_POINTER(mimg2);

	sparse1 = get_level_dense_mimage(mimg1, float_array);
	CHECK_POINTER(sparse1);
	sparse2 = get_level_dense_mimage(mimg2, float_array);
	CHECK_POINTER(sparse2);

	result_mimg = binary_op_mimage(sparse1, sparse2, plus_op, fplus_op);
	CHECK_POINTER(result_mimg);

	err = to_dense_mimage(&result_mimg);
	CHECK_POINTER(result_mimg);
	CHECK_ERROR(err);
	
	err = write_tiff_mimage(ofname, result_mimg);
	CHECK_ERROR(err);
	
#ifdef PARANOIC

	err = to_dense_mimage(&sparse1);
	CHECK_POINTER(sparse1);
	CHECK_ERROR(err);
	err = to_dense_mimage(&sparse2);
	CHECK_POINTER(sparse2);
	CHECK_ERROR(err);

	err = write_tiff_mimage("a", sparse1);
	CHECK_ERROR(err);
	err = write_tiff_mimage("b", sparse2);
	CHECK_ERROR(err);

#endif

	destroy_mimage(mimg1);
	destroy_mimage(mimg2);

	destroy_mimage(sparse1);
	destroy_mimage(sparse2);
	
	destroy_mimage(result_mimg);
}

void testm24f(char *fname)
{
	int err;
	int number;
	int i;
	int *pixels_pop;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {15., 15., 15.};

	mimage_ptr mimg;
	mimage_ptr *result_mimgs;

	char result_name[256];
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	err = convert_mimage_to_float(mimg);
	CHECK_ERROR(err);
	
	result_mimgs = split_dense_mimage(mimg, &number, NULL, &pixels_pop);
	CHECK_POINTER(result_mimgs);

	if (number>0) {

		for (i=0;i<number;i++) 
			printf("Population for image #%d = %d\n", i, pixels_pop[i]);

		for (i=0;i<number;i++) {
			err = to_dense_mimage(&result_mimgs[i]);
			CHECK_POINTER(result_mimgs[i]);
			CHECK_ERROR(err);

			sprintf(result_name, "dense_%d.tiff", i);
			
			err = write_tiff_mimage(result_name,result_mimgs[i]);
			CHECK_ERROR(err);

			destroy_mimage(result_mimgs[i]);
		}
	}
	
	SMART_FREE(result_mimgs);
	SMART_FREE(pixels_pop);
	
	destroy_mimage(mimg);
}

void testm24(char *fname)
{
	int err;
	int number;
	int i;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {15., 15., 15.};

	mimage_ptr mimg;
	mimage_ptr *result_mimgs;
	int *pixels_pop;
	long total_pop = 0;
	
	char result_name[256];
	
	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	result_mimgs = split_dense_mimage(mimg, &number, NULL, &pixels_pop);
	CHECK_POINTER(result_mimgs);

	if (number>0) {

		for (i=0;i<number;i++) {
			printf("Population for image #%d = %d\n", i, pixels_pop[i]);
			total_pop += pixels_pop[i];
		}
		printf("  Total population: %d\n", total_pop);
		
		for (i=0;i<number;i++) {
/*
			err = to_dense_mimage(&result_mimgs[i]);
			CHECK_POINTER(result_mimgs[i]);
			CHECK_ERROR(err);
 */
			sprintf(result_name, "dense_%d.tiff", i);
			
			err = write_tiff_mimage(result_name,result_mimgs[i]);
			CHECK_ERROR(err);

			destroy_mimage(result_mimgs[i]);
		}
	}
	
	SMART_FREE(result_mimgs);
	SMART_FREE(pixels_pop);
	
	destroy_mimage(mimg);
}

void testfm23(char *fname)
{
	int err;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {15., 15., 15.};
	image_rect rect;

	mimage_ptr mimg, result_mimg, old_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	result_mimg = get_near_dense_mimage(mimg, float_array, float_darray);
	CHECK_POINTER(result_mimg);
	
	err = convert_smimage_to_float(result_mimg);
	CHECK_ERROR(err);

	result_mimg = shrink_and_cut_mimage(old_mimg = result_mimg, &rect);
	CHECK_POINTER(result_mimg);
	
	printf("x: %d - y: %d - dx: %d - dy: %d\n", rect.x, rect.y, rect.dx, rect.dy);

	err = to_dense_mimage(&result_mimg);
	CHECK_POINTER(result_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_again.tiff", result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(old_mimg);
	destroy_mimage(result_mimg);
}

void testdm23(char *fname)
{
	int err;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {15., 15., 15.};
	image_rect rect;

	mimage_ptr mimg, result_mimg, old_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);
	
	result_mimg = get_near_dense_mimage(mimg, float_array, float_darray);
	CHECK_POINTER(result_mimg);
	
	result_mimg = shrink_and_cut_mimage(old_mimg = result_mimg, &rect);
	CHECK_POINTER(result_mimg);

	printf("x: %d - y: %d - dx: %d - dy: %d\n", rect.x, rect.y, rect.dx, rect.dy);

	err = to_dense_mimage(&result_mimg);
	CHECK_POINTER(result_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_again.tiff", result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(old_mimg);
	destroy_mimage(result_mimg);
}

void testm22(char *fname)
{
	int err;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {15., 15., 15.};

	mimage_ptr mimg, result_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	result_mimg = get_near_dense_mimage(mimg, float_array, float_darray);
	CHECK_POINTER(result_mimg);
	
	err = convert_smimage_to_float(result_mimg);
	CHECK_ERROR(err);

	err = convert_smimage_to_discrete(result_mimg);
	CHECK_ERROR(err);

	err = to_dense_mimage(&result_mimg);
	CHECK_POINTER(result_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_again.tiff", result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(result_mimg);
}

void testdm21()
{
	int err;
	mpixel array[] = {0xff, 0x00, 0x00};
	image_dimension dim = {120, 120};
	mimage_ptr op_mimg;

	op_mimg = const_smimage(array, &dim, DISCRETE_IMAGE, 3);
	CHECK_POINTER(op_mimg);

	err = to_dense_mimage(&op_mimg);
	CHECK_POINTER(op_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_op.tiff", op_mimg);
	CHECK_ERROR(err);

	destroy_mimage(op_mimg);
}

void testfm21()
{
	int err;
	float array[] = {255., 0., 0.};
	image_dimension dim = {120, 120};
	mimage_ptr op_mimg;

	op_mimg = const_smimage(array, &dim, FLOAT_IMAGE, 3);
	CHECK_POINTER(op_mimg);

	err = to_dense_mimage(&op_mimg);
	CHECK_POINTER(op_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_op.tiff", op_mimg);
	CHECK_ERROR(err);

	destroy_mimage(op_mimg);
}

void testm20(char *fname)
{
	int err;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {10., 10., 10.};
	unsigned char v_array[] = {1, 0, 0};
	
	mimage_ptr mimg, result_mimg, op_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	result_mimg = get_near_dense_mimage(mimg, float_array, float_darray);
	CHECK_POINTER(result_mimg);

	op_mimg = clone_mimage_sparse(result_mimg);
	CHECK_POINTER(op_mimg);

	err = to_dense_mimage(&op_mimg);
	CHECK_POINTER(op_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_op.tiff", op_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(op_mimg);
	destroy_mimage(result_mimg);
}

void testm19(char *fname)
{
	int err;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {10., 10., 10.};
	unsigned char v_array[] = {1, 0, 0};
	
	mimage_ptr mimg, result_mimg, op_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	result_mimg = get_near_dense_mimage(mimg, float_array, float_darray);
	CHECK_POINTER(result_mimg);

	op_mimg = binary_op_constant_smimage(result_mimg, v_array, times_op, ftimes_op);
	CHECK_POINTER(op_mimg);

	err = to_dense_mimage(&op_mimg);
	CHECK_POINTER(op_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_op.tiff", op_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(op_mimg);
	destroy_mimage(result_mimg);
}

void testmf18(char *fname)
{
	int err;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {15., 15., 15.};

	mimage_ptr mimg, result_mimg;

	mimg = read_tiff_mimage(fname);

	err = convert_mimage_to_float(mimg);
	CHECK_ERROR(err);

	result_mimg = get_near_dense_mimage(mimg, float_array, float_darray);
	CHECK_POINTER(result_mimg);

	err = to_dense_mimage(&result_mimg);
	CHECK_POINTER(result_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_again.tiff", result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(result_mimg);
}

void testm18(char *fname)
{
	int err;
	float float_array[] = {255., 255., 255.};
	float float_darray[] = {15., 15., 15.};

	mimage_ptr mimg, result_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	result_mimg = get_near_dense_mimage(mimg, float_array, float_darray);
	CHECK_POINTER(result_mimg);

	err = to_dense_mimage(&result_mimg);
	CHECK_POINTER(result_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_again.tiff", result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(result_mimg);
}

void testm17(char *fname)
{
	int err;
	float float_array[] = {255., 255., 255.};

	mimage_ptr mimg, result_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	result_mimg = get_level_dense_mimage(mimg, float_array);
	CHECK_POINTER(result_mimg);

	err = to_dense_mimage(&result_mimg);
	CHECK_POINTER(result_mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("dense_again.tiff", result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(result_mimg);
}

void testm16(char *fname)
{
	int err;
	mimage_ptr mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	err = to_sparse_mimage(&mimg);
	CHECK_POINTER(mimg);
	CHECK_ERROR(err);

	err = to_dense_mimage(&mimg);
	CHECK_POINTER(mimg);
	CHECK_ERROR(err);

	err = write_tiff_mimage("sparse_result.tiff", mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
}

void testm15(char *fname, char *ofname)
{
	int err;
	mimage_ptr mimg, result_mimg;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

//	convert_mimage_to_float(mimg);
//	CHECK_POINTER(mimg);

	result_mimg = anaglyph_mimage(mimg, .05, .5);
	CHECK_POINTER(result_mimg);

	err = write_tiff_mimage(ofname, result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(result_mimg);
}

void testmd14()
{
	float f_array[] = {50.};
	int err;
	mimage_ptr mimg, connected_mimg, result_mimg;

	mimg = read_tiff_mimage("spiral.tiff");
	CHECK_POINTER(mimg);

	connected_mimg = connected_components_mimage(mimg);
	CHECK_POINTER(connected_mimg);
	
	result_mimg = times_mimage_constant(connected_mimg, f_array);
	CHECK_POINTER(result_mimg);

	err = write_tiff_mimage("tiff.tiff", result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(connected_mimg);
	destroy_mimage(result_mimg);
}

void testmf14()
{
	float f_array[] = {50.};
	int err;
	mimage_ptr mimg, connected_mimg, result_mimg;

	mimg = read_tiff_mimage("spiral.tiff");
	CHECK_POINTER(mimg);

	err = convert_mimage_to_float(mimg);
	CHECK_ERROR(err);

	connected_mimg = connected_components_mimage(mimg);
	CHECK_POINTER(connected_mimg);
	
	result_mimg = times_mimage_constant(connected_mimg, f_array);
	CHECK_POINTER(result_mimg);

	err = write_tiff_mimage("tiff.tiff", result_mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(connected_mimg);
	destroy_mimage(result_mimg);
}

void testm13(char *fname, char *ofname) 
{
	int err;
	mimage_ptr mimg;

	char *str;
	size_t str_length;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	err = mimage_2_string_format(mimg, &str, &str_length);
	CHECK_ERROR(err);

	destroy_mimage(mimg);

	mimg = string_format_2_mimage(str);
	CHECK_POINTER(mimg);

	err = write_jpeg_mimage(ofname, mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	SMART_FREE(str);
}

float fop_c(float x, float y, int c)
{
	int f;
	
	switch(c) {
		case 0:
			f = fabs(x-120);
			break;
		case 1:
			f = fabs(y-120);
			break;
		case 2:
			f = fabs(y-x);
			break;
	}
		
	return f;
}

void testm12(char *ofname)
{
	int err;
	mimage_ptr mimg;
	image_dimension new_dim = {512, 348};

	mimg = gradient_mimage(NULL, NULL, (float (*)(void*,void*,int,int,int))fop_c, &new_dim, DISCRETE_IMAGE, 3); 
	CHECK_POINTER(mimg);

	err = write_jpeg_mimage(ofname, mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
}

void testfm11(char *fname, char *ofname)
{
	int err;
	mimage_ptr mimg, mimg_scaled;
	image_dimension new_dim = {200, 200};

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	convert_mimage_to_float(mimg);
	mimg_scaled = scale_mimage(mimg, &new_dim);
	CHECK_POINTER(mimg_scaled);

	err = write_jpeg_mimage(ofname, mimg_scaled);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(mimg_scaled);
}


void testm11(char *fname, char *ofname)
{
	int err;
	mimage_ptr mimg, mimg_scaled;
	image_dimension new_dim = {200, 200};

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	mimg_scaled = scale_mimage(mimg, &new_dim);
	CHECK_POINTER(mimg_scaled);

	err = write_jpeg_mimage(ofname, mimg_scaled);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(mimg_scaled);
}

void testfm10(char *fname)
{
	mimage_ptr mimg;
	float *sorted_list;
	int elts;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	convert_mimage_to_float(mimg);

	sorted_list = sort_mimage(mimg, &elts);
	CHECK_POINTER(sorted_list);

	destroy_mimage(mimg);
	SMART_FREE(sorted_list);
}

void testm10(char *fname)
{
	mimage_ptr mimg;
	unsigned char *sorted_list;
	int elts;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	sorted_list = sort_mimage(mimg, &elts);
	CHECK_POINTER(sorted_list);

	destroy_mimage(mimg);
	SMART_FREE(sorted_list);
}

void testm9(char *fname)
{
#define THIRD_POWER	3
	int i;
	mimage_ptr mimg;
	double *sums;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	sums = sumall_mimage(mimg, THIRD_POWER);
	CHECK_POINTER(sums);

	for ( i=0 ; i<THIRD_POWER ; i++ )
		printf("=> %d-th power = sum:%g\n", i, sums[i]);

	destroy_mimage(mimg);
	SMART_FREE(sums);
}

void testm8(char *fname)
{
	mimage_ptr mimg;
	float min, max;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	min = minof_mimage(mimg);
	max = maxof_mimage(mimg);

	printf("=> min:%g - max:%g\n", min, max);

	destroy_mimage(mimg);
}

void testm7(char *fname, char *fname2, char *ofname)
{
	mimage_ptr mimg, mimg2, mimg_res;
	int err;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	mimg2 = read_jpeg_mimage(fname2);
	CHECK_POINTER(mimg2);

	mimg_res = plus_mimage(mimg, mimg2);
	CHECK_POINTER(mimg_res);

	err = write_jpeg_mimage(ofname, mimg_res);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(mimg2);
	destroy_mimage(mimg_res);
}

void testm6(char *ofname)
{
	int err;
	mimage_ptr mimg;
	unsigned char values[] = {122, 0, 125};
	image_dimension dim	= {128, 256};

	mimg = const_mimage(values, &dim, DISCRETE_IMAGE, 3);
	CHECK_POINTER(mimg);

	err = write_jpeg_mimage(ofname, mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
}

void testm5(char *fname)
{
	mimage_ptr mimg;
	int err;
	image_rect rect;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	err = shrink_mimage(mimg, 0, &rect);
	CHECK_ERROR(err);

#ifdef VERBOSE
	printf("x:%d, y:%d, dx:%d, dy:%d\n",rect.x, rect.y, rect.dx, rect.dy);
#endif /* VERBOSE */

	destroy_mimage(mimg);
}

void testm4(char *fname, char *fname2, char *ofname)
{
	mimage_ptr mimg, mimg2;
	int err;
	gr_image_displacement delta = {50, 50};

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	mimg2 = read_jpeg_mimage(fname2);
	CHECK_POINTER(mimg2);

	err = stuff_mimage(mimg, mimg2, &delta);
	CHECK_ERROR(err);

	err = write_jpeg_mimage(ofname, mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
	destroy_mimage(mimg2);
}

void testm3(char *fname, char *ofname)
{
	mimage_ptr mimg;
	int err;
	image_rect rect = {10, 10, 40, 40};

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	err = crop_mimage(mimg, &rect);
	CHECK_ERROR(err);

	err = write_jpeg_mimage(ofname, mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
}

void testm2(char *fname, char *ofname)
{
	mimage_ptr mimg;
	int err;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	convert_mimage_to_float(mimg);
	convert_mimage_to_discrete(mimg);

	err = write_jpeg_mimage(ofname, mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
}

void testm1_tiff(char *fname)
{
	mimage_ptr mimg;
	int err;

	mimg = read_tiff_mimage(fname);
	CHECK_POINTER(mimg);

	err = write_tiff_mimage("out.tiff", mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
}

void testm1(char *fname, char *ofname)
{
	mimage_ptr mimg;
	int err;

	mimg = read_jpeg_mimage(fname);
	CHECK_POINTER(mimg);

	err = write_jpeg_mimage(ofname, mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg);
}

/*************************************************************************************
 *                           various procedures good for tests 
 *************************************************************************************/

mimage_ptr get_sparse_n_plane_mimage(char *filename, int n)
{
	int i, no;
	mimage_ptr mimg, *mimgs;

	mimg = read_tiff_mimage(filename);
	CHECK_POINTER(mimg);
	
	mimgs = split_dense_mimage(mimg, &no, NULL, NULL);
	CHECK_POINTER(mimgs);

	destroy_mimage(mimg);
	mimg = mimgs[n];
	
	for (i=0; i<no; i++)
		if (i!=n)
			destroy_mimage(mimgs[i]);

	SMART_FREE(mimgs);
	
	return mimg;
}

void superpose_and_write(mimage_ptr mimg_a, mimage_ptr mimg_b, char *filename_target)
{
	int err;
	mimage_ptr res_mimg;
	
	res_mimg = superpose_smimage(mimg_a, mimg_b);
	CHECK_POINTER(res_mimg);

	err = write_tiff_mimage(filename_target, res_mimg);
	CHECK_ERROR(err);

	destroy_mimage(res_mimg);
}

mimage_ptr mix_a_with_random_b(mimage_ptr mimg_a, mimage_ptr mimg_b)
{
	mimage_ptr mimg_b_rand;
	mimage_ptr res_mimg;
	
	mimg_b_rand = random_mimage(mimg_b, 80., 120.);	/* create random values not too white nor too black */
	CHECK_POINTER(mimg_b_rand);
	
	res_mimg = superpose_smimage(mimg_a, mimg_b_rand);
	CHECK_POINTER(res_mimg);

	destroy_mimage(mimg_b_rand);
	
	return res_mimg;	
}

mimage_ptr create_test_mimage(char *filename_a, char *filename_b, char *filename_target)
{
	int err;
	
	mimage_ptr mimg_a = NULL, mimg_b = NULL, mimg = NULL;

	mimg_a = get_sparse_n_plane_mimage(filename_a, 1);
	mimg_b = get_sparse_n_plane_mimage(filename_b, 1);

	mimg = mix_a_with_random_b(mimg_a, mimg_b);
	CHECK_POINTER(mimg);
	
	err = write_tiff_mimage(filename_target, mimg);
	CHECK_ERROR(err);

	destroy_mimage(mimg_a);	destroy_mimage(mimg_b);

	return mimg;
}

void test_counter(int line)
{
	static int test_no = 0;
	printf("Running now: %d @ [%d]\n", test_no ++, line);
}

/*************************************/

int main(int argc, char*argv[])
{

#ifdef macintosh
 #pragma unused(argc)
 #pragma unused(argv)
#endif

#ifdef STRESS_TEST
 int counter = 0;
 clock_t begin, end;
#endif 

#ifdef STRESS_TEST

 puts("begin test suite");
 begin = clock();
 while (counter!=STRESS_TIMES) {

 #ifdef VERBOSE
  printf("Test [%d/%d]\n", counter+1, STRESS_TIMES);
 #endif /* VERBOSE */

#endif /* STRESS_TEST */

	tests2execute();

#ifdef STRESS_TEST

 ++counter;
 }	

 #ifdef VERBOSE
  puts("test finished");
 #endif /* VERBOSE */

 end = clock();
 printf("==> ellapsed time: %3.2f secs\n", (float)(end-begin)/CLOCKS_PER_SEC);
 puts("end test suite");

#endif

	return 0;
}

