void NTL_FACTOR(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_FACTOR(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	TUPLE_CONSTRUCTOR(ca)
	specifier s;

	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZX_type, 0, "integer polynomial", "ntl_factor");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
	ntl_struct *var1 = new ntl_struct(SETL_SYSTEM ntl_vec_pair_ZZX_long_type);

	factor(*(var0->var.ZZ), *(var1->var.vec_pair_ZZX_long), *(var2->var.ZZX));		// call the function

	TUPLE_CONSTRUCTOR_BEGIN(ca);

	s.sp_form = ft_opaque;
	s.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
	TUPLE_ADD_CELL(ca,&s);

	s.sp_form = ft_opaque;
	s.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var1;
	TUPLE_ADD_CELL(ca,&s);

	TUPLE_CONSTRUCTOR_END(ca);

			/*return the whole tuple*/
	unmark_specifier(target);
	target->sp_form = ft_tuple;
	target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);

}

void NTL_SQUAREFREEDECOMP(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_SQUAREFREEDECOMP(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZX_type, 0, "integer polynomial", "ntl_SquareFreeDecomp");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_vec_pair_ZZX_long_type);

	SquareFreeDecomp(*(var0->var.vec_pair_ZZX_long), *(var1->var.ZZX));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_ABS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_ABS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_abs");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		abs(*(var0->var.ZZ),*(var1->var.ZZ));		// call the function
			break;

	case ntl_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		abs(*(var0->var.RR),*(var1->var.RR));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "abs");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_SQRMOD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_SQRMOD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_SqrMod");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_SqrMod");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		SqrMod(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		SqrMod(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		SqrMod(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		SqrMod(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		SqrMod(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		SqrMod(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "SqrMod");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_ADDMOD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_ADDMOD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_type, 0, "multiprecision integer", "ntl_AddMod");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_ZZ_type, 1, "multiprecision integer", "ntl_AddMod");
	ntl_struct *var3 = check_ntl_arg(SETL_SYSTEM &argv[2], ntl_ZZ_type, 2, "multiprecision integer", "ntl_AddMod");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);

	AddMod(*(var0->var.ZZ), *(var1->var.ZZ), *(var2->var.ZZ), *(var3->var.ZZ));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_SUBMOD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_SUBMOD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_type, 0, "multiprecision integer", "ntl_SubMod");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_ZZ_type, 1, "multiprecision integer", "ntl_SubMod");
	ntl_struct *var3 = check_ntl_arg(SETL_SYSTEM &argv[2], ntl_ZZ_type, 2, "multiprecision integer", "ntl_SubMod");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);

	SubMod(*(var0->var.ZZ), *(var1->var.ZZ), *(var2->var.ZZ), *(var3->var.ZZ));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_MULMOD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_MULMOD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_MulMod");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_MulMod");
	ntl_struct *var3 = check_ntl_arg(SETL_SYSTEM &argv[2], ntl_any_type, 2, "ntl type", "ntl_MulMod");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		MulMod(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ),*(var3->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		MulMod(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX),*(var3->var.ZZX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		MulMod(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX),*(var3->var.ZZ_pX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		MulMod(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX),*(var3->var.ZZ_pEX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		MulMod(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X),*(var3->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		MulMod(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX),*(var3->var.GF2EX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "MulMod");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_DIVREM(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_DIVREM(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;
	TUPLE_CONSTRUCTOR(ca)
	specifier s;

	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_DivRem");
	ntl_struct *var3 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_DivRem");

	sub_type = var2->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;
	ntl_struct *var1 = NULL;

	switch (sub_type) {
	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		DivRem(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ),*(var3->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		DivRem(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX),*(var3->var.ZZX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		DivRem(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX),*(var3->var.ZZ_pX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		DivRem(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX),*(var3->var.ZZ_pEX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		DivRem(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X),*(var3->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		DivRem(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX),*(var3->var.GF2EX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "DivRem");
			break;

	}
	TUPLE_CONSTRUCTOR_BEGIN(ca);

	s.sp_form = ft_opaque;
	s.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
	TUPLE_ADD_CELL(ca,&s);

	s.sp_form = ft_opaque;
	s.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var1;
	TUPLE_ADD_CELL(ca,&s);

	TUPLE_CONSTRUCTOR_END(ca);

			/*return the whole tuple*/
	unmark_specifier(target);
	target->sp_form = ft_tuple;
	target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);

}

void NTL_REM(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_REM(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_rem");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_rem");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		rem(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		rem(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		rem(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		rem(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		rem(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		rem(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "rem");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_ADD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_ADD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_add");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_add");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		add(*(var0->var.RR),*(var1->var.RR),*(var2->var.RR));		// call the function
			break;

	case ntl_mat_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_RR_type);
		add(*(var0->var.mat_RR),*(var1->var.mat_RR),*(var2->var.mat_RR));		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		add(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		add(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX));		// call the function
			break;

	case ntl_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		add(*(var0->var.ZZ_p),*(var1->var.ZZ_p),*(var2->var.ZZ_p));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		add(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX));		// call the function
			break;

	case ntl_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		add(*(var0->var.ZZ_pE),*(var1->var.ZZ_pE),*(var2->var.ZZ_pE));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		add(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX));		// call the function
			break;

	case ntl_vec_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_p_type);
		add(*(var0->var.vec_ZZ_p),*(var1->var.vec_ZZ_p),*(var2->var.vec_ZZ_p));		// call the function
			break;

	case ntl_mat_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_type);
		add(*(var0->var.mat_ZZ),*(var1->var.mat_ZZ),*(var2->var.mat_ZZ));		// call the function
			break;

	case ntl_mat_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_p_type);
		add(*(var0->var.mat_ZZ_p),*(var1->var.mat_ZZ_p),*(var2->var.mat_ZZ_p));		// call the function
			break;

	case ntl_vec_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_type);
		add(*(var0->var.vec_ZZ),*(var1->var.vec_ZZ),*(var2->var.vec_ZZ));		// call the function
			break;

	case ntl_vec_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_RR_type);
		add(*(var0->var.vec_RR),*(var1->var.vec_RR),*(var2->var.vec_RR));		// call the function
			break;

	case ntl_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2_type);
		add(*(var0->var.GF2),*(var1->var.GF2),*(var2->var.GF2));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		add(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		add(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX));		// call the function
			break;

	case ntl_mat_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_GF2_type);
		add(*(var0->var.mat_GF2),*(var1->var.mat_GF2),*(var2->var.mat_GF2));		// call the function
			break;

	case ntl_vec_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_GF2_type);
		add(*(var0->var.vec_GF2),*(var1->var.vec_GF2),*(var2->var.vec_GF2));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "add");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_SUB(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_SUB(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_sub");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_sub");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		sub(*(var0->var.RR),*(var1->var.RR),*(var2->var.RR));		// call the function
			break;

	case ntl_mat_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_RR_type);
		sub(*(var0->var.mat_RR),*(var1->var.mat_RR),*(var2->var.mat_RR));		// call the function
			break;

	case ntl_mat_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_type);
		sub(*(var0->var.mat_ZZ),*(var1->var.mat_ZZ),*(var2->var.mat_ZZ));		// call the function
			break;

	case ntl_vec_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_RR_type);
		sub(*(var0->var.vec_RR),*(var1->var.vec_RR),*(var2->var.vec_RR));		// call the function
			break;

	case ntl_vec_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_type);
		sub(*(var0->var.vec_ZZ),*(var1->var.vec_ZZ),*(var2->var.vec_ZZ));		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		sub(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		sub(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX));		// call the function
			break;

	case ntl_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		sub(*(var0->var.ZZ_p),*(var1->var.ZZ_p),*(var2->var.ZZ_p));		// call the function
			break;

	case ntl_mat_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_p_type);
		sub(*(var0->var.mat_ZZ_p),*(var1->var.mat_ZZ_p),*(var2->var.mat_ZZ_p));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		sub(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX));		// call the function
			break;

	case ntl_vec_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_p_type);
		sub(*(var0->var.vec_ZZ_p),*(var1->var.vec_ZZ_p),*(var2->var.vec_ZZ_p));		// call the function
			break;

	case ntl_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2_type);
		sub(*(var0->var.GF2),*(var1->var.GF2),*(var2->var.GF2));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		sub(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		sub(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX));		// call the function
			break;

	case ntl_mat_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_GF2_type);
		sub(*(var0->var.mat_GF2),*(var1->var.mat_GF2),*(var2->var.mat_GF2));		// call the function
			break;

	case ntl_vec_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_GF2_type);
		sub(*(var0->var.vec_GF2),*(var1->var.vec_GF2),*(var2->var.vec_GF2));		// call the function
			break;

	case ntl_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		sub(*(var0->var.ZZ_pE),*(var1->var.ZZ_pE),*(var2->var.ZZ_pE));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		sub(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "sub");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_MUL(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_MUL(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_mul");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_mul");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		mul(*(var0->var.RR),*(var1->var.RR),*(var2->var.RR));		// call the function
			break;

	case ntl_mat_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_RR_type);
		mul(*(var0->var.mat_RR),*(var1->var.mat_RR),*(var2->var.mat_RR));		// call the function
			break;

	case ntl_mat_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_type);
		mul(*(var0->var.mat_ZZ),*(var1->var.mat_ZZ),*(var2->var.mat_ZZ));		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		mul(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		mul(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX));		// call the function
			break;

	case ntl_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		mul(*(var0->var.ZZ_p),*(var1->var.ZZ_p),*(var2->var.ZZ_p));		// call the function
			break;

	case ntl_mat_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_p_type);
		mul(*(var0->var.mat_ZZ_p),*(var1->var.mat_ZZ_p),*(var2->var.mat_ZZ_p));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		mul(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX));		// call the function
			break;

	case ntl_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2_type);
		mul(*(var0->var.GF2),*(var1->var.GF2),*(var2->var.GF2));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		mul(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		mul(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX));		// call the function
			break;

	case ntl_mat_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_GF2_type);
		mul(*(var0->var.mat_GF2),*(var1->var.mat_GF2),*(var2->var.mat_GF2));		// call the function
			break;

	case ntl_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		mul(*(var0->var.ZZ_pE),*(var1->var.ZZ_pE),*(var2->var.ZZ_pE));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		mul(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "mul");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_DIV(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_DIV(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_div");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_div");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		div(*(var0->var.RR),*(var1->var.RR),*(var2->var.RR));		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		div(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		div(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX));		// call the function
			break;

	case ntl_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		div(*(var0->var.ZZ_p),*(var1->var.ZZ_p),*(var2->var.ZZ_p));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		div(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX));		// call the function
			break;

	case ntl_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2_type);
		div(*(var0->var.GF2),*(var1->var.GF2),*(var2->var.GF2));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		div(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		div(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX));		// call the function
			break;

	case ntl_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		div(*(var0->var.ZZ_pE),*(var1->var.ZZ_pE),*(var2->var.ZZ_pE));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		div(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "div");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_NEGATE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_NEGATE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_negate");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		negate(*(var0->var.RR),*(var1->var.RR));		// call the function
			break;

	case ntl_mat_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_RR_type);
		negate(*(var0->var.mat_RR),*(var1->var.mat_RR));		// call the function
			break;

	case ntl_mat_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_type);
		negate(*(var0->var.mat_ZZ),*(var1->var.mat_ZZ));		// call the function
			break;

	case ntl_mat_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_GF2_type);
		negate(*(var0->var.mat_GF2),*(var1->var.mat_GF2));		// call the function
			break;

	case ntl_vec_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_RR_type);
		negate(*(var0->var.vec_RR),*(var1->var.vec_RR));		// call the function
			break;

	case ntl_vec_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_type);
		negate(*(var0->var.vec_ZZ),*(var1->var.vec_ZZ));		// call the function
			break;

	case ntl_vec_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_GF2_type);
		negate(*(var0->var.vec_GF2),*(var1->var.vec_GF2));		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		negate(*(var0->var.ZZ),*(var1->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		negate(*(var0->var.ZZX),*(var1->var.ZZX));		// call the function
			break;

	case ntl_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		negate(*(var0->var.ZZ_p),*(var1->var.ZZ_p));		// call the function
			break;

	case ntl_mat_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_p_type);
		negate(*(var0->var.mat_ZZ_p),*(var1->var.mat_ZZ_p));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		negate(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX));		// call the function
			break;

	case ntl_vec_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_p_type);
		negate(*(var0->var.vec_ZZ_p),*(var1->var.vec_ZZ_p));		// call the function
			break;

	case ntl_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2_type);
		negate(*(var0->var.GF2),*(var1->var.GF2));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		negate(*(var0->var.GF2X),*(var1->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		negate(*(var0->var.GF2EX),*(var1->var.GF2EX));		// call the function
			break;

	case ntl_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		negate(*(var0->var.ZZ_pE),*(var1->var.ZZ_pE));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		negate(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "negate");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_DETERMINANT(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_DETERMINANT(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_determinant");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_mat_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		determinant(*(var0->var.RR),*(var1->var.mat_RR));		// call the function
			break;

	case ntl_mat_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		determinant(*(var0->var.ZZ),*(var1->var.mat_ZZ));		// call the function
			break;

	case ntl_mat_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		determinant(*(var0->var.ZZ_p),*(var1->var.mat_ZZ_p));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "determinant");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_SOLVE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_SOLVE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;
	TUPLE_CONSTRUCTOR(ca)
	specifier s;

	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_solve");
	ntl_struct *var3 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_solve");

	sub_type = var2->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;
	ntl_struct *var1 = NULL;

	switch (sub_type) {
	case ntl_mat_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_vec_RR_type);
		solve(*(var0->var.RR),*(var1->var.vec_RR),*(var2->var.mat_RR),*(var3->var.vec_RR));		// call the function
			break;

	case ntl_mat_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_type);
		solve(*(var0->var.ZZ),*(var1->var.vec_ZZ),*(var2->var.mat_ZZ),*(var3->var.vec_ZZ));		// call the function
			break;

	case ntl_mat_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_p_type);
		solve(*(var0->var.ZZ_p),*(var1->var.vec_ZZ_p),*(var2->var.mat_ZZ_p),*(var3->var.vec_ZZ_p));		// call the function
			break;

	case ntl_mat_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_pE_type);
		solve(*(var0->var.ZZ_pE),*(var1->var.vec_ZZ_pE),*(var2->var.mat_ZZ_pE),*(var3->var.vec_ZZ_pE));		// call the function
			break;

	case ntl_mat_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2_type);
		var1 = new ntl_struct(SETL_SYSTEM ntl_vec_GF2_type);
		solve(*(var0->var.GF2),*(var1->var.vec_GF2),*(var2->var.mat_GF2),*(var3->var.vec_GF2));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "solve");
			break;

	}
	TUPLE_CONSTRUCTOR_BEGIN(ca);

	s.sp_form = ft_opaque;
	s.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
	TUPLE_ADD_CELL(ca,&s);

	s.sp_form = ft_opaque;
	s.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var1;
	TUPLE_ADD_CELL(ca,&s);

	TUPLE_CONSTRUCTOR_END(ca);

			/*return the whole tuple*/
	unmark_specifier(target);
	target->sp_form = ft_tuple;
	target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);

}

void NTL_INV(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_INV(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_inv");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2_type);
		inv(*(var0->var.GF2),*(var1->var.GF2));		// call the function
			break;

	case ntl_GF2E_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2E_type);
		inv(*(var0->var.GF2E),*(var1->var.GF2E));		// call the function
			break;

	case ntl_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		inv(*(var0->var.ZZ_p),*(var1->var.ZZ_p));		// call the function
			break;

	case ntl_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_RR_type);
		inv(*(var0->var.RR),*(var1->var.RR));		// call the function
			break;

	case ntl_mat_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_RR_type);
		inv(*(var0->var.mat_RR),*(var1->var.mat_RR));		// call the function
			break;

	case ntl_mat_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_type);
		inv(*(var0->var.mat_ZZ),*(var1->var.mat_ZZ));		// call the function
			break;

	case ntl_mat_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_p_type);
		inv(*(var0->var.mat_ZZ_p),*(var1->var.mat_ZZ_p));		// call the function
			break;

	case ntl_mat_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_GF2_type);
		inv(*(var0->var.mat_GF2),*(var1->var.mat_GF2));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "inv");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_POWER(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_POWER(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_power");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "power");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2_type);
		power(*(var0->var.GF2),*(var1->var.GF2),var2);		// call the function
			break;

	case ntl_GF2E_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2E_type);
		power(*(var0->var.GF2E),*(var1->var.GF2E),var2);		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		power(*(var0->var.GF2X),*(var1->var.GF2X),var2);		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		power(*(var0->var.GF2EX),*(var1->var.GF2EX),var2);		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		power(*(var0->var.ZZ),*(var1->var.ZZ),var2);		// call the function
			break;

	case ntl_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		power(*(var0->var.ZZ_p),*(var1->var.ZZ_p),var2);		// call the function
			break;

	case ntl_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		power(*(var0->var.ZZ_pE),*(var1->var.ZZ_pE),var2);		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		power(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),var2);		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		power(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),var2);		// call the function
			break;

	case ntl_mat_GF2_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_GF2_type);
		power(*(var0->var.mat_GF2),*(var1->var.mat_GF2),var2);		// call the function
			break;

	case ntl_mat_RR_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_RR_type);
		power(*(var0->var.mat_RR),*(var1->var.mat_RR),var2);		// call the function
			break;

	case ntl_mat_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_type);
		power(*(var0->var.mat_ZZ),*(var1->var.mat_ZZ),var2);		// call the function
			break;

	case ntl_mat_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_mat_ZZ_p_type);
		power(*(var0->var.mat_ZZ_p),*(var1->var.mat_ZZ_p),var2);		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "power");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_GETCOEFF(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_GETCOEFF(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_GetCoeff");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "GetCoeff");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2E_type);
		GetCoeff(*(var0->var.GF2E),*(var1->var.GF2EX),var2);		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		GetCoeff(*(var0->var.ZZ),*(var1->var.ZZX),var2);		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		GetCoeff(*(var0->var.ZZ_p),*(var1->var.ZZ_pX),var2);		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "GetCoeff");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_SETCOEFF(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_SETCOEFF(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	long var1 = check_long_arg(SETL_SYSTEM &argv[0], 0, "SetCoeff");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_GF2E_type, 1, "integer mod 2 extension", "ntl_SetCoeff");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);

	SetCoeff(*(var0->var.GF2EX), var1,*(var2->var.GF2E));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_TRUNC(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_TRUNC(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_trunc");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "trunc");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		trunc(*(var0->var.GF2EX),*(var1->var.GF2EX),var2);		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		trunc(*(var0->var.GF2X),*(var1->var.GF2X),var2);		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		trunc(*(var0->var.ZZ),*(var1->var.ZZ),var2);		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		trunc(*(var0->var.ZZX),*(var1->var.ZZX),var2);		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		trunc(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),var2);		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		trunc(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),var2);		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "trunc");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_RIGHTSHIFT(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_RIGHTSHIFT(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_RightShift");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "RightShift");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		RightShift(*(var0->var.GF2EX),*(var1->var.GF2EX),var2);		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		RightShift(*(var0->var.GF2X),*(var1->var.GF2X),var2);		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		RightShift(*(var0->var.ZZ),*(var1->var.ZZ),var2);		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		RightShift(*(var0->var.ZZX),*(var1->var.ZZX),var2);		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		RightShift(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),var2);		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		RightShift(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),var2);		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "RightShift");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_LEFTSHIFT(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_LEFTSHIFT(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_LeftShift");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "LeftShift");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		LeftShift(*(var0->var.GF2EX),*(var1->var.GF2EX),var2);		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		LeftShift(*(var0->var.GF2X),*(var1->var.GF2X),var2);		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		LeftShift(*(var0->var.ZZ),*(var1->var.ZZ),var2);		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		LeftShift(*(var0->var.ZZX),*(var1->var.ZZX),var2);		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		LeftShift(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),var2);		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		LeftShift(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),var2);		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "LeftShift");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_DIFF(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_DIFF(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_diff");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		diff(*(var0->var.GF2EX),*(var1->var.GF2EX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		diff(*(var0->var.GF2X),*(var1->var.GF2X));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		diff(*(var0->var.ZZX),*(var1->var.ZZX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		diff(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		diff(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "diff");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_REVERSE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_REVERSE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_reverse");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		reverse(*(var0->var.GF2EX),*(var1->var.GF2EX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		reverse(*(var0->var.GF2X),*(var1->var.GF2X));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		reverse(*(var0->var.ZZX),*(var1->var.ZZX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		reverse(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		reverse(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "reverse");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_GCD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_GCD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_GCD");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_GCD");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		GCD(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		GCD(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X));		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		GCD(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ));		// call the function
			break;

	case ntl_ZZX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZX_type);
		GCD(*(var0->var.ZZX),*(var1->var.ZZX),*(var2->var.ZZX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		GCD(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		GCD(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "GCD");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_XGCD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_XGCD(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_XGCD");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_XGCD");
	ntl_struct *var3 = check_ntl_arg(SETL_SYSTEM &argv[2], ntl_any_type, 2, "ntl type", "ntl_XGCD");
	ntl_struct *var4 = check_ntl_arg(SETL_SYSTEM &argv[3], ntl_any_type, 3, "ntl type", "ntl_XGCD");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		XGCD(*(var0->var.GF2EX),*(var1->var.GF2EX),*(var2->var.GF2EX),*(var3->var.GF2EX),*(var4->var.GF2EX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		XGCD(*(var0->var.GF2X),*(var1->var.GF2X),*(var2->var.GF2X),*(var3->var.GF2X),*(var4->var.GF2X));		// call the function
			break;

	case ntl_ZZ_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);
		XGCD(*(var0->var.ZZ),*(var1->var.ZZ),*(var2->var.ZZ),*(var3->var.ZZ),*(var4->var.ZZ));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		XGCD(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pEX),*(var3->var.ZZ_pEX),*(var4->var.ZZ_pEX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		XGCD(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),*(var2->var.ZZ_pX),*(var3->var.ZZ_pX),*(var4->var.ZZ_pX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "XGCD");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_FINDROOT(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_FINDROOT(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_FindRoot");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		FindRoot(*(var0->var.ZZ_p),*(var1->var.ZZ_pX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		FindRoot(*(var0->var.ZZ_pE),*(var1->var.ZZ_pEX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "FindRoot");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_FINDROOTS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_FINDROOTS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_FindRoots");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_p_type);
		FindRoots(*(var0->var.vec_ZZ_p),*(var1->var.ZZ_pX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_pE_type);
		FindRoots(*(var0->var.vec_ZZ_pE),*(var1->var.ZZ_pEX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "FindRoots");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_SFBERLEKAMP(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_SFBERLEKAMP(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_pX_type, 0, "integer polynomial mod stated prime", "ntl_SFBerlekamp");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "SFBerlekamp");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_pX_type);

	SFBerlekamp(*(var0->var.vec_ZZ_pX), *(var1->var.ZZ_pX), var2);		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_BERLEKAMP(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_BERLEKAMP(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_berlekamp");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "berlekamp");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_pair_GF2EX_long_type);
		berlekamp(*(var0->var.vec_pair_GF2EX_long),*(var1->var.GF2EX),var2);		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_pair_ZZ_pX_long_type);
		berlekamp(*(var0->var.vec_pair_ZZ_pX_long),*(var1->var.ZZ_pX),var2);		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "berlekamp");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_SFCANZASS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_SFCANZASS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_SFCanZass");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_pEX_type);
		SFCanZass(*(var0->var.vec_ZZ_pEX),*(var1->var.ZZ_pEX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_pX_type);
		SFCanZass(*(var0->var.vec_ZZ_pX),*(var1->var.ZZ_pX));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_GF2EX_type);
		SFCanZass(*(var0->var.vec_GF2EX),*(var1->var.GF2EX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_GF2X_type);
		SFCanZass(*(var0->var.vec_GF2X),*(var1->var.GF2X));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "SFCanZass");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_CANZASS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_CANZASS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_CanZass");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "CanZass");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_pair_GF2EX_long_type);
		CanZass(*(var0->var.vec_pair_GF2EX_long),*(var1->var.GF2EX),var2);		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_pair_GF2X_long_type);
		CanZass(*(var0->var.vec_pair_GF2X_long),*(var1->var.GF2X),var2);		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_pair_ZZ_pEX_long_type);
		CanZass(*(var0->var.vec_pair_ZZ_pEX_long),*(var1->var.ZZ_pEX),var2);		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_vec_pair_ZZ_pX_long_type);
		CanZass(*(var0->var.vec_pair_ZZ_pX_long),*(var1->var.ZZ_pX),var2);		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "CanZass");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_BUILDIRRED_MOD2EXTINT_POLY(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_BUILDIRRED_MOD2EXTINT_POLY(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	long var1 = check_long_arg(SETL_SYSTEM &argv[0], 0, "BuildIrred_mod2extint_poly");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);

	BuildIrred_mod2extint_poly(*(var0->var.GF2EX), var1);		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_BUILDIRRED_MOD2INT_POLY(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_BUILDIRRED_MOD2INT_POLY(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	long var1 = check_long_arg(SETL_SYSTEM &argv[0], 0, "BuildIrred_mod2int_poly");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);

	BuildIrred_mod2int_poly(*(var0->var.GF2X), var1);		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_BUILDIRRED_MODEXTINT_POLY(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_BUILDIRRED_MODEXTINT_POLY(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	long var1 = check_long_arg(SETL_SYSTEM &argv[0], 0, "BuildIrred_modextint_poly");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);

	BuildIrred_modextint_poly(*(var0->var.ZZ_pEX), var1);		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_BUILDIRRED_MODINT_POLY(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_BUILDIRRED_MODINT_POLY(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	long var1 = check_long_arg(SETL_SYSTEM &argv[0], 0, "BuildIrred_modint_poly");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);

	BuildIrred_modint_poly(*(var0->var.ZZ_pX), var1);		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_BUILDRANDOMIRRED(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_BUILDRANDOMIRRED(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_BuildRandomIrred");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		BuildRandomIrred(*(var0->var.GF2EX),*(var1->var.GF2EX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		BuildRandomIrred(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		BuildRandomIrred(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "BuildRandomIrred");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_GENPRIME(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_GENPRIME(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	long var1 = check_long_arg(SETL_SYSTEM &argv[0], 0, "GenPrime");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "GenPrime");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);

	GenPrime(*(var0->var.ZZ), var1,var2);		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_NEXTPRIME(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_NEXTPRIME(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_type, 0, "multiprecision integer", "ntl_NextPrime");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "NextPrime");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);

	NextPrime(*(var0->var.ZZ), *(var1->var.ZZ), var2);		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_BUILDFROMROOTS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_BUILDFROMROOTS(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_BuildFromRoots");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_vec_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		BuildFromRoots(*(var0->var.ZZ_pEX),*(var1->var.vec_ZZ_pE));		// call the function
			break;

	case ntl_vec_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		BuildFromRoots(*(var0->var.ZZ_pX),*(var1->var.vec_ZZ_p));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "BuildFromRoots");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_EVAL(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_EVAL(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_eval");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_eval");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2E_type);
		eval(*(var0->var.GF2E),*(var1->var.GF2EX),*(var2->var.GF2E));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2E_type);
		eval(*(var0->var.GF2E),*(var1->var.GF2X),*(var2->var.GF2E));		// call the function
			break;

	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_p_type);
		eval(*(var0->var.ZZ_p),*(var1->var.ZZ_pX),*(var2->var.ZZ_p));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);
		eval(*(var0->var.ZZ_pE),*(var1->var.ZZ_pEX),*(var2->var.ZZ_pE));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "eval");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_EVAL2(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_EVAL2(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_pX_type, 0, "integer polynomial mod stated prime", "ntl_eval2");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_ZZ_pE_type, 1, "integer mod stated prime extension", "ntl_eval2");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pE_type);

	eval2(*(var0->var.ZZ_pE), *(var1->var.ZZ_pX), *(var2->var.ZZ_pE));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_EVAL3(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_EVAL3(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_pX_type, 0, "integer polynomial mod stated prime", "ntl_eval3");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_vec_ZZ_p_type, 1, "???", "ntl_eval3");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_p_type);

	eval3(*(var0->var.vec_ZZ_p), *(var1->var.ZZ_pX), *(var2->var.vec_ZZ_p));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_EVAL4(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_EVAL4(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_pEX_type, 0, "integer polynomial mod stated prime extension", "ntl_eval4");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_vec_ZZ_pE_type, 1, "???", "ntl_eval4");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_vec_ZZ_pE_type);

	eval4(*(var0->var.vec_ZZ_pE), *(var1->var.ZZ_pEX), *(var2->var.vec_ZZ_pE));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_INTERPOLATE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_INTERPOLATE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_interpolate");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_any_type, 1, "ntl type", "ntl_interpolate");

	sub_type = var1->sub_type;

	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_vec_ZZ_pE_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		interpolate(*(var0->var.ZZ_pEX),*(var1->var.vec_ZZ_pE),*(var2->var.vec_ZZ_pE));		// call the function
			break;

	case ntl_vec_ZZ_p_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		interpolate(*(var0->var.ZZ_pX),*(var1->var.vec_ZZ_p),*(var2->var.vec_ZZ_p));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "interpolate");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_COMPUTEDEGREE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_COMPUTEDEGREE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_pX_type, 0, "integer polynomial mod stated prime", "ntl_ComputeDegree");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_ZZ_pX_type, 1, "integer polynomial mod stated prime", "ntl_ComputeDegree");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);

	ComputeDegree(*(var0->var.ZZ), *(var1->var.ZZ_pX), *(var2->var.ZZ_pX));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_PROBCOMPUTEDEGREE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_PROBCOMPUTEDEGREE(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_ZZ_pX_type, 0, "integer polynomial mod stated prime", "ntl_ProbComputeDegree");
	ntl_struct *var2 = check_ntl_arg(SETL_SYSTEM &argv[1], ntl_ZZ_pX_type, 1, "integer polynomial mod stated prime", "ntl_ProbComputeDegree");

	ntl_struct *var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_type);

	ProbComputeDegree(*(var0->var.ZZ), *(var1->var.ZZ_pX), *(var2->var.ZZ_pX));		// call the function

			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

void NTL_TRACEMAP(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target); /* prototype */

void NTL_TRACEMAP(SETL_SYSTEM_PROTO int argc, specifier *argv,specifier* target)
{
	int32 sub_type;

	ntl_struct *var1 = check_ntl_arg(SETL_SYSTEM &argv[0], ntl_any_type, 0, "ntl type", "ntl_TraceMap");
	long var2 = check_long_arg(SETL_SYSTEM &argv[1], 1, "TraceMap");
	ntl_struct *var3 = check_ntl_arg(SETL_SYSTEM &argv[2], ntl_any_type, 2, "ntl type", "ntl_TraceMap");
	ntl_struct *var4 = check_ntl_arg(SETL_SYSTEM &argv[3], ntl_any_type, 3, "ntl type", "ntl_TraceMap");

	sub_type = var1->sub_type;		// first input subtype for subsequent checking


	ntl_struct *var0 = NULL;

	switch (sub_type) {
	case ntl_ZZ_pX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pX_type);
		TraceMap(*(var0->var.ZZ_pX),*(var1->var.ZZ_pX),var2,*(var3->var.ZZ_pX),*(var4->var.ZZ_pX));		// call the function
			break;

	case ntl_ZZ_pEX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_ZZ_pEX_type);
		TraceMap(*(var0->var.ZZ_pEX),*(var1->var.ZZ_pEX),var2,*(var3->var.ZZ_pEX),*(var4->var.ZZ_pEX));		// call the function
			break;

	case ntl_GF2X_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2X_type);
		TraceMap(*(var0->var.GF2X),*(var1->var.GF2X),var2,*(var3->var.GF2X),*(var4->var.GF2X));		// call the function
			break;

	case ntl_GF2EX_type:
		var0 = new ntl_struct(SETL_SYSTEM ntl_GF2EX_type);
		TraceMap(*(var0->var.GF2EX),*(var1->var.GF2EX),var2,*(var3->var.GF2EX),*(var4->var.GF2EX));		// call the function
			break;

	default:
			delete(var0);
			abend(SETL_SYSTEM "not allowed type in %s", "TraceMap");
			break;

	}
			/*return one item*/
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)var0;
}

