#ifndef __STUBS_H__
#define __STUBS_H__		0x0100

#ifndef uint32
typedef unsigned int32 uint32;
#endif

	/*
	 *	Constants
	 */

		//
		// Base types
		
const uint32 ntl_basic_type_mask			= 0x000000ff;

const uint32 ntl_RR_type					= 0x00000001;		// big float
const uint32 ntl_ZZ_type					= 0x00000002;		// big integers
const uint32 ntl_ZZ_p_type					= 0x00000004;		// big integers modulo p
const uint32 ntl_ZZX_type					= 0x00000008;		// big integer polynomial
const uint32 ntl_ZZ_pX_type					= 0x00000010;		// polynomial over integer modulo p
const uint32 ntl_ZZ_pE_type					= 0x00000020;		// ring/field extension of integers modulo p
const uint32 ntl_ZZ_pEX_type				= 0x00000040;		// polymonial over ring/field extension of integers modulo p
const uint32 ntl_GF2_type					= 0x00000080;		// integer modulo 2
const uint32 ntl_GF2X_type					= 0x00000100;		// integer modulo 2 polynomial
const uint32 ntl_GF2E_type					= 0x00000200;		// integer modulo 2 extension
const uint32 ntl_GF2EX_type					= 0x00000400;		// integer modulo 2 extension polynomial
		//
		// Matrices
const uint32 ntl_any_mat_type				= 0x00010000;
const uint32 ntl_mat_RR_type				= 0x00010001;		// big floats matrix
const uint32 ntl_mat_ZZ_type				= 0x00010002;		// big integers matrix
const uint32 ntl_mat_ZZ_p_type				= 0x00010004;		// big integers modulo p matrix
const uint32 ntl_mat_ZZ_pE_type				= 0x00010020;		// big integers modulo p ext matrix
const uint32 ntl_mat_GF2_type				= 0x00010080;		// integers modulo 2 matrix
		//
		// Vector types
const uint32 ntl_any_vec_type				= 0x00020000;
const uint32 ntl_vec_RR_type				= 0x00020001;		// big integer vector
const uint32 ntl_vec_ZZ_type				= 0x00020002;		// big integer vector
const uint32 ntl_vec_ZZ_p_type				= 0x00020004;		// big integer modulo p vector
const uint32 ntl_vec_ZZ_pX_type				= 0x00020010;		// ring/field extension of integers modulo p vector
const uint32 ntl_vec_ZZ_pE_type				= 0x00020020;		// ring/field extension of integers modulo p vector
const uint32 ntl_vec_ZZ_pEX_type			= 0x00020040;		// polymonial over ring/field extension of integers modulo p vector

const uint32 ntl_vec_GF2_type				= 0x00020080;		// integers modulo 2 vectors
const uint32 ntl_vec_GF2X_type				= 0x00020100;		// integers modulo 2 vectors
const uint32 ntl_vec_GF2E_type				= 0x00020200;		// integers modulo 2 vectors
const uint32 ntl_vec_GF2EX_type				= 0x00020400;		// integers modulo 2 vectors
		//
		// Pair types
const uint32 ntl_vec_pair_ZZX_long_type		= 0x00100000;		// vector of pairs of big integer polynomial and long
const uint32 ntl_vec_pair_ZZ_pX_long_type	= 0x00100001;
const uint32 ntl_vec_pair_ZZ_pEX_long_type	= 0x00100002;
const uint32 ntl_vec_pair_GF2X_long_type	= 0x00100003;
const uint32 ntl_vec_pair_GF2EX_long_type	= 0x00100004;
		//
		// Special types

		//
		// Auxiliary types
const uint32 ntl_any_type					= 0xffffffff;		// any of abow types
		
	/*
	 *	Forward declarations
	 */

extern int32 ntl_type;

	/*
	 *	Classes
	 */

typedef struct ntl_struct {
	
		// common setl part
	int32 use_count;
	int32 type;
	
		// this package type
	uint32 sub_type;
	union {
		RR 			*RR;
		ZZ 			*ZZ;
		ZZ_p 		*ZZ_p;
		ZZ_pX 		*ZZ_pX;
		ZZX 		*ZZX;
		ZZ_pE 		*ZZ_pE;
		ZZ_pEX 		*ZZ_pEX;
		GF2			*GF2;
		GF2X		*GF2X;
		GF2E		*GF2E;
		GF2EX		*GF2EX;
		
		mat_RR		*mat_RR;
		mat_ZZ		*mat_ZZ;
		mat_ZZ_p	*mat_ZZ_p;
		mat_ZZ_pE	*mat_ZZ_pE;
		mat_GF2		*mat_GF2;
		
		vec_RR		*vec_RR;
		vec_ZZ 		*vec_ZZ;
		vec_ZZ_p	*vec_ZZ_p;
		vec_ZZ_pX	*vec_ZZ_pX;
		vec_ZZ_pE	*vec_ZZ_pE;
		vec_ZZ_pEX	*vec_ZZ_pEX;
		
		vec_GF2		*vec_GF2;
		vec_GF2X	*vec_GF2X;
		vec_GF2E	*vec_GF2E;
		vec_GF2EX	*vec_GF2EX;
		
		vec_pair_ZZX_long		*vec_pair_ZZX_long;
		vec_pair_ZZ_pX_long		*vec_pair_ZZ_pX_long;
		vec_pair_ZZ_pEX_long	*vec_pair_ZZ_pEX_long;
		vec_pair_GF2X_long 		*vec_pair_GF2X_long;
		vec_pair_GF2EX_long 	*vec_pair_GF2EX_long;

	} var;

public:

		// constructor for ntl_struct type
	ntl_struct(SETL_SYSTEM_PROTO uint32 ntl_sub_type) {

		use_count = 1;
		type = ntl_type;
		sub_type = ntl_sub_type;

		switch (sub_type) {
					// Base types
			case ntl_RR_type:
				if (!(var.RR = new RR()))
					goto abort;
				break;
			case ntl_ZZ_type:
				if (!(var.ZZ = new ZZ()))
					goto abort;
				break;
			case ntl_ZZ_p_type:
				if (!(var.ZZ_p = new ZZ_p()))
					goto abort;
				break;
			case ntl_ZZ_pX_type:
				if (!(var.ZZ_pX = new ZZ_pX()))
					goto abort;
				break;
			case ntl_ZZX_type:
				if (!(var.ZZX = new ZZX()))
					goto abort;
				break;
			case ntl_ZZ_pE_type:
				if (!(var.ZZ_pE = new ZZ_pE()))
					goto abort;
				break;
			case ntl_ZZ_pEX_type:
				if (!(var.ZZ_pEX = new ZZ_pEX()))
					goto abort;
				break;
			case ntl_GF2_type:
				if (!(var.GF2 = new GF2()))
					goto abort;
				break;
			case ntl_GF2X_type:
				if (!(var.GF2X = new GF2X()))
					goto abort;
				break;
			case ntl_GF2E_type:
				if (!(var.GF2E = new GF2E()))
					goto abort;
				break;
			case ntl_GF2EX_type:
				if (!(var.GF2EX = new GF2EX()))
					goto abort;
				break;

					// Matrices
			case ntl_mat_RR_type:
				if (!(var.mat_RR = new mat_RR()))
					goto abort;
				break;
			case ntl_mat_ZZ_type:
				if (!(var.mat_ZZ = new mat_ZZ()))
					goto abort;
				break;
			case ntl_mat_ZZ_p_type:
				if (!(var.mat_ZZ_p = new mat_ZZ_p()))
					goto abort;
				break;
			case ntl_mat_ZZ_pE_type:
				if (!(var.mat_ZZ_pE = new mat_ZZ_pE()))
					goto abort;
				break;
			case ntl_mat_GF2_type:
				if (!(var.mat_GF2 = new mat_GF2()))
					goto abort;
				break;

					// Vectors
			case ntl_vec_RR_type:
				if (!(var.vec_RR = new vec_RR()))
					goto abort;
				break;
			case ntl_vec_ZZ_type:
				if (!(var.vec_ZZ = new vec_ZZ()))
					goto abort;
				break;
			case ntl_vec_ZZ_p_type:
				if (!(var.vec_ZZ_p = new vec_ZZ_p()))
					goto abort;
				break;
			case ntl_vec_ZZ_pX_type:
				if (!(var.vec_ZZ_pX = new vec_ZZ_pX()))
					goto abort;
				break;
			case ntl_vec_ZZ_pE_type:
				if (!(var.vec_ZZ_pE = new vec_ZZ_pE()))
					goto abort;
				break;
			case ntl_vec_ZZ_pEX_type:
				if (!(var.vec_ZZ_pEX = new vec_ZZ_pEX()))
					goto abort;
				break;
			case ntl_vec_GF2_type:
				if (!(var.vec_GF2 = new vec_GF2()))
					goto abort;
				break;
			case ntl_vec_GF2X_type:
				if (!(var.vec_GF2X = new vec_GF2X()))
					goto abort;
				break;
			case ntl_vec_GF2E_type:
				if (!(var.vec_GF2E = new vec_GF2E()))
					goto abort;
				break;
			case ntl_vec_GF2EX_type:
				if (!(var.vec_GF2EX = new vec_GF2EX()))
					goto abort;
				break;

					// Others

			case ntl_vec_pair_ZZX_long_type:			
				if (!(var.vec_pair_ZZX_long = new vec_pair_ZZX_long()))
					goto abort;
				break;
			case ntl_vec_pair_ZZ_pX_long_type:			
				if (!(var.vec_pair_ZZ_pX_long = new vec_pair_ZZ_pX_long()))
					goto abort;
				break;
			case ntl_vec_pair_ZZ_pEX_long_type:			
				if (!(var.vec_pair_ZZ_pEX_long = new vec_pair_ZZ_pEX_long()))
					goto abort;
				break;
			case ntl_vec_pair_GF2X_long_type:			
				if (!(var.vec_pair_GF2X_long = new vec_pair_GF2X_long()))
					goto abort;
				break;
			case ntl_vec_pair_GF2EX_long_type:			
				if (!(var.vec_pair_GF2EX_long = new vec_pair_GF2EX_long()))
					goto abort;
				break;
		}

		return;

	abort:
		abend(SETL_SYSTEM msg_malloc_error);	// start an error condition
	}
	
		// destructor for ntl_struct type
	~ntl_struct() {

		switch (sub_type) {
					// Base types
			case ntl_RR_type:
				if (var.RR)
					delete var.RR;
				break;
			case ntl_ZZ_type:
				if (var.ZZ)
					delete var.ZZ;
				break;
			case ntl_ZZ_p_type:
				if (var.ZZ_p)
					delete var.ZZ_p;
				break;
			case ntl_ZZ_pX_type:
				if (var.ZZ_pX)
					delete var.ZZ_pX;
				break;
			case ntl_ZZX_type:
				if (var.ZZX)
					delete var.ZZX;
				break;
			case ntl_ZZ_pE_type:
				if (var.ZZ_pE)
					delete var.ZZ_pE;
				break;
			case ntl_ZZ_pEX_type:
				if (var.ZZ_pEX)
					delete var.ZZ_pEX;
				break;
			case ntl_GF2_type:
				if (var.GF2)
					delete var.GF2;
				break;
			case ntl_GF2X_type:
				if (var.GF2X)
					delete var.GF2X;
				break;
			case ntl_GF2E_type:
				if (var.GF2E)
					delete var.GF2E;
				break;
			case ntl_GF2EX_type:
				if (var.GF2EX)
					delete var.GF2EX;
				break;

					// Matrices
			case ntl_mat_ZZ_type:
				if (var.mat_ZZ)
					delete var.mat_ZZ;
				break;
			case ntl_mat_ZZ_p_type:
				if (var.mat_ZZ_p)
					delete var.mat_ZZ_p;
				break;
			case ntl_mat_ZZ_pE_type:
				if (var.mat_ZZ_pE)
					delete var.mat_ZZ_pE;
				break;
			case ntl_mat_GF2_type:
				if (var.mat_GF2)
					delete var.mat_GF2;
				break;

					// Vectors
			case ntl_vec_ZZ_type:
				if (var.vec_ZZ)
					delete var.vec_ZZ;
				break;
			case ntl_vec_ZZ_p_type:
				if (var.vec_ZZ_p)
					delete var.vec_ZZ_p;
				break;
			case ntl_vec_ZZ_pX_type:
				if (var.vec_ZZ_pX)
					delete var.vec_ZZ_pX;
				break;
			case ntl_vec_ZZ_pE_type:
				if (var.vec_ZZ_pE)
					delete var.vec_ZZ_pE;
				break;
			case ntl_vec_ZZ_pEX_type:
				if (var.vec_ZZ_pEX)
					delete var.vec_ZZ_pEX;
				break;
			case ntl_vec_GF2_type:
				if (var.vec_GF2)
					delete var.vec_GF2;
				break;
			case ntl_vec_GF2X_type:
				if (var.vec_GF2X)
					delete var.vec_GF2X;
				break;
			case ntl_vec_GF2E_type:
				if (var.vec_GF2E)
					delete var.vec_GF2E;
				break;
			case ntl_vec_GF2EX_type:
				if (var.vec_GF2EX)
					delete var.vec_GF2EX;
				break;

					// Others
			case ntl_vec_pair_ZZX_long_type:
				if (var.vec_pair_ZZX_long)
					delete var.vec_pair_ZZX_long;
				break;
			case ntl_vec_pair_ZZ_pX_long_type:
				if (var.vec_pair_ZZ_pX_long)
					delete var.vec_pair_ZZ_pX_long;
				break;
			case ntl_vec_pair_ZZ_pEX_long_type:
				if (var.vec_pair_ZZ_pEX_long)
					delete var.vec_pair_ZZ_pEX_long;
				break;
			case ntl_vec_pair_GF2X_long_type:
				if (var.vec_pair_GF2X_long)
					delete var.vec_pair_GF2X_long;
				break;
			case ntl_vec_pair_GF2EX_long_type:
				if (var.vec_pair_GF2EX_long)
					delete var.vec_pair_GF2EX_long;
				break;

		}
	}

} ntl_struct;

#endif // __STUBS_H__ 