
void GAUSSJ(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
struct nrmatrix matA;
struct nrmatrix matB;
int n,m;
specifier return1;
specifier return2;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"opaque matrix",1,"gaussj",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"opaque matrix",1,"gaussj",
            abend_opnd_str(SETL_SYSTEM argv+1));

   setl2string_to_C(argv[0].sp_val.sp_string_ptr,
	(unsigned char *)&matA,sizeof(struct nrmatrix));

   setl2string_to_C(argv[1].sp_val.sp_string_ptr,
	(unsigned char *)&matB,sizeof(struct nrmatrix));

   if (matA.r!=matA.c) 
      abend(SETL_SYSTEM msg_bad_arg,"square matrix",1,"gaussj",
            abend_opnd_str(SETL_SYSTEM argv));

   if (matA.r!=matB.r) 
      abend(SETL_SYSTEM "wrong dimensions in second matrix");

   gaussj(matA.p,matA.r,matB.p,matB.c);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_string;
   return1.sp_val.sp_string_ptr = 
     setl2_string(SETL_SYSTEM (unsigned char *)&matA,sizeof(struct nrmatrix));
   push_pstack(&return1);

   return2.sp_form = ft_string;
   return2.sp_val.sp_string_ptr = 
     setl2_string(SETL_SYSTEM (unsigned char *)&matB,sizeof(struct nrmatrix));
   push_pstack(&return2);

}
