
void GAUSSJ(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
struct nrmatrix * fmatB; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"gaussj",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"gaussj",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"gaussj",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fmatB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fmatB->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",2,"gaussj",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in gaussj (parameter 2)");
   if (n != fmatB->r)
      abend(SETL_SYSTEM "Wrong first dimension in gaussj (parameter 3)");
   m = fmatB->c;

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatB->use_count!=1) 
      fmatB=nr_copy(fmatB);
   if (fmatB==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   gaussj((float **)(fmatA->p),n,(float **)(fmatB->p),m);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatB;
   push_pstack(&return2);



}

void LUDCMP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
struct nrmatrix * ivectB; /* w */ 
float floatD; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ludcmp",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"ludcmp",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in ludcmp (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   ivectB = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   ivectB->use_count = 0;
   ivectB->type = nr_ivect*65536+nr_type;

   ivectB->r = n;
   ivectB->p = (void*)ivector(1,n);

   ludcmp((float **)(fmatA->p),n,(int *)(ivectB->p),&floatD);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectB;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatD);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void MPROVE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
struct nrmatrix * fmatALUD; /* r */ 
struct nrmatrix * ivectINDX; /* r */ 
struct nrmatrix * fvectB; /* r */ 
struct nrmatrix * fvectX; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fmatALUD = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fmatALUD->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",2,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ivectINDX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((ivectINDX->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",3,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectB = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+3));

   fvectX = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",5,"mprove",
         abend_opnd_str(SETL_SYSTEM argv+4));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in mprove (parameter 2)");
   if (n != fmatALUD->r)
      abend(SETL_SYSTEM "Wrong first dimension in mprove (parameter 3)");
   if (n != fmatALUD->c)
      abend(SETL_SYSTEM "Wrong second dimension in mprove (parameter 3)");
   if (n != ivectINDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in mprove (parameter 4)");
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in mprove (parameter 5)");
   if (n != fvectX->r)
      abend(SETL_SYSTEM "Wrong first dimension in mprove (parameter 6)");

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mprove((float **)(fmatA->p),(float **)(fmatALUD->p),n,(int *)(ivectINDX->p),(float *)(fvectB->p),(float *)(fvectX->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);



}

void LUBKSB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
struct nrmatrix * ivectB; /* r */ 
struct nrmatrix * fvectD; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"lubksb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"lubksb",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"lubksb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ivectB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ivectB->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",2,"lubksb",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in lubksb (parameter 2)");
   if (n != ivectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in lubksb (parameter 3)");

   fvectD = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectD->use_count = 0;
   fvectD->type = nr_fvect*65536+nr_type;

   fvectD->r = n;
   fvectD->p = (void*)vector(1,n);

   lubksb((float **)(fmatA->p),n,(int *)(ivectB->p),(float *)(fvectD->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void TRIDAG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectA; /* r */ 
struct nrmatrix * fvectB; /* r */ 
struct nrmatrix * fvectC; /* r */ 
struct nrmatrix * fvectR; /* r */ 
struct nrmatrix * fvectU; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"tridag",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"tridag",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"tridag",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"tridag",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"tridag",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"tridag",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectC = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"tridag",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectR = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"tridag",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fvectA->r;
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in tridag (parameter 3)");
   if (n != fvectC->r)
      abend(SETL_SYSTEM "Wrong first dimension in tridag (parameter 4)");
   if (n != fvectR->r)
      abend(SETL_SYSTEM "Wrong first dimension in tridag (parameter 5)");

   fvectU = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectU->use_count = 0;
   fvectU->type = nr_fvect*65536+nr_type;

   fvectU->r = n;
   fvectU->p = (void*)vector(1,n);

   tridag((float *)(fvectA->p),(float *)(fvectB->p),(float *)(fvectC->p),(float *)(fvectR->p),(float *)(fvectU->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectU;
   push_pstack(&return1);



}

void BANMUL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
int integerM1; /* r */ 
int integerM2; /* r */ 
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"banmul",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"banmul",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"banmul",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"banmul",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"banmul",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerM1 = (argv[1].sp_val.sp_short_value);

   integerM2 = (argv[2].sp_val.sp_short_value);

   fvectX = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"banmul",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fmatA->r;
   m = fmatA->c;
   if (n != fvectX->r)
      abend(SETL_SYSTEM "Wrong first dimension in banmul (parameter 5)");

   fvectB = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectB->use_count = 0;
   fvectB->type = nr_fvect*65536+nr_type;

   fvectB->r = n;
   fvectB->p = (void*)vector(1,n);

   banmul((float **)(fmatA->p),n,integerM1,integerM2,(float *)(fvectX->p),(float *)(fvectB->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectB;
   push_pstack(&return1);



}

void BANDEC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
int integerM1; /* r */ 
int integerM2; /* r */ 
struct nrmatrix * fmatAL; /* w */ 
struct nrmatrix * ulvectINDX; /* w */ 
float floatD; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"bandec",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"bandec",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"bandec",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"bandec",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"bandec",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerM1 = (argv[1].sp_val.sp_short_value);

   integerM2 = (argv[2].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_short)
      floatD = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatD = (float)((argv[5].sp_val.sp_real_ptr)->r_value);

   n = fmatA->r;
   m = fmatA->c;

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fmatAL = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatAL->use_count = 0;
   fmatAL->type = nr_fmat*65536+nr_type;

   fmatAL->r = n;
   fmatAL->c = integerM1;
   fmatAL->p = (void*)matrix(1,n,1,integerM1);
   ulvectINDX = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   ulvectINDX->use_count = 0;
   ulvectINDX->type = nr_ulvect*65536+nr_type;

   ulvectINDX->r = n;
   ulvectINDX->p = (void*)lvector(1,n);

   bandec((float **)(fmatA->p),n,integerM1,integerM2,(float **)(fmatAL->p),(unsigned long *)(ulvectINDX->p),&floatD);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatAL;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ulvectINDX;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatD);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void BANBKS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
int integerM1; /* r */ 
int integerM2; /* r */ 
struct nrmatrix * fmatAL; /* r */ 
struct nrmatrix * ulvectINDX; /* r */ 
struct nrmatrix * fvectB; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerM1 = (argv[1].sp_val.sp_short_value);

   integerM2 = (argv[2].sp_val.sp_short_value);

   fmatAL = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fmatAL->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",4,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+3));

   ulvectINDX = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((ulvectINDX->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",5,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+4));

   fvectB = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",6,"banbks",
         abend_opnd_str(SETL_SYSTEM argv+5));


   n = fmatA->r;
   m = fmatA->c;
   if (n != fmatAL->r)
      abend(SETL_SYSTEM "Wrong first dimension in banbks (parameter 5)");
   if (integerM1 != fmatAL->c)
      abend(SETL_SYSTEM "Wrong second dimension in banbks (parameter 5)");
   if (n != ulvectINDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in banbks (parameter 6)");
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in banbks (parameter 7)");

   if (fvectB->use_count!=1) 
      fvectB=nr_copy(fvectB);
   if (fvectB==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   banbks((float **)(fmatA->p),n,integerM1,integerM2,(float **)(fmatAL->p),(unsigned long *)(ulvectINDX->p),(float *)(fvectB->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectB;
   push_pstack(&return1);



}

void SVDCMP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
struct nrmatrix * fvectW; /* w */ 
struct nrmatrix * fmatV; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"svdcmp",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"svdcmp",
         abend_opnd_str(SETL_SYSTEM argv+0));


   m = fmatA->r;
   n = fmatA->c;

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = n;
   fvectW->p = (void*)vector(1,n);
   fmatV = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatV->use_count = 0;
   fmatV->type = nr_fmat*65536+nr_type;

   fmatV->r = n;
   fmatV->c = n;
   fmatV->p = (void*)matrix(1,n,1,n);

   svdcmp((float **)(fmatA->p),m,n,(float *)(fvectW->p),(float **)(fmatV->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatV;
   push_pstack(&return3);



}

void DSVDCMP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatA; /* rw */ 
struct nrmatrix * dvectW; /* w */ 
struct nrmatrix * dmatV; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"dsvdcmp",
         abend_opnd_str(SETL_SYSTEM argv+0));


   dmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatA->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"dsvdcmp",
         abend_opnd_str(SETL_SYSTEM argv+0));


   m = dmatA->r;
   n = dmatA->c;

   if (dmatA->use_count!=1) 
      dmatA=nr_copy(dmatA);
   if (dmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   dvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dvectW->use_count = 0;
   dvectW->type = nr_dvect*65536+nr_type;

   dvectW->r = n;
   dvectW->p = (void*)dvector(1,n);
   dmatV = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dmatV->use_count = 0;
   dmatV->type = nr_dmat*65536+nr_type;

   dmatV->r = n;
   dmatV->c = n;
   dmatV->p = (void*)dmatrix(1,n,1,n);

   dsvdcmp((double **)(dmatA->p),m,n,(double *)(dvectW->p),(double **)(dmatV->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectW;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatV;
   push_pstack(&return3);



}

void SVBKSB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatU; /* r */ 
struct nrmatrix * fvectW; /* r */ 
struct nrmatrix * fmatV; /* r */ 
struct nrmatrix * fvectB; /* r */ 
struct nrmatrix * fvectX; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"svbksb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"svbksb",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"svbksb",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"svbksb",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fmatU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatU->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"svbksb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectW = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectW->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"svbksb",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fmatV = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fmatV->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",3,"svbksb",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectB = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"svbksb",
         abend_opnd_str(SETL_SYSTEM argv+3));


   m = fmatU->r;
   n = fmatU->c;
   if (n != fvectW->r)
      abend(SETL_SYSTEM "Wrong first dimension in svbksb (parameter 3)");
   if (n != fmatV->r)
      abend(SETL_SYSTEM "Wrong first dimension in svbksb (parameter 4)");
   if (n != fmatV->c)
      abend(SETL_SYSTEM "Wrong second dimension in svbksb (parameter 4)");
   if (m != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in svbksb (parameter 5)");

   fvectX = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectX->use_count = 0;
   fvectX->type = nr_fvect*65536+nr_type;

   fvectX->r = n;
   fvectX->p = (void*)vector(1,n);

   svbksb((float **)(fmatU->p),(float *)(fvectW->p),(float **)(fmatV->p),m,n,(float *)(fvectB->p),(float *)(fvectX->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);



}

void DSVBKSB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatU; /* r */ 
struct nrmatrix * dvectW; /* r */ 
struct nrmatrix * dmatV; /* r */ 
struct nrmatrix * dvectB; /* r */ 
struct nrmatrix * dvectX; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"dsvbksb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"dsvbksb",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"dsvbksb",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"dsvbksb",
         abend_opnd_str(SETL_SYSTEM argv+3));


   dmatU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"dsvbksb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dvectW = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dvectW->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",2,"dsvbksb",
         abend_opnd_str(SETL_SYSTEM argv+1));

   dmatV = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((dmatV->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",3,"dsvbksb",
         abend_opnd_str(SETL_SYSTEM argv+2));

   dvectB = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((dvectB->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",4,"dsvbksb",
         abend_opnd_str(SETL_SYSTEM argv+3));


   m = dmatU->r;
   n = dmatU->c;
   if (n != dvectW->r)
      abend(SETL_SYSTEM "Wrong first dimension in dsvbksb (parameter 3)");
   if (n != dmatV->r)
      abend(SETL_SYSTEM "Wrong first dimension in dsvbksb (parameter 4)");
   if (n != dmatV->c)
      abend(SETL_SYSTEM "Wrong second dimension in dsvbksb (parameter 4)");
   if (m != dvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in dsvbksb (parameter 5)");

   dvectX = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dvectX->use_count = 0;
   dvectX->type = nr_dvect*65536+nr_type;

   dvectX->r = n;
   dvectX->p = (void*)dvector(1,n);

   dsvbksb((double **)(dmatU->p),(double *)(dvectW->p),(double **)(dmatV->p),m,n,(double *)(dvectB->p),(double *)(dvectX->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectX;
   push_pstack(&return1);



}

void CYCLIC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectA; /* r */ 
struct nrmatrix * fvectB; /* r */ 
struct nrmatrix * fvectC; /* r */ 
float floatALPHA; /* r */ 
float floatBETA; /* r */ 
struct nrmatrix * fvectR; /* r */ 
struct nrmatrix * fvectX; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectC = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form == ft_short)
      floatALPHA = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatALPHA = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatBETA = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatBETA = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   fvectR = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((fvectR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",6,"cyclic",
         abend_opnd_str(SETL_SYSTEM argv+5));


   n = fvectA->r;
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in cyclic (parameter 3)");
   if (n != fvectC->r)
      abend(SETL_SYSTEM "Wrong first dimension in cyclic (parameter 4)");
   if (n != fvectR->r)
      abend(SETL_SYSTEM "Wrong first dimension in cyclic (parameter 7)");

   fvectX = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectX->use_count = 0;
   fvectX->type = nr_fvect*65536+nr_type;

   fvectX->r = n;
   fvectX->p = (void*)vector(1,n);

   cyclic((float *)(fvectA->p),(float *)(fvectB->p),(float *)(fvectC->p),floatALPHA,floatBETA,(float *)(fvectR->p),(float *)(fvectX->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);



}

void SPRSIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
float floatTHRESH; /* r */ 
struct nrmatrix * fvectSA; /* rw */ 
struct nrmatrix * ulvectIJA; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sprsin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"sprsin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"sprsin",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"sprsin",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"sprsin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatTHRESH = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatTHRESH = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectSA = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectSA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"sprsin",
         abend_opnd_str(SETL_SYSTEM argv+2));

   ulvectIJA = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((ulvectIJA->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",4,"sprsin",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in sprsin (parameter 2)");
   m = fvectSA->r;
   if (m != ulvectIJA->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprsin (parameter 5)");

   if (fvectSA->use_count!=1) 
      fvectSA=nr_copy(fvectSA);
   if (fvectSA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (ulvectIJA->use_count!=1) 
      ulvectIJA=nr_copy(ulvectIJA);
   if (ulvectIJA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sprsin((float **)(fmatA->p),n,floatTHRESH,m,(float *)(fvectSA->p),(unsigned long *)(ulvectIJA->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectSA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ulvectIJA;
   push_pstack(&return2);



}

void SPRSAX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectSA; /* r */ 
struct nrmatrix * ulvectIJA; /* r */ 
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sprsax",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"sprsax",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"sprsax",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectSA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectSA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sprsax",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectIJA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectIJA->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"sprsax",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"sprsax",
         abend_opnd_str(SETL_SYSTEM argv+2));


   m = fvectSA->r;
   if (m != ulvectIJA->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprsax (parameter 3)");
   n = fvectX->r;

   fvectB = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectB->use_count = 0;
   fvectB->type = nr_fvect*65536+nr_type;

   fvectB->r = n;
   fvectB->p = (void*)vector(1,n);

   sprsax((float *)(fvectSA->p),(unsigned long *)(ulvectIJA->p),(float *)(fvectX->p),(float *)(fvectB->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectB;
   push_pstack(&return1);



}

void DSPRSAX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectSA; /* r */ 
struct nrmatrix * ulvectIJA; /* r */ 
struct nrmatrix * dvectX; /* r */ 
struct nrmatrix * dvectB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"dsprsax",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"dsprsax",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"dsprsax",
         abend_opnd_str(SETL_SYSTEM argv+2));


   dvectSA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectSA->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"dsprsax",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectIJA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectIJA->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"dsprsax",
         abend_opnd_str(SETL_SYSTEM argv+1));

   dvectX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((dvectX->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",3,"dsprsax",
         abend_opnd_str(SETL_SYSTEM argv+2));


   m = dvectSA->r;
   if (m != ulvectIJA->r)
      abend(SETL_SYSTEM "Wrong first dimension in dsprsax (parameter 3)");
   n = dvectX->r;

   dvectB = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dvectB->use_count = 0;
   dvectB->type = nr_dvect*65536+nr_type;

   dvectB->r = n;
   dvectB->p = (void*)dvector(1,n);

   dsprsax((double *)(dvectSA->p),(unsigned long *)(ulvectIJA->p),(double *)(dvectX->p),(double *)(dvectB->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectB;
   push_pstack(&return1);



}

void SPRSTX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectSA; /* r */ 
struct nrmatrix * ulvectIJA; /* r */ 
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sprstx",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"sprstx",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"sprstx",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectSA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectSA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sprstx",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectIJA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectIJA->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"sprstx",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"sprstx",
         abend_opnd_str(SETL_SYSTEM argv+2));


   m = fvectSA->r;
   if (m != ulvectIJA->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprstx (parameter 3)");
   n = fvectX->r;

   fvectB = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectB->use_count = 0;
   fvectB->type = nr_fvect*65536+nr_type;

   fvectB->r = n;
   fvectB->p = (void*)vector(1,n);

   sprstx((float *)(fvectSA->p),(unsigned long *)(ulvectIJA->p),(float *)(fvectX->p),(float *)(fvectB->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectB;
   push_pstack(&return1);



}

void DSPRSTX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectSA; /* r */ 
struct nrmatrix * ulvectIJA; /* r */ 
struct nrmatrix * dvectX; /* r */ 
struct nrmatrix * dvectB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"dsprstx",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"dsprstx",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"dsprstx",
         abend_opnd_str(SETL_SYSTEM argv+2));


   dvectSA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectSA->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"dsprstx",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectIJA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectIJA->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"dsprstx",
         abend_opnd_str(SETL_SYSTEM argv+1));

   dvectX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((dvectX->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",3,"dsprstx",
         abend_opnd_str(SETL_SYSTEM argv+2));


   m = dvectSA->r;
   if (m != ulvectIJA->r)
      abend(SETL_SYSTEM "Wrong first dimension in dsprstx (parameter 3)");
   n = dvectX->r;

   dvectB = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dvectB->use_count = 0;
   dvectB->type = nr_dvect*65536+nr_type;

   dvectB->r = n;
   dvectB->p = (void*)dvector(1,n);

   dsprstx((double *)(dvectSA->p),(unsigned long *)(ulvectIJA->p),(double *)(dvectX->p),(double *)(dvectB->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectB;
   push_pstack(&return1);



}

void SPRSTP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectSA; /* r */ 
struct nrmatrix * ulvectIJA; /* r */ 
struct nrmatrix * fvectSB; /* w */ 
struct nrmatrix * ulvectIJB; /* rw */ 

/* Variables used to compute the array bounds */

long m;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sprstp",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"sprstp",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"sprstp",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectSA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectSA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sprstp",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectIJA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectIJA->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"sprstp",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ulvectIJB = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((ulvectIJB->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",4,"sprstp",
         abend_opnd_str(SETL_SYSTEM argv+3));


   m = fvectSA->r;
   if (m != ulvectIJA->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprstp (parameter 3)");
   if (m != ulvectIJB->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprstp (parameter 5)");

   fvectSB = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectSB->use_count = 0;
   fvectSB->type = nr_fvect*65536+nr_type;

   fvectSB->r = m;
   fvectSB->p = (void*)vector(1,m);
   if (ulvectIJB->use_count!=1) 
      ulvectIJB=nr_copy(ulvectIJB);
   if (ulvectIJB==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sprstp((float *)(fvectSA->p),(unsigned long *)(ulvectIJA->p),(float *)(fvectSB->p),(unsigned long *)(ulvectIJB->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectSB;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ulvectIJB;
   push_pstack(&return2);



}

void SPRSPM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectSA; /* r */ 
struct nrmatrix * ulvectIJA; /* r */ 
struct nrmatrix * fvectSB; /* r */ 
struct nrmatrix * ulvectIJB; /* r */ 
struct nrmatrix * fvectSC; /* w */ 
struct nrmatrix * ulvectIJC; /* rw */ 

/* Variables used to compute the array bounds */

long m;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectSA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectSA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectIJA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectIJA->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectSB = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectSB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+2));

   ulvectIJB = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((ulvectIJB->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",4,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+3));

   ulvectIJC = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((ulvectIJC->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",6,"sprspm",
         abend_opnd_str(SETL_SYSTEM argv+5));


   m = fvectSA->r;
   if (m != ulvectIJA->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprspm (parameter 3)");
   if (m != fvectSB->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprspm (parameter 4)");
   if (m != ulvectIJB->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprspm (parameter 5)");
   if (m != ulvectIJC->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprspm (parameter 7)");

   fvectSC = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectSC->use_count = 0;
   fvectSC->type = nr_fvect*65536+nr_type;

   fvectSC->r = m;
   fvectSC->p = (void*)vector(1,m);
   if (ulvectIJC->use_count!=1) 
      ulvectIJC=nr_copy(ulvectIJC);
   if (ulvectIJC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sprspm((float *)(fvectSA->p),(unsigned long *)(ulvectIJA->p),(float *)(fvectSB->p),(unsigned long *)(ulvectIJB->p),(float *)(fvectSC->p),(unsigned long *)(ulvectIJC->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectSC;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ulvectIJC;
   push_pstack(&return2);



}

void SPRSTM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectSA; /* r */ 
struct nrmatrix * ulvectIJA; /* r */ 
struct nrmatrix * fvectSB; /* r */ 
struct nrmatrix * ulvectIJB; /* r */ 
float floatTHRESH; /* r */ 
struct nrmatrix * fvectSC; /* w */ 
struct nrmatrix * ulvectIJC; /* rw */ 

/* Variables used to compute the array bounds */

long m;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[6].sp_form != ft_opaque)||
       (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",7,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+6));


   fvectSA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectSA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectIJA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectIJA->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectSB = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectSB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+2));

   ulvectIJB = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((ulvectIJB->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",4,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form == ft_short)
      floatTHRESH = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatTHRESH = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   ulvectIJC = (struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr);

   if (((ulvectIJC->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",7,"sprstm",
         abend_opnd_str(SETL_SYSTEM argv+6));


   m = fvectSA->r;
   if (m != ulvectIJA->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprstm (parameter 3)");
   if (m != fvectSB->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprstm (parameter 4)");
   if (m != ulvectIJB->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprstm (parameter 5)");
   if (m != ulvectIJC->r)
      abend(SETL_SYSTEM "Wrong first dimension in sprstm (parameter 8)");

   fvectSC = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectSC->use_count = 0;
   fvectSC->type = nr_fvect*65536+nr_type;

   fvectSC->r = m;
   fvectSC->p = (void*)vector(1,m);
   if (ulvectIJC->use_count!=1) 
      ulvectIJC=nr_copy(ulvectIJC);
   if (ulvectIJC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sprstm((float *)(fvectSA->p),(unsigned long *)(ulvectIJA->p),(float *)(fvectSB->p),(unsigned long *)(ulvectIJB->p),floatTHRESH,m,(float *)(fvectSC->p),(unsigned long *)(ulvectIJC->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectSC;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ulvectIJC;
   push_pstack(&return2);



}

static specifier nrlinbcgASOLVE_callback;
#ifndef TUNSAFE
plugin_item_ptr_type nrlinbcgASOLVE_instance;
#endif

void nrlinbcgASOLVE_c_callback(int p1,double  p2[],double  p3[],int p4)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = nrlinbcgASOLVE_instance;
   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p4;
   push_pstack(&spare);

   save_callback.sp_form = nrlinbcgASOLVE_callback.sp_form;
   save_callback.sp_val.sp_biggest = nrlinbcgASOLVE_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  4,YES,NO,0);
   nrlinbcgASOLVE_callback.sp_form = save_callback.sp_form;
   nrlinbcgASOLVE_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static specifier nrlinbcgATIMES_callback;
#ifndef TUNSAFE
plugin_item_ptr_type nrlinbcgATIMES_instance;
#endif

void nrlinbcgATIMES_c_callback(int p1,double  p2[],double  p3[],int p4)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = nrlinbcgATIMES_instance;
   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p4;
   push_pstack(&spare);

   save_callback.sp_form = nrlinbcgATIMES_callback.sp_form;
   save_callback.sp_val.sp_biggest = nrlinbcgATIMES_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  4,YES,NO,0);
   nrlinbcgATIMES_callback.sp_form = save_callback.sp_form;
   nrlinbcgATIMES_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void NRLINBCG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectB; /* r */ 
struct nrmatrix * dvectX; /* rw */ 
int integerITOL; /* r */ 
double doubleTOL; /* r */ 
int integerITMAX; /* r */ 
int integerITER; /* w */ 
double doubleERR; /* w */ 
void *ASOLVEcallback;
void *ATIMEScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[7].sp_form != ft_opaque)||
          (((argv[7].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[7].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[7].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",8,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+7));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+8));


   dvectB = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectB->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dvectX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dvectX->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",2,"nrlinbcg",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerITOL = (argv[2].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_short)
      doubleTOL = (double)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      doubleTOL = (double)((argv[3].sp_val.sp_real_ptr)->r_value);
   integerITMAX = (argv[4].sp_val.sp_short_value);

  if (argv[7].sp_form == ft_proc) {
#ifndef TUNSAFE
     nrlinbcgASOLVE_instance = plugin_instance;
#endif
     nrlinbcgASOLVE_callback.sp_form = ft_proc;
     nrlinbcgASOLVE_callback.sp_val.sp_proc_ptr = argv[7].sp_val.sp_proc_ptr;

     ASOLVEcallback = (void*)nrlinbcgASOLVE_c_callback;
  } else {
     ASOLVEcallback = 
         (void *)(((struct nrmatrix *)(argv[7].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     nrlinbcgATIMES_instance = plugin_instance;
#endif
     nrlinbcgATIMES_callback.sp_form = ft_proc;
     nrlinbcgATIMES_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     ATIMEScallback = (void*)nrlinbcgATIMES_c_callback;
  } else {
     ATIMEScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = dvectB->r;
   if (n != dvectX->r)
      abend(SETL_SYSTEM "Wrong first dimension in nrlinbcg (parameter 3)");

   if (dvectX->use_count!=1) 
      dvectX=nr_copy(dvectX);
   if (dvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   nrlinbcg(n,(double *)(dvectB->p),(double *)(dvectX->p),integerITOL,doubleTOL,integerITMAX,&integerITER,&doubleERR,ASOLVEcallback,ATIMEScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectX;
   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerITER;

   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(doubleERR);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void SNRM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectSX; /* r */ 
int integerITOL; /* r */ 

/* Variables used to compute the array bounds */

long n;



   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"snrm",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"snrm",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dvectSX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectSX->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"snrm",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerITOL = (argv[1].sp_val.sp_short_value);


   n = dvectSX->r;


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(snrm(n,(double *)(dvectSX->p),integerITOL));



}

void VANDER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectX; /* r */ 
struct nrmatrix * dvectW; /* w */ 
struct nrmatrix * dvectQ; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"vander",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"vander",
         abend_opnd_str(SETL_SYSTEM argv+2));


   dvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectX->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"vander",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dvectQ = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((dvectQ->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",3,"vander",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = dvectX->r;
   if (n != dvectQ->r)
      abend(SETL_SYSTEM "Wrong first dimension in vander (parameter 4)");

   dvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dvectW->use_count = 0;
   dvectW->type = nr_dvect*65536+nr_type;

   dvectW->r = n;
   dvectW->p = (void*)dvector(1,n);

   vander((double *)(dvectX->p),(double *)(dvectW->p),(double *)(dvectQ->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectW;
   push_pstack(&return1);



}

void TOEPLZ(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectR; /* r */ 
struct nrmatrix * fvectX; /* w */ 
struct nrmatrix * fvectY; /* r */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"toeplz",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"toeplz",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"toeplz",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"toeplz",
         abend_opnd_str(SETL_SYSTEM argv+2));


   m = fvectR->r;
   n = fvectY->r;

   fvectX = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectX->use_count = 0;
   fvectX->type = nr_fvect*65536+nr_type;

   fvectX->r = n;
   fvectX->p = (void*)vector(1,n);

   toeplz((float *)(fvectR->p),(float *)(fvectX->p),(float *)(fvectY->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);



}

void CHOLDC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
struct nrmatrix * fvectP; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"choldc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"choldc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in choldc (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectP = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectP->use_count = 0;
   fvectP->type = nr_fvect*65536+nr_type;

   fvectP->r = n;
   fvectP->p = (void*)vector(1,n);

   choldc((float **)(fmatA->p),n,(float *)(fvectP->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectP;
   push_pstack(&return2);



}

void CHOLSL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
struct nrmatrix * fvectP; /* r */ 
struct nrmatrix * fvectB; /* r */ 
struct nrmatrix * fvectX; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"cholsl",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"cholsl",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"cholsl",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"cholsl",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectP = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"cholsl",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectB = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"cholsl",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in cholsl (parameter 2)");
   if (n != fvectP->r)
      abend(SETL_SYSTEM "Wrong first dimension in cholsl (parameter 3)");
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in cholsl (parameter 4)");

   fvectX = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectX->use_count = 0;
   fvectX->type = nr_fvect*65536+nr_type;

   fvectX->r = n;
   fvectX->p = (void*)vector(1,n);

   cholsl((float **)(fmatA->p),n,(float *)(fvectP->p),(float *)(fvectB->p),(float *)(fvectX->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);



}

void QRDCMP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
struct nrmatrix * fvectC; /* w */ 
struct nrmatrix * fvectD; /* w */ 
int integerSIGN; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"qrdcmp",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"qrdcmp",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in qrdcmp (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectC = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectC->use_count = 0;
   fvectC->type = nr_fvect*65536+nr_type;

   fvectC->r = n;
   fvectC->p = (void*)vector(1,n);
   fvectD = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectD->use_count = 0;
   fvectD->type = nr_fvect*65536+nr_type;

   fvectD->r = n;
   fvectD->p = (void*)vector(1,n);

   qrdcmp((float **)(fmatA->p),n,(float *)(fvectC->p),(float *)(fvectD->p),&integerSIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectC;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return3);

   return4.sp_form = ft_short;
   return4.sp_val.sp_short_value = (int32)integerSIGN;

   push_pstack(&return4);



}

void RSOLV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
struct nrmatrix * fvectD; /* r */ 
struct nrmatrix * fvectB; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rsolv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"rsolv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"rsolv",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"rsolv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectD = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"rsolv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectB = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"rsolv",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in rsolv (parameter 2)");
   if (n != fvectD->r)
      abend(SETL_SYSTEM "Wrong first dimension in rsolv (parameter 3)");
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in rsolv (parameter 4)");

   if (fvectB->use_count!=1) 
      fvectB=nr_copy(fvectB);
   if (fvectB==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   rsolv((float **)(fmatA->p),n,(float *)(fvectD->p),(float *)(fvectB->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectB;
   push_pstack(&return1);



}

void QRSOLV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
struct nrmatrix * fvectC; /* r */ 
struct nrmatrix * fvectD; /* r */ 
struct nrmatrix * fvectB; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"qrsolv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"qrsolv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"qrsolv",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"qrsolv",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"qrsolv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectC = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"qrsolv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectD = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"qrsolv",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectB = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"qrsolv",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in qrsolv (parameter 2)");
   if (n != fvectC->r)
      abend(SETL_SYSTEM "Wrong first dimension in qrsolv (parameter 3)");
   if (n != fvectD->r)
      abend(SETL_SYSTEM "Wrong first dimension in qrsolv (parameter 4)");
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in qrsolv (parameter 5)");

   if (fvectB->use_count!=1) 
      fvectB=nr_copy(fvectB);
   if (fvectB==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   qrsolv((float **)(fmatA->p),n,(float *)(fvectC->p),(float *)(fvectD->p),(float *)(fvectB->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectB;
   push_pstack(&return1);



}

void QRUPDT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatR; /* r */ 
struct nrmatrix * fmatQT; /* rw */ 
struct nrmatrix * fvectU; /* rw */ 
struct nrmatrix * fvectV; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"qrupdt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"qrupdt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"qrupdt",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"qrupdt",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fmatR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatR->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"qrupdt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fmatQT = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fmatQT->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",2,"qrupdt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectU = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectU->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"qrupdt",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectV = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectV->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"qrupdt",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fmatR->r;
   if (n != fmatR->c)
      abend(SETL_SYSTEM "Wrong second dimension in qrupdt (parameter 2)");
   if (n != fvectU->r)
      abend(SETL_SYSTEM "Wrong first dimension in qrupdt (parameter 4)");
   if (n != fvectV->r)
      abend(SETL_SYSTEM "Wrong first dimension in qrupdt (parameter 5)");

   if (fmatQT->use_count!=1) 
      fmatQT=nr_copy(fmatQT);
   if (fmatQT==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectU->use_count!=1) 
      fvectU=nr_copy(fvectU);
   if (fvectU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   qrupdt((float **)(fmatR->p),(float **)(fmatQT->p),n,(float *)(fvectU->p),(float *)(fvectV->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatQT;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectU;
   push_pstack(&return2);



}

void ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatR; /* rw */ 
struct nrmatrix * fmatQT; /* rw */ 
int integerI; /* r */ 
float floatA; /* r */ 
float floatB; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rotate",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"rotate",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"rotate",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"rotate",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"rotate",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fmatR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatR->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"rotate",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fmatQT = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fmatQT->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",2,"rotate",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerI = (argv[2].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_short)
      floatA = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatA = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatB = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatB = (float)((argv[4].sp_val.sp_real_ptr)->r_value);

   n = fmatR->r;
   if (n != fmatR->c)
      abend(SETL_SYSTEM "Wrong second dimension in rotate (parameter 2)");

   if (fmatR->use_count!=1) 
      fmatR=nr_copy(fmatR);
   if (fmatR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatQT->use_count!=1) 
      fmatQT=nr_copy(fmatQT);
   if (fmatQT==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   rotate((float **)(fmatR->p),(float **)(fmatQT->p),n,integerI,floatA,floatB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatR;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatQT;
   push_pstack(&return2);



}

void POLINT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectXA; /* r */ 
struct nrmatrix * fvectYA; /* r */ 
float floatX; /* r */ 
float floatY; /* w */ 
float floatDY; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"polint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"polint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"polint",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectXA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectXA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"polint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectYA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectYA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"polint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);

   n = fvectXA->r;
   if (n != fvectYA->r)
      abend(SETL_SYSTEM "Wrong first dimension in polint (parameter 3)");


   polint((float *)(fvectXA->p),(float *)(fvectYA->p),n,floatX,&floatY,&floatDY);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatY);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatDY);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void RATINT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectXA; /* r */ 
struct nrmatrix * fvectYA; /* r */ 
float floatX; /* r */ 
float floatY; /* w */ 
float floatDY; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ratint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"ratint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"ratint",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectXA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectXA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ratint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectYA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectYA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"ratint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);

   n = fvectXA->r;
   if (n != fvectYA->r)
      abend(SETL_SYSTEM "Wrong first dimension in ratint (parameter 3)");


   ratint((float *)(fvectXA->p),(float *)(fvectYA->p),n,floatX,&floatY,&floatDY);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatY);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatDY);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void SPLINE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
float floatYP1; /* r */ 
float floatYPN; /* r */ 
struct nrmatrix * fvectY2; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"spline",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"spline",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"spline",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"spline",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"spline",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"spline",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatYP1 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatYP1 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatYPN = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatYPN = (float)((argv[3].sp_val.sp_real_ptr)->r_value);

   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in spline (parameter 3)");

   fvectY2 = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectY2->use_count = 0;
   fvectY2->type = nr_fvect*65536+nr_type;

   fvectY2->r = n;
   fvectY2->p = (void*)vector(1,n);

   spline((float *)(fvectX->p),(float *)(fvectY->p),n,floatYP1,floatYPN,(float *)(fvectY2->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY2;
   push_pstack(&return1);



}

void SPLINT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectXA; /* r */ 
struct nrmatrix * fvectYA; /* r */ 
struct nrmatrix * fvectY2A; /* r */ 
float floatX; /* r */ 
float floatY; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"splint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"splint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"splint",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"splint",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectXA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectXA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"splint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectYA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectYA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"splint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectY2A = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectY2A->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"splint",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form == ft_short)
      floatX = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatX = (float)((argv[3].sp_val.sp_real_ptr)->r_value);

   n = fvectXA->r;
   if (n != fvectYA->r)
      abend(SETL_SYSTEM "Wrong first dimension in splint (parameter 3)");
   if (n != fvectY2A->r)
      abend(SETL_SYSTEM "Wrong first dimension in splint (parameter 4)");


   splint((float *)(fvectXA->p),(float *)(fvectYA->p),(float *)(fvectY2A->p),n,floatX,&floatY);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatY);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);



}

void LOCATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectXX; /* r */ 
float floatX; /* r */ 
unsigned long ulongJ; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"locate",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"locate",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectXX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectXX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"locate",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);

   n = fvectXX->r;


   locate((float *)(fvectXX->p),n,floatX,&ulongJ);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)ulongJ;

   push_pstack(&return1);



}

void HUNT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectXX; /* r */ 
float floatX; /* r */ 
unsigned long ulongJLO; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"hunt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"hunt",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectXX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectXX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"hunt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);

   n = fvectXX->r;


   hunt((float *)(fvectXX->p),n,floatX,&ulongJLO);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)ulongJLO;

   push_pstack(&return1);



}

void POLCOE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectCOF; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"polcoe",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"polcoe",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"polcoe",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"polcoe",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in polcoe (parameter 3)");

   fvectCOF = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectCOF->use_count = 0;
   fvectCOF->type = nr_fvect*65536+nr_type;

   fvectCOF->r = n;
   fvectCOF->p = (void*)vector(1,n);

   polcoe((((float *)(fvectX->p)) + 1),(((float *)(fvectY->p)) + 1),n-1,(((float *)(fvectCOF->p)) + 1));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectCOF;
   push_pstack(&return1);



}

void POLCOF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectXA; /* r */ 
struct nrmatrix * fvectYA; /* r */ 
struct nrmatrix * fvectCOF; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"polcof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"polcof",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectXA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectXA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"polcof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectYA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectYA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"polcof",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectXA->r;
   if (n != fvectYA->r)
      abend(SETL_SYSTEM "Wrong first dimension in polcof (parameter 3)");

   fvectCOF = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectCOF->use_count = 0;
   fvectCOF->type = nr_fvect*65536+nr_type;

   fvectCOF->r = n;
   fvectCOF->p = (void*)vector(1,n);

   polcof((((float *)(fvectXA->p)) + 1),(((float *)(fvectYA->p)) + 1),n-1,(((float *)(fvectCOF->p)) + 1));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectCOF;
   push_pstack(&return1);



}

void POLIN2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX1A; /* r */ 
struct nrmatrix * fvectX2A; /* r */ 
struct nrmatrix * fmatYA; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatY; /* w */ 
float floatDY; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"polin2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"polin2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"polin2",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"polin2",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"polin2",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fvectX1A = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX1A->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"polin2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectX2A = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectX2A->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"polin2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fmatYA = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fmatYA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",3,"polin2",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form == ft_short)
      floatX1 = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatX1 = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatX2 = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatX2 = (float)((argv[4].sp_val.sp_real_ptr)->r_value);

   m = fvectX1A->r;
   n = fvectX2A->r;
   if (m != fmatYA->r)
      abend(SETL_SYSTEM "Wrong first dimension in polin2 (parameter 4)");
   if (n != fmatYA->c)
      abend(SETL_SYSTEM "Wrong second dimension in polin2 (parameter 4)");


   polin2((float *)(fvectX1A->p),(float *)(fvectX2A->p),(float **)(fmatYA->p),m,n,floatX1,floatX2,&floatY,&floatDY);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatY);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatDY);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void BCUCOF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectY1; /* r */ 
struct nrmatrix * fvectY2; /* r */ 
struct nrmatrix * fvectY12; /* r */ 
float floatD1; /* r */ 
float floatD2; /* r */ 
struct nrmatrix * fmatC; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if ((argv[6].sp_form != ft_opaque)||
       (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",7,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+6));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY1 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectY2 = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectY2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectY12 = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectY12->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form == ft_short)
      floatD1 = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatD1 = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatD2 = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatD2 = (float)((argv[5].sp_val.sp_real_ptr)->r_value);
   fmatC = (struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr);

   if (((fmatC->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",7,"bcucof",
         abend_opnd_str(SETL_SYSTEM argv+6));


   n = fvectY->r;
   if (n != fvectY1->r)
      abend(SETL_SYSTEM "Wrong first dimension in bcucof (parameter 3)");
   if (n != fvectY2->r)
      abend(SETL_SYSTEM "Wrong first dimension in bcucof (parameter 4)");
   if (n != fvectY12->r)
      abend(SETL_SYSTEM "Wrong first dimension in bcucof (parameter 5)");
   if (n != fmatC->r)
      abend(SETL_SYSTEM "Wrong first dimension in bcucof (parameter 8)");
   if (n != fmatC->c)
      abend(SETL_SYSTEM "Wrong second dimension in bcucof (parameter 8)");

   if (fmatC->use_count!=1) 
      fmatC=nr_copy(fmatC);
   if (fmatC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   bcucof((float *)(fvectY->p),(float *)(fvectY1->p),(float *)(fvectY2->p),(float *)(fvectY12->p),floatD1,floatD2,(float **)(fmatC->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatC;
   push_pstack(&return1);



}

void BCUINT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectY1; /* r */ 
struct nrmatrix * fvectY2; /* r */ 
struct nrmatrix * fvectY12; /* r */ 
float floatX1L; /* r */ 
float floatX1U; /* r */ 
float floatX2L; /* r */ 
float floatX2U; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatANSY; /* w */ 
float floatANSY1; /* w */ 
float floatANSY2; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if ((argv[6].sp_form != ft_short) && (argv[6].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",7,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if ((argv[7].sp_form != ft_short) && (argv[7].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",8,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+7));

   if ((argv[8].sp_form != ft_short) && (argv[8].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",9,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+8));

   if ((argv[9].sp_form != ft_short) && (argv[9].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",10,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+9));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY1 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectY2 = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectY2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectY12 = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectY12->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"bcuint",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form == ft_short)
      floatX1L = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatX1L = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatX1U = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatX1U = (float)((argv[5].sp_val.sp_real_ptr)->r_value);
   if (argv[6].sp_form == ft_short)
      floatX2L = (float)(argv[6].sp_val.sp_short_value);

   if (argv[6].sp_form == ft_real)
      floatX2L = (float)((argv[6].sp_val.sp_real_ptr)->r_value);
   if (argv[7].sp_form == ft_short)
      floatX2U = (float)(argv[7].sp_val.sp_short_value);

   if (argv[7].sp_form == ft_real)
      floatX2U = (float)((argv[7].sp_val.sp_real_ptr)->r_value);
   if (argv[8].sp_form == ft_short)
      floatX1 = (float)(argv[8].sp_val.sp_short_value);

   if (argv[8].sp_form == ft_real)
      floatX1 = (float)((argv[8].sp_val.sp_real_ptr)->r_value);
   if (argv[9].sp_form == ft_short)
      floatX2 = (float)(argv[9].sp_val.sp_short_value);

   if (argv[9].sp_form == ft_real)
      floatX2 = (float)((argv[9].sp_val.sp_real_ptr)->r_value);

   n = fvectY->r;
   if (n != fvectY1->r)
      abend(SETL_SYSTEM "Wrong first dimension in bcuint (parameter 3)");
   if (n != fvectY2->r)
      abend(SETL_SYSTEM "Wrong first dimension in bcuint (parameter 4)");
   if (n != fvectY12->r)
      abend(SETL_SYSTEM "Wrong first dimension in bcuint (parameter 5)");


   bcuint((float *)(fvectY->p),(float *)(fvectY1->p),(float *)(fvectY2->p),(float *)(fvectY12->p),floatX1L,floatX1U,floatX2L,floatX2U,floatX1,floatX2,&floatANSY,&floatANSY1,&floatANSY2);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatANSY);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatANSY1);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatANSY2);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void SPLIE2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX1A; /* r */ 
struct nrmatrix * fvectX2A; /* r */ 
struct nrmatrix * fmatYA; /* r */ 
struct nrmatrix * fmatY2A; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"splie2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"splie2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"splie2",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectX1A = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX1A->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"splie2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectX2A = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectX2A->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"splie2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fmatYA = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fmatYA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",3,"splie2",
         abend_opnd_str(SETL_SYSTEM argv+2));


   m = fvectX1A->r;
   n = fvectX2A->r;
   if (m != fmatYA->r)
      abend(SETL_SYSTEM "Wrong first dimension in splie2 (parameter 4)");
   if (n != fmatYA->c)
      abend(SETL_SYSTEM "Wrong second dimension in splie2 (parameter 4)");

   fmatY2A = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatY2A->use_count = 0;
   fmatY2A->type = nr_fmat*65536+nr_type;

   fmatY2A->r = m;
   fmatY2A->c = n;
   fmatY2A->p = (void*)matrix(1,m,1,n);

   splie2((float *)(fvectX1A->p),(float *)(fvectX2A->p),(float **)(fmatYA->p),m,n,(float **)(fmatY2A->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatY2A;
   push_pstack(&return1);



}

void SPLIN2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX1A; /* r */ 
struct nrmatrix * fvectX2A; /* r */ 
struct nrmatrix * fmatYA; /* r */ 
struct nrmatrix * fmatY2A; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatY; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectX1A = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX1A->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectX2A = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectX2A->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fmatYA = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fmatYA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",3,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fmatY2A = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fmatY2A->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",4,"splin2",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form == ft_short)
      floatX1 = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatX1 = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatX2 = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatX2 = (float)((argv[5].sp_val.sp_real_ptr)->r_value);

   m = fvectX1A->r;
   n = fvectX2A->r;
   if (m != fmatYA->r)
      abend(SETL_SYSTEM "Wrong first dimension in splin2 (parameter 4)");
   if (n != fmatYA->c)
      abend(SETL_SYSTEM "Wrong second dimension in splin2 (parameter 4)");
   if (m != fmatY2A->r)
      abend(SETL_SYSTEM "Wrong first dimension in splin2 (parameter 5)");
   if (n != fmatY2A->c)
      abend(SETL_SYSTEM "Wrong second dimension in splin2 (parameter 5)");


   splin2((float *)(fvectX1A->p),(float *)(fvectX2A->p),(float **)(fmatYA->p),(float **)(fmatY2A->p),m,n,floatX1,floatX2,&floatY);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatY);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);



}

static specifier trapzdF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type trapzdF_instance;
#endif

float trapzdF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = trapzdF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = trapzdF_callback.sp_form;
   save_callback.sp_val.sp_biggest = trapzdF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   trapzdF_callback.sp_form = save_callback.sp_form;
   trapzdF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void TRAPZD(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 
int integerN; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"trapzd",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"trapzd",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"trapzd",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"trapzd",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     trapzdF_instance = plugin_instance;
#endif
     trapzdF_callback.sp_form = ft_proc;
     trapzdF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)trapzdF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   integerN = (argv[3].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(trapzd(Fcallback,floatA,floatB,integerN));



}

static specifier qtrapF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type qtrapF_instance;
#endif

float qtrapF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = qtrapF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = qtrapF_callback.sp_form;
   save_callback.sp_val.sp_biggest = qtrapF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   qtrapF_callback.sp_form = save_callback.sp_form;
   qtrapF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void QTRAP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"qtrap",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"qtrap",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"qtrap",
         abend_opnd_str(SETL_SYSTEM argv+2));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     qtrapF_instance = plugin_instance;
#endif
     qtrapF_callback.sp_form = ft_proc;
     qtrapF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)qtrapF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(qtrap(Fcallback,floatA,floatB));



}

static specifier qsimpF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type qsimpF_instance;
#endif

float qsimpF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = qsimpF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = qsimpF_callback.sp_form;
   save_callback.sp_val.sp_biggest = qsimpF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   qsimpF_callback.sp_form = save_callback.sp_form;
   qsimpF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void QSIMP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"qsimp",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"qsimp",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"qsimp",
         abend_opnd_str(SETL_SYSTEM argv+2));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     qsimpF_instance = plugin_instance;
#endif
     qsimpF_callback.sp_form = ft_proc;
     qsimpF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)qsimpF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(qsimp(Fcallback,floatA,floatB));



}

static specifier qrombF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type qrombF_instance;
#endif

float qrombF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = qrombF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = qrombF_callback.sp_form;
   save_callback.sp_val.sp_biggest = qrombF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   qrombF_callback.sp_form = save_callback.sp_form;
   qrombF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void QROMB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"qromb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"qromb",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"qromb",
         abend_opnd_str(SETL_SYSTEM argv+2));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     qrombF_instance = plugin_instance;
#endif
     qrombF_callback.sp_form = ft_proc;
     qrombF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)qrombF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(qromb(Fcallback,floatA,floatB));



}

static specifier midpntF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type midpntF_instance;
#endif

float midpntF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = midpntF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = midpntF_callback.sp_form;
   save_callback.sp_val.sp_biggest = midpntF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   midpntF_callback.sp_form = save_callback.sp_form;
   midpntF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void MIDPNT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 
int integerN; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"midpnt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"midpnt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"midpnt",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"midpnt",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     midpntF_instance = plugin_instance;
#endif
     midpntF_callback.sp_form = ft_proc;
     midpntF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)midpntF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   integerN = (argv[3].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(midpnt(Fcallback,floatA,floatB,integerN));



}

static specifier midinfF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type midinfF_instance;
#endif

float midinfF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = midinfF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = midinfF_callback.sp_form;
   save_callback.sp_val.sp_biggest = midinfF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   midinfF_callback.sp_form = save_callback.sp_form;
   midinfF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void MIDINF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 
int integerN; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"midinf",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"midinf",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"midinf",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"midinf",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     midinfF_instance = plugin_instance;
#endif
     midinfF_callback.sp_form = ft_proc;
     midinfF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)midinfF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   integerN = (argv[3].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(midinf(Fcallback,floatA,floatB,integerN));



}

static specifier midsqlF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type midsqlF_instance;
#endif

float midsqlF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = midsqlF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = midsqlF_callback.sp_form;
   save_callback.sp_val.sp_biggest = midsqlF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   midsqlF_callback.sp_form = save_callback.sp_form;
   midsqlF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void MIDSQL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 
int integerN; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"midsql",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"midsql",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"midsql",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"midsql",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     midsqlF_instance = plugin_instance;
#endif
     midsqlF_callback.sp_form = ft_proc;
     midsqlF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)midsqlF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   integerN = (argv[3].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(midsql(Fcallback,floatA,floatB,integerN));



}

static specifier midsquF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type midsquF_instance;
#endif

float midsquF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = midsquF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = midsquF_callback.sp_form;
   save_callback.sp_val.sp_biggest = midsquF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   midsquF_callback.sp_form = save_callback.sp_form;
   midsquF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void MIDSQU(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 
int integerN; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"midsqu",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"midsqu",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"midsqu",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"midsqu",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     midsquF_instance = plugin_instance;
#endif
     midsquF_callback.sp_form = ft_proc;
     midsquF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)midsquF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   integerN = (argv[3].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(midsqu(Fcallback,floatA,floatB,integerN));



}

static specifier midexpF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type midexpF_instance;
#endif

float midexpF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = midexpF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = midexpF_callback.sp_form;
   save_callback.sp_val.sp_biggest = midexpF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   midexpF_callback.sp_form = save_callback.sp_form;
   midexpF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void MIDEXP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 
int integerN; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"midexp",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"midexp",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"midexp",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"midexp",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     midexpF_instance = plugin_instance;
#endif
     midexpF_callback.sp_form = ft_proc;
     midexpF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)midexpF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   integerN = (argv[3].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(midexp(Fcallback,floatA,floatB,integerN));



}

static specifier qgausF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type qgausF_instance;
#endif

float qgausF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = qgausF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = qgausF_callback.sp_form;
   save_callback.sp_val.sp_biggest = qgausF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   qgausF_callback.sp_form = save_callback.sp_form;
   qgausF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void QGAUS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatA; /* r */ 
float floatB; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"qgaus",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"qgaus",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"qgaus",
         abend_opnd_str(SETL_SYSTEM argv+2));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     qgausF_instance = plugin_instance;
#endif
     qgausF_callback.sp_form = ft_proc;
     qgausF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)qgausF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(qgaus(Fcallback,floatA,floatB));



}

void GAUHER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* rw */ 
struct nrmatrix * fvectW; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"gauher",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"gauher",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectX->r;

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = n;
   fvectW->p = (void*)vector(1,n);

   gauher((float *)(fvectX->p),(float *)(fvectW->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return2);



}

void GAUCOF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectA; /* rw */ 
struct nrmatrix * fvectB; /* r */ 
float floatAMU0; /* r */ 
struct nrmatrix * fvectX; /* w */ 
struct nrmatrix * fvectW; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"gaucof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"gaucof",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"gaucof",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"gaucof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"gaucof",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatAMU0 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatAMU0 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);

   n = fvectA->r;
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in gaucof (parameter 3)");

   if (fvectA->use_count!=1) 
      fvectA=nr_copy(fvectA);
   if (fvectA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectX = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectX->use_count = 0;
   fvectX->type = nr_fvect*65536+nr_type;

   fvectX->r = n;
   fvectX->p = (void*)vector(1,n);
   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = n;
   fvectW->p = (void*)vector(1,n);

   gaucof(n,(float *)(fvectA->p),(float *)(fvectB->p),floatAMU0,(float *)(fvectX->p),(float *)(fvectW->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return3);



}

void GAUJAC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* rw */ 
struct nrmatrix * fvectW; /* w */ 
float floatALF; /* r */ 
float floatBET; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"gaujac",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"gaujac",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"gaujac",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"gaujac",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[3].sp_form == ft_short)
      floatALF = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatALF = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatBET = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatBET = (float)((argv[4].sp_val.sp_real_ptr)->r_value);

   n = fvectX->r;

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = n;
   fvectW->p = (void*)vector(1,n);

   gaujac((float *)(fvectX->p),(float *)(fvectW->p),n,floatALF,floatBET);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return2);



}

void GAULAG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* rw */ 
struct nrmatrix * fvectW; /* w */ 
float floatALF; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"gaulag",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"gaulag",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"gaulag",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[3].sp_form == ft_short)
      floatALF = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatALF = (float)((argv[3].sp_val.sp_real_ptr)->r_value);

   n = fvectX->r;

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = n;
   fvectW->p = (void*)vector(1,n);

   gaulag((float *)(fvectX->p),(float *)(fvectW->p),n,floatALF);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return2);



}

void GAULEG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX1; /* r */ 
float floatX2; /* r */ 
struct nrmatrix * fvectX; /* rw */ 
struct nrmatrix * fvectW; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"gauleg",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"gauleg",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"gauleg",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatX1 = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX1 = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatX2 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX2 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"gauleg",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectX->r;

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = n;
   fvectW->p = (void*)vector(1,n);

   gauleg(floatX1,floatX2,(float *)(fvectX->p),(float *)(fvectW->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return2);



}

void ORTHOG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectANU; /* r */ 
struct nrmatrix * fvectALPHA; /* r */ 
struct nrmatrix * fvectBETA; /* r */ 
struct nrmatrix * fvectA; /* rw */ 
struct nrmatrix * fvectB; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fvectANU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectANU->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectALPHA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectALPHA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectBETA = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectBETA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectA = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+3));

   fvectB = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fvectB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",5,"orthog",
         abend_opnd_str(SETL_SYSTEM argv+4));


   n = fvectANU->r;
   if (n != fvectALPHA->r)
      abend(SETL_SYSTEM "Wrong first dimension in orthog (parameter 3)");
   if (n != fvectBETA->r)
      abend(SETL_SYSTEM "Wrong first dimension in orthog (parameter 4)");
   if (n != fvectA->r)
      abend(SETL_SYSTEM "Wrong first dimension in orthog (parameter 5)");
   if (n != fvectB->r)
      abend(SETL_SYSTEM "Wrong first dimension in orthog (parameter 6)");

   if (fvectA->use_count!=1) 
      fvectA=nr_copy(fvectA);
   if (fvectA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectB->use_count!=1) 
      fvectB=nr_copy(fvectB);
   if (fvectB==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   orthog(n,(float *)(fvectANU->p),(float *)(fvectALPHA->p),(float *)(fvectBETA->p),(float *)(fvectA->p),(float *)(fvectB->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectB;
   push_pstack(&return2);



}

void PYTHAG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"pythag",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"pythag",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(pythag(floatA,floatB));



}

void DPYTHAG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
double doubleA; /* r */ 
double doubleB; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"dpythag",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"dpythag",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      doubleA = (double)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      doubleA = (double)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      doubleB = (double)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      doubleB = (double)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(dpythag(doubleA,doubleB));



}

void CHEBEV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 
struct nrmatrix * fvectC; /* r */ 
float floatX; /* r */ 

/* Variables used to compute the array bounds */

long n;



   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"chebev",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"chebev",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"chebev",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"chebev",
         abend_opnd_str(SETL_SYSTEM argv+3));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectC = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"chebev",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form == ft_short)
      floatX = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatX = (float)((argv[3].sp_val.sp_real_ptr)->r_value);

   n = fvectC->r;


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(chebev(floatA,floatB,(((float *)(fvectC->p)) + 1),n-1,floatX));



}

static specifier chebftFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type chebftFUNC_instance;
#endif

float chebftFUNC_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = chebftFUNC_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = chebftFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = chebftFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   chebftFUNC_callback.sp_form = save_callback.sp_form;
   chebftFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void CHEBFT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 
struct nrmatrix * fvectC; /* rw */ 
void *FUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"chebft",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"chebft",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"chebft",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"chebft",
         abend_opnd_str(SETL_SYSTEM argv+3));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectC = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"chebft",
         abend_opnd_str(SETL_SYSTEM argv+2));

  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     chebftFUNC_instance = plugin_instance;
#endif
     chebftFUNC_callback.sp_form = ft_proc;
     chebftFUNC_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)chebftFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectC->r;

   if (fvectC->use_count!=1) 
      fvectC=nr_copy(fvectC);
   if (fvectC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   chebft(floatA,floatB,(((float *)(fvectC->p)) + 1),n-1,FUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectC;
   push_pstack(&return1);



}

void CHDER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 
struct nrmatrix * fvectC; /* r */ 
struct nrmatrix * fvectCDER; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"chder",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"chder",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"chder",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectC = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"chder",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectC->r;

   fvectCDER = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectCDER->use_count = 0;
   fvectCDER->type = nr_fvect*65536+nr_type;

   fvectCDER->r = n;
   fvectCDER->p = (void*)vector(1,n);

   chder(floatA,floatB,(((float *)(fvectC->p)) + 1),(((float *)(fvectCDER->p)) + 1),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectCDER;
   push_pstack(&return1);



}

void CHINT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 
struct nrmatrix * fvectC; /* r */ 
struct nrmatrix * fvectCINT; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"chint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"chint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"chint",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectC = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"chint",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectC->r;

   fvectCINT = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectCINT->use_count = 0;
   fvectCINT->type = nr_fvect*65536+nr_type;

   fvectCINT->r = n;
   fvectCINT->p = (void*)vector(1,n);

   chint(floatA,floatB,(((float *)(fvectC->p)) + 1),(((float *)(fvectCINT->p)) + 1),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectCINT;
   push_pstack(&return1);



}

void CHEBPC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectC; /* r */ 
struct nrmatrix * fvectD; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"chebpc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectC = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"chebpc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectC->r;

   fvectD = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectD->use_count = 0;
   fvectD->type = nr_fvect*65536+nr_type;

   fvectD->r = n;
   fvectD->p = (void*)vector(1,n);

   chebpc((((float *)(fvectC->p)) + 1),(((float *)(fvectD->p)) + 1),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void PCSHFT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 
struct nrmatrix * fvectD; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"pcshft",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"pcshft",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"pcshft",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectD = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"pcshft",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectD->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   pcshft(floatA,floatB,(((float *)(fvectD->p)) + 1),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void PCCHEB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* r */ 
struct nrmatrix * fvectC; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"pccheb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"pccheb",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"pccheb",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectC = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"pccheb",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectD->r;
   if (n != fvectC->r)
      abend(SETL_SYSTEM "Wrong first dimension in pccheb (parameter 3)");

   if (fvectC->use_count!=1) 
      fvectC=nr_copy(fvectC);
   if (fvectC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   pccheb((((float *)(fvectD->p)) + 1),(((float *)(fvectC->p)) + 1),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectC;
   push_pstack(&return1);



}

void PADE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectCOF; /* rw */ 
float floatRESID; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"pade",
         abend_opnd_str(SETL_SYSTEM argv+0));


   dvectCOF = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectCOF->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"pade",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = dvectCOF->r;

   if (dvectCOF->use_count!=1) 
      dvectCOF=nr_copy(dvectCOF);
   if (dvectCOF==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   pade((((double *)(dvectCOF->p)) + 1),n/2,&floatRESID);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectCOF;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatRESID);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

static specifier ratlsqFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type ratlsqFUNC_instance;
#endif

double ratlsqFUNC_c_callback(double p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = ratlsqFUNC_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = ratlsqFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = ratlsqFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   ratlsqFUNC_callback.sp_form = save_callback.sp_form;
   ratlsqFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (double)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (double)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void RATLSQ(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *FUNCcallback;
double doubleA; /* r */ 
double doubleB; /* r */ 
int integerKK; /* r */ 
struct nrmatrix * dvectCOF; /* r */ 
double doubleDEV; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"ratlsq",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"ratlsq",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"ratlsq",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"ratlsq",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"ratlsq",
         abend_opnd_str(SETL_SYSTEM argv+4));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     ratlsqFUNC_instance = plugin_instance;
#endif
     ratlsqFUNC_callback.sp_form = ft_proc;
     ratlsqFUNC_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)ratlsqFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      doubleA = (double)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      doubleA = (double)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      doubleB = (double)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      doubleB = (double)((argv[2].sp_val.sp_real_ptr)->r_value);
   integerKK = (argv[3].sp_val.sp_short_value);

   dvectCOF = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((dvectCOF->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",5,"ratlsq",
         abend_opnd_str(SETL_SYSTEM argv+4));


   n = dvectCOF->r;


   ratlsq(FUNCcallback,doubleA,doubleB,n-integerKK-1,integerKK,(((double *)(dvectCOF->p)) + 1),&doubleDEV);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(doubleDEV);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);



}

void EULSUM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatSUM; /* rw */ 
float floatTERM; /* r */ 
int integerJTERM; /* r */ 
struct nrmatrix * fvectWKSP; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"eulsum",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"eulsum",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"eulsum",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"eulsum",
         abend_opnd_str(SETL_SYSTEM argv+3));


   if (argv[0].sp_form == ft_short)
      floatSUM = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatSUM = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatTERM = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatTERM = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   integerJTERM = (argv[2].sp_val.sp_short_value);

   fvectWKSP = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectWKSP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"eulsum",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fvectWKSP->r;

   if (fvectWKSP->use_count!=1) 
      fvectWKSP=nr_copy(fvectWKSP);
   if (fvectWKSP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   eulsum(&floatSUM,floatTERM,integerJTERM,fvectWKSP->p                                                     );

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatSUM);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectWKSP;
   push_pstack(&return2);



}

void DDPOLY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectC; /* r */ 
double doubleX; /* r */ 
struct nrmatrix * fvectPD; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ddpoly",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"ddpoly",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectC = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ddpoly",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      doubleX = (double)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      doubleX = (double)((argv[1].sp_val.sp_real_ptr)->r_value);

   n = fvectC->r;

   fvectPD = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectPD->use_count = 0;
   fvectPD->type = nr_fvect*65536+nr_type;

   fvectPD->r = n;
   fvectPD->p = (void*)vector(1,n);

   ddpoly((((float *)(fvectC->p)) + 1),n-1,doubleX,(((float *)(fvectPD->p)) + 1),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectPD;
   push_pstack(&return1);



}

void POLDIV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectU; /* r */ 
struct nrmatrix * fvectV; /* r */ 
struct nrmatrix * fvectQ; /* w */ 
struct nrmatrix * fvectR; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"poldiv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"poldiv",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectU->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"poldiv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectV = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectV->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"poldiv",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectU->r;
   m = fvectV->r;

   fvectQ = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectQ->use_count = 0;
   fvectQ->type = nr_fvect*65536+nr_type;

   fvectQ->r = n;
   fvectQ->p = (void*)vector(1,n);
   fvectR = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectR->use_count = 0;
   fvectR->type = nr_fvect*65536+nr_type;

   fvectR->r = n;
   fvectR->p = (void*)vector(1,n);

   poldiv((((float *)(fvectU->p)) + 1),n-1,(((float *)(fvectV->p)) + 1),m-1,(((float *)(fvectQ->p)) + 1),(((float *)(fvectR->p)) + 1));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectQ;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectR;
   push_pstack(&return2);



}

static specifier dfridrFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type dfridrFUNC_instance;
#endif

float dfridrFUNC_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = dfridrFUNC_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = dfridrFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = dfridrFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   dfridrFUNC_callback.sp_form = save_callback.sp_form;
   dfridrFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void DFRIDR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *FUNCcallback;
float floatX; /* r */ 
float floatH; /* r */ 
float floatERR; /* w */ 

specifier return1;

   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"dfridr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"dfridr",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"dfridr",
         abend_opnd_str(SETL_SYSTEM argv+2));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     dfridrFUNC_instance = plugin_instance;
#endif
     dfridrFUNC_callback.sp_form = ft_proc;
     dfridrFUNC_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)dfridrFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatH = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatH = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(dfridr(FUNCcallback,floatX,floatH,&floatERR));

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatERR);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);



}

void BESCHB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
double doubleX; /* r */ 
double doubleGAM1; /* w */ 
double doubleGAM2; /* w */ 
double doubleGAMpl; /* w */ 
double doubleGAMmi; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"beschb",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      doubleX = (double)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      doubleX = (double)((argv[0].sp_val.sp_real_ptr)->r_value);



   beschb(doubleX,&doubleGAM1,&doubleGAM2,&doubleGAMpl,&doubleGAMmi);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(doubleGAM1);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(doubleGAM2);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(doubleGAMpl);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(doubleGAMmi);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void BESSI0(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessi0",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessi0(floatX));



}

void BESSK0(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessk0",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessk0(floatX));



}

void BESSI1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessi1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessi1(floatX));



}

void BESSK1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessk1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessk1(floatX));



}

void BESSI(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 
float floatX; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"bessi",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"bessi",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerN = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessi(integerN,floatX));



}

void BESSK(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 
float floatX; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"bessk",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"bessk",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerN = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessk(integerN,floatX));



}

void BESSIK(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatXNU; /* r */ 
float floatRI; /* w */ 
float floatRK; /* w */ 
float floatRIP; /* w */ 
float floatRKP; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessik",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"bessik",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatXNU = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatXNU = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   bessik(floatX,floatXNU,&floatRI,&floatRK,&floatRIP,&floatRKP);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatRI);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatRK);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatRIP);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatRKP);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void BESSJ0(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessj0",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessj0(floatX));



}

void BESSY0(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessy0",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessy0(floatX));



}

void BESSJ1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessj1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessj1(floatX));



}

void BESSY1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessy1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessy1(floatX));



}

void BESSJ(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 
float floatX; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"bessj",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"bessj",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerN = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessj(integerN,floatX));



}

void BESSY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 
float floatX; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"bessy",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"bessy",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerN = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bessy(integerN,floatX));



}

void BESSJY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatXNU; /* r */ 
float floatRJ; /* w */ 
float floatRY; /* w */ 
float floatRJp; /* w */ 
float floatRYp; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bessjy",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"bessjy",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatXNU = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatXNU = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   bessjy(floatX,floatXNU,&floatRJ,&floatRY,&floatRJp,&floatRYp);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatRJ);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatRY);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatRJp);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatRYp);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void BETAI(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"betai",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"betai",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"betai",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(betai(floatA,floatB,floatX));



}

void BETACF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"betacf",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"betacf",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"betacf",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(betacf(floatA,floatB,floatX));



}

void BICO(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 
int integerK; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"bico",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"bico",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerN = (argv[0].sp_val.sp_short_value);

   integerK = (argv[1].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bico(integerN,integerK));



}

void DAWSON(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"dawson",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(dawson(floatX));



}

void EI(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"ei",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(ei(floatX));



}

void ELLF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatPHI; /* r */ 
float floatAK; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"ellf",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"ellf",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatPHI = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatPHI = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatAK = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatAK = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(ellf(floatPHI,floatAK));



}

void ELLE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatPHI; /* r */ 
float floatAK; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"elle",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"elle",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatPHI = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatPHI = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatAK = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatAK = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(elle(floatPHI,floatAK));



}

void ELLPI(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatPHI; /* r */ 
float floatEN; /* r */ 
float floatAK; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"ellpi",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"ellpi",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"ellpi",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatPHI = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatPHI = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatEN = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatEN = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatAK = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatAK = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(ellpi(floatPHI,floatEN,floatAK));



}

void ERFF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"erff",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(erff(floatX));



}

void ERFFC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"erffc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(erffc(floatX));



}

void ERFCC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"erfcc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(erfcc(floatX));



}

void EXPINT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerNR; /* r */ 
float floatX; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"expint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"expint",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerNR = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(expint(integerNR,floatX));



}

void FACTRL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"factrl",
         abend_opnd_str(SETL_SYSTEM argv+0));


   integerN = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(factrl(integerN));



}

void FACTLN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"factln",
         abend_opnd_str(SETL_SYSTEM argv+0));


   integerN = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(factln(integerN));



}

void BETA(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatZ; /* r */ 
float floatW; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"beta",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"beta",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatZ = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatZ = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatW = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatW = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(beta(floatZ,floatW));



}

void GAMMP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"gammp",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"gammp",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(gammp(floatA,floatX));



}

void GAMMQ(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"gammq",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"gammq",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(gammq(floatA,floatX));



}

void GAMMLN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatXX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"gammln",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatXX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatXX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(gammln(floatXX));



}

void GSER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatGAMSER; /* w */ 
float floatA; /* r */ 
float floatX; /* r */ 
float floatGLN; /* w */ 

specifier return1;
specifier return2;

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"gser",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"gser",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   gser(&floatGAMSER,floatA,floatX,&floatGLN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatGAMSER);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatGLN);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void GCF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatGAMMCF; /* w */ 
float floatA; /* r */ 
float floatX; /* r */ 
float floatGLN; /* w */ 

specifier return1;
specifier return2;

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"gcf",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"gcf",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   gcf(&floatGAMMCF,floatA,floatX,&floatGLN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatGAMMCF);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatGLN);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void RF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatY; /* r */ 
float floatZ; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"rf",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"rf",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rf",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatY = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatY = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatZ = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatZ = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(rf(floatX,floatY,floatZ));



}

void RJ(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatY; /* r */ 
float floatZ; /* r */ 
float floatP; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"rj",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"rj",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rj",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"rj",
         abend_opnd_str(SETL_SYSTEM argv+3));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatY = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatY = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatZ = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatZ = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatP = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatP = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(rj(floatX,floatY,floatZ,floatP));



}

void RC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatY; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"rc",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"rc",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatY = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatY = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(rc(floatX,floatY));



}

void AIRY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatAI; /* w */ 
float floatBI; /* w */ 
float floatAIP; /* w */ 
float floatBIP; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"airy",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   airy(floatX,&floatAI,&floatBI,&floatAIP,&floatBIP);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatAI);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatBI);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatAIP);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatBIP);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void CISI(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatCI; /* w */ 
float floatSI; /* w */ 

specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"cisi",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   cisi(floatX,&floatCI,&floatSI);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatCI);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatSI);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void PLGNDR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerL; /* r */ 
int integerM; /* r */ 
float floatX; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"plgndr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"plgndr",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"plgndr",
         abend_opnd_str(SETL_SYSTEM argv+2));


   integerL = (argv[0].sp_val.sp_short_value);

   integerM = (argv[1].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(plgndr(integerL,integerM,floatX));



}

void SPHBES(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 
float floatX; /* r */ 
float floatSJ; /* w */ 
float floatSY; /* w */ 
float floatSJP; /* w */ 
float floatSYP; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"sphbes",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"sphbes",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerN = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   sphbes(integerN,floatX,&floatSJ,&floatSY,&floatSJP,&floatSYP);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatSJ);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatSY);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatSJP);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatSYP);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void FRENEL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatS; /* w */ 
float floatC; /* w */ 

specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"frenel",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   frenel(floatX,&floatS,&floatC);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatS);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatC);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void SNCNDN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatUU; /* r */ 
float floatEMMC; /* r */ 
float floatSN; /* w */ 
float floatCN; /* w */ 
float floatDN; /* w */ 

specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"sncndn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"sncndn",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatUU = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatUU = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatEMMC = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatEMMC = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   sncndn(floatUU,floatEMMC,&floatSN,&floatCN,&floatDN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatSN);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatCN);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatDN);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void RAN0(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
long longIDUM; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"ran0",
         abend_opnd_str(SETL_SYSTEM argv+0));


   longIDUM = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(ran0(&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void RAN1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
long longIDUM; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"ran1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   longIDUM = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(ran1(&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void RAN2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
long longIDUM; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"ran2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   longIDUM = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(ran2(&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void RAN3(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
long longIDUM; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"ran3",
         abend_opnd_str(SETL_SYSTEM argv+0));


   longIDUM = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(ran3(&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void RAN4(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
long longIDUM; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"ran4",
         abend_opnd_str(SETL_SYSTEM argv+0));


   longIDUM = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(ran4(&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void EXPDEV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
long longIDUM; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"expdev",
         abend_opnd_str(SETL_SYSTEM argv+0));


   longIDUM = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(expdev(&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void GASDEV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
long longIDUM; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"gasdev",
         abend_opnd_str(SETL_SYSTEM argv+0));


   longIDUM = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(gasdev(&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void GAMDEV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerIA; /* r */ 
long longIDUM; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"gamdev",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"gamdev",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerIA = (argv[0].sp_val.sp_short_value);

   longIDUM = (argv[1].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(gamdev(integerIA,&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void POIDEV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatXM; /* r */ 
long longIDUM; /* rw */ 

specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"poidev",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"poidev",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatXM = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatXM = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   longIDUM = (argv[1].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(poidev(floatXM,&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void BNLDEV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatPP; /* r */ 
int integerN; /* r */ 
long longIDUM; /* rw */ 

specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"bnldev",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"bnldev",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"bnldev",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatPP = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatPP = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   integerN = (argv[1].sp_val.sp_short_value);

   longIDUM = (argv[2].sp_val.sp_short_value);




   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(bnldev(floatPP,integerN,&longIDUM));

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longIDUM;

   push_pstack(&return1);



}

void IRBIT1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
unsigned long ulongISEED; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"irbit1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   ulongISEED = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = 
       (int32)irbit1(&ulongISEED);

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)ulongISEED;

   push_pstack(&return1);



}

void IRBIT2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
unsigned long ulongISEED; /* rw */ 

specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"irbit2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   ulongISEED = (argv[0].sp_val.sp_short_value);




   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = 
       (int32)irbit2(&ulongISEED);

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)ulongISEED;

   push_pstack(&return1);



}

void PSDES(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
unsigned long ulongILWORD; /* rw */ 
unsigned long ulongIRWORD; /* rw */ 

specifier return1;
specifier return2;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"psdes",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"psdes",
         abend_opnd_str(SETL_SYSTEM argv+1));


   ulongILWORD = (argv[0].sp_val.sp_short_value);

   ulongIRWORD = (argv[1].sp_val.sp_short_value);




   psdes(&ulongILWORD,&ulongIRWORD);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)ulongILWORD;

   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)ulongIRWORD;

   push_pstack(&return2);



}

void RANPT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectPT; /* rw */ 
struct nrmatrix * fvectREGN; /* r */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ranpt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"ranpt",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectPT = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectPT->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ranpt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectREGN = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectREGN->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"ranpt",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectPT->r;
   m = fvectREGN->r;

   if (fvectPT->use_count!=1) 
      fvectPT=nr_copy(fvectPT);
   if (fvectPT==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   ranpt((float *)(fvectPT->p),(float *)(fvectREGN->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectPT;
   push_pstack(&return1);



}

void REBIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatRC; /* r */ 
struct nrmatrix * fvectR; /* r */ 
struct nrmatrix * fvectXIN; /* rw */ 
struct nrmatrix * fvectXI; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"rebin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"rebin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"rebin",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"rebin",
         abend_opnd_str(SETL_SYSTEM argv+3));


   if (argv[0].sp_form == ft_short)
      floatRC = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatRC = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   fvectR = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"rebin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectXIN = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectXIN->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"rebin",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectXI = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectXI->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"rebin",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fvectR->r;
   if (n != fvectXIN->r)
      abend(SETL_SYSTEM "Wrong first dimension in rebin (parameter 4)");
   if (n != fvectXI->r)
      abend(SETL_SYSTEM "Wrong first dimension in rebin (parameter 5)");

   if (fvectXIN->use_count!=1) 
      fvectXIN=nr_copy(fvectXIN);
   if (fvectXIN==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectXI->use_count!=1) 
      fvectXI=nr_copy(fvectXI);
   if (fvectXI==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   rebin(floatRC,n,(float *)(fvectR->p),(float *)(fvectXIN->p),(float *)(fvectXI->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectXIN;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectXI;
   push_pstack(&return2);



}

void NRSOBSEQ(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* rw */ 
struct nrmatrix * fvectX; /* rw */ 

/* Variables used to compute the array bounds */

long m;


specifier return1;
specifier return2;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"nrsobseq",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"nrsobseq",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerN = (argv[0].sp_val.sp_short_value);

   fvectX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"nrsobseq",
         abend_opnd_str(SETL_SYSTEM argv+1));


   m = fvectX->r;

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   nrsobseq(&integerN,(float *)(fvectX->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerN;

   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return2);



}

static specifier vegasFXN_callback;
#ifndef TUNSAFE
plugin_item_ptr_type vegasFXN_instance;
#endif

float vegasFXN_c_callback(float  p1[],float p2)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = vegasFXN_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p2;
   push_pstack(&spare);

   save_callback.sp_form = vegasFXN_callback.sp_form;
   save_callback.sp_val.sp_biggest = vegasFXN_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   vegasFXN_callback.sp_form = save_callback.sp_form;
   vegasFXN_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void VEGAS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectREGN; /* r */ 
void *FXNcallback;
int integerINIT; /* r */ 
unsigned long ulongNCALL; /* r */ 
int integerITMX; /* r */ 
int integerNPRN; /* r */ 
float floatTGRAL; /* w */ 
float floatSD; /* w */ 
float floatCHI2A; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"vegas",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (((argv[1].sp_form != ft_opaque)||
          (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[1].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[1].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",2,"vegas",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"vegas",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"vegas",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"vegas",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (argv[5].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",6,"vegas",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectREGN = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectREGN->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"vegas",
         abend_opnd_str(SETL_SYSTEM argv+0));

  if (argv[1].sp_form == ft_proc) {
#ifndef TUNSAFE
     vegasFXN_instance = plugin_instance;
#endif
     vegasFXN_callback.sp_form = ft_proc;
     vegasFXN_callback.sp_val.sp_proc_ptr = argv[1].sp_val.sp_proc_ptr;

     FXNcallback = (void*)vegasFXN_c_callback;
  } else {
     FXNcallback = 
         (void *)(((struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr))->p);
  }
   integerINIT = (argv[2].sp_val.sp_short_value);

   ulongNCALL = (argv[3].sp_val.sp_short_value);

   integerITMX = (argv[4].sp_val.sp_short_value);

   integerNPRN = (argv[5].sp_val.sp_short_value);


   n = fvectREGN->r;


   vegas((float *)(fvectREGN->p),n/2,FXNcallback,integerINIT,ulongNCALL,integerITMX,integerNPRN,&floatTGRAL,&floatSD,&floatCHI2A);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatTGRAL);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatSD);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatCHI2A);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

static specifier miserFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type miserFUNC_instance;
#endif

float miserFUNC_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = miserFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = miserFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = miserFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   miserFUNC_callback.sp_form = save_callback.sp_form;
   miserFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void MISER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *FUNCcallback;
struct nrmatrix * fvectREGN; /* r */ 
unsigned long ulongNPTS; /* r */ 
float floatDITH; /* r */ 
float floatAVE; /* w */ 
float floatVAR; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"miser",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"miser",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"miser",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"miser",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     miserFUNC_instance = plugin_instance;
#endif
     miserFUNC_callback.sp_form = ft_proc;
     miserFUNC_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)miserFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   fvectREGN = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectREGN->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"miser",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ulongNPTS = (argv[2].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_short)
      floatDITH = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatDITH = (float)((argv[3].sp_val.sp_real_ptr)->r_value);

   n = fvectREGN->r;


   miser(FUNCcallback,(float *)(fvectREGN->p),n/2,ulongNPTS,floatDITH,&floatAVE,&floatVAR);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatAVE);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatVAR);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void PIKSRT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectARR; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"piksrt",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectARR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectARR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"piksrt",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectARR->r;

   if (fvectARR->use_count!=1) 
      fvectARR=nr_copy(fvectARR);
   if (fvectARR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   piksrt(n,(float *)(fvectARR->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectARR;
   push_pstack(&return1);



}

void PIKSR2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectARR; /* rw */ 
struct nrmatrix * fvectBRR; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"piksr2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"piksr2",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectARR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectARR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"piksr2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectBRR = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectBRR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"piksr2",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectARR->r;
   if (n != fvectBRR->r)
      abend(SETL_SYSTEM "Wrong first dimension in piksr2 (parameter 3)");

   if (fvectARR->use_count!=1) 
      fvectARR=nr_copy(fvectARR);
   if (fvectARR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectBRR->use_count!=1) 
      fvectBRR=nr_copy(fvectBRR);
   if (fvectBRR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   piksr2(n,(float *)(fvectARR->p),(float *)(fvectBRR->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectARR;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectBRR;
   push_pstack(&return2);



}

void SHELL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectA; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"shell",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"shell",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectA->r;

   if (fvectA->use_count!=1) 
      fvectA=nr_copy(fvectA);
   if (fvectA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   shell(n,(float *)(fvectA->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return1);



}

void SORT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectARR; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sort",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectARR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectARR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sort",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectARR->r;

   if (fvectARR->use_count!=1) 
      fvectARR=nr_copy(fvectARR);
   if (fvectARR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sort(n,(float *)(fvectARR->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectARR;
   push_pstack(&return1);



}

void SORT2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectARR; /* rw */ 
struct nrmatrix * fvectBRR; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sort2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"sort2",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectARR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectARR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sort2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectBRR = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectBRR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"sort2",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectARR->r;
   if (n != fvectBRR->r)
      abend(SETL_SYSTEM "Wrong first dimension in sort2 (parameter 3)");

   if (fvectARR->use_count!=1) 
      fvectARR=nr_copy(fvectARR);
   if (fvectARR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectBRR->use_count!=1) 
      fvectBRR=nr_copy(fvectBRR);
   if (fvectBRR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sort2(n,(float *)(fvectARR->p),(float *)(fvectBRR->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectARR;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectBRR;
   push_pstack(&return2);



}

void SORT3(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectRA; /* rw */ 
struct nrmatrix * fvectRB; /* rw */ 
struct nrmatrix * fvectRC; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sort3",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"sort3",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"sort3",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectRA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectRA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sort3",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectRB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectRB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"sort3",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectRC = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectRC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"sort3",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectRA->r;
   if (n != fvectRB->r)
      abend(SETL_SYSTEM "Wrong first dimension in sort3 (parameter 3)");
   if (n != fvectRC->r)
      abend(SETL_SYSTEM "Wrong first dimension in sort3 (parameter 4)");

   if (fvectRA->use_count!=1) 
      fvectRA=nr_copy(fvectRA);
   if (fvectRA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectRB->use_count!=1) 
      fvectRB=nr_copy(fvectRB);
   if (fvectRB==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectRC->use_count!=1) 
      fvectRC=nr_copy(fvectRC);
   if (fvectRC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sort3(n,(float *)(fvectRA->p),(float *)(fvectRB->p),(float *)(fvectRC->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectRA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectRB;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectRC;
   push_pstack(&return3);



}

void HPSORT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectRA; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"hpsort",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectRA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectRA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"hpsort",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectRA->r;

   if (fvectRA->use_count!=1) 
      fvectRA=nr_copy(fvectRA);
   if (fvectRA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   hpsort(n,(float *)(fvectRA->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectRA;
   push_pstack(&return1);



}

void INDEXX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectARR; /* rw */ 
struct nrmatrix * ulvectINDX; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"indexx",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"indexx",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectARR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectARR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"indexx",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectINDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectINDX->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"indexx",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectARR->r;
   if (n != ulvectINDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in indexx (parameter 3)");

   if (fvectARR->use_count!=1) 
      fvectARR=nr_copy(fvectARR);
   if (fvectARR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (ulvectINDX->use_count!=1) 
      ulvectINDX=nr_copy(ulvectINDX);
   if (ulvectINDX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   indexx(n,(float *)(fvectARR->p),(unsigned long *)(ulvectINDX->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectARR;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ulvectINDX;
   push_pstack(&return2);



}

void RANK(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * ulvectINDX; /* r */ 
struct nrmatrix * ulvectIRANK; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rank",
         abend_opnd_str(SETL_SYSTEM argv+0));


   ulvectINDX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((ulvectINDX->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",1,"rank",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = ulvectINDX->r;

   ulvectIRANK = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   ulvectIRANK->use_count = 0;
   ulvectIRANK->type = nr_ulvect*65536+nr_type;

   ulvectIRANK->r = n;
   ulvectIRANK->p = (void*)lvector(1,n);

   rank(n,(unsigned long *)(ulvectINDX->p),(unsigned long *)(ulvectIRANK->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ulvectIRANK;
   push_pstack(&return1);



}

void NSELECT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerK; /* r */ 
struct nrmatrix * fvectARR; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"nselect",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"nselect",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerK = (argv[0].sp_val.sp_short_value);

   fvectARR = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectARR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"nselect",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectARR->r;

   if (fvectARR->use_count!=1) 
      fvectARR=nr_copy(fvectARR);
   if (fvectARR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(nselect(integerK,n,(float *)(fvectARR->p)));

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectARR;
   push_pstack(&return1);



}

void SELIP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerK; /* r */ 
struct nrmatrix * fvectARR; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"selip",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"selip",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerK = (argv[0].sp_val.sp_short_value);

   fvectARR = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectARR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"selip",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectARR->r;

   if (fvectARR->use_count!=1) 
      fvectARR=nr_copy(fvectARR);
   if (fvectARR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(selip(integerK,n,(float *)(fvectARR->p)));

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectARR;
   push_pstack(&return1);



}

void HPSEL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectARR; /* rw */ 
struct nrmatrix * fvectHEAP; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"hpsel",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"hpsel",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectARR = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectARR->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"hpsel",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectHEAP = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectHEAP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"hpsel",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectARR->r;
   m = fvectHEAP->r;

   if (fvectARR->use_count!=1) 
      fvectARR=nr_copy(fvectARR);
   if (fvectARR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectHEAP->use_count!=1) 
      fvectHEAP=nr_copy(fvectHEAP);
   if (fvectHEAP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   hpsel(m,n,(float *)(fvectARR->p),(float *)(fvectHEAP->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectARR;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectHEAP;
   push_pstack(&return2);



}

void ECLASS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * ivectNF; /* rw */ 
struct nrmatrix * ivectLISTA; /* rw */ 
struct nrmatrix * ivectLISTB; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"eclass",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"eclass",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"eclass",
         abend_opnd_str(SETL_SYSTEM argv+2));


   ivectNF = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((ivectNF->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",1,"eclass",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ivectLISTA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ivectLISTA->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",2,"eclass",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ivectLISTB = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((ivectLISTB->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",3,"eclass",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = ivectNF->r;
   m = ivectLISTA->r;
   if (m != ivectLISTB->r)
      abend(SETL_SYSTEM "Wrong first dimension in eclass (parameter 4)");

   if (ivectNF->use_count!=1) 
      ivectNF=nr_copy(ivectNF);
   if (ivectNF==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (ivectLISTA->use_count!=1) 
      ivectLISTA=nr_copy(ivectLISTA);
   if (ivectLISTA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (ivectLISTB->use_count!=1) 
      ivectLISTB=nr_copy(ivectLISTB);
   if (ivectLISTB==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   eclass((int *)(ivectNF->p),n,(int *)(ivectLISTA->p),(int *)(ivectLISTB->p),m);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectNF;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectLISTA;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectLISTB;
   push_pstack(&return3);



}

static specifier eclazzEQUIV_callback;
#ifndef TUNSAFE
plugin_item_ptr_type eclazzEQUIV_instance;
#endif

int eclazzEQUIV_c_callback(int p1,int p2)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = eclazzEQUIV_instance;
   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p2;
   push_pstack(&spare);

   save_callback.sp_form = eclazzEQUIV_callback.sp_form;
   save_callback.sp_val.sp_biggest = eclazzEQUIV_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   eclazzEQUIV_callback.sp_form = save_callback.sp_form;
   eclazzEQUIV_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (int)(spare.sp_val.sp_short_value);
   }
}

void ECLAZZ(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * ivectNF; /* rw */ 
void *EQUIVcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"eclazz",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (((argv[1].sp_form != ft_opaque)||
          (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[1].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[1].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",2,"eclazz",
         abend_opnd_str(SETL_SYSTEM argv+1));


   ivectNF = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((ivectNF->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",1,"eclazz",
         abend_opnd_str(SETL_SYSTEM argv+0));

  if (argv[1].sp_form == ft_proc) {
#ifndef TUNSAFE
     eclazzEQUIV_instance = plugin_instance;
#endif
     eclazzEQUIV_callback.sp_form = ft_proc;
     eclazzEQUIV_callback.sp_val.sp_proc_ptr = argv[1].sp_val.sp_proc_ptr;

     EQUIVcallback = (void*)eclazzEQUIV_c_callback;
  } else {
     EQUIVcallback = 
         (void *)(((struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr))->p);
  }

   n = ivectNF->r;

   if (ivectNF->use_count!=1) 
      ivectNF=nr_copy(ivectNF);
   if (ivectNF==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   eclazz((int *)(ivectNF->p),n,EQUIVcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectNF;
   push_pstack(&return1);



}

static specifier zbracF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type zbracF_instance;
#endif

float zbracF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = zbracF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = zbracF_callback.sp_form;
   save_callback.sp_val.sp_biggest = zbracF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   zbracF_callback.sp_form = save_callback.sp_form;
   zbracF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void ZBRAC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatX1; /* rw */ 
float floatX2; /* rw */ 

specifier return1;
specifier return2;

   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"zbrac",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"zbrac",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"zbrac",
         abend_opnd_str(SETL_SYSTEM argv+2));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     zbracF_instance = plugin_instance;
#endif
     zbracF_callback.sp_form = ft_proc;
     zbracF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)zbracF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);



   zbrac(Fcallback,&floatX1,&floatX2);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatX1);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatX2);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

static specifier rtbisF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type rtbisF_instance;
#endif

float rtbisF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = rtbisF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = rtbisF_callback.sp_form;
   save_callback.sp_val.sp_biggest = rtbisF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   rtbisF_callback.sp_form = save_callback.sp_form;
   rtbisF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void RTBIS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatXACC; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"rtbis",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"rtbis",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rtbis",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"rtbis",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     rtbisF_instance = plugin_instance;
#endif
     rtbisF_callback.sp_form = ft_proc;
     rtbisF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)rtbisF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatXACC = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatXACC = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(rtbis(Fcallback,floatX1,floatX2,floatXACC));



}

static specifier rtflspF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type rtflspF_instance;
#endif

float rtflspF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = rtflspF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = rtflspF_callback.sp_form;
   save_callback.sp_val.sp_biggest = rtflspF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   rtflspF_callback.sp_form = save_callback.sp_form;
   rtflspF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void RTFLSP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatXACC; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"rtflsp",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"rtflsp",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rtflsp",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"rtflsp",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     rtflspF_instance = plugin_instance;
#endif
     rtflspF_callback.sp_form = ft_proc;
     rtflspF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)rtflspF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatXACC = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatXACC = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(rtflsp(Fcallback,floatX1,floatX2,floatXACC));



}

static specifier rtsecF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type rtsecF_instance;
#endif

float rtsecF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = rtsecF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = rtsecF_callback.sp_form;
   save_callback.sp_val.sp_biggest = rtsecF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   rtsecF_callback.sp_form = save_callback.sp_form;
   rtsecF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void RTSEC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatXACC; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"rtsec",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"rtsec",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rtsec",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"rtsec",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     rtsecF_instance = plugin_instance;
#endif
     rtsecF_callback.sp_form = ft_proc;
     rtsecF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)rtsecF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatXACC = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatXACC = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(rtsec(Fcallback,floatX1,floatX2,floatXACC));



}

static specifier zriddrF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type zriddrF_instance;
#endif

float zriddrF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = zriddrF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = zriddrF_callback.sp_form;
   save_callback.sp_val.sp_biggest = zriddrF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   zriddrF_callback.sp_form = save_callback.sp_form;
   zriddrF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void ZRIDDR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatXACC; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"zriddr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"zriddr",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"zriddr",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"zriddr",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     zriddrF_instance = plugin_instance;
#endif
     zriddrF_callback.sp_form = ft_proc;
     zriddrF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)zriddrF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatXACC = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatXACC = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(zriddr(Fcallback,floatX1,floatX2,floatXACC));



}

static specifier zbrentF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type zbrentF_instance;
#endif

float zbrentF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = zbrentF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = zbrentF_callback.sp_form;
   save_callback.sp_val.sp_biggest = zbrentF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   zbrentF_callback.sp_form = save_callback.sp_form;
   zbrentF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void ZBRENT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatTOL; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"zbrent",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"zbrent",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"zbrent",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"zbrent",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     zbrentF_instance = plugin_instance;
#endif
     zbrentF_callback.sp_form = ft_proc;
     zbrentF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)zbrentF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatTOL = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatTOL = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(zbrent(Fcallback,floatX1,floatX2,floatTOL));



}

void ZRHQR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectP; /* r */ 
struct nrmatrix * fvectR; /* w */ 
struct nrmatrix * fvectI; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"zrhqr",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"zrhqr",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectP->r;

   fvectR = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectR->use_count = 0;
   fvectR->type = nr_fvect*65536+nr_type;

   fvectR->r = n-1;
   fvectR->p = (void*)vector(1,n-1);
   fvectI = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectI->use_count = 0;
   fvectI->type = nr_fvect*65536+nr_type;

   fvectI->r = n-1;
   fvectI->p = (void*)vector(1,n-1);

   zrhqr((((float *)(fvectP->p)) + 1),n-1,(float *)(fvectR->p),(float *)(fvectI->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectR;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectI;
   push_pstack(&return2);



}

static specifier zbrakF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type zbrakF_instance;
#endif

float zbrakF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = zbrakF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = zbrakF_callback.sp_form;
   save_callback.sp_val.sp_biggest = zbrakF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   zbrakF_callback.sp_form = save_callback.sp_form;
   zbrakF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void ZBRAK(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Fcallback;
float floatX1; /* r */ 
float floatX2; /* r */ 
struct nrmatrix * fvectXB1; /* r */ 
struct nrmatrix * fvectXB2; /* r */ 
int integerNB; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"zbrak",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"zbrak",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"zbrak",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"zbrak",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"zbrak",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (argv[5].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",6,"zbrak",
         abend_opnd_str(SETL_SYSTEM argv+5));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     zbrakF_instance = plugin_instance;
#endif
     zbrakF_callback.sp_form = ft_proc;
     zbrakF_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Fcallback = (void*)zbrakF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   fvectXB1 = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectXB1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"zbrak",
         abend_opnd_str(SETL_SYSTEM argv+3));

   fvectXB2 = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fvectXB2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",5,"zbrak",
         abend_opnd_str(SETL_SYSTEM argv+4));

   integerNB = (argv[5].sp_val.sp_short_value);


   n = fvectXB1->r;
   if (n != fvectXB2->r)
      abend(SETL_SYSTEM "Wrong first dimension in zbrak (parameter 6)");


   zbrak(Fcallback,floatX1,floatX2,n,(float *)(fvectXB1->p),(float *)(fvectXB2->p),&integerNB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerNB;

   push_pstack(&return1);



}

void QROOT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectP; /* r */ 
float floatB; /* rw */ 
float floatC; /* rw */ 
float floatEPS; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"qroot",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"qroot",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"qroot",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"qroot",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"qroot",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatC = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatC = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatEPS = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatEPS = (float)((argv[3].sp_val.sp_real_ptr)->r_value);

   n = fvectP->r;


   qroot((((float *)(fvectP->p)) + 1),n-1,&floatB,&floatC,floatEPS);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatB);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatC);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

static specifier nrmnewtUSRFUN_callback;
#ifndef TUNSAFE
plugin_item_ptr_type nrmnewtUSRFUN_instance;
#endif

void nrmnewtUSRFUN_c_callback(float  p1[],int p2,float  p3[],float  p4[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = nrmnewtUSRFUN_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p2;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p4);
   push_pstack(&spare);

   save_callback.sp_form = nrmnewtUSRFUN_callback.sp_form;
   save_callback.sp_val.sp_biggest = nrmnewtUSRFUN_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  4,YES,NO,0);
   nrmnewtUSRFUN_callback.sp_form = save_callback.sp_form;
   nrmnewtUSRFUN_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void NRMNEWT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerNTRIAL; /* r */ 
struct nrmatrix * fvectX; /* rw */ 
float floatTOLX; /* r */ 
float floatTOLF; /* r */ 
void *USRFUNcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"nrmnewt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"nrmnewt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"nrmnewt",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"nrmnewt",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (((argv[4].sp_form != ft_opaque)||
          (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[4].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[4].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",5,"nrmnewt",
         abend_opnd_str(SETL_SYSTEM argv+4));


   integerNTRIAL = (argv[0].sp_val.sp_short_value);

   fvectX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"nrmnewt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatTOLX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatTOLX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatTOLF = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatTOLF = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
  if (argv[4].sp_form == ft_proc) {
#ifndef TUNSAFE
     nrmnewtUSRFUN_instance = plugin_instance;
#endif
     nrmnewtUSRFUN_callback.sp_form = ft_proc;
     nrmnewtUSRFUN_callback.sp_val.sp_proc_ptr = argv[4].sp_val.sp_proc_ptr;

     USRFUNcallback = (void*)nrmnewtUSRFUN_c_callback;
  } else {
     USRFUNcallback = 
         (void *)(((struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectX->r;

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   nrmnewt(integerNTRIAL,(float *)(fvectX->p),n,floatTOLX,floatTOLF,USRFUNcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);



}

static specifier nrtnewtD_callback;
#ifndef TUNSAFE
plugin_item_ptr_type nrtnewtD_instance;
#endif

void nrtnewtD_c_callback(float p1,float  p2[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = nrtnewtD_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   save_callback.sp_form = nrtnewtD_callback.sp_form;
   save_callback.sp_val.sp_biggest = nrtnewtD_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   nrtnewtD_callback.sp_form = save_callback.sp_form;
   nrtnewtD_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void NRTNEWT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Dcallback;
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatXACC; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"nrtnewt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"nrtnewt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"nrtnewt",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"nrtnewt",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     nrtnewtD_instance = plugin_instance;
#endif
     nrtnewtD_callback.sp_form = ft_proc;
     nrtnewtD_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Dcallback = (void*)nrtnewtD_c_callback;
  } else {
     Dcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatXACC = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatXACC = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(nrtnewt(Dcallback,floatX1,floatX2,floatXACC));



}

static specifier nrtsafeD_callback;
#ifndef TUNSAFE
plugin_item_ptr_type nrtsafeD_instance;
#endif

void nrtsafeD_c_callback(float p1,float  p2[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = nrtsafeD_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   save_callback.sp_form = nrtsafeD_callback.sp_form;
   save_callback.sp_val.sp_biggest = nrtsafeD_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   nrtsafeD_callback.sp_form = save_callback.sp_form;
   nrtsafeD_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void NRTSAFE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *Dcallback;
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatXACC; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"nrtsafe",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"nrtsafe",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"nrtsafe",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"nrtsafe",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     nrtsafeD_instance = plugin_instance;
#endif
     nrtsafeD_callback.sp_form = ft_proc;
     nrtsafeD_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     Dcallback = (void*)nrtsafeD_c_callback;
  } else {
     Dcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatXACC = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatXACC = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(nrtsafe(Dcallback,floatX1,floatX2,floatXACC));



}

static specifier lnsrchFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type lnsrchFUNC_instance;
#endif

float lnsrchFUNC_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = lnsrchFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = lnsrchFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = lnsrchFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   lnsrchFUNC_callback.sp_form = save_callback.sp_form;
   lnsrchFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void LNSRCH(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectXOLD; /* r */ 
float floatFOLD; /* r */ 
struct nrmatrix * fvectG; /* r */ 
struct nrmatrix * fvectP; /* r */ 
struct nrmatrix * fvectX; /* w */ 
float floatF; /* w */ 
float floatSTPMAX; /* r */ 
int integerCHECK; /* w */ 
void *FUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[6].sp_form != ft_short) && (argv[6].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",7,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fvectXOLD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectXOLD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatFOLD = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatFOLD = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectG = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectG->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectP = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"lnsrch",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[6].sp_form == ft_short)
      floatSTPMAX = (float)(argv[6].sp_val.sp_short_value);

   if (argv[6].sp_form == ft_real)
      floatSTPMAX = (float)((argv[6].sp_val.sp_real_ptr)->r_value);
  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     lnsrchFUNC_instance = plugin_instance;
#endif
     lnsrchFUNC_callback.sp_form = ft_proc;
     lnsrchFUNC_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)lnsrchFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectXOLD->r;
   if (n != fvectG->r)
      abend(SETL_SYSTEM "Wrong first dimension in lnsrch (parameter 4)");
   if (n != fvectP->r)
      abend(SETL_SYSTEM "Wrong first dimension in lnsrch (parameter 5)");

   fvectX = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectX->use_count = 0;
   fvectX->type = nr_fvect*65536+nr_type;

   fvectX->r = n;
   fvectX->p = (void*)vector(1,n);

   lnsrch(n,(float *)(fvectXOLD->p),floatFOLD,(float *)(fvectG->p),(float *)(fvectP->p),(float *)(fvectX->p),&floatF,floatSTPMAX,&integerCHECK,FUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatF);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerCHECK;

   push_pstack(&return3);



}

static specifier newtVECFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type newtVECFUNC_instance;
#endif

void newtVECFUNC_c_callback(int p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = newtVECFUNC_instance;
   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = newtVECFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = newtVECFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   newtVECFUNC_callback.sp_form = save_callback.sp_form;
   newtVECFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void NEWT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* rw */ 
int integerCHECK; /* w */ 
void *VECFUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"newt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (((argv[2].sp_form != ft_opaque)||
          (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[2].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[2].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",3,"newt",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"newt",
         abend_opnd_str(SETL_SYSTEM argv+0));

  if (argv[2].sp_form == ft_proc) {
#ifndef TUNSAFE
     newtVECFUNC_instance = plugin_instance;
#endif
     newtVECFUNC_callback.sp_form = ft_proc;
     newtVECFUNC_callback.sp_val.sp_proc_ptr = argv[2].sp_val.sp_proc_ptr;

     VECFUNCcallback = (void*)newtVECFUNC_c_callback;
  } else {
     VECFUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectX->r;

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   newt((float *)(fvectX->p),n,&integerCHECK,VECFUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerCHECK;

   push_pstack(&return2);



}

static specifier fdjacVECFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type fdjacVECFUNC_instance;
#endif

void fdjacVECFUNC_c_callback(int p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = fdjacVECFUNC_instance;
   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = fdjacVECFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = fdjacVECFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   fdjacVECFUNC_callback.sp_form = save_callback.sp_form;
   fdjacVECFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void FDJAC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectFVEC; /* r */ 
struct nrmatrix * fmatDF; /* w */ 
void *VECFUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"fdjac",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"fdjac",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"fdjac",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"fdjac",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectFVEC = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectFVEC->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"fdjac",
         abend_opnd_str(SETL_SYSTEM argv+1));

  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     fdjacVECFUNC_instance = plugin_instance;
#endif
     fdjacVECFUNC_callback.sp_form = ft_proc;
     fdjacVECFUNC_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     VECFUNCcallback = (void*)fdjacVECFUNC_c_callback;
  } else {
     VECFUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectX->r;
   if (n != fvectFVEC->r)
      abend(SETL_SYSTEM "Wrong first dimension in fdjac (parameter 3)");

   fmatDF = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatDF->use_count = 0;
   fmatDF->type = nr_fmat*65536+nr_type;

   fmatDF->r = n;
   fmatDF->c = n;
   fmatDF->p = (void*)matrix(1,n,1,n);

   fdjac(n,(float *)(fvectX->p),(float *)(fvectFVEC->p),(float **)(fmatDF->p),VECFUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatDF;
   push_pstack(&return1);



}

static specifier broydnVECFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type broydnVECFUNC_instance;
#endif

void broydnVECFUNC_c_callback(int p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = broydnVECFUNC_instance;
   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = broydnVECFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = broydnVECFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   broydnVECFUNC_callback.sp_form = save_callback.sp_form;
   broydnVECFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void BROYDN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* rw */ 
int integerCHECKk; /* w */ 
void *VECFUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"broydn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (((argv[2].sp_form != ft_opaque)||
          (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[2].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[2].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",3,"broydn",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"broydn",
         abend_opnd_str(SETL_SYSTEM argv+0));

  if (argv[2].sp_form == ft_proc) {
#ifndef TUNSAFE
     broydnVECFUNC_instance = plugin_instance;
#endif
     broydnVECFUNC_callback.sp_form = ft_proc;
     broydnVECFUNC_callback.sp_val.sp_proc_ptr = argv[2].sp_val.sp_proc_ptr;

     VECFUNCcallback = (void*)broydnVECFUNC_c_callback;
  } else {
     VECFUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectX->r;

   if (fvectX->use_count!=1) 
      fvectX=nr_copy(fvectX);
   if (fvectX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   broydn((float *)(fvectX->p),n,&integerCHECKk,VECFUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectX;
   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerCHECKk;

   push_pstack(&return2);



}

static specifier mnbrakF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type mnbrakF_instance;
#endif

float mnbrakF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = mnbrakF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = mnbrakF_callback.sp_form;
   save_callback.sp_val.sp_biggest = mnbrakF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   mnbrakF_callback.sp_form = save_callback.sp_form;
   mnbrakF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void MNBRAK(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatAX; /* rw */ 
float floatBX; /* rw */ 
float floatCX; /* rw */ 
float floatFA; /* rw */ 
float floatFB; /* rw */ 
float floatFC; /* rw */ 
void *Fcallback;

specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;
specifier return6;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"mnbrak",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"mnbrak",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"mnbrak",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"mnbrak",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"mnbrak",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"mnbrak",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[6].sp_form != ft_opaque)||
          (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[6].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[6].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",7,"mnbrak",
         abend_opnd_str(SETL_SYSTEM argv+6));


   if (argv[0].sp_form == ft_short)
      floatAX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatAX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatBX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatBX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatCX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatCX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatFA = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatFA = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatFB = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatFB = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatFC = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatFC = (float)((argv[5].sp_val.sp_real_ptr)->r_value);
  if (argv[6].sp_form == ft_proc) {
#ifndef TUNSAFE
     mnbrakF_instance = plugin_instance;
#endif
     mnbrakF_callback.sp_form = ft_proc;
     mnbrakF_callback.sp_val.sp_proc_ptr = argv[6].sp_val.sp_proc_ptr;

     Fcallback = (void*)mnbrakF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr))->p);
  }



   mnbrak(&floatAX,&floatBX,&floatCX,&floatFA,&floatFB,&floatFC,Fcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatAX);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatBX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatCX);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatFA);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatFB);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);

   return6.sp_form = ft_real;
   i_get_real(return6.sp_val.sp_real_ptr);
   return6.sp_val.sp_real_ptr->r_value = (double)(floatFC);
   return6.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return6);



}

static specifier goldenF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type goldenF_instance;
#endif

float goldenF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = goldenF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = goldenF_callback.sp_form;
   save_callback.sp_val.sp_biggest = goldenF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   goldenF_callback.sp_form = save_callback.sp_form;
   goldenF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void GOLDEN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatAX; /* rw */ 
float floatBX; /* rw */ 
float floatCX; /* rw */ 
void *Fcallback;
float floatTOL; /* r */ 
float floatXMIN; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"golden",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"golden",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"golden",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"golden",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"golden",
         abend_opnd_str(SETL_SYSTEM argv+4));


   if (argv[0].sp_form == ft_short)
      floatAX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatAX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatBX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatBX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatCX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatCX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     goldenF_instance = plugin_instance;
#endif
     goldenF_callback.sp_form = ft_proc;
     goldenF_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     Fcallback = (void*)goldenF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[4].sp_form == ft_short)
      floatTOL = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatTOL = (float)((argv[4].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(golden(floatAX,floatBX,floatCX,Fcallback,floatTOL,&floatXMIN));

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatAX);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatBX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatCX);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatXMIN);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

static specifier brentF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type brentF_instance;
#endif

float brentF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = brentF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = brentF_callback.sp_form;
   save_callback.sp_val.sp_biggest = brentF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   brentF_callback.sp_form = save_callback.sp_form;
   brentF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void BRENT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatAX; /* rw */ 
float floatBX; /* rw */ 
float floatCX; /* rw */ 
void *Fcallback;
float floatTOL; /* r */ 
float floatXMIN; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"brent",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"brent",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"brent",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"brent",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"brent",
         abend_opnd_str(SETL_SYSTEM argv+4));


   if (argv[0].sp_form == ft_short)
      floatAX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatAX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatBX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatBX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatCX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatCX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     brentF_instance = plugin_instance;
#endif
     brentF_callback.sp_form = ft_proc;
     brentF_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     Fcallback = (void*)brentF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[4].sp_form == ft_short)
      floatTOL = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatTOL = (float)((argv[4].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(brent(floatAX,floatBX,floatCX,Fcallback,floatTOL,&floatXMIN));

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatAX);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatBX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatCX);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatXMIN);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

static specifier dbrentF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type dbrentF_instance;
#endif

float dbrentF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = dbrentF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = dbrentF_callback.sp_form;
   save_callback.sp_val.sp_biggest = dbrentF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   dbrentF_callback.sp_form = save_callback.sp_form;
   dbrentF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

static specifier dbrentDF_callback;
#ifndef TUNSAFE
plugin_item_ptr_type dbrentDF_instance;
#endif

float dbrentDF_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = dbrentDF_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = dbrentDF_callback.sp_form;
   save_callback.sp_val.sp_biggest = dbrentDF_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   dbrentDF_callback.sp_form = save_callback.sp_form;
   dbrentDF_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void DBRENT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatAX; /* rw */ 
float floatBX; /* rw */ 
float floatCX; /* rw */ 
void *Fcallback;
void *DFcallback;
float floatTOL; /* r */ 
float floatXMIN; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"dbrent",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"dbrent",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"dbrent",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"dbrent",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (((argv[4].sp_form != ft_opaque)||
          (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[4].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[4].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",5,"dbrent",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"dbrent",
         abend_opnd_str(SETL_SYSTEM argv+5));


   if (argv[0].sp_form == ft_short)
      floatAX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatAX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatBX = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatBX = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatCX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatCX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     dbrentF_instance = plugin_instance;
#endif
     dbrentF_callback.sp_form = ft_proc;
     dbrentF_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     Fcallback = (void*)dbrentF_c_callback;
  } else {
     Fcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[4].sp_form == ft_proc) {
#ifndef TUNSAFE
     dbrentDF_instance = plugin_instance;
#endif
     dbrentDF_callback.sp_form = ft_proc;
     dbrentDF_callback.sp_val.sp_proc_ptr = argv[4].sp_val.sp_proc_ptr;

     DFcallback = (void*)dbrentDF_c_callback;
  } else {
     DFcallback = 
         (void *)(((struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[5].sp_form == ft_short)
      floatTOL = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatTOL = (float)((argv[5].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(dbrent(floatAX,floatBX,floatCX,Fcallback,DFcallback,floatTOL,&floatXMIN));

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatAX);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatBX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatCX);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatXMIN);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void SIMPLX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
int integerM1; /* r */ 
int integerM2; /* r */ 
int integerM3; /* r */ 
int integerICASE; /* w */ 
struct nrmatrix * ivectIZROV; /* w */ 
struct nrmatrix * ivectIPOSV; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"simplx",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"simplx",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"simplx",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"simplx",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"simplx",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerM1 = (argv[1].sp_val.sp_short_value);

   integerM2 = (argv[2].sp_val.sp_short_value);

   integerM3 = (argv[3].sp_val.sp_short_value);


   m = fmatA->r;
   n = fmatA->c;

   ivectIZROV = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   ivectIZROV->use_count = 0;
   ivectIZROV->type = nr_ivect*65536+nr_type;

   ivectIZROV->r = n;
   ivectIZROV->p = (void*)ivector(1,n);
   ivectIPOSV = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   ivectIPOSV->use_count = 0;
   ivectIPOSV->type = nr_ivect*65536+nr_type;

   ivectIPOSV->r = m;
   ivectIPOSV->p = (void*)ivector(1,m);

   simplx((float **)(fmatA->p),m-2,n-1,integerM1,integerM2,integerM3,&integerICASE,(int *)(ivectIZROV->p),(int *)(ivectIPOSV->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerICASE;

   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectIZROV;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectIPOSV;
   push_pstack(&return3);



}

void SIMP1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
struct nrmatrix * ivectLL; /* r */ 
int integerIABF; /* r */ 
int integerKP; /* w */ 
float floatBMAX; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;
long k;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"simp1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"simp1",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"simp1",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"simp1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ivectLL = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ivectLL->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",2,"simp1",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerIABF = (argv[2].sp_val.sp_short_value);


   m = fmatA->r;
   n = fmatA->c;
   k = ivectLL->r;


   simp1((float **)(fmatA->p),m-1,(int *)(ivectLL->p),k,integerIABF,&integerKP,&floatBMAX);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerKP;

   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatBMAX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void SIMP2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
struct nrmatrix * ivectL2; /* rw */ 
int integerIP; /* w */ 
int integerKP; /* r */ 
float floatQ1; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;
long k;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"simp2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"simp2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"simp2",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"simp2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ivectL2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ivectL2->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",2,"simp2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerKP = (argv[3].sp_val.sp_short_value);


   m = fmatA->r;
   n = fmatA->c;
   k = ivectL2->r;

   if (ivectL2->use_count!=1) 
      ivectL2=nr_copy(ivectL2);
   if (ivectL2==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   simp2((float **)(fmatA->p),n,(int *)(ivectL2->p),k,&integerIP,integerKP,&floatQ1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectL2;
   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerIP;

   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatQ1);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void SIMP3(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* r */ 
int integerI1; /* r */ 
int integerK1; /* r */ 
int integerIP; /* r */ 
int integerKP; /* r */ 

/* Variables used to compute the array bounds */

long m;
long n;



   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"simp3",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"simp3",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"simp3",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"simp3",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"simp3",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"simp3",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerI1 = (argv[1].sp_val.sp_short_value);

   integerK1 = (argv[2].sp_val.sp_short_value);

   integerIP = (argv[3].sp_val.sp_short_value);

   integerKP = (argv[4].sp_val.sp_short_value);


   m = fmatA->r;
   n = fmatA->c;


   simp3((float **)(fmatA->p),integerI1,integerK1,integerIP,integerKP);

   unmark_specifier(target);
   target->sp_form = ft_omega;



}

static specifier linminFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type linminFUNC_instance;
#endif

float linminFUNC_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = linminFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = linminFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = linminFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   linminFUNC_callback.sp_form = save_callback.sp_form;
   linminFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void LINMIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectP; /* r */ 
struct nrmatrix * fvectXI; /* r */ 
float floatFRET; /* w */ 
void *FUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"linmin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"linmin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"linmin",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"linmin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectXI = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectXI->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"linmin",
         abend_opnd_str(SETL_SYSTEM argv+1));

  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     linminFUNC_instance = plugin_instance;
#endif
     linminFUNC_callback.sp_form = ft_proc;
     linminFUNC_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)linminFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectP->r;
   if (n != fvectXI->r)
      abend(SETL_SYSTEM "Wrong first dimension in linmin (parameter 3)");


   linmin((float *)(fvectP->p),(float *)(fvectXI->p),n,&floatFRET,FUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatFRET);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);



}

static specifier dlinminFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type dlinminFUNC_instance;
#endif

float dlinminFUNC_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = dlinminFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = dlinminFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = dlinminFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   dlinminFUNC_callback.sp_form = save_callback.sp_form;
   dlinminFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

static specifier dlinminDFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type dlinminDFUNC_instance;
#endif

void dlinminDFUNC_c_callback(float  p1[],float  p2[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = dlinminDFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   save_callback.sp_form = dlinminDFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = dlinminDFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   dlinminDFUNC_callback.sp_form = save_callback.sp_form;
   dlinminDFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void DLINMIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectP; /* r */ 
struct nrmatrix * fvectXI; /* r */ 
float floatFRET; /* w */ 
void *FUNCcallback;
void *DFUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"dlinmin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"dlinmin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"dlinmin",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (((argv[4].sp_form != ft_opaque)||
          (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[4].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[4].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",5,"dlinmin",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fvectP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"dlinmin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectXI = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectXI->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"dlinmin",
         abend_opnd_str(SETL_SYSTEM argv+1));

  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     dlinminFUNC_instance = plugin_instance;
#endif
     dlinminFUNC_callback.sp_form = ft_proc;
     dlinminFUNC_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)dlinminFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[4].sp_form == ft_proc) {
#ifndef TUNSAFE
     dlinminDFUNC_instance = plugin_instance;
#endif
     dlinminDFUNC_callback.sp_form = ft_proc;
     dlinminDFUNC_callback.sp_val.sp_proc_ptr = argv[4].sp_val.sp_proc_ptr;

     DFUNCcallback = (void*)dlinminDFUNC_c_callback;
  } else {
     DFUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectP->r;
   if (n != fvectXI->r)
      abend(SETL_SYSTEM "Wrong first dimension in dlinmin (parameter 3)");


   dlinmin((float *)(fvectP->p),(float *)(fvectXI->p),n,&floatFRET,FUNCcallback,DFUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatFRET);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);



}

void F1DIM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"f1dim",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(f1dim(floatX));



}

void DF1DIM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"df1dim",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(df1dim(floatX));



}

void METROP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatDE; /* r */ 
float floatT; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"metrop",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"metrop",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatDE = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatDE = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatT = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatT = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = 
       (int32)metrop(floatDE,floatT);



}

static specifier amoebaFUNK_callback;
#ifndef TUNSAFE
plugin_item_ptr_type amoebaFUNK_instance;
#endif

float amoebaFUNK_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = amoebaFUNK_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = amoebaFUNK_callback.sp_form;
   save_callback.sp_val.sp_biggest = amoebaFUNK_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   amoebaFUNK_callback.sp_form = save_callback.sp_form;
   amoebaFUNK_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void AMOEBA(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatP; /* rw */ 
struct nrmatrix * fvectY; /* rw */ 
float floatFTOL; /* r */ 
void *FUNKcallback;
int integerNFUNK; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"amoeba",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"amoeba",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"amoeba",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"amoeba",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fmatP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatP->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"amoeba",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"amoeba",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatFTOL = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatFTOL = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     amoebaFUNK_instance = plugin_instance;
#endif
     amoebaFUNK_callback.sp_form = ft_proc;
     amoebaFUNK_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     FUNKcallback = (void*)amoebaFUNK_c_callback;
  } else {
     FUNKcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }

   n = fmatP->r;
   m = fmatP->c;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in amoeba (parameter 3)");

   if (fmatP->use_count!=1) 
      fmatP=nr_copy(fmatP);
   if (fmatP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectY->use_count!=1) 
      fvectY=nr_copy(fvectY);
   if (fvectY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   amoeba((float **)(fmatP->p),(float *)(fvectY->p),n-1,floatFTOL,FUNKcallback,&integerNFUNK);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatP;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY;
   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerNFUNK;

   push_pstack(&return3);



}

static specifier amotryFUNK_callback;
#ifndef TUNSAFE
plugin_item_ptr_type amotryFUNK_instance;
#endif

float amotryFUNK_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = amotryFUNK_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = amotryFUNK_callback.sp_form;
   save_callback.sp_val.sp_biggest = amotryFUNK_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   amotryFUNK_callback.sp_form = save_callback.sp_form;
   amotryFUNK_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void AMOTRY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatP; /* rw */ 
struct nrmatrix * fvectY; /* rw */ 
struct nrmatrix * fvectPSUM; /* w */ 
void *FUNKcallback;
int integerIHI; /* r */ 
float floatFAC; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"amotry",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"amotry",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"amotry",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"amotry",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"amotry",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fmatP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatP->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"amotry",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"amotry",
         abend_opnd_str(SETL_SYSTEM argv+1));

  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     amotryFUNK_instance = plugin_instance;
#endif
     amotryFUNK_callback.sp_form = ft_proc;
     amotryFUNK_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     FUNKcallback = (void*)amotryFUNK_c_callback;
  } else {
     FUNKcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }
   integerIHI = (argv[4].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_short)
      floatFAC = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatFAC = (float)((argv[5].sp_val.sp_real_ptr)->r_value);

   n = fmatP->r;
   if (n-1 != fmatP->c)
      abend(SETL_SYSTEM "Wrong second dimension in amotry (parameter 2)");
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in amotry (parameter 3)");

   if (fmatP->use_count!=1) 
      fmatP=nr_copy(fmatP);
   if (fmatP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectY->use_count!=1) 
      fvectY=nr_copy(fvectY);
   if (fvectY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectPSUM = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectPSUM->use_count = 0;
   fvectPSUM->type = nr_fvect*65536+nr_type;

   fvectPSUM->r = n;
   fvectPSUM->p = (void*)vector(1,n);

   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(amotry((float **)(fmatP->p),(float *)(fvectY->p),(float *)(fvectPSUM->p),n,FUNKcallback,integerIHI,floatFAC));

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatP;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectPSUM;
   push_pstack(&return3);



}

static specifier powellFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type powellFUNC_instance;
#endif

float powellFUNC_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = powellFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = powellFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = powellFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   powellFUNC_callback.sp_form = save_callback.sp_form;
   powellFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void POWELL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectP; /* r */ 
struct nrmatrix * fmatXI; /* r */ 
float floatTOL; /* r */ 
int integerITER; /* w */ 
float floatFRET; /* w */ 
void *FUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"powell",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"powell",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"powell",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[5].sp_form != ft_opaque)||
          (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[5].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[5].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",6,"powell",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"powell",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fmatXI = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fmatXI->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",2,"powell",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatTOL = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatTOL = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
  if (argv[5].sp_form == ft_proc) {
#ifndef TUNSAFE
     powellFUNC_instance = plugin_instance;
#endif
     powellFUNC_callback.sp_form = ft_proc;
     powellFUNC_callback.sp_val.sp_proc_ptr = argv[5].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)powellFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectP->r;
   if (n != fmatXI->r)
      abend(SETL_SYSTEM "Wrong first dimension in powell (parameter 3)");
   if (n != fmatXI->c)
      abend(SETL_SYSTEM "Wrong second dimension in powell (parameter 3)");


   powell((float *)(fvectP->p),(float **)(fmatXI->p),n,floatTOL,&integerITER,&floatFRET,FUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerITER;

   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatFRET);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

static specifier frprmnFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type frprmnFUNC_instance;
#endif

float frprmnFUNC_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = frprmnFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = frprmnFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = frprmnFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   frprmnFUNC_callback.sp_form = save_callback.sp_form;
   frprmnFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

static specifier frprmnDFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type frprmnDFUNC_instance;
#endif

void frprmnDFUNC_c_callback(float  p1[],float  p2[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = frprmnDFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   save_callback.sp_form = frprmnDFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = frprmnDFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   frprmnDFUNC_callback.sp_form = save_callback.sp_form;
   frprmnDFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void FRPRMN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectP; /* rw */ 
float floatFTOL; /* r */ 
int integerITER; /* w */ 
float floatFRET; /* w */ 
void *FUNCcallback;
void *DFUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"frprmn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"frprmn",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[4].sp_form != ft_opaque)||
          (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[4].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[4].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",5,"frprmn",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[5].sp_form != ft_opaque)||
          (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[5].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[5].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",6,"frprmn",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"frprmn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatFTOL = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatFTOL = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
  if (argv[4].sp_form == ft_proc) {
#ifndef TUNSAFE
     frprmnFUNC_instance = plugin_instance;
#endif
     frprmnFUNC_callback.sp_form = ft_proc;
     frprmnFUNC_callback.sp_val.sp_proc_ptr = argv[4].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)frprmnFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[5].sp_form == ft_proc) {
#ifndef TUNSAFE
     frprmnDFUNC_instance = plugin_instance;
#endif
     frprmnDFUNC_callback.sp_form = ft_proc;
     frprmnDFUNC_callback.sp_val.sp_proc_ptr = argv[5].sp_val.sp_proc_ptr;

     DFUNCcallback = (void*)frprmnDFUNC_c_callback;
  } else {
     DFUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectP->r;

   if (fvectP->use_count!=1) 
      fvectP=nr_copy(fvectP);
   if (fvectP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   frprmn((float *)(fvectP->p),n,floatFTOL,&integerITER,&floatFRET,FUNCcallback,DFUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectP;
   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerITER;

   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatFRET);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

static specifier dfpminFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type dfpminFUNC_instance;
#endif

float dfpminFUNC_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = dfpminFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = dfpminFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = dfpminFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   dfpminFUNC_callback.sp_form = save_callback.sp_form;
   dfpminFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

static specifier dfpminDFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type dfpminDFUNC_instance;
#endif

void dfpminDFUNC_c_callback(float  p1[],float  p2[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = dfpminDFUNC_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   save_callback.sp_form = dfpminDFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = dfpminDFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   dfpminDFUNC_callback.sp_form = save_callback.sp_form;
   dfpminDFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void DFPMIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectP; /* rw */ 
float floatGTOL; /* r */ 
int integerITER; /* w */ 
float floatFRET; /* w */ 
void *FUNCcallback;
void *DFUNCcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"dfpmin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"dfpmin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[4].sp_form != ft_opaque)||
          (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[4].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[4].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",5,"dfpmin",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[5].sp_form != ft_opaque)||
          (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[5].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[5].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",6,"dfpmin",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"dfpmin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatGTOL = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatGTOL = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
  if (argv[4].sp_form == ft_proc) {
#ifndef TUNSAFE
     dfpminFUNC_instance = plugin_instance;
#endif
     dfpminFUNC_callback.sp_form = ft_proc;
     dfpminFUNC_callback.sp_val.sp_proc_ptr = argv[4].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)dfpminFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[5].sp_form == ft_proc) {
#ifndef TUNSAFE
     dfpminDFUNC_instance = plugin_instance;
#endif
     dfpminDFUNC_callback.sp_form = ft_proc;
     dfpminDFUNC_callback.sp_val.sp_proc_ptr = argv[5].sp_val.sp_proc_ptr;

     DFUNCcallback = (void*)dfpminDFUNC_c_callback;
  } else {
     DFUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectP->r;

   if (fvectP->use_count!=1) 
      fvectP=nr_copy(fvectP);
   if (fvectP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   dfpmin((float *)(fvectP->p),n,floatGTOL,&integerITER,&floatFRET,FUNCcallback,DFUNCcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectP;
   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerITER;

   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatFRET);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

static specifier amebsaFUNK_callback;
#ifndef TUNSAFE
plugin_item_ptr_type amebsaFUNK_instance;
#endif

float amebsaFUNK_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = amebsaFUNK_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = amebsaFUNK_callback.sp_form;
   save_callback.sp_val.sp_biggest = amebsaFUNK_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   amebsaFUNK_callback.sp_form = save_callback.sp_form;
   amebsaFUNK_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void AMEBSA(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatP; /* rw */ 
struct nrmatrix * fvectY; /* rw */ 
struct nrmatrix * fvectPB; /* r */ 
float floatYB; /* w */ 
float floatFTOL; /* r */ 
void *FUNKcallback;
int integerITER; /* w */ 
float floatTEMPTR; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[5].sp_form != ft_opaque)||
          (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[5].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[5].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",6,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if ((argv[7].sp_form != ft_short) && (argv[7].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",8,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+7));


   fmatP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatP->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectPB = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectPB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"amebsa",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[4].sp_form == ft_short)
      floatFTOL = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatFTOL = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
  if (argv[5].sp_form == ft_proc) {
#ifndef TUNSAFE
     amebsaFUNK_instance = plugin_instance;
#endif
     amebsaFUNK_callback.sp_form = ft_proc;
     amebsaFUNK_callback.sp_val.sp_proc_ptr = argv[5].sp_val.sp_proc_ptr;

     FUNKcallback = (void*)amebsaFUNK_c_callback;
  } else {
     FUNKcallback = 
         (void *)(((struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[7].sp_form == ft_short)
      floatTEMPTR = (float)(argv[7].sp_val.sp_short_value);

   if (argv[7].sp_form == ft_real)
      floatTEMPTR = (float)((argv[7].sp_val.sp_real_ptr)->r_value);

   n = fmatP->r;
   if (n-1 != fmatP->c)
      abend(SETL_SYSTEM "Wrong second dimension in amebsa (parameter 2)");
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in amebsa (parameter 3)");
   if (n != fvectPB->r)
      abend(SETL_SYSTEM "Wrong first dimension in amebsa (parameter 4)");

   if (fmatP->use_count!=1) 
      fmatP=nr_copy(fmatP);
   if (fmatP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectY->use_count!=1) 
      fvectY=nr_copy(fvectY);
   if (fvectY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   amebsa((float **)(fmatP->p),(float *)(fvectY->p),n,(float *)(fvectPB->p),&floatYB,floatFTOL,FUNKcallback,&integerITER,floatTEMPTR);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatP;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatYB);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_short;
   return4.sp_val.sp_short_value = (int32)integerITER;

   push_pstack(&return4);



}

static specifier amotsaFUNK_callback;
#ifndef TUNSAFE
plugin_item_ptr_type amotsaFUNK_instance;
#endif

float amotsaFUNK_c_callback(float  p1[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = amotsaFUNK_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   save_callback.sp_form = amotsaFUNK_callback.sp_form;
   save_callback.sp_val.sp_biggest = amotsaFUNK_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   amotsaFUNK_callback.sp_form = save_callback.sp_form;
   amotsaFUNK_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void AMOTSA(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatP; /* rw */ 
struct nrmatrix * fvectY; /* rw */ 
struct nrmatrix * fvectPSUM; /* r */ 
struct nrmatrix * fvectPB; /* r */ 
float floatYB; /* w */ 
void *FUNKcallback;
int integerIHI; /* r */ 
float floatYHI; /* w */ 
float floatFAC; /* r */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (((argv[5].sp_form != ft_opaque)||
          (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[5].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[5].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",6,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (argv[6].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",7,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if ((argv[8].sp_form != ft_short) && (argv[8].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",9,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fmatP = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatP->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectPSUM = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectPSUM->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectPB = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectPB->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"amotsa",
         abend_opnd_str(SETL_SYSTEM argv+3));

  if (argv[5].sp_form == ft_proc) {
#ifndef TUNSAFE
     amotsaFUNK_instance = plugin_instance;
#endif
     amotsaFUNK_callback.sp_form = ft_proc;
     amotsaFUNK_callback.sp_val.sp_proc_ptr = argv[5].sp_val.sp_proc_ptr;

     FUNKcallback = (void*)amotsaFUNK_c_callback;
  } else {
     FUNKcallback = 
         (void *)(((struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr))->p);
  }
   integerIHI = (argv[6].sp_val.sp_short_value);

   if (argv[8].sp_form == ft_short)
      floatFAC = (float)(argv[8].sp_val.sp_short_value);

   if (argv[8].sp_form == ft_real)
      floatFAC = (float)((argv[8].sp_val.sp_real_ptr)->r_value);

   n = fmatP->r;
   m = fmatP->c;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in amotsa (parameter 3)");
   if (n != fvectPSUM->r)
      abend(SETL_SYSTEM "Wrong first dimension in amotsa (parameter 4)");
   if (n != fvectPB->r)
      abend(SETL_SYSTEM "Wrong first dimension in amotsa (parameter 5)");

   if (fmatP->use_count!=1) 
      fmatP=nr_copy(fmatP);
   if (fmatP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectY->use_count!=1) 
      fvectY=nr_copy(fvectY);
   if (fvectY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(amotsa((float **)(fmatP->p),(float *)(fvectY->p),(float *)(fvectPSUM->p),n-1,(float *)(fvectPB->p),&floatYB,FUNKcallback,integerIHI,&floatYHI,floatFAC));

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatP;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatYB);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatYHI);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void ANNEAL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * ivectIORDER; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"anneal",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"anneal",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"anneal",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"anneal",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in anneal (parameter 3)");

   ivectIORDER = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   ivectIORDER->use_count = 0;
   ivectIORDER->type = nr_ivect*65536+nr_type;

   ivectIORDER->r = n;
   ivectIORDER->p = (void*)ivector(1,n);

   anneal((float *)(fvectX->p),(float *)(fvectY->p),(int *)(ivectIORDER->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectIORDER;
   push_pstack(&return1);



}

void REVCST(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * ivectIORDER; /* r */ 
struct nrmatrix * ivectN; /* r */ 

/* Variables used to compute the array bounds */

long n;



   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"revcst",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"revcst",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"revcst",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"revcst",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"revcst",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"revcst",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ivectIORDER = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((ivectIORDER->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",3,"revcst",
         abend_opnd_str(SETL_SYSTEM argv+2));

   ivectN = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((ivectN->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",4,"revcst",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in revcst (parameter 3)");
   if (n != ivectIORDER->r)
      abend(SETL_SYSTEM "Wrong first dimension in revcst (parameter 4)");


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(revcst((float *)(fvectX->p),(float *)(fvectY->p),(int *)(ivectIORDER->p),n,(int *)(ivectN->p)));



}

void REVERSE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * ivectIORDER; /* rw */ 
struct nrmatrix * ivectN; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"reverse",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"reverse",
         abend_opnd_str(SETL_SYSTEM argv+1));


   ivectIORDER = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((ivectIORDER->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",1,"reverse",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ivectN = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ivectN->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",2,"reverse",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = ivectIORDER->r;

   if (ivectIORDER->use_count!=1) 
      ivectIORDER=nr_copy(ivectIORDER);
   if (ivectIORDER==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   reverse((int *)(ivectIORDER->p),n,(int *)(ivectN->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectIORDER;
   push_pstack(&return1);



}

void TRNCST(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * ivectIORDER; /* r */ 
struct nrmatrix * ivectN; /* w */ 

/* Variables used to compute the array bounds */

long n;
long k;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"trncst",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"trncst",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"trncst",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"trncst",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"trncst",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ivectIORDER = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((ivectIORDER->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",3,"trncst",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in trncst (parameter 3)");
   if (n != ivectIORDER->r)
      abend(SETL_SYSTEM "Wrong first dimension in trncst (parameter 4)");

   ivectN = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   ivectN->use_count = 0;
   ivectN->type = nr_ivect*65536+nr_type;

   ivectN->r = k;
   ivectN->p = (void*)ivector(1,k);

   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(trncst((float *)(fvectX->p),(float *)(fvectY->p),(int *)(ivectIORDER->p),n,(int *)(ivectN->p)));

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectN;
   push_pstack(&return1);



}

void TRNSPT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * ivectIORDER; /* rw */ 
struct nrmatrix * ivectN; /* r */ 

/* Variables used to compute the array bounds */

long n;
long k;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"trnspt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"trnspt",
         abend_opnd_str(SETL_SYSTEM argv+1));


   ivectIORDER = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((ivectIORDER->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",1,"trnspt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ivectN = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ivectN->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",2,"trnspt",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = ivectIORDER->r;
   k = ivectN->r;

   if (ivectIORDER->use_count!=1) 
      ivectIORDER=nr_copy(ivectIORDER);
   if (ivectIORDER==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   trnspt((int *)(ivectIORDER->p),n,(int *)(ivectN->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ivectIORDER;
   push_pstack(&return1);



}

void JACOBI(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
struct nrmatrix * fvectD; /* w */ 
struct nrmatrix * fmatV; /* w */ 
int integerNROT; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"jacobi",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"jacobi",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in jacobi (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectD = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectD->use_count = 0;
   fvectD->type = nr_fvect*65536+nr_type;

   fvectD->r = n;
   fvectD->p = (void*)vector(1,n);
   fmatV = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatV->use_count = 0;
   fmatV->type = nr_fmat*65536+nr_type;

   fmatV->r = n;
   fmatV->c = n;
   fmatV->p = (void*)matrix(1,n,1,n);

   jacobi((float **)(fmatA->p),n,(float *)(fvectD->p),(float **)(fmatV->p),&integerNROT);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatV;
   push_pstack(&return3);

   return4.sp_form = ft_short;
   return4.sp_val.sp_short_value = (int32)integerNROT;

   push_pstack(&return4);



}

void TRED2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
struct nrmatrix * fvectD; /* w */ 
struct nrmatrix * fvectE; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"tred2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"tred2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in tred2 (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectD = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectD->use_count = 0;
   fvectD->type = nr_fvect*65536+nr_type;

   fvectD->r = n;
   fvectD->p = (void*)vector(1,n);
   fvectE = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectE->use_count = 0;
   fvectE->type = nr_fvect*65536+nr_type;

   fvectE->r = n;
   fvectE->p = (void*)vector(1,n);

   tred2((float **)(fmatA->p),n,(float *)(fvectD->p),(float *)(fvectE->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectE;
   push_pstack(&return3);



}

void TQLI(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 
struct nrmatrix * fvectE; /* rw */ 
struct nrmatrix * fmatZ; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"tqli",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"tqli",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"tqli",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"tqli",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectE = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectE->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"tqli",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fmatZ = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fmatZ->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",3,"tqli",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectD->r;
   if (n != fvectE->r)
      abend(SETL_SYSTEM "Wrong first dimension in tqli (parameter 3)");
   if (n != fmatZ->r)
      abend(SETL_SYSTEM "Wrong first dimension in tqli (parameter 4)");
   if (n != fmatZ->c)
      abend(SETL_SYSTEM "Wrong second dimension in tqli (parameter 4)");

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectE->use_count!=1) 
      fvectE=nr_copy(fvectE);
   if (fvectE==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatZ->use_count!=1) 
      fmatZ=nr_copy(fmatZ);
   if (fmatZ==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   tqli((float *)(fvectD->p),(float *)(fvectE->p),n,(float **)(fmatZ->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectE;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatZ;
   push_pstack(&return3);



}

void BALANC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"balanc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"balanc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in balanc (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   balanc((float **)(fmatA->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);



}

void ELMHES(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"elmhes",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"elmhes",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in elmhes (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   elmhes((float **)(fmatA->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);



}

void HQR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 
struct nrmatrix * fvectR; /* w */ 
struct nrmatrix * fvectI; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"hqr",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"hqr",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in hqr (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectR = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectR->use_count = 0;
   fvectR->type = nr_fvect*65536+nr_type;

   fvectR->r = n;
   fvectR->p = (void*)vector(1,n);
   fvectI = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectI->use_count = 0;
   fvectI->type = nr_fvect*65536+nr_type;

   fvectI->r = n;
   fvectI->p = (void*)vector(1,n);

   hqr((float **)(fmatA->p),n,(float *)(fvectR->p),(float *)(fvectI->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectR;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectI;
   push_pstack(&return3);



}

void EIGSRT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 
struct nrmatrix * fmatV; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"eigsrt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"eigsrt",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"eigsrt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fmatV = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fmatV->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",2,"eigsrt",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectD->r;
   if (n != fmatV->r)
      abend(SETL_SYSTEM "Wrong first dimension in eigsrt (parameter 3)");
   if (n != fmatV->c)
      abend(SETL_SYSTEM "Wrong second dimension in eigsrt (parameter 3)");

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatV->use_count!=1) 
      fmatV=nr_copy(fmatV);
   if (fmatV==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   eigsrt((float *)(fvectD->p),(float **)(fmatV->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatV;
   push_pstack(&return2);



}

void FOUR1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"four1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"four1",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"four1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[1].sp_val.sp_short_value);


   n = fvectD->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   four1((float *)(fvectD->p),n/2,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void DFOUR1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectD; /* rw */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"dfour1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"dfour1",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectD->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"dfour1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[1].sp_val.sp_short_value);


   n = dvectD->r;

   if (dvectD->use_count!=1) 
      dvectD=nr_copy(dvectD);
   if (dvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   dfour1((double *)(dvectD->p),n/2,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectD;
   push_pstack(&return1);



}

void TWOFFT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD1; /* r */ 
struct nrmatrix * fvectD2; /* r */ 
struct nrmatrix * fvectF1; /* rw */ 
struct nrmatrix * fvectF2; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"twofft",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"twofft",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"twofft",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectD1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"twofft",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectD2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectD2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"twofft",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectF1 = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectF1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"twofft",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectD1->r;
   if (n != fvectD2->r)
      abend(SETL_SYSTEM "Wrong first dimension in twofft (parameter 3)");
   m = fvectF1->r;

   if (fvectF1->use_count!=1) 
      fvectF1=nr_copy(fvectF1);
   if (fvectF1==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectF2 = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectF2->use_count = 0;
   fvectF2->type = nr_fvect*65536+nr_type;

   fvectF2->r = m;
   fvectF2->p = (void*)vector(1,m);

   twofft((float *)(fvectD1->p),(float *)(fvectD2->p),(float *)(fvectF1->p),(float *)(fvectF2->p),n/2);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectF1;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectF2;
   push_pstack(&return2);



}

void REALFT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"realft",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"realft",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"realft",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[1].sp_val.sp_short_value);


   n = fvectD->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   realft((float *)(fvectD->p),n,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void DREALFT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectD; /* rw */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"drealft",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"drealft",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectD->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"drealft",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[1].sp_val.sp_short_value);


   n = dvectD->r;

   if (dvectD->use_count!=1) 
      dvectD=nr_copy(dvectD);
   if (dvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   drealft((double *)(dvectD->p),n,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectD;
   push_pstack(&return1);



}

void SINFT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sinft",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"sinft",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectD->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sinft((float *)(fvectD->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void COSFT1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"cosft1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"cosft1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectD->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   cosft1((float *)(fvectD->p),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void COSFT2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"cosft2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"cosft2",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"cosft2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[1].sp_val.sp_short_value);


   n = fvectD->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   cosft2((float *)(fvectD->p),n,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void FOURN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 
struct nrmatrix * ulvectNN; /* r */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"fourn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"fourn",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"fourn",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"fourn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectNN = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectNN->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"fourn",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerISIGN = (argv[2].sp_val.sp_short_value);


   n = fvectD->r;
   m = ulvectNN->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   fourn((float *)(fvectD->p),(unsigned long *)(ulvectNN->p),m,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void RLFT3(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * ftensD; /* rw */ 
struct nrmatrix * fmatSPEQ; /* w */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long m;
long q;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rlft3",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"rlft3",
         abend_opnd_str(SETL_SYSTEM argv+2));


   ftensD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((ftensD->type)>>16)!=nr_ftens)

      abend(SETL_SYSTEM msg_bad_arg,"float tensor",1,"rlft3",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[2].sp_val.sp_short_value);


   n = ftensD->r;
   m = ftensD->c;
   q = ftensD->h;

   if (ftensD->use_count!=1) 
      ftensD=nr_copy(ftensD);
   if (ftensD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fmatSPEQ = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatSPEQ->use_count = 0;
   fmatSPEQ->type = nr_fmat*65536+nr_type;

   fmatSPEQ->r = n;
   fmatSPEQ->c = 2*m;
   fmatSPEQ->p = (void*)matrix(1,n,1,2*m);

   rlft3((float ***)(ftensD->p),(float **)(fmatSPEQ->p),n,m,q,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ftensD;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatSPEQ;
   push_pstack(&return2);



}

void CONVLV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA; /* r */ 
struct nrmatrix * fvectRESPNS; /* r */ 
unsigned long ulongM; /* r */ 
int integerISIGN; /* r */ 
struct nrmatrix * fvectANS; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"convlv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"convlv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"convlv",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"convlv",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"convlv",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fvectDATA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"convlv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectRESPNS = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectRESPNS->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"convlv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ulongM = (argv[2].sp_val.sp_short_value);

   integerISIGN = (argv[3].sp_val.sp_short_value);

   fvectANS = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fvectANS->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",5,"convlv",
         abend_opnd_str(SETL_SYSTEM argv+4));


   n = fvectDATA->r;
   if (n != fvectRESPNS->r)
      abend(SETL_SYSTEM "Wrong first dimension in convlv (parameter 3)");
   if (2*n != fvectANS->r)
      abend(SETL_SYSTEM "Wrong first dimension in convlv (parameter 6)");

   if (fvectANS->use_count!=1) 
      fvectANS=nr_copy(fvectANS);
   if (fvectANS==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   convlv((float *)(fvectDATA->p),n,(float *)(fvectRESPNS->p),ulongM,integerISIGN,(float *)(fvectANS->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectANS;
   push_pstack(&return1);



}

void CORREL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA1; /* r */ 
struct nrmatrix * fvectDATA2; /* r */ 
struct nrmatrix * fvectANS; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"correl",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"correl",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"correl",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectDATA1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"correl",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDATA2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDATA2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"correl",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectANS = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectANS->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"correl",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectDATA1->r;
   if (n != fvectDATA2->r)
      abend(SETL_SYSTEM "Wrong first dimension in correl (parameter 3)");
   m = fvectANS->r;

   if (fvectANS->use_count!=1) 
      fvectANS=nr_copy(fvectANS);
   if (fvectANS==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   correl((float *)(fvectDATA1->p),(float *)(fvectDATA2->p),n,(float *)(fvectANS->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectANS;
   push_pstack(&return1);



}

static specifier wt1WTSTEP_callback;
#ifndef TUNSAFE
plugin_item_ptr_type wt1WTSTEP_instance;
#endif

void wt1WTSTEP_c_callback(float  p1[],int p2,int p3)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = wt1WTSTEP_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p2;
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p3;
   push_pstack(&spare);

   save_callback.sp_form = wt1WTSTEP_callback.sp_form;
   save_callback.sp_val.sp_biggest = wt1WTSTEP_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   wt1WTSTEP_callback.sp_form = save_callback.sp_form;
   wt1WTSTEP_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void WT1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectA; /* rw */ 
int integerISIGN; /* r */ 
void *WTSTEPcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"wt1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"wt1",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[2].sp_form != ft_opaque)||
          (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[2].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[2].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",3,"wt1",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"wt1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[1].sp_val.sp_short_value);

  if (argv[2].sp_form == ft_proc) {
#ifndef TUNSAFE
     wt1WTSTEP_instance = plugin_instance;
#endif
     wt1WTSTEP_callback.sp_form = ft_proc;
     wt1WTSTEP_callback.sp_val.sp_proc_ptr = argv[2].sp_val.sp_proc_ptr;

     WTSTEPcallback = (void*)wt1WTSTEP_c_callback;
  } else {
     WTSTEPcallback = 
         (void *)(((struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectA->r;

   if (fvectA->use_count!=1) 
      fvectA=nr_copy(fvectA);
   if (fvectA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   wt1((float *)(fvectA->p),n,integerISIGN,WTSTEPcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return1);



}

static specifier wtnWTSTEP_callback;
#ifndef TUNSAFE
plugin_item_ptr_type wtnWTSTEP_instance;
#endif

void wtnWTSTEP_c_callback(float  p1[],int p2,int p3)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = wtnWTSTEP_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p2;
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p3;
   push_pstack(&spare);

   save_callback.sp_form = wtnWTSTEP_callback.sp_form;
   save_callback.sp_val.sp_biggest = wtnWTSTEP_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   wtnWTSTEP_callback.sp_form = save_callback.sp_form;
   wtnWTSTEP_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void WTN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectA; /* rw */ 
struct nrmatrix * ulvectNN; /* r */ 
int integerISIGN; /* r */ 
void *WTSTEPcallback;

/* Variables used to compute the array bounds */

long n;
long k;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"wtn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"wtn",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"wtn",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"wtn",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"wtn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   ulvectNN = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ulvectNN->type)>>16)!=nr_ulvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned long vector",2,"wtn",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerISIGN = (argv[2].sp_val.sp_short_value);

  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     wtnWTSTEP_instance = plugin_instance;
#endif
     wtnWTSTEP_callback.sp_form = ft_proc;
     wtnWTSTEP_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     WTSTEPcallback = (void*)wtnWTSTEP_c_callback;
  } else {
     WTSTEPcallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }

   k = fvectA->r;
   n = ulvectNN->r;

   if (fvectA->use_count!=1) 
      fvectA=nr_copy(fvectA);
   if (fvectA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   wtn((float *)(fvectA->p),(unsigned long *)(ulvectNN->p),n,integerISIGN,WTSTEPcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return1);



}

void SPREAD(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatY; /* r */ 
struct nrmatrix * fvectYY; /* rw */ 
float floatX; /* r */ 
int integerM; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"spread",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"spread",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"spread",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"spread",
         abend_opnd_str(SETL_SYSTEM argv+3));


   if (argv[0].sp_form == ft_short)
      floatY = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatY = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   fvectYY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectYY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"spread",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   integerM = (argv[3].sp_val.sp_short_value);


   n = fvectYY->r;

   if (fvectYY->use_count!=1) 
      fvectYY=nr_copy(fvectYY);
   if (fvectYY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   spread(floatY,(float *)(fvectYY->p),n,floatX,integerM);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYY;
   push_pstack(&return1);



}

void DFTCOR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatW; /* r */ 
float floatDELTA; /* r */ 
float floatA; /* r */ 
float floatB; /* r */ 
struct nrmatrix * fvectENDPTS; /* r */ 
float floatCORRE; /* w */ 
float floatCORIM; /* w */ 
float floatCORFAC; /* w */ 

specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"dftcor",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"dftcor",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"dftcor",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"dftcor",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"dftcor",
         abend_opnd_str(SETL_SYSTEM argv+4));


   if (argv[0].sp_form == ft_short)
      floatW = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatW = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatDELTA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatDELTA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatA = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatA = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatB = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatB = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   fvectENDPTS = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fvectENDPTS->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",5,"dftcor",
         abend_opnd_str(SETL_SYSTEM argv+4));




   dftcor(floatW,floatDELTA,floatA,floatB,(float *)(fvectENDPTS->p),&floatCORRE,&floatCORIM,&floatCORFAC);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatCORRE);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatCORIM);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatCORFAC);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

static specifier dftintFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type dftintFUNC_instance;
#endif

float dftintFUNC_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = dftintFUNC_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = dftintFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = dftintFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   dftintFUNC_callback.sp_form = save_callback.sp_form;
   dftintFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void DFTINT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *FUNCcallback;
float floatA; /* r */ 
float floatB; /* r */ 
float floatW; /* r */ 
float floatCOSINT; /* w */ 
float floatSININT; /* w */ 

specifier return1;
specifier return2;

   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"dftint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"dftint",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"dftint",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"dftint",
         abend_opnd_str(SETL_SYSTEM argv+3));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     dftintFUNC_instance = plugin_instance;
#endif
     dftintFUNC_callback.sp_form = ft_proc;
     dftintFUNC_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)dftintFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatW = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatW = (float)((argv[3].sp_val.sp_real_ptr)->r_value);



   dftint(FUNCcallback,floatA,floatB,floatW,&floatCOSINT,&floatSININT);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatCOSINT);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatSININT);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void PWTSET(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"pwtset",
         abend_opnd_str(SETL_SYSTEM argv+0));


   integerN = (argv[0].sp_val.sp_short_value);




   pwtset(integerN);

   unmark_specifier(target);
   target->sp_form = ft_omega;



}
void NR_GETCB_DAUB4(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{ 
struct nrmatrix *func;

   func = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   func->type    = nr_cback*65536+nr_type;
   func->use_count = 1;

   func->p = (void *)daub4;
   func->r = 0;
   func->c = 0;

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)func;

   return;
  
}

void DAUB4(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectA; /* r */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long n;



   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"daub4",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"daub4",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"daub4",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[1].sp_val.sp_short_value);


   n = fvectA->r;


   daub4((float *)(fvectA->p),n,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;



}

void PWT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectA; /* r */ 
int integerISIGN; /* r */ 

/* Variables used to compute the array bounds */

long n;



   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"pwt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"pwt",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"pwt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerISIGN = (argv[1].sp_val.sp_short_value);


   n = fvectA->r;


   pwt((float *)(fvectA->p),n,integerISIGN);

   unmark_specifier(target);
   target->sp_form = ft_omega;



}

void PREDIC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA; /* r */ 
struct nrmatrix * fvectD; /* r */ 
struct nrmatrix * fvectFUTURE; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;
long k;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"predic",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"predic",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"predic",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectDATA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"predic",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectD = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"predic",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectFUTURE = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectFUTURE->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"predic",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectDATA->r;
   m = fvectD->r;
   k = fvectFUTURE->r;

   if (fvectFUTURE->use_count!=1) 
      fvectFUTURE=nr_copy(fvectFUTURE);
   if (fvectFUTURE==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   predic((float *)(fvectDATA->p),n,(float *)(fvectD->p),m,(float *)(fvectFUTURE->p),k);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectFUTURE;
   push_pstack(&return1);



}

void EVLMEM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatFDT; /* r */ 
struct nrmatrix * fvectD; /* r */ 
float floatXMS; /* r */ 

/* Variables used to compute the array bounds */

long m;



   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"evlmem",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"evlmem",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"evlmem",
         abend_opnd_str(SETL_SYSTEM argv+2));


   if (argv[0].sp_form == ft_short)
      floatFDT = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatFDT = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   fvectD = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"evlmem",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatXMS = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatXMS = (float)((argv[2].sp_val.sp_real_ptr)->r_value);

   m = fvectD->r;


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(evlmem(floatFDT,(float *)(fvectD->p),m,floatXMS));



}

void PERIOD(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
float floatOFAC; /* r */ 
float floatHIFAC; /* r */ 
struct nrmatrix * fvectPX; /* rw */ 
struct nrmatrix * fvectPY; /* w */ 
int integerNOUT; /* w */ 
int integerJMAX; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"period",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"period",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"period",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"period",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"period",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"period",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"period",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatOFAC = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatOFAC = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatHIFAC = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatHIFAC = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   fvectPX = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fvectPX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",5,"period",
         abend_opnd_str(SETL_SYSTEM argv+4));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in period (parameter 3)");
   m = fvectPX->r;

   if (fvectPX->use_count!=1) 
      fvectPX=nr_copy(fvectPX);
   if (fvectPX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectPY = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectPY->use_count = 0;
   fvectPY->type = nr_fvect*65536+nr_type;

   fvectPY->r = m;
   fvectPY->p = (void*)vector(1,m);

   period((float *)(fvectX->p),(float *)(fvectY->p),n,floatOFAC,floatHIFAC,(float *)(fvectPX->p),(float *)(fvectPY->p),m,&integerNOUT,&integerJMAX,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectPX;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectPY;
   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerNOUT;

   push_pstack(&return3);

   return4.sp_form = ft_short;
   return4.sp_val.sp_short_value = (int32)integerJMAX;

   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);



}

void FASPER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
float floatOFAC; /* r */ 
float floatHIFAC; /* r */ 
struct nrmatrix * fvectWK1; /* rw */ 
struct nrmatrix * fvectWK2; /* w */ 
unsigned long ulongNOUT; /* w */ 
unsigned long ulongJMAX; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long n;
long k;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"fasper",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"fasper",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"fasper",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"fasper",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"fasper",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"fasper",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"fasper",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatOFAC = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatOFAC = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatHIFAC = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatHIFAC = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   fvectWK1 = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fvectWK1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",5,"fasper",
         abend_opnd_str(SETL_SYSTEM argv+4));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in fasper (parameter 3)");
   k = fvectWK1->r;

   if (fvectWK1->use_count!=1) 
      fvectWK1=nr_copy(fvectWK1);
   if (fvectWK1==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectWK2 = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectWK2->use_count = 0;
   fvectWK2->type = nr_fvect*65536+nr_type;

   fvectWK2->r = k;
   fvectWK2->p = (void*)vector(1,k);

   fasper((float *)(fvectX->p),(float *)(fvectY->p),n,floatOFAC,floatHIFAC,(float *)(fvectWK1->p),(float *)(fvectWK2->p),k,&ulongNOUT,&ulongJMAX,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectWK1;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectWK2;
   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)ulongNOUT;

   push_pstack(&return3);

   return4.sp_form = ft_short;
   return4.sp_val.sp_short_value = (int32)ulongJMAX;

   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);



}

void MEMCOF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA; /* r */ 
float floatXMS; /* w */ 
struct nrmatrix * fvectD; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"memcof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"memcof",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectDATA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"memcof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectD = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"memcof",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectDATA->r;
   m = fvectD->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   memcof((float *)(fvectDATA->p),n,m,&floatXMS,(float *)(fvectD->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatXMS);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return2);



}

void FIXRTS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectD; /* rw */ 

/* Variables used to compute the array bounds */

long m;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"fixrts",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectD = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectD->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"fixrts",
         abend_opnd_str(SETL_SYSTEM argv+0));


   m = fvectD->r;

   if (fvectD->use_count!=1) 
      fvectD=nr_copy(fvectD);
   if (fvectD==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   fixrts((float *)(fvectD->p),m);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectD;
   push_pstack(&return1);



}

void MOMENT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA; /* r */ 
float floatAVE; /* w */ 
float floatADEV; /* w */ 
float floatSDEV; /* w */ 
float floatVAR; /* w */ 
float floatSKEW; /* w */ 
float floatCURT; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;
specifier return6;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"moment",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectDATA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"moment",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectDATA->r;


   moment((float *)(fvectDATA->p),n,&floatAVE,&floatADEV,&floatSDEV,&floatVAR,&floatSKEW,&floatCURT);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatAVE);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatADEV);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatSDEV);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatVAR);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatSKEW);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);

   return6.sp_form = ft_real;
   i_get_real(return6.sp_val.sp_real_ptr);
   return6.sp_val.sp_real_ptr->r_value = (double)(floatCURT);
   return6.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return6);



}

void TTEST(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA1; /* r */ 
struct nrmatrix * fvectDATA2; /* r */ 
float floatT; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ttest",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"ttest",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectDATA1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ttest",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDATA2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDATA2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"ttest",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectDATA1->r;
   m = fvectDATA2->r;


   ttest((float *)(fvectDATA1->p),n,(float *)(fvectDATA2->p),m,&floatT,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatT);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void TUTEST(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA1; /* r */ 
struct nrmatrix * fvectDATA2; /* r */ 
float floatT; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"tutest",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"tutest",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectDATA1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"tutest",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDATA2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDATA2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"tutest",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectDATA1->r;
   m = fvectDATA2->r;


   tutest((float *)(fvectDATA1->p),n,(float *)(fvectDATA2->p),m,&floatT,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatT);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void AVEVAR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA; /* r */ 
float floatAVE; /* w */ 
float floatVAR; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"avevar",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectDATA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"avevar",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectDATA->r;


   avevar((float *)(fvectDATA->p),n,&floatAVE,&floatVAR);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatAVE);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatVAR);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void TPTEST(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA1; /* r */ 
struct nrmatrix * fvectDATA2; /* r */ 
float floatT; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"tptest",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"tptest",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectDATA1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"tptest",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDATA2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDATA2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"tptest",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectDATA1->r;
   if (n != fvectDATA2->r)
      abend(SETL_SYSTEM "Wrong first dimension in tptest (parameter 3)");


   tptest((float *)(fvectDATA1->p),(float *)(fvectDATA2->p),n,&floatT,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatT);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void FTEST(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA1; /* r */ 
struct nrmatrix * fvectDATA2; /* r */ 
float floatF; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ftest",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"ftest",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectDATA1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ftest",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDATA2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDATA2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"ftest",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectDATA1->r;
   m = fvectDATA2->r;


   ftest((float *)(fvectDATA1->p),n,(float *)(fvectDATA2->p),m,&floatF,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatF);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void CHSONE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectBINS; /* r */ 
struct nrmatrix * fvectEBINS; /* r */ 
int integerKNSTRN; /* r */ 
float floatDF; /* w */ 
float floatCHSQ; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"chsone",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"chsone",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"chsone",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectBINS = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectBINS->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"chsone",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectEBINS = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectEBINS->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"chsone",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerKNSTRN = (argv[2].sp_val.sp_short_value);


   n = fvectBINS->r;
   if (n != fvectEBINS->r)
      abend(SETL_SYSTEM "Wrong first dimension in chsone (parameter 3)");


   chsone((float *)(fvectBINS->p),(float *)(fvectEBINS->p),n,integerKNSTRN,&floatDF,&floatCHSQ,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatDF);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatCHSQ);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void CHSTWO(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectBINS1; /* r */ 
struct nrmatrix * fvectBINS2; /* r */ 
int integerKNSTRN; /* r */ 
float floatDF; /* w */ 
float floatCHSQ; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"chstwo",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"chstwo",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"chstwo",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectBINS1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectBINS1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"chstwo",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectBINS2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectBINS2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"chstwo",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerKNSTRN = (argv[2].sp_val.sp_short_value);


   n = fvectBINS1->r;
   if (n != fvectBINS2->r)
      abend(SETL_SYSTEM "Wrong first dimension in chstwo (parameter 3)");


   chstwo((float *)(fvectBINS1->p),(float *)(fvectBINS2->p),n,integerKNSTRN,&floatDF,&floatCHSQ,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatDF);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatCHSQ);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

static specifier ksoneFUNC_callback;
#ifndef TUNSAFE
plugin_item_ptr_type ksoneFUNC_instance;
#endif

float ksoneFUNC_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = ksoneFUNC_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = ksoneFUNC_callback.sp_form;
   save_callback.sp_val.sp_biggest = ksoneFUNC_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   ksoneFUNC_callback.sp_form = save_callback.sp_form;
   ksoneFUNC_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void KSONE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA; /* r */ 
void *FUNCcallback;
float floatD; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ksone",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (((argv[1].sp_form != ft_opaque)||
          (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[1].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[1].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",2,"ksone",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectDATA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ksone",
         abend_opnd_str(SETL_SYSTEM argv+0));

  if (argv[1].sp_form == ft_proc) {
#ifndef TUNSAFE
     ksoneFUNC_instance = plugin_instance;
#endif
     ksoneFUNC_callback.sp_form = ft_proc;
     ksoneFUNC_callback.sp_val.sp_proc_ptr = argv[1].sp_val.sp_proc_ptr;

     FUNCcallback = (void*)ksoneFUNC_c_callback;
  } else {
     FUNCcallback = 
         (void *)(((struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectDATA->r;


   ksone((float *)(fvectDATA->p),n,FUNCcallback,&floatD,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatD);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void KSTWO(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA1; /* r */ 
struct nrmatrix * fvectDATA2; /* r */ 
float floatD; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"kstwo",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"kstwo",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectDATA1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"kstwo",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDATA2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDATA2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"kstwo",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectDATA1->r;
   m = fvectDATA2->r;


   kstwo((float *)(fvectDATA1->p),n,(float *)(fvectDATA2->p),m,&floatD,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatD);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void PROBKS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatALAM; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"probks",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatALAM = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatALAM = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(probks(floatALAM));



}

void CNTAB1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * imatNN; /* r */ 
float floatCHISQ; /* w */ 
float floatDF; /* w */ 
float floatPROB; /* w */ 
float floatCRAMRV; /* w */ 
float floatCCC; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"cntab1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   imatNN = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((imatNN->type)>>16)!=nr_imat)

      abend(SETL_SYSTEM msg_bad_arg,"integer matrix",1,"cntab1",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = imatNN->r;
   m = imatNN->c;


   cntab1((int **)(imatNN->p),n,m,&floatCHISQ,&floatDF,&floatPROB,&floatCRAMRV,&floatCCC);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatCHISQ);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatDF);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatCRAMRV);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatCCC);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);



}

void CNTAB2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * imatNN; /* r */ 
float floatH; /* w */ 
float floatHX; /* w */ 
float floatHY; /* w */ 
float floatHYGX; /* w */ 
float floatHXGY; /* w */ 
float floatUYGX; /* w */ 
float floatUXGY; /* w */ 
float floatUXY; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;
specifier return6;
specifier return7;
specifier return8;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"cntab2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   imatNN = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((imatNN->type)>>16)!=nr_imat)

      abend(SETL_SYSTEM msg_bad_arg,"integer matrix",1,"cntab2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = imatNN->r;
   m = imatNN->c;


   cntab2((int **)(imatNN->p),n,m,&floatH,&floatHX,&floatHY,&floatHYGX,&floatHXGY,&floatUYGX,&floatUXGY,&floatUXY);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatH);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatHX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatHY);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatHYGX);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatHXGY);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);

   return6.sp_form = ft_real;
   i_get_real(return6.sp_val.sp_real_ptr);
   return6.sp_val.sp_real_ptr->r_value = (double)(floatUYGX);
   return6.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return6);

   return7.sp_form = ft_real;
   i_get_real(return7.sp_val.sp_real_ptr);
   return7.sp_val.sp_real_ptr->r_value = (double)(floatUXGY);
   return7.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return7);

   return8.sp_form = ft_real;
   i_get_real(return8.sp_val.sp_real_ptr);
   return8.sp_val.sp_real_ptr->r_value = (double)(floatUXY);
   return8.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return8);



}

void PEARSN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
float floatR; /* w */ 
float floatPROB; /* w */ 
float floatZ; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"pearsn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"pearsn",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"pearsn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"pearsn",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in pearsn (parameter 3)");


   pearsn((float *)(fvectX->p),(float *)(fvectY->p),n,&floatR,&floatPROB,&floatZ);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatR);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatZ);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void SPEAR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA1; /* r */ 
struct nrmatrix * fvectDATA2; /* r */ 
float floatD; /* w */ 
float floatZD; /* w */ 
float floatPROBD; /* w */ 
float floatRS; /* w */ 
float floatPROBRS; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"spear",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"spear",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectDATA1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"spear",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDATA2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDATA2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"spear",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectDATA1->r;
   if (n != fvectDATA2->r)
      abend(SETL_SYSTEM "Wrong first dimension in spear (parameter 3)");


   spear((float *)(fvectDATA1->p),(float *)(fvectDATA2->p),n,&floatD,&floatZD,&floatPROBD,&floatRS,&floatPROBRS);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatD);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatZD);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatPROBD);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatRS);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatPROBRS);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);



}

void CRANK(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectW; /* r */ 
float floatS; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"crank",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectW = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectW->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"crank",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectW->r;


   crank(n,(float *)(fvectW->p),&floatS);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatS);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);



}

void KENDL1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectDATA1; /* r */ 
struct nrmatrix * fvectDATA2; /* r */ 
float floatTAU; /* w */ 
float floatZ; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"kendl1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"kendl1",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectDATA1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectDATA1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"kendl1",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDATA2 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDATA2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"kendl1",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectDATA1->r;
   if (n != fvectDATA2->r)
      abend(SETL_SYSTEM "Wrong first dimension in kendl1 (parameter 3)");


   kendl1((float *)(fvectDATA1->p),(float *)(fvectDATA2->p),n,&floatTAU,&floatZ,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatTAU);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatZ);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void KENDL2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatTAB; /* r */ 
float floatTAU; /* w */ 
float floatZ; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long i;
long j;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"kendl2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatTAB = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatTAB->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"kendl2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   i = fmatTAB->r;
   j = fmatTAB->c;


   kendl2((float **)(fmatTAB->p),i,j,&floatTAU,&floatZ,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatTAU);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatZ);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

static specifier nrks2d1sQUADVL_callback;
#ifndef TUNSAFE
plugin_item_ptr_type nrks2d1sQUADVL_instance;
#endif

void nrks2d1sQUADVL_c_callback(float p1,float p2,float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = nrks2d1sQUADVL_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p2;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = nrks2d1sQUADVL_callback.sp_form;
   save_callback.sp_val.sp_biggest = nrks2d1sQUADVL_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   nrks2d1sQUADVL_callback.sp_form = save_callback.sp_form;
   nrks2d1sQUADVL_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void NRKS2D1S(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX1; /* r */ 
struct nrmatrix * fvectY1; /* r */ 
void *QUADVLcallback;
float floatD1; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"nrks2d1s",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"nrks2d1s",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[2].sp_form != ft_opaque)||
          (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[2].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[2].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",3,"nrks2d1s",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectX1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"nrks2d1s",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY1 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"nrks2d1s",
         abend_opnd_str(SETL_SYSTEM argv+1));

  if (argv[2].sp_form == ft_proc) {
#ifndef TUNSAFE
     nrks2d1sQUADVL_instance = plugin_instance;
#endif
     nrks2d1sQUADVL_callback.sp_form = ft_proc;
     nrks2d1sQUADVL_callback.sp_val.sp_proc_ptr = argv[2].sp_val.sp_proc_ptr;

     QUADVLcallback = (void*)nrks2d1sQUADVL_c_callback;
  } else {
     QUADVLcallback = 
         (void *)(((struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectX1->r;
   if (n != fvectY1->r)
      abend(SETL_SYSTEM "Wrong first dimension in nrks2d1s (parameter 3)");


   nrks2d1s((float *)(fvectX1->p),(float *)(fvectY1->p),n,QUADVLcallback,&floatD1,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatD1);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void KS2D2S(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX1; /* r */ 
struct nrmatrix * fvectY1; /* r */ 
struct nrmatrix * fvectX2; /* r */ 
struct nrmatrix * fvectY2; /* r */ 
float floatD; /* w */ 
float floatPROB; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ks2d2s",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"ks2d2s",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"ks2d2s",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"ks2d2s",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectX1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ks2d2s",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY1 = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"ks2d2s",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectX2 = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectX2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"ks2d2s",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectY2 = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectY2->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"ks2d2s",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fvectX1->r;
   if (n != fvectY1->r)
      abend(SETL_SYSTEM "Wrong first dimension in ks2d2s (parameter 3)");
   m = fvectX2->r;
   if (m != fvectY2->r)
      abend(SETL_SYSTEM "Wrong first dimension in ks2d2s (parameter 5)");


   ks2d2s((float *)(fvectX1->p),(float *)(fvectY1->p),n,(float *)(fvectX2->p),(float *)(fvectY2->p),m,&floatD,&floatPROB);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatD);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatPROB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void QUADCT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatY; /* r */ 
struct nrmatrix * fvectXX; /* r */ 
struct nrmatrix * fvectYY; /* r */ 
float floatFA; /* w */ 
float floatFB; /* w */ 
float floatFC; /* w */ 
float floatFD; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"quadct",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"quadct",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"quadct",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"quadct",
         abend_opnd_str(SETL_SYSTEM argv+3));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatY = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatY = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectXX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectXX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"quadct",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectYY = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectYY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"quadct",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fvectXX->r;
   if (n != fvectYY->r)
      abend(SETL_SYSTEM "Wrong first dimension in quadct (parameter 5)");


   quadct(floatX,floatY,(float *)(fvectXX->p),(float *)(fvectYY->p),n,&floatFA,&floatFB,&floatFC,&floatFD);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatFA);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatFB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatFC);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatFD);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void QUADVL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatY; /* r */ 
float floatFA; /* w */ 
float floatFB; /* w */ 
float floatFC; /* w */ 
float floatFD; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"quadvl",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"quadvl",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatY = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatY = (float)((argv[1].sp_val.sp_real_ptr)->r_value);



   quadvl(floatX,floatY,&floatFA,&floatFB,&floatFC,&floatFD);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatFA);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatFB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatFC);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatFD);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void SAVGOL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY1; /* rw */ 
int integerNL; /* r */ 
int integerNR; /* r */ 
int integerLD; /* r */ 
int integerM; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"savgol",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"savgol",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"savgol",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"savgol",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"savgol",
         abend_opnd_str(SETL_SYSTEM argv+4));


   fvectY1 = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY1->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"savgol",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerNL = (argv[1].sp_val.sp_short_value);

   integerNR = (argv[2].sp_val.sp_short_value);

   integerLD = (argv[3].sp_val.sp_short_value);

   integerM = (argv[4].sp_val.sp_short_value);


   n = fvectY1->r;

   if (fvectY1->use_count!=1) 
      fvectY1=nr_copy(fvectY1);
   if (fvectY1==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   savgol((float *)(fvectY1->p),n,integerNL,integerNR,integerLD,integerM);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY1;
   push_pstack(&return1);



}

void FIT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectSIG; /* r */ 
int integerMWT; /* r */ 
float floatA; /* w */ 
float floatB; /* w */ 
float floatSIGA; /* w */ 
float floatSIGB; /* w */ 
float floatCHI2; /* w */ 
float floatQ; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;
specifier return6;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"fit",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"fit",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"fit",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"fit",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"fit",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"fit",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectSIG = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectSIG->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"fit",
         abend_opnd_str(SETL_SYSTEM argv+2));

   integerMWT = (argv[3].sp_val.sp_short_value);


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in fit (parameter 3)");
   if (n != fvectSIG->r)
      abend(SETL_SYSTEM "Wrong first dimension in fit (parameter 4)");


   fit((float *)(fvectX->p),(float *)(fvectY->p),n,(float *)(fvectSIG->p),integerMWT,&floatA,&floatB,&floatSIGA,&floatSIGB,&floatCHI2,&floatQ);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatA);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatSIGA);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatSIGB);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatCHI2);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);

   return6.sp_form = ft_real;
   i_get_real(return6.sp_val.sp_real_ptr);
   return6.sp_val.sp_real_ptr->r_value = (double)(floatQ);
   return6.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return6);



}

void FITEXY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectSIGX; /* r */ 
struct nrmatrix * fvectSIGY; /* r */ 
float floatA; /* w */ 
float floatB; /* w */ 
float floatSIGA; /* w */ 
float floatSIGB; /* w */ 
float floatCHI2; /* w */ 
float floatQ; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;
specifier return6;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"fitexy",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"fitexy",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"fitexy",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"fitexy",
         abend_opnd_str(SETL_SYSTEM argv+3));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"fitexy",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"fitexy",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectSIGX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectSIGX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"fitexy",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectSIGY = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectSIGY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"fitexy",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in fitexy (parameter 3)");
   if (n != fvectSIGX->r)
      abend(SETL_SYSTEM "Wrong first dimension in fitexy (parameter 4)");
   if (n != fvectSIGY->r)
      abend(SETL_SYSTEM "Wrong first dimension in fitexy (parameter 5)");


   fitexy((float *)(fvectX->p),(float *)(fvectY->p),n,(float *)(fvectSIGX->p),(float *)(fvectSIGY->p),&floatA,&floatB,&floatSIGA,&floatSIGB,&floatCHI2,&floatQ);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatA);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatSIGA);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatSIGB);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatCHI2);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);

   return6.sp_form = ft_real;
   i_get_real(return6.sp_val.sp_real_ptr);
   return6.sp_val.sp_real_ptr->r_value = (double)(floatQ);
   return6.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return6);



}

void CHIXY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
double doubleBANG; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"chixy",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      doubleBANG = (double)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      doubleBANG = (double)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(chixy(doubleBANG));



}

static specifier lfitFUNCS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type lfitFUNCS_instance;
#endif

void lfitFUNCS_c_callback(float p1,float  p2[],int p3)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = lfitFUNCS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p3;
   push_pstack(&spare);

   save_callback.sp_form = lfitFUNCS_callback.sp_form;
   save_callback.sp_val.sp_biggest = lfitFUNCS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   lfitFUNCS_callback.sp_form = save_callback.sp_form;
   lfitFUNCS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void LFIT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectSIG; /* r */ 
struct nrmatrix * fvectA; /* w */ 
struct nrmatrix * ivectIA; /* r */ 
struct nrmatrix * fmatCOVAR; /* w */ 
float floatCHISQ; /* w */ 
void *FUNCScallback;

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[7].sp_form != ft_opaque)||
          (((argv[7].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[7].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[7].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",8,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+7));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectSIG = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectSIG->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+2));

   ivectIA = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((ivectIA->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",5,"lfit",
         abend_opnd_str(SETL_SYSTEM argv+4));

  if (argv[7].sp_form == ft_proc) {
#ifndef TUNSAFE
     lfitFUNCS_instance = plugin_instance;
#endif
     lfitFUNCS_callback.sp_form = ft_proc;
     lfitFUNCS_callback.sp_val.sp_proc_ptr = argv[7].sp_val.sp_proc_ptr;

     FUNCScallback = (void*)lfitFUNCS_c_callback;
  } else {
     FUNCScallback = 
         (void *)(((struct nrmatrix *)(argv[7].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in lfit (parameter 3)");
   if (n != fvectSIG->r)
      abend(SETL_SYSTEM "Wrong first dimension in lfit (parameter 4)");
   m = ivectIA->r;

   fvectA = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectA->use_count = 0;
   fvectA->type = nr_fvect*65536+nr_type;

   fvectA->r = m;
   fvectA->p = (void*)vector(1,m);
   fmatCOVAR = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatCOVAR->use_count = 0;
   fmatCOVAR->type = nr_fmat*65536+nr_type;

   fmatCOVAR->r = m;
   fmatCOVAR->c = m;
   fmatCOVAR->p = (void*)matrix(1,m,1,m);

   lfit((float *)(fvectX->p),(float *)(fvectY->p),(float *)(fvectSIG->p),n,(float *)(fvectA->p),(int *)(ivectIA->p),m,(float **)(fmatCOVAR->p),&floatCHISQ,FUNCScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatCOVAR;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatCHISQ);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void COVSRT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatCOVAR; /* w */ 
struct nrmatrix * ivectIA; /* r */ 
int integerMFIT; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"covsrt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"covsrt",
         abend_opnd_str(SETL_SYSTEM argv+2));


   ivectIA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((ivectIA->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",2,"covsrt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerMFIT = (argv[2].sp_val.sp_short_value);


   n = ivectIA->r;

   fmatCOVAR = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatCOVAR->use_count = 0;
   fmatCOVAR->type = nr_fmat*65536+nr_type;

   fmatCOVAR->r = n;
   fmatCOVAR->c = n;
   fmatCOVAR->p = (void*)matrix(1,n,1,n);

   covsrt((float **)(fmatCOVAR->p),n,(int *)(ivectIA->p),integerMFIT);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatCOVAR;
   push_pstack(&return1);



}

static specifier svdfitFUNCS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type svdfitFUNCS_instance;
#endif

void svdfitFUNCS_c_callback()
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = svdfitFUNCS_instance;
   save_callback.sp_form = svdfitFUNCS_callback.sp_form;
   save_callback.sp_val.sp_biggest = svdfitFUNCS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  0,YES,NO,0);
   svdfitFUNCS_callback.sp_form = save_callback.sp_form;
   svdfitFUNCS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void SVDFIT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectSIG; /* r */ 
struct nrmatrix * fvectA; /* rw */ 
struct nrmatrix * fmatU; /* rw */ 
struct nrmatrix * fmatV; /* rw */ 
struct nrmatrix * fvectW; /* w */ 
float floatCHISQ; /* w */ 
void *FUNCScallback;

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectSIG = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectSIG->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fvectA = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+3));

   fmatU = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fmatU->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",5,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+4));

   fmatV = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((fmatV->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",6,"svdfit",
         abend_opnd_str(SETL_SYSTEM argv+5));

  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     svdfitFUNCS_instance = plugin_instance;
#endif
     svdfitFUNCS_callback.sp_form = ft_proc;
     svdfitFUNCS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     FUNCScallback = (void*)svdfitFUNCS_c_callback;
  } else {
     FUNCScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in svdfit (parameter 3)");
   if (n != fvectSIG->r)
      abend(SETL_SYSTEM "Wrong first dimension in svdfit (parameter 4)");
   m = fvectA->r;
   if (n != fmatU->r)
      abend(SETL_SYSTEM "Wrong first dimension in svdfit (parameter 6)");
   if (m != fmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in svdfit (parameter 6)");
   if (m != fmatV->r)
      abend(SETL_SYSTEM "Wrong first dimension in svdfit (parameter 7)");
   if (m != fmatV->c)
      abend(SETL_SYSTEM "Wrong second dimension in svdfit (parameter 7)");

   if (fvectA->use_count!=1) 
      fvectA=nr_copy(fvectA);
   if (fvectA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatU->use_count!=1) 
      fmatU=nr_copy(fmatU);
   if (fmatU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatV->use_count!=1) 
      fmatV=nr_copy(fmatV);
   if (fmatV==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = m;
   fvectW->p = (void*)vector(1,m);

   svdfit((float *)(fvectX->p),(float *)(fvectY->p),(float *)(fvectSIG->p),n,(float *)(fvectA->p),m,(float **)(fmatU->p),(float **)(fmatV->p),(float *)(fvectW->p),&floatCHISQ,FUNCScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatU;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatV;
   push_pstack(&return3);

   return4.sp_form = ft_opaque;
   return4.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatCHISQ);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);



}

void SVDVAR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatV; /* w */ 
struct nrmatrix * fvectW; /* w */ 
struct nrmatrix * fmatCVM; /* w */ 

/* Variables used to compute the array bounds */

long m;


specifier return1;
specifier return2;
specifier return3;




   fmatV = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatV->use_count = 0;
   fmatV->type = nr_fmat*65536+nr_type;

   fmatV->r = m;
   fmatV->c = m;
   fmatV->p = (void*)matrix(1,m,1,m);
   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = m;
   fvectW->p = (void*)vector(1,m);
   fmatCVM = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatCVM->use_count = 0;
   fmatCVM->type = nr_fmat*65536+nr_type;

   fmatCVM->r = m;
   fmatCVM->c = m;
   fmatCVM->p = (void*)matrix(1,m,1,m);

   svdvar((float **)(fmatV->p),m,(float *)(fvectW->p),(float **)(fmatCVM->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatV;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatCVM;
   push_pstack(&return3);



}

static specifier nrmrqminFUNCS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type nrmrqminFUNCS_instance;
#endif

void nrmrqminFUNCS_c_callback(double p1,float  p2[],float  p3[],float  p4[],int p5)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = nrmrqminFUNCS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p4);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p5;
   push_pstack(&spare);

   save_callback.sp_form = nrmrqminFUNCS_callback.sp_form;
   save_callback.sp_val.sp_biggest = nrmrqminFUNCS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  5,YES,NO,0);
   nrmrqminFUNCS_callback.sp_form = save_callback.sp_form;
   nrmrqminFUNCS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void NRMRQMIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectSIG; /* w */ 
struct nrmatrix * fvectA; /* w */ 
struct nrmatrix * ivectIA; /* r */ 
struct nrmatrix * fmatCOVAR; /* w */ 
struct nrmatrix * fmatALPHA; /* w */ 
float floatCHISQ; /* w */ 
void *FUNCScallback;
float floatALAMDA; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;
specifier return6;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"nrmrqmin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"nrmrqmin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"nrmrqmin",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"nrmrqmin",
         abend_opnd_str(SETL_SYSTEM argv+8));

   if ((argv[9].sp_form != ft_short) && (argv[9].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",10,"nrmrqmin",
         abend_opnd_str(SETL_SYSTEM argv+9));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"nrmrqmin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"nrmrqmin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ivectIA = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((ivectIA->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",5,"nrmrqmin",
         abend_opnd_str(SETL_SYSTEM argv+4));

  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     nrmrqminFUNCS_instance = plugin_instance;
#endif
     nrmrqminFUNCS_callback.sp_form = ft_proc;
     nrmrqminFUNCS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     FUNCScallback = (void*)nrmrqminFUNCS_c_callback;
  } else {
     FUNCScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[9].sp_form == ft_short)
      floatALAMDA = (float)(argv[9].sp_val.sp_short_value);

   if (argv[9].sp_form == ft_real)
      floatALAMDA = (float)((argv[9].sp_val.sp_real_ptr)->r_value);

   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in nrmrqmin (parameter 3)");
   m = ivectIA->r;

   fvectSIG = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectSIG->use_count = 0;
   fvectSIG->type = nr_fvect*65536+nr_type;

   fvectSIG->r = n;
   fvectSIG->p = (void*)vector(1,n);
   fvectA = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectA->use_count = 0;
   fvectA->type = nr_fvect*65536+nr_type;

   fvectA->r = m;
   fvectA->p = (void*)vector(1,m);
   fmatCOVAR = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatCOVAR->use_count = 0;
   fmatCOVAR->type = nr_fmat*65536+nr_type;

   fmatCOVAR->r = m;
   fmatCOVAR->c = m;
   fmatCOVAR->p = (void*)matrix(1,m,1,m);
   fmatALPHA = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatALPHA->use_count = 0;
   fmatALPHA->type = nr_fmat*65536+nr_type;

   fmatALPHA->r = m;
   fmatALPHA->c = m;
   fmatALPHA->p = (void*)matrix(1,m,1,m);

   nrmrqmin((float *)(fvectX->p),(float *)(fvectY->p),(float *)(fvectSIG->p),n,(float *)(fvectA->p),(int *)(ivectIA->p),m,(float **)(fmatCOVAR->p),(float **)(fmatALPHA->p),&floatCHISQ,FUNCScallback,&floatALAMDA);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectSIG;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatCOVAR;
   push_pstack(&return3);

   return4.sp_form = ft_opaque;
   return4.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatALPHA;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatCHISQ);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);

   return6.sp_form = ft_real;
   i_get_real(return6.sp_val.sp_real_ptr);
   return6.sp_val.sp_real_ptr->r_value = (double)(floatALAMDA);
   return6.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return6);



}

static specifier nrmrqcofFUNCS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type nrmrqcofFUNCS_instance;
#endif

void nrmrqcofFUNCS_c_callback(double p1,float  p2[],float  p3[],float  p4[],int p5)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = nrmrqcofFUNCS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p4);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p5;
   push_pstack(&spare);

   save_callback.sp_form = nrmrqcofFUNCS_callback.sp_form;
   save_callback.sp_val.sp_biggest = nrmrqcofFUNCS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  5,YES,NO,0);
   nrmrqcofFUNCS_callback.sp_form = save_callback.sp_form;
   nrmrqcofFUNCS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void NRMRQCOF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectSIG; /* w */ 
struct nrmatrix * fvectA; /* w */ 
struct nrmatrix * ivectIA; /* r */ 
struct nrmatrix * fmatALPHA; /* w */ 
struct nrmatrix * fvectBETA; /* w */ 
float floatCHISQ; /* w */ 
void *FUNCScallback;

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"nrmrqcof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"nrmrqcof",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"nrmrqcof",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"nrmrqcof",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"nrmrqcof",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"nrmrqcof",
         abend_opnd_str(SETL_SYSTEM argv+1));

   ivectIA = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((ivectIA->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",5,"nrmrqcof",
         abend_opnd_str(SETL_SYSTEM argv+4));

  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     nrmrqcofFUNCS_instance = plugin_instance;
#endif
     nrmrqcofFUNCS_callback.sp_form = ft_proc;
     nrmrqcofFUNCS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     FUNCScallback = (void*)nrmrqcofFUNCS_c_callback;
  } else {
     FUNCScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in nrmrqcof (parameter 3)");
   m = ivectIA->r;

   fvectSIG = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectSIG->use_count = 0;
   fvectSIG->type = nr_fvect*65536+nr_type;

   fvectSIG->r = n;
   fvectSIG->p = (void*)vector(1,n);
   fvectA = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectA->use_count = 0;
   fvectA->type = nr_fvect*65536+nr_type;

   fvectA->r = m;
   fvectA->p = (void*)vector(1,m);
   fmatALPHA = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatALPHA->use_count = 0;
   fmatALPHA->type = nr_fmat*65536+nr_type;

   fmatALPHA->r = m;
   fmatALPHA->c = m;
   fmatALPHA->p = (void*)matrix(1,m,1,m);
   fvectBETA = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectBETA->use_count = 0;
   fvectBETA->type = nr_fvect*65536+nr_type;

   fvectBETA->r = m;
   fvectBETA->p = (void*)vector(1,m);

   nrmrqcof((float *)(fvectX->p),(float *)(fvectY->p),(float *)(fvectSIG->p),n,(float *)(fvectA->p),(int *)(ivectIA->p),m,(float **)(fmatALPHA->p),(float *)(fvectBETA->p),&floatCHISQ,FUNCScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectSIG;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectA;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatALPHA;
   push_pstack(&return3);

   return4.sp_form = ft_opaque;
   return4.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectBETA;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatCHISQ);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);



}

void MEDFIT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
float floatA; /* w */ 
float floatB; /* w */ 
float floatABDEV; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"medfit",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"medfit",
         abend_opnd_str(SETL_SYSTEM argv+1));


   fvectX = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"medfit",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"medfit",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectX->r;
   if (n != fvectY->r)
      abend(SETL_SYSTEM "Wrong first dimension in medfit (parameter 3)");


   medfit((float *)(fvectX->p),(float *)(fvectY->p),n,&floatA,&floatB,&floatABDEV);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatA);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatB);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatABDEV);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);



}

void ROFUNC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatB; /* r */ 


   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"rofunc",
         abend_opnd_str(SETL_SYSTEM argv+0));


   if (argv[0].sp_form == ft_short)
      floatB = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatB = (float)((argv[0].sp_val.sp_real_ptr)->r_value);



   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(rofunc(floatB));



}

void FGAUSS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
struct nrmatrix * fvectA; /* r */ 
float floatY; /* w */ 
struct nrmatrix * fvectDYDA; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"fgauss",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"fgauss",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   fvectA = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectA->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"fgauss",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectA->r;

   fvectDYDA = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectDYDA->use_count = 0;
   fvectDYDA->type = nr_fvect*65536+nr_type;

   fvectDYDA->r = n;
   fvectDYDA->p = (void*)vector(1,n);

   fgauss(floatX,(float *)(fvectA->p),&floatY,(float *)(fvectDYDA->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_real;
   i_get_real(return1.sp_val.sp_real_ptr);
   return1.sp_val.sp_real_ptr->r_value = (double)(floatY);
   return1.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectDYDA;
   push_pstack(&return2);



}

void FLEG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
struct nrmatrix * fvectPL; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"fleg",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"fleg",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   fvectPL = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectPL->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"fleg",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectPL->r;

   if (fvectPL->use_count!=1) 
      fvectPL=nr_copy(fvectPL);
   if (fvectPL==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   fleg(floatX,(float *)(fvectPL->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectPL;
   push_pstack(&return1);



}

void FPOLY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
struct nrmatrix * fvectP; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"fpoly",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"fpoly",
         abend_opnd_str(SETL_SYSTEM argv+1));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   fvectP = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"fpoly",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = fvectP->r;

   if (fvectP->use_count!=1) 
      fvectP=nr_copy(fvectP);
   if (fvectP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   fpoly(floatX,(float *)(fvectP->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectP;
   push_pstack(&return1);



}

static specifier rk4DERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type rk4DERIVS_instance;
#endif

void rk4DERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = rk4DERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = rk4DERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = rk4DERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   rk4DERIVS_callback.sp_form = save_callback.sp_form;
   rk4DERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void RK4(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectDYDX; /* r */ 
float floatX; /* r */ 
float floatH; /* r */ 
struct nrmatrix * fvectYOUT; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rk4",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"rk4",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rk4",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"rk4",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (((argv[5].sp_form != ft_opaque)||
          (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[5].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[5].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",6,"rk4",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"rk4",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDYDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"rk4",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatH = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatH = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
  if (argv[5].sp_form == ft_proc) {
#ifndef TUNSAFE
     rk4DERIVS_instance = plugin_instance;
#endif
     rk4DERIVS_callback.sp_form = ft_proc;
     rk4DERIVS_callback.sp_val.sp_proc_ptr = argv[5].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)rk4DERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in rk4 (parameter 3)");

   fvectYOUT = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYOUT->use_count = 0;
   fvectYOUT->type = nr_fvect*65536+nr_type;

   fvectYOUT->r = n;
   fvectYOUT->p = (void*)vector(1,n);

   rk4((float *)(fvectY->p),(float *)(fvectDYDX->p),n,floatX,floatH,(float *)(fvectYOUT->p),DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYOUT;
   push_pstack(&return1);



}

static specifier rkdumb2DERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type rkdumb2DERIVS_instance;
#endif

void rkdumb2DERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = rkdumb2DERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = rkdumb2DERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = rkdumb2DERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   rkdumb2DERIVS_callback.sp_form = save_callback.sp_form;
   rkdumb2DERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void RKDUMB2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectVSTART; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
void *DERIVScallback;
struct nrmatrix * fmatY; /* rw */ 
struct nrmatrix * fvectXX; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+5));


   fvectVSTART = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectVSTART->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     rkdumb2DERIVS_instance = plugin_instance;
#endif
     rkdumb2DERIVS_callback.sp_form = ft_proc;
     rkdumb2DERIVS_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)rkdumb2DERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }
   fmatY = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fmatY->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",5,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+4));

   fvectXX = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((fvectXX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",6,"rkdumb2",
         abend_opnd_str(SETL_SYSTEM argv+5));


   n = fvectVSTART->r;
   if (n != fmatY->r)
      abend(SETL_SYSTEM "Wrong first dimension in rkdumb2 (parameter 6)");
   m = fmatY->c;
   if (m != fvectXX->r)
      abend(SETL_SYSTEM "Wrong first dimension in rkdumb2 (parameter 7)");

   if (fmatY->use_count!=1) 
      fmatY=nr_copy(fmatY);
   if (fmatY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fvectXX->use_count!=1) 
      fvectXX=nr_copy(fvectXX);
   if (fvectXX==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   rkdumb2((float *)(fvectVSTART->p),n,floatX1,floatX2,m-1,DERIVScallback,(float **)(fmatY->p),(float *)(fvectXX->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatY;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectXX;
   push_pstack(&return2);



}

static specifier rkqsDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type rkqsDERIVS_instance;
#endif

void rkqsDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = rkqsDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = rkqsDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = rkqsDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   rkqsDERIVS_callback.sp_form = save_callback.sp_form;
   rkqsDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void RKQS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* rw */ 
struct nrmatrix * fvectDYDX; /* r */ 
float floatX; /* rw */ 
float floatHTRY; /* r */ 
float floatEPS; /* r */ 
struct nrmatrix * fvectYSCAL; /* r */ 
float floatHDID; /* w */ 
float floatHNEXT; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDYDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatHTRY = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatHTRY = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatEPS = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatEPS = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   fvectYSCAL = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((fvectYSCAL->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",6,"rkqs",
         abend_opnd_str(SETL_SYSTEM argv+5));

  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     rkqsDERIVS_instance = plugin_instance;
#endif
     rkqsDERIVS_callback.sp_form = ft_proc;
     rkqsDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)rkqsDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in rkqs (parameter 3)");
   if (n != fvectYSCAL->r)
      abend(SETL_SYSTEM "Wrong first dimension in rkqs (parameter 7)");

   if (fvectY->use_count!=1) 
      fvectY=nr_copy(fvectY);
   if (fvectY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   rkqs((float *)(fvectY->p),(float *)(fvectDYDX->p),n,&floatX,floatHTRY,floatEPS,(float *)(fvectYSCAL->p),&floatHDID,&floatHNEXT,DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatHDID);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatHNEXT);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

static specifier rkckDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type rkckDERIVS_instance;
#endif

void rkckDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = rkckDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = rkckDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = rkckDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   rkckDERIVS_callback.sp_form = save_callback.sp_form;
   rkckDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void RKCK(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectDYDX; /* r */ 
float floatX; /* r */ 
float floatH; /* r */ 
struct nrmatrix * fvectYOUT; /* w */ 
struct nrmatrix * fvectYERR; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rkck",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"rkck",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"rkck",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"rkck",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (((argv[6].sp_form != ft_opaque)||
          (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[6].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[6].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",7,"rkck",
         abend_opnd_str(SETL_SYSTEM argv+6));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"rkck",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDYDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"rkck",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatH = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatH = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
  if (argv[6].sp_form == ft_proc) {
#ifndef TUNSAFE
     rkckDERIVS_instance = plugin_instance;
#endif
     rkckDERIVS_callback.sp_form = ft_proc;
     rkckDERIVS_callback.sp_val.sp_proc_ptr = argv[6].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)rkckDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in rkck (parameter 3)");

   fvectYOUT = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYOUT->use_count = 0;
   fvectYOUT->type = nr_fvect*65536+nr_type;

   fvectYOUT->r = n;
   fvectYOUT->p = (void*)vector(1,n);
   fvectYERR = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYERR->use_count = 0;
   fvectYERR->type = nr_fvect*65536+nr_type;

   fvectYERR->r = n;
   fvectYERR->p = (void*)vector(1,n);

   rkck((float *)(fvectY->p),(float *)(fvectDYDX->p),n,floatX,floatH,(float *)(fvectYOUT->p),(float *)(fvectYERR->p),DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYOUT;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYERR;
   push_pstack(&return2);



}

static specifier ode_solveDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type ode_solveDERIVS_instance;
#endif

void ode_solveDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = ode_solveDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = ode_solveDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = ode_solveDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   ode_solveDERIVS_callback.sp_form = save_callback.sp_form;
   ode_solveDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void ODE_SOLVE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectYSTART; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatEPS; /* r */ 
float floatH1; /* r */ 
float floatHMIN; /* r */ 
int integerNOK; /* w */ 
int integerNBAD; /* w */ 
void *DERIVScallback;
int integerKOUNT; /* w */ 
float floatDXSAV; /* r */ 
struct nrmatrix * fvectXP; /* rw */ 
struct nrmatrix * fmatYP; /* w */ 

/* Variables used to compute the array bounds */

long n;
long k;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+8));

   if ((argv[10].sp_form != ft_short) && (argv[10].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",11,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+10));

   if ((argv[11].sp_form != ft_opaque)||
       (((argv[11].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",12,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+11));


   fvectYSTART = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectYSTART->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatEPS = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatEPS = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatH1 = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatH1 = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatHMIN = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatHMIN = (float)((argv[5].sp_val.sp_real_ptr)->r_value);
  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     ode_solveDERIVS_instance = plugin_instance;
#endif
     ode_solveDERIVS_callback.sp_form = ft_proc;
     ode_solveDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)ode_solveDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[10].sp_form == ft_short)
      floatDXSAV = (float)(argv[10].sp_val.sp_short_value);

   if (argv[10].sp_form == ft_real)
      floatDXSAV = (float)((argv[10].sp_val.sp_real_ptr)->r_value);
   fvectXP = (struct nrmatrix *)(argv[11].sp_val.sp_opaque_ptr);

   if (((fvectXP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",12,"ode_solve",
         abend_opnd_str(SETL_SYSTEM argv+11));


   n = fvectYSTART->r;
   k = fvectXP->r;

   if (fvectXP->use_count!=1) 
      fvectXP=nr_copy(fvectXP);
   if (fvectXP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fmatYP = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatYP->use_count = 0;
   fmatYP->type = nr_fmat*65536+nr_type;

   fmatYP->r = n;
   fmatYP->c = k;
   fmatYP->p = (void*)matrix(1,n,1,k);

   ode_solve((float *)(fvectYSTART->p),n,floatX1,floatX2,floatEPS,floatH1,floatHMIN,&integerNOK,&integerNBAD,DERIVScallback,k,&integerKOUNT,floatDXSAV,(float *)(fvectXP->p),(float **)(fmatYP->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerNOK;

   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerNBAD;

   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerKOUNT;

   push_pstack(&return3);

   return4.sp_form = ft_opaque;
   return4.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectXP;
   push_pstack(&return4);

   return5.sp_form = ft_opaque;
   return5.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatYP;
   push_pstack(&return5);



}

static specifier ode_solve_bsDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type ode_solve_bsDERIVS_instance;
#endif

void ode_solve_bsDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = ode_solve_bsDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = ode_solve_bsDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = ode_solve_bsDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   ode_solve_bsDERIVS_callback.sp_form = save_callback.sp_form;
   ode_solve_bsDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void ODE_SOLVE_BS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectYSTART; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatEPS; /* r */ 
float floatH1; /* r */ 
float floatHMIN; /* r */ 
int integerNOK; /* w */ 
int integerNBAD; /* w */ 
void *DERIVScallback;
int integerKOUNT; /* w */ 
float floatDXSAV; /* r */ 
struct nrmatrix * fvectXP; /* rw */ 
struct nrmatrix * fmatYP; /* w */ 

/* Variables used to compute the array bounds */

long n;
long k;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+8));

   if ((argv[10].sp_form != ft_short) && (argv[10].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",11,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+10));

   if ((argv[11].sp_form != ft_opaque)||
       (((argv[11].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",12,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+11));


   fvectYSTART = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectYSTART->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatEPS = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatEPS = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatH1 = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatH1 = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatHMIN = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatHMIN = (float)((argv[5].sp_val.sp_real_ptr)->r_value);
  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     ode_solve_bsDERIVS_instance = plugin_instance;
#endif
     ode_solve_bsDERIVS_callback.sp_form = ft_proc;
     ode_solve_bsDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)ode_solve_bsDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[10].sp_form == ft_short)
      floatDXSAV = (float)(argv[10].sp_val.sp_short_value);

   if (argv[10].sp_form == ft_real)
      floatDXSAV = (float)((argv[10].sp_val.sp_real_ptr)->r_value);
   fvectXP = (struct nrmatrix *)(argv[11].sp_val.sp_opaque_ptr);

   if (((fvectXP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",12,"ode_solve_bs",
         abend_opnd_str(SETL_SYSTEM argv+11));


   n = fvectYSTART->r;
   k = fvectXP->r;

   if (fvectXP->use_count!=1) 
      fvectXP=nr_copy(fvectXP);
   if (fvectXP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fmatYP = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatYP->use_count = 0;
   fmatYP->type = nr_fmat*65536+nr_type;

   fmatYP->r = n;
   fmatYP->c = k;
   fmatYP->p = (void*)matrix(1,n,1,k);

   ode_solve_bs((float *)(fvectYSTART->p),n,floatX1,floatX2,floatEPS,floatH1,floatHMIN,&integerNOK,&integerNBAD,DERIVScallback,k,&integerKOUNT,floatDXSAV,(float *)(fvectXP->p),(float **)(fmatYP->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerNOK;

   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerNBAD;

   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerKOUNT;

   push_pstack(&return3);

   return4.sp_form = ft_opaque;
   return4.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectXP;
   push_pstack(&return4);

   return5.sp_form = ft_opaque;
   return5.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatYP;
   push_pstack(&return5);



}

static specifier ode_solve_stiff_bsDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type ode_solve_stiff_bsDERIVS_instance;
#endif

void ode_solve_stiff_bsDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = ode_solve_stiff_bsDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = ode_solve_stiff_bsDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = ode_solve_stiff_bsDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   ode_solve_stiff_bsDERIVS_callback.sp_form = save_callback.sp_form;
   ode_solve_stiff_bsDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static specifier ode_solve_stiff_bsJACOBN_callback;
#ifndef TUNSAFE
plugin_item_ptr_type ode_solve_stiff_bsJACOBN_instance;
#endif

void ode_solve_stiff_bsJACOBN_c_callback(float p1,float  p2[],float  p3[],float  p4[],int p5)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = ode_solve_stiff_bsJACOBN_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p4);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p5;
   push_pstack(&spare);

   save_callback.sp_form = ode_solve_stiff_bsJACOBN_callback.sp_form;
   save_callback.sp_val.sp_biggest = ode_solve_stiff_bsJACOBN_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  5,YES,NO,0);
   ode_solve_stiff_bsJACOBN_callback.sp_form = save_callback.sp_form;
   ode_solve_stiff_bsJACOBN_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void ODE_SOLVE_STIFF_BS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectYSTART; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatEPS; /* r */ 
float floatH1; /* r */ 
float floatHMIN; /* r */ 
int integerNOK; /* w */ 
int integerNBAD; /* w */ 
void *DERIVScallback;
int integerKOUNT; /* w */ 
float floatDXSAV; /* r */ 
struct nrmatrix * fvectXP; /* rw */ 
struct nrmatrix * fmatYP; /* w */ 
void *JACOBNcallback;

/* Variables used to compute the array bounds */

long n;
long k;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+8));

   if ((argv[10].sp_form != ft_short) && (argv[10].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",11,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+10));

   if ((argv[11].sp_form != ft_opaque)||
       (((argv[11].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",12,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+11));

   if (((argv[13].sp_form != ft_opaque)||
          (((argv[13].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[13].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[13].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",14,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+13));


   fvectYSTART = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectYSTART->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatEPS = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatEPS = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatH1 = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatH1 = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatHMIN = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatHMIN = (float)((argv[5].sp_val.sp_real_ptr)->r_value);
  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     ode_solve_stiff_bsDERIVS_instance = plugin_instance;
#endif
     ode_solve_stiff_bsDERIVS_callback.sp_form = ft_proc;
     ode_solve_stiff_bsDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)ode_solve_stiff_bsDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[10].sp_form == ft_short)
      floatDXSAV = (float)(argv[10].sp_val.sp_short_value);

   if (argv[10].sp_form == ft_real)
      floatDXSAV = (float)((argv[10].sp_val.sp_real_ptr)->r_value);
   fvectXP = (struct nrmatrix *)(argv[11].sp_val.sp_opaque_ptr);

   if (((fvectXP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",12,"ode_solve_stiff_bs",
         abend_opnd_str(SETL_SYSTEM argv+11));

  if (argv[13].sp_form == ft_proc) {
#ifndef TUNSAFE
     ode_solve_stiff_bsJACOBN_instance = plugin_instance;
#endif
     ode_solve_stiff_bsJACOBN_callback.sp_form = ft_proc;
     ode_solve_stiff_bsJACOBN_callback.sp_val.sp_proc_ptr = argv[13].sp_val.sp_proc_ptr;

     JACOBNcallback = (void*)ode_solve_stiff_bsJACOBN_c_callback;
  } else {
     JACOBNcallback = 
         (void *)(((struct nrmatrix *)(argv[13].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectYSTART->r;
   k = fvectXP->r;

   if (fvectXP->use_count!=1) 
      fvectXP=nr_copy(fvectXP);
   if (fvectXP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fmatYP = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatYP->use_count = 0;
   fmatYP->type = nr_fmat*65536+nr_type;

   fmatYP->r = n;
   fmatYP->c = k;
   fmatYP->p = (void*)matrix(1,n,1,k);

   ode_solve_stiff_bs((float *)(fvectYSTART->p),n,floatX1,floatX2,floatEPS,floatH1,floatHMIN,&integerNOK,&integerNBAD,DERIVScallback,k,&integerKOUNT,floatDXSAV,(float *)(fvectXP->p),(float **)(fmatYP->p),JACOBNcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerNOK;

   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerNBAD;

   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerKOUNT;

   push_pstack(&return3);

   return4.sp_form = ft_opaque;
   return4.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectXP;
   push_pstack(&return4);

   return5.sp_form = ft_opaque;
   return5.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatYP;
   push_pstack(&return5);



}

static specifier ode_solve_stiffDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type ode_solve_stiffDERIVS_instance;
#endif

void ode_solve_stiffDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = ode_solve_stiffDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = ode_solve_stiffDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = ode_solve_stiffDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   ode_solve_stiffDERIVS_callback.sp_form = save_callback.sp_form;
   ode_solve_stiffDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static specifier ode_solve_stiffJACOBN_callback;
#ifndef TUNSAFE
plugin_item_ptr_type ode_solve_stiffJACOBN_instance;
#endif

void ode_solve_stiffJACOBN_c_callback(float p1,float  p2[],float  p3[],float  p4[],int p5)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = ode_solve_stiffJACOBN_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p4);
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p5;
   push_pstack(&spare);

   save_callback.sp_form = ode_solve_stiffJACOBN_callback.sp_form;
   save_callback.sp_val.sp_biggest = ode_solve_stiffJACOBN_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  5,YES,NO,0);
   ode_solve_stiffJACOBN_callback.sp_form = save_callback.sp_form;
   ode_solve_stiffJACOBN_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void ODE_SOLVE_STIFF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectYSTART; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatEPS; /* r */ 
float floatH1; /* r */ 
float floatHMIN; /* r */ 
int integerNOK; /* w */ 
int integerNBAD; /* w */ 
void *DERIVScallback;
int integerKOUNT; /* w */ 
float floatDXSAV; /* r */ 
struct nrmatrix * fvectXP; /* rw */ 
struct nrmatrix * fmatYP; /* w */ 
void *JACOBNcallback;

/* Variables used to compute the array bounds */

long n;
long k;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+8));

   if ((argv[10].sp_form != ft_short) && (argv[10].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",11,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+10));

   if ((argv[11].sp_form != ft_opaque)||
       (((argv[11].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",12,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+11));

   if (((argv[13].sp_form != ft_opaque)||
          (((argv[13].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[13].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[13].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",14,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+13));


   fvectYSTART = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectYSTART->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatX1 = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatX1 = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatX2 = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX2 = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatEPS = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatEPS = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatH1 = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatH1 = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatHMIN = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatHMIN = (float)((argv[5].sp_val.sp_real_ptr)->r_value);
  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     ode_solve_stiffDERIVS_instance = plugin_instance;
#endif
     ode_solve_stiffDERIVS_callback.sp_form = ft_proc;
     ode_solve_stiffDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)ode_solve_stiffDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }
   if (argv[10].sp_form == ft_short)
      floatDXSAV = (float)(argv[10].sp_val.sp_short_value);

   if (argv[10].sp_form == ft_real)
      floatDXSAV = (float)((argv[10].sp_val.sp_real_ptr)->r_value);
   fvectXP = (struct nrmatrix *)(argv[11].sp_val.sp_opaque_ptr);

   if (((fvectXP->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",12,"ode_solve_stiff",
         abend_opnd_str(SETL_SYSTEM argv+11));

  if (argv[13].sp_form == ft_proc) {
#ifndef TUNSAFE
     ode_solve_stiffJACOBN_instance = plugin_instance;
#endif
     ode_solve_stiffJACOBN_callback.sp_form = ft_proc;
     ode_solve_stiffJACOBN_callback.sp_val.sp_proc_ptr = argv[13].sp_val.sp_proc_ptr;

     JACOBNcallback = (void*)ode_solve_stiffJACOBN_c_callback;
  } else {
     JACOBNcallback = 
         (void *)(((struct nrmatrix *)(argv[13].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectYSTART->r;
   k = fvectXP->r;

   if (fvectXP->use_count!=1) 
      fvectXP=nr_copy(fvectXP);
   if (fvectXP==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fmatYP = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatYP->use_count = 0;
   fmatYP->type = nr_fmat*65536+nr_type;

   fmatYP->r = n;
   fmatYP->c = k;
   fmatYP->p = (void*)matrix(1,n,1,k);

   ode_solve_stiff((float *)(fvectYSTART->p),n,floatX1,floatX2,floatEPS,floatH1,floatHMIN,&integerNOK,&integerNBAD,DERIVScallback,k,&integerKOUNT,floatDXSAV,(float *)(fvectXP->p),(float **)(fmatYP->p),JACOBNcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerNOK;

   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerNBAD;

   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerKOUNT;

   push_pstack(&return3);

   return4.sp_form = ft_opaque;
   return4.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectXP;
   push_pstack(&return4);

   return5.sp_form = ft_opaque;
   return5.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatYP;
   push_pstack(&return5);



}

static specifier mmidDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type mmidDERIVS_instance;
#endif

void mmidDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = mmidDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = mmidDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = mmidDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   mmidDERIVS_callback.sp_form = save_callback.sp_form;
   mmidDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void MMID(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectDYDX; /* r */ 
float floatXS; /* r */ 
float floatHTOT; /* r */ 
int integerNSTEP; /* r */ 
struct nrmatrix * fvectYOUT; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mmid",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mmid",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"mmid",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"mmid",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"mmid",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[6].sp_form != ft_opaque)||
          (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[6].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[6].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",7,"mmid",
         abend_opnd_str(SETL_SYSTEM argv+6));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"mmid",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDYDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"mmid",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatXS = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatXS = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatHTOT = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatHTOT = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   integerNSTEP = (argv[4].sp_val.sp_short_value);

  if (argv[6].sp_form == ft_proc) {
#ifndef TUNSAFE
     mmidDERIVS_instance = plugin_instance;
#endif
     mmidDERIVS_callback.sp_form = ft_proc;
     mmidDERIVS_callback.sp_val.sp_proc_ptr = argv[6].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)mmidDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in mmid (parameter 3)");

   fvectYOUT = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYOUT->use_count = 0;
   fvectYOUT->type = nr_fvect*65536+nr_type;

   fvectYOUT->r = n;
   fvectYOUT->p = (void*)vector(1,n);

   mmid((float *)(fvectY->p),(float *)(fvectDYDX->p),n,floatXS,floatHTOT,integerNSTEP,(float *)(fvectYOUT->p),DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYOUT;
   push_pstack(&return1);



}

static specifier bsstepDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type bsstepDERIVS_instance;
#endif

void bsstepDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = bsstepDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = bsstepDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = bsstepDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   bsstepDERIVS_callback.sp_form = save_callback.sp_form;
   bsstepDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void BSSTEP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* rw */ 
struct nrmatrix * fvectDYDX; /* r */ 
float floatXX; /* rw */ 
float floatHTRY; /* r */ 
float floatEPS; /* r */ 
struct nrmatrix * fvectSCAL; /* r */ 
float floatHDID; /* w */ 
float floatHNEXT; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDYDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatXX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatXX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatHTRY = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatHTRY = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatEPS = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatEPS = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   fvectSCAL = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((fvectSCAL->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",6,"bsstep",
         abend_opnd_str(SETL_SYSTEM argv+5));

  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     bsstepDERIVS_instance = plugin_instance;
#endif
     bsstepDERIVS_callback.sp_form = ft_proc;
     bsstepDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)bsstepDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in bsstep (parameter 3)");
   if (n != fvectSCAL->r)
      abend(SETL_SYSTEM "Wrong first dimension in bsstep (parameter 7)");

   if (fvectY->use_count!=1) 
      fvectY=nr_copy(fvectY);
   if (fvectY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   bsstep((float *)(fvectY->p),(float *)(fvectDYDX->p),n,&floatXX,floatHTRY,floatEPS,(float *)(fvectSCAL->p),&floatHDID,&floatHNEXT,DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatXX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatHDID);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatHNEXT);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

void PZEXTR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerIEST; /* r */ 
float floatXEST; /* r */ 
struct nrmatrix * fvectYEST; /* r */ 
struct nrmatrix * fvectYZ; /* w */ 
struct nrmatrix * fvectDY; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"pzextr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"pzextr",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"pzextr",
         abend_opnd_str(SETL_SYSTEM argv+2));


   integerIEST = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatXEST = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatXEST = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectYEST = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectYEST->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"pzextr",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectYEST->r;

   fvectYZ = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYZ->use_count = 0;
   fvectYZ->type = nr_fvect*65536+nr_type;

   fvectYZ->r = n;
   fvectYZ->p = (void*)vector(1,n);
   fvectDY = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectDY->use_count = 0;
   fvectDY->type = nr_fvect*65536+nr_type;

   fvectDY->r = n;
   fvectDY->p = (void*)vector(1,n);

   pzextr(integerIEST,floatXEST,(float *)(fvectYEST->p),(float *)(fvectYZ->p),(float *)(fvectDY->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYZ;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectDY;
   push_pstack(&return2);



}

void RZEXTR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerIEST; /* r */ 
float floatXEST; /* r */ 
struct nrmatrix * fvectYEST; /* r */ 
struct nrmatrix * fvectYZ; /* w */ 
struct nrmatrix * fvectDY; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"rzextr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"rzextr",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"rzextr",
         abend_opnd_str(SETL_SYSTEM argv+2));


   integerIEST = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatXEST = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatXEST = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectYEST = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectYEST->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"rzextr",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = fvectYEST->r;

   fvectYZ = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYZ->use_count = 0;
   fvectYZ->type = nr_fvect*65536+nr_type;

   fvectYZ->r = n;
   fvectYZ->p = (void*)vector(1,n);
   fvectDY = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectDY->use_count = 0;
   fvectDY->type = nr_fvect*65536+nr_type;

   fvectDY->r = n;
   fvectDY->p = (void*)vector(1,n);

   rzextr(integerIEST,floatXEST,(float *)(fvectYEST->p),(float *)(fvectYZ->p),(float *)(fvectDY->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYZ;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectDY;
   push_pstack(&return2);



}

static specifier stoermDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type stoermDERIVS_instance;
#endif

void stoermDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = stoermDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = stoermDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = stoermDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   stoermDERIVS_callback.sp_form = save_callback.sp_form;
   stoermDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void STOERM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectD2Y; /* r */ 
float floatXS; /* r */ 
float floatHTOT; /* r */ 
int integerNSTEP; /* r */ 
struct nrmatrix * fvectYOUT; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"stoerm",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"stoerm",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"stoerm",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"stoerm",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"stoerm",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[6].sp_form != ft_opaque)||
          (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[6].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[6].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",7,"stoerm",
         abend_opnd_str(SETL_SYSTEM argv+6));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"stoerm",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectD2Y = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectD2Y->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"stoerm",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatXS = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatXS = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatHTOT = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatHTOT = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   integerNSTEP = (argv[4].sp_val.sp_short_value);

  if (argv[6].sp_form == ft_proc) {
#ifndef TUNSAFE
     stoermDERIVS_instance = plugin_instance;
#endif
     stoermDERIVS_callback.sp_form = ft_proc;
     stoermDERIVS_callback.sp_val.sp_proc_ptr = argv[6].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)stoermDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectD2Y->r)
      abend(SETL_SYSTEM "Wrong first dimension in stoerm (parameter 3)");

   fvectYOUT = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYOUT->use_count = 0;
   fvectYOUT->type = nr_fvect*65536+nr_type;

   fvectYOUT->r = n;
   fvectYOUT->p = (void*)vector(1,n);

   stoerm((float *)(fvectY->p),(float *)(fvectD2Y->p),n,floatXS,floatHTOT,integerNSTEP,(float *)(fvectYOUT->p),DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYOUT;
   push_pstack(&return1);



}

static specifier stiffDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type stiffDERIVS_instance;
#endif

void stiffDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = stiffDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = stiffDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = stiffDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   stiffDERIVS_callback.sp_form = save_callback.sp_form;
   stiffDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void STIFF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* rw */ 
struct nrmatrix * fvectDYDX; /* r */ 
float floatX; /* rw */ 
float floatHTRY; /* r */ 
float floatEPS; /* r */ 
struct nrmatrix * fvectYSCAL; /* w */ 
float floatHDID; /* w */ 
float floatHNEXT; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"stiff",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"stiff",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"stiff",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"stiff",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"stiff",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"stiff",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"stiff",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDYDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"stiff",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatHTRY = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatHTRY = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatEPS = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatEPS = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     stiffDERIVS_instance = plugin_instance;
#endif
     stiffDERIVS_callback.sp_form = ft_proc;
     stiffDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)stiffDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in stiff (parameter 3)");

   if (fvectY->use_count!=1) 
      fvectY=nr_copy(fvectY);
   if (fvectY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectYSCAL = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYSCAL->use_count = 0;
   fvectYSCAL->type = nr_fvect*65536+nr_type;

   fvectYSCAL->r = n;
   fvectYSCAL->p = (void*)vector(1,n);

   stiff((float *)(fvectY->p),(float *)(fvectDYDX->p),n,&floatX,floatHTRY,floatEPS,(float *)(fvectYSCAL->p),&floatHDID,&floatHNEXT,DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYSCAL;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatHDID);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);

   return5.sp_form = ft_real;
   i_get_real(return5.sp_val.sp_real_ptr);
   return5.sp_val.sp_real_ptr->r_value = (double)(floatHNEXT);
   return5.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return5);



}

void JACOBN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectDYDX; /* r */ 
struct nrmatrix * fmatDFDY; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"jacobn",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"jacobn",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"jacobn",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"jacobn",
         abend_opnd_str(SETL_SYSTEM argv+3));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   fvectY = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"jacobn",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectDYDX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"jacobn",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fmatDFDY = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fmatDFDY->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",4,"jacobn",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in jacobn (parameter 4)");
   m = fmatDFDY->r;
   if (m != fmatDFDY->c)
      abend(SETL_SYSTEM "Wrong second dimension in jacobn (parameter 5)");

   if (fmatDFDY->use_count!=1) 
      fmatDFDY=nr_copy(fmatDFDY);
   if (fmatDFDY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   jacobn(floatX,(float *)(fvectY->p),(float *)(fvectDYDX->p),(float **)(fmatDFDY->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatDFDY;
   push_pstack(&return1);



}

static specifier simprDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type simprDERIVS_instance;
#endif

void simprDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = simprDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = simprDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = simprDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   simprDERIVS_callback.sp_form = save_callback.sp_form;
   simprDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void SIMPR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* r */ 
struct nrmatrix * fvectDYDX; /* r */ 
struct nrmatrix * fvectDFDX; /* r */ 
struct nrmatrix * fmatDFDY; /* r */ 
float floatXS; /* r */ 
float floatHTOT; /* r */ 
int integerNSTEP; /* r */ 
struct nrmatrix * fvectYOUT; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_short) && (argv[5].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",6,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (argv[6].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",7,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDYDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+1));

   fvectDFDX = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectDFDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fmatDFDY = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fmatDFDY->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",4,"simpr",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form == ft_short)
      floatXS = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatXS = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   if (argv[5].sp_form == ft_short)
      floatHTOT = (float)(argv[5].sp_val.sp_short_value);

   if (argv[5].sp_form == ft_real)
      floatHTOT = (float)((argv[5].sp_val.sp_real_ptr)->r_value);
   integerNSTEP = (argv[6].sp_val.sp_short_value);

  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     simprDERIVS_instance = plugin_instance;
#endif
     simprDERIVS_callback.sp_form = ft_proc;
     simprDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)simprDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in simpr (parameter 3)");
   if (n != fvectDFDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in simpr (parameter 4)");
   if (n != fmatDFDY->r)
      abend(SETL_SYSTEM "Wrong first dimension in simpr (parameter 5)");
   if (n != fmatDFDY->c)
      abend(SETL_SYSTEM "Wrong second dimension in simpr (parameter 5)");

   fvectYOUT = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectYOUT->use_count = 0;
   fvectYOUT->type = nr_fvect*65536+nr_type;

   fvectYOUT->r = n;
   fvectYOUT->p = (void*)vector(1,n);

   simpr((float *)(fvectY->p),(float *)(fvectDYDX->p),(float *)(fvectDFDX->p),(float **)(fmatDFDY->p),n,floatXS,floatHTOT,integerNSTEP,(float *)(fvectYOUT->p),DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectYOUT;
   push_pstack(&return1);



}

static specifier stifbsDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type stifbsDERIVS_instance;
#endif

void stifbsDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = stifbsDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = stifbsDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = stifbsDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   stifbsDERIVS_callback.sp_form = save_callback.sp_form;
   stifbsDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void STIFBS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectY; /* rw */ 
struct nrmatrix * fvectDYDX; /* r */ 
float floatXX; /* rw */ 
float floatHTRY; /* r */ 
float floatEPSR; /* r */ 
struct nrmatrix * fvectYSCAL; /* r */ 
float floatHDID; /* w */ 
float floatHNEXT; /* w */ 
void *DERIVScallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;
specifier return4;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_short) && (argv[3].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",4,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_short) && (argv[4].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",5,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[8].sp_form != ft_opaque)||
          (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[8].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[8].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",9,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+8));


   fvectY = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectY->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   fvectDYDX = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((fvectDYDX->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",2,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form == ft_short)
      floatXX = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatXX = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   if (argv[3].sp_form == ft_short)
      floatHTRY = (float)(argv[3].sp_val.sp_short_value);

   if (argv[3].sp_form == ft_real)
      floatHTRY = (float)((argv[3].sp_val.sp_real_ptr)->r_value);
   if (argv[4].sp_form == ft_short)
      floatEPSR = (float)(argv[4].sp_val.sp_short_value);

   if (argv[4].sp_form == ft_real)
      floatEPSR = (float)((argv[4].sp_val.sp_real_ptr)->r_value);
   fvectYSCAL = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((fvectYSCAL->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",6,"stifbs",
         abend_opnd_str(SETL_SYSTEM argv+5));

  if (argv[8].sp_form == ft_proc) {
#ifndef TUNSAFE
     stifbsDERIVS_instance = plugin_instance;
#endif
     stifbsDERIVS_callback.sp_form = ft_proc;
     stifbsDERIVS_callback.sp_val.sp_proc_ptr = argv[8].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)stifbsDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectY->r;
   if (n != fvectDYDX->r)
      abend(SETL_SYSTEM "Wrong first dimension in stifbs (parameter 3)");
   if (n != fvectYSCAL->r)
      abend(SETL_SYSTEM "Wrong first dimension in stifbs (parameter 7)");

   if (fvectY->use_count!=1) 
      fvectY=nr_copy(fvectY);
   if (fvectY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   stifbs((float *)(fvectY->p),(float *)(fvectDYDX->p),n,&floatXX,floatHTRY,floatEPSR,(float *)(fvectYSCAL->p),&floatHDID,&floatHNEXT,DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectY;
   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatXX);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);

   return3.sp_form = ft_real;
   i_get_real(return3.sp_val.sp_real_ptr);
   return3.sp_val.sp_real_ptr->r_value = (double)(floatHDID);
   return3.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return3);

   return4.sp_form = ft_real;
   i_get_real(return4.sp_val.sp_real_ptr);
   return4.sp_val.sp_real_ptr->r_value = (double)(floatHNEXT);
   return4.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return4);



}

static specifier setshootLOAD_callback;
#ifndef TUNSAFE
plugin_item_ptr_type setshootLOAD_instance;
#endif

void setshootLOAD_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = setshootLOAD_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = setshootLOAD_callback.sp_form;
   save_callback.sp_val.sp_biggest = setshootLOAD_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   setshootLOAD_callback.sp_form = save_callback.sp_form;
   setshootLOAD_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static specifier setshootSCORE_callback;
#ifndef TUNSAFE
plugin_item_ptr_type setshootSCORE_instance;
#endif

void setshootSCORE_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = setshootSCORE_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = setshootSCORE_callback.sp_form;
   save_callback.sp_val.sp_biggest = setshootSCORE_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   setshootSCORE_callback.sp_form = save_callback.sp_form;
   setshootSCORE_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static specifier setshootDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type setshootDERIVS_instance;
#endif

void setshootDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = setshootDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = setshootDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = setshootDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   setshootDERIVS_callback.sp_form = save_callback.sp_form;
   setshootDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void SETSHOOT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *LOADcallback;
void *SCOREcallback;
void *DERIVScallback;


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"setshoot",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (((argv[1].sp_form != ft_opaque)||
          (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[1].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[1].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",2,"setshoot",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[2].sp_form != ft_opaque)||
          (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[2].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[2].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",3,"setshoot",
         abend_opnd_str(SETL_SYSTEM argv+2));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     setshootLOAD_instance = plugin_instance;
#endif
     setshootLOAD_callback.sp_form = ft_proc;
     setshootLOAD_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     LOADcallback = (void*)setshootLOAD_c_callback;
  } else {
     LOADcallback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[1].sp_form == ft_proc) {
#ifndef TUNSAFE
     setshootSCORE_instance = plugin_instance;
#endif
     setshootSCORE_callback.sp_form = ft_proc;
     setshootSCORE_callback.sp_val.sp_proc_ptr = argv[1].sp_val.sp_proc_ptr;

     SCOREcallback = (void*)setshootSCORE_c_callback;
  } else {
     SCOREcallback = 
         (void *)(((struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[2].sp_form == ft_proc) {
#ifndef TUNSAFE
     setshootDERIVS_instance = plugin_instance;
#endif
     setshootDERIVS_callback.sp_form = ft_proc;
     setshootDERIVS_callback.sp_val.sp_proc_ptr = argv[2].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)setshootDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr))->p);
  }



   setshoot(LOADcallback,SCOREcallback,DERIVScallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;



}

static specifier setshootfLOAD1_callback;
#ifndef TUNSAFE
plugin_item_ptr_type setshootfLOAD1_instance;
#endif

void setshootfLOAD1_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = setshootfLOAD1_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = setshootfLOAD1_callback.sp_form;
   save_callback.sp_val.sp_biggest = setshootfLOAD1_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   setshootfLOAD1_callback.sp_form = save_callback.sp_form;
   setshootfLOAD1_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static specifier setshootfLOAD2_callback;
#ifndef TUNSAFE
plugin_item_ptr_type setshootfLOAD2_instance;
#endif

void setshootfLOAD2_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = setshootfLOAD2_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = setshootfLOAD2_callback.sp_form;
   save_callback.sp_val.sp_biggest = setshootfLOAD2_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   setshootfLOAD2_callback.sp_form = save_callback.sp_form;
   setshootfLOAD2_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static specifier setshootfSCORE_callback;
#ifndef TUNSAFE
plugin_item_ptr_type setshootfSCORE_instance;
#endif

void setshootfSCORE_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = setshootfSCORE_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = setshootfSCORE_callback.sp_form;
   save_callback.sp_val.sp_biggest = setshootfSCORE_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   setshootfSCORE_callback.sp_form = save_callback.sp_form;
   setshootfSCORE_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static specifier setshootfDERIVS_callback;
#ifndef TUNSAFE
plugin_item_ptr_type setshootfDERIVS_instance;
#endif

void setshootfDERIVS_c_callback(float p1,float  p2[],float  p3[])
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = setshootfDERIVS_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p2);
   push_pstack(&spare);

   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p3);
   push_pstack(&spare);

   save_callback.sp_form = setshootfDERIVS_callback.sp_form;
   save_callback.sp_val.sp_biggest = setshootfDERIVS_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   setshootfDERIVS_callback.sp_form = save_callback.sp_form;
   setshootfDERIVS_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void SETSHOOTF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
void *LOAD1callback;
void *LOAD2callback;
void *SCOREcallback;
void *DERIVScallback;
int integerNN2; /* r */ 
int integerNVAR; /* r */ 
float floatX1; /* r */ 
float floatX2; /* r */ 
float floatXF; /* r */ 


   if (((argv[0].sp_form != ft_opaque)||
          (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[0].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[0].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (((argv[1].sp_form != ft_opaque)||
          (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[1].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[1].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",2,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[2].sp_form != ft_opaque)||
          (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[2].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[2].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",3,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[3].sp_form != ft_opaque)||
          (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[3].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[3].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",4,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (argv[5].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",6,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if ((argv[6].sp_form != ft_short) && (argv[6].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",7,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if ((argv[7].sp_form != ft_short) && (argv[7].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",8,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+7));

   if ((argv[8].sp_form != ft_short) && (argv[8].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",9,"setshootf",
         abend_opnd_str(SETL_SYSTEM argv+8));


  if (argv[0].sp_form == ft_proc) {
#ifndef TUNSAFE
     setshootfLOAD1_instance = plugin_instance;
#endif
     setshootfLOAD1_callback.sp_form = ft_proc;
     setshootfLOAD1_callback.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;

     LOAD1callback = (void*)setshootfLOAD1_c_callback;
  } else {
     LOAD1callback = 
         (void *)(((struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[1].sp_form == ft_proc) {
#ifndef TUNSAFE
     setshootfLOAD2_instance = plugin_instance;
#endif
     setshootfLOAD2_callback.sp_form = ft_proc;
     setshootfLOAD2_callback.sp_val.sp_proc_ptr = argv[1].sp_val.sp_proc_ptr;

     LOAD2callback = (void*)setshootfLOAD2_c_callback;
  } else {
     LOAD2callback = 
         (void *)(((struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[2].sp_form == ft_proc) {
#ifndef TUNSAFE
     setshootfSCORE_instance = plugin_instance;
#endif
     setshootfSCORE_callback.sp_form = ft_proc;
     setshootfSCORE_callback.sp_val.sp_proc_ptr = argv[2].sp_val.sp_proc_ptr;

     SCOREcallback = (void*)setshootfSCORE_c_callback;
  } else {
     SCOREcallback = 
         (void *)(((struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[3].sp_form == ft_proc) {
#ifndef TUNSAFE
     setshootfDERIVS_instance = plugin_instance;
#endif
     setshootfDERIVS_callback.sp_form = ft_proc;
     setshootfDERIVS_callback.sp_val.sp_proc_ptr = argv[3].sp_val.sp_proc_ptr;

     DERIVScallback = (void*)setshootfDERIVS_c_callback;
  } else {
     DERIVScallback = 
         (void *)(((struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr))->p);
  }
   integerNN2 = (argv[4].sp_val.sp_short_value);

   integerNVAR = (argv[5].sp_val.sp_short_value);

   if (argv[6].sp_form == ft_short)
      floatX1 = (float)(argv[6].sp_val.sp_short_value);

   if (argv[6].sp_form == ft_real)
      floatX1 = (float)((argv[6].sp_val.sp_real_ptr)->r_value);
   if (argv[7].sp_form == ft_short)
      floatX2 = (float)(argv[7].sp_val.sp_short_value);

   if (argv[7].sp_form == ft_real)
      floatX2 = (float)((argv[7].sp_val.sp_real_ptr)->r_value);
   if (argv[8].sp_form == ft_short)
      floatXF = (float)(argv[8].sp_val.sp_short_value);

   if (argv[8].sp_form == ft_real)
      floatXF = (float)((argv[8].sp_val.sp_real_ptr)->r_value);



   setshootf(LOAD1callback,LOAD2callback,SCOREcallback,DERIVScallback,integerNN2,integerNVAR,floatX1,floatX2,floatXF);

   unmark_specifier(target);
   target->sp_form = ft_omega;



}
void NR_GETCB_SHOOT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{ 
struct nrmatrix *func;

   func = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   func->type    = nr_cback*65536+nr_type;
   func->use_count = 1;

   func->p = (void *)shoot;
   func->r = 0;
   func->c = 0;

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)func;

   return;
  
}

void SHOOT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectV; /* r */ 
struct nrmatrix * fvectF; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"shoot",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectV = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectV->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"shoot",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectV->r;

   fvectF = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectF->use_count = 0;
   fvectF->type = nr_fvect*65536+nr_type;

   fvectF->r = n;
   fvectF->p = (void*)vector(1,n);

   shoot(n,(float *)(fvectV->p),(float *)(fvectF->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectF;
   push_pstack(&return1);



}
void NR_GETCB_SHOOTF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{ 
struct nrmatrix *func;

   func = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   func->type    = nr_cback*65536+nr_type;
   func->use_count = 1;

   func->p = (void *)shootf;
   func->r = 0;
   func->c = 0;

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)func;

   return;
  
}

void SHOOTF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectV; /* r */ 
struct nrmatrix * fvectF; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"shootf",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fvectV = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectV->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"shootf",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fvectV->r;

   fvectF = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectF->use_count = 0;
   fvectF->type = nr_fvect*65536+nr_type;

   fvectF->r = n;
   fvectF->p = (void*)vector(1,n);

   shootf(n,(float *)(fvectV->p),(float *)(fvectF->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectF;
   push_pstack(&return1);



}

void SOLVDE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerITMAX; /* r */ 
float floatCONV; /* r */ 
float floatSLOWC; /* r */ 
struct nrmatrix * fvectSCALV; /* r */ 
struct nrmatrix * ivectINDEXV; /* r */ 
int integerNB; /* r */ 
struct nrmatrix * fmatY; /* rw */ 
struct nrmatrix * ftensC; /* rw */ 
struct nrmatrix * fmatS; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (argv[5].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",6,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if ((argv[6].sp_form != ft_opaque)||
       (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",7,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if ((argv[7].sp_form != ft_opaque)||
       (((argv[7].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",8,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+7));

   if ((argv[8].sp_form != ft_opaque)||
       (((argv[8].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",9,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+8));


   integerITMAX = (argv[0].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_short)
      floatCONV = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatCONV = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatSLOWC = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatSLOWC = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   fvectSCALV = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectSCALV->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+3));

   ivectINDEXV = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((ivectINDEXV->type)>>16)!=nr_ivect)

      abend(SETL_SYSTEM msg_bad_arg,"integer vector",5,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+4));

   integerNB = (argv[5].sp_val.sp_short_value);

   fmatY = (struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr);

   if (((fmatY->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",7,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+6));

   ftensC = (struct nrmatrix *)(argv[7].sp_val.sp_opaque_ptr);

   if (((ftensC->type)>>16)!=nr_ftens)

      abend(SETL_SYSTEM msg_bad_arg,"float tensor",8,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+7));

   fmatS = (struct nrmatrix *)(argv[8].sp_val.sp_opaque_ptr);

   if (((fmatS->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",9,"solvde",
         abend_opnd_str(SETL_SYSTEM argv+8));


   n = fvectSCALV->r;
   if (n != ivectINDEXV->r)
      abend(SETL_SYSTEM "Wrong first dimension in solvde (parameter 6)");
   if (n != fmatY->r)
      abend(SETL_SYSTEM "Wrong first dimension in solvde (parameter 8)");
   m = fmatY->c;
   if (n != ftensC->r)
      abend(SETL_SYSTEM "Wrong first dimension in solvde (parameter 9)");
   if (n != ftensC->c)
      abend(SETL_SYSTEM "Wrong second dimension in solvde (parameter 9)");
   if (n != ftensC->h)
      abend(SETL_SYSTEM "Wrong third dimension in solvde (parameter 9)");
   if (n != fmatS->r)
      abend(SETL_SYSTEM "Wrong first dimension in solvde (parameter 10)");
   if (n != fmatS->c)
      abend(SETL_SYSTEM "Wrong second dimension in solvde (parameter 10)");

   if (fmatY->use_count!=1) 
      fmatY=nr_copy(fmatY);
   if (fmatY==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (ftensC->use_count!=1) 
      ftensC=nr_copy(ftensC);
   if (ftensC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatS->use_count!=1) 
      fmatS=nr_copy(fmatS);
   if (fmatS==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   solvde(integerITMAX,floatCONV,floatSLOWC,(float *)(fvectSCALV->p),(int *)(ivectINDEXV->p),n,integerNB,m,(float **)(fmatY->p),(float ***)(ftensC->p),(float **)(fmatS->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatY;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ftensC;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatS;
   push_pstack(&return3);



}

void PINVS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerIE1; /* r */ 
int integerIE2; /* r */ 
int integerJE1; /* r */ 
int integerJSF; /* r */ 
int integerJC1; /* r */ 
int integerK; /* r */ 
struct nrmatrix * ftensC; /* rw */ 
struct nrmatrix * fmatS; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (argv[5].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",6,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if ((argv[6].sp_form != ft_opaque)||
       (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",7,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if ((argv[7].sp_form != ft_opaque)||
       (((argv[7].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",8,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+7));


   integerIE1 = (argv[0].sp_val.sp_short_value);

   integerIE2 = (argv[1].sp_val.sp_short_value);

   integerJE1 = (argv[2].sp_val.sp_short_value);

   integerJSF = (argv[3].sp_val.sp_short_value);

   integerJC1 = (argv[4].sp_val.sp_short_value);

   integerK = (argv[5].sp_val.sp_short_value);

   ftensC = (struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr);

   if (((ftensC->type)>>16)!=nr_ftens)

      abend(SETL_SYSTEM msg_bad_arg,"float tensor",7,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+6));

   fmatS = (struct nrmatrix *)(argv[7].sp_val.sp_opaque_ptr);

   if (((fmatS->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",8,"pinvs",
         abend_opnd_str(SETL_SYSTEM argv+7));


   n = ftensC->r;
   if (n != ftensC->c)
      abend(SETL_SYSTEM "Wrong second dimension in pinvs (parameter 8)");
   if (n != ftensC->h)
      abend(SETL_SYSTEM "Wrong third dimension in pinvs (parameter 8)");
   if (n != fmatS->r)
      abend(SETL_SYSTEM "Wrong first dimension in pinvs (parameter 9)");
   if (n != fmatS->c)
      abend(SETL_SYSTEM "Wrong second dimension in pinvs (parameter 9)");

   if (ftensC->use_count!=1) 
      ftensC=nr_copy(ftensC);
   if (ftensC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatS->use_count!=1) 
      fmatS=nr_copy(fmatS);
   if (fmatS==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   pinvs(integerIE1,integerIE2,integerJE1,integerJSF,integerJC1,integerK,(float ***)(ftensC->p),(float **)(fmatS->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ftensC;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatS;
   push_pstack(&return2);



}

void RED(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerIZ1; /* r */ 
int integerIZ2; /* r */ 
int integerJZ1; /* r */ 
int integerJZ2; /* r */ 
int integerJM1; /* r */ 
int integerJM2; /* r */ 
int integerJMF; /* r */ 
int integerIC1; /* r */ 
int integerJC1; /* r */ 
int integerJCF; /* r */ 
int integerKC; /* r */ 
struct nrmatrix * ftensC; /* rw */ 
struct nrmatrix * fmatS; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"red",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"red",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"red",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"red",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"red",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (argv[5].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",6,"red",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (argv[6].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",7,"red",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if (argv[7].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",8,"red",
         abend_opnd_str(SETL_SYSTEM argv+7));

   if (argv[8].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",9,"red",
         abend_opnd_str(SETL_SYSTEM argv+8));

   if (argv[9].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",10,"red",
         abend_opnd_str(SETL_SYSTEM argv+9));

   if (argv[10].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",11,"red",
         abend_opnd_str(SETL_SYSTEM argv+10));

   if ((argv[11].sp_form != ft_opaque)||
       (((argv[11].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",12,"red",
         abend_opnd_str(SETL_SYSTEM argv+11));


   integerIZ1 = (argv[0].sp_val.sp_short_value);

   integerIZ2 = (argv[1].sp_val.sp_short_value);

   integerJZ1 = (argv[2].sp_val.sp_short_value);

   integerJZ2 = (argv[3].sp_val.sp_short_value);

   integerJM1 = (argv[4].sp_val.sp_short_value);

   integerJM2 = (argv[5].sp_val.sp_short_value);

   integerJMF = (argv[6].sp_val.sp_short_value);

   integerIC1 = (argv[7].sp_val.sp_short_value);

   integerJC1 = (argv[8].sp_val.sp_short_value);

   integerJCF = (argv[9].sp_val.sp_short_value);

   integerKC = (argv[10].sp_val.sp_short_value);

   ftensC = (struct nrmatrix *)(argv[11].sp_val.sp_opaque_ptr);

   if (((ftensC->type)>>16)!=nr_ftens)

      abend(SETL_SYSTEM msg_bad_arg,"float tensor",12,"red",
         abend_opnd_str(SETL_SYSTEM argv+11));


   n = ftensC->r;
   if (n != ftensC->c)
      abend(SETL_SYSTEM "Wrong second dimension in red (parameter 13)");
   if (n != ftensC->h)
      abend(SETL_SYSTEM "Wrong third dimension in red (parameter 13)");

   if (ftensC->use_count!=1) 
      ftensC=nr_copy(ftensC);
   if (ftensC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fmatS = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fmatS->use_count = 0;
   fmatS->type = nr_fmat*65536+nr_type;

   fmatS->r = n;
   fmatS->c = n;
   fmatS->p = (void*)matrix(1,n,1,n);

   red(integerIZ1,integerIZ2,integerJZ1,integerJZ2,integerJM1,integerJM2,integerJMF,integerIC1,integerJC1,integerJCF,integerKC,(float ***)(ftensC->p),(float **)(fmatS->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ftensC;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatS;
   push_pstack(&return2);



}

void BKSUB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerNE; /* r */ 
int integerNB; /* r */ 
int integerJF; /* r */ 
int integerK1; /* r */ 
int integerK2; /* r */ 
struct nrmatrix * ftensC; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"bksub",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"bksub",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"bksub",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",4,"bksub",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (argv[4].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",5,"bksub",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"bksub",
         abend_opnd_str(SETL_SYSTEM argv+5));


   integerNE = (argv[0].sp_val.sp_short_value);

   integerNB = (argv[1].sp_val.sp_short_value);

   integerJF = (argv[2].sp_val.sp_short_value);

   integerK1 = (argv[3].sp_val.sp_short_value);

   integerK2 = (argv[4].sp_val.sp_short_value);

   ftensC = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((ftensC->type)>>16)!=nr_ftens)

      abend(SETL_SYSTEM msg_bad_arg,"float tensor",6,"bksub",
         abend_opnd_str(SETL_SYSTEM argv+5));


   n = ftensC->r;
   if (n != ftensC->c)
      abend(SETL_SYSTEM "Wrong second dimension in bksub (parameter 7)");
   if (n != ftensC->h)
      abend(SETL_SYSTEM "Wrong third dimension in bksub (parameter 7)");

   if (ftensC->use_count!=1) 
      ftensC=nr_copy(ftensC);
   if (ftensC==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   bksub(integerNE,integerNB,integerJF,integerK1,integerK2,(float ***)(ftensC->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)ftensC;
   push_pstack(&return1);



}

static specifier wwghtsKERMOM_callback;
#ifndef TUNSAFE
plugin_item_ptr_type wwghtsKERMOM_instance;
#endif

void wwghtsKERMOM_c_callback(float  p1[],float p2,int p3)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = wwghtsKERMOM_instance;
   spare.sp_form = ft_opaque;
   spare.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)(p1);
   push_pstack(&spare);

   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p2;
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p3;
   push_pstack(&spare);

   save_callback.sp_form = wwghtsKERMOM_callback.sp_form;
   save_callback.sp_val.sp_biggest = wwghtsKERMOM_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  3,YES,NO,0);
   wwghtsKERMOM_callback.sp_form = save_callback.sp_form;
   wwghtsKERMOM_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

void WWGHTS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fvectWGHTS; /* rw */ 
float floatH; /* r */ 
void *KERMOMcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"wwghts",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"wwghts",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (((argv[2].sp_form != ft_opaque)||
          (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[2].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[2].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",3,"wwghts",
         abend_opnd_str(SETL_SYSTEM argv+2));


   fvectWGHTS = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fvectWGHTS->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",1,"wwghts",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatH = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatH = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
  if (argv[2].sp_form == ft_proc) {
#ifndef TUNSAFE
     wwghtsKERMOM_instance = plugin_instance;
#endif
     wwghtsKERMOM_callback.sp_form = ft_proc;
     wwghtsKERMOM_callback.sp_val.sp_proc_ptr = argv[2].sp_val.sp_proc_ptr;

     KERMOMcallback = (void*)wwghtsKERMOM_c_callback;
  } else {
     KERMOMcallback = 
         (void *)(((struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectWGHTS->r;

   if (fvectWGHTS->use_count!=1) 
      fvectWGHTS=nr_copy(fvectWGHTS);
   if (fvectWGHTS==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   wwghts((float *)(fvectWGHTS->p),n,floatH,KERMOMcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectWGHTS;
   push_pstack(&return1);



}

void KERMOM(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dvectWGHTS; /* rw */ 
float floatY; /* r */ 

/* Variables used to compute the array bounds */

long m;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"kermom",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"kermom",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dvectWGHTS = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dvectWGHTS->type)>>16)!=nr_dvect)

      abend(SETL_SYSTEM msg_bad_arg,"double vector",1,"kermom",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form == ft_short)
      floatY = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatY = (float)((argv[1].sp_val.sp_real_ptr)->r_value);

   m = dvectWGHTS->r;

   if (dvectWGHTS->use_count!=1) 
      dvectWGHTS=nr_copy(dvectWGHTS);
   if (dvectWGHTS==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   kermom((double *)(dvectWGHTS->p),floatY,m);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dvectWGHTS;
   push_pstack(&return1);



}

void QUADMX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * fmatA; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"quadmx",
         abend_opnd_str(SETL_SYSTEM argv+0));


   fmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((fmatA->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",1,"quadmx",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = fmatA->r;
   if (n != fmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in quadmx (parameter 2)");

   if (fmatA->use_count!=1) 
      fmatA=nr_copy(fmatA);
   if (fmatA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   quadmx((float **)(fmatA->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatA;
   push_pstack(&return1);



}

static specifier fred2G_callback;
#ifndef TUNSAFE
plugin_item_ptr_type fred2G_instance;
#endif

float fred2G_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = fred2G_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = fred2G_callback.sp_form;
   save_callback.sp_val.sp_biggest = fred2G_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   fred2G_callback.sp_form = save_callback.sp_form;
   fred2G_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

static specifier fred2AK_callback;
#ifndef TUNSAFE
plugin_item_ptr_type fred2AK_instance;
#endif

float fred2AK_c_callback(float p1,float p2)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = fred2AK_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p2;
   push_pstack(&spare);

   save_callback.sp_form = fred2AK_callback.sp_form;
   save_callback.sp_val.sp_biggest = fred2AK_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   fred2AK_callback.sp_form = save_callback.sp_form;
   fred2AK_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void FRED2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatA; /* r */ 
float floatB; /* r */ 
struct nrmatrix * fvectT; /* rw */ 
struct nrmatrix * fvectF; /* w */ 
struct nrmatrix * fvectW; /* w */ 
void *Gcallback;
void *AKcallback;

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"fred2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"fred2",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"fred2",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if (((argv[5].sp_form != ft_opaque)||
          (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[5].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[5].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",6,"fred2",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[6].sp_form != ft_opaque)||
          (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[6].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[6].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",7,"fred2",
         abend_opnd_str(SETL_SYSTEM argv+6));


   if (argv[0].sp_form == ft_short)
      floatA = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatA = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatB = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatB = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectT = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectT->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"fred2",
         abend_opnd_str(SETL_SYSTEM argv+2));

  if (argv[5].sp_form == ft_proc) {
#ifndef TUNSAFE
     fred2G_instance = plugin_instance;
#endif
     fred2G_callback.sp_form = ft_proc;
     fred2G_callback.sp_val.sp_proc_ptr = argv[5].sp_val.sp_proc_ptr;

     Gcallback = (void*)fred2G_c_callback;
  } else {
     Gcallback = 
         (void *)(((struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[6].sp_form == ft_proc) {
#ifndef TUNSAFE
     fred2AK_instance = plugin_instance;
#endif
     fred2AK_callback.sp_form = ft_proc;
     fred2AK_callback.sp_val.sp_proc_ptr = argv[6].sp_val.sp_proc_ptr;

     AKcallback = (void*)fred2AK_c_callback;
  } else {
     AKcallback = 
         (void *)(((struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectT->r;

   if (fvectT->use_count!=1) 
      fvectT=nr_copy(fvectT);
   if (fvectT==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   fvectF = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectF->use_count = 0;
   fvectF->type = nr_fvect*65536+nr_type;

   fvectF->r = n;
   fvectF->p = (void*)vector(1,n);
   fvectW = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   fvectW->use_count = 0;
   fvectW->type = nr_fvect*65536+nr_type;

   fvectW->r = n;
   fvectW->p = (void*)vector(1,n);

   fred2(n,floatA,floatB,(float *)(fvectT->p),(float *)(fvectF->p),(float *)(fvectW->p),Gcallback,AKcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectT;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectF;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectW;
   push_pstack(&return3);



}

static specifier fredinG_callback;
#ifndef TUNSAFE
plugin_item_ptr_type fredinG_instance;
#endif

float fredinG_c_callback(float p1)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = fredinG_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   save_callback.sp_form = fredinG_callback.sp_form;
   save_callback.sp_val.sp_biggest = fredinG_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  1,YES,NO,0);
   fredinG_callback.sp_form = save_callback.sp_form;
   fredinG_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

static specifier fredinAK_callback;
#ifndef TUNSAFE
plugin_item_ptr_type fredinAK_instance;
#endif

float fredinAK_c_callback(float p1,float p2)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = fredinAK_instance;
   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p1;
   push_pstack(&spare);

   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p2;
   push_pstack(&spare);

   save_callback.sp_form = fredinAK_callback.sp_form;
   save_callback.sp_val.sp_biggest = fredinAK_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   fredinAK_callback.sp_form = save_callback.sp_form;
   fredinAK_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void FREDIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatX; /* r */ 
float floatA; /* r */ 
float floatB; /* r */ 
struct nrmatrix * fvectT; /* r */ 
struct nrmatrix * fvectF; /* r */ 
struct nrmatrix * fvectW; /* r */ 
void *Gcallback;
void *AKcallback;

/* Variables used to compute the array bounds */

long n;



   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_short) && (argv[2].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",3,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if (((argv[6].sp_form != ft_opaque)||
          (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[6].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[6].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",7,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if (((argv[7].sp_form != ft_opaque)||
          (((argv[7].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[7].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[7].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",8,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+7));


   if (argv[0].sp_form == ft_short)
      floatX = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatX = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatA = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatA = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   if (argv[2].sp_form == ft_short)
      floatB = (float)(argv[2].sp_val.sp_short_value);

   if (argv[2].sp_form == ft_real)
      floatB = (float)((argv[2].sp_val.sp_real_ptr)->r_value);
   fvectT = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fvectT->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",4,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+3));

   fvectF = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((fvectF->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",5,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+4));

   fvectW = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((fvectW->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",6,"fredin",
         abend_opnd_str(SETL_SYSTEM argv+5));

  if (argv[6].sp_form == ft_proc) {
#ifndef TUNSAFE
     fredinG_instance = plugin_instance;
#endif
     fredinG_callback.sp_form = ft_proc;
     fredinG_callback.sp_val.sp_proc_ptr = argv[6].sp_val.sp_proc_ptr;

     Gcallback = (void*)fredinG_c_callback;
  } else {
     Gcallback = 
         (void *)(((struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[7].sp_form == ft_proc) {
#ifndef TUNSAFE
     fredinAK_instance = plugin_instance;
#endif
     fredinAK_callback.sp_form = ft_proc;
     fredinAK_callback.sp_val.sp_proc_ptr = argv[7].sp_val.sp_proc_ptr;

     AKcallback = (void*)fredinAK_c_callback;
  } else {
     AKcallback = 
         (void *)(((struct nrmatrix *)(argv[7].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectT->r;
   if (n != fvectF->r)
      abend(SETL_SYSTEM "Wrong first dimension in fredin (parameter 6)");
   if (n != fvectW->r)
      abend(SETL_SYSTEM "Wrong first dimension in fredin (parameter 7)");


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(fredin(floatX,n,floatA,floatB,(float *)(fvectT->p),(float *)(fvectF->p),(float *)(fvectW->p),Gcallback,AKcallback));



}

static specifier voltraG_callback;
#ifndef TUNSAFE
plugin_item_ptr_type voltraG_instance;
#endif

float voltraG_c_callback(int p1,float p2)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = voltraG_instance;
   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p1;
   push_pstack(&spare);

   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p2;
   push_pstack(&spare);

   save_callback.sp_form = voltraG_callback.sp_form;
   save_callback.sp_val.sp_biggest = voltraG_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  2,YES,NO,0);
   voltraG_callback.sp_form = save_callback.sp_form;
   voltraG_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

static specifier voltraAK_callback;
#ifndef TUNSAFE
plugin_item_ptr_type voltraAK_instance;
#endif

float voltraAK_c_callback(int p1,int p2,float p3,float p4)
{
i_real_ptr_type real_ptr;              /* real pointer                      */
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
#ifndef TUNSAFE
plugin_item_ptr_type plugin_instance;
#endif

   plugin_instance = voltraAK_instance;
   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p1;
   push_pstack(&spare);

   spare.sp_form = ft_short;
   spare.sp_val.sp_short_value = p2;
   push_pstack(&spare);

   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p3;
   push_pstack(&spare);

   i_get_real(real_ptr);
   spare.sp_form = ft_real;
   spare.sp_val.sp_real_ptr = real_ptr;
   real_ptr->r_use_count = 1;
   real_ptr->r_value = p4;
   push_pstack(&spare);

   save_callback.sp_form = voltraAK_callback.sp_form;
   save_callback.sp_val.sp_biggest = voltraAK_callback.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  4,YES,NO,0);
   voltraAK_callback.sp_form = save_callback.sp_form;
   voltraAK_callback.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

   if (spare.sp_form == ft_short) {
        return (float)(spare.sp_val.sp_short_value);
   } else
   if (spare.sp_form == ft_real) {
      return (float)((spare.sp_val.sp_real_ptr)->r_value);
   }
}

void VOLTRA(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
float floatT0; /* r */ 
float floatH; /* r */ 
struct nrmatrix * fvectT; /* rw */ 
struct nrmatrix * fmatF; /* rw */ 
void *Gcallback;
void *AKcallback;

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_short) && (argv[0].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",1,"voltra",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_short) && (argv[1].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",2,"voltra",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"voltra",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"voltra",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if (((argv[4].sp_form != ft_opaque)||
          (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[4].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[4].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",5,"voltra",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if (((argv[5].sp_form != ft_opaque)||
          (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type)||
          (((argv[5].sp_val.sp_opaque_ptr->type)>>16)!=nr_cback))&&
       (argv[5].sp_form != ft_proc))
      abend(SETL_SYSTEM msg_bad_arg,"procedure",6,"voltra",
         abend_opnd_str(SETL_SYSTEM argv+5));


   if (argv[0].sp_form == ft_short)
      floatT0 = (float)(argv[0].sp_val.sp_short_value);

   if (argv[0].sp_form == ft_real)
      floatT0 = (float)((argv[0].sp_val.sp_real_ptr)->r_value);
   if (argv[1].sp_form == ft_short)
      floatH = (float)(argv[1].sp_val.sp_short_value);

   if (argv[1].sp_form == ft_real)
      floatH = (float)((argv[1].sp_val.sp_real_ptr)->r_value);
   fvectT = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((fvectT->type)>>16)!=nr_fvect)

      abend(SETL_SYSTEM msg_bad_arg,"float vector",3,"voltra",
         abend_opnd_str(SETL_SYSTEM argv+2));

   fmatF = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((fmatF->type)>>16)!=nr_fmat)

      abend(SETL_SYSTEM msg_bad_arg,"float matrix",4,"voltra",
         abend_opnd_str(SETL_SYSTEM argv+3));

  if (argv[4].sp_form == ft_proc) {
#ifndef TUNSAFE
     voltraG_instance = plugin_instance;
#endif
     voltraG_callback.sp_form = ft_proc;
     voltraG_callback.sp_val.sp_proc_ptr = argv[4].sp_val.sp_proc_ptr;

     Gcallback = (void*)voltraG_c_callback;
  } else {
     Gcallback = 
         (void *)(((struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr))->p);
  }
  if (argv[5].sp_form == ft_proc) {
#ifndef TUNSAFE
     voltraAK_instance = plugin_instance;
#endif
     voltraAK_callback.sp_form = ft_proc;
     voltraAK_callback.sp_val.sp_proc_ptr = argv[5].sp_val.sp_proc_ptr;

     AKcallback = (void*)voltraAK_c_callback;
  } else {
     AKcallback = 
         (void *)(((struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr))->p);
  }

   n = fvectT->r;
   m = fmatF->r;
   if (n != fmatF->c)
      abend(SETL_SYSTEM "Wrong second dimension in voltra (parameter 5)");

   if (fvectT->use_count!=1) 
      fvectT=nr_copy(fvectT);
   if (fvectT==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (fmatF->use_count!=1) 
      fmatF=nr_copy(fmatF);
   if (fmatF==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   voltra(n,m,floatT0,floatH,(float *)(fvectT->p),(float **)(fmatF->p),Gcallback,AKcallback);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fvectT;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)fmatF;
   push_pstack(&return2);



}

void SOR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatA; /* r */ 
struct nrmatrix * dmatB; /* r */ 
struct nrmatrix * dmatC; /* r */ 
struct nrmatrix * dmatD; /* r */ 
struct nrmatrix * dmatE; /* r */ 
struct nrmatrix * dmatF; /* r */ 
struct nrmatrix * dmatU; /* rw */ 
double doubleRJAC; /* r */ 

/* Variables used to compute the array bounds */

long j;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"sor",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"sor",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"sor",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"sor",
         abend_opnd_str(SETL_SYSTEM argv+3));

   if ((argv[4].sp_form != ft_opaque)||
       (((argv[4].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",5,"sor",
         abend_opnd_str(SETL_SYSTEM argv+4));

   if ((argv[5].sp_form != ft_opaque)||
       (((argv[5].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",6,"sor",
         abend_opnd_str(SETL_SYSTEM argv+5));

   if ((argv[6].sp_form != ft_opaque)||
       (((argv[6].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",7,"sor",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if ((argv[7].sp_form != ft_short) && (argv[7].sp_form != ft_real))
      abend(SETL_SYSTEM msg_bad_arg,"integer or real",8,"sor",
         abend_opnd_str(SETL_SYSTEM argv+7));


   dmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatA->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"sor",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dmatB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatB->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"sor",
         abend_opnd_str(SETL_SYSTEM argv+1));

   dmatC = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((dmatC->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",3,"sor",
         abend_opnd_str(SETL_SYSTEM argv+2));

   dmatD = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((dmatD->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",4,"sor",
         abend_opnd_str(SETL_SYSTEM argv+3));

   dmatE = (struct nrmatrix *)(argv[4].sp_val.sp_opaque_ptr);

   if (((dmatE->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",5,"sor",
         abend_opnd_str(SETL_SYSTEM argv+4));

   dmatF = (struct nrmatrix *)(argv[5].sp_val.sp_opaque_ptr);

   if (((dmatF->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",6,"sor",
         abend_opnd_str(SETL_SYSTEM argv+5));

   dmatU = (struct nrmatrix *)(argv[6].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",7,"sor",
         abend_opnd_str(SETL_SYSTEM argv+6));

   if (argv[7].sp_form == ft_short)
      doubleRJAC = (double)(argv[7].sp_val.sp_short_value);

   if (argv[7].sp_form == ft_real)
      doubleRJAC = (double)((argv[7].sp_val.sp_real_ptr)->r_value);

   j = dmatA->r;
   if (j != dmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in sor (parameter 2)");
   if (j != dmatB->r)
      abend(SETL_SYSTEM "Wrong first dimension in sor (parameter 3)");
   if (j != dmatB->c)
      abend(SETL_SYSTEM "Wrong second dimension in sor (parameter 3)");
   if (j != dmatC->r)
      abend(SETL_SYSTEM "Wrong first dimension in sor (parameter 4)");
   if (j != dmatC->c)
      abend(SETL_SYSTEM "Wrong second dimension in sor (parameter 4)");
   if (j != dmatD->r)
      abend(SETL_SYSTEM "Wrong first dimension in sor (parameter 5)");
   if (j != dmatD->c)
      abend(SETL_SYSTEM "Wrong second dimension in sor (parameter 5)");
   if (j != dmatE->r)
      abend(SETL_SYSTEM "Wrong first dimension in sor (parameter 6)");
   if (j != dmatE->c)
      abend(SETL_SYSTEM "Wrong second dimension in sor (parameter 6)");
   if (j != dmatF->r)
      abend(SETL_SYSTEM "Wrong first dimension in sor (parameter 7)");
   if (j != dmatF->c)
      abend(SETL_SYSTEM "Wrong second dimension in sor (parameter 7)");
   if (j != dmatU->r)
      abend(SETL_SYSTEM "Wrong first dimension in sor (parameter 8)");
   if (j != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in sor (parameter 8)");

   if (dmatU->use_count!=1) 
      dmatU=nr_copy(dmatU);
   if (dmatU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   sor((double **)(dmatA->p),(double **)(dmatB->p),(double **)(dmatC->p),(double **)(dmatD->p),(double **)(dmatE->p),(double **)(dmatF->p),(double **)(dmatU->p),j,doubleRJAC);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatU;
   push_pstack(&return1);



}

void MGLIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatU; /* rw */ 
int integerNCYCLE; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mglin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"mglin",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"mglin",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerNCYCLE = (argv[1].sp_val.sp_short_value);


   n = dmatU->r;
   if (n != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in mglin (parameter 2)");

   if (dmatU->use_count!=1) 
      dmatU=nr_copy(dmatU);
   if (dmatU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mglin((double **)(dmatU->p),n,integerNCYCLE);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatU;
   push_pstack(&return1);



}

void RSTRCT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatUC; /* r */ 
struct nrmatrix * dmatUF; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"rstrct",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"rstrct",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatUC = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatUC->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"rstrct",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dmatUF = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatUF->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"rstrct",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = dmatUC->r;
   if (n != dmatUC->c)
      abend(SETL_SYSTEM "Wrong second dimension in rstrct (parameter 2)");
   m = dmatUF->r;
   if (m != dmatUF->c)
      abend(SETL_SYSTEM "Wrong second dimension in rstrct (parameter 3)");

   if (dmatUF->use_count!=1) 
      dmatUF=nr_copy(dmatUF);
   if (dmatUF==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   rstrct((double **)(dmatUC->p),(double **)(dmatUF->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatUF;
   push_pstack(&return1);



}

void ADDINT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatUF; /* rw */ 
struct nrmatrix * dmatUC; /* r */ 
struct nrmatrix * dmatRES; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"addint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"addint",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatUF = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatUF->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"addint",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dmatUC = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatUC->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"addint",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = dmatUF->r;
   if (n != dmatUF->c)
      abend(SETL_SYSTEM "Wrong second dimension in addint (parameter 2)");
   m = dmatUC->r;
   if (m != dmatUC->c)
      abend(SETL_SYSTEM "Wrong second dimension in addint (parameter 3)");

   if (dmatUF->use_count!=1) 
      dmatUF=nr_copy(dmatUF);
   if (dmatUF==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   dmatRES = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dmatRES->use_count = 0;
   dmatRES->type = nr_dmat*65536+nr_type;

   dmatRES->r = n;
   dmatRES->c = n;
   dmatRES->p = (void*)dmatrix(1,n,1,n);

   addint((double **)(dmatUC->p),(double **)(dmatUF->p),(double **)(dmatRES->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatUF;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatRES;
   push_pstack(&return2);



}

void ANORM2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatA; /* r */ 

/* Variables used to compute the array bounds */

long n;



   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"anorm2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   dmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatA->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"anorm2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = dmatA->r;
   if (n != dmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in anorm2 (parameter 2)");


   unmark_specifier(target);
   i_get_real(target->sp_val.sp_real_ptr);
   target->sp_form = ft_real;
   target->sp_val.sp_real_ptr->r_use_count = 1;
   target->sp_val.sp_real_ptr->r_value = 
       (double)(anorm2((double **)(dmatA->p),n));



}

void RELAX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatU; /* rw */ 
struct nrmatrix * dmatRHS; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"relax",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"relax",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"relax",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dmatRHS = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatRHS->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"relax",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = dmatU->r;
   if (n != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in relax (parameter 2)");
   if (n != dmatRHS->r)
      abend(SETL_SYSTEM "Wrong first dimension in relax (parameter 3)");
   if (n != dmatRHS->c)
      abend(SETL_SYSTEM "Wrong second dimension in relax (parameter 3)");

   if (dmatU->use_count!=1) 
      dmatU=nr_copy(dmatU);
   if (dmatU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   relax((double **)(dmatU->p),(double **)(dmatRHS->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatU;
   push_pstack(&return1);



}

void RESID(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatRES; /* w */ 
struct nrmatrix * dmatU; /* r */ 
struct nrmatrix * dmatRHS; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"resid",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"resid",
         abend_opnd_str(SETL_SYSTEM argv+2));


   dmatU = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"resid",
         abend_opnd_str(SETL_SYSTEM argv+1));

   dmatRHS = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((dmatRHS->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",3,"resid",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = dmatU->r;
   if (n != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in resid (parameter 3)");
   if (n != dmatRHS->r)
      abend(SETL_SYSTEM "Wrong first dimension in resid (parameter 4)");
   if (n != dmatRHS->c)
      abend(SETL_SYSTEM "Wrong second dimension in resid (parameter 4)");

   dmatRES = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dmatRES->use_count = 0;
   dmatRES->type = nr_dmat*65536+nr_type;

   dmatRES->r = n;
   dmatRES->c = n;
   dmatRES->p = (void*)dmatrix(1,n,1,n);

   resid((double **)(dmatRES->p),(double **)(dmatU->p),(double **)(dmatRHS->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatRES;
   push_pstack(&return1);



}

void COPY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatAOUT; /* w */ 
struct nrmatrix * dmatAIN; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"copy",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatAIN = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatAIN->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"copy",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = dmatAIN->r;
   if (n != dmatAIN->c)
      abend(SETL_SYSTEM "Wrong second dimension in copy (parameter 3)");

   dmatAOUT = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dmatAOUT->use_count = 0;
   dmatAOUT->type = nr_dmat*65536+nr_type;

   dmatAOUT->r = n;
   dmatAOUT->c = n;
   dmatAOUT->p = (void*)dmatrix(1,n,1,n);

   copy((double **)(dmatAOUT->p),(double **)(dmatAIN->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatAOUT;
   push_pstack(&return1);



}

void FILL0(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatU; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"fill0",
         abend_opnd_str(SETL_SYSTEM argv+0));


   dmatU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"fill0",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = dmatU->r;
   if (n != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in fill0 (parameter 2)");

   if (dmatU->use_count!=1) 
      dmatU=nr_copy(dmatU);
   if (dmatU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   fill0((double **)(dmatU->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatU;
   push_pstack(&return1);



}

void MGFAS(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatU; /* rw */ 
int integerMAXCYC; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mgfas",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"mgfas",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"mgfas",
         abend_opnd_str(SETL_SYSTEM argv+0));

   integerMAXCYC = (argv[1].sp_val.sp_short_value);


   n = dmatU->r;
   if (n != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in mgfas (parameter 2)");

   if (dmatU->use_count!=1) 
      dmatU=nr_copy(dmatU);
   if (dmatU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mgfas((double **)(dmatU->p),n,integerMAXCYC);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatU;
   push_pstack(&return1);



}

void RELAX2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatU; /* rw */ 
struct nrmatrix * dmatRHS; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"relax2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"relax2",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"relax2",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dmatRHS = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatRHS->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"relax2",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = dmatU->r;
   if (n != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in relax2 (parameter 2)");
   if (n != dmatRHS->r)
      abend(SETL_SYSTEM "Wrong first dimension in relax2 (parameter 3)");
   if (n != dmatRHS->c)
      abend(SETL_SYSTEM "Wrong second dimension in relax2 (parameter 3)");

   if (dmatU->use_count!=1) 
      dmatU=nr_copy(dmatU);
   if (dmatU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   relax2((double **)(dmatU->p),(double **)(dmatRHS->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatU;
   push_pstack(&return1);



}

void MATADD(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatA; /* r */ 
struct nrmatrix * dmatB; /* r */ 
struct nrmatrix * dmatC; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"matadd",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"matadd",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatA->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"matadd",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dmatB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatB->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"matadd",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = dmatA->r;
   if (n != dmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in matadd (parameter 2)");
   if (n != dmatB->r)
      abend(SETL_SYSTEM "Wrong first dimension in matadd (parameter 3)");
   if (n != dmatB->c)
      abend(SETL_SYSTEM "Wrong second dimension in matadd (parameter 3)");

   dmatC = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dmatC->use_count = 0;
   dmatC->type = nr_dmat*65536+nr_type;

   dmatC->r = n;
   dmatC->c = n;
   dmatC->p = (void*)dmatrix(1,n,1,n);

   matadd((double **)(dmatA->p),(double **)(dmatB->p),(double **)(dmatC->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatC;
   push_pstack(&return1);



}

void MATSUB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatA; /* r */ 
struct nrmatrix * dmatB; /* r */ 
struct nrmatrix * dmatC; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"matsub",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"matsub",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatA->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"matsub",
         abend_opnd_str(SETL_SYSTEM argv+0));

   dmatB = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatB->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"matsub",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = dmatA->r;
   if (n != dmatA->c)
      abend(SETL_SYSTEM "Wrong second dimension in matsub (parameter 2)");
   if (n != dmatB->r)
      abend(SETL_SYSTEM "Wrong first dimension in matsub (parameter 3)");
   if (n != dmatB->c)
      abend(SETL_SYSTEM "Wrong second dimension in matsub (parameter 3)");

   dmatC = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dmatC->use_count = 0;
   dmatC->type = nr_dmat*65536+nr_type;

   dmatC->r = n;
   dmatC->c = n;
   dmatC->p = (void*)dmatrix(1,n,1,n);

   matsub((double **)(dmatA->p),(double **)(dmatB->p),(double **)(dmatC->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatC;
   push_pstack(&return1);



}

void LOP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatOUT; /* w */ 
struct nrmatrix * dmatU; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"lop",
         abend_opnd_str(SETL_SYSTEM argv+1));


   dmatU = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",2,"lop",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = dmatU->r;
   if (n != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in lop (parameter 3)");

   dmatOUT = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dmatOUT->use_count = 0;
   dmatOUT->type = nr_dmat*65536+nr_type;

   dmatOUT->r = n;
   dmatOUT->c = n;
   dmatOUT->p = (void*)dmatrix(1,n,1,n);

   lop((double **)(dmatOUT->p),(double **)(dmatU->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatOUT;
   push_pstack(&return1);



}

void SLVSM2(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * dmatU; /* rw */ 
struct nrmatrix * dmatRHS; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"slvsm2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   dmatU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((dmatU->type)>>16)!=nr_dmat)

      abend(SETL_SYSTEM msg_bad_arg,"double matrix",1,"slvsm2",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = dmatU->r;
   if (n != dmatU->c)
      abend(SETL_SYSTEM "Wrong second dimension in slvsm2 (parameter 2)");

   if (dmatU->use_count!=1) 
      dmatU=nr_copy(dmatU);
   if (dmatU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   dmatRHS = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
   dmatRHS->use_count = 0;
   dmatRHS->type = nr_dmat*65536+nr_type;

   dmatRHS->r = n;
   dmatRHS->c = n;
   dmatRHS->p = (void*)dmatrix(1,n,1,n);

   slvsm2((double **)(dmatU->p),(double **)(dmatRHS->p));

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatU;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)dmatRHS;
   push_pstack(&return2);



}

void MACHAR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerIBETA; /* w */ 
int integerIT; /* w */ 
int integerIRND; /* w */ 
int integerNGRD; /* w */ 
int integerMACHEP; /* w */ 
int integerNEGEP; /* w */ 
int integerIEXP; /* w */ 
int integerMINEXP; /* w */ 
int integerMAXEXP; /* w */ 
float floatEPS; /* w */ 
float floatEPSNEG; /* w */ 
float floatXMIN; /* w */ 
float floatXMAX; /* w */ 

specifier return1;
specifier return2;
specifier return3;
specifier return4;
specifier return5;
specifier return6;
specifier return7;
specifier return8;
specifier return9;
specifier return10;
specifier return11;
specifier return12;
specifier return13;





   machar(&integerIBETA,&integerIT,&integerIRND,&integerNGRD,&integerMACHEP,&integerNEGEP,&integerIEXP,&integerMINEXP,&integerMAXEXP,&floatEPS,&floatEPSNEG,&floatXMIN,&floatXMAX);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerIBETA;

   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerIT;

   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerIRND;

   push_pstack(&return3);

   return4.sp_form = ft_short;
   return4.sp_val.sp_short_value = (int32)integerNGRD;

   push_pstack(&return4);

   return5.sp_form = ft_short;
   return5.sp_val.sp_short_value = (int32)integerMACHEP;

   push_pstack(&return5);

   return6.sp_form = ft_short;
   return6.sp_val.sp_short_value = (int32)integerNEGEP;

   push_pstack(&return6);

   return7.sp_form = ft_short;
   return7.sp_val.sp_short_value = (int32)integerIEXP;

   push_pstack(&return7);

   return8.sp_form = ft_short;
   return8.sp_val.sp_short_value = (int32)integerMINEXP;

   push_pstack(&return8);

   return9.sp_form = ft_short;
   return9.sp_val.sp_short_value = (int32)integerMAXEXP;

   push_pstack(&return9);

   return10.sp_form = ft_real;
   i_get_real(return10.sp_val.sp_real_ptr);
   return10.sp_val.sp_real_ptr->r_value = (double)(floatEPS);
   return10.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return10);

   return11.sp_form = ft_real;
   i_get_real(return11.sp_val.sp_real_ptr);
   return11.sp_val.sp_real_ptr->r_value = (double)(floatEPSNEG);
   return11.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return11);

   return12.sp_form = ft_real;
   i_get_real(return12.sp_val.sp_real_ptr);
   return12.sp_val.sp_real_ptr->r_value = (double)(floatXMIN);
   return12.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return12);

   return13.sp_form = ft_real;
   i_get_real(return13.sp_val.sp_real_ptr);
   return13.sp_val.sp_real_ptr->r_value = (double)(floatXMAX);
   return13.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return13);



}

void IGRAY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
unsigned long ulongN; /* r */ 
int integerIS; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"igray",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"igray",
         abend_opnd_str(SETL_SYSTEM argv+1));


   ulongN = (argv[0].sp_val.sp_short_value);

   integerIS = (argv[1].sp_val.sp_short_value);




   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = 
       (int32)igray(ulongN,integerIS);



}

void ICRC1(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
unsigned short ushortCRC; /* r */ 
unsigned short ushortONEC; /* r */ 






   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = 
       (int32)icrc1(ushortCRC,ushortONEC);



}

void MPADD(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectW; /* rw */ 
struct nrmatrix * cvectU; /* r */ 
struct nrmatrix * cvectV; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpadd",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpadd",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"mpadd",
         abend_opnd_str(SETL_SYSTEM argv+2));


   cvectW = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectW->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpadd",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectU = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpadd",
         abend_opnd_str(SETL_SYSTEM argv+1));

   cvectV = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((cvectV->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",3,"mpadd",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = cvectW->r;
   if (n != cvectU->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpadd (parameter 3)");
   if (n != cvectV->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpadd (parameter 4)");

   if (cvectW->use_count!=1) 
      cvectW=nr_copy(cvectW);
   if (cvectW==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpadd((unsigned char *)(cvectW->p),(unsigned char *)(cvectU->p),(unsigned char *)(cvectV->p),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectW;
   push_pstack(&return1);



}

void MPSUB(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerIS; /* w */ 
struct nrmatrix * cvectW; /* rw */ 
struct nrmatrix * cvectU; /* r */ 
struct nrmatrix * cvectV; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpsub",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"mpsub",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"mpsub",
         abend_opnd_str(SETL_SYSTEM argv+3));


   cvectW = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectW->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpsub",
         abend_opnd_str(SETL_SYSTEM argv+1));

   cvectU = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",3,"mpsub",
         abend_opnd_str(SETL_SYSTEM argv+2));

   cvectV = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((cvectV->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",4,"mpsub",
         abend_opnd_str(SETL_SYSTEM argv+3));


   n = cvectW->r;
   if (n != cvectU->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpsub (parameter 4)");
   if (n != cvectV->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpsub (parameter 5)");

   if (cvectW->use_count!=1) 
      cvectW=nr_copy(cvectW);
   if (cvectW==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpsub(&integerIS,(unsigned char *)(cvectW->p),(unsigned char *)(cvectU->p),(unsigned char *)(cvectV->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerIS;

   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectW;
   push_pstack(&return2);



}

void MPSAD(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectW; /* rw */ 
struct nrmatrix * cvectU; /* r */ 
int integerIV; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpsad",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpsad",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"mpsad",
         abend_opnd_str(SETL_SYSTEM argv+2));


   cvectW = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectW->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpsad",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectU = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpsad",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerIV = (argv[2].sp_val.sp_short_value);


   n = cvectW->r;
   if (n != cvectU->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpsad (parameter 3)");

   if (cvectW->use_count!=1) 
      cvectW=nr_copy(cvectW);
   if (cvectW==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpsad((unsigned char *)(cvectW->p),(unsigned char *)(cvectU->p),n,integerIV);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectW;
   push_pstack(&return1);



}

void MPSMU(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectW; /* rw */ 
struct nrmatrix * cvectU; /* r */ 
int integerIV; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpsmu",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpsmu",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"mpsmu",
         abend_opnd_str(SETL_SYSTEM argv+2));


   cvectW = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectW->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpsmu",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectU = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpsmu",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerIV = (argv[2].sp_val.sp_short_value);


   n = cvectW->r;
   if (n != cvectU->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpsmu (parameter 3)");

   if (cvectW->use_count!=1) 
      cvectW=nr_copy(cvectW);
   if (cvectW==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpsmu((unsigned char *)(cvectW->p),(unsigned char *)(cvectU->p),n,integerIV);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectW;
   push_pstack(&return1);



}

void MPNEG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectU; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpneg",
         abend_opnd_str(SETL_SYSTEM argv+0));


   cvectU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpneg",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = cvectU->r;

   if (cvectU->use_count!=1) 
      cvectU=nr_copy(cvectU);
   if (cvectU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpneg((unsigned char *)(cvectU->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectU;
   push_pstack(&return1);



}

void MPMOV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectU; /* rw */ 
struct nrmatrix * cvectV; /* r */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpmov",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpmov",
         abend_opnd_str(SETL_SYSTEM argv+1));


   cvectU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpmov",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectV = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectV->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpmov",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = cvectU->r;
   if (n != cvectV->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpmov (parameter 3)");

   if (cvectU->use_count!=1) 
      cvectU=nr_copy(cvectU);
   if (cvectU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpmov((unsigned char *)(cvectU->p),(unsigned char *)(cvectV->p),n);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectU;
   push_pstack(&return1);



}

void MPLSH(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectU; /* rw */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mplsh",
         abend_opnd_str(SETL_SYSTEM argv+0));


   cvectU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mplsh",
         abend_opnd_str(SETL_SYSTEM argv+0));


   n = cvectU->r;

   if (cvectU->use_count!=1) 
      cvectU=nr_copy(cvectU);
   if (cvectU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mplsh((unsigned char *)(cvectU->p),n-1);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectU;
   push_pstack(&return1);



}

void MPMUL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectW; /* rw */ 
struct nrmatrix * cvectU; /* rw */ 
struct nrmatrix * cvectV; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;
long k;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpmul",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpmul",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"mpmul",
         abend_opnd_str(SETL_SYSTEM argv+2));


   cvectW = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectW->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpmul",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectU = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpmul",
         abend_opnd_str(SETL_SYSTEM argv+1));

   cvectV = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((cvectV->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",3,"mpmul",
         abend_opnd_str(SETL_SYSTEM argv+2));


   k = cvectW->r;
   n = cvectU->r;
   m = cvectV->r;

   if (cvectW->use_count!=1) 
      cvectW=nr_copy(cvectW);
   if (cvectW==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (cvectU->use_count!=1) 
      cvectU=nr_copy(cvectU);
   if (cvectU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (cvectV->use_count!=1) 
      cvectV=nr_copy(cvectV);
   if (cvectV==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpmul((unsigned char *)(cvectW->p),(unsigned char *)(cvectU->p),(unsigned char *)(cvectV->p),n,m);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectW;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectU;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectV;
   push_pstack(&return3);



}

void MPINV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectU; /* rw */ 
struct nrmatrix * cvectV; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpinv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpinv",
         abend_opnd_str(SETL_SYSTEM argv+1));


   cvectU = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpinv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectV = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectV->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpinv",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = cvectU->r;
   m = cvectV->r;

   if (cvectU->use_count!=1) 
      cvectU=nr_copy(cvectU);
   if (cvectU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (cvectV->use_count!=1) 
      cvectV=nr_copy(cvectV);
   if (cvectV==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpinv((unsigned char *)(cvectU->p),(unsigned char *)(cvectV->p),n,m);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectU;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectV;
   push_pstack(&return2);



}

void MPDIV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectQ; /* rw */ 
struct nrmatrix * cvectR; /* rw */ 
struct nrmatrix * cvectU; /* r */ 
struct nrmatrix * cvectV; /* r */ 

/* Variables used to compute the array bounds */

long m;
long n;
long k;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpdiv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpdiv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"mpdiv",
         abend_opnd_str(SETL_SYSTEM argv+2));

   if ((argv[3].sp_form != ft_opaque)||
       (((argv[3].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",4,"mpdiv",
         abend_opnd_str(SETL_SYSTEM argv+3));


   cvectQ = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectQ->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpdiv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectR = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectR->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpdiv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   cvectU = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",3,"mpdiv",
         abend_opnd_str(SETL_SYSTEM argv+2));

   cvectV = (struct nrmatrix *)(argv[3].sp_val.sp_opaque_ptr);

   if (((cvectV->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",4,"mpdiv",
         abend_opnd_str(SETL_SYSTEM argv+3));


   k = cvectQ->r;
   m = cvectR->r;
   n = cvectU->r;
   if (m != cvectV->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpdiv (parameter 5)");

   if (cvectQ->use_count!=1) 
      cvectQ=nr_copy(cvectQ);
   if (cvectQ==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (cvectR->use_count!=1) 
      cvectR=nr_copy(cvectR);
   if (cvectR==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpdiv((unsigned char *)(cvectQ->p),(unsigned char *)(cvectR->p),(unsigned char *)(cvectU->p),(unsigned char *)(cvectV->p),n,m);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectQ;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectR;
   push_pstack(&return2);



}

void MPSDV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectW; /* rw */ 
struct nrmatrix * cvectU; /* r */ 
int integerIV; /* r */ 
int integerIR; /* w */ 

/* Variables used to compute the array bounds */

long n;


specifier return1;
specifier return2;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpsdv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpsdv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"mpsdv",
         abend_opnd_str(SETL_SYSTEM argv+2));


   cvectW = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectW->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpsdv",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectU = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpsdv",
         abend_opnd_str(SETL_SYSTEM argv+1));

   integerIV = (argv[2].sp_val.sp_short_value);


   n = cvectW->r;
   if (n != cvectU->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpsdv (parameter 3)");

   if (cvectW->use_count!=1) 
      cvectW=nr_copy(cvectW);
   if (cvectW==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpsdv((unsigned char *)(cvectW->p),(unsigned char *)(cvectU->p),n-1,integerIV,&integerIR);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectW;
   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerIR;

   push_pstack(&return2);



}

void MPSQRT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectW; /* rw */ 
struct nrmatrix * cvectU; /* rw */ 
struct nrmatrix * cvectV; /* rw */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mpsqrt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mpsqrt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if ((argv[2].sp_form != ft_opaque)||
       (((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",3,"mpsqrt",
         abend_opnd_str(SETL_SYSTEM argv+2));


   cvectW = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectW->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mpsqrt",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectU = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectU->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mpsqrt",
         abend_opnd_str(SETL_SYSTEM argv+1));

   cvectV = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);

   if (((cvectV->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",3,"mpsqrt",
         abend_opnd_str(SETL_SYSTEM argv+2));


   n = cvectW->r;
   if (n != cvectU->r)
      abend(SETL_SYSTEM "Wrong first dimension in mpsqrt (parameter 3)");
   m = cvectV->r;

   if (cvectW->use_count!=1) 
      cvectW=nr_copy(cvectW);
   if (cvectW==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (cvectU->use_count!=1) 
      cvectU=nr_copy(cvectU);
   if (cvectU==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (cvectV->use_count!=1) 
      cvectV=nr_copy(cvectV);
   if (cvectV==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mpsqrt((unsigned char *)(cvectW->p),(unsigned char *)(cvectU->p),(unsigned char *)(cvectV->p),n,m);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectW;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectU;
   push_pstack(&return2);

   return3.sp_form = ft_opaque;
   return3.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectV;
   push_pstack(&return3);



}

void MP2DFR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct nrmatrix * cvectA; /* rw */ 
struct nrmatrix * cvectS; /* rw */ 
int integerDIGITS; /* w */ 

/* Variables used to compute the array bounds */

long m;
long n;


specifier return1;
specifier return2;
specifier return3;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",1,"mp2dfr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"nr_matrix",2,"mp2dfr",
         abend_opnd_str(SETL_SYSTEM argv+1));


   cvectA = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

   if (((cvectA->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",1,"mp2dfr",
         abend_opnd_str(SETL_SYSTEM argv+0));

   cvectS = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

   if (((cvectS->type)>>16)!=nr_cvect)

      abend(SETL_SYSTEM msg_bad_arg,"unsigned char vector",2,"mp2dfr",
         abend_opnd_str(SETL_SYSTEM argv+1));


   n = cvectA->r;
   m = cvectS->r;

   if (cvectA->use_count!=1) 
      cvectA=nr_copy(cvectA);
   if (cvectA==NULL)
      abend(SETL_SYSTEM msg_malloc_error);

   if (cvectS->use_count!=1) 
      cvectS=nr_copy(cvectS);
   if (cvectS==NULL)
      abend(SETL_SYSTEM msg_malloc_error);


   mp2dfr((unsigned char *)(cvectA->p),(unsigned char *)(cvectS->p),n,&integerDIGITS);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectA;
   push_pstack(&return1);

   return2.sp_form = ft_opaque;
   return2.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)cvectS;
   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerDIGITS;

   push_pstack(&return3);



}

void CALDAT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
unsigned long ulongJULIAN; /* r */ 
int integerMM; /* w */ 
int integerID; /* w */ 
int integerIYYY; /* w */ 

specifier return1;
specifier return2;
specifier return3;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"caldat",
         abend_opnd_str(SETL_SYSTEM argv+0));


   ulongJULIAN = (argv[0].sp_val.sp_short_value);




   caldat(ulongJULIAN,&integerMM,&integerID,&integerIYYY);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)integerMM;

   push_pstack(&return1);

   return2.sp_form = ft_short;
   return2.sp_val.sp_short_value = (int32)integerID;

   push_pstack(&return2);

   return3.sp_form = ft_short;
   return3.sp_val.sp_short_value = (int32)integerIYYY;

   push_pstack(&return3);



}

void FLMOON(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerN; /* r */ 
int integerNPH; /* r */ 
long longJD; /* w */ 
float floatFRAC; /* w */ 

specifier return1;
specifier return2;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"flmoon",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"flmoon",
         abend_opnd_str(SETL_SYSTEM argv+1));


   integerN = (argv[0].sp_val.sp_short_value);

   integerNPH = (argv[1].sp_val.sp_short_value);




   flmoon(integerN,integerNPH,&longJD,&floatFRAC);

   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_short;
   return1.sp_val.sp_short_value = (int32)longJD;

   push_pstack(&return1);

   return2.sp_form = ft_real;
   i_get_real(return2.sp_val.sp_real_ptr);
   return2.sp_val.sp_real_ptr->r_value = (double)(floatFRAC);
   return2.sp_val.sp_real_ptr->r_use_count = 0;
   push_pstack(&return2);



}

void JULDAY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int integerMM; /* r */ 
int integerID; /* r */ 
int integerIYYY; /* r */ 


   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"julday",
         abend_opnd_str(SETL_SYSTEM argv+0));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",2,"julday",
         abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"julday",
         abend_opnd_str(SETL_SYSTEM argv+2));


   integerMM = (argv[0].sp_val.sp_short_value);

   integerID = (argv[1].sp_val.sp_short_value);

   integerIYYY = (argv[2].sp_val.sp_short_value);




   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = 
       (int32)julday(integerMM,integerID,integerIYYY);



}
