/*
\*/


#include <math.h>
#include <string.h>

/* SETL2 system header files */
#include "macros.h"

#define NRANSI
#include "nr.h"
#include "nrutil.h"

struct nrmatrix {
   int32 use_count;
   int32 type;
   int r,c,h;
   void *p;
};


#define nr_fmat		1
#define nr_dmat		2
#define nr_imat		3

#define nr_fvect	11
#define nr_dvect	12
#define nr_ivect	13
#define nr_ulvect	14
#define nr_cvect	15

#define nr_ftens	21
#define nr_cback	31

#undef FMIN

/* constants */

#define YES         1                  /* true constant                     */
#define NO          0                  /* false constant                    */

static int32 nr_type;

/*
 *	Global variables needed by files in project
\*/
 
	/* Global variables shared betweeb dlinmin and df1dim */
extern int ncom;
extern float *pcom, *xicom, (*nrfunc)(float []);
extern void (*nrdfun)(float [], float[]);

	/* Seed variable for random number generator */
long idum;

	/* User function passed to nnewt */
void (*usrfun)(float *x, int n, float *fvec, float **fjac);

	/* User function passed to linbcg */
void atimes(unsigned long n, double x[], double r[], int itrnsp);
void asolve(unsigned long n, double b[], double x[], int itrnsp);
 
/*
 *	Prototypes
 */

int		i_sum_op(int i1, int i2);
int		i_diff_op(int i1, int i2);
int		i_diff_reverse_op(int i1, int i2);
int		i_prod_op(int i1, int i2);

double	d_sum_op(double d1, double d2);
double	d_diff_op(double d1, double d2);
double	d_diff_reverse_op(double d1, double d2);
double	d_prod_op(double d1, double d2);


	
	
struct nrmatrix *constant_binop_matrix_or_vector(struct nrmatrix *mat_a, void *constant, int t, double (*dop )(double, double ), int (*iop )(int, int ));
struct nrmatrix *binop_matrix_or_vector(struct nrmatrix *mat_a, struct nrmatrix *mat_b, int t, double (*dop )(double, double ), int (*iop )(int, int ));
struct nrmatrix *prod_matrix_or_vector(struct nrmatrix *mat_a, struct nrmatrix *mat_b, double (*dop)(double, double), int (*iop)(int, int), int *err);

/*
\*/

int get_tuple_count(
	SETL_SYSTEM_PROTO
	tuple_h_ptr_type tuple_root,
	int form
)
{
TUPLE_ITERATOR(ia) 
int count;
specifier spare;

  spare.sp_form=ft_tuple;
  spare.sp_val.sp_tuple_ptr = tuple_root;
  count = 0;
   
   /* loop over the elements of source */

  ITERATE_TUPLE_BEGIN(ia,spare)
   {
      if (count < ia_number) 
         return -1;

      if ((form>0)&&(ia_element->sp_form != form))
 	  return -1;

      count++;
   }
   ITERATE_TUPLE_END(ia)

   return count;
}

void internal_destructor(struct nrmatrix *spec)
{
int subtyp;
/*char spam[256]; */

   subtyp=spec->type>>16;
   
/*   sprintf(spam,"Destructor %d\n",subtyp); 
  plugin_printf(spam);  */
  
   switch(subtyp) {
      case nr_fmat:
         free_matrix(spec->p,1,spec->r,1,spec->c);
	 break;
      case nr_dmat:
         free_dmatrix(spec->p,1,spec->r,1,spec->c);
	 break;
      case nr_imat:
         free_imatrix(spec->p,1,spec->r,1,spec->c);
	 break;
      case nr_fvect:
         free_vector(spec->p,1,spec->r);
	 break;
      case nr_dvect:
         free_dvector(spec->p,1,spec->r);
	 break;
      case nr_ivect:
         free_ivector(spec->p,1,spec->r);
   	 break;
      case nr_cvect:
         free_cvector(spec->p,1,spec->r);
	 break;
      case nr_ulvect:
         free_lvector(spec->p,1,spec->r);
	 break;
      case nr_ftens:
         free_f3tensor(spec->p,1,spec->r,1,spec->c,1,spec->h);
	 break;
      default:
         break;
   }

}


int32 LIBNR__INIT(
   SETL_SYSTEM_PROTO_VOID)
{
   nr_type=register_type(SETL_SYSTEM "struct nrmatrix",internal_destructor);
   if (nr_type==0) return 1;
   return 0;

}


/***********************************************************************/

void NR_GET_VECTOR(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,r;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_vector",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,0);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_vector",
            abend_opnd_str(SETL_SYSTEM argv));

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_fvect*65536+nr_type;
   mat->use_count = 1;

   mat->p = (void *)vector(1,rows);
   mat->r = rows;
   mat->c = 1;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (ia_element->sp_form==ft_short) {
	((float *)(mat->p))[r]=(float)(ia_element->sp_val.sp_short_value);
     } else 
     if (ia_element->sp_form==ft_real) {
	((float *)(mat->p))[r]=(float)((ia_element->sp_val.sp_real_ptr)->r_value);
     } else 
        abend(SETL_SYSTEM "the vector must be integer or real","vector",1,
	   "nr_vector", abend_opnd_str(SETL_SYSTEM argv));
   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}

void NR_GET_DVECTOR(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,r;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_dvector",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,0);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_dvector",
            abend_opnd_str(SETL_SYSTEM argv));

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_dvect*65536+nr_type;
   mat->use_count = 1;

   mat->p = (void *)dvector(1,rows);
   mat->r = rows;
   mat->c = 1;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (ia_element->sp_form==ft_short) {
	((double *)(mat->p))[r]=(double)(ia_element->sp_val.sp_short_value);
     } else 
     if (ia_element->sp_form==ft_real) {
	((double *)(mat->p))[r]=(double)((ia_element->sp_val.sp_real_ptr)->r_value);
     } else 
        abend(SETL_SYSTEM "the vector must be integer or real","vector",1,
	   "nr_dvector", abend_opnd_str(SETL_SYSTEM argv));
   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}

void NR_GET_LVECTOR(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,r;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_lvector",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,ft_short);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple of integers",1,"nr_lvector",
            abend_opnd_str(SETL_SYSTEM argv));

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_ulvect*65536+nr_type;
   mat->use_count = 1;

   mat->p = (void *)lvector(1,rows);
   mat->r = rows;
   mat->c = 1;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (ia_element->sp_form==ft_short) {
	((unsigned long *)(mat->p))[r]=(int)(ia_element->sp_val.sp_short_value);
     } else 
        abend(SETL_SYSTEM "the vector must be integer","vector",1,
	   "nr_lvector", abend_opnd_str(SETL_SYSTEM argv));
   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}

void NR_GET_IVECTOR(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,r;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_ivector",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,ft_short);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple of integers",1,"nr_ivector",
            abend_opnd_str(SETL_SYSTEM argv));

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_ivect*65536+nr_type;
   mat->use_count = 1;

   mat->p = (void *)ivector(1,rows);
   mat->r = rows;
   mat->c = 1;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (ia_element->sp_form==ft_short) {
	((int *)(mat->p))[r]=(int)(ia_element->sp_val.sp_short_value);
     } else 
        abend(SETL_SYSTEM "the vector must be integer","vector",1,
	   "nr_ivector", abend_opnd_str(SETL_SYSTEM argv));
   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}

/***********************************************************************/

void NR_GET_CVECTOR(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,r;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_get_cvector",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,ft_short);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple of integers",1,"nr_get_cvector",
            abend_opnd_str(SETL_SYSTEM argv));

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_cvect*65536+nr_type;
   mat->use_count = 1;

   mat->p = (void *)cvector(1,rows);
   mat->r = rows;
   mat->c = 1;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (ia_element->sp_form==ft_short) {
	((unsigned char *)(mat->p))[r]=(unsigned char)(ia_element->sp_val.sp_short_value);
     } else 
        abend(SETL_SYSTEM "the vector must be integer","vector",1,
	   		"nr_get_cvector", abend_opnd_str(SETL_SYSTEM argv));
   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}

/***********************************************************************/

void NR_GET_TENSOR(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
TUPLE_ITERATOR(ib)
TUPLE_ITERATOR(ic)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,columns,hh,r,c,h;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_tensor",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,ft_tuple);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_tensor",
            abend_opnd_str(SETL_SYSTEM argv));

   columns=-1;
   hh=-1;

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_ftens*65536+nr_type;
   mat->use_count = 1;
   mat->p = NULL;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (columns<0) {
	columns=get_tuple_count(SETL_SYSTEM 
			        ia_element->sp_val.sp_tuple_ptr,ft_tuple);

        if (columns<0) 
           abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_tensor",
                 abend_opnd_str(SETL_SYSTEM argv));

     } else if (columns!=get_tuple_count(SETL_SYSTEM 
		      	        ia_element->sp_val.sp_tuple_ptr,ft_tuple))
           abend(SETL_SYSTEM "rows have different sizes","tuple of tuples",1,
		"nr_tensor", abend_opnd_str(SETL_SYSTEM argv));

     c=0;
     ITERATE_TUPLE_BEGIN(ib,(*ia_element))
     {
        c++;

        if (hh<0) {

   	   hh=get_tuple_count(SETL_SYSTEM 
			        ib_element->sp_val.sp_tuple_ptr,0);

           if (hh<0) 
              abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_tensor",
                    abend_opnd_str(SETL_SYSTEM argv));
       
           mat->p = (void *)f3tensor(1,rows,1,columns,1,hh);
           mat->r = rows;
           mat->c = columns;
           mat->h = hh;

        } else if (hh!=get_tuple_count(SETL_SYSTEM 
		      	        ib_element->sp_val.sp_tuple_ptr,0))
              abend(SETL_SYSTEM "columns have different sizes","tuple of tuples",1,
   		"nr_tensor", abend_opnd_str(SETL_SYSTEM argv));

        h=0;
        ITERATE_TUPLE_BEGIN(ic,(*ib_element))
        {
	   h++;

   	   if (ic_element->sp_form==ft_short) {
		((float ***)(mat->p))[r][c][h]=(float)(ic_element->sp_val.sp_short_value);
           } else 
           if (ic_element->sp_form==ft_real) {
		((float ***)(mat->p))[r][c][h]=(float)((ic_element->sp_val.sp_real_ptr)->r_value);

           } else 
              abend(SETL_SYSTEM "the matrix must be integer or real","matrix",1,
	   	"nr_tensor", abend_opnd_str(SETL_SYSTEM argv));
	}
        ITERATE_TUPLE_END(ic)

     }
     ITERATE_TUPLE_END(ib)

   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}


void NR_GET_ZERO_VECTOR(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
struct nrmatrix *mat;
int r,c,h;
int stlen;
int t;
int rows;
char typ[128];
STRING_ITERATOR(si)
char *s;

	if (argv[0].sp_form != ft_short)
			abend(SETL_SYSTEM msg_bad_arg,"integer",1,"nr_get_zero_vector",
			abend_opnd_str(SETL_SYSTEM argv));
			

	if (argv[1].sp_form != ft_string)
			abend(SETL_SYSTEM msg_bad_arg,"string",2,"nr_get_zero_vector",
			abend_opnd_str(SETL_SYSTEM argv+1));
	stlen=STRING_LEN(argv[1]);
        if (stlen>128)
	   abend(SETL_SYSTEM "Invalid type passed to nr_get_zero_vector");


	ITERATE_STRING_BEGIN(si,argv[1]);
        STRING_CONVERT(si,typ);

	s=typ;
	switch (*s) {
	   case 'f':t=1;break;
	   case 'd':t=2;break;
	   case 'i':t=3;break;
	   case 'u':
		t=4;
		if (*(s+1)=='l') s++;
		break;
	   default:
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_update");
	  
 	} 
   rows = argv[0].sp_val.sp_short_value;	
   
   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = (t+10)*65536+nr_type;
   mat->use_count = 1;

   switch (t) {
   	case 1:
   	 mat->p = (void *)vector(1,rows);
   	  break;
   	case 2:
   	 mat->p = (void *)dvector(1,rows);
   	  break;
   	case 3:
   	 mat->p = (void *)ivector(1,rows);
   	  break;
   	case 4:
   	 mat->p = (void *)lvector(1,rows);
   	  break;
   	  
   	  
   }
  
   mat->r = rows;
   mat->c = 1;

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;

}

/***********************************************************************/

void NR_GET_MATRIX(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
TUPLE_ITERATOR(ib)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,columns,r,c;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_matrix",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,ft_tuple);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_matrix",
            abend_opnd_str(SETL_SYSTEM argv));

   columns=-1;

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_fmat*65536+nr_type;
   mat->use_count = 1;
   mat->p = NULL;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (columns<0) {
	columns=get_tuple_count(SETL_SYSTEM 
			        ia_element->sp_val.sp_tuple_ptr,0);

        if (columns<0) 
           abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_matrix",
                 abend_opnd_str(SETL_SYSTEM argv));
       
        mat->p = (void *)matrix(1,rows,1,columns);
        mat->r = rows;
        mat->c = columns;

     } else if (columns!=get_tuple_count(SETL_SYSTEM 
		      	        ia_element->sp_val.sp_tuple_ptr,0))
           abend(SETL_SYSTEM "rows have different sizes","tuple of tuples",1,
		"nr_matrix", abend_opnd_str(SETL_SYSTEM argv));

     c=0;
     ITERATE_TUPLE_BEGIN(ib,(*ia_element))
     {
        c++;
	if (ib_element->sp_form==ft_short) {
		((float **)(mat->p))[r][c]=(float)(ib_element->sp_val.sp_short_value);
        } else 
        if (ib_element->sp_form==ft_real) {
		((float **)(mat->p))[r][c]=(float)((ib_element->sp_val.sp_real_ptr)->r_value);

        } else 
           abend(SETL_SYSTEM "the matrix must be integer or real","matrix",1,
		"nr_matrix", abend_opnd_str(SETL_SYSTEM argv));
     }
     ITERATE_TUPLE_END(ib)

   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}

void NR_GET_DMATRIX(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
TUPLE_ITERATOR(ib)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,columns,r,c;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_dmatrix",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,ft_tuple);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_dmatrix",
            abend_opnd_str(SETL_SYSTEM argv));

   columns=-1;

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_dmat*65536+nr_type;
   mat->use_count = 1;
   mat->p = NULL;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (columns<0) {
	columns=get_tuple_count(SETL_SYSTEM 
			        ia_element->sp_val.sp_tuple_ptr,0);

        if (columns<0) 
           abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_dmatrix",
                 abend_opnd_str(SETL_SYSTEM argv));
       
        mat->p = (void *)dmatrix(1,rows,1,columns);
        mat->r = rows;
        mat->c = columns;

     } else if (columns!=get_tuple_count(SETL_SYSTEM 
		      	        ia_element->sp_val.sp_tuple_ptr,0))
           abend(SETL_SYSTEM "rows have different sizes","tuple of tuples",1,
		"nr_dmatrix", abend_opnd_str(SETL_SYSTEM argv));

     c=0;
     ITERATE_TUPLE_BEGIN(ib,(*ia_element))
     {
        c++;
	if (ib_element->sp_form==ft_short) {
		((double**)(mat->p))[r][c]=(double)(ib_element->sp_val.sp_short_value);
        } else 
        if (ib_element->sp_form==ft_real) {
		((double **)(mat->p))[r][c]=(double)((ib_element->sp_val.sp_real_ptr)->r_value);

        } else 
           abend(SETL_SYSTEM "the matrix must be integer or real","matrix",1,
		"nr_dmatrix", abend_opnd_str(SETL_SYSTEM argv));
     }
     ITERATE_TUPLE_END(ib)

   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}

void NR_GET_IMATRIX(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
TUPLE_ITERATOR(ib)
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
int rows,columns,r,c;
struct nrmatrix *mat;

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"nr_imatrix",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[0].sp_val.sp_tuple_ptr;
   rows = get_tuple_count(SETL_SYSTEM source_root,ft_tuple);

   if (rows<0) 
      abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_imatrix",
            abend_opnd_str(SETL_SYSTEM argv));

   columns=-1;

   mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

   mat->type    = nr_imat*65536+nr_type;
   mat->use_count = 1;
   mat->p = NULL;

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[0])
   {
     r++;
     if (columns<0) {
	columns=get_tuple_count(SETL_SYSTEM 
			        ia_element->sp_val.sp_tuple_ptr,0);

        if (columns<0) 
           abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"nr_imatrix",
                 abend_opnd_str(SETL_SYSTEM argv));
       
        mat->p = (void *)imatrix(1,rows,1,columns);
        mat->r = rows;
        mat->c = columns;

     } else if (columns!=get_tuple_count(SETL_SYSTEM 
		      	        ia_element->sp_val.sp_tuple_ptr,0))
           abend(SETL_SYSTEM "rows have different sizes","tuple of tuples",1,
		"nr_imatrix", abend_opnd_str(SETL_SYSTEM argv));

     c=0;
     ITERATE_TUPLE_BEGIN(ib,(*ia_element))
     {
        c++;
	if (ib_element->sp_form==ft_short) {
		((int **)(mat->p))[r][c]=(int)(ib_element->sp_val.sp_short_value);
        } else 
           abend(SETL_SYSTEM "the matrix must be integer","matrix",1,
		"nr_imatrix", abend_opnd_str(SETL_SYSTEM argv));
     }
     ITERATE_TUPLE_END(ib)

   }
   ITERATE_TUPLE_END(ia)

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

   return;
}


void NR_PRINT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
struct nrmatrix *mat;
int r,c,h;
int t,st;

   if ((argv[0].sp_form != ft_opaque)||
	(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_print",
            abend_opnd_str(SETL_SYSTEM argv));
 
   mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
   t=mat->type>>16;

   plugin_printf("Type = %d \n",t);
   if (t<10) {
   plugin_printf("Matrix Dimensions = %d x %d \n",mat->r,mat->c);
   for (r=1;r<=mat->r;r++) {
      for (c=1;c<=mat->c;c++) {
         
         switch(t) {
         	case nr_fmat:
	            plugin_printf("%f ",((float **)(mat->p))[r][c]);
            break;
			case nr_dmat:
    	        plugin_printf("%f ",((double **)(mat->p))[r][c]);
    	    break;
			case nr_imat:
	            plugin_printf("%d ",((int **)(mat->p))[r][c]);
	        break;
	  	}
      } 
      plugin_printf("\n");
   }
   } else if (t<20) {
   plugin_printf("Vector Dimensions = %d \n",mat->r);
   for (r=1;r<=mat->r;r++) {

		switch(t) {
         case nr_fvect:
            plugin_printf("%f ",((float *)(mat->p))[r]);
         break;
         case nr_dvect:
            plugin_printf("%f ",((double *)(mat->p))[r]);
         break;
         case nr_ivect:
            plugin_printf("%d ",((int *)(mat->p))[r]);
         break;
         case nr_ulvect:
            plugin_printf("%d ",((unsigned long *)(mat->p))[r]);
         break;
         case nr_cvect:
            plugin_printf("%d ",(int)((unsigned char *)(mat->p))[r]);
         break;
       	}
      } 
      plugin_printf("\n");
   } else if (t<30) {
   plugin_printf("Tensor Dimensions = %d x %d x %d\n",mat->r,mat->c,mat->h);
   for (r=1;r<=mat->r;r++) {
      for (c=1;c<=mat->c;c++) {
	plugin_printf("(");
        for (h=1;h<=mat->h;h++) {
         if (t==nr_ftens)
            plugin_printf("%f ",((float ***)(mat->p))[r][c][h]);
      } 
	plugin_printf(")");
   }
      plugin_printf("\n");
   }
   }
}

void NR_GET_ELEMENT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type source_root;          /* root node pointer                 */
i_real_ptr_type real_ptr;              /* real pointer                      */
TUPLE_ITERATOR(ia)
struct nrmatrix *mat;
int nindex;
int r,c,h;
int t,st;
unsigned long ind[3];
int32 ri;
float rf;
double rd;

   if ((argv[0].sp_form != ft_opaque)||
	(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
      abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_get_element",
            abend_opnd_str(SETL_SYSTEM argv));
 
   mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
   t=mat->type>>16;

   /* the last must be a tuple */

   if (argv[1].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",2,"nr_get_element",
            abend_opnd_str(SETL_SYSTEM argv+1));

   /* set up to loop over the tuple, counting arguments and lengths */

   source_root = argv[1].sp_val.sp_tuple_ptr;
   nindex = get_tuple_count(SETL_SYSTEM source_root,ft_short);

   if ((nindex<0)||(nindex>3)) 
      abend(SETL_SYSTEM msg_bad_arg,"integer tuple",2,"nr_get_element",
            abend_opnd_str(SETL_SYSTEM argv+1));

   r=0;
   ITERATE_TUPLE_BEGIN(ia,argv[1])
   {
     if (ia_element->sp_form==ft_short) {
	ind[r]=(ia_element->sp_val.sp_short_value);
     } else 
        abend(SETL_SYSTEM "the tuple must be integer",2,
	   "nr_get_element", abend_opnd_str(SETL_SYSTEM argv+1));
     r++;
   }
   ITERATE_TUPLE_END(ia)

   if (t<10) {
	if (nindex!=2)
          abend(SETL_SYSTEM "the tuple must have 2 elements");
         r=ind[0];
         c=ind[1];
         if (t==nr_fmat) 
            rf=((float **)(mat->p))[r][c];
         if (t==nr_dmat)
            rd=((double **)(mat->p))[r][c];
         if (t==nr_imat)
            ri=((int **)(mat->p))[r][c];
   } else if (t<20) {
	if (nindex!=1)
          abend(SETL_SYSTEM "the tuple must have 1 elements");
         r=ind[0];
         if (t==nr_fvect)
            rf=((float *)(mat->p))[r];
         if (t==nr_dvect)
            rd=((double *)(mat->p))[r];
         if (t==nr_ivect)
            ri=((int *)(mat->p))[r];
         if (t==nr_ulvect)
            ri=((unsigned long *)(mat->p))[r];
   } else if (t<30) {
	if (nindex!=3)
          abend(SETL_SYSTEM "the tuple must have 3 elements");
         r=ind[0];
         c=ind[1];
         h=ind[2];
         rf=((float ***)(mat->p))[r][c][h];
   }


   if ((t==nr_imat)||(t==nr_ivect)||
       (t==nr_ulvect)) {
     unmark_specifier(target);
     target->sp_form = ft_short;
     target->sp_val.sp_short_value = ri;
   }
    
   if ((t==nr_fmat)||(t==nr_fvect)||(t==nr_ftens)) {
      unmark_specifier(target);
      i_get_real(real_ptr);
      target->sp_form = ft_real;
      target->sp_val.sp_real_ptr = real_ptr;
      real_ptr->r_use_count = 1;
      real_ptr->r_value = rf;

      return;
   }

   if ((t==nr_dmat)||(t==nr_dvect)) {
      unmark_specifier(target);
      i_get_real(real_ptr);
      target->sp_form = ft_real;
      target->sp_val.sp_real_ptr = real_ptr;
      real_ptr->r_use_count = 1;
      real_ptr->r_value = rd;

      return;
   }

}

void NR_PTR_UPDATE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
TUPLE_CONSTRUCTOR(ca)
TUPLE_CONSTRUCTOR(cb)
TUPLE_CONSTRUCTOR(cc)
void *ptr;
struct nrmatrix mat;
i_real_ptr_type real_ptr;              /* real pointer                      */
int t;
int r,c,h;
int32 ri;
float rf;
double rd;
specifier spare;
int stlen;
int e;
int idx[3];
char typ[128];
STRING_ITERATOR(si)
char *s;
double element;

	if (argv[0].sp_form != ft_opaque)
			abend(SETL_SYSTEM msg_bad_arg,"opaque",1,"nr_ptr_update",
			abend_opnd_str(SETL_SYSTEM argv));

	ptr = (void *)(argv[0].sp_val.sp_opaque_ptr);
	mat.p=ptr;

	if (argv[1].sp_form != ft_string)
			abend(SETL_SYSTEM msg_bad_arg,"string",2,"nr_ptr_update",
			abend_opnd_str(SETL_SYSTEM argv+1));
	stlen=STRING_LEN(argv[1]);
        if (stlen>128)
	   abend(SETL_SYSTEM "Invalid type passed to nr_ptr_update");

	if ((argv[2].sp_form != ft_short)&& (argv[2].sp_form != ft_real))
		abend(SETL_SYSTEM msg_bad_arg,"int or real",3,"nr_ptr_update",
			abend_opnd_str(SETL_SYSTEM argv+2));

	if (argv[2].sp_form==ft_short) {
	   element=(double)(argv[2].sp_val.sp_short_value);
        } else 
	   element=(double)((argv[2].sp_val.sp_real_ptr)->r_value);

	ITERATE_STRING_BEGIN(si,argv[1]);
        STRING_CONVERT(si,typ);

	s=typ;
	switch (*s) {
	   case 'f':t=1;break;
	   case 'd':t=2;break;
	   case 'i':t=3;break;
	   case 'u':
		t=4;
		if (*(s+1)=='l') s++;
		break;
	   default:
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_update");
	  
 	} 	
        s++;
	if (*s!=',') 
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_update");

        e=0; /* parameter number */
	s++;
        while (*s!=0) {
	  char *d; char bak;
	  int spam;
          d=s;
          while ((*d!=0)&&(*d!=',')) d++;
		/* d points to 0 or a comma */
          bak=*d;
	  *d=0;
   	  spam=atoi(s);
	  switch (e) {
		case 0:mat.r=spam; break;
		case 1:mat.c=spam; break;
		case 2:mat.h=spam; break;
		default:
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_update");
	  }
	  idx[e]=spam;
	  e++;
	  *d=bak;
	  s=d;
	  if (*s==',') s++;
	  

	}
	switch (e) {
		case 1:t+=10; break;
		case 2:break;
		case 3:t+=20;break;
		default:
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_update");
	}
   if (t<10) {
         if (t==nr_fmat)
            ((float **)(mat.p))[mat.r][mat.c]=(float)element;
         if (t==nr_dmat)
            ((double **)(mat.p))[mat.r][mat.c]=(double)element;
         if (t==nr_imat)
            ((int **)(mat.p))[mat.r][mat.c]=(int)element;
   } else if (t<20) {
         if (t==nr_fvect)
            ((float *)(mat.p))[mat.r]=(float)element;
         if (t==nr_dvect)
            ((double *)(mat.p))[mat.r]=(double)element;
         if (t==nr_ivect)
            ((int *)(mat.p))[mat.r]=(int)element;
         if (t==nr_ulvect)
            ((unsigned long *)(mat.p))[mat.r]=(unsigned long)element;
   } else if (t<30) {
            ((float ***)(mat.p))[mat.r][mat.c][mat.h]=(float)element;
   } 

   unmark_specifier(target);
   target->sp_form=ft_omega;
   return;

}

void NR_GET_REFCOUNT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int ri=-1;
 
   if (argv[0].sp_form>=ft_opaque) 
      ri=(*((int32 *)(argv[0].sp_val.sp_biggest)));

   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = ri;
   return;

}

struct nrmatrix *nr_copy(struct nrmatrix *spec)
{
struct nrmatrix *newspec;
int subtyp;
int size;

	newspec=(struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	if (newspec) {
		bcopy(spec,newspec,sizeof(struct nrmatrix));
		newspec->use_count=1;	/*GDM 052899 (was 0)*/
		subtyp=spec->type>>16;

		switch(subtyp) {
			case nr_fmat:
				newspec->p=(void*)matrix(1,spec->r,1,spec->c);
				size=spec->r*spec->c*sizeof(float);
				bcopy(&((float **)(spec->p))[1][1],
					&((float **)(newspec->p))[1][1],
						size);
			break;
			case nr_dmat:
				newspec->p=(void*)dmatrix(1,spec->r,1,spec->c);
				size=spec->r*spec->c*sizeof(double);
				bcopy(&((double **)(spec->p))[1][1],
					&((double **)(newspec->p))[1][1],
						size);
			break;
			case nr_imat:
				newspec->p=(void*)imatrix(1,spec->r,1,spec->c);
				size=spec->r*spec->c*sizeof(int);
				bcopy(&((int **)(spec->p))[1][1],
					&((int **)(newspec->p))[1][1],
						size);
			break;
			case nr_fvect:
				newspec->p=(void*)vector(1,spec->r);
				size=spec->r*sizeof(float);
				bcopy(&((float *)(spec->p))[1],
					&((float *)(newspec->p))[1],
						size);
			break;
			case nr_dvect:
				newspec->p=(void*)dvector(1,spec->r);
				size=spec->r*sizeof(double);
				bcopy(&((double *)(spec->p))[1],
					&((double *)(newspec->p))[1],
						size);
			break;
			case nr_ivect:
				newspec->p=(void*)ivector(1,spec->r);
				size=spec->r*sizeof(int);
				bcopy(&((int *)(spec->p))[1],
					&((int *)(newspec->p))[1],
						size);
			break;
			case nr_cvect:
				newspec->p=(void*)cvector(1,spec->r);
				size=spec->r*sizeof(unsigned char);
				bcopy(&((unsigned char *)(spec->p))[1],
					&((unsigned char *)(newspec->p))[1],
						size);
			break;
			case nr_ulvect:
				newspec->p=(void*)lvector(1,spec->r);
				size=spec->r*sizeof(unsigned long);
				bcopy(&((unsigned long *)(spec->p))[1],
					&((unsigned long *)(newspec->p))[1],
						size);
			break;
			case nr_ftens:
				newspec->p=(void*)f3tensor(1,spec->r,1,spec->c,1,spec->h);
				size=spec->r*spec->c*spec->h*sizeof(float);
				bcopy(&((float ***)(spec->p))[1][1][1],
					&((float ***)(newspec->p))[1][1][1],
						size);
			break;
			default:
			break;
		}
	}
	return newspec;
}

void NR_PTR_CONTENTS(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
TUPLE_CONSTRUCTOR(ca)
TUPLE_CONSTRUCTOR(cb)
TUPLE_CONSTRUCTOR(cc)
void *ptr;
struct nrmatrix mat;
i_real_ptr_type real_ptr;              /* real pointer                      */
int t;
int r,c,h;
int32 ri;
float rf;
double rd;
specifier spare;
int stlen;
int e;
int dim[3];
char typ[128];
STRING_ITERATOR(si)
char *s;

	if (argv[0].sp_form != ft_opaque)
			abend(SETL_SYSTEM msg_bad_arg,"opaque",1,"nr_ptr_content",
			abend_opnd_str(SETL_SYSTEM argv));

	ptr = (void *)(argv[0].sp_val.sp_opaque_ptr);
	mat.p=ptr;

	if (argv[1].sp_form != ft_string)
			abend(SETL_SYSTEM msg_bad_arg,"string",2,"nr_ptr_content",
			abend_opnd_str(SETL_SYSTEM argv+1));
	stlen=STRING_LEN(argv[1]);
        if (stlen>128)
	   abend(SETL_SYSTEM "Invalid type passed to nr_ptr_content");

	ITERATE_STRING_BEGIN(si,argv[1]);
        STRING_CONVERT(si,typ);

	s=typ;
	switch (*s) {
	   case 'f':t=1;break;
	   case 'd':t=2;break;
	   case 'i':t=3;break;
	   case 'u':
		t=4;
		if (*(s+1)=='l') s++;
		break;
	   default:
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_content");
	  
 	} 	
        s++;
	if (*s!=',') 
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_content");

        e=0; /* parameter number */
	s++;
        while (*s!=0) {
	  char *d; char bak;
	  int spam;
          d=s;
          while ((*d!=0)&&(*d!=',')) d++;
		/* d points to 0 or a comma */
          bak=*d;
	  *d=0;
   	  spam=atoi(s);
	  switch (e) {
		case 0:mat.r=spam; break;
		case 1:mat.c=spam; break;
		case 2:mat.h=spam; break;
		default:
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_content");
	  }
	  e++;
	  *d=bak;
	  s=d;
	  if (*s==',') s++;
	  

	}
	switch (e) {
		case 1:t+=10; break;
		case 2:break;
		case 3:t+=20;break;
		default:
	      abend(SETL_SYSTEM "Invalid type passed to nr_ptr_content");
	}
	
	if (t<10) { /* Matrix */
		TUPLE_CONSTRUCTOR_BEGIN(ca);
		for (r=1;r<=mat.r;r++) {

			TUPLE_CONSTRUCTOR_BEGIN(cb);
			for (c=1;c<=mat.c;c++) {

				if (t==nr_fmat) {
					rf=((float **)(mat.p))[r][c];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rf;
					TUPLE_ADD_CELL(cb,&spare);
				}
				if (t==nr_dmat) {
					rd=((double **)(mat.p))[r][c];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rd;
					TUPLE_ADD_CELL(cb,&spare);
				}
				if (t==nr_imat) {
					ri=((int **)(mat.p))[r][c];
					spare.sp_form=ft_short;
					spare.sp_val.sp_short_value=ri;
					TUPLE_ADD_CELL(cb,&spare);
				}

			}
			TUPLE_CONSTRUCTOR_END(cb);

			spare.sp_form=ft_tuple;
			spare.sp_val.sp_tuple_ptr = TUPLE_HEADER(cb);

			TUPLE_ADD_CELL(ca,&spare);

		}
		TUPLE_CONSTRUCTOR_END(ca);
	} else 
		if (t<20) { /* Vector */
			TUPLE_CONSTRUCTOR_BEGIN(ca);
			for (r=1;r<=mat.r;r++) {

				if (t==nr_fvect) {
					rf=((float *)(mat.p))[r];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rf;
					TUPLE_ADD_CELL(ca,&spare);
				}
					if (t==nr_dvect) {
					rd=((double *)(mat.p))[r];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rd;
					TUPLE_ADD_CELL(ca,&spare);
				}
				if (t==nr_ivect) {
					ri=((int *)(mat.p))[r];
					spare.sp_form=ft_short;
					spare.sp_val.sp_short_value = ri;
					TUPLE_ADD_CELL(ca,&spare);
				}
				if (t==nr_ulvect) {
					ri=((unsigned long *)(mat.p))[r];
					spare.sp_form=ft_short;
					spare.sp_val.sp_short_value = ri;
					TUPLE_ADD_CELL(ca,&spare);
				}

			}
			TUPLE_CONSTRUCTOR_END(ca);

		} else 
	if (t<30) { /* Tensor */
		TUPLE_CONSTRUCTOR_BEGIN(ca);
		for (r=1;r<=mat.r;r++) {

			TUPLE_CONSTRUCTOR_BEGIN(cb);
			for (c=1;c<=mat.c;c++) {

				TUPLE_CONSTRUCTOR_BEGIN(cc);
				for (h=1;h<=mat.h;h++) {

					rf=((float ***)(mat.p))[r][c][h];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rf;
					TUPLE_ADD_CELL(ca,&spare);

				}
				TUPLE_CONSTRUCTOR_END(cc);

				spare.sp_form = ft_tuple;
				spare.sp_val.sp_tuple_ptr = TUPLE_HEADER(cc);

				TUPLE_ADD_CELL(cb,&spare);

			}
			TUPLE_CONSTRUCTOR_END(cb);

			spare.sp_form = ft_tuple;
			spare.sp_val.sp_tuple_ptr = TUPLE_HEADER(cb);

			TUPLE_ADD_CELL(ca,&spare);
		}
		TUPLE_CONSTRUCTOR_END(ca);
	} 

	unmark_specifier(target);
	target->sp_form = ft_tuple;
	target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);

	return;

}

void NR_GET_OBJECT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
TUPLE_CONSTRUCTOR(ca)
TUPLE_CONSTRUCTOR(cb)
TUPLE_CONSTRUCTOR(cc)
struct nrmatrix *mat;
i_real_ptr_type real_ptr;              /* real pointer                      */
int t;
int r,c,h;
int32 ri;
float rf;
double rd;
specifier spare;

int e;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_get_object",
			abend_opnd_str(SETL_SYSTEM argv));

	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t=mat->type>>16;

	if (t<10) { /* Matrix */
		TUPLE_CONSTRUCTOR_BEGIN(ca);
		for (r=1;r<=mat->r;r++) {
/*			TUPLE_ADD_BEGIN(ca);	/*GDM 052899*/

			TUPLE_CONSTRUCTOR_BEGIN(cb);
			for (c=1;c<=mat->c;c++) {

/*				TUPLE_ADD_BEGIN(cb);	/*GDM 052899*/

				if (t==nr_fmat) {
					rf=((float **)(mat->p))[r][c];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rf;
					TUPLE_ADD_CELL(cb,&spare);
				}
				else if (t==nr_dmat) {
					rd=((double **)(mat->p))[r][c];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rd;
					TUPLE_ADD_CELL(cb,&spare);
				}
				else if (t==nr_imat) {
					ri=((int **)(mat->p))[r][c];
					spare.sp_form=ft_short;
					spare.sp_val.sp_short_value=ri;
					TUPLE_ADD_CELL(cb,&spare);
				}

/*				TUPLE_ADD_END(cb);	/*GDM 052899*/

			}
			TUPLE_CONSTRUCTOR_END(cb);

			spare.sp_form=ft_tuple;
			spare.sp_val.sp_tuple_ptr = TUPLE_HEADER(cb);

			TUPLE_ADD_CELL(ca,&spare);

/*			TUPLE_ADD_END(ca);	/*GDM 052899*/
		}
		TUPLE_CONSTRUCTOR_END(ca);
	} else 
		if (t<20) { /* Vector */
			TUPLE_CONSTRUCTOR_BEGIN(ca);
			for (r=1;r<=mat->r;r++) {
/*				TUPLE_ADD_BEGIN(ca);	/*GDM 052899*/

				if (t==nr_fvect) {
					rf=((float *)(mat->p))[r];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rf;
					TUPLE_ADD_CELL(ca,&spare);
				}
				else if (t==nr_dvect) {
					rd=((double *)(mat->p))[r];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rd;
					TUPLE_ADD_CELL(ca,&spare);
				}
				else if (t==nr_ivect) {
					ri=((int *)(mat->p))[r];
					spare.sp_form=ft_short;
					spare.sp_val.sp_short_value = ri;
					TUPLE_ADD_CELL(ca,&spare);
				}
				else if (t==nr_ulvect) {
					ri=((unsigned long *)(mat->p))[r];
					spare.sp_form=ft_short;
					spare.sp_val.sp_short_value = ri;
					TUPLE_ADD_CELL(ca,&spare);
				}
				else if (t==nr_cvect) {
					ri=((unsigned char *)(mat->p))[r];
					spare.sp_form=ft_short;
					spare.sp_val.sp_short_value = ri;
					TUPLE_ADD_CELL(ca,&spare);
				}

/*				TUPLE_ADD_END(ca);	/*GDM 052899*/

			}
			TUPLE_CONSTRUCTOR_END(ca);

		} else 
	if (t<30) { /* Tensor */
		TUPLE_CONSTRUCTOR_BEGIN(ca);
		for (r=1;r<=mat->r;r++) {
/*			TUPLE_ADD_BEGIN(ca);	/*GDM 052899*/

			TUPLE_CONSTRUCTOR_BEGIN(cb);
			for (c=1;c<=mat->c;c++) {

/*				TUPLE_ADD_BEGIN(cb);	/*GDM 052899*/

				TUPLE_CONSTRUCTOR_BEGIN(cc);
				for (h=1;h<=mat->h;h++) {

/*					TUPLE_ADD_BEGIN(cc);	/*GDM 052899*/

					rf=((float ***)(mat->p))[r][c][h];
					i_get_real(real_ptr);
					spare.sp_form=ft_real;
					spare.sp_val.sp_real_ptr = real_ptr;
					real_ptr->r_use_count = 1;
					real_ptr->r_value = rf;
					TUPLE_ADD_CELL(ca,&spare);

/*					TUPLE_ADD_END(cc);	/*GDM 052899*/
				}
				TUPLE_CONSTRUCTOR_END(cc);

				spare.sp_form = ft_tuple;
				spare.sp_val.sp_tuple_ptr = TUPLE_HEADER(cc);

				TUPLE_ADD_CELL(cb,&spare);

/*				TUPLE_ADD_END(cb);	/*GDM 052899*/

			}
			TUPLE_CONSTRUCTOR_END(cb);

			spare.sp_form = ft_tuple;
			spare.sp_val.sp_tuple_ptr = TUPLE_HEADER(cb);

			TUPLE_ADD_CELL(ca,&spare);
		}
		TUPLE_CONSTRUCTOR_END(ca);
	} 

	unmark_specifier(target);
	target->sp_form = ft_tuple;
	target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);

	return;

}

/*
 *	Matrix operations
 */

double d_sum_op(double d1, double d2)
{
	return d1 + d2;
}

int i_sum_op(int i1, int i2)
{
	return i1 + i2;
}

double d_diff_op(double d1, double d2)
{
	return d1 - d2;
}

int i_diff_op(int i1, int i2)
{
	return i1 - i2;
}

double d_diff_reverse_op(double d1, double d2)
{
	return d2 - d1;
}

int i_diff_reverse_op(int i1, int i2)
{
	return i2 - i1;
}

double d_prod_op(double d1, double d2)
{
	return d1 * d2;
}

int i_prod_op(int i1, int i2)
{
	return i1 * i2;
}

struct nrmatrix *constant_binop_matrix_or_vector(struct nrmatrix *mat_a, void *constant, int t, double (*dop)(double, double), int (*iop)(int, int))
{

	struct nrmatrix *mat;
	int r, c, rn, cn;

	if (t < 10) /* matrix */
		cn = mat_a->c;
	rn = mat_a->r;

	switch (t) {
		case nr_fmat:
			
			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_fmat*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)matrix(1,rn,1,cn);
			mat->r = rn;
			mat->c = cn;

			for (r=1;r<=rn;r++) 
				for (c=1;c<=cn;c++) 
					((float **)(mat->p))[r][c] = dop(((float **)(mat_a->p))[r][c], *(double *)constant);
			break;

		case nr_dmat:

			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_dmat*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)dmatrix(1,rn,1,cn);
			mat->r = rn;
			mat->c = cn;

			for (r=1;r<=rn;r++) 
				for (c=1;c<=cn;c++) 
					((double **)(mat->p))[r][c] = dop(((double **)(mat_a->p))[r][c], *(double *)constant);
			break;

		case nr_imat:

			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_imat*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)imatrix(1,rn,1,cn);
			mat->r = rn;
			mat->c = cn;

			for (r=1;r<=rn;r++) 
				for (c=1;c<=cn;c++) 
					((int **)(mat->p))[r][c] = iop(((int **)(mat_a->p))[r][c], *(int *)constant);
			break;

		case nr_fvect:
			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
			
			mat->type    = nr_fvect*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)vector(1,rn);
			mat->r = rn;
			mat->c = 1;

			for (r=1;r<=rn;r++) 
				((float *)(mat->p))[r] = dop(((float *)(mat_a->p))[r], *(double *)constant);
			break;

		case nr_dvect:
			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
			
			mat->type    = nr_dvect*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)dvector(1,rn);
			mat->r = rn;
			mat->c = 1;

			for (r=1;r<=rn;r++) 
				((double *)(mat->p))[r] = dop(((double *)(mat_a->p))[r], *(double *)constant);
			break;

		case nr_ivect:
			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_ivect*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)ivector(1,rn);
			mat->r = rn;
			mat->c = 1;

			for (r=1;r<=rn;r++) 
				((int *)(mat->p))[r] = iop(((int *)(mat_a->p))[r], *(int *)constant);
			break;

		case nr_ulvect:	/* convert the result to an int vector */
			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_ulvect*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)ivector(1,rn);
			mat->r = rn;
			mat->c = 1;

			for (r=1;r<=rn;r++) 
				((int *)(mat->p))[r] = iop(((unsigned long *)(mat_a->p))[r], *(int *)constant);
			break;
	}

	return mat;
}

struct nrmatrix *binop_matrix_or_vector(struct nrmatrix *mat_a, struct nrmatrix *mat_b, int t, double (*dop)(double, double), int (*iop)(int, int))
{
	struct nrmatrix *mat;
	int r, c, rn, cn;

	if (t < 10) /* matrix */
		cn = mat_a->c;
	rn = mat_a->r;

	switch (t) {
		case nr_fmat:
			
			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_fmat*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)matrix(1,rn,1,cn);
			mat->r = rn;
			mat->c = cn;

			for (r=1;r<=rn;r++) 
				for (c=1;c<=cn;c++) 
					((float **)(mat->p))[r][c] = dop(((float **)(mat_a->p))[r][c], ((float **)(mat_b->p))[r][c]);
			break;

		case nr_dmat:

			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_dmat*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)dmatrix(1,rn,1,cn);
			mat->r = rn;
			mat->c = cn;

			for (r=1;r<=rn;r++) 
				for (c=1;c<=cn;c++) 
					((double **)(mat->p))[r][c] = dop(((double **)(mat_a->p))[r][c], ((double **)(mat_b->p))[r][c]);
			break;

		case nr_imat:

			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_imat*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)imatrix(1,rn,1,cn);
			mat->r = rn;
			mat->c = cn;

			for (r=1;r<=rn;r++) 
				for (c=1;c<=cn;c++) 
					((int **)(mat->p))[r][c] = iop(((int **)(mat_a->p))[r][c], ((int **)(mat_b->p))[r][c]);
			break;

		case nr_fvect:
			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
			
			mat->type    = nr_fvect*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)vector(1,rn);
			mat->r = rn;
			mat->c = 1;

			for (r=1;r<=rn;r++) 
				((float *)(mat->p))[r] = dop(((float *)(mat_a->p))[r], ((float *)(mat_b->p))[r]);
			break;

		case nr_dvect:
			mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_dvect*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)dvector(1,rn);
			mat->r = rn;
			mat->c = 1;

			for (r=1;r<=rn;r++) 
				((double *)(mat->p))[r] = dop(((double *)(mat_a->p))[r] , ((double *)(mat_b->p))[r]);
			break;

		case nr_ivect:
		mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_ivect*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)ivector(1,rn);
			mat->r = rn;
			mat->c = 1;

			for (r=1;r<=rn;r++) 
				((int *)(mat->p))[r] = iop(((int *)(mat_a->p))[r], ((int *)(mat_b->p))[r]);
			break;

		case nr_ulvect:	/* convert the result to an int vector */
		mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));

			mat->type    = nr_ulvect*65536+nr_type;
			mat->use_count = 1;
			mat->p = (void *)ivector(1,rn);
			mat->r = rn;
			mat->c = 1;

			for (r=1;r<=rn;r++) 
				((int *)(mat->p))[r] = iop(((unsigned long *)(mat_a->p))[r], ((unsigned long *)(mat_b->p))[r]);
			break;
	}

	return mat;
}

struct nrmatrix *prod_matrix_or_vector(struct nrmatrix *mat_a, struct nrmatrix *mat_b, double (*dop)(double, double), int (*iop)(int, int), int *err)
{
	int t_a, t_b;
	struct nrmatrix *mat;
	int i, k, j, cn, rn, n;

	if (mat_a->c != mat_b->r) {
		*err = 1;
		return NULL;
	}
	
	*err = 0;
	
	t_a = mat_a->type >> 16;
	t_b = mat_b->type >> 16;

	rn = mat_a->r;
	cn = mat_b->c;	/* if this is a vector the number of columns should be 1 */

	n = mat_a->c;
	
	mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	mat->use_count = 1;
	mat->r = rn;
	mat->c = cn;
		 
	if (t_a == t_b) {
		
		int t;
		
			/* check for compatibility */
		if (t_a>10 && t_a<20) {	/* cannot multiply vector by vector */
			*err = 1;
			free(mat);
			return NULL;
		}
		
		t = t_a;

		switch (t) {

			case nr_fmat:
		
				mat->type    = nr_fmat*65536+nr_type;
				mat->p = (void *)matrix(1,rn,1,cn);

				for (i=1;i<=rn;i++) {
					for (k=1;k<=cn;k++) {
					
						((float **)(mat->p))[i][k] = (float)0.0;
					
						for (j=1;j<=n;j++)
							((float **)(mat->p))[i][k] += 
									((float **)(mat_a->p))[i][j] * ((float **)(mat_b->p))[j][k];
					}
				}
				
				break;
				
			case nr_dmat:
			
				mat->type    = nr_dmat*65536+nr_type;
				mat->p = (void *)dmatrix(1,rn,1,cn);

				for (i=1;i<=rn;i++) {
					for (k=1;k<=cn;k++) {
					
						((double **)(mat->p))[i][k] = (double)0.0;
					
						for (j=1;j<=n;j++)
							((double **)(mat->p))[i][k] += 
									((double **)(mat_a->p))[i][j] * ((double **)(mat_b->p))[j][k];
					}
				}

				break;
				
			case nr_imat:
			
				mat->type    = nr_imat*65536+nr_type;
				mat->p = (void *)imatrix(1,rn,1,cn);

				for (i=1;i<=rn;i++) {
					for (k=1;k<=cn;k++) {
					
						((int **)(mat->p))[i][k] = (int)0;
					
						for (j=1;j<=n;j++)
							((int **)(mat->p))[i][k] += 
									((int **)(mat_a->p))[i][j] * ((int **)(mat_b->p))[j][k];
					}
				}

				break;
		}
	}	
	else {

			/* consider various legal mixed cases */
		if ((t_a == nr_fmat) && (t_b == nr_fvect)) {

			mat->type    = nr_fmat*65536+nr_type;
			mat->p = (void *)matrix(1,rn,1,cn);

			for (i=1;i<=rn;i++) {
				((float **)(mat->p))[i][1] = 0.0F;
				
				for (j=1;j<=n;j++) {
					((float **)(mat->p))[i][1] += 
							((float **)(mat_a->p))[i][j] * ((float *)(mat_b->p))[j];
				}
			}
			

		} else if ((t_a == nr_dmat) && (t_b == nr_dvect)) {

			mat->type    = nr_dmat*65536+nr_type;
			mat->p = (void *)dmatrix(1,rn,1,cn);

			for (i=1;i<=rn;i++) {
				((double **)(mat->p))[i][1] = 0.0;
				
				for (j=1;j<=n;j++) {
					((double **)(mat->p))[i][1] += 
							((double **)(mat_a->p))[i][j] * ((double *)(mat_b->p))[j];
				}
			}

		} else if ((t_a == nr_imat) && (t_b == nr_ivect)) {

			mat->type    = nr_imat*65536+nr_type;
			mat->p = (void *)imatrix(1,rn,1,cn);

			for (i=1;i<=rn;i++) {
				((int **)(mat->p))[i][1] = 0.0;
				
				for (j=1;j<=n;j++) {
					((int **)(mat->p))[i][1] += 
							((int **)(mat_a->p))[i][j] * ((int *)(mat_b->p))[j];
				}
			}

		} else if ((t_a == nr_fvect) && (t_b == nr_fmat)) {

			mat->type    = nr_fmat*65536+nr_type;
			mat->p = (void *)matrix(1,rn,1,cn);

			for (i=1;i<=rn;i++) {
				for (k=1;k<=cn;k++) {
				
					((float **)(mat->p))[i][k] = 0.0f;
				
					for (j=1;j<=n;j++)
						((float **)(mat->p))[i][k] += 
								((float *)(mat_a->p))[i] * ((float **)(mat_b->p))[j][k];
				}
			}

		} else if ((t_a == nr_dvect) && (t_b == nr_dmat)) {

			mat->type    = nr_dmat*65536+nr_type;
			mat->p = (void *)dmatrix(1,rn,1,cn);

			for (i=1;i<=rn;i++) {
				for (k=1;k<=cn;k++) {
				
					((double **)(mat->p))[i][k] = 0.0;
				
					for (j=1;j<=n;j++)
						((double **)(mat->p))[i][k] += 
								((double *)(mat_a->p))[i] * ((double **)(mat_b->p))[j][k];
				}
			}

		} else if ((t_a == nr_ivect) && (t_b == nr_imat)) {

			mat->type    = nr_imat*65536+nr_type;
			mat->p = (void *)imatrix(1,rn,1,cn);

			for (i=1;i<=rn;i++) {
				for (k=1;k<=cn;k++) {
				
					((int **)(mat->p))[i][k] = 0;
				
					for (j=1;j<=n;j++)
						((int **)(mat->p))[i][k] += 
								((int *)(mat_a->p))[i] * ((int **)(mat_b->p))[j][k];
				}
			}

		} else {
			*err = 1;
			free(mat);
			return NULL;
		}
	}

	return mat;
}

void NR_VECT_PROD(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
struct nrmatrix *mat, *mat_a, *mat_b;
int r, c, rn, cn;
int t_a, t_b, t, st;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_sum",
				abend_opnd_str(SETL_SYSTEM argv));

	if ((argv[1].sp_form != ft_opaque)&&
		(((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",2,"nr_mat_sum",
				abend_opnd_str(SETL_SYSTEM argv+1));

	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	mat_b = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

	t_a=mat_a->type>>16;
	t_b=mat_b->type>>16;

	if ((t_a != t_b) || (mat_a->r != mat_b->r) || (mat_a->c != mat_b->c))
		abend(SETL_SYSTEM "Matrix or vector should share same size and type");

	t = t_a;	/* get the type from one of the two matrixes */

	mat = binop_matrix_or_vector(mat_a, mat_b, t, d_prod_op, i_prod_op);

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

	return;
}

void NR_SET_VECT_SLICE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
struct nrmatrix *mat, *mat_a, *mat_b;
int r, c, rn, cn;
int t_a, t_b, t, st;
int offset,i;
specifier return1;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"vector",1,"NR_SET_VECT_SLICE",
				abend_opnd_str(SETL_SYSTEM argv));

	if ((argv[1].sp_form != ft_short))
		abend(SETL_SYSTEM msg_bad_arg,"int",2,"NR_SET_VECT_SLICE",
			abend_opnd_str(SETL_SYSTEM argv+1));
			
	if ((argv[2].sp_form != ft_opaque)&&
		(((argv[2].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"vector",3,"NR_SET_VECT_SLICE",
				abend_opnd_str(SETL_SYSTEM argv+2));

	offset= argv[1].sp_val.sp_short_value;
	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	mat_b = (struct nrmatrix *)(argv[2].sp_val.sp_opaque_ptr);
	
	if ((offset<1) || (offset>(mat_a->r-mat_b->r+1)))
		abend(SETL_SYSTEM "Invalid offset in NR_SET_VECT_SLICE");
	
	
	t_a=mat_a->type>>16;
	t_b=mat_b->type>>16;
	if (t_a != t_b) 
		abend(SETL_SYSTEM "Matrix or vector should share same type");


   if (mat_a->use_count!=1) 
      mat_a=nr_copy(mat_a);
      
	

	rn=offset+mat_b->r-1;
	
    switch (t_a) {



		case nr_ivect:

			

			for (i=offset;i<=rn;i++)
				((int *)(mat_a->p))[i] = ((int *)(mat_b->p))[i-offset+1];
			
			break;

	
		case nr_fvect:
		
			for (i=offset;i<=rn;i++)
				((float *)(mat_a->p))[i] = ((float *)(mat_b->p))[i-offset+1];
			
			break;

	

		case nr_dvect:

		
			for (i=offset;i<=rn;i++)
				((double *)(mat_a->p))[i] = ((double *)(mat_b->p))[i-offset+1];
			
			break;
		default:
			break;
	}
	
   unmark_specifier(target);
   target->sp_form = ft_omega;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_a;
   push_pstack(&return1);

}

  
  
void NR_CVECT_PROD(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
struct nrmatrix *mat, *mat_a, *mat_b;
int r, c, rn, cn;
int t_a, t_b, t, st;
int i;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_cvect_prod",
				abend_opnd_str(SETL_SYSTEM argv));

	if ((argv[1].sp_form != ft_opaque)&&
		(((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",2,"nr_cvect_prod",
				abend_opnd_str(SETL_SYSTEM argv+1));

	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	mat_b = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

	t_a=mat_a->type>>16;
	t_b=mat_b->type>>16;

	if ((t_a != t_b) || (mat_a->r != mat_b->r) || (mat_a->c != mat_b->c))
		abend(SETL_SYSTEM "Matrix or vector should share same size and type");

	t = t_a;	/* get the type from one of the two matrixes */

	      
	rn=mat_a->r;
	
	mat = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	mat->type = mat_a->type;
	mat->use_count = 1;
	mat->r = rn;
	mat->c = 1;

	
	
    switch (t_a) {



		case nr_ivect:	
			
			break;

	
		case nr_fvect:
			
			break;

	

		case nr_dvect:
		{
			double *pa=((double *)(mat_a->p));
			double *pb=((double *)(mat_b->p));
			double *p=((double *)(mat->p));
			for (i=1;i<=rn;i+=2) {
				p[i]=pa[i]*pb[i]-(pa[i+1]*pb[i+1]);
				p[i+1]=pa[i+1]*pb[i]+pa[i]*pb[i+1];
			}
		}
			break;
		default:
			break;
	}
	
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;


}
  
  
void NR_CVECT_CONJ(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int t, i, j, rn, cn;
struct nrmatrix *mat, *mat_res;
int isign;
float fsign;
double dsign;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"NR_CVECT_CONJ",
				abend_opnd_str(SETL_SYSTEM argv));


	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t=mat->type>>16;
	
	mat_res = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	mat_res->use_count = 1;
	rn = mat_res->r = mat->r;
	cn = mat_res->c = 1;
	
	switch (t) {



		case nr_ivect:

			mat_res->type = nr_ivect*65536+nr_type;
			mat_res->p = (void *)ivector(1,rn);
			isign=1;
			for (i=1;i<=rn;i++) {
				((int *)(mat_res->p))[i] = isign*((int *)(mat->p))[i];
				isign*=-1;
			}
			break;

	
		case nr_fvect:
		
			mat_res->type = nr_fvect*65536+nr_type;
			mat_res->p = (void *)vector(1,rn);
			fsign=1.0;
		for (i=1;i<=rn;i++) {
				((float *)(mat_res->p))[i] = fsign*((float *)(mat->p))[i]; 
				fsign*=-1.0;
			}
			break;

	

		case nr_dvect:

			mat_res->type = nr_dvect*65536+nr_type;
			mat_res->p = (void *)dvector(1,rn);
			dsign=1.0;
			for (i=1;i<=rn;i++) {
				((double *)(mat_res->p))[i] = dsign*((double *)(mat->p))[i];
				dsign*=-1.0;
				}
			
			break;
		default:
			break;
	}

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_res;

	return;
}



void NR_MAT_SUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
struct nrmatrix *mat, *mat_a, *mat_b;
int r, c, rn, cn;
int t_a, t_b, t, st;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_sum",
				abend_opnd_str(SETL_SYSTEM argv));

	if ((argv[1].sp_form != ft_opaque)&&
		(((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",2,"nr_mat_sum",
				abend_opnd_str(SETL_SYSTEM argv));

	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	mat_b = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

	t_a=mat_a->type>>16;
	t_b=mat_b->type>>16;

	if ((t_a != t_b) || (mat_a->r != mat_b->r) || (mat_a->c != mat_b->c))
		abend(SETL_SYSTEM "Matrix or vector should share same size and type");

	t = t_a;	/* get the type from one of the two matrixes */

	mat = binop_matrix_or_vector(mat_a, mat_b, t, d_sum_op, i_sum_op);

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

	return;
}

void NR_MAT_DIFF(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
struct nrmatrix *mat, *mat_a, *mat_b;
int r, c, rn, cn;
int t_a, t_b, t, st;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_diff",
				abend_opnd_str(SETL_SYSTEM argv));

	if ((argv[1].sp_form != ft_opaque)&&
		(((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",2,"nr_mat_diff",
				abend_opnd_str(SETL_SYSTEM argv+1));

	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	mat_b = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

	t_a=mat_a->type>>16;
	t_b=mat_b->type>>16;

	if ((t_a != t_b) || (mat_a->r != mat_b->r) || (mat_a->c != mat_b->c))
		abend(SETL_SYSTEM "Matrix or vector should share same size and type");

	t = t_a;	/* get the type from one of the two matrixes */

	mat = binop_matrix_or_vector(mat_a, mat_b, t, d_diff_op, i_diff_op);

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

	return;
}

void NR_MAT_PROD(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
	struct nrmatrix *mat, *mat_a, *mat_b;
	int err;
	
	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_prod",
				abend_opnd_str(SETL_SYSTEM argv));

	if ((argv[1].sp_form != ft_opaque)&&
		(((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",2,"nr_mat_prod",
				abend_opnd_str(SETL_SYSTEM argv+1));

	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	mat_b = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

	mat = prod_matrix_or_vector(mat_a, mat_b, d_sum_op, i_sum_op, &err);
	if (err) 
		abend(SETL_SYSTEM "Matrix or vector should have same type and be compatible");
	
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

	return;
}

void NR_MATCONST_SUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
void *constant_ptr;

double dconst;
int iconst;

struct nrmatrix *mat, *mat_a;
int r, c, rn, cn;
int t_constant, t, st;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_matconst_sum",
				abend_opnd_str(SETL_SYSTEM argv));

	t_constant = argv[1].sp_form;
	if ( t_constant != ft_short   &&   t_constant != ft_real )
		abend(SETL_SYSTEM msg_bad_arg,"real or integer number",2,"nr_matconst_sum",
			abend_opnd_str(SETL_SYSTEM argv));

	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

	t=mat_a->type>>16;

	switch (t) {

		case nr_fmat:
		case nr_dmat:
		case nr_fvect:
		case nr_dvect:
		
			if (t_constant == ft_real)
				dconst = (double)argv[1].sp_val.sp_real_ptr->r_value;
			else /* ft_short */
				dconst = (double)argv[1].sp_val.sp_short_value;
				
			constant_ptr = &dconst;

			break;

		case nr_imat:
		case nr_ivect:
		case nr_ulvect:

			if (t_constant == ft_real)
				iconst = (int)argv[1].sp_val.sp_real_ptr->r_value;
			else /* ft_short */
				iconst = (int)argv[1].sp_val.sp_short_value;
				
			constant_ptr = &iconst;

			break;
	}

	mat = constant_binop_matrix_or_vector(mat_a, constant_ptr, t, d_sum_op, i_sum_op);

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

	return;
}

void NR_MATCONST_DIFF(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
void *constant_ptr;

double dconst;
int iconst;

struct nrmatrix *mat, *mat_a;
int r, c, rn, cn;
int t_constant, t, st;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_matconst_diff",
				abend_opnd_str(SETL_SYSTEM argv));

	t_constant = argv[1].sp_form;
	if ( t_constant != ft_short   &&   t_constant != ft_real )
		abend(SETL_SYSTEM msg_bad_arg,"real or integer number",2,"nr_matconst_diff",
			abend_opnd_str(SETL_SYSTEM argv));

	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

	t=mat_a->type>>16;

	switch (t) {

		case nr_fmat:
		case nr_dmat:
		case nr_fvect:
		case nr_dvect:
		
			if (t_constant == ft_real)
				dconst = (double)argv[1].sp_val.sp_real_ptr->r_value;
			else /* ft_short */
				dconst = (double)argv[1].sp_val.sp_short_value;
				
			constant_ptr = &dconst;

			break;

		case nr_imat:
		case nr_ivect:
		case nr_ulvect:

			if (t_constant == ft_real)
				iconst = (int)argv[1].sp_val.sp_real_ptr->r_value;
			else /* ft_short */
				iconst = (int)argv[1].sp_val.sp_short_value;
				
			constant_ptr = &iconst;

			break;
	}

	mat = constant_binop_matrix_or_vector(mat_a, constant_ptr, t, d_diff_op, i_diff_op);

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

	return;
}

void NR_CONST_DIFFMAT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
void *constant_ptr;

double dconst;
int iconst;

struct nrmatrix *mat, *mat_a;
int r, c, rn, cn;
int t_constant, t, st;

	t_constant = argv[0].sp_form;
	if ( t_constant != ft_short   &&   t_constant != ft_real )
		abend(SETL_SYSTEM msg_bad_arg,"real or integer number",1,"nr_const_matdiff",
			abend_opnd_str(SETL_SYSTEM argv));

	if ((argv[1].sp_form != ft_opaque)&&
		(((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",2,"nr_const_matdiff",
				abend_opnd_str(SETL_SYSTEM argv));


	mat_a = (struct nrmatrix *)(argv[1].sp_val.sp_opaque_ptr);

	t=mat_a->type>>16;

	switch (t) {

		case nr_fmat:
		case nr_dmat:
		case nr_fvect:
		case nr_dvect:
		
			if (t_constant == ft_real)
				dconst = (double)argv[0].sp_val.sp_real_ptr->r_value;
			else /* ft_short */
				dconst = (double)argv[0].sp_val.sp_short_value;
				
			constant_ptr = &dconst;

			break;

		case nr_imat:
		case nr_ivect:
		case nr_ulvect:

			if (t_constant == ft_real)
				iconst = (int)argv[0].sp_val.sp_real_ptr->r_value;
			else /* ft_short */
				iconst = (int)argv[0].sp_val.sp_short_value;
				
			constant_ptr = &iconst;

			break;
	}

	mat = constant_binop_matrix_or_vector(mat_a, constant_ptr, t, d_diff_reverse_op, i_diff_reverse_op);

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

	return;
}

void NR_MATCONST_PROD(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
void *constant_ptr;

double dconst;
int iconst;
	
struct nrmatrix *mat, *mat_a;
int r, c, rn, cn;
int t_constant, t, st;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_matconst_prod",
				abend_opnd_str(SETL_SYSTEM argv));

	t_constant = argv[1].sp_form;
	if ( t_constant != ft_short   &&   t_constant != ft_real )
		abend(SETL_SYSTEM msg_bad_arg,"real or integer number",2,"nr_matconst_prod",
			abend_opnd_str(SETL_SYSTEM argv));

	mat_a = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);

	t=mat_a->type>>16;

	switch (t) {

		case nr_fmat:
		case nr_dmat:
		case nr_fvect:
		case nr_dvect:
		
			if (t_constant == ft_real)
				dconst = (double)argv[1].sp_val.sp_real_ptr->r_value;
			else /* ft_short */
				dconst = (double)argv[1].sp_val.sp_short_value;
				
			constant_ptr = &dconst;

			break;

		case nr_imat:
		case nr_ivect:
		case nr_ulvect:

			if (t_constant == ft_real)
				iconst = (int)argv[1].sp_val.sp_real_ptr->r_value;
			else /* ft_short */
				iconst = (int)argv[1].sp_val.sp_short_value;
				
			constant_ptr = &iconst;

			break;
	}

	mat = constant_binop_matrix_or_vector(mat_a, constant_ptr, t, d_prod_op, i_prod_op);

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat;

	return;
}

void NR_MAT_CLONE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
	struct nrmatrix *mat, *mat_cloned;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_clone",
				abend_opnd_str(SETL_SYSTEM argv));


	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	mat_cloned = nr_copy(mat);
	
	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_cloned;

	return;
}

void NR_MAT_FIX(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int t, i, j, rn, cn;
struct nrmatrix *mat, *mat_res;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_fix",
				abend_opnd_str(SETL_SYSTEM argv));

	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t=mat->type>>16;
	
	if ((t==nr_imat) || (t==nr_ivect) || (t==nr_ulvect))
		abend(SETL_SYSTEM "Not integer matrix or vector expected");
	
	mat_res = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	mat_res->use_count = 1;
	mat_res->type = ( t<10 ? nr_imat : nr_ivect) * 65536 + nr_type;
	rn = mat_res->r = mat->r;
	cn = mat_res->c = mat->c;


	if ( t < 10 )	/* matrix case */
		mat_res->p = (void *)imatrix(1,rn,1,cn);
	else			/* vector case */
		mat_res->p = (void *)ivector(1,rn);		
	
	switch (t) {

		case nr_fmat:
			
			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((int **)(mat_res->p))[i][j] = ((float **)(mat->p))[i][j];
			break;
			
		case nr_dmat:
		
			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((int **)(mat_res->p))[i][j] = ((double **)(mat->p))[i][j];
			break;

		case nr_fvect:

			for (i=1;i<=rn;i++)
				((int *)(mat_res->p))[i] = ((float *)(mat->p))[i];
			break;

		case nr_dvect:
	
			for (i=1;i<=rn;i++)
				((int *)(mat_res->p))[i] = ((double *)(mat->p))[i];
			break;
	}

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_res;

	return;
}

void NR_MAT_FLOAT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int t, i, j, rn, cn;
struct nrmatrix *mat, *mat_res;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_float",
				abend_opnd_str(SETL_SYSTEM argv));

	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t=mat->type>>16;
	
	if ((t==nr_fmat) || (t==nr_fvect))
		abend(SETL_SYSTEM "Non float matrix or vector expected");
	
	mat_res = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	mat_res->use_count = 1;
	mat_res->type = ( t<10 ? nr_fmat : nr_fvect) * 65536 + nr_type;
	
	rn = mat_res->r = mat->r;
	cn = mat_res->c = mat->c;


	if ( t < 10)
		mat_res->p = (void *)matrix(1,rn,1,cn);
	else	/* vector case */
		mat_res->p = (void *)vector(1,rn);		
	
	switch (t) {

		case nr_imat:
			
			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((float **)(mat_res->p))[i][j] = ((int **)(mat->p))[i][j];
			break;
			
		case nr_dmat:
		
			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((float **)(mat_res->p))[i][j] = ((double **)(mat->p))[i][j];
			break;

		case nr_ivect:

			for (i=1;i<=rn;i++)
				((float *)(mat_res->p))[i] = ((int *)(mat->p))[i];
			break;

		case nr_dvect:
	
			for (i=1;i<=rn;i++)
				((float *)(mat_res->p))[i] = ((int *)(mat->p))[i];
			break;
	}

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_res;

	return;
}

void NR_MAT_DOUBLE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int t, i, j, rn, cn;
struct nrmatrix *mat, *mat_res;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_double",
				abend_opnd_str(SETL_SYSTEM argv));

	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t=mat->type>>16;
	
	if ((t==nr_dmat) || (t==nr_dvect))
		abend(SETL_SYSTEM "Non double matrix or vector expected");
	
	mat_res = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	mat_res->use_count = 1;
	mat_res->type = ( t<10 ? nr_dmat : nr_dvect) * 65536 + nr_type;
	rn = mat_res->r = mat->r;
	cn = mat_res->c = mat->c;

	if ( t < 10 )
		mat_res->p = (void *)dmatrix(1,rn,1,cn);
	else	/* vector case */
		mat_res->p = (void *)dvector(1,rn);		
	
	switch (t) {

		case nr_imat:
			
			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((double **)(mat_res->p))[i][j] = ((int **)(mat->p))[i][j];
			break;
			
		case nr_fmat:
		
			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((double **)(mat_res->p))[i][j] = ((float **)(mat->p))[i][j];
			break;

		case nr_ivect:

			for (i=1;i<=rn;i++)
				((double *)(mat_res->p))[i] = ((int *)(mat->p))[i];
			break;

		case nr_fvect:
	
			for (i=1;i<=rn;i++)
				((double *)(mat_res->p))[i] = ((float *)(mat->p))[i];
			break;
	}

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_res;

	return;
}

void NR_MAT_TRANSPOSE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int t, i, j, rn, cn;
struct nrmatrix *mat, *mat_res;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_mat_transpose",
				abend_opnd_str(SETL_SYSTEM argv));


	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t=mat->type>>16;
	
	mat_res = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	mat_res->use_count = 1;
	rn = mat_res->r = mat->c;
	cn = mat_res->c = mat->r;
	
	switch (t) {

		case nr_imat:
			
			mat_res->type = nr_imat*65536+nr_type;
			mat_res->p = (void *)imatrix(1,rn,1,cn);

			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((int **)(mat_res->p))[i][j] = ((int **)(mat->p))[j][i];

			break;

		case nr_ivect:

			mat_res->type = nr_imat*65536+nr_type;
			mat_res->p = (void *)imatrix(1,rn,1,cn);

			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((int **)(mat_res->p))[i][j] = ((int *)(mat->p))[j];

			break;

		case nr_fmat:

			mat_res->type = nr_fmat*65536+nr_type;
			mat_res->p = (void *)matrix(1,rn,1,cn);

			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((float **)(mat_res->p))[i][j] = ((float **)(mat->p))[j][i];

			break;

		case nr_fvect:
		
			mat_res->type = nr_fmat*65536+nr_type;
			mat_res->p = (void *)matrix(1,rn,1,cn);

			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((float **)(mat_res->p))[i][j] = ((float *)(mat->p))[j];

			break;

		case nr_dmat:
		
			mat_res->type = nr_dmat*65536+nr_type;
			mat_res->p = (void *)dmatrix(1,rn,1,cn);

			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((double **)(mat_res->p))[i][j] = ((double **)(mat->p))[j][i];

			break;

		case nr_dvect:

			mat_res->type = nr_dmat*65536+nr_type;
			mat_res->p = (void *)dmatrix(1,rn,1,cn);

			for (i=1;i<=rn;i++)
				for (j=1;j<=cn;j++)
					((double **)(mat_res->p))[i][j] = ((double *)(mat->p))[j];

			break;
	}

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_res;

	return;
}


void NR_VECT_REVERSE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int t, i, j, rn, cn;
struct nrmatrix *mat, *mat_res;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"NR_VECT_REVERSE",
				abend_opnd_str(SETL_SYSTEM argv));


	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t=mat->type>>16;
	
	mat_res = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
	mat_res->use_count = 1;
	rn = mat_res->r = mat->r;
	cn = mat_res->c = 1;
	
	switch (t) {



		case nr_ivect:

			mat_res->type = nr_ivect*65536+nr_type;
			mat_res->p = (void *)ivector(1,rn);

			for (i=1;i<=rn;i++)
				((int *)(mat_res->p))[rn-i+1] = ((int *)(mat->p))[i];
			
			break;

	
		case nr_fvect:
		
			mat_res->type = nr_fvect*65536+nr_type;
			mat_res->p = (void *)vector(1,rn);

		for (i=1;i<=rn;i++)
				((float *)(mat_res->p))[rn-i+1] = ((float *)(mat->p))[i];
			
			break;

	

		case nr_dvect:

			mat_res->type = nr_dvect*65536+nr_type;
			mat_res->p = (void *)dvector(1,rn);

			for (i=1;i<=rn;i++)
				((double *)(mat_res->p))[rn-i+1] = ((double *)(mat->p))[i];
			
			break;
		default:
			break;
	}

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_res;

	return;
}

void NR_VECT_MAX_INDEX(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int t, i, j, rn, cn;
struct nrmatrix *mat;
int imax;
int idx=1;
float fmax;
double dmax;
unsigned long ulmax;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"NR_VECT_MAX_INDEX",
				abend_opnd_str(SETL_SYSTEM argv));


	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t=mat->type>>16;
	
	
	rn = mat->r;
	cn = 1;
	
	switch (t) {



		case nr_ivect:
			imax=((int *)(mat->p))[1];
			

			for (i=1;i<=rn;i++)
				if (((int *)(mat->p))[i]>imax) {
				 imax=((int *)(mat->p))[i];
				 idx=i;
			 }
				
			break;

	
		case nr_fvect:
		
			fmax =  ((float *)(mat->p))[1];

		for (i=1;i<=rn;i++)
				if ( ((float *)(mat->p))[i]>fmax) {
					fmax =  ((float *)(mat->p))[i];
					idx=i;
				}
			
			break;

	

		case nr_dvect:

			dmax = ((double *)(mat->p))[1];
			
			for (i=1;i<=rn;i++)
				if (((double *)(mat->p))[i] > dmax ) {
				  dmax = ((double *)(mat->p))[i];
				  idx = i;
				}
			
			break;
		default:
			break;
	}

	unmark_specifier(target);
	target->sp_form = ft_short;
	target->sp_val.sp_short_value = idx;

	return;
}
void NR_ROWS_AND_COLS(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
TUPLE_CONSTRUCTOR(ca)
specifier spare;

int rn, cn;
struct nrmatrix *mat;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_rows_and_cols",
				abend_opnd_str(SETL_SYSTEM argv));

	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	rn = mat->r;
	cn = mat->c;

	TUPLE_CONSTRUCTOR_BEGIN(ca);

/*	TUPLE_ADD_BEGIN(ca);	/*GDM 052899*/

	spare.sp_form = ft_short;
	spare.sp_val.sp_short_value = rn;
	TUPLE_ADD_CELL(ca, &spare);

	spare.sp_form = ft_short;
	spare.sp_val.sp_short_value = cn;
	TUPLE_ADD_CELL(ca, &spare);

/*	TUPLE_ADD_END(ca);	/*GDM 052899*/

	TUPLE_CONSTRUCTOR_END(ca);

	unmark_specifier(target);
	target->sp_form = ft_tuple;
	target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);

	return;
}

void NR_GET_SLICE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int i, j;
int left, top;
		
int t, rn, cn, r, slice_kind;
tuple_h_ptr_type source_root;          /* root node pointer                 */
TUPLE_ITERATOR(ia)
int size[4];	/* this size array could be either two or four elements */
struct nrmatrix *mat, *mat_res;

	if ((argv[0].sp_form != ft_opaque)&&
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=nr_type))
			abend(SETL_SYSTEM msg_bad_arg,"matrix",1,"nr_get_slice",
				abend_opnd_str(SETL_SYSTEM argv));

	if (argv[1].sp_form != ft_tuple) 
		abend(SETL_SYSTEM msg_bad_arg,"tuple",2,"nr_get_slice",
			abend_opnd_str(SETL_SYSTEM argv));

	source_root = argv[1].sp_val.sp_tuple_ptr;
	mat = (struct nrmatrix *)(argv[0].sp_val.sp_opaque_ptr);
	t = mat->type >> 16;
	
	slice_kind = get_tuple_count(SETL_SYSTEM source_root,ft_short);
	if (!(slice_kind==2 || slice_kind==4))
		abend(SETL_SYSTEM "size tuple must have 2 or 4 elements","size",2,
			"nr_get_slice", abend_opnd_str(SETL_SYSTEM argv));

	r=0;
	ITERATE_TUPLE_BEGIN(ia,argv[1])
	{
		if (ia_element->sp_form==ft_short) {
			size[r]=ia_element->sp_val.sp_short_value;
		} else 
			abend(SETL_SYSTEM "size tuple must be integer","size",2,
				"nr_get_slice", abend_opnd_str(SETL_SYSTEM argv));
		r++;
	}
	ITERATE_TUPLE_END(ia)

	if (slice_kind == 2) {

		mat_res = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
		mat_res->use_count = 1;
		mat_res->type = t*65536+nr_type;

		top = size[0] - 1;

		if (t<10) {	/* matrix */
			rn = mat_res->r = mat->r;
			cn = mat_res->c = size[1] - size[0] + 1;
		} else { /* vector */
			rn = mat_res->r = size[1] - size[0] + 1;
			cn = mat_res->c = 1;
		}

		switch (t) {

			case nr_fmat:

				mat_res->p = (void *)matrix(1,rn,1,cn);
				for (i=1;i<=rn;i++)
					for (j=1;j<=cn;j++)
						((float **)(mat_res->p))[i][j] = ((float **)(mat->p))[i][j+top];
								
				break;

			case nr_dmat:

				mat_res->p = (void *)dmatrix(1,rn,1,cn);
				for (i=1;i<=rn;i++)
					for (j=1;j<=cn;j++)
						((double **)(mat_res->p))[i][j] = ((double **)(mat->p))[i][j+top];

				break;

			case nr_imat:

				mat_res->p = (void *)imatrix(1,rn,1,cn);
				for (i=1;i<=rn;i++)
					for (j=1;j<=cn;j++)
						((int **)(mat_res->p))[i][j] = ((int **)(mat->p))[i][j+top];

				break;


			case nr_fvect:

				mat_res->p = (void *)vector(1,rn);
				for (i=1;i<=rn;i++)
					((float *)(mat_res->p))[i] = ((float *)(mat->p))[i+top];

				break;

			case nr_dvect:

				mat_res->p = (void *)dvector(1,rn);
				for (i=1;i<=rn;i++)
					((double *)(mat_res->p))[i] = ((double *)(mat->p))[i+top];

				break;

			case nr_ivect:

				mat_res->p = (void *)ivector(1,rn);
				for (i=1;i<=rn;i++)
					((int *)(mat_res->p))[i] = ((int *)(mat->p))[i+top];

				break;
		}
		
	} else {	/* slice_kind == 4 */

		if (t>10) /*vector */
			abend(SETL_SYSTEM "cannot make a rectangular slice for a vector","size",2,
				"nr_get_slice", abend_opnd_str(SETL_SYSTEM argv));
		
		left = size[0] - 1;
		top = size[1] - 1;
		
		mat_res = (struct nrmatrix *)(malloc(sizeof(struct nrmatrix)));
		mat_res->use_count = 1;
		mat_res->type = t*65536+nr_type;
		rn = mat_res->r = size[3] - size[1] +1;
		cn = mat_res->c = size[2] - size[0] +1;
		
		switch (t) {
		
			case nr_fmat:
			
				mat_res->p = (void *)matrix(1,rn,1,cn);

				for (i=1;i<=rn;i++)
					for (j=1;j<=cn;j++)
						((float **)(mat_res->p))[i][j] = ((float **)(mat->p))[i+top][j+left];

				break;
			case nr_dmat:

				mat_res->p = (void *)dmatrix(1,rn,1,cn);

				for (i=1;i<=rn;i++)
					for (j=1;j<=cn;j++)
						((double **)(mat_res->p))[i][j] = ((double **)(mat->p))[i+top][j+left];

				break;
			case nr_imat:

				mat_res->p = (void *)imatrix(1,rn,1,cn);

				for (i=1;i<=rn;i++)
					for (j=1;j<=cn;j++)
						((int **)(mat_res->p))[i][j] = ((int **)(mat->p))[i+top][j+left];

				break;
		}		
	}

	unmark_specifier(target);
	target->sp_form = ft_opaque;
	target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)mat_res;

	return;
}

extern int kmax, kount;
extern float *xp, **yp, dxsav;
extern void (*_jacobn)(float x, float y[], float dfdx[], float **dfdy, int n);

extern void (*_load)(float x, float y[], float dydx[]);
extern void (*_score)(float x, float y[], float dydx[]);
extern void (*_derivs)(float x, float y[], float dydx[]);

extern void (*_load1)(float x, float y[], float dydx[]);
extern void (*_load2)(float x, float y[], float dydx[]);

extern int nn2,nvar;
extern float x1,x2,xf;

void setshoot(
	void (*__load)(float, float [], float []),
	void (*__score)(float, float [], float []),
	void (*__derivs)(float, float [], float [])
	)
{

	_load=__load;
	_score=__score;
	_derivs=__derivs;

}


void setshootf(
	void (*__load1)(float, float [], float []),
	void (*__load2)(float, float [], float []),
	void (*__score)(float, float [], float []),
	void (*__derivs)(float, float [], float []),
	int _nn2,int _nvar,float _x1,float _x2,float _xf
	)
{

	_load1=__load1;
	_load2=__load2;
	
	_score=__score;
	_derivs=__derivs;
	
	nn2=_nn2; nvar=_nvar; x1=_x1; x2=_x2; xf=_xf;

}

void ode_solve(float ystart[], int nvar, float x1, float x2,
	float eps, float h1, float hmin, int *nok, int *nbad,
	void (*_derivs)(float, float [], float []), 
	int _kmax, int *_kount, float _dxsav, float *_xp, float **_yp)
{
	kmax	= _kmax;
	kount	= *_kount;
	xp		= _xp;
	yp		= _yp;
	dxsav	= _dxsav;

	odeint(ystart, nvar, x1, x2, eps, h1, hmin, nok, nbad, _derivs, rkqs);
	
	*_kount = kount;
}

void ode_solve_bs(float ystart[], int nvar, float x1, float x2,
	float eps, float h1, float hmin, int *nok, int *nbad,
	void (*_derivs)(float, float [], float []), 
	int _kmax, int *_kount, float _dxsav, float *_xp, float **_yp)
{
	kmax	= _kmax;
	kount	= *_kount;
	xp		= _xp;
	yp		= _yp;
	dxsav	= _dxsav;

	odeint(ystart, nvar, x1, x2, eps, h1, hmin, nok, nbad, _derivs, bsstep);
	
	*_kount = kount;
}

void ode_solve_stiff(float ystart[], int nvar, float x1, float x2,
	float eps, float h1, float hmin, int *nok, int *nbad,
	void (*_derivs)(float, float [], float []), 
	int _kmax, int *_kount, float _dxsav, float *_xp, float **_yp,
	void (*__jacobn)(float x, float y[], float dfdx[], float **dfdy, int n)
	)
{
	kmax	= _kmax;
	kount	= *_kount;
	xp		= _xp;
	yp		= _yp;
	dxsav	= _dxsav;
 	_jacobn=__jacobn;
 	
	odeint(ystart, nvar, x1, x2, eps, h1, hmin, nok, nbad, _derivs, stifbs);
	
	*_kount = kount;
}

void ode_solve_stiff_bs(float ystart[], int nvar, float x1, float x2,
	float eps, float h1, float hmin, int *nok, int *nbad,
	void (*_derivs)(float, float [], float []), 
	int _kmax, int *_kount, float _dxsav, float *_xp, float **_yp,
	void (*__jacobn)(float x, float y[], float dfdx[], float **dfdy, int n)
	)
{
	kmax	= _kmax;
	kount	= *_kount;
	xp		= _xp;
	yp		= _yp;
	dxsav	= _dxsav;
	_jacobn=__jacobn;
	
	odeint(ystart, nvar, x1, x2, eps, h1, hmin, nok, nbad, _derivs, stifbs);
	
	*_kount = kount;
}



void rkdumb2(float vstart[], int nvar, float x1, float x2, int nstep,
	void (*derivs)(float, float [], float []),float **y,float *xx)
{
	void rk4(float y[], float dydx[], int n, float x, float h, float yout[],
		void (*derivs)(float, float [], float []));
	int i,k;
	float x,h;
	float *v,*vout,*dv;

	v=vector(1,nvar);
	vout=vector(1,nvar);
	dv=vector(1,nvar);
	for (i=1;i<=nvar;i++) {
		v[i]=vstart[i];
		y[i][1]=v[i];
	}
	xx[1]=x1;
	x=x1;
	h=(x2-x1)/nstep;
	for (k=1;k<=nstep;k++) {
		(*derivs)(x,v,dv);
		rk4(v,dv,nvar,x,h,vout,derivs);
		if ((float)(x+h) == x) nrerror("Step size too small in routine rkdumb2");
		x += h;
		xx[k+1]=x;
		for (i=1;i<=nvar;i++) {
			v[i]=vout[i];
			y[i][k+1]=v[i];
		}
	}
	free_vector(dv,1,nvar);
	free_vector(vout,1,nvar);
	free_vector(v,1,nvar);
}

#define MAXIT 100

float nrtsafe(void (*funcd)(float, float[]), float x1, float x2,
	float xacc)
{
	void nrerror(char error_text[]);
	int j;
	float df,dx,dxold,f,fh,fl;
	float temp,xh,xl,rts;

	float f_array[3];

/*	(*funcd)(x1,&fl,&df);
	(*funcd)(x2,&fh,&df); GDM */

	(*funcd)(x1,f_array);
	fl = f_array[1];
	
	(*funcd)(x2,f_array); 
	fh = f_array[1];
	df = f_array[2];
	
	if ((fl > 0.0 && fh > 0.0) || (fl < 0.0 && fh < 0.0))
		nrerror("Root must be bracketed in rtsafe");
	if (fl == 0.0) return x1;
	if (fh == 0.0) return x2;
	if (fl < 0.0) {
		xl=x1;
		xh=x2;
	} else {
		xh=x1;
		xl=x2;
	}
	rts=0.5*(x1+x2);
	dxold=fabs(x2-x1);
	dx=dxold;
/*	(*funcd)(rts,&f,&df); GDM */

	(*funcd)(rts,f_array);
	f = f_array[1];
	df = f_array[2];

	for (j=1;j<=MAXIT;j++) {
		if ((((rts-xh)*df-f)*((rts-xl)*df-f) >= 0.0)
			|| (fabs(2.0*f) > fabs(dxold*df))) {
			dxold=dx;
			dx=0.5*(xh-xl);
			rts=xl+dx;
			if (xl == rts) return rts;
		} else {
			dxold=dx;
			dx=f/df;
			temp=rts;
			rts -= dx;
			if (temp == rts) return rts;
		}
		if (fabs(dx) < xacc) return rts;
/*		(*funcd)(rts,&f,&df); GDM */

		(*funcd)(rts,f_array);
		f = f_array[1];
		df = f_array[2];

		if (f < 0.0)
			xl=rts;
		else
			xh=rts;
	}
	nrerror("Maximum number of iterations exceeded in rtsafe");
	return 0.0;
}
#undef MAXIT

#define JMAX 20

float nrtnewt(void (*funcd)(float, float[]), float x1, float x2,
	float xacc)
{
	void nrerror(char error_text[]);
	int j;
	float df,dx,f,rtn;
	float f_array[3];
	
	rtn=0.5*(x1+x2);
	for (j=1;j<=JMAX;j++) {

/*		(*funcd)(rtn,&f,&df); GDM */
		(*funcd)(rtn,f_array); 
		f = f_array[1];
		df = f_array[2];
		
		dx=f/df;
		rtn -= dx;
		if ((x1-rtn)*(rtn-x2) < 0.0)
			nrerror("Jumped out of brackets in rtnewt");
		if (fabs(dx) < xacc) return rtn;
	}
	nrerror("Maximum number of iterations exceeded in rtnewt");
	return 0.0;
}
#undef JMAX

void nrks2d1s(float x1[], float y1[], unsigned long n1,
	void (*quadvl)(float, float, float[]),
	float *d1, float *prob)
{
	void pearsn(float x[], float y[], unsigned long n, float *r, float *prob,
		float *z);
	float probks(float alam);
	void quadct(float x, float y, float xx[], float yy[], unsigned long nn,
		float *fa, float *fb, float *fc, float *fd);
	unsigned long j;
	float dum,dumm,fa,fb,fc,fd,ga,gb,gc,gd,r1,rr,sqen;
	float f_array[5];
	
	*d1=0.0;
	for (j=1;j<=n1;j++) {
		quadct(x1[j],y1[j],x1,y1,n1,&fa,&fb,&fc,&fd);
/*		(*quadvl)(x1[j],y1[j],&ga,&gb,&gc,&gd); GDM */
		(*quadvl)(x1[j],y1[j],f_array);
		
		ga = f_array[1];
		gb = f_array[2];
		gc = f_array[3];
		gd = f_array[4];
		
		*d1=FMAX(*d1,fabs(fa-ga));
		*d1=FMAX(*d1,fabs(fb-gb));
		*d1=FMAX(*d1,fabs(fc-gc));
		*d1=FMAX(*d1,fabs(fd-gd));
	}
	pearsn(x1,y1,n1,&r1,&dum,&dumm);
	sqen=sqrt((double)n1);
	rr=sqrt(1.0-r1*r1);
	*prob=probks(*d1*sqen/(1.0+rr*(0.25-0.75/sqen)));
}

#define EPS 1.0e-14

void nrlinbcg(unsigned long n, double b[], double x[], int itol, double tol,
	int itmax, int *iter, double *err, 
	void (*asolve)(unsigned long n, double b[], double x[], int itrnsp),
	double (*atimes)(unsigned long n, double x[], double r[], int itrnsp))
{
	double snrm(unsigned long n, double sx[], int itol);
	unsigned long j;
	double ak,akden,bk,bkden,bknum,bnrm,dxnrm,xnrm,zm1nrm,znrm;
	double *p,*pp,*r,*rr,*z,*zz;

	p=dvector(1,n);
	pp=dvector(1,n);
	r=dvector(1,n);
	rr=dvector(1,n);
	z=dvector(1,n);
	zz=dvector(1,n);

	*iter=0;
	atimes(n,x,r,0);
	for (j=1;j<=n;j++) {
		r[j]=b[j]-r[j];
		rr[j]=r[j];
	}
	znrm=1.0;
	if (itol == 1) bnrm=snrm(n,b,itol);
	else if (itol == 2) {
		asolve(n,b,z,0);
		bnrm=snrm(n,z,itol);
	}
	else if (itol == 3 || itol == 4) {
		asolve(n,b,z,0);
		bnrm=snrm(n,z,itol);
		asolve(n,r,z,0);
		znrm=snrm(n,z,itol);
	} else nrerror("illegal itol in linbcg");
	asolve(n,r,z,0);
	while (*iter <= itmax) {
		++(*iter);
		zm1nrm=znrm;
		asolve(n,rr,zz,1);
		for (bknum=0.0,j=1;j<=n;j++) bknum += z[j]*rr[j];
		if (*iter == 1) {
			for (j=1;j<=n;j++) {
				p[j]=z[j];
				pp[j]=zz[j];
			}
		}
		else {
			bk=bknum/bkden;
			for (j=1;j<=n;j++) {
				p[j]=bk*p[j]+z[j];
				pp[j]=bk*pp[j]+zz[j];
			}
		}
		bkden=bknum;
		atimes(n,p,z,0);
		for (akden=0.0,j=1;j<=n;j++) akden += z[j]*pp[j];
		ak=bknum/akden;
		atimes(n,pp,zz,1);
		for (j=1;j<=n;j++) {
			x[j] += ak*p[j];
			r[j] -= ak*z[j];
			rr[j] -= ak*zz[j];
		}
		asolve(n,r,z,0);
		if (itol == 1 || itol == 2) {
			znrm=1.0;
			*err=snrm(n,r,itol)/bnrm;
		} else if (itol == 3 || itol == 4) {
			znrm=snrm(n,z,itol);
			if (fabs(zm1nrm-znrm) > EPS*znrm) {
				dxnrm=fabs(ak)*snrm(n,p,itol);
				*err=znrm/fabs(zm1nrm-znrm)*dxnrm;
			} else {
				*err=znrm/bnrm;
				continue;
			}
			xnrm=snrm(n,x,itol);
			if (*err <= 0.5*xnrm) *err /= xnrm;
			else {
				*err=znrm/bnrm;
				continue;
			}
		}
		plugin_printf("iter=%4d err=%12.6f\n",*iter,*err);
	if (*err <= tol) break;
	}

	free_dvector(p,1,n);
	free_dvector(pp,1,n);
	free_dvector(r,1,n);
	free_dvector(rr,1,n);
	free_dvector(z,1,n);
	free_dvector(zz,1,n);
}
#undef EPS

#define MAXBIT 30
#define MAXDIM 6

static unsigned long tmp_mdeg[MAXDIM+1]={0,1,2,3,3,4,4};
static unsigned long tmp_ip[MAXDIM+1]={0,0,1,1,2,1,4};
static unsigned long tmp_iv[MAXDIM*MAXBIT+1]={
	0,1,1,1,1,1,1,3,1,3,3,1,1,5,7,7,3,3,5,15,11,5,15,13,9};

void nrsobseq(int *n, float x[])
{
	int j,k,l;
	unsigned long i,im,ipp;
	static float fac;
	static unsigned long in,ix[MAXDIM+1],*iu[MAXBIT+1];
	
	static unsigned long mdeg[MAXDIM+1];
	static unsigned long ip[MAXDIM+1];
	static unsigned long iv[MAXDIM*MAXBIT+1];

	if (*n < 0) {
	
			/* re-initialize every time we start */
		j=k=l=0;
		i=im=ipp=0;
		fac=0.0f;
		in=0;
		
		memset(ix, 0, sizeof(unsigned long) * (MAXDIM+1));
		memset(iu, 0, sizeof(unsigned long *) * (MAXBIT+1));

		memcpy(mdeg, tmp_mdeg, sizeof(unsigned long) * (MAXDIM+1));
		memcpy(ip, tmp_ip, sizeof(unsigned long) * (MAXDIM+1));
		memcpy(iv, tmp_iv, sizeof(unsigned long) * (MAXDIM*MAXBIT+1));
	
		for (j=1,k=0;j<=MAXBIT;j++,k+=MAXDIM) iu[j] = &iv[k];
		for (k=1;k<=MAXDIM;k++) {
			for (j=1;j<=mdeg[k];j++) iu[j][k] <<= (MAXBIT-j);
			for (j=mdeg[k]+1;j<=MAXBIT;j++) {
				ipp=ip[k];
				i=iu[j-mdeg[k]][k];
				i ^= (i >> mdeg[k]);
				for (l=mdeg[k]-1;l>=1;l--) {
					if (ipp & 1) i ^= iu[j-l][k];
					ipp >>= 1;
				}
				iu[j][k]=i;
			}
		}
		fac=1.0/(1L << MAXBIT);
		in=0;
	} else {
		im=in;
		for (j=1;j<=MAXBIT;j++) {
			if (!(im & 1)) break;
			im >>= 1;
		}
		if (j > MAXBIT) nrerror("MAXBIT too small in sobseq");
		im=(j-1)*MAXDIM;
		for (k=1;k<=IMIN(*n,MAXDIM);k++) {
			ix[k] ^= iv[im+k];
			x[k]=ix[k]*fac;
		}
		in++;
	}
}
#undef MAXBIT
#undef MAXDIM

#define FREERETURN {free_matrix(fjac,1,n,1,n);free_vector(fvec,1,n);\
	free_vector(p,1,n);free_ivector(indx,1,n);return;}

void nrmnewt(int ntrial, float x[], int n, float tolx, float tolf, void (*usrfun)(float *x, int n, float *fvec, float **fjac))
{
	void lubksb(float **a, int n, int *indx, float b[]);
	void ludcmp(float **a, int n, int *indx, float *d);
	int k,i,*indx;
	float errx,errf,d,*fvec,**fjac,*p;

	indx=ivector(1,n);
	p=vector(1,n);
	fvec=vector(1,n);
	fjac=matrix(1,n,1,n);
	for (k=1;k<=ntrial;k++) {
		usrfun(x,n,fvec,fjac);
		errf=0.0;
		for (i=1;i<=n;i++) errf += fabs(fvec[i]);
		if (errf <= tolf) FREERETURN
		for (i=1;i<=n;i++) p[i] = -fvec[i];
		ludcmp(fjac,n,indx,&d);
		lubksb(fjac,n,indx,p);
		errx=0.0;
		for (i=1;i<=n;i++) {
			errx += fabs(p[i]);
			x[i] += p[i];
		}
		if (errx <= tolx) FREERETURN
	}
	FREERETURN
}
#undef FREERETURN

void nrmrqmin(float x[], float y[], float sig[], int ndata, float a[], int ia[],
	int ma, float **covar, float **alpha, float *chisq,
	void (*funcs)(float, float [], float[], float [], int), float *alamda)
{
	void covsrt(float **covar, int ma, int ia[], int mfit);
	void gaussj(float **a, int n, float **b, int m);
	void nrmrqcof(float x[], float y[], float sig[], int ndata, float a[],
		int ia[], int ma, float **alpha, float beta[], float *chisq,
		void (*funcs)(float, float [], float [], float [], int));
	int j,k,l,m;
	static int mfit;
	static float ochisq,*atry,*beta,*da,**oneda;

	if (*alamda < 0.0) {
		atry=vector(1,ma);
		beta=vector(1,ma);
		da=vector(1,ma);
		for (mfit=0,j=1;j<=ma;j++)
			if (ia[j]) mfit++;
		oneda=matrix(1,mfit,1,1);
		*alamda=0.001;
		nrmrqcof(x,y,sig,ndata,a,ia,ma,alpha,beta,chisq,funcs);
		ochisq=(*chisq);
		for (j=1;j<=ma;j++) atry[j]=a[j];
	}
	for (j=0,l=1;l<=ma;l++) {
		if (ia[l]) {
			for (j++,k=0,m=1;m<=ma;m++) {
				if (ia[m]) {
					k++;
					covar[j][k]=alpha[j][k];
				}
			}
			covar[j][j]=alpha[j][j]*(1.0+(*alamda));
			oneda[j][1]=beta[j];
		}
	}
	gaussj(covar,mfit,oneda,1);
	for (j=1;j<=mfit;j++) da[j]=oneda[j][1];
	if (*alamda == 0.0) {
		covsrt(covar,ma,ia,mfit);
		free_matrix(oneda,1,mfit,1,1);
		free_vector(da,1,ma);
		free_vector(beta,1,ma);
		free_vector(atry,1,ma);
		return;
	}
	for (j=0,l=1;l<=ma;l++)
		if (ia[l]) atry[l]=a[l]+da[++j];
	mrqcof(x,y,sig,ndata,atry,ia,ma,covar,da,chisq,funcs);
	if (*chisq < ochisq) {
		*alamda *= 0.1;
		ochisq=(*chisq);
		for (j=0,l=1;l<=ma;l++) {
			if (ia[l]) {
				for (j++,k=0,m=1;m<=ma;m++) {
					if (ia[m]) {
						k++;
						alpha[j][k]=covar[j][k];
					}
				}
				beta[j]=da[j];
				a[l]=atry[l];
			}
		}
	} else {
		*alamda *= 10.0;
		*chisq=ochisq;
	}
}

void nrmrqcof(float x[], float y[], float sig[], int ndata, float a[], int ia[],
	int ma, float **alpha, float beta[], float *chisq,
	void (*funcs)(float, float [], float [], float [], int))
{
	int i,j,k,l,m,mfit=0;
	float ymod,wt,sig2i,dy,*dyda;
	float f_array[2];
	
	dyda=vector(1,ma);
	for (j=1;j<=ma;j++)
		if (ia[j]) mfit++;
	for (j=1;j<=mfit;j++) {
		for (k=1;k<=j;k++) alpha[j][k]=0.0;
		beta[j]=0.0;
	}
	*chisq=0.0;
	for (i=1;i<=ndata;i++) {
		(*funcs)(x[i],a,f_array,dyda,ma);
		ymod = f_array[1];
		
		sig2i=1.0/(sig[i]*sig[i]);
		dy=y[i]-ymod;
		for (j=0,l=1;l<=ma;l++) {
			if (ia[l]) {
				wt=dyda[l]*sig2i;
				for (j++,k=0,m=1;m<=l;m++)
					if (ia[m]) alpha[j][++k] += wt*dyda[m];
				beta[j] += dy*wt;
			}
		}
		*chisq += dy*dy*sig2i;
	}
	for (j=2;j<=mfit;j++)
		for (k=1;k<j;k++) alpha[k][j]=alpha[j][k];
	free_vector(dyda,1,ma);
}

#include "libnr.c"
