static short cond;
static int counter = 1;	/* sued for debug remove when finished */

/*
 *
 * Package: Poly Zeros
 * File: poly_zeroes.c
 *
 * (c) 1999 Jack Schwartz
 * part of translation from the Setl Language by G. Di Mauro
 *
 * Portions of code from the book: "Numerical Recipes in C"
 *
 */

	/*
	 * header files
	 */

#include "poly_zeroes.h"
#include "nrutil.h"
#include "lpkit.h"

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#ifdef MEM_LEAK_CHECK
static char *file_name = "poly_zeroes.c";
#include "debug_mem.h"
#endif

	/*
	 * preprocessor definition
	 */

#ifdef PACKAGE_VERSION
#	define printf	plugin_printf
#else
#endif

	/*
	 * global variables
	 */

double	**root_list;
int		n_root_list;
int		refused_boxes;
int		refused_enough;
int		roots_found;
int		splits;
int		wasted_splits;
double	small_enough;
double	small_enough2;
int		refused_enough;
int		max_roots;
int		split_enough;
double	smallish;


	/* used to calculate the simplex*/
#define OLD_SIMPLEX
#ifdef OLD_SIMPLEX
int num_res_m1;
int *irowv, *iposv;
double **simplex_matrix;	/* this is a pointer to a numerical recipes array */
//#else 
lprec *lp;
REAL *lp_vect;
REAL *off_vect;
#endif

	/*
	 * implementation
	 */
	 
/*
 * find_root_list:
 */

double **find_root_list(double *Q_coefficients, int nQ, double *a, double *b, int *degrees, int dim, int *root_list_size)
{
	int max_no_roots;
	int i;
	short err;

	*root_list_size = 0;
	
		/* the p's are the polynomial coefficients, accessed as a tensor  p(i1)(i2)..(i_d)(j) */
	roots_found = 0;
	refused_boxes = 0;

counter = 0;

	for (i=0, max_no_roots=1; i<dim; i++)
		max_no_roots *= degrees[i];

	poly_zeroes_initialize(1.0e-14, 1.0e-7, 50, max_no_roots, 100);  

		/* allocate the root list */
	root_list = (double **)calloc(sizeof(double *), max_no_roots);
	if (!root_list)
		return NULL;

		/* allocate structures for the simplex method */
		
#ifdef OLD_SIMPLEX
	num_res_m1 = nQ / dim;
		
	simplex_matrix = dmatrix(1, (num_res_m1+3), 1, (2*dim+2));
	if (!simplex_matrix) {
		free(root_list);
		return NULL;
	}
	
	irowv = ivector(1, 2*dim+1);
	if (!irowv) {
		free(root_list);
		free_dmatrix(simplex_matrix, 1, (num_res_m1+3), 1, (2 * dim+2));
		return NULL;
	}

	iposv = ivector(1, num_res_m1+1);
	if (!iposv) {
		free(root_list);
		free_dmatrix(simplex_matrix, 1, (num_res_m1+3), 1, (2 * dim+2));
		free_ivector(irowv, 1, 2*dim+1);
		return NULL;
	}		
//#else
	lp_vect = malloc((dim + 1) * sizeof(REAL));
	if (!lp_vect) {
		free(root_list);
		return NULL;
	}
	off_vect = lp_vect - 1;

	lp = make_lp(0, dim + 1);
	if (!lp) {
		free(root_list);
		free(lp_vect);
		return NULL;
	}
	
	for (i=1;i<=dim + 1;i++) {
		set_upbo(lp, i, +1);
		set_lowbo(lp, i, -1);
	}
	
#endif
				/* call the general n-dimensional bisection procedure, starting with the first axis */
	err = find_root_list_Q(Q_coefficients, nQ, a, b, dim, 0, degrees, dim);
	if (err) {
		free(root_list);
#ifdef OLD_SIMPLEX
		free_dmatrix(simplex_matrix, 1, (num_res_m1+3), 1, (2 * dim+2));
		free_ivector(irowv, 1, 2*dim+1);
		free_ivector(iposv, 1, num_res_m1+1);
//#else
		free(lp_vect);
		delete_lp(lp);
#endif

#ifdef VERBOSE
		if (err == 1) 
			printf("[POLY ZEROES] Out of memory\n");
		else
			printf("[POLY ZEROES] Fatal error: too many roots\n");
#endif

		return NULL;
	}

#ifdef VERBOSE
	printf("[POLY ZEROES] unpruned rootlist count %d\n", n_root_list); 
#endif

	realloc(root_list, n_root_list * sizeof(double *));	/* shrink to the actual number of roots */
	if (!n_root_list) 
		root_list = NULL;

#ifdef OLD_SIMPLEX
		/* destroy simplex memory structures */
	free_dmatrix(simplex_matrix, 1, (num_res_m1+3), 1, (2 * dim+2));
	free_ivector(irowv, 1, 2*dim+1);
	free_ivector(iposv, 1, num_res_m1+1);
//#else
	free(lp_vect);
	delete_lp(lp);
#endif
	*root_list_size = n_root_list;

/*	printf("\nLast counter = %d\n", counter);*/

	return root_list;
}

/*
 * poly_zeroes_initialize:
 */

void poly_zeroes_initialize(double the_small_enough, double the_small_enough2, int the_refused_enough, int the_max_roots, int the_split_enough)
{
		/*
		 * reset global variables for re-use
		 */
	root_list		= NULL;
	n_root_list		= 0;
	refused_boxes	= 0;
	refused_enough	= 0;
	roots_found		= 0;
	splits			= 0;
	wasted_splits	= 0;

		/*
		 *	set to the new values
		 */

	small_enough	= the_small_enough;
	small_enough2	= the_small_enough2;
	refused_enough	= the_refused_enough;
	max_roots		= the_max_roots;
	split_enough	= the_split_enough;
	smallish		= small_enough * 10000.0;
}

/*
 * hull_excludes_0:
 */

short hull_excludes_0(double *vect, int vec_len, int dim)
{
	if (0 && dim == 2) {

		/*
		 * tests a list of vectors  to determine whether their convex hull excludes the origin
		 * two-dimensional case; we find the smallest angle around the origin containing all the points, and ask
		 * whether this is larger than 180 degrees. If so, the range from angle from the smallest to the largest
		 * angle could be traversed in the clockwise direction (which would make angles in the lower half plane negative)
		 * or in the counterclockwise direction  (which would make angles in the lower half plane positive, and larger than pi)
		 *
		 * in this code, we simply assume the 2D case.
		 */
		
		double max_clock;
		double max_counter;
		double min_clock;
		double min_counter;
		double max_dist;
		int j;
		double x, y;
		double ax, ay;
		double ma;
		double samp_x, samp_y;
		double ang, orig_ang;
		double counter_ang;
		short res;
				
		max_clock = max_counter = -4.0;		/* maximum and minimum possible angles in the clockwise */
		min_clock = min_counter = 4.0;		/* and counterclockwise directions */
		samp_x = vect[0];
		samp_y = vect[1];
		max_dist = fabs(vect[0]) + fabs(vect[1]);		/* keep track of maximum manhattan distance */

		for (j=0; j<vec_len; j+=2) {
		
			ax = fabs(x = vect[j]);
			ay = fabs(y = vect[j+1]);
			
			if ((ax<small_enough) && (ay<small_enough)) 
				return 0;

			if ((ma=ax+ay) > max_dist) {
				samp_x = x;
				samp_y = y;
				max_dist = ma;
			}
			
			ang = orig_ang = atan2(y,x); /* atan2(y,x) gives that atan of y/x which lies in the range -pi/2 to pi/2 */

			counter_ang = (y < 0.0) ? (ang + 2*pi) : ang ;

			max_clock = max(max_clock, ang);
			max_counter = max(max_counter, counter_ang);
			min_clock = min(min_clock, ang);
			min_counter = min(min_counter, counter_ang);
		}

		res = ((max_clock-min_clock) < (pi-small_angle)) || ((max_counter-min_counter) < (pi-small_angle));
		if (res)
			return res;
			
		res = 1;
		for (j=0; j<vec_len; j+=2) {
			x = vect[j];
			y = vect[j+1];

			if ( (fabs(x-samp_x) + fabs(y-samp_y)) <= small_enough) {
				res = 0;
				break;
			}
		}
		
		return res;

	} else {    /* otherwise more than 2 dimensions */
	
		short ret_1, ret_2;		

		int i, j, jj;
		int res_case;

		double max_of_vect;		
			/* get the maximum to normalize later */
		max_of_vect = fabs(vect[0]);
		for (i=1;i<vec_len;i++) 
			max_of_vect = max(max_of_vect, fabs(vect[i]));
		if (max_of_vect <= smallish)	/* don't reject if all coefficients are really small */
			return 0;
		if (max_of_vect > 1.0)
			max_of_vect = 1.0;

#ifdef OLD_SIMPLEX	
		/*
		 * The inputs to the general 'simplx' routine are:
		 *
		 * simplx(a[2 + num_restrictions][1 + num_vars],num_restrictions,num_vars,
		 *	num_res_ge_0,num_res_le_0,num_res_eq_0, &result_case, irowv[num_restrictions],iposv[num_vars])
		 *
		 * where the a-matrix is set up as follows:
		 *
		 * first row:		coefficients of form to be maximised, constant first
		 * next rows:		coefficients of form restricted >= 0, constant first (num_res_le_0 of these)
		 * 					coefficients of form restricted <= 0, constant first (num_res_ge_0 of these)
		 * 					coefficients of form restricted = 0, constant first  (num_res_eq_0 of these)
		 *						(in these rows all the constant terms should be non-negative)
		 * last_row:		required spare, containing negative of sum of all but the first row
		 *						(this must be provided but need not be filled in)
		 *
		 * The output variable 'result_case' is 0 if a finite solution is found, +1 if the retrictions
		 * do not bound the form to be maximized, -1 if there exists no solution of the given constraints.
		 *
		 * To apply this to determine if the convex hull of a set of vectors v includes the origin, we 
		 * impose the restrictions x  v - b >= 0 (all v on one side of this plane) for all v, sigma(x) = 1,
		 * and maximize b. If b is positive (enough) then the origin is not in the hull and the set of   
		 * vectors can be rejected. If b is negative or small, then the origin is close to or in the hull,
		 * and the set of vectors should not be rejected.
		 *
		 * Application begins with a vector c in which the vectors v are represented by k sucessive sections
		 * (of length nvars = dim). To convert this to the required a, we first dimension an auxiliary aa as a
		 * single vector of length (k + 3) * (2 * nvars + 2), consisting of k + 2 sections, each of length 
		 * 2 * nvars + 2. The first section is initialized to 0,..,0,1 (representing the variable b). 
		 * The following k rows are initialized to 0,v1,v2,..,vn,-v1,-v2,...,-vn,-1. One more row is initialized to 
		 * 1,-1,...,-1,0 (representing sigma(x) = 1). Then we set up an auxiliary vector a of length k + 2,  
		 * whose components point to the sucessive sections (length nvars + 2) of aa. The call to the simplx 
		 * routine is then 
		 *
		 * 				simplx(a,k + 1,nvars + 1,k,0,1,&result_case, irowv[k+1],iposv[nvars + 2])
		 *
		 * On return from this call we get the maximum value of b from the a[1][1] of the aoutput a
		 * and test it to see if max_b >= small_quantity. If so, the convex hull is far from the origin
		 * and the cube generating can be rejected. Othewise it cannot.
		 *
		 * Note that each of our variable x is represented in the simplex call by two variables x',x" with x = x'-x"
		 * since the simplex alogirthm assumes that each of the variables whith which it works is non negative.
		 *
		 * The dimension of irowv in the simplex call should be the full number of variables, i.e. 2*dim+1 
		 * the dimension of iposv should be the full number of restrictions i.e. k+1
		 *
		 */

/*{

int k;
double the_min_dist = (fabs(vect[0])+fabs(vect[1])+fabs(vect[2])+fabs(vect[3]));
for (k=4; k<vec_len; k+=4)
	the_min_dist = min(the_min_dist, fabs(vect[k+0])+fabs(vect[k+1])+fabs(vect[k+2])+fabs(vect[k+3]) );
if (counter == 804 || counter == 805) 
	printf("\n*** the_min_dist = %g", the_min_dist);
}*/

			/*
			 *	prepare data for simplex algorithm call
			 */

			/* initialize the first row */
		for (j=1 ; j<(2*dim+2) ; j++)
			simplex_matrix[1][j] = 0.0;
		simplex_matrix[1][2*dim+2] = 1.0;
			/* initialize the next num_res_m1 rows */
		jj = 0;
		for (i=2; i<=(num_res_m1+1); i++) {
			simplex_matrix[i][1] = 0.0;
			for (j=2 ; j<=(dim+1) ; j++) {
				simplex_matrix[i][j] = (float)(vect[jj] / max_of_vect);	/* normalize on need */
				simplex_matrix[i][j + dim] = (float)(- vect[jj++] / max_of_vect);	/* normalize on need */
			}
			simplex_matrix[i][2*dim+2] = -1.0;
		}
			/* initialize the final row */
		simplex_matrix[num_res_m1+2][1] = 1.0;
		for (j=2 ; j<(2*dim+2) ; j++)
			simplex_matrix[num_res_m1+2][j] = -1.0;
		simplex_matrix[num_res_m1+2][2*dim+2] = 0.0;


/*if (counter == 489) {
printf("before\na[%d, %d] = \n[", (num_res_m1+3), (2 * dim + 2));
for (i=1; i<(num_res_m1+3); i++) {
	printf("[");
	for (j=1; j<(2 * dim+2); j++) {
		printf("%1.20G, ", simplex_matrix[i][j]);
	}
	printf("%1.20G],\n",simplex_matrix[i][2 * dim+2]);
}
printf("[");
for (j=1; j<(2 * dim+2); j++) {
	printf("%1.20G, ", simplex_matrix[num_res_m1+3][j]);
}
printf("%1.20G]]\n",simplex_matrix[num_res_m1+3][2 * dim+2]);
exit(0);
}*/
		simplex(simplex_matrix, 2*dim+1, num_res_m1, 0, 1, &res_case, irowv, iposv);

/*printf("after\na[%d, %d] = \n[", (num_res_m1+3), (2 * dim + 2));
for (i=1; i<(num_res_m1+3); i++) {
	printf("[");
	for (j=1; j<(2 * dim+2); j++) {
		printf("%g, ", simplex_matrix[i][j]);
	}
	printf("%g],\n",simplex_matrix[i][2 * dim+2]);
}
printf("[");
for (j=1; j<(2 * dim+2); j++) {
	printf("%g, ", simplex_matrix[num_res_m1+3][j]);
}
printf("%g]]\n",simplex_matrix[num_res_m1+3][2 * dim+2]);
*/

/*if (counter == 804 || counter == 805) printf("\n=> simple_matrix[1][1] = %g, smallish = %g, max_of_vect = %g<=\t",simplex_matrix[1][1], smallish, max_of_vect);
*/

		ret_1 = (simplex_matrix[1][1] >= smallish); 
//		return (simplex_matrix[1][1] >= smallish);
//#else /* ! OLD_SIMPLEX */
	{
		int i, j;
		int ret = 0, err;

		for (i=0;i<dim;i++)
			lp_vect[i] = 0.0;
		lp_vect[dim] = -1.0;
		
		set_obj_fn(lp, off_vect);
		
		for (j=0;j<vec_len;j+=dim) {
			for (i=0; i<dim; i++)
				lp_vect[i] = vect[j+i];
			lp_vect[dim] = -1;
			
			add_constraint(lp, off_vect, GE, 0);				
		}
		
		err = solve(lp);
		
		for (j=0;j<vec_len;j+=dim)
			del_constraint(lp, 1);
		
		if (!err) {
			ret = ((-lp->best_solution[0]) >= smallish);
	//printf("bs = %g, ret = %d\n", -lp->best_solution[0], ret);
		} else
			printf("err is not zero: %d\n", err);
			
		ret_2 = ret;
//		return ret;
	}
#endif  /* ! OLD_SIMPLEX */

		if (ret_1 != ret_2) {
			printf("\n=====>1) %g - 2) %g\n", simplex_matrix[1][1], -lp->best_solution[0]);
		}

		return ret_1;
	}
	
	return 0;
}

/*
 * get_left_coeffs_gen:
 */

double *get_left_coeffs_gen(double *c, int nc, int axis, int *degs, int n_vars)
{
	/* 
	 * get left-half coeffs from full interval coeffs, multidim case 
	 * now apply the left-coefficient formula for the 1-variable case
	 */

	int j, i;
	int nmp = nc;
	int stride, next_stride;
	int n;
	double *p1, *p2;
	int k_big, k_small;
	int ix;
	int m;
	double sum;
	double *multi_p;
	
	for (stride=n_vars, j=axis+1; j<n_vars; j++) 
		stride = stride * (degs[j] + 1);
		
	next_stride = stride * (n = degs[axis] + 1);
	
	p1 = (double *)malloc(sizeof(double) * n * 2);	/* n is the degree + 1 */
	if (!p1)
		return NULL;
	p2 = p1 + n;
	multi_p  = (double *)malloc(sizeof(double) * nc);
	if (!multi_p) {
		free(p1);
		return NULL;
	}

	for (k_big=0; k_big<nmp; k_big += next_stride) {	/* iteration within each stride */
		for (k_small=0; k_small<stride; k_small++) {	/* iteration within each stride */
		
			ix = 0;	/* start count of 1-var coordinates */		
			for (m=k_small; m<next_stride; m+=stride)	/* iteration with jumps by stride */
				p1[ix++] = c[m + k_big];	/* extract 1-var polynomial */

			for (i=0; i<n; i++) {
				sum = 0.0;
				for (j=0; j<=i; j++) 
					sum += p1[j] * comb(i,j);
				p2[i] = pow(2.0,(double)-i) * sum;
			}


			ix = 0;	/* restart count of 1-var coordinates  */
			for (m=k_small; m<next_stride; m+= stride)	{ /* iteration with jumps by stride */
				multi_p[m + k_big] = p2[ix++];
			}
		}
	}
	
	free(p1);
	return multi_p;
}

/*
 * get_right_coeffs_gen:
 */

double *get_right_coeffs_gen(double *c, int nc, int axis, int *degs, int n_vars)
{
	/* 
	 * get right-half coeffs from full interval coeffs, multidim case 
	 * now apply the left-coefficient formula for the 1-variable case
	 */

	int j, k;
	int nmp = nc;
	int stride, next_stride;
	int n;
	double *p1, *p2;
	int k_big, k_small;
	int ix;
	int m;
	double sum;
	double *multi_p;
	
	for (stride=n_vars, j=axis+1; j<n_vars; j++) 
		stride = stride * (degs[j] + 1);
		
	next_stride = stride * (n = degs[axis] + 1);
	
	p1 = (double *)malloc(sizeof(double) * n * 2);
	if (!p1)
		return NULL;
	p2 = p1 + n;
	multi_p  = (double *)malloc(sizeof(double) * nc);
	if (!multi_p) {
		free(p1);
		return NULL;
	}

	for (k_big=0; k_big<nmp; k_big += next_stride) {	/* iteration within each stride */
		for (k_small=0; k_small<stride; k_small++) {	/* iteration within each stride */
		
			ix = 0;	/* start count of 1-var coordinates */		
			for (m=k_small; m<next_stride; m+=stride)	/* iteration with jumps by stride */
				p1[ix++] = c[m + k_big];	/* extract 1-var polynomial */

			for (k=0; k<n; k++) {
				sum = 0.0;
				for (j=k; j<n; j++) {
					sum += p1[j] * comb(n-1-k,n-1-j);
				}
				p2[k] = pow(2.0,(double)k-n+1) * sum;
			}

			ix = 0;	/* restart count of 1-var coordinates  */
			for (m=k_small; m<next_stride; m+=stride)	/* iteration with jumps by stride */
				multi_p[m + k_big] = p2[ix++];
		}
	}
	
	free(p1);
	return multi_p;
}

/*
 * find_root_list_Q:
 */

short find_root_list_Q(double *c, int nc, double *a, double *b, int dim, int axis, int *degs, int n_vars)
{
	/*
	 * Q-polynomial-based root-finder in the d-variable case; finds roots in the parallipiped [a,b]
	 * the c's are the vectors of Q-coefficents, accessed by t(flatten([i_1,i_2,..,i_d],dims)), where
	 * the 'flatten' function is as described above.
	 * if all the coefficients are positive or all negative, return an empty list of roots
	 *
	 * The reprogrammed version in C should treat the vector c as native, and provide an operation returning its vector sum.
	 * What is the source of the memory leak????
	 */
	
	int j;
	int na;
	int axi;
	short found;

	double new_midl;
	double *left_half;
	double *right_half;
		
	int roots_so_far;
	short err;

	double *save_left;
	double *save_right;
	
	int ax;
	int root_ix;
	double *root;
	short too_near;

#ifdef VERBOSE 
	int ii;
#endif

	if (axis >= (na = dim))  /* get the dimension, and limit 'axis' to the dimension */
		axis = 0;

counter ++;
{

//cond = (a[0] <= 0.333 && b[0] >= 0.333) && (a[2] <= 0.249 && b[2] >= 0.249) || (786 <= counter && counter <= 1000);
//cond = !(counter % 100);

cond = 1;

if (cond) {}
//	printf("%d. paralleliped to split: %3.11g + %3.11g (%3.11g), %3.11g + %3.11g (%3.11g), axis: %d", counter, a[0] ,b[0] - a[0], b[0], a[2] ,b[2] - a[2], b[2], axis+1); 
//	printf("%d. paralleliped to split: %3.11g + %3.11g (%3.11g), %3.11g + %3.11g (%3.11g), axis: %d", counter, a[0] ,b[0] - a[0], b[0], a[1] ,b[1] - a[1], b[1], axis+1); 

}

#ifdef VERBOSE
	printf("[POLY ZEROES] paralleliped to split: %3.11g + %3.11g    %3.11g + %3.11g axis: %d\n", a[0] ,b[0] - a[0], a[1] ,b[1] - a[1], axis+1); 
	printf("[POLY ZEROES] c = [");
	for (ii=0 ; ii<nc ; ii++)
		printf("%3.11g, ", c[ii]);
	printf("], nc = %d\n",nc);
#endif

	if (hull_excludes_0(c, nc, n_vars)) {
//if (cond) printf(" rejected\n");
#ifdef VERBOSE
		printf("[POLY ZEROES] rejected; c = [");
		for (ii=0 ; ii<nc ; ii++)
			printf("%3.11g, ", c[ii]);
		printf("], nc = %d\n",nc);
#endif
		return 0; /* there are no roots in this case */
	}
//if (cond) printf("\n");

	for (found=0, axi=0; axi<na; axi++)	/* see if the box is too small along every axis */
		if ((found = ((b[axi] - a[axi]) >= small_enough2)) != 0)
			break;

	if (!found) {   /* box is small, refuse it if it is too near a known root */
				
		for (root_ix=0; root_ix<n_root_list; root_ix++) {
			
			too_near = 1;

			root = root_list[root_ix];

			for (ax=0; ax<na; ax++) {
				if (fabs(root[ax] - a[ax]) > small_enough2) {
					too_near = 0;
					break;
				}
			}
			
			if (too_near) { 		/* refuse box since too near known root */
				refused_boxes ++;
				if ((refused_boxes % refused_enough) == 0) {
#ifdef VERBOSE
					printf("[POLY ZEROES] refused_boxes: %d\n", refused_boxes);	
#endif
				}
				return 0;	/* in this case the box is refused */
			}
			
		}
	}	
		/*
		 * otherwise see if the box is too small 
		 * along every access; if not we will bisect 
		 */

	if ((b[axis] - a[axis]) <= small_enough) {	/* we don't want to cut this axis */
				/*
				 * if the parallelipiped is small enough and might contain roots, return its center as a root, since
				 * in this limiting case all the coefficients must be close to equal and quite small 
				 */
		for(found=0, axis=0; axis<na; axis++) {
			if ((found = ((b[axis] - a[axis]) >= small_enough)) != 0) {
#ifdef VERBOSE
				printf("[POLY ZEROES] found axis = %d (b[axis] - a[axis]) = %g %g\n", axis, (b[axis] - a[axis]), small_enough);
#endif
				break;
			}
		}
		
		if (!found) {	/* then the box is small along every axis */
			
			double *root;
			
			roots_found++;     /* note that a root was found */
			
			if ((root = (double *)malloc(sizeof(double) * na)) == NULL)
					/* out of memory */
				return 1;
			
			for (j=0; j<na; j++)
				root[j] = (b[j] + a[j])/2.0;	/* root is at middle of small box */
			
			root_list[n_root_list ++] = root;	/* collect the root */
#ifdef VERBOSE
			printf("[POLY ZEROES] root found %1.11g\n", root[0]);			
#endif

printf("%d. root = %1.11g", counter, root[0]);			
printf(" %1.11g", root[1]);			
/*printf(" %1.11g", root[2]);			
printf(" %1.11g", root[3]);			
*/printf(" c=%d\n", counter);/**/

			if (roots_found > max_roots) 	/* this could happen in the presence of multiple roots or degenerate system */
				return 2;
				
			return 0;
		}	/* otherwise cut along an axis that is long enough */
	}

/*	if not b(axis) - a(axis) >= small_enough then print("***error*** "); stop; end if; */

	left_half = (double *)malloc(sizeof(double) * (2 * na));	/* 
																 * allocate two times the size of 
															     * the box corner vector
																 * to accomodate right_half too 
																 */
	if (!left_half)
		return 1;	/* out of memory */

	right_half = left_half + na;

	new_midl = (a[axis] + b[axis]) / 2.0;  /* get the middle of the axis */
	for (j=0; j<na; j++) {
		left_half[j] = (j != axis) ? b[j] : new_midl;
		right_half[j] =  (j != axis) ? a[j] : new_midl;	/* bisect the paralleliped along this axis */
	}
	

#ifdef VERBOSE
	printf("new_midl,left_half,right_half: %3.11g ",new_midl);
	printf("[");
	for (j=0;j<na;j++)
		printf("%f ",left_half[j]);
	printf("],[");
	for (j=0;j<na;j++)
		printf("%f ",right_half[j]);
	printf("]\n");
#endif
		/*
		 * combine the roots from the two sections
		 */
	
	roots_so_far = n_root_list;

	save_left = get_left_coeffs_gen(c, nc, axis, degs, na);
	if (!save_left) 
		return 1;

	err = find_root_list_Q(save_left, nc, a, left_half, dim, axis + 1, degs, n_vars);
	if (err) {
		free(save_left);
		return err;
	}
		
	save_right = get_right_coeffs_gen(c, nc, axis, degs, na);
	if (!save_right) {
		free(save_left);
		return 1;
	}
	err = find_root_list_Q(save_right, nc, right_half, b, dim, axis + 1, degs, n_vars);
	if (err) {
		free(save_right);
		free(save_left);
		return err;
	}
	
	splits++;
		
	if (roots_so_far == n_root_list) 
		wasted_splits ++;

		/* diagnostic only*/
#ifdef VERBOSE
	if (!(splits % split_enough)) 
		printf("[POLY ZEROES] splits, wasted: %d  %d roots_found %d refused_boxes %d %d\n", 
				splits, wasted_splits, roots_found, refused_boxes);
#endif


	free(save_right);	/* free used dynamic memory */
	free(save_left);
	free(left_half);
	
	return 0; /* return the combined root list */
}

/*
 * simples:
 */

void simplex(double **a, int n, int m1, int m2, int m3, int *icase, int izrov[], int iposv[])
{
	int j;
	int m_all = m1+m2+m3;
	
	simplx(a, m_all, n, m1, m2, m3, icase, izrov, iposv);
	
	for (j=2 ; j<=n+1 ; j++)
		a[1][j] = 0.0;
	for (j=1 ; j<=m_all ; j++)
		if (iposv[j] <= n)
			a[1][iposv[j]+1] = a[j+1][1];
}
		
/*
 * comb:
 */

double comb(int i, int j)
{
	return factrl(i)/(factrl(j) * factrl(i - j));
}

	/*
	 * "Numerical Recipes" borrowed routines
	 */

double factrl(int n)
{
	static int ntop=4;
	static double a[33]={1.0,1.0,2.0,6.0,24.0};
	int j;

	if (n > 32) return exp(gammln(n+1.0));
	while (ntop<n) {
		j=ntop++;
		a[ntop]=a[j]*ntop;
	}
	return a[n];
}

double gammln(double xx)
{
	double x,y,tmp,ser;
	static double cof[6]={76.18009172947146,-86.50532032941677,
		24.01409824083091,-1.231739572450155,
		0.1208650973866179e-2,-0.5395239384953e-5};
	int j;

	y=x=xx;
	tmp=x+5.5;
	tmp -= (x+0.5)*log(tmp);
	ser=1.000000000190015;
	for (j=0;j<=5;j++) ser += cof[j]/++y;
	return -tmp+log(2.5066282746310005*ser/x);
}

