#include "macros.h"

#include "nrutil.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <math.h>
#include <time.h>

#include "poly_zeroes.h"

/* SETL2 system header files */

static int32 nr_type;

#define TUPLE_SIZE(tuple_arg) \
	tuple_arg.sp_val.sp_tuple_ptr->t_ntype.t_root.t_length

void internal_destructor(void *ptr)
{
#ifdef __MWERKS__
#pragma unused(ptr)
#endif
}

int32 POLYZEROES__INIT(
   SETL_SYSTEM_PROTO_VOID)
{
   nr_type=register_type(SETL_SYSTEM "struct nrmatrix",internal_destructor);
   if (nr_type==0) return 1;
   return 0;

}

void PZ_FIND_ROOT_LIST(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
#ifdef __MWERKS__
#pragma unused(argc)
#endif
	int i, j;

	TUPLE_ITERATOR(ia)
	TUPLE_ITERATOR(ib)
	TUPLE_CONSTRUCTOR(ca)
	TUPLE_CONSTRUCTOR(cab)
	int rows, columns;

	double *Q_coeffs = NULL, *Q_coeffs_ptr;
	double *a, *a_ptr;
	double *b, *b_ptr;
	int *degrees, *degrees_ptr;

	int coeff_rows, coeff_cols, a_size, b_size, degrees_size;

	double **root_list_res;
	int root_list_size;
	i_real_ptr_type real_ptr;			/* real pointer	*/
	specifier s;
	
	
		/*
		 * first parameter [coefficients]
		 */
	if (argv[0].sp_form != ft_tuple)
		abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"pz_find_root_list",
			abend_opnd_str(SETL_SYSTEM argv));

	coeff_rows = rows = TUPLE_SIZE(argv[0]);

#ifdef NESTED_TUPLES
	columns = -1;

	ITERATE_TUPLE_BEGIN(ia, argv[0])
	{
		if (columns < 0) {
			coeff_cols = columns = TUPLE_SIZE((*ia_element));

			Q_coeffs_ptr = Q_coeffs = (double *) malloc (sizeof(double) * rows * columns);
			if (!Q_coeffs)
				abend(SETL_SYSTEM "out of memory");
		}
		
		ITERATE_TUPLE_BEGIN(ib,(*ia_element))
		{
			if (ib_element->sp_form==ft_real) 
				*Q_coeffs_ptr++=(double)((ib_element->sp_val.sp_real_ptr)->r_value);
			else
				abend(SETL_SYSTEM "coefficients must me real","matrix",1,
					"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));
		}
		ITERATE_TUPLE_END(ib)
	}
	ITERATE_TUPLE_END(ia)

#else

	if (!rows)
		abend(SETL_SYSTEM "invalid empty tuple","matrix",1,
			"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));

	Q_coeffs_ptr = Q_coeffs = (double *) malloc (sizeof(double) * rows);
	if (!Q_coeffs)
		abend(SETL_SYSTEM "out of memory");

	ITERATE_TUPLE_BEGIN(ia, argv[0])
	{
		if (ia_element->sp_form==ft_real) 
			*Q_coeffs_ptr++=(double)((ia_element->sp_val.sp_real_ptr)->r_value);
		else
			abend(SETL_SYSTEM "coefficients must me real","matrix",1,
				"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));
	}
	ITERATE_TUPLE_END(ia)

#endif
	
		/*
		 * second parameter [a]
		 */
	if (argv[1].sp_form != ft_tuple)
		abend(SETL_SYSTEM msg_bad_arg,"tuple",2,"pz_find_root_list",
			abend_opnd_str(SETL_SYSTEM argv));

	a_size = rows = TUPLE_SIZE(argv[1]);

	if (!rows)
		abend(SETL_SYSTEM "invalid empty tuple","matrix",1,
			"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));

	a_ptr = a = malloc(sizeof(double) * rows);
	if (!a)
		abend(SETL_SYSTEM "out of memory");

	ITERATE_TUPLE_BEGIN(ia,argv[1])
	{
        if (ia_element->sp_form==ft_real) 
			*a_ptr++ = (double)((ia_element->sp_val.sp_real_ptr)->r_value);
		else
			abend(SETL_SYSTEM "coefficients must me real","vector",2,
				"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));
	}
	ITERATE_TUPLE_END(ia);

		/*
		 * third parameter [b]
		 */
	if (argv[2].sp_form != ft_tuple)
		abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"pz_find_root_list",
			abend_opnd_str(SETL_SYSTEM argv));

	b_size = rows = TUPLE_SIZE(argv[2]);

	if (!rows)
		abend(SETL_SYSTEM "invalid empty tuple","matrix",1,
			"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));

	b_ptr = b = malloc(sizeof(double) * rows);
	if (!b)
		abend(SETL_SYSTEM "out of memory");

	ITERATE_TUPLE_BEGIN(ia,argv[2])
	{
        if (ia_element->sp_form==ft_real) 
			*b_ptr++ = (double)((ia_element->sp_val.sp_real_ptr)->r_value);
		else
			abend(SETL_SYSTEM "coefficients must me real","vector",2,
				"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));
	}
	ITERATE_TUPLE_END(ia);

		/*
		 * fourth parameter [degrees]
		 */
	if (argv[3].sp_form != ft_tuple)
		abend(SETL_SYSTEM msg_bad_arg,"tuple",4,"pz_find_root_list",
			abend_opnd_str(SETL_SYSTEM argv));

	degrees_size = rows = TUPLE_SIZE(argv[3]);

	if (!rows)
		abend(SETL_SYSTEM "invalid empty tuple","matrix",1,
			"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));

	degrees_ptr = degrees = malloc(sizeof(double) * rows);
	if (!degrees)
		abend(SETL_SYSTEM "out of memory");

	ITERATE_TUPLE_BEGIN(ia,argv[3])
	{
        if (ia_element->sp_form==ft_short) 
			*degrees_ptr++ = (int)ia_element->sp_val.sp_short_value;
		else
			abend(SETL_SYSTEM "coefficients must me real","vector",4,
				"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));
	}
	ITERATE_TUPLE_END(ia);

	if ((a_size != b_size) || (b_size != degrees_size))
		abend(SETL_SYSTEM "tuples for a, b and degrees should share the same size","",4,
			"pz_find_root_list", abend_opnd_str(SETL_SYSTEM argv));
	
#ifdef NESTED_TUPLES
	root_list_res = find_root_list(Q_coeffs, coeff_rows * coeff_cols, a, b, degrees, a_size, &root_list_size);
#else
	root_list_res = find_root_list(Q_coeffs, coeff_rows, a, b, degrees, a_size, &root_list_size);
#endif

	free(a);
	free(b);
	free(Q_coeffs);
	free(degrees);

	TUPLE_CONSTRUCTOR_BEGIN(ca);	/* tuple constructed outside to generate */
									/* the empty tuple if no roots are found */
	if (root_list_size) {
		for (i=0; i<root_list_size; i++) {
			TUPLE_CONSTRUCTOR_BEGIN(cab);
			for (j=0; j<a_size; j++) {		

				i_get_real(real_ptr);
				s.sp_form = ft_real;
				s.sp_val.sp_real_ptr = real_ptr;
				real_ptr->r_use_count = 1;
				real_ptr->r_value = root_list_res[i][j];
				TUPLE_ADD_CELL(cab,&s);
			}
			TUPLE_CONSTRUCTOR_END(cab);
			
			s.sp_form = ft_tuple;
			s.sp_val.sp_tuple_ptr = TUPLE_HEADER(cab);
			TUPLE_ADD_CELL(ca, &s);
		}

			/* deallocate used memory */
		for (i=0; i<root_list_size; i++)
			free(root_list_res[i]);
		free(root_list_res);
	}
	TUPLE_CONSTRUCTOR_END(ca);

	unmark_specifier(target);
	target->sp_form = ft_tuple;
	target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);
}

void PZ_SIMPLEX(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
#ifdef __MWERKS__
#pragma unused(argc)
#endif

	TUPLE_ITERATOR(ia)
	TUPLE_ITERATOR(ib)
	TUPLE_CONSTRUCTOR(ca)

	int i, j;
	int icase;
	int n, m1, m2, m3, m;
	
	int *irowv, *iposv;
	double **simplex_matrix;	/* this is a pointer to a numerical recipes array */

	i_real_ptr_type real_ptr;			/* real pointer	*/
	specifier s;

	if (argv[0].sp_form != ft_tuple)
		abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"pz_simplex",
			abend_opnd_str(SETL_SYSTEM argv));

	n = TUPLE_SIZE(argv[0]) - 1;

	if (argv[1].sp_form != ft_tuple)
		abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"pz_simplex",
			abend_opnd_str(SETL_SYSTEM argv));
	
	m1 = TUPLE_SIZE(argv[1]);

	if (argv[2].sp_form != ft_tuple)
		abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"pz_simplex",
			abend_opnd_str(SETL_SYSTEM argv));

	m2 = TUPLE_SIZE(argv[2]);

	if (argv[3].sp_form != ft_tuple)
		abend(SETL_SYSTEM msg_bad_arg,"tuple of tuples",1,"pz_simplex",
			abend_opnd_str(SETL_SYSTEM argv));

	m3 = TUPLE_SIZE(argv[3]);
	m = m1+m2+m3;
	
	simplex_matrix = dmatrix(1, m+2, 1, n+1);
	if (!simplex_matrix) 
		abend(SETL_SYSTEM "out of memory");

	irowv = ivector(1, n);
	if (!irowv)
		abend(SETL_SYSTEM "out of memory");

	iposv = ivector(1, m);
	if (!iposv)
		abend(SETL_SYSTEM "out of memory");

		/* read first row of a*/
	i=1;
	j=1;
	ITERATE_TUPLE_BEGIN(ia, argv[0])
	{
		if (ia_element->sp_form==ft_real) 
			simplex_matrix[1][i++] = (double)((ia_element->sp_val.sp_real_ptr)->r_value);
		else
			abend(SETL_SYSTEM "coefficients must me real","matrix",1,
				"pz_simplex", abend_opnd_str(SETL_SYSTEM argv));
	}
	ITERATE_TUPLE_END(ia)
	
		/* read next m1 rows */
	j=2;
	ITERATE_TUPLE_BEGIN(ia, argv[1])
	{
		i=1;
		ITERATE_TUPLE_BEGIN(ib,(*ia_element))
		{
			if (ib_element->sp_form==ft_real) 
				simplex_matrix[j][i++]=(double)((ib_element->sp_val.sp_real_ptr)->r_value);
			else
				abend(SETL_SYSTEM "coefficients must me real","matrix",2,
					"pz_simplex", abend_opnd_str(SETL_SYSTEM argv));
		}
		ITERATE_TUPLE_END(ib)
		j++;
	}
	ITERATE_TUPLE_END(ia)

		/* read next m2 rows */
	ITERATE_TUPLE_BEGIN(ia, argv[2])
	{
		i=1;
		ITERATE_TUPLE_BEGIN(ib,(*ia_element))
		{
			if (ib_element->sp_form==ft_real) 
				simplex_matrix[j][i++]=(double)((ib_element->sp_val.sp_real_ptr)->r_value);
			else
				abend(SETL_SYSTEM "coefficients must me real","matrix",3,
					"pz_simplex", abend_opnd_str(SETL_SYSTEM argv));
		}
		ITERATE_TUPLE_END(ib)
		j++;
	}
	ITERATE_TUPLE_END(ia)

		/* read next and last m3 rows */
	ITERATE_TUPLE_BEGIN(ia, argv[3])
	{
		i=1;
		ITERATE_TUPLE_BEGIN(ib,(*ia_element))
		{
			if (ib_element->sp_form==ft_real) 
				simplex_matrix[j][i++]=(double)((ib_element->sp_val.sp_real_ptr)->r_value);
			else
				abend(SETL_SYSTEM "coefficients must me real","matrix",4,
					"pz_simplex", abend_opnd_str(SETL_SYSTEM argv));
		}
		ITERATE_TUPLE_END(ib)
		j++;
	}
	ITERATE_TUPLE_END(ia)

	simplex(simplex_matrix, n, m1, m2, m3, &icase, irowv, iposv);
	
	if (icase == 0) {	/* return the first vector */

		TUPLE_CONSTRUCTOR_BEGIN(ca);	/* tuple constructed outside to generate */
		for (i=1; i<=n+1; i++) {
			i_get_real(real_ptr);
			s.sp_form = ft_real;
			s.sp_val.sp_real_ptr = real_ptr;
			real_ptr->r_use_count = 1;
			real_ptr->r_value = simplex_matrix[1][i];
			TUPLE_ADD_CELL(ca,&s);
		}
		TUPLE_CONSTRUCTOR_END(ca);

		unmark_specifier(target);
		target->sp_form = ft_tuple;
		target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);

	} else if (icase == 1) {	/* return an empty vector */

		TUPLE_CONSTRUCTOR_BEGIN(ca);	/* tuple constructed outside to generate */
		TUPLE_CONSTRUCTOR_END(ca);
		unmark_specifier(target);

		unmark_specifier(target);
		target->sp_form = ft_tuple;
		target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);
		
	} else { /* if (icase == -1) { */

		unmark_specifier(target);
		target->sp_form = ft_omega;

	}	

	free_dmatrix(simplex_matrix, 1, m+2, 1, n+1);
	free_ivector(irowv, 1, n);
	free_ivector(iposv, 1, m);
}