#include "tkInt.h"
#include "tkPort.h"

#include "tkMimage.h"

/*
 *	Early definition prototypes
 */

static int MimageCreate(Tcl_Interp *interp, char *name, int argc, char **argv, Tk_ImageType *typePtr, Tk_ImageMaster master, ClientData *clientDataPtr);
static ClientData MimageGet(Tk_Window tkwin, ClientData masterData);
static void MimageDisplay(ClientData clientData, Display *display, Drawable drawable, int imageX, int imageY, int width, int height, int drawableX, int drawableY);
static void MimageFree(ClientData  clientData, Display *display);
static void MimageDelete(ClientData masterData);

/*
 *
 * Information from bitplns.h
 *
 */
 
#ifndef _int32
typedef long _int32;
#endif

typedef struct {
		size_t starting_pixel_number;
		size_t number_of_pixels;
		int position_in_buffer;		
} section_data_t, *section_data_t_ptr;

typedef struct {
	_int32 use_count;
	_int32 type;

	char kind;
	int  comp;
	void **planes_array;

	unsigned char density;

	size_t upperleft_x;
	size_t upperleft_y;	

	size_t data_length;
	size_t section_length;

	int *row_start;
	                       
	section_data_t *row_section;

	size_t	buffer_length;

} mimage, *mimage_ptr;
 
/*
 */

typedef struct MimageInstance {
	int 					refCount;
	struct MimageMaster		*masterPtr;
	Tk_Window 				tkwin;

	GC						gc; /* graphic context */

	Pixmap					pixels;
	mimage					*mimgPtr;
	struct MimageInstance	*nextPtr;
} MimageInstance;

typedef struct MimageMaster {
	Tk_ImageMaster			tkMaster;
	Tcl_Interp				*interp;
	Tcl_Command				imageCmd;
	
	mimage					*data;
	int width, height;
	
	MimageInstance	*instancePtr;
} MimageMaster;

Tk_ImageType tkMimageType = {
	"mimage",				/* name */
	MimageCreate,			/* createProc */
	MimageGet,				/* getProc */
	MimageDisplay,			/* displayProc */
	MimageFree,				/* freeProc */
	MimageDelete,			/* deleteProc */
	(Tk_ImageType *) NULL	/* nextPtr */
};

/*
 * Information used for parsing configuration specs:
 */

	// serve per definire parametri nuovi per l'immagine. Importante nel nostro caso
	// che vogliamo passare un parametro opaque. // ????
	
static Tk_ConfigSpec configSpecs[] = {
    {TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
	(char *) NULL, 0, 0}
};

/*
 * Prototypes
 */

static int MimageConfigureMaster(MimageMaster *masterPtr, int argc, char **argv, int flags);
static void MimageConfigureInstance(MimageInstance *instancePtr);

/*
 */

static int MimageCreate(Tcl_Interp *interp, char *name, int argc, char **argv, Tk_ImageType *typePtr, Tk_ImageMaster master, ClientData *clientDataPtr)
{
	MimageMaster *masterPtr;
	
	masterPtr = (MimageMaster *) ckalloc(sizeof(MimageMaster));
	memset(masterPtr, 0, sizeof(MimageMaster));
	masterPtr->tkMaster = master;
	masterPtr->interp = interp;
	masterPtr->imageCmd = NULL;	// mettere qui l'interpretazione dei comandi tk ????

	masterPtr->width = masterPtr->height = 50;	// test

	masterPtr->data = NULL;

	if (MimageConfigureMaster(masterPtr, argc, argv, 0) != TCL_OK) {
		MimageDelete((ClientData) masterPtr);
		return TCL_ERROR;
	}
	
	*clientDataPtr = (ClientData) masterPtr;
	
	return TCL_OK;
}

/*
 */

static int MimageConfigureMaster(MimageMaster *masterPtr, int argc, char **argv, int flags)
{
	MimageInstance *instancePtr;
	
//	if (Tk_ConfigureWidget(masterPtr->interp, Tk_MainWindow(masterPtr->interp), configSpecs, argc, argv, (char *) masterPtr, flags) != TCL_OK)		
//		return TCL_ERROR;

//    if (masterPtr->data != NULL) {
//		ckfree(masterPtr->data);
//		masterPtr->data = NULL;
//    }
    
	for (instancePtr = masterPtr->instancePtr; instancePtr != NULL; instancePtr = instancePtr->nextPtr) 
		MimageConfigureInstance(instancePtr);
	
	Tk_ImageChanged(masterPtr->tkMaster, 0, 0, masterPtr->width, masterPtr->height, masterPtr->width, masterPtr->height);
		
	return TCL_OK;
}

static void MimageConfigureInstance(MimageInstance *instancePtr)
{
	MimageMaster *masterPtr = instancePtr->masterPtr;
	XGCValues gcValues;
	GC gc;
	unsigned int mask;
	
	mask = 0;

	gc = Tk_GetGC(instancePtr->tkwin, mask, &gcValues);

//	if (instancePtr->gc != None)
//		Tk_FreeGC(Tk_Display(instancePtr->tkwin), instancePtr->gc);
	
	instancePtr->gc = gc;	/* get the graphic context */
	
	return;
}

/*
 */

static ClientData MimageGet(Tk_Window tkwin, ClientData masterData)
{
	MimageMaster *masterPtr = (MimageMaster *) masterData;
	MimageInstance *instancePtr;
	
	for (instancePtr = masterPtr->instancePtr; instancePtr != NULL; instancePtr = instancePtr->nextPtr) {
		if (instancePtr->tkwin == tkwin) {
			instancePtr->refCount ++;
			return (ClientData) instancePtr;
		}
	}

	instancePtr = (MimageInstance *) ckalloc(sizeof(MimageInstance));
	instancePtr->refCount = 1;
	instancePtr->masterPtr = masterPtr;
	instancePtr->tkwin = tkwin;
	
	instancePtr->mimgPtr = NULL; // ????

	instancePtr->nextPtr = masterPtr->instancePtr;
	masterPtr->instancePtr = instancePtr;
	
	MimageConfigureInstance(instancePtr);

	if (instancePtr->nextPtr == NULL) {
		Tk_ImageChanged(masterPtr->tkMaster, 0, 0, 0, 0, masterPtr->width, masterPtr->height);
	}	

	return (ClientData) instancePtr;
}

static void MimageDisplay(ClientData clientData, Display *display, Drawable drawable, int imageX, int imageY, int width, int height, int drawableX, int drawableY)
{
	MimageInstance *instancePtr = (MimageInstance *) clientData;

	if (instancePtr->gc != None) {

		// masking not enabled by now
	
		// ????

/*
	XCopyPlane(display, instancePtr->bitmap, drawable, instancePtr->gc,
		imageX, imageY, (unsigned)width, (unsigned)height, 
		drawableX, drawableY, 1);
*/

	XCopyArea(display, instancePtr->pixels, drawable, instancePtr->gc,
		imageX, imageY, (unsigned)width, (unsigned)height, 
		drawableX, drawableY);

	}
}

static void MimageFree(ClientData  clientData, Display *display)
{
	MimageInstance *instancePtr = (MimageInstance *) clientData;
	MimageInstance *prevPtr;
	
	instancePtr->refCount--;
	if (instancePtr->refCount > 0) 
		return;
		
	// rimuovere la grafica copiata ????

	//	if (instancePtr->gc != None)	// ?????
	//		TK_FreeGC(display, instancePtr->gc);
	
	if (instancePtr->masterPtr->instancePtr == instancePtr) {
		instancePtr->masterPtr->instancePtr = instancePtr->nextPtr;
	} else {
		for (prevPtr = instancePtr->masterPtr->instancePtr; prevPtr->nextPtr != instancePtr; prevPtr = prevPtr->nextPtr) {
			/* Empty loop body */
		}
	}
	
}

static void MimageDelete(ClientData masterData)
{
	MimageMaster *masterPtr = (MimageMaster *) masterData;
	
	if (masterPtr->instancePtr != NULL) 
		panic("tried to delete mimage image when instance sill exist");
		
	masterPtr->tkMaster = NULL;
	
	if (masterPtr->imageCmd != NULL)
		Tcl_DeleteCommandFromToken(masterPtr->interp, masterPtr->imageCmd);
	
	Tk_FreeOptions(configSpecs, (char *) masterPtr, (Display *) NULL, 0);
	ckfree((char *) masterPtr);

}