#ifndef __TKGRLIB_H__
#define __TKGRLIB_H__	0x0100


typedef enum {
	FLOAT_IMAGE		= 1,
	REG_IMAGE		= 2,	/* to be obsolete soon */
	DISCRETE_IMAGE	= 2		/* !!! use this for not float images !!! */
} image_t;

typedef enum {
 	RGB_CHANNELS = 3
} channels_number_t;

typedef enum {
	DENSE_IMAGE  = 0,
	SPARSE_IMAGE = 1
} density_t;

#ifndef _int32
typedef int _int32;
#endif
#ifdef MACINTOSH
typedef long _int32;
#endif

#ifndef pixel
typedef unsigned char mpixel;
typedef unsigned char *mpixel_ptr;
#endif

#ifndef fmpixel
typedef float fmpixel;
typedef float *fmpixel_ptr;
#endif

typedef struct {
  int height;
  int width;
  
  mpixel_ptr buffer;
  mpixel default_value;
  
} byteplane, *byteplane_ptr, sparse_byteplane, *sparse_byteplane_ptr;

typedef struct {
  int height;
  int width;
  
  fmpixel_ptr buffer;
  fmpixel default_value;
  
} fbyteplane, *fbyteplane_ptr, sparse_fbyteplane, *sparse_fbyteplane_ptr;

typedef struct {
		size_t starting_pixel_number;
		size_t number_of_pixels;
		int position_in_buffer;		
} section_data, *section_data_ptr;

typedef struct {
	_int32 use_count;
	_int32 type;

	char kind;
	int  comp;
	byteplane_ptr *planes_array;

	unsigned char density;

	size_t upperleft_x;
	size_t upperleft_y;	

	size_t data_length;
	size_t section_length;

	int *row_start;
	                       
	section_data *row_section;

	size_t	buffer_length;

} mimage, *mimage_ptr;

/* 
 *	portability alert
 *	short is assumed
 *	to be 16 bits wide
 */

#define GET_TYPE_SIZE(a) ((a) == FLOAT_IMAGE ? sizeof(fmpixel) : sizeof(mpixel))

//extern _int32 gr_type;

	/* prototypes */
	
byteplane_ptr *create_planes_array(int width, int height, char kind, int planes_number, unsigned char density);
void destroy_planes_array(void **planes_array, char kind, int planes_number, unsigned char density);
void *get_plane_buffer(void *plane, int kind);
void *create_byteplane(int width, int height, char kind, unsigned char density);
void destroy_byteplane(void *byteplane, char kind, unsigned char density);
void destroy_dense_byteplane(void *byteplane, char kind);
byteplane_ptr get_byteplane_from_mimage(mimage_ptr mimg, char plane_index);
mimage_ptr create_mimage(int width, int height, int planes_number, char kind, unsigned char density);
void *create_sparse_byteplane(int width, int height, char kind);
void destroy_sparse_byteplane(sparse_byteplane_ptr byteplane, char kind);
void *create_dense_byteplane(int width, int height, char kind);
int sections_in_row(mimage_ptr mimg, int k);
void get_mimage_info(mimage_ptr mimg, int *height, int *width, int *comp, int *kind, unsigned char *density);

typedef union {
	short color;
	struct {
		unsigned alpha:1;
		unsigned red:5;
		unsigned green:5;
		unsigned blue:5;
	} components;	
} high_color;

typedef struct {
	unsigned char red;
	unsigned char green;
	unsigned char blue;
} true_color;

typedef struct {
	unsigned char alpha;
	unsigned char red;
	unsigned char green;
	unsigned char blue;
} true_color32;

#endif /* __TKGRLIB_H__	*/
