#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "str_queue.h"

StrQueuePtr create_str_queue(int num)
{
	StrQueuePtr theQueue = (StrQueuePtr)malloc(sizeof(StrQueue) + num * sizeof(StrQueueElem));
	if (!theQueue)
		return NULL;
	
	theQueue->theElmts = (StrQueueElemPtr)(((char *)theQueue) + sizeof(StrQueue));
	theQueue->head = theQueue->tail = 0;
	theQueue->length = num;

	return theQueue;
}

void empty_str_queue(StrQueuePtr theQueue)
{
	char *str;
	int length;
		
	while ((str = str_dequeue(theQueue, &length)) != NULL)
		free(str);
}

void destroy_str_queue(StrQueuePtr *theQueue)
{
	char *str;

	empty_str_queue(*theQueue);

	if (*theQueue)
		free(*theQueue);
	*theQueue = NULL;
}

char *str_dequeue(StrQueuePtr theQueue, int *strLength)
{
	StrQueueElemPtr elem;
	char *str;
	
	if (theQueue->head == theQueue->tail)
		return NULL;

	elem = theQueue->theElmts+theQueue->tail;

	str = elem->str;
	if (strLength)	*strLength = elem->strLength;
	
	theQueue->tail = (theQueue->tail + 1) % theQueue->length;

	return str;	
}

void str_enqueue(StrQueuePtr theQueue, char *str, int strLength)
{
	StrQueueElemPtr elem;
	
	if ((theQueue->head + 1) % theQueue->length == theQueue->tail)
		return;

	elem = theQueue->theElmts+theQueue->head;
	elem->str = malloc(strLength);
	if (!elem->str)
		return;	/* out of memory */
	memcpy(elem->str, str, strLength);
	
	theQueue->head = (theQueue->head + 1) % theQueue->length;
}