/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{File Names}
\*/

#ifndef FILENAME_LOADED

/* SETL2 system header files */

#include "system.h"                    /* SETL2 system constants            */

/* file node in file list */

struct filelist_item {
   char fl_name[PATH_LENGTH + 1];      /* expanded file name                */
   struct filelist_item *fl_next;      /* next name in list                 */
};

typedef struct filelist_item *filelist_ptr_type;
                                       /* file list pointer typedef         */

/* public function declarations */

void expand_filename(SETL_SYSTEM_PROTO char *);          
				       /* prepend drive / path to name      */
filelist_ptr_type setl_get_filelist(SETL_SYSTEM_PROTO char *);
                                       /* get a list of files matching a    */
                                       /* list of specifications            */
void setl_free_filelist(filelist_ptr_type); /* free a file list                  */
void get_tempname(SETL_SYSTEM_PROTO char *, char*);      
                                       /* find a temporary file name        */

#define FILENAME_LOADED 1

#endif

