/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{listing}
\*/

#ifndef LISTING_LOADED

/* public function declarations */

#if UNIX_VARARGS
void error_message(SETL_SYSTEM_PROTO_VOID);
                                       /* log error message                 */
void warning_message(SETL_SYSTEM_PROTO_VOID);                
                                       /* log warning message               */
void info_message(SETL_SYSTEM_PROTO_VOID);                   
                                       /* log info message                  */
#else
void error_message(SETL_SYSTEM_PROTO struct file_pos_item *, char *, ...);
                                       /* log error message                 */
void warning_message(SETL_SYSTEM_PROTO struct file_pos_item *, char *, ...);
                                       /* log warning message               */
void info_message(SETL_SYSTEM_PROTO struct file_pos_item *, char *, ...);
                                       /* log info message                  */
#endif
void print_errors(SETL_SYSTEM_PROTO_VOID);  
                                       /* print error list                  */
void print_listing(SETL_SYSTEM_PROTO_VOID);            
                                       /* print source listing              */
void generate_markup(SETL_SYSTEM_PROTO_VOID);    
                                       /* insert errors in source file      */
void free_err_table(SETL_SYSTEM_PROTO_VOID);

#ifdef PLUGIN
int setl_num_errors();
char * setl_err_string(int i);
#endif


#define LISTING_LOADED 1
#endif
