/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \package{Messages}
 *
 *  This package collects a variety of error message strings into one
 *  package.  At first glance, it seems a little foolish.  Why not just
 *  use a literal string at the point the error is found?  Essentially,
 *  I'm trying to get a little better code out of the compiler.  Most of
 *  these errors can be detected at many places in the compiler.
 *  Sometimes at many places within a single source file.  If we collect
 *  them here and give them symbolic names, the compiler will not
 *  generate separate literal strings for each occurrence.
 *
 *  Please do not make changes directly to this file.  The bulk of it can
 *  be generated by the table generator macro.
\*/

#ifndef MESSAGES_LOADED

#ifdef SHARED

/* giveup messages (severe errors) */

/* ## begin shared_common_messages */
char msg_spec_lib[] = "A specific library must be given for output units";
char msg_bad_stream_close[] = "Attempt to close invalid stream";
char msg_bad_unit_close[] = "Attempt to close invalid unit pointer";
char msg_bad_file_close[] = "Attempt to close unopen file";
char msg_bad_unit_copy[] = "Attempt to copy non-existant unit => %s";
char msg_bad_stream_read[] = "Attempt to read from output stream";
char msg_bad_stream_write[] = "Attempt to write from input stream";
char msg_read_only_library[] = "Attempted to write to read-only library";
char msg_dup_stream_open[] = "Duplicate stream open";
char msg_lib_create_error[] = "Error creating library => %s";
char msg_bad_file_path[] = 
      "File path => %s\nexceeds maximum length => %d characters";
char msg_bad_library[] = "Invalid library file => %s";
char msg_lib_fseek_error[] = "Seek error on library file => %s";
char msg_too_many_files[] = "Maximum file count exceeded";
char msg_malloc_error[] = "Memory allocation error";
char msg_lib_missing[] = "Missing library file => %s";
char msg_lib_open_error[] = "Open error on library file => %s";
char msg_lib_read_error[] = "Read error on library file => %s";
char msg_no_dir_space[] = "System error -- no space for directory";
char msg_get_dta_error[] = "System error -- unable to get DTA";
char msg_set_dta_error[] = "System error -- unable to set DTA";
char msg_no_temp_file[] = "Unable to find unused temporary file name";
char msg_lib_write_error[] = "Write error on library file => %s";
char msg_trap_float[] = "Could not set floating point error trap!";
char msg_trap_segment[] = "Could not set segmentation error trap!";
char msg_native_lib_open_error[] = "Open error on native library file => %s";
char msg_symbol_not_resolved[] = "Could not resolve native procedure %s ";
/* ## end shared_common_messages */

#ifdef INTERP
/* ## begin shared_interp_messages */
char msg_abend_failed[] = "ABEND couldn't find faulty unit";
char msg_abs_too_long[] = 
      "ABS string operand must be one character long:\nString => %s";
char msg_actarg_ne_formal[] = "Actual arguments do not match formal => %d";
char msg_bad_assert_arg[] = 
      "Assert expects a boolean, but found:\nOpnd => %s";
char msg_assert_passed[] = "Assert passed in ";
char msg_get_not_text[] = 
      "Attempt to get from file not opened for TEXT-IN:\nFile => %s";
char msg_read_not_text[] = 
      "Attempt to read from file not opened for TEXT-IN:\nFile => %s";
char msg_bad_spec_eq_call[] = "Bad call to spec_equal_test";
char msg_corrupted_set[] = "Can not find element in non-empty set";
char msg_bad_not_opnd[] = "Can only apply NOT to logical values";
char msg_corrupted_tuple[] = "Corrupted tuple";
char msg_trap_user[] = "Could not set user interrupt trap!";
char msg_zero_divide[] = "Divide by zero";
char msg_non_int_card[] = "Expected cardinality to be integer";
char msg_non_int_length[] = "Expected length to be integer";
char msg_expected_map[] = "Expected map but found %s";
char msg_expected_proc[] = "Expected procedure, but found:\nOpnd => %s";
char msg_expected_set[] = "Expected set but found %s";
char msg_source_too_long[] = "Expected source to be a single character";
char msg_expected_tuple[] = "Expected tuple, but found:\n%s";
char msg_divide_error[] = "Fatal error in divide";
char msg_file_not_binary[] = "File not SETL binary file => %s";
char msg_domain_error[] = "Floating point domain error";
char msg_nan_error[] = "Floating point error -- Not a number";
char msg_float_error[] = "Floating point error";
char msg_range_error[] = "Floating point range error";
char msg_expected_pack_not_unit[] = "Imported unit %s is a program, not a package";
char msg_incompatible_opnds[] = "Incompatible operand types => %s and %s";
char msg_expected_integer[] = "Integer expected but found:\nOpnd => %s";
char msg_bad_reads_opnd[] = "Invalid SETL value in reads";
char msg_not_setl_value[] = "Invalid SETL value";
char msg_bad_assert_opt[] = "Invalid assert option => %c";
char msg_bad_debug_opt[] = "Invalid debugging option => %c";
char msg_bad_file_handle[] = "Invalid file handle:\nHandle => %s";
char msg_bad_file_mode[] = "Invalid file mode:\nMode => %s";
char msg_bad_file_spec[] = "Invalid file specifier:\nSpecifier => %s";
char msg_bad_sys_command[] = "Invalid system command";
char msg_bad_form_hash[] = "Invalid form type for hash code calculation";
char msg_invalid_index[] = "Invalid index:\n%s";
char msg_bad_indirect_goto[] = "Invalid indirect branch";
char msg_invalid_opnd_msg[] = "Invalid operand type => %s";
char msg_invalid_opnd_domain[] = "Invalid operand type for domain";
char msg_invalid_inter_opnd[] = "Invalid operand type for iterator";
char msg_invalid_map_iter[] = "Invalid operand type for map iterator";
char msg_invalid_option[] = "Invalid option => %s";
char msg_invalid_proc_type[] = "Invalid procedure type => %d";
char msg_invalid_slice_limits[] = 
      "Invalid slice limits:\nSource => %s\nLeft => %s\nRight => %s";
char msg_invalid_tail_limits[] = 
      "Invalid slice limits:\nSource => %s\nIndex => %s";
char msg_invalid_string_index_msg[] = "Invalid string index => %ld";
char msg_invalid_string_index[] = "Invalid string index";
char msg_invalid_tup_assign[] = "Invalid tuple assignment";
char msg_invalid_tuple_index_msg[] = "Invalid tuple index => %ld";
char msg_invalid_type_slice[] = "Invalid type for slice =>";
char msg_invalid_set_map[] = "Invalid use of set as map:\nSet => %s";
char msg_missing_lib_name[] = "Missing library name";
char msg_missing_lib_path[] = "Missing library path";
char msg_missing_prog_name[] = "Missing program name";
char msg_missing_tup_header[] = "Missing tuple header";
char msg_noop_executed[] = "NOOP instruction executed";
char msg_negative_index[] = "Negative index";
char msg_negative_npow[] = "Negative n for npow:\nN => %s";
char msg_negative_string_index[] = "Negative string index";
char msg_negative_tuple_index[] = "Negative tuple index";
char msg_non_integer_index[] = "Non-integer used as index => %s";
char msg_non_integer_str_index[] = "Non-integer used as string index => %s";
char msg_non_integer_str_mult[] = 
      "Non-integer used as string multiplier => %s";
char msg_non_integer_tup_index[] = "Non-integer used as tuple index => %s";
char msg_opt_string_too_long[] = 
      "Option string exceeds maximum length (%d characters)";
char msg_program_not_found[] = "Program %s not found in library";
char msg_read_error[] = "Read error on file => %s\n";
char msg_bad_real_convert[] = "Real can not be converted to integer";
char msg_segment_error[] = "Segmentation error";
char msg_bad_opcode[] = "System error -- Invalid opcode";
char msg_package_uncompiled[] = "The body of %s must be compiled";
char msg_missing_args[] = "Too few actual arguments => %d";
char msg_tuple_indexes_string[] = "Tuple used as string index";
char msg_tuple_indexes_tuple[] = "Tuple used as tuple index";
char msg_missing_set_element[] = "Unable to find element in set";
char msg_package_needs_compiled[] = "Unit %s must be recompiled";
char msg_unmatched_quote[] = "Unmatched '\"' in options";
char msg_write_error[] = "Write error on file => %s";
char msg_missing_method[] = "The %s operation is not defined on class %s";
char msg_bad_binop_forms[] = 
      "Bad operands for %s operator:\nLeft  => %s\nRight => %s";
char msg_bad_unop_form[] = "Bad operand for %s operator:\nOpnd => %s";
char msg_bad_arg[] = 
      "Expected %s as argument %d to %s, but found:\nActual => %s";
/* ## end shared_interp_messages */
char msg_bad_debug_file[] = "Can't open debug file";
char msg_wrong_parms[] = "Wrong number of parameters";
#endif

#ifdef COMPILER
/* ## begin shared_compiler_messages */
char msg_unattched_sym[] = "Symbol \"%s\" not attached to name";
char msg_dup_declaration[] = "Duplicate declaration => %s";
char msg_existing_unit[] = 
      "%s exists in library from source file %s. Overwrite? ";
char msg_expected_prog[] = "%s is not a program. Overwrite? ";
char msg_expected_pack[] = "%s is not a package. Overwrite? ";
char msg_unit_too_long[] = "%s is longer than %d characters";
char msg_unit_not_comp[] = "%s not replaced in the library";
char msg_expected_tok_proc[] = "%s should be a procedure";
char msg_bad_selector[] = "A selector index must be an integer";
char msg_too_few_parms[] = "Actual parameters do not match formal";
char msg_bad_continue[] = "CONTINUEs are only possible in loops";
char msg_expected_goto[] = "Compiler error -- can not goto after reduce";
char msg_expected_shift[] = "Compiler error -- expected shift";
char msg_bad_action[] = 
      "Compiler error -- expected valid action in error recovery";
char msg_token_stack_overflow[] = 
      "Compiler error -- state-token stack exceeded";
char msg_expected_const[] = "Constant expression expected";
char msg_bad_proc_def[] = "Definition of %s does not match specification";
char msg_bad_exit[] = "EXITs are only possible in loops";
char msg_null_as_lhs[] = "Expected LHS, but found null";
char msg_expected_selector[] = "Expected selector => %s";
char msg_null_as_rhs[] = "Expected value-yielding expression, but found null";
char msg_uninit_const[] = "Initialized constant expected";
char msg_bad_ast_node[] = "Invalid AST node type => %d";
char msg_bad_iterator[] = "Invalid iterator expression";
char msg_expected_lhs[] = "Left hand side expected";
char msg_bad_inter_fseek[] = "Seek failure on intermediate file";
char msg_bad_map_iter[] = 
      "Map iterators are not valid without preceeding expression";
char msg_missing_map_arg[] = "Missing argument in map reference";
char msg_missing_proc[] = "Missing definition of %s";
char msg_missing_exp[] = "Missing expression";
char msg_missing_sel_exp[] = "No expression for selector => %s";
char msg_option_too_long[] = 
      "Option string exceeds maximum length (%d characters)";
char msg_dup_use[] = "Package %s is already being used";
char msg_bad_dash[] = "Place holders are only valid in assignment targets";
char msg_return_as_rhs[] = "RETURN doesn't produce a value";
char msg_return_from_prog[] = "RETURNs are only possible in procedures";
char msg_inter_read_error[] = "Read error on intermediate file";
char msg_expected_rhs[] = "Right hand side expected";
char msg_stop_as_rhs[] = "STOP must be used as a statment";
char msg_bad_sem_stack[] = "Semantic stack corrupted!";
char msg_bad_iter_lhs[] = "Sinister assignments are not allowed in iterators";
char msg_rhs_as_statement[] = "Statement expected";
char msg_bad_tail[] = "Tail identifier (%s) does not match unit name (%s)";
char msg_missing_package[] = "The package %s is not in the library";
char msg_no_spec[] = "The specification of %s is not in the library";
char msg_token_too_long[] = "Token too long => %s...";
char msg_bad_proc_call[] = "Too few actual parameters";
char msg_missing_source_file[] = "Unable to open source file => %s";
char msg_bad_temp_file[] = "Unable to open temporary file";
char msg_missing_id[] = "Unknown identifier => %s";
char msg_iter_write_error[] = "Write error on intermediate file";
char msg_want_yes_no[] = "\nPlease answer yes or no.\n";
/* ## end shared_compiler_messages */
#endif

#else

/* giveup messages (severe errors) */

/* ## begin extern_common_messages */
EXTERNAL char msg_spec_lib[];
EXTERNAL char msg_bad_stream_close[];
EXTERNAL char msg_bad_unit_close[];
EXTERNAL char msg_bad_file_close[];
EXTERNAL char msg_bad_unit_copy[];
EXTERNAL char msg_bad_stream_read[];
EXTERNAL char msg_bad_stream_write[];
EXTERNAL char msg_read_only_library[];
EXTERNAL char msg_dup_stream_open[];
EXTERNAL char msg_lib_create_error[];
EXTERNAL char msg_bad_file_path[];
EXTERNAL char msg_bad_library[];
EXTERNAL char msg_lib_fseek_error[];
EXTERNAL char msg_too_many_files[];
EXTERNAL char msg_malloc_error[];
EXTERNAL char msg_lib_missing[];
EXTERNAL char msg_lib_open_error[];
EXTERNAL char msg_lib_read_error[];
EXTERNAL char msg_no_dir_space[];
EXTERNAL char msg_get_dta_error[];
EXTERNAL char msg_set_dta_error[];
EXTERNAL char msg_no_temp_file[];
EXTERNAL char msg_lib_write_error[];
EXTERNAL char msg_trap_float[];
EXTERNAL char msg_trap_segment[];
EXTERNAL char msg_native_lib_open_error[];
EXTERNAL char msg_symbol_not_resolved[];
/* ## end extern_common_messages */

#ifdef INTERP
/* ## begin extern_interp_messages */
EXTERNAL char msg_abend_failed[];
EXTERNAL char msg_abs_too_long[];
EXTERNAL char msg_actarg_ne_formal[];
EXTERNAL char msg_bad_assert_arg[];
EXTERNAL char msg_assert_passed[];
EXTERNAL char msg_get_not_text[];
EXTERNAL char msg_read_not_text[];
EXTERNAL char msg_bad_spec_eq_call[];
EXTERNAL char msg_corrupted_set[];
EXTERNAL char msg_bad_not_opnd[];
EXTERNAL char msg_corrupted_tuple[];
EXTERNAL char msg_trap_user[];
EXTERNAL char msg_zero_divide[];
EXTERNAL char msg_non_int_card[];
EXTERNAL char msg_non_int_length[];
EXTERNAL char msg_expected_map[];
EXTERNAL char msg_expected_proc[];
EXTERNAL char msg_expected_set[];
EXTERNAL char msg_source_too_long[];
EXTERNAL char msg_expected_tuple[];
EXTERNAL char msg_divide_error[];
EXTERNAL char msg_file_not_binary[];
EXTERNAL char msg_domain_error[];
EXTERNAL char msg_nan_error[];
EXTERNAL char msg_float_error[];
EXTERNAL char msg_range_error[];
EXTERNAL char msg_expected_pack_not_unit[];
EXTERNAL char msg_incompatible_opnds[];
EXTERNAL char msg_expected_integer[];
EXTERNAL char msg_bad_reads_opnd[];
EXTERNAL char msg_not_setl_value[];
EXTERNAL char msg_bad_assert_opt[];
EXTERNAL char msg_bad_debug_opt[];
EXTERNAL char msg_bad_file_handle[];
EXTERNAL char msg_bad_file_mode[];
EXTERNAL char msg_bad_file_spec[];
EXTERNAL char msg_bad_sys_command[];
EXTERNAL char msg_bad_form_hash[];
EXTERNAL char msg_invalid_index[];
EXTERNAL char msg_bad_indirect_goto[];
EXTERNAL char msg_invalid_opnd_msg[];
EXTERNAL char msg_invalid_opnd_domain[];
EXTERNAL char msg_invalid_inter_opnd[];
EXTERNAL char msg_invalid_map_iter[];
EXTERNAL char msg_invalid_option[];
EXTERNAL char msg_invalid_proc_type[];
EXTERNAL char msg_invalid_slice_limits[];
EXTERNAL char msg_invalid_tail_limits[];
EXTERNAL char msg_invalid_string_index_msg[];
EXTERNAL char msg_invalid_string_index[];
EXTERNAL char msg_invalid_tup_assign[];
EXTERNAL char msg_invalid_tuple_index_msg[];
EXTERNAL char msg_invalid_type_slice[];
EXTERNAL char msg_invalid_set_map[];
EXTERNAL char msg_missing_lib_name[];
EXTERNAL char msg_missing_lib_path[];
EXTERNAL char msg_missing_prog_name[];
EXTERNAL char msg_missing_tup_header[];
EXTERNAL char msg_noop_executed[];
EXTERNAL char msg_negative_index[];
EXTERNAL char msg_negative_npow[];
EXTERNAL char msg_negative_string_index[];
EXTERNAL char msg_negative_tuple_index[];
EXTERNAL char msg_non_integer_index[];
EXTERNAL char msg_non_integer_str_index[];
EXTERNAL char msg_non_integer_str_mult[];
EXTERNAL char msg_non_integer_tup_index[];
EXTERNAL char msg_opt_string_too_long[];
EXTERNAL char msg_program_not_found[];
EXTERNAL char msg_read_error[];
EXTERNAL char msg_bad_real_convert[];
EXTERNAL char msg_segment_error[];
EXTERNAL char msg_bad_opcode[];
EXTERNAL char msg_package_uncompiled[];
EXTERNAL char msg_missing_args[];
EXTERNAL char msg_tuple_indexes_string[];
EXTERNAL char msg_tuple_indexes_tuple[];
EXTERNAL char msg_missing_set_element[];
EXTERNAL char msg_package_needs_compiled[];
EXTERNAL char msg_unmatched_quote[];
EXTERNAL char msg_write_error[];
EXTERNAL char msg_missing_method[];
EXTERNAL char msg_bad_binop_forms[];
EXTERNAL char msg_bad_unop_form[];
EXTERNAL char msg_bad_arg[];
EXTERNAL char msg_bad_debug_file[];
EXTERNAL char msg_wrong_parms[];
/* ## end extern_interp_messages */
#endif

#ifdef COMPILER
/* ## begin extern_compiler_messages */
EXTERNAL char msg_unattched_sym[];
EXTERNAL char msg_dup_declaration[];
EXTERNAL char msg_existing_unit[];
EXTERNAL char msg_expected_prog[];
EXTERNAL char msg_expected_pack[];
EXTERNAL char msg_unit_too_long[];
EXTERNAL char msg_unit_not_comp[];
EXTERNAL char msg_expected_tok_proc[];
EXTERNAL char msg_bad_selector[];
EXTERNAL char msg_too_few_parms[];
EXTERNAL char msg_bad_continue[];
EXTERNAL char msg_expected_goto[];
EXTERNAL char msg_expected_shift[];
EXTERNAL char msg_bad_action[];
EXTERNAL char msg_token_stack_overflow[];
EXTERNAL char msg_expected_const[];
EXTERNAL char msg_bad_proc_def[];
EXTERNAL char msg_bad_exit[];
EXTERNAL char msg_null_as_lhs[];
EXTERNAL char msg_expected_selector[];
EXTERNAL char msg_null_as_rhs[];
EXTERNAL char msg_uninit_const[];
EXTERNAL char msg_bad_ast_node[];
EXTERNAL char msg_bad_iterator[];
EXTERNAL char msg_expected_lhs[];
EXTERNAL char msg_bad_inter_fseek[];
EXTERNAL char msg_bad_map_iter[];
EXTERNAL char msg_missing_map_arg[];
EXTERNAL char msg_missing_proc[];
EXTERNAL char msg_missing_exp[];
EXTERNAL char msg_missing_sel_exp[];
EXTERNAL char msg_option_too_long[];
EXTERNAL char msg_dup_use[];
EXTERNAL char msg_bad_dash[];
EXTERNAL char msg_return_as_rhs[];
EXTERNAL char msg_return_from_prog[];
EXTERNAL char msg_inter_read_error[];
EXTERNAL char msg_expected_rhs[];
EXTERNAL char msg_stop_as_rhs[];
EXTERNAL char msg_bad_sem_stack[];
EXTERNAL char msg_bad_iter_lhs[];
EXTERNAL char msg_rhs_as_statement[];
EXTERNAL char msg_bad_tail[];
EXTERNAL char msg_missing_package[];
EXTERNAL char msg_no_spec[];
EXTERNAL char msg_token_too_long[];
EXTERNAL char msg_bad_proc_call[];
EXTERNAL char msg_missing_source_file[];
EXTERNAL char msg_bad_temp_file[];
EXTERNAL char msg_missing_id[];
EXTERNAL char msg_iter_write_error[];
EXTERNAL char msg_want_yes_no[];
/* ## end extern_compiler_messages */
#endif

#endif

#define MESSAGES_LOADED 1
#endif
