
/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \package{Semantic Actions}
 *
 *  %
 *  % If this message is at the top of the file, the file you are looking
 *  % at was generated by LALR from a grammar file. DO NOT CHANGE THIS
 *  % FILE!!  If you wish to change a semantic action, change the grammar
 *  % file and re-run LALR.  View this file as machine-generated.
 *  %
 *
 *  We are somewhat less ambitious in the semantic actions of this
 *  compiler than we would be in a similar package of another compiler.
 *  Because \setl\ allows forward references, it is extremely difficult to
 *  match the symbol table with the abstract syntax tree on the first
 *  pass.  We would have to do a lot of backpatching, after all
 *  declarations had been processed.  We suspect the backpatching would
 *  be less efficient, and would certainly be more complex to program,
 *  than simply adding another pass to match the symbol table and
 *  abstract syntax tree.
 *
 *  We have chosen the simpler alternative, and defer matching the symbol
 *  table and abstract syntax tree to another pass.  The semantic actions
 *  therefore have two distinct functions:
 *
 *  \begin{itemize}
 *  \item
 *  {\bf Declararion processing.}
 *  We process declarations and make entries in the symbol table, even
 *  though we do not refer to those declarations yet.
 *  \item
 *  {\bf Construction of an abstract syntax tree.}
 *  We build an abstract syntax tree, but every time we come across an
 *  identifier we build a name table node, {\em not} a symbol table
 *  node.  We make no attempt to determine exactly to which symbol a name
 *  refers.
 *  \end{itemize}
 *
 *  The semantic actions were completely hand coded in an ad hoc manner.
 *  To aid the reader in following the construction of an abstract syntax
 *  tree, we give a diagram of the semantic stack with every action which
 *  refers to items on the stack.
\*/


/* SETL2 system header files */

#include "system.h"                    /* SETL2 system constants            */
#include "compiler.h"                  /* SETL2 compiler constants          */
#include "giveup.h"                    /* severe error handler              */
#include "messages.h"                  /* error messages                    */
#include "builtins.h"                  /* built-in symbols                  */
#include "namtab.h"                    /* name table                        */
#include "symtab.h"                    /* symbol table                      */
#include "proctab.h"                   /* procedure table                   */
#include "ast.h"                       /* abstract syntax tree              */
#include "import.h"                    /* imported packages and classes     */
#include "lex.h"                       /* lexical analyzer                  */
#include "semact.h"                    /* semantic actions                  */
#include "listing.h"                   /* source and error listings         */
#include "chartab.h"                   /* character type table              */

#ifdef PLUGIN
#define fprintf plugin_fprintf
#define fputs   plugin_fputs
#endif

/* performance tuning constants */

#define SEM_BLOCK_SIZE      50         /* semantic stack block size         */

/* semantic stack */

#define SEM_AST      0                 /* stack item is ast                 */
#define SEM_NAMTAB   1                 /* stack item is name                */

struct sem_stack_item {
   int sem_type;                       /* type of stack entry               */
   file_pos_type sem_file_pos;         /* file position of name             */
   namtab_ptr_type sem_namtab_ptr;     /* name table pointer                */
   ast_ptr_type sem_ast_ptr;           /* ast pointer                       */
   ast_ptr_type *sem_ast_tail;         /* tail of ast list                  */
   int sem_token_subclass;             /* subclass of pushed token          */
};

/* macro to allocate a new semantic stack item */

#ifdef TSAFE
#define get_sem ((sem_top < sem_max - 1) ? ++sem_top : alloc_sem(plugin_instance))
#else
#define get_sem ((sem_top < sem_max - 1) ? ++sem_top : alloc_sem())
#endif

/* global data */

static struct sem_stack_item *sem_stack = NULL;
                                       /* semantic stack                    */
static int sem_top = -1;               /*    stack top                      */
static int sem_max = 0;                /*    size of stack                  */
static ast_ptr_type ast_init_tree;     /* constant initialization tree      */
static ast_ptr_type *ast_init_tail;    /* next constant initialization node */
static ast_ptr_type var_init_tree;     /* variable initialization tree      */
static ast_ptr_type *var_init_tail;    /* next initialization node          */
static ast_ptr_type slot_init_tree;    /* slot initialization tree          */
static ast_ptr_type *slot_init_tail;   /* next initialization node          */

/* forward declarations */

static void build_ast(SETL_SYSTEM_PROTO int, char *, struct file_pos_item *);
                                       /* general AST builder               */
static void build_method(SETL_SYSTEM_PROTO int, char *);
                                       /* general method builder            */
static int alloc_sem(SETL_SYSTEM_PROTO_VOID);            
                                       /* allocate a semantic stack block   */
#ifdef TRAPS
static void verify_sem(int, int);      /* verify the type of a stack item   */
#endif
#ifdef DEBUG
static void print_sem(SETL_SYSTEM_PROTO_VOID); 
                                       /* print the semantic stack          */
#endif
#ifdef SHORT_FUNCS
static void semantic_action2(SETL_SYSTEM_PROTO int);   
                                       /* break up semantic actions         */
static void semantic_action3(SETL_SYSTEM_PROTO int);  
                                       /* break up semantic actions         */
#endif

/*\
 *  \function{semantic\_action()}
 *
 *  This function performs a single semantic action and returns.  It is
 *  organized as one big case statement, but the indentation is
 *  unconventional.  We think of this as a set of functions, each one
 *  dealing with a single production.  We indent it that way, rather than
 *  as cases.  Notice that we must be careful to include an explicit
 *  return statement in every case.
\*/

void semantic_action(
   SETL_SYSTEM_PROTO
   int rule)                           /* rule number                       */

{

   switch (rule) {


/*\
 *  \semact{native package specification}
 *
 *  When this rule is invoked, we've seen an entire package specification.
 *  There isn't much we have to do here, since we parse all compilation
 *  units before we generate code for any of them.  Here is what we have
 *  to do:
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.  At that point, we will be at the root of
 *  the procedure table, since we are at the compilation unit level.
 *  \item
 *  Since package specifications are compilation units, we update
 *  compilation unit statistics.
 *  \end{enumerate}
\*/

/*
 *  Rule: <native_package_spec_unit> ::= <native_package_spec_header> <no_body> <proc_declaration_part> <unit_tail>
 */

case 12 :

{

#ifdef DEBUG

   /* print the symbols in the package specification, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* update statistics, and set up for a new compilation unit */

   FILE_ERROR_COUNT += UNIT_ERROR_COUNT;
   FILE_WARNING_COUNT += UNIT_WARNING_COUNT;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{native package specification header}
 *  \semcell{package name}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning a package
 *  specification header.  We use this as a trigger, to do a variety of
 *  things necessary to open a compilation unit.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the package name in the symbol table, as part of the new
 *  scope since we want it to be purged outside of the package.
 *  \item
 *  We set up an empty list for the initialization code tree and the code
 *  body tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <native_package_spec_header> ::= NATIVE PACKAGE identifier ;
 */

case 13 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* initialize the error counts */

   UNIT_ERROR_COUNT = 0;
   UNIT_WARNING_COUNT = 0;

   /* make sure package name is short enough */

   if (strlen(sem_stack[sem_top].sem_namtab_ptr->nt_name) > MAX_UNIT_NAME) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_unit_too_long,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name,
                    MAX_UNIT_NAME);

      return;

   }

   /* open up a new procedure (in this case, a package) */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   new_proc->pr_type = pr_native_package;
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));

   /* install the package specification name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      new_proc,
                      &(sem_stack[sem_top].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      new_proc->pr_symtab_ptr->st_type = sym_package;
      new_proc->pr_symtab_ptr->st_aux.st_proctab_ptr = new_proc;

   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   unit_proctab_ptr = new_proc;

   sem_top--;

   return;

}

/*\
 *  \semact{package specification}
 *
 *  When this rule is invoked, we've seen an entire package specification.
 *  There isn't much we have to do here, since we parse all compilation
 *  units before we generate code for any of them.  Here is what we have
 *  to do:
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.  At that point, we will be at the root of
 *  the procedure table, since we are at the compilation unit level.
 *  \item
 *  Since package specifications are compilation units, we update
 *  compilation unit statistics.
 *  \end{enumerate}
\*/

/*
 *  Rule: <package_spec_unit> ::= <package_spec_header> <data_declaration_part> <no_body> <proc_declaration_part> <unit_tail>
 */

case 15 :

{

#ifdef DEBUG

   /* print the symbols in the package specification, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* update statistics, and set up for a new compilation unit */

   FILE_ERROR_COUNT += UNIT_ERROR_COUNT;
   FILE_WARNING_COUNT += UNIT_WARNING_COUNT;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{package specification header}
 *  \semcell{package name}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning a package
 *  specification header.  We use this as a trigger, to do a variety of
 *  things necessary to open a compilation unit.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the package name in the symbol table, as part of the new
 *  scope since we want it to be purged outside of the package.
 *  \item
 *  We set up an empty list for the initialization code tree and the code
 *  body tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <package_spec_header> ::= PACKAGE identifier ;
 */

case 16 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* initialize the error counts */

   UNIT_ERROR_COUNT = 0;
   UNIT_WARNING_COUNT = 0;

   /* make sure package name is short enough */

   if (strlen(sem_stack[sem_top].sem_namtab_ptr->nt_name) > MAX_UNIT_NAME) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_unit_too_long,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name,
                    MAX_UNIT_NAME);

      return;

   }

   /* open up a new procedure (in this case, a package) */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   new_proc->pr_type = pr_package_spec;
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));

   /* install the package specification name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      new_proc,
                      &(sem_stack[sem_top].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      new_proc->pr_symtab_ptr->st_type = sym_package;
      new_proc->pr_symtab_ptr->st_aux.st_proctab_ptr = new_proc;

   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   unit_proctab_ptr = new_proc;

   sem_top--;

   return;

}

/*\
 *  \semact{package body}
 *
 *  When this rule is invoked, we've seen an entire package body.  There
 *  isn't much we have to do here, since we parse all compilation units
 *  before we generate code for any of them.  Here is what we have to do:
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.  At that point, we will be at the root of
 *  the procedure table, since we are at the compilation unit level.
 *  \item
 *  Since package bodies are compilation units, we update compilation
 *  unit statistics.
 *  \end{enumerate}
\*/

/*
 *  Rule: <package_body_unit> ::= <package_body_header> <use_part> <data_declaration_part> <no_body> <proc_definition_part> <unit_tail>
 */

case 18 :

{

#ifdef DEBUG

   /* print the symbols in the package body, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* update statistics, and set up for a new compilation unit */

   FILE_ERROR_COUNT += UNIT_ERROR_COUNT;
   FILE_WARNING_COUNT += UNIT_WARNING_COUNT;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{package body header}
 *  \semcell{package name}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning a package
 *  body header.  We use this as a trigger, to do a variety of things
 *  necessary to open a compilation unit.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the package name in the symbol table, as part of the new
 *  scope since we want it to be purged outside of the package.
 *  \item
 *  We set up an empty list for the initialization code tree and the code
 *  body tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <package_body_header> ::= PACKAGE BODY identifier ;
 */

case 19 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* initialize the error counts */

   UNIT_ERROR_COUNT = 0;
   UNIT_WARNING_COUNT = 0;

   /* make sure package name is short enough */

   if (strlen(sem_stack[sem_top].sem_namtab_ptr->nt_name) > MAX_UNIT_NAME) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_unit_too_long,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name,
                    MAX_UNIT_NAME);

      return;

   }

   /* open up a new procedure (in this case, a package) */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   new_proc->pr_type = pr_package_body;
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));

   /* install the package specification name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      new_proc,
                      &(sem_stack[sem_top].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      new_proc->pr_symtab_ptr->st_type = sym_package;
      new_proc->pr_symtab_ptr->st_aux.st_proctab_ptr = new_proc;

   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   unit_proctab_ptr = new_proc;

   sem_top--;

   return;

}

/*\
 *  \semact{class specification}
 *
 *  When this rule is invoked, we've seen an entire class specification.
 *  There isn't much we have to do here, since we parse all compilation
 *  units before we generate code for any of them.  Here is what we have
 *  to do:
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.  At that point, we will be at the root of
 *  the procedure table, since we are at the compilation unit level.
 *  \item
 *  Since class specifications are compilation units, we update
 *  compilation unit statistics.
 *  \end{enumerate}
\*/

/*
 *  Rule: <class_spec_unit> ::= <class_spec_header> <inherit_part> <data_declaration_part> <no_body> <proc_declaration_part> <unit_tail>
 */

case 21 :

{

#ifdef DEBUG

   /* print the symbols in the class specification, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* update statistics, and set up for a new compilation unit */

   FILE_ERROR_COUNT += UNIT_ERROR_COUNT;
   FILE_WARNING_COUNT += UNIT_WARNING_COUNT;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{class specification header}
 *  \semcell{class name}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning a class
 *  specification header.  We use this as a trigger, to do a variety of
 *  things necessary to open a compilation unit.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the class name in the symbol table, as part of the new
 *  scope since we want it to be purged outside of the class.
 *  \item
 *  We set up an empty list for the initialization code tree and the code
 *  body tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <class_spec_header> ::= CLASS identifier ;
 */

case 22 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* initialize the error counts */

   UNIT_ERROR_COUNT = 0;
   UNIT_WARNING_COUNT = 0;

   /* make sure class name is short enough */

   if (strlen(sem_stack[sem_top].sem_namtab_ptr->nt_name) > MAX_UNIT_NAME) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_unit_too_long,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name,
                    MAX_UNIT_NAME);

      return;

   }

   /* open up a new procedure (in this case, a class) */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   new_proc->pr_type = pr_class_spec;
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));

   /* install the class specification name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      new_proc,
                      &(sem_stack[sem_top].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      new_proc->pr_symtab_ptr->st_type = sym_class;
      new_proc->pr_symtab_ptr->st_unit_num = 1;
      new_proc->pr_symtab_ptr->st_aux.st_proctab_ptr = new_proc;

   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   unit_proctab_ptr = new_proc;

   sem_top--;

   return;

}

/*\
 *  \semact{class body}
 *
 *  When this rule is invoked, we've seen an entire class body.    There
 *  isn't much we have to do here, since we parse all compilation units
 *  before we generate code for any of them.  Here is what we have to do:
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.  At that point, we will be at the root of
 *  the procedure table, since we are at the compilation unit level.
 *  \item
 *  Since class bodies are compilation units, we update compilation
 *  unit statistics.
 *  \end{enumerate}
\*/

/*
 *  Rule: <class_body_unit> ::= <class_body_header> <use_part> <data_declaration_part> <no_body> <proc_definition_part> <unit_tail>
 */

case 24 :

{

#ifdef DEBUG

   /* print the symbols in the class body, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* update statistics, and set up for a new compilation unit */

   FILE_ERROR_COUNT += UNIT_ERROR_COUNT;
   FILE_WARNING_COUNT += UNIT_WARNING_COUNT;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{class body header}
 *  \semcell{class name}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning a class
 *  body header.  We use this as a trigger, to do a variety of things
 *  necessary to open a compilation unit.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the class name in the symbol table, as part of the new
 *  scope since we want it to be purged outside of the class.
 *  \item
 *  We set up an empty list for the initialization code tree and the code
 *  body tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <class_body_header> ::= CLASS BODY identifier ;
 */

case 25 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* initialize the error counts */

   UNIT_ERROR_COUNT = 0;
   UNIT_WARNING_COUNT = 0;

   /* make sure class name is short enough */

   if (strlen(sem_stack[sem_top].sem_namtab_ptr->nt_name) > MAX_UNIT_NAME) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_unit_too_long,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name,
                    MAX_UNIT_NAME);

      return;

   }

   /* open up a new procedure (in this case, a class) */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   new_proc->pr_type = pr_class_body;
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));

   /* install the class specification name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      new_proc,
                      &(sem_stack[sem_top].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      new_proc->pr_symtab_ptr->st_type = sym_class;
      new_proc->pr_symtab_ptr->st_unit_num = 1;
      new_proc->pr_symtab_ptr->st_aux.st_proctab_ptr = new_proc;

   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   unit_proctab_ptr = new_proc;

   sem_top--;

   return;

}

/*\
 *  \semact{process specification}
 *
 *  When this rule is invoked, we've seen an entire process specification.
 *  There isn't much we have to do here, since we parse all compilation
 *  units before we generate code for any of them.  Here is what we have
 *  to do:
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.  At that point, we will be at the root of
 *  the procedure table, since we are at the compilation unit level.
 *  \item
 *  Since process specifications are compilation units, we update
 *  compilation unit statistics.
 *  \end{enumerate}
\*/

/*
 *  Rule: <process_spec_unit> ::= <process_spec_header> <data_declaration_part> <no_body> <proc_declaration_part> <unit_tail>
 */

case 27 :

{

#ifdef DEBUG

   /* print the symbols in the process specification, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* update statistics, and set up for a new compilation unit */

   FILE_ERROR_COUNT += UNIT_ERROR_COUNT;
   FILE_WARNING_COUNT += UNIT_WARNING_COUNT;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{process specification header}
 *  \semcell{process name}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning a process
 *  specification header.  We use this as a trigger, to do a variety of
 *  things necessary to open a compilation unit.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the process name in the symbol table, as part of the new
 *  scope since we want it to be purged outside of the process.
 *  \item
 *  We set up an empty list for the initialization code tree and the code
 *  body tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <process_spec_header> ::= PROCESS CLASS identifier ;
 */

case 28 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* initialize the error counts */

   UNIT_ERROR_COUNT = 0;
   UNIT_WARNING_COUNT = 0;

   /* make sure process name is short enough */

   if (strlen(sem_stack[sem_top].sem_namtab_ptr->nt_name) > MAX_UNIT_NAME) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_unit_too_long,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name,
                    MAX_UNIT_NAME);

      return;

   }

   /* open up a new procedure (in this case, a process) */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   new_proc->pr_type = pr_process_spec;
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));

   /* install the process specification name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      new_proc,
                      &(sem_stack[sem_top].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      new_proc->pr_symtab_ptr->st_type = sym_process;
      new_proc->pr_symtab_ptr->st_unit_num = 1;
      new_proc->pr_symtab_ptr->st_aux.st_proctab_ptr = new_proc;

   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   unit_proctab_ptr = new_proc;

   sem_top--;

   return;

}

/*\
 *  \semact{process body}
 *
 *  When this rule is invoked, we've seen an entire process body.  There
 *  isn't much we have to do here, since we parse all compilation units
 *  before we generate code for any of them.  Here is what we have to do:
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.  At that point, we will be at the root of
 *  the procedure table, since we are at the compilation unit level.
 *  \item
 *  Since process bodies are compilation units, we update compilation
 *  unit statistics.
 *  \end{enumerate}
\*/

/*
 *  Rule: <process_body_unit> ::= <process_body_header> <use_part> <data_declaration_part> <no_body> <proc_definition_part> <unit_tail>
 */

case 30 :

{

#ifdef DEBUG

   /* print the symbols in the process body, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* update statistics, and set up for a new compilation unit */

   FILE_ERROR_COUNT += UNIT_ERROR_COUNT;
   FILE_WARNING_COUNT += UNIT_WARNING_COUNT;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{process body header}
 *  \semcell{process name}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning a process
 *  body header.  We use this as a trigger, to do a variety of things
 *  necessary to open a compilation unit.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the process name in the symbol table, as part of the new
 *  scope since we want it to be purged outside of the process.
 *  \item
 *  We set up an empty list for the initialization code tree and the code
 *  body tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <process_body_header> ::= PROCESS CLASS BODY identifier ;
 */

case 31 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* initialize the error counts */

   UNIT_ERROR_COUNT = 0;
   UNIT_WARNING_COUNT = 0;

   /* make sure process name is short enough */

   if (strlen(sem_stack[sem_top].sem_namtab_ptr->nt_name) > MAX_UNIT_NAME) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_unit_too_long,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name,
                    MAX_UNIT_NAME);

      return;

   }

   /* open up a new procedure (in this case, a process) */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   new_proc->pr_type = pr_process_body;
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));

   /* install the process specification name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      new_proc,
                      &(sem_stack[sem_top].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      new_proc->pr_symtab_ptr->st_type = sym_process;
      new_proc->pr_symtab_ptr->st_unit_num = 1;
      new_proc->pr_symtab_ptr->st_aux.st_proctab_ptr = new_proc;

   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   unit_proctab_ptr = new_proc;

   sem_top--;

   return;

}

/*\
 *  \semact{program}
 *
 *  When this rule is invoked, we've seen an entire program.  There isn't
 *  much we have to do here, since we parse all compilation units before
 *  we generate code for any of them.  Here is what we have to do:
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.  At that point, we will be at the root of
 *  the procedure table, since we are at the compilation unit level.
 *  \item
 *  Since programs are compilation units, we update compilation
 *  unit statistics.
 *  \end{enumerate}
\*/

/*
 *  Rule: <program_unit> ::= <program_header> <use_part> <data_declaration_part> <body> <proc_definition_part> <unit_tail>
 */

case 33 :

{

#ifdef DEBUG

   /* print the symbols in the program, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* update statistics, and set up for a new compilation unit */

   FILE_ERROR_COUNT += UNIT_ERROR_COUNT;
   FILE_WARNING_COUNT += UNIT_WARNING_COUNT;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{program header}
 *  \semcell{program name}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning a program
 *  header.  We use this as a trigger, to do a variety of things
 *  necessary to open a compilation unit.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the program name in the symbol table, as part of the new
 *  scope since we want it to be purged outside of the class.
 *  \item
 *  We set up an empty list for the initialization code tree and the code
 *  body tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <program_header> ::= PROGRAM identifier ;
 */

case 34 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* initialize the error counts */

   UNIT_ERROR_COUNT = 0;
   UNIT_WARNING_COUNT = 0;

   /* make sure program name is short enough */

   if (strlen(sem_stack[sem_top].sem_namtab_ptr->nt_name) > MAX_UNIT_NAME) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_unit_too_long,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name,
                    MAX_UNIT_NAME);

      return;

   }

   /* open up a new procedure (in this case, a program) */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   new_proc->pr_type = pr_program;
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));

   /* install the program name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      new_proc,
                      &(sem_stack[sem_top].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      new_proc->pr_symtab_ptr->st_type = sym_program;
      new_proc->pr_symtab_ptr->st_aux.st_proctab_ptr = new_proc;

   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   unit_proctab_ptr = new_proc;

   sem_top--;

   return;

}

/*\
 *  \semact{imported packages}
 *  \semcell{package name}
 *  \sembottom
 *
 *  This rule adds a package name to the list of imported packages.  We
 *  don't actually look up the packages in the library yet -- there is no
 *  need.  Since we are not trying to match the symbol table with the
 *  abstract syntax tree yet we can defer loading imported packages until
 *  we do so.
\*/

/*
 *  Rule: <use_item> ::= identifier
 */

case 41 :

{
import_ptr_type *import_ptr;           /* used to loop over import list     */
symtab_ptr_type symtab_ptr;            /* imported package symbol           */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* search for the package in the current imported item list */

   for (import_ptr = &(curr_proctab_ptr->pr_import_list);
        *import_ptr != NULL &&
           (*import_ptr)->im_namtab_ptr != sem_stack[sem_top].sem_namtab_ptr;
        import_ptr = &((*import_ptr)->im_next));

   /* if we found it, error */

   if (*import_ptr != NULL) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_dup_use,
                    sem_stack[sem_top].sem_namtab_ptr->nt_name);

      return;

   }
   else {

      /* otherwise add it to the list */

      *import_ptr = get_import(SETL_SYSTEM_VOID);
      (*import_ptr)->im_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;

      /* install the package name */

      symtab_ptr = enter_symbol(SETL_SYSTEM
                                sem_stack[sem_top].sem_namtab_ptr,
                                curr_proctab_ptr,
                                &(sem_stack[sem_top].sem_file_pos));

      if (symtab_ptr != NULL) {

         symtab_ptr->st_type = sym_use;
         symtab_ptr->st_aux.st_import_ptr = *import_ptr;
         (*import_ptr)->im_symtab_ptr = symtab_ptr;

      }
   }

   /* pop the name off of the semantic stack */

   sem_top--;

   return;

}

/*\
 *  \semact{inherited classes}
 *  \semcell{superclass name}
 *  \sembottom
 *
 *  This rule adds a superclass name to the list of inherited classes.  We
 *  don't actually look up the classes in the library yet -- there is no
 *  need.  Since we are not trying to match the symbol table with the
 *  abstract syntax tree yet we can defer loading inherited classes until
 *  we do so.
\*/

/*
 *  Rule: <inherit_item> ::= identifier
 */

case 48 :

{
import_ptr_type *import_ptr;           /* used to loop over import list     */
symtab_ptr_type symtab_ptr;            /* inherited class symbol            */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* search for the class in the current imported item list */

   for (import_ptr = &(curr_proctab_ptr->pr_inherit_list);
        *import_ptr != NULL &&
           (*import_ptr)->im_namtab_ptr != sem_stack[sem_top].sem_namtab_ptr;
        import_ptr = &((*import_ptr)->im_next));

   /* if we found it, error */

   if (*import_ptr != NULL) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    "Class %s is already inherited",
                    sem_stack[sem_top].sem_namtab_ptr->nt_name);

      return;

   }
   else {

      /* otherwise add it to the list */

      *import_ptr = get_import(SETL_SYSTEM_VOID);
      (*import_ptr)->im_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
      (*import_ptr)->im_inherited = YES;

      /* install the class name */

      symtab_ptr = enter_symbol(SETL_SYSTEM
                                sem_stack[sem_top].sem_namtab_ptr,
                                curr_proctab_ptr,
                                &(sem_stack[sem_top].sem_file_pos));

      if (symtab_ptr != NULL) {

         symtab_ptr->st_type = sym_inherit;
         symtab_ptr->st_aux.st_import_ptr = *import_ptr;
         (*import_ptr)->im_symtab_ptr = symtab_ptr;

      }

      /* append a call to the class initialization function */

      build_ast(SETL_SYSTEM ast_namtab,"",&(sem_stack[sem_top].sem_file_pos));
      sem_stack[sem_top].sem_ast_ptr->ast_child.ast_namtab_ptr =
         sem_stack[sem_top - 1].sem_namtab_ptr;
      build_ast(SETL_SYSTEM ast_namtab,"",&(sem_stack[sem_top].sem_file_pos));
      sem_stack[sem_top].sem_ast_ptr->ast_child.ast_namtab_ptr =
         method_name[m_initobj];
      build_ast(SETL_SYSTEM ast_dot,"11",&(sem_stack[sem_top].sem_file_pos));
      build_ast(SETL_SYSTEM ast_list,"",&(sem_stack[sem_top].sem_file_pos));
      build_ast(SETL_SYSTEM ast_of,"11",&(sem_stack[sem_top].sem_file_pos));
      *slot_init_tail = sem_stack[sem_top].sem_ast_ptr;
      slot_init_tail = &((*slot_init_tail)->ast_next);

   }

   /* pop the name off of the semantic stack */

   sem_top--;

   return;

}

/*\
 *  \semact{procedure}
 *
 *  When this rule is invoked, we've seen an entire procedure.  All we
 *  have to do is print the symbol table and pop the procedure table.
\*/

/*
 *  Rule: <procedure_unit> ::= <procedure_header> ; <data_declaration_part> <body> <proc_definition_part> <unit_tail>
 */

case 58 :

{

#ifdef DEBUG

   /* print the symbols in the procedure, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{procedure header}
 *
 *  Procedure headers are quite different from compilation unit headers.
 *  For one thing, they might have lists of formal parameters.  The more
 *  significant difference is that when used in a package specification,
 *  there will be no following procedure code.  For that reason,
 *  procedure headers are split up into several parts, so that we can
 *  perform actions at various points in header.  At this point, we've
 *  seen an entire procedure header.  If we are processing a package
 *  specification, this is also the end of the procedure.  We perform the
 *  following {\em iff} the enclosing unit is a package specification.
 *
 *  \begin{enumerate}
 *  \item
 *  If desired, we print the symbol table.  By the time we reach this
 *  rule, we should have already printed and purged the abstract syntax
 *  tree.
 *  \item
 *  We pop the procedure table.
 *  \end{enumerate}
\*/

/*
 *  Rule: <procedure_header> ::= <procedure_name> <parameter_part>
 */

case 59 :

{

   /*
    *  if we are processing a package specification, we've finished a
    *  procedure
    */

   if (unit_proctab_ptr->pr_type != pr_package_spec &&
       unit_proctab_ptr->pr_type != pr_class_spec &&
       unit_proctab_ptr->pr_type != pr_native_package &&
       unit_proctab_ptr->pr_type != pr_process_spec)
      return;

#ifdef DEBUG

   /* print the symbols in the procedure, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{procedure name}
 *  \semcell{procedure name}
 *  \semcell{procedure keyword}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning the name
 *  portion of a procedure header.  At this point, we want to open up a
 *  new scope, since formal parameter names are internal to a procedure.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the procedure name in the symbol table, as part of the
 *  enclosing procedure.
 *  \item
 *  We set up an empty list for the initialization code tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <procedure_name> ::= PROCEDURE identifier
 */

case 60 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* open up a new procedure */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;

   if (unit_proctab_ptr->pr_type == pr_class_spec ||
       unit_proctab_ptr->pr_type == pr_class_body ||
       unit_proctab_ptr->pr_type == pr_process_spec ||
       unit_proctab_ptr->pr_type == pr_process_body) {

      new_proc->pr_type = pr_method;
      new_proc->pr_method_code =
         sem_stack[sem_top].sem_namtab_ptr->nt_method_code;

   }
   else {
      new_proc->pr_type = pr_procedure;
   }
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top - 1].sem_file_pos));

   /* install the procedure name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      sem_stack[sem_top].sem_namtab_ptr,
                      curr_proctab_ptr,
                      &(sem_stack[sem_top - 1].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      if (new_proc->pr_type == pr_method) {
         (new_proc->pr_symtab_ptr)->st_type = sym_method;
         (new_proc->pr_symtab_ptr)->st_slot_num =
            new_proc->pr_method_code;
         (new_proc->pr_symtab_ptr)->st_class = unit_proctab_ptr;
      }
      else {
         (new_proc->pr_symtab_ptr)->st_type = sym_procedure;
         (new_proc->pr_symtab_ptr)->st_slot_num = -1;
      }
      (new_proc->pr_symtab_ptr)->st_aux.st_proctab_ptr = new_proc;
      (new_proc->pr_symtab_ptr)->st_has_rvalue = YES;
      (new_proc->pr_symtab_ptr)->st_is_initialized = YES;
      (new_proc->pr_symtab_ptr)->st_needs_stored = YES;
      (new_proc->pr_symtab_ptr)->st_is_declared = YES;
      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_native_package || 
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_process_spec)
         (new_proc->pr_symtab_ptr)->st_is_public = YES;

   }

   /* install an empty list as initialization code */

   if (unit_proctab_ptr->pr_type != pr_package_spec &&
       unit_proctab_ptr->pr_type != pr_native_package &&
       unit_proctab_ptr->pr_type != pr_class_spec &&
       unit_proctab_ptr->pr_type != pr_process_spec) {

      build_ast(SETL_SYSTEM ast_list,"",NULL);
      ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
      sem_top--;
      ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
      build_ast(SETL_SYSTEM ast_list,"",NULL);
      slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
      sem_top--;
      slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
      var_init_tree = NULL;
      var_init_tail = &var_init_tree;

   }

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;
   sem_top -= 2;

   return;

}

/*\
 *  \semact{default formal parameter declaration}
 *  \semcell{formal name}
 *  \sembottom
 *
 *  A declaration of a formal parameter is almost identical to a variable
 *  declaration.  The formal paramters of a procedure are just the first
 *  {\em n} symbols in the procedure's local symbol table, where {\em n}
 *  is the number of formals.  All we have to do here is declare a
 *  variable, and bump the count of formal parameters for a procedure.
 *
 *  By default, a formal parameter is read only.
\*/

/*
 *  Rule: <parameter_spec> ::= identifier
 */

case 68 :

{
symtab_ptr_type symtab_ptr;            /* formal parameter pointer          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top].sem_file_pos));

   if (symtab_ptr != NULL) {

      symtab_ptr->st_type = sym_id;
      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_has_rvalue = YES;
      symtab_ptr->st_is_rparam = YES;
      symtab_ptr->st_needs_stored = YES;
      symtab_ptr->st_is_declared = YES;

   }

   curr_proctab_ptr->pr_formal_count++;
   sem_top--;

   return;

}

/*\
 *  \semact{read-only formal parameter declaration}
 *  \semcell{formal name}
 *  \sembottom
 *
 *  A declaration of a formal parameter is almost identical to a variable
 *  declaration.  The formal paramters of a procedure are just the first
 *  {\em n} symbols in the procedure's local symbol table, where {\em n}
 *  is the number of formals.  All we have to do here is declare a
 *  variable, and bump the count of formal parameters for a procedure.
\*/

/*
 *  Rule: <parameter_spec> ::= RD identifier
 */

case 69 :

{
symtab_ptr_type symtab_ptr;            /* formal parameter pointer          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top].sem_file_pos));

   if (symtab_ptr != NULL) {

      symtab_ptr->st_type = sym_id;
      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_has_rvalue = YES;
      symtab_ptr->st_is_rparam = YES;
      symtab_ptr->st_needs_stored = YES;
      symtab_ptr->st_is_declared = YES;

   }

   curr_proctab_ptr->pr_formal_count++;
   sem_top--;

   return;

}

/*\
 *  \semact{write-only formal parameter declaration}
 *  \semcell{formal name}
 *  \sembottom
 *
 *  A declaration of a formal parameter is almost identical to a variable
 *  declaration.  The formal paramters of a procedure are just the first
 *  {\em n} symbols in the procedure's local symbol table, where {\em n}
 *  is the number of formals.  All we have to do here is declare a
 *  variable, and bump the count of formal parameters for a procedure.
\*/

/*
 *  Rule: <parameter_spec> ::= WR identifier
 */

case 70 :

{
symtab_ptr_type symtab_ptr;            /* formal parameter pointer          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* we don't allow write parameters on methods */

   if (unit_proctab_ptr->pr_type == pr_class_spec ||
       unit_proctab_ptr->pr_type == pr_class_body ||
       unit_proctab_ptr->pr_type == pr_process_spec ||
       unit_proctab_ptr->pr_type == pr_process_body) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    "Write parameters are not allowed in methods => %s",
                    sem_stack[sem_top].sem_namtab_ptr->nt_name);

      return;

   }

   /* enter and flag the symbol */

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top].sem_file_pos));

   if (symtab_ptr != NULL) {

      symtab_ptr->st_type = sym_id;
      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_has_rvalue = YES;
      symtab_ptr->st_is_wparam = YES;
      symtab_ptr->st_needs_stored = YES;
      symtab_ptr->st_is_declared = YES;

   }

   curr_proctab_ptr->pr_formal_count++;
   curr_proctab_ptr->pr_symtab_ptr->st_has_rvalue = NO;
   sem_top--;

   return;

}

/*\
 *  \semact{read-write formal parameter declaration}
 *  \semcell{formal name}
 *  \sembottom
 *
 *  A declaration of a formal parameter is almost identical to a variable
 *  declaration.  The formal paramters of a procedure are just the first
 *  {\em n} symbols in the procedure's local symbol table, where {\em n}
 *  is the number of formals.  All we have to do here is declare a
 *  variable, and bump the count of formal parameters for a procedure.
\*/

/*
 *  Rule: <parameter_spec> ::= RW identifier
 */

case 71 :

{
symtab_ptr_type symtab_ptr;            /* formal parameter pointer          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* we don't allow write parameters on methods */

   if (unit_proctab_ptr->pr_type == pr_class_spec ||
       unit_proctab_ptr->pr_type == pr_class_body ||
       unit_proctab_ptr->pr_type == pr_process_spec ||
       unit_proctab_ptr->pr_type == pr_process_body) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    "Write parameters are not allowed in methods => %s",
                    sem_stack[sem_top].sem_namtab_ptr->nt_name);

      return;

   }

   /* enter and flag the symbol */

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top].sem_file_pos));

   if (symtab_ptr != NULL) {

      symtab_ptr->st_type = sym_id;
      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_has_rvalue = YES;
      symtab_ptr->st_is_rparam = YES;
      symtab_ptr->st_is_wparam = YES;
      symtab_ptr->st_needs_stored = YES;
      symtab_ptr->st_is_declared = YES;

   }

   curr_proctab_ptr->pr_formal_count++;
   curr_proctab_ptr->pr_symtab_ptr->st_has_rvalue = NO;
   sem_top--;

   return;

}

/*\
 *  \semact{method headers}
 *
 *  This rule shields the following ones, making sure that method headers
 *  are only used within a class body.
\*/

/*
 *  Rule: <procedure_header> ::= <method_header>
 */

case 73 :

{

   /* make sure this operator has a method */


   if (((curr_proctab_ptr->pr_parent)->pr_type != pr_class_body)&&
       (((curr_proctab_ptr->pr_parent)->pr_type!= pr_package_body)||
	((strncmp(((curr_proctab_ptr->pr_parent)->pr_namtab_ptr)->nt_name,"ERROR_EXTENSION",15)!=0)))) {

      error_message(SETL_SYSTEM NULL,"Operator methods are only valid in class bodies");

   }

   return;

}

/*\
 *  \semact{method headers}
 *  \semcell{{\em varies}}
 *  \sembottom
 *
 *  \setl\ allows methods to override many types of its syntax.  The
 *  following rules allow the declaration of methods corresponding to
 *  those syntactic structures.  Rather than duplicate similar code a
 *  variety of places, we have a general function to handle all of these
 *  cases.
\*/

/*
 *  Rule: <method_header> ::= PROCEDURE SELF addop identifier
 */

case 74 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass],"0S01");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE identifier addop SELF
 */

case 75 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass]+1,
                "010S");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF - identifier
 */

case 76 :

{

   /* build the method */

   build_method(SETL_SYSTEM
                m_sub,"0S01");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE identifier - SELF
 */

case 77 :

{

   /* build the method */

   build_method(SETL_SYSTEM
                m_sub_r,"010S");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF mulop identifier
 */

case 78 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass],"0S01");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE identifier mulop SELF
 */

case 79 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass]+1,
                "010S");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF ** identifier
 */

case 80 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass],"0S01");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE identifier ** SELF
 */

case 81 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass]+1,
                "010S");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF relop identifier
 */

case 82 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass],"0S01");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE identifier relop SELF
 */

case 83 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {


      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass]+1,
                "010S");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE fromop SELF
 */

case 84 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass],"00S");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE unop SELF
 */

case 85 :

{

   /* make sure this operator has a method */

   if (tok_mcode[sem_stack[sem_top - 1].sem_token_subclass] < 0) {

      error_message(SETL_SYSTEM &sem_stack[sem_top - 1].sem_file_pos,
                    "No method for %s operator",
                    sem_stack[sem_top - 1].sem_namtab_ptr->nt_name);

      return;

   }

   /* build the method */

   build_method(SETL_SYSTEM
                tok_mcode[sem_stack[sem_top - 1].sem_token_subclass],"00S");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE - SELF
 */

case 86 :

{

   /* build the method */

   build_method(SETL_SYSTEM
                m_uminus,"00S");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF ( identifier )
 */

case 87 :

{

   build_method(SETL_SYSTEM
                m_of,"0S1");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF { identifier }
 */

case 88 :

{

   build_method(SETL_SYSTEM
                m_ofa,"0S1");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF ( identifier .. identifier )
 */

case 89 :

{

   build_method(SETL_SYSTEM
                m_slice,"0S11");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF ( identifier .. )
 */

case 90 :

{

   build_method(SETL_SYSTEM
                m_end,"0S1");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF ( identifier ) := identifier
 */

case 91 :

{

   build_method(SETL_SYSTEM
                m_sof,"0S101");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF { identifier } := identifier
 */

case 92 :

{

   build_method(SETL_SYSTEM
                m_sofa,"0S101");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF ( identifier .. identifier ) := identifier
 */

case 93 :

{

   build_method(SETL_SYSTEM
                m_sslice,"0S1101");

   return;

}

/*
 *  Rule: <method_header> ::= PROCEDURE SELF ( identifier .. ) := identifier
 */

case 94 :

{

   build_method(SETL_SYSTEM
                m_send,"0S101");

   return;

}

/*\
 *  \semact{procedure / program / package tail identifier}
 *  \semcell{unit name}
 *  \sembottom
 *
 *  When this action is invoked, we found the tail identifier.  We need
 *  to make sure the name matches the name given in the header.
\*/

/*
 *  Rule: <optional_unit_name> ::= identifier
 */

case 96 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   if (sem_stack[sem_top].sem_namtab_ptr->nt_name !=
       (curr_proctab_ptr->pr_namtab_ptr)->nt_name) {

      warning_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
          msg_bad_tail,
          sem_stack[sem_top].sem_namtab_ptr->nt_name,
          (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

   }

   sem_top--;

   return;

}

/*\
 *  \semact{constant declaration}
 *  \semcell{expression}
 *  \semcell{assignment symbol}
 *  \semcell{identifier}
 *  \sembottom
 *
 *  This rule handles a constant declaration.  We enter the symbol into
 *  the symbol table, and append an assignment to the initialization
 *  tree.
\*/

/*
 *  Rule: <const_declaration> ::= identifier := <expression>
 */

case 110 :

{
symtab_ptr_type symtab_ptr;            /* constant's symbol table entry     */
ast_ptr_type const_ptr;                /* constant subtree                  */
ast_ptr_type assign_ptr;               /* constant initialization           */

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_NAMTAB);
   verify_sem(sem_top - 2,SEM_NAMTAB);

#endif

   /* first, we declare the symbol as a constant */

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top - 2].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top - 2].sem_file_pos));

   /* if we didn't have a duplicate declaration ... */

   if (symtab_ptr != NULL) {

      /* set up the constant's symbol table entry */

      symtab_ptr->st_type = sym_id;
      symtab_ptr->st_has_rvalue = YES;

      /* we always store names in package specifications */

      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_body)
         symtab_ptr->st_needs_stored = YES;

      symtab_ptr->st_is_declared = YES;
      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_process_spec)
         symtab_ptr->st_is_public = YES;

      /* construct a symbol tree */

      const_ptr = get_ast(SETL_SYSTEM_VOID);
      const_ptr->ast_type = ast_symtab;
      const_ptr->ast_child.ast_symtab_ptr = symtab_ptr;
      const_ptr->ast_next = sem_stack[sem_top].sem_ast_ptr;
      copy_file_pos(&(const_ptr->ast_file_pos),
                    &(sem_stack[sem_top - 2].sem_file_pos));

      /* construct a constant assignment tree */

      assign_ptr = get_ast(SETL_SYSTEM_VOID);
      assign_ptr->ast_type = ast_cassign;
      assign_ptr->ast_child.ast_child_ast = const_ptr;
      copy_file_pos(&(assign_ptr->ast_file_pos),
                    &(sem_stack[sem_top - 2].sem_file_pos));

      /* append the constant assignment to the initialization code */

      *ast_init_tail = assign_ptr;
      ast_init_tail = &(assign_ptr->ast_next);

   }

   /* pop the name and expression off the stack */

   sem_top -= 3;

   return;

}

/*\
 *  \semact{selector declaration}
 *  \semcell{literal}
 *  \semcell{identifier}
 *  \sembottom
 *
 *  This rule handles a selector declaration.  We have merged all
 *  literals into a single token class, but we only accept integers as
 *  selectors, so we make sure the literal is an integer here.
\*/

/*
 *  Rule: <sel_declaration> ::= identifier ( literal )
 */

case 115 :

{
symtab_ptr_type sel_ptr;               /* selector symbol table entry       */
symtab_ptr_type index_ptr;             /* index symbol table entry          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);
   verify_sem(sem_top - 1,SEM_NAMTAB);

#endif

   /* first we verify that the index is an integer */

   index_ptr = sem_stack[sem_top].sem_namtab_ptr->nt_symtab_ptr;
   if (index_ptr->st_type != sym_integer) {

      error_message(SETL_SYSTEM &sem_stack[sem_top].sem_file_pos,
                    msg_bad_selector);

      return;

   }

   /* we declare the symbol as a selector */

   sel_ptr = enter_symbol(SETL_SYSTEM
                          sem_stack[sem_top - 1].sem_namtab_ptr,
                          curr_proctab_ptr,
                          &(sem_stack[sem_top - 1].sem_file_pos));

   /* if we didn't have a duplicate declaration ... */

   if (sel_ptr != NULL) {

      /* set up the selector's symbol table entry */

      sel_ptr->st_type = sym_selector;
      sel_ptr->st_aux.st_selector_ptr = index_ptr;

      /* we always store names in package specifications */

      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_body)
         sel_ptr->st_needs_stored = YES;

      sel_ptr->st_is_declared = YES;
      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_process_spec)
         sel_ptr->st_is_public = YES;

   }

   /* pop the name and literal off the stack */

   sem_top -= 2;

   return;

}

#ifdef SHORT_FUNCS

default :

   semantic_action2(SETL_SYSTEM rule);
   return;

}}


static void semantic_action2(
   SETL_SYSTEM_PROTO
   int rule)                           /* rule number                       */

{

   switch (rule) {

#endif

/*\
 *  \semact{variable declaration}
 *  \semcell{identifier}
 *  \sembottom
 *
 *  This rule handles a variable declaration.  We just enter the symbol
 *  into the symbol table.
\*/

/*
 *  Rule: <var_declaration> ::= identifier
 */

case 121 :

{
symtab_ptr_type symtab_ptr;            /* variable's symbol table entry     */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* first, we declare the symbol as a variable */

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top].sem_file_pos));

   /* if we didn't have a duplicate declaration ... */

   if (symtab_ptr != NULL) {

      /* set up the variable's symbol table entry */

      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_has_rvalue = YES;

      if (curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_spec ||
          curr_proctab_ptr->pr_type == pr_process_body) {

         symtab_ptr->st_type = sym_slot;
         symtab_ptr->st_slot_num = m_user;
         symtab_ptr->st_class = unit_proctab_ptr;

      }
      else {

         symtab_ptr->st_type = sym_id;

      }

      /* we always store names in package specifications */

      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_spec ||
          curr_proctab_ptr->pr_type == pr_process_body)
         symtab_ptr->st_needs_stored = YES;

      symtab_ptr->st_is_declared = YES;
      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_class_spec || 
          curr_proctab_ptr->pr_type == pr_process_spec)
         symtab_ptr->st_is_public = YES;

   }

   /* pop the name off the stack */

   sem_top--;

   return;

}

/*\
 *  \semact{variable declaration}
 *  \semcell{expression}
 *  \semcell{assignment symbol}
 *  \semcell{identifier}
 *  \sembottom
 *
 *  This rule handles a variable declaration.  We enter the symbol into
 *  the symbol table, and append an assignment to the code initialization
 *  tree.  Note that we are somewhat restrictive in the expressions we
 *  allow for initialization.
\*/

/*
 *  Rule: <var_declaration> ::= identifier := <expression>
 */

case 122 :

{
symtab_ptr_type symtab_ptr;            /* variable's symbol table entry     */
ast_ptr_type var_ptr;                  /* variable subtree                  */
ast_ptr_type assign_ptr;               /* variable initialization           */

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_NAMTAB);
   verify_sem(sem_top - 2,SEM_NAMTAB);

#endif

   /* first, we declare the symbol as a variable */

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top - 2].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top - 2].sem_file_pos));

   /* if we didn't have a duplicate declaration ... */

   if (symtab_ptr != NULL) {

      /* set up the variable's symbol table entry */

      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_has_rvalue = YES;

      /* we always store names in package specifications */

      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_spec ||
          curr_proctab_ptr->pr_type == pr_process_body)
         symtab_ptr->st_needs_stored = YES;

      symtab_ptr->st_is_declared = YES;
      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_process_spec)
         symtab_ptr->st_is_public = YES;

      /* construct a symbol tree */

      var_ptr = get_ast(SETL_SYSTEM_VOID);
      var_ptr->ast_type = ast_symtab;
      var_ptr->ast_child.ast_symtab_ptr = symtab_ptr;
      var_ptr->ast_next = sem_stack[sem_top].sem_ast_ptr;
      copy_file_pos(&(var_ptr->ast_file_pos),
                    &(sem_stack[sem_top - 2].sem_file_pos));

      /* construct a variable assignment tree */

      assign_ptr = get_ast(SETL_SYSTEM_VOID);
      assign_ptr->ast_type = ast_assign;
      assign_ptr->ast_child.ast_child_ast = var_ptr;
      copy_file_pos(&(assign_ptr->ast_file_pos),
                    &(sem_stack[sem_top - 2].sem_file_pos));

      /* append the variable assignment to the initialization code */

      if (curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_spec ||
          curr_proctab_ptr->pr_type == pr_process_body) {

         symtab_ptr->st_type = sym_slot;
         symtab_ptr->st_slot_num = m_user;
         symtab_ptr->st_class = unit_proctab_ptr;
         *slot_init_tail = assign_ptr;
         slot_init_tail = &(assign_ptr->ast_next);

      }
      else {

         symtab_ptr->st_type = sym_id;
         *var_init_tail = assign_ptr;
         var_init_tail = &(assign_ptr->ast_next);

      }
   }

   /* pop the name and expression off the stack */

   sem_top -= 3;

   return;

}

/*\
 *  \semact{variable declaration}
 *  \semcell{identifier}
 *  \sembottom
 *
 *  This rule handles a variable declaration.  We just enter the symbol
 *  into the symbol table.
\*/

/*
 *  Rule: <class_var_decl> ::= identifier
 */

case 127 :

{
symtab_ptr_type symtab_ptr;            /* variable's symbol table entry     */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   /* first, we declare the symbol as a variable */

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top].sem_file_pos));

   /* if we didn't have a duplicate declaration ... */

   if (symtab_ptr != NULL) {

      /* set up the variable's symbol table entry */

      symtab_ptr->st_type = sym_id;
      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_has_rvalue = YES;

      /* we always store names in package specifications */

      if (curr_proctab_ptr->pr_type == pr_package_spec || 
          curr_proctab_ptr->pr_type == pr_native_package ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_spec ||
          curr_proctab_ptr->pr_type == pr_process_body)
         symtab_ptr->st_needs_stored = YES;

      symtab_ptr->st_is_declared = YES;
      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_process_spec)
         symtab_ptr->st_is_public = YES;

   }

   /* pop the name off the stack */

   sem_top--;

   return;

}

/*\
 *  \semact{variable declaration}
 *  \semcell{expression}
 *  \semcell{assignment symbol}
 *  \semcell{identifier}
 *  \sembottom
 *
 *  This rule handles a variable declaration.  We enter the symbol into
 *  the symbol table, and append an assignment to the code initialization
 *  tree.  Note that we are somewhat restrictive in the expressions we
 *  allow for initialization.
\*/

/*
 *  Rule: <class_var_decl> ::= identifier := <expression>
 */

case 128 :

{
symtab_ptr_type symtab_ptr;            /* variable's symbol table entry     */
ast_ptr_type var_ptr;                  /* variable subtree                  */
ast_ptr_type assign_ptr;               /* variable initialization           */

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_NAMTAB);
   verify_sem(sem_top - 2,SEM_NAMTAB);

#endif

   /* first, we declare the symbol as a variable */

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top - 2].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top - 2].sem_file_pos));

   /* if we didn't have a duplicate declaration ... */

   if (symtab_ptr != NULL) {

      /* set up the variable's symbol table entry */

      symtab_ptr->st_type = sym_id;
      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_has_rvalue = YES;

      /* we always store names in package specifications */

      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_spec ||
          curr_proctab_ptr->pr_type == pr_process_body)
         symtab_ptr->st_needs_stored = YES;

      symtab_ptr->st_is_declared = YES;
      if (curr_proctab_ptr->pr_type == pr_package_spec ||
          curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_process_spec)
         symtab_ptr->st_is_public = YES;

      /* construct a symbol tree */

      var_ptr = get_ast(SETL_SYSTEM_VOID);
      var_ptr->ast_type = ast_symtab;
      var_ptr->ast_child.ast_symtab_ptr = symtab_ptr;
      var_ptr->ast_next = sem_stack[sem_top].sem_ast_ptr;
      copy_file_pos(&(var_ptr->ast_file_pos),
                    &(sem_stack[sem_top - 2].sem_file_pos));

      /* construct a variable assignment tree */

      assign_ptr = get_ast(SETL_SYSTEM_VOID);
      assign_ptr->ast_type = ast_assign;
      assign_ptr->ast_child.ast_child_ast = var_ptr;
      copy_file_pos(&(assign_ptr->ast_file_pos),
                    &(sem_stack[sem_top - 2].sem_file_pos));

      /* append the variable assignment to the initialization code */

      *var_init_tail = assign_ptr;
      var_init_tail = &(assign_ptr->ast_next);

   }

   /* pop the name and expression off the stack */

   sem_top -= 3;

   return;

}

/*\
 *  \semact{procedure / program / package bodies}
 *
 *  The following two statements correspond to missing bodies.  We create
 *  a null statement list, and drop through to the more general body
 *  case.
\*/

/*
 *  Rule: <no_body> ::= %empty
 */

case 130 :


/*
 *  Rule: <body> ::= %empty
 */

case 131 :

{

   /* construct a dummy body */

   build_ast(SETL_SYSTEM ast_list,"",NULL);

}

/*\
 *  \semact{procedure / program / package bodies}
 *  \semcell{statement list}
 *  \sembottom
 *
 *  When this action is invoked, we have gathered up the statements in a
 *  procedure body into a list.  All we have to do is print the list, if
 *  desired, and attach it to the procedure table node.
\*/

/*
 *  Rule: <body> ::= <statement_list>
 */

case 132 :

{
proctab_ptr_type new_proc;             /* initobj procedure                 */

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);

#endif

   /*
    *  If we are processing a procedure, splice in the variable
    *  initialization at the beginning of the body.  Otherwise, tack it
    *  on to the end of the constant initialization code.
    */

   if (curr_proctab_ptr->pr_type == pr_procedure ||
       curr_proctab_ptr->pr_type == pr_method) {

      if (var_init_tree != NULL) {

         *var_init_tail =
            (sem_stack[sem_top].sem_ast_ptr)->ast_child.ast_child_ast;
         (sem_stack[sem_top].sem_ast_ptr)->ast_child.ast_child_ast =
            var_init_tree;

      }
   }
   else {

      if (var_init_tree != NULL) {

         *ast_init_tail = var_init_tree;
         ast_init_tail = var_init_tail;

      }
   }

#ifdef DEBUG

   if (AST_DEBUG) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_ast(SETL_SYSTEM ast_init_tree,"Initialization Tree");
      fputs("\n",DEBUG_FILE);

      if (curr_proctab_ptr->pr_type == pr_class_spec ||
          curr_proctab_ptr->pr_type == pr_class_body ||
          curr_proctab_ptr->pr_type == pr_process_body ||
          curr_proctab_ptr->pr_type == pr_process_body) {

         print_ast(SETL_SYSTEM slot_init_tree,"Slot initialization Tree");
         fputs("\n",DEBUG_FILE);

      }

      print_ast(SETL_SYSTEM sem_stack[sem_top].sem_ast_ptr,"Body Tree");
      fputs("\n",DEBUG_FILE);

   }

#endif

   /*
    *  if we're processing a class body, we create an object
    *  initialization procedure
    */

   if (curr_proctab_ptr->pr_type == pr_class_body ||
       curr_proctab_ptr->pr_type == pr_process_body) {

      /* open up a new procedure */

      new_proc = get_proctab(SETL_SYSTEM_VOID);
      new_proc->pr_parent = curr_proctab_ptr;
      *(curr_proctab_ptr->pr_tail) = new_proc;
      curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
      new_proc->pr_namtab_ptr = method_name[m_initobj];
      new_proc->pr_type = pr_method;
      new_proc->pr_method_code = m_initobj;
      copy_file_pos(&(new_proc->pr_file_pos),
                    &(sem_stack[sem_top].sem_file_pos));

      /* install the procedure name */

      new_proc->pr_symtab_ptr = enter_symbol(SETL_SYSTEM
                                             method_name[m_initobj],
                                             curr_proctab_ptr,
                                             NULL);

      (new_proc->pr_symtab_ptr)->st_type = sym_method;
      (new_proc->pr_symtab_ptr)->st_slot_num = m_initobj;
      (new_proc->pr_symtab_ptr)->st_class = unit_proctab_ptr;
      (new_proc->pr_symtab_ptr)->st_is_public = YES;
      (new_proc->pr_symtab_ptr)->st_aux.st_proctab_ptr = new_proc;
      (new_proc->pr_symtab_ptr)->st_has_rvalue = YES;
      (new_proc->pr_symtab_ptr)->st_needs_stored = YES;
      (new_proc->pr_symtab_ptr)->st_is_declared = YES;

      build_ast(SETL_SYSTEM ast_list,"",NULL);
      store_ast(SETL_SYSTEM &(new_proc->pr_init_code),
                sem_stack[sem_top].sem_ast_ptr);
      sem_top--;

      build_ast(SETL_SYSTEM ast_list,"",NULL);
      store_ast(SETL_SYSTEM &(new_proc->pr_slot_code),
                sem_stack[sem_top].sem_ast_ptr);
      sem_top--;

      store_ast(SETL_SYSTEM &(new_proc->pr_body_code),
                slot_init_tree);
      build_ast(SETL_SYSTEM ast_list,"",NULL);
      slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
      sem_top--;
      slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);

   }

   /* save the AST's in the intermediate file */

   store_ast(SETL_SYSTEM &(curr_proctab_ptr->pr_init_code),
             ast_init_tree);
   store_ast(SETL_SYSTEM &(curr_proctab_ptr->pr_slot_code),
             slot_init_tree);
   store_ast(SETL_SYSTEM &(curr_proctab_ptr->pr_body_code),
             sem_stack[sem_top].sem_ast_ptr);

   sem_top--;

   return;

}

/*\
 *  \semact{statement lists}
 *  \semcell{new statement}
 *  \semcell{statement list}
 *  \sembottom
 *
 *  When this action is invoked, we've just scanned a statement which
 *  must be appended to the current statement list. We use the tail
 *  pointer to update the current tail, then reset the tail pointer.
\*/

/*
 *  Rule: <statement_list> ::= <statement_list> <stmt_or_expression> ;
 */

case 133 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   *(sem_stack[sem_top - 1].sem_ast_tail) =
      sem_stack[sem_top].sem_ast_ptr;
   sem_stack[sem_top - 1].sem_ast_tail =
      &(sem_stack[sem_top].sem_ast_ptr->ast_next);
   sem_top--;

   return;

}

/*\
 *  \semact{first statement in list}
 *  \semcell{statement}
 *  \sembottom
 *
 *  When this action is invoked, we've just scanned the first statement
 *  in a statement list. We have to make it a child of a list node.
\*/

/*
 *  Rule: <statement_list> ::= <stmt_or_expression> ;
 */

case 134 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);

#endif

   build_ast(SETL_SYSTEM ast_list,"1",NULL);
   sem_stack[sem_top].sem_ast_tail =
      &((sem_stack[sem_top].sem_ast_ptr->ast_child.ast_child_ast)->ast_next);

   return;

}

/*\
 *  \semact{expression lists}
 *  \semcell{new expression}
 *  \semcell{expression list}
 *  \sembottom
 *
 *  When this action is invoked, we've just scanned an expression which
 *  must be appended to the current expression list. We use the tail
 *  pointer to update the current tail, then reset the tail pointer.
\*/

/*
 *  Rule: <expression_list> ::= <expression_list> , <expression>
 */

case 137 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   *(sem_stack[sem_top - 1].sem_ast_tail) =
      sem_stack[sem_top].sem_ast_ptr;
   sem_stack[sem_top - 1].sem_ast_tail =
      &(sem_stack[sem_top].sem_ast_ptr->ast_next);
   sem_top--;

   return;

}

/*\
 *  \semact{first expression in list}
 *  \semcell{expression}
 *  \sembottom
 *
 *  When this action is invoked, we've just scanned the first expression
 *  in an expression list. We have to make it a child of a list node.
\*/

/*
 *  Rule: <expression_list> ::= <expression>
 */

case 138 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);

#endif

   build_ast(SETL_SYSTEM ast_list,"1",NULL);
   sem_stack[sem_top].sem_ast_tail =
      &((sem_stack[sem_top].sem_ast_ptr->ast_child.ast_child_ast)->ast_next);

   return;

}

/*\
 *  \semact{assignment expression}
 *  \semcell{right expression}
 *  \semcell{assignment operator}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  Generally, we would like to do some error checking here to insure
 *  that the left hand expression is indeed a valid left hand side.  We
 *  can not do that in \setl, however, without type declarations. All we do
 *  here is form an AST, and defer error checking to the next phase.
\*/

/*
 *  Rule: <expression> ::= <left_term> := <expression>
 */

case 139 :

{

   build_ast(SETL_SYSTEM ast_assign,"101",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{assignment operators}
 *  \semcell{right expression}
 *  \semcell{assignment operator}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  To simplify the grammar, we expect the lexical analyzer to merge
 *  binary operators followed by an assignment symbol into a single
 *  token, which we classify as assignment operators.  We merge all of
 *  these into the token class \verb"tok_assignop", and distinguish them
 *  via the token subclass.
 *
 *  The action here is a little complicated.  First we use the assignment
 *  operator to look up the operation type.  Then we copy the left hand
 *  side into that slot, so the stack contains the right hand side
 *  followed by the left hand side twice.  We then assemble a tree for
 *  the right hand side, followed by the assignment.
\*/

/*
 *  Rule: <expression> ::= <left_term> assignop <expression>
 */

case 140 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "101",
             &(sem_stack[sem_top - 1].sem_file_pos));
   build_ast(SETL_SYSTEM ast_assignop,"1",NULL);

   return;

}

/*\
 *  \semact{for loop}
 *  \semcell{LOOP}
 *  \semcell{statement list}
 *  \semcell{LOOP}
 *  \semcell{condition}
 *  \semcell{iterator list}
 *  \semcell{FOR}
 *  \sembottom
 *
 *  For statements iterate over a list of sets, tuples, or strings
 *  executing a statement list for each set of values matching a
 *  condition.
\*/

/*
 *  Rule: <primary> ::= FOR <for_iterator> LOOP <statement_list> END LOOP
 */

case 141 :

{

   sem_stack[sem_top - 4].sem_ast_ptr->ast_type = ast_iter_list;
   build_ast(SETL_SYSTEM ast_for,"011010",&(sem_stack[sem_top - 5].sem_file_pos));

   return;

}

/*\
 *  \semact{for iterator}
 *  \semcell{iterator}
 *  \sembottom
 *
 *  If a for iterator does not have a selection condition we push a null
 *  on the stack.
\*/

/*
 *  Rule: <for_iterator> ::= <expression_list>
 */

case 142 :

{

   build_ast(SETL_SYSTEM ast_null,"",&(sem_stack[sem_top].sem_file_pos));

   return;

}

/*\
 *  \semact{while expression}
 *  \semcell{LOOP}
 *  \semcell{statement list}
 *  \semcell{LOOP}
 *  \semcell{condition}
 *  \semcell{WHILE}
 *  \sembottom
 *
 *  All we do with a while expression is form the AST subtree.
\*/

/*
 *  Rule: <primary> ::= WHILE <expression> LOOP <statement_list> END LOOP
 */

case 144 :

{

   build_ast(SETL_SYSTEM ast_while,"01010",&(sem_stack[sem_top - 4].sem_file_pos));

   return;

}

/*\
 *  \semact{until expression}
 *  \semcell{LOOP}
 *  \semcell{statement list}
 *  \semcell{LOOP}
 *  \semcell{condition}
 *  \semcell{UNTIL}
 *  \sembottom
 *
 *  All we do with an until expression is form the AST subtree.
\*/

/*
 *  Rule: <primary> ::= UNTIL <expression> LOOP <statement_list> END LOOP
 */

case 145 :

{

   build_ast(SETL_SYSTEM ast_until,"01010",&(sem_stack[sem_top - 4].sem_file_pos));

   return;

}

/*\
 *  \semact{loop expression}
 *  \semcell{LOOP}
 *  \semcell{statement list}
 *  \semcell{LOOP}
 *  \sembottom
 *
 *  All we do with a loop expression is form the AST subtree.
\*/

/*
 *  Rule: <primary> ::= LOOP <statement_list> END LOOP
 */

case 146 :

{

   build_ast(SETL_SYSTEM ast_loop,"010",&(sem_stack[sem_top - 2].sem_file_pos));

   return;

}

/*\
 *  \semact{if expressions}
 *  \semcell{else clause}
 *  \semcell{statement list}
 *  \semcell{condition}
 *  \semcell{IF}
 *  \sembottom
 *
 *  We have incorporated any \verb"ELSEIF" clauses into the \verb"ELSE"
 *  clause already, so all we do here is build the abstract syntax tree.
\*/

/*
 *  Rule: <primary> ::= IF <expression> THEN <statement_list> <opt_else_stmt_clause> END IF
 */

case 147 :

{

   build_ast(SETL_SYSTEM ast_if_stmt,"01110",&(sem_stack[sem_top - 4].sem_file_pos));

   return;

}

/*\
 *  \semact{elseif clauses}
 *  \semcell{else clause}
 *  \semcell{statement list}
 *  \semcell{condition}
 *  \semcell{ELSEIF}
 *  \sembottom
 *
 *  We incorporate any \verb"ELSEIF" clauses into the \verb"ELSE" clause
 *  already, to remove \verb"ELSEIF" from the abstract syntax tree
 *  altogether.
\*/

/*
 *  Rule: <opt_else_stmt_clause> ::= ELSEIF <expression> THEN <statement_list> <opt_else_stmt_clause>
 */

case 148 :

{

   build_ast(SETL_SYSTEM ast_if_stmt,"0111",NULL);

   return;

}

/*\
 *  \semact{missing else clauses}
 *
 *  The higher-level rules count on an \verb"ELSE" clause being present,
 *  so we push a null on the stack if there is no \verb"ELSE" clause.
\*/

/*
 *  Rule: <opt_else_stmt_clause> ::= %empty
 */

case 150 :

{

   build_ast(SETL_SYSTEM ast_null,"",NULL);

   return;

}

/*\
 *  \semact{if expressions}
 *  \semcell{else clause}
 *  \semcell{statement list}
 *  \semcell{condition}
 *  \semcell{IF}
 *  \sembottom
 *
 *  We have incorporated any \verb"ELSEIF" clauses into the \verb"ELSE"
 *  clause already, so all we do here is build the abstract syntax tree.
\*/

/*
 *  Rule: <primary> ::= IF <expression> THEN <expression> <opt_else_expr_clause> END IF
 */

case 151 :

{

   build_ast(SETL_SYSTEM ast_if_expr,"01110",&(sem_stack[sem_top - 4].sem_file_pos));

   return;

}

/*\
 *  \semact{elseif clauses}
 *  \semcell{else clause}
 *  \semcell{statement list}
 *  \semcell{condition}
 *  \semcell{ELSEIF}
 *  \sembottom
 *
 *  We incorporate any \verb"ELSEIF" clauses into the \verb"ELSE" clause
 *  already, to remove \verb"ELSEIF" from the abstract syntax tree
 *  altogether.
\*/

/*
 *  Rule: <opt_else_expr_clause> ::= ELSEIF <expression> THEN <expression> <opt_else_expr_clause>
 */

case 152 :

{

   build_ast(SETL_SYSTEM ast_if_expr,"0111",NULL);

   return;

}

/*\
 *  \semact{missing else clauses}
 *
 *  The higher-level rules count on an \verb"ELSE" clause being present,
 *  so we push a null on the stack if there is no \verb"ELSE" clause.
\*/

/*
 *  Rule: <opt_else_expr_clause> ::= %empty
 */

case 154 :

{

   build_ast(SETL_SYSTEM ast_null,"",NULL);

   return;

}

/*\
 *  \semact{case expression}
 *  \semcell{CASE}
 *  \semcell{otherwise clause}
 *  \semcell{statement list}
 *  \semcell{choice value}
 *  \semcell{CASE}
 *  \sembottom
 *
 *  Case expressions are difficult for the code generator, but all we do
 *  here is build an abstract syntax tree.
\*/

/*
 *  Rule: <primary> ::= CASE <expression> <case_when_stmt_list> <guard_case_stmt_default> END CASE
 */

case 155 :

{

   build_ast(SETL_SYSTEM ast_case_stmt,"01110",NULL);

   return;

}

/*\
 *  \semact{case when clause list}
 *  \semcell{when clause}
 *  \semcell{when clause list}
 *  \sembottom
 *
 *  This action is identical to many other list-building actions in the
 *  semantic actions.  When this action is invoked, we've just scanned a
 *  clause which must be appended to the current clause list. We use the
 *  tail pointer to update the current tail, then reset the tail
 *  pointer.
\*/

/*
 *  Rule: <case_when_stmt_list> ::= <case_when_stmt_list> <case_when_stmt_item>
 */

case 156 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   *(sem_stack[sem_top - 1].sem_ast_tail) =
      sem_stack[sem_top].sem_ast_ptr;
   sem_stack[sem_top - 1].sem_ast_tail =
      &(sem_stack[sem_top].sem_ast_ptr->ast_next);
   sem_top--;

   return;

}

/*\
 *  \semact{case when clause list}
 *  \semcell{when clause}
 *  \sembottom
 *
 *  At this point we've scanned the first clause in a when clause list.
 *  We begin a list, and set the tail pointer.
\*/

/*
 *  Rule: <case_when_stmt_list> ::= <case_when_stmt_item>
 */

case 157 :

{

   build_ast(SETL_SYSTEM ast_list,"1",NULL);
   sem_stack[sem_top].sem_ast_tail =
      &((sem_stack[sem_top].sem_ast_ptr->ast_child.ast_child_ast)->ast_next);

   return;

}

/*\
 *  \semact{when clause}
 *  \semcell{statement list}
 *  \semcell{expression}
 *  \semcell{WHEN}
 *  \sembottom
 *
 *  We have to accumulate a list of \verb"WHEN" clauses in the process of
 *  building a \verb"case" or \verb"SELECT" subtree.
\*/

/*
 *  Rule: <case_when_stmt_item> ::= WHEN <expression_list> => <statement_list>
 */

case 158 :

{

   build_ast(SETL_SYSTEM ast_when,"011",NULL);

   return;

}

/*\
 *  \semact{guard expression}
 *  \semcell{CASE}
 *  \semcell{otherwise clause}
 *  \semcell{statement list}
 *  \semcell{CASE}
 *  \sembottom
 *
 *  Select expressions are nearly identical to case expressions for the
 *  grammar and semantic actions.
\*/

/*
 *  Rule: <primary> ::= CASE <guard_when_stmt_list> <guard_case_stmt_default> END CASE
 */

case 159 :

{

   build_ast(SETL_SYSTEM ast_guard_stmt,"0110",NULL);

   return;

}

/*\
 *  \semact{guard when lists}
 *  \semcell{when clause}
 *  \semcell{when clause list}
 *  \sembottom
 *
 *  This is yet another list-building action.  We need to separate it
 *  from case when lists to allow lists of expressions in case when
 *  clauses.
\*/

/*
 *  Rule: <guard_when_stmt_list> ::= <guard_when_stmt_list> <guard_when_stmt_item>
 */

case 160 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   *(sem_stack[sem_top - 1].sem_ast_tail) =
      sem_stack[sem_top].sem_ast_ptr;
   sem_stack[sem_top - 1].sem_ast_tail =
      &(sem_stack[sem_top].sem_ast_ptr->ast_next);
   sem_top--;

   return;

}

/*\
 *  \semact{first when clause in list}
 *  \semcell{clause}
 *  \sembottom
 *
 *  When this action is invoked, we've just scanned the first clause
 *  in a when clause list. We have to make it a child of a list node.
\*/

/*
 *  Rule: <guard_when_stmt_list> ::= <guard_when_stmt_item>
 */

case 161 :

{

   build_ast(SETL_SYSTEM ast_list,"1",NULL);
   sem_stack[sem_top].sem_ast_tail =
      &((sem_stack[sem_top].sem_ast_ptr->ast_child.ast_child_ast)->ast_next);

   return;

}

/*\
 *  \semact{guard when clause}
 *  \semcell{statement list}
 *  \semcell{condition}
 *  \semcell{WHEN}
 *  \sembottom
 *
 *  This rule is nearly identical to a case when clause.  The difference
 *  is that we accept only a single expression as a guard.
\*/

/*
 *  Rule: <guard_when_stmt_item> ::= WHEN <expression> => <statement_list>
 */

case 162 :

{

   build_ast(SETL_SYSTEM ast_when,"011",NULL);

   return;

}

/*\
 *  \semact{missing otherwise clauses}
 *
 *  The higher-level rules count on an \verb"OTHERWISE" clause being
 *  present, so we push a null on the stack if there is no
 *  \verb"OTHERWISE" clause.
\*/

/*
 *  Rule: <guard_case_stmt_default> ::= %empty
 */

case 164 :

{

   build_ast(SETL_SYSTEM ast_null,"",NULL);

   return;

}

/*\
 *  \semact{case expression}
 *  \semcell{CASE}
 *  \semcell{otherwise clause}
 *  \semcell{statement list}
 *  \semcell{choice value}
 *  \semcell{CASE}
 *  \sembottom
 *
 *  Case expressions are difficult for the code generator, but all we do
 *  here is build an abstract syntax tree.
\*/

/*
 *  Rule: <primary> ::= CASE <expression> <case_when_expr_list> <guard_case_expr_default> END CASE
 */

case 165 :

{

   build_ast(SETL_SYSTEM ast_case_expr,"01110",NULL);

   return;

}

/*\
 *  \semact{case when clause list}
 *  \semcell{when clause}
 *  \semcell{when clause list}
 *  \sembottom
 *
 *  This action is identical to many other list-building actions in the
 *  semantic actions.  When this action is invoked, we've just scanned a
 *  clause which must be appended to the current clause list. We use the
 *  tail pointer to update the current tail, then reset the tail
 *  pointer.
\*/

/*
 *  Rule: <case_when_expr_list> ::= <case_when_expr_list> <case_when_expr_item>
 */

case 166 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   *(sem_stack[sem_top - 1].sem_ast_tail) =
      sem_stack[sem_top].sem_ast_ptr;
   sem_stack[sem_top - 1].sem_ast_tail =
      &(sem_stack[sem_top].sem_ast_ptr->ast_next);
   sem_top--;

   return;

}

/*\
 *  \semact{case when clause list}
 *  \semcell{when clause}
 *  \sembottom
 *
 *  At this point we've scanned the first clause in a when clause list.
 *  We begin a list, and set the tail pointer.
\*/

/*
 *  Rule: <case_when_expr_list> ::= <case_when_expr_item>
 */

case 167 :

{

   build_ast(SETL_SYSTEM ast_list,"1",NULL);
   sem_stack[sem_top].sem_ast_tail =
      &((sem_stack[sem_top].sem_ast_ptr->ast_child.ast_child_ast)->ast_next);

   return;

}

/*\
 *  \semact{when clause}
 *  \semcell{statement list}
 *  \semcell{expression}
 *  \semcell{WHEN}
 *  \sembottom
 *
 *  We have to accumulate a list of \verb"WHEN" clauses in the process of
 *  building a \verb"case" or \verb"SELECT" subtree.
\*/

/*
 *  Rule: <case_when_expr_item> ::= WHEN <expression_list> => <expression>
 */

case 168 :

{

   build_ast(SETL_SYSTEM ast_when,"011",NULL);

   return;

}

/*\
 *  \semact{guard expression}
 *  \semcell{CASE}
 *  \semcell{otherwise clause}
 *  \semcell{statement list}
 *  \semcell{CASE}
 *  \sembottom
 *
 *  Select expressions are nearly identical to case expressions for the
 *  grammar and semantic actions.
\*/

/*
 *  Rule: <primary> ::= CASE <guard_when_expr_list> <guard_case_expr_default> END CASE
 */

case 169 :

{

   build_ast(SETL_SYSTEM ast_guard_expr,"0110",NULL);

   return;

}

/*\
 *  \semact{guard when lists}
 *  \semcell{when clause}
 *  \semcell{when clause list}
 *  \sembottom
 *
 *  This is yet another list-building action.  We need to separate it
 *  from case when lists to allow lists of expressions in case when
 *  clauses.
\*/

/*
 *  Rule: <guard_when_expr_list> ::= <guard_when_expr_list> <guard_when_expr_item>
 */

case 170 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   *(sem_stack[sem_top - 1].sem_ast_tail) =
      sem_stack[sem_top].sem_ast_ptr;
   sem_stack[sem_top - 1].sem_ast_tail =
      &(sem_stack[sem_top].sem_ast_ptr->ast_next);
   sem_top--;

   return;

}

/*\
 *  \semact{first when clause in list}
 *  \semcell{clause}
 *  \sembottom
 *
 *  When this action is invoked, we've just scanned the first clause
 *  in a when clause list. We have to make it a child of a list node.
\*/

/*
 *  Rule: <guard_when_expr_list> ::= <guard_when_expr_item>
 */

case 171 :

{

   build_ast(SETL_SYSTEM ast_list,"1",NULL);
   sem_stack[sem_top].sem_ast_tail =
      &((sem_stack[sem_top].sem_ast_ptr->ast_child.ast_child_ast)->ast_next);

   return;

}

/*\
 *  \semact{guard when clause}
 *  \semcell{statement list}
 *  \semcell{condition}
 *  \semcell{WHEN}
 *  \sembottom
 *
 *  This rule is nearly identical to a case when clause.  The difference
 *  is that we accept only a single expression as a guard.
\*/

/*
 *  Rule: <guard_when_expr_item> ::= WHEN <expression> => <expression>
 */

case 172 :

{

   build_ast(SETL_SYSTEM ast_when,"011",NULL);

   return;

}

/*\
 *  \semact{missing otherwise clauses}
 *
 *  The higher-level rules count on an \verb"OTHERWISE" clause being
 *  present.  In an expression, a missing otherwise returns OM.
\*/

/*
 *  Rule: <guard_case_expr_default> ::= %empty
 */

case 174 :

{
ast_ptr_type ast_ptr;                  /* created ast node                  */

   ast_ptr = get_ast(SETL_SYSTEM_VOID);
   ast_ptr->ast_type = ast_symtab;
   ast_ptr->ast_child.ast_symtab_ptr = sym_omega;
   get_sem;
   sem_stack[sem_top].sem_type = SEM_AST;
   copy_file_pos(&(ast_ptr->ast_file_pos),&(sem_stack[sem_top].sem_file_pos));
   sem_stack[sem_top].sem_ast_ptr = ast_ptr;

   return;

}

#ifdef SHORT_FUNCS

default :

   semantic_action3(SETL_SYSTEM rule);
   return;

}}


static void semantic_action3(
   SETL_SYSTEM_PROTO
   int rule)                           /* rule number                       */

{

   switch (rule) {

#endif

/*\
 *  \semact{stop expression}
 *  \semcell{STOP}
 *  \sembottom
 *
 *  A \verb"stop" will stop the program.
\*/

/*
 *  Rule: <statement> ::= STOP
 */

case 175 :

{

   build_ast(SETL_SYSTEM ast_stop,"0",&(sem_stack[sem_top].sem_file_pos));

   return;

}

/*\
 *  \semact{return expression}
 *  \semcell{RETURN}
 *  \sembottom
 *
 *  A \verb"return" without a corresponding return value will return OM.
\*/

/*
 *  Rule: <statement> ::= RETURN
 */

case 176 :

{

   build_ast(SETL_SYSTEM ast_return,"0",&(sem_stack[sem_top].sem_file_pos));

   return;

}

/*\
 *  \semact{return statement}
 *  \semcell{return value}
 *  \semcell{RETURN}
 *  \sembottom
 *
 *  In \setl, there is no difference between functions and procedures.
 *  Essentially, there is an implicit return of OM at the end of every
 *  procedure, and return statements without a return value return OM.
\*/

/*
 *  Rule: <statement> ::= RETURN <expression>
 */

case 177 :

{

   build_ast(SETL_SYSTEM ast_return,"01",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{exit expression}
 *  \semcell{EXIT}
 *  \sembottom
 *
 *  A \verb"EXIT" is used to break out of a \verb"FOR" or \verb"WHILE"
 *  loop.
\*/

/*
 *  Rule: <statement> ::= EXIT
 */

case 178 :

{

   build_ast(SETL_SYSTEM ast_exit,"0",&(sem_stack[sem_top].sem_file_pos));

   return;

}

/*\
 *  \semact{exit statement}
 *  \semcell{exit value}
 *  \semcell{EXIT}
 *  \sembottom
 *
 *  A exit with a value is only meaningful if a loop expression is used
 *  in a right hand side context.  In that case, the value of the loop is
 *  the value returned.
\*/

/*
 *  Rule: <statement> ::= EXIT <expression>
 */

case 179 :

{

   build_ast(SETL_SYSTEM ast_exit,"01",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{exit statement}
 *  \semcell{exit value}
 *  \semcell{EXIT}
 *  \sembottom
 *
 *  A exit with a value is only meaningful if a loop expression is used
 *  in a right hand side context.  In that case, the value of the loop is
 *  the value returned.
\*/

/*
 *  Rule: <statement> ::= EXIT WHEN <expression>
 */

case 180 :

{

   build_ast(SETL_SYSTEM ast_exit,"",&(sem_stack[sem_top - 2].sem_file_pos));
   build_ast(SETL_SYSTEM ast_null,"",NULL);
   build_ast(SETL_SYSTEM ast_if_stmt,"00111",&(sem_stack[sem_top - 3].sem_file_pos));

   return;

}

/*\
 *  \semact{exit statement}
 *  \semcell{exit value}
 *  \semcell{EXIT}
 *  \sembottom
 *
 *  A exit with a value is only meaningful if a loop expression is used
 *  in a right hand side context.  In that case, the value of the loop is
 *  the value returned.
\*/

/*
 *  Rule: <statement> ::= EXIT <expression> WHEN <expression>
 */

case 181 :

{

   memcpy(&sem_stack[sem_top - 1],
          &sem_stack[sem_top - 2],
          sizeof(struct sem_stack_item));
   memcpy(&sem_stack[sem_top - 2],
          &sem_stack[sem_top],
          sizeof(struct sem_stack_item));
   sem_top--;
   build_ast(SETL_SYSTEM ast_exit,"1",&(sem_stack[sem_top - 2].sem_file_pos));
   build_ast(SETL_SYSTEM ast_null,"",NULL);
   build_ast(SETL_SYSTEM ast_if_stmt,"0111",&(sem_stack[sem_top - 3].sem_file_pos));

   return;

}

/*\
 *  \semact{continue expression}
 *  \semcell{CONTINUE}
 *  \sembottom
 *
 *  A \verb"CONTINUE" is used to cycle in a \verb"FOR" or \verb"WHILE"
 *  loop.
\*/

/*
 *  Rule: <statement> ::= CONTINUE
 */

case 182 :

{

   build_ast(SETL_SYSTEM ast_continue,"0",&(sem_stack[sem_top].sem_file_pos));

   return;

}

/*\
 *  \semact{continue statement}
 *  \semcell{CONTINUE}
 *  \sembottom
 *
 *  A continue with a value is only meaningful if a loop expression is used
 *  in a right hand side context.  In that case, the value of the loop is
 *  the value returned.
\*/

/*
 *  Rule: <statement> ::= CONTINUE WHEN <expression>
 */

case 183 :

{

   build_ast(SETL_SYSTEM ast_continue,"",&(sem_stack[sem_top - 2].sem_file_pos));
   build_ast(SETL_SYSTEM ast_null,"",NULL);
   build_ast(SETL_SYSTEM ast_if_stmt,"00111",&(sem_stack[sem_top - 3].sem_file_pos));

   return;

}

/*\
 *  \semact{assert statement}
 *  \semcell{assert condition}
 *  \semcell{ASSERT}
 *  \sembottom
 *
 *  An assert is the way to code a program trap in \setl. If the condition
 *  fails, the program is aborted.
\*/

/*
 *  Rule: <statement> ::= ASSERT <expression>
 */

case 184 :

{

   build_ast(SETL_SYSTEM ast_assert,"01",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{null statement}
 *  \semcell{NULL}
 *  \sembottom
 *
 *  A \verb"NULL" is used for empty statement lists.
\*/

/*
 *  Rule: <statement> ::= NULL
 */

case 185 :

{

   build_ast(SETL_SYSTEM ast_null,"0",&(sem_stack[sem_top].sem_file_pos));

   return;

}

/*\
 *  \semact{lambda procedure}
 *
 *  When this rule is invoked, we've seen an entire procedure.  All we
 *  have to do is print the symbol table and pop the procedure table.
\*/

/*
 *  Rule: <primary> ::= <lambda_header> ; <data_declaration_part> <body> <proc_definition_part> END LAMBDA
 */

case 186 :

{

#ifdef DEBUG

   /* print the symbols in the procedure, if desired */

   if (SYM_DEBUG ) {

      fprintf(DEBUG_FILE,"\n%s => %s\n",
                         proctab_desc[curr_proctab_ptr->pr_type],
                         (curr_proctab_ptr->pr_namtab_ptr)->nt_name);

      print_symtab(SETL_SYSTEM curr_proctab_ptr);
      fputs("\n",DEBUG_FILE);

   }

#endif

   /* restore the initialization trees */

   sem_top--;
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   while (*ast_init_tail != NULL)
      ast_init_tail = &((*ast_init_tail)->ast_next);
   sem_top--;
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   while (*slot_init_tail != NULL)
      slot_init_tail = &((*slot_init_tail)->ast_next);
   sem_top--;
   var_init_tree = sem_stack[sem_top].sem_ast_ptr;
   var_init_tail = &var_init_tree;
   while (*var_init_tail != NULL)
      var_init_tail = &((*var_init_tail)->ast_next);
   sem_top--;

   /* push the created symbol */

   build_ast(SETL_SYSTEM ast_symtab,"",&(curr_proctab_ptr->pr_file_pos));
   (sem_stack[sem_top].sem_ast_ptr)->ast_child.ast_symtab_ptr =
         curr_proctab_ptr->pr_symtab_ptr;

   /* pop the current procedure */

   detach_symtab(curr_proctab_ptr->pr_symtab_head);
   curr_proctab_ptr = curr_proctab_ptr->pr_parent;

   return;

}

/*\
 *  \semact{lambda key}
 *  \semcell{LAMBDA}
 *  \sembottom
 *
 *  When this action is invoked, we've just finished scanning the name
 *  portion of a procedure header.  At this point, we want to open up a
 *  new scope, since formal parameter names are internal to a procedure.
 *
 *  \begin{enumerate}
 *  \item
 *  We open a new procedure table item, inserting it as a child of the
 *  current procedure, and making it the new current procedure.
 *  \item
 *  We install the procedure name in the symbol table, as part of the
 *  enclosing procedure.
 *  \item
 *  We set up an empty list for the initialization code tree.
 *  \end{enumerate}
\*/

/*
 *  Rule: <lambda_key> ::= LAMBDA
 */

case 188 :

{
proctab_ptr_type new_proc;             /* pointer to new procedure          */

   /* save the initialization trees (note: replace LAMBDA) */

   sem_stack[sem_top].sem_type = SEM_AST;
   sem_stack[sem_top].sem_ast_ptr = var_init_tree;
   get_sem;
   sem_stack[sem_top].sem_type = SEM_AST;
   sem_stack[sem_top].sem_ast_ptr = slot_init_tree;
   get_sem;
   sem_stack[sem_top].sem_type = SEM_AST;
   sem_stack[sem_top].sem_ast_ptr = ast_init_tree;

   /* open up a new procedure */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   new_proc->pr_namtab_ptr = nam_lambda;

   if (unit_proctab_ptr->pr_type == pr_class_spec ||
       unit_proctab_ptr->pr_type == pr_class_body ||
       unit_proctab_ptr->pr_type == pr_process_body ||
       unit_proctab_ptr->pr_type == pr_process_body) {
      new_proc->pr_type = pr_method;
   }
   else {
      new_proc->pr_type = pr_procedure;
   }
   copy_file_pos(&(new_proc->pr_file_pos),
                 &(sem_stack[sem_top - 2].sem_file_pos));

   /* install the procedure name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      NULL,
                      curr_proctab_ptr,
                      &(sem_stack[sem_top - 2].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

      (new_proc->pr_symtab_ptr)->st_type = sym_procedure;
      (new_proc->pr_symtab_ptr)->st_slot_num = -1;
      (new_proc->pr_symtab_ptr)->st_aux.st_proctab_ptr = new_proc;
      (new_proc->pr_symtab_ptr)->st_has_rvalue = YES;
      (new_proc->pr_symtab_ptr)->st_needs_stored = YES;
      (new_proc->pr_symtab_ptr)->st_is_declared = YES;

   }

   /* install an empty list as initialization code */

   if (unit_proctab_ptr->pr_type != pr_package_spec &&
       unit_proctab_ptr->pr_type != pr_class_spec ||
       unit_proctab_ptr->pr_type != pr_process_spec) {

      build_ast(SETL_SYSTEM ast_list,"",NULL);
      ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
      sem_top--;
      ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
      build_ast(SETL_SYSTEM ast_list,"",NULL);
      slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
      sem_top--;
      slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
      var_init_tree = NULL;
      var_init_tail = &var_init_tree;

   }

   /* make the new procedure current and pop the name from the stack */

   curr_proctab_ptr = new_proc;

   return;

}

/*\
 *  \semact{default formal parameter declaration}
 *  \semcell{formal name}
 *  \sembottom
 *
 *  A declaration of a formal parameter is almost identical to a variable
 *  declaration.  The formal paramters of a procedure are just the first
 *  {\em n} symbols in the procedure's local symbol table, where {\em n}
 *  is the number of formals.  All we have to do here is declare a
 *  variable, and bump the count of formal parameters for a procedure.
 *
 *  By default, a formal parameter is read only.
\*/

/*
 *  Rule: <lambda_param_spec> ::= identifier
 */

case 195 :

{
symtab_ptr_type symtab_ptr;            /* formal parameter pointer          */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   symtab_ptr = enter_symbol(SETL_SYSTEM
                             sem_stack[sem_top].sem_namtab_ptr,
                             curr_proctab_ptr,
                             &(sem_stack[sem_top].sem_file_pos));

   if (symtab_ptr != NULL) {

      symtab_ptr->st_type = sym_id;
      symtab_ptr->st_has_rvalue = YES;
      symtab_ptr->st_has_lvalue = YES;
      symtab_ptr->st_is_rparam = YES;
      symtab_ptr->st_needs_stored = YES;

   }

   curr_proctab_ptr->pr_formal_count++;
   sem_top--;

   return;

}

/*\
 *  \semact{quantifier expressions}
 *  \semcell{condition}
 *  \semcell{iterator list}
 *  \semcell{quantifier}
 *  \sembottom
 *
 *  Quantifiers in \setl\ are quite different from those in SETL in that they
 *  they are only used as predicates.  The values of the iteration
 *  variables are not set if the predicate is true.
\*/

/*
 *  Rule: <expression> ::= quantifier <expression_list> suchthat <expression>
 */

case 197 :

{

   if (sem_stack[sem_top - 2].sem_token_subclass == tok_exists)
      sem_stack[sem_top - 1].sem_ast_ptr->ast_type = ast_ex_iter;
   else
      sem_stack[sem_top - 1].sem_ast_ptr->ast_type = ast_iter_list;

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 2].sem_token_subclass],
             "011",
             &(sem_stack[sem_top - 2].sem_file_pos));

   return;

}

/*\
 *  \semact{from expression}
 *  \semcell{right expression}
 *  \semcell{from operator}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  This is one of several places in which we have a set of binary
 *  operators with the same precedence.  We use a table by token subclass
 *  to pick the AST node type corresponding to the actual operator, and
 *  form the AST.
\*/

/*
 *  Rule: <expression> ::= <left_term> fromop <left_term>
 */

case 198 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "101",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{and expression}
 *  \semcell{right expression}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  \verb"AND" and \verb"OR" operators are unusual in that we don't allow
 *  them to be combined without parentheses.  We control this in the
 *  grammar, but it requires two rules with the same semantic action.
\*/

/*
 *  Rule: <and_expression> ::= <and_term> AND <not_term>
 */

case 202 :

{

   build_ast(SETL_SYSTEM ast_and,"101",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{and expression}
 *  \semcell{right expression}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  \verb"AND" and \verb"OR" operators are unusual in that we don't allow
 *  them to be combined without parentheses.  We control this in the
 *  grammar, but it requires two rules with the same semantic action.
\*/

/*
 *  Rule: <and_term> ::= <and_term> AND <not_term>
 */

case 203 :

{
   build_ast(SETL_SYSTEM ast_and,"101",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{or expression}
 *  \semcell{right expression}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  \verb"AND" and \verb"OR" operators are unusual in that we don't allow
 *  them to be combined without parentheses.  We control this in the
 *  grammar, but it requires two rules with the same semantic action.
\*/

/*
 *  Rule: <or_expression> ::= <or_term> OR <not_term>
 */

case 205 :

{

   build_ast(SETL_SYSTEM ast_or,"101",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{or expression}
 *  \semcell{right expression}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  \verb"AND" and \verb"OR" operators are unusual in that we don't allow
 *  them to be combined without parentheses.  We control this in the
 *  grammar, but it requires two rules with the same semantic action.
\*/

/*
 *  Rule: <or_term> ::= <or_term> OR <not_term>
 */

case 206 :

{

   build_ast(SETL_SYSTEM ast_or,"101",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{not expression}
 *  \semcell{expression}
 *  \sembottom
 *
 *  The NOT operator has a precedence all to itself.  Therefore, we don't
 *  push it on the semantic stack.
\*/

/*
 *  Rule: <not_term> ::= NOT <relop_term>
 */

case 208 :

{

   build_ast(SETL_SYSTEM ast_not,"01",&(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{relational operator expression}
 *  \semcell{right expression}
 *  \semcell{relational operator}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  This is one of several places in which we have a set of binary
 *  operators with the same precedence.  We use a table by token subclass
 *  to pick the AST node type corresponding to the actual operator, and
 *  form the AST.
\*/

/*
 *  Rule: <relop_term> ::= <relop_term> relop <addop_term>
 */

case 210 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "101",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{addition operator}
 *  \semcell{right expression}
 *  \semcell{binary operator}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  This is one of several places in which we have a set of binary
 *  operators with the same precedence.  We use a table by token subclass
 *  to pick the AST node type corresponding to the actual operator, and
 *  form the AST.
\*/

/*
 *  Rule: <addop_term> ::= <addop_term> addop <mulop_term>
 */

case 212 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "101",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{subtraction expression}
 *  \semcell{right expression}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  Although binary subtraction has the same precedence as addition, we
 *  separate it from other addition operators because we also need it as
 *  a placeholder in parallel assignment expressions.
\*/

/*
 *  Rule: <addop_term> ::= <addop_term> - <mulop_term>
 */

case 213 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "101",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{multiplication operator}
 *  \semcell{right expression}
 *  \semcell{relational operator}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  This is one of several places in which we have a set of binary
 *  operators with the same precedence.  We use a table by token subclass
 *  to pick the AST node type corresponding to the actual operator, and
 *  form the AST.
\*/

/*
 *  Rule: <mulop_term> ::= <mulop_term> mulop <expon_term>
 */

case 215 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "101",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{binary application operator}
 *  \semcell{right expression}
 *  \semcell{operator}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  This is one of several places in which we have a set of binary
 *  operators with the same precedence.  We use a table by token subclass
 *  to pick the AST node type corresponding to the actual operator, and
 *  form the AST.
\*/

/*
 *  Rule: <mulop_term> ::= <mulop_term> applyop <expon_term>
 */

case 216 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "101",
             &(sem_stack[sem_top - 1].sem_file_pos));

   build_ast(SETL_SYSTEM ast_binapply,"1",NULL);

   return;

}

/*\
 *  \semact{exponentiation expression}
 *  \semcell{right expression}
 *  \semcell{left expression}
 *  \sembottom
 *
 *  Exponentiation is a strange expression.  First, it is not a class of
 *  operators, but a single operator with the highest precedence of all
 *  binary operators.  Secondly, it associates to the right, not the
 *  left.
\*/

/*
 *  Rule: <expon_term> ::= <left_term> ** <expon_term>
 */

case 218 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "101",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{unary operation}
 *  \semcell{expression}
 *  \sembottom
 *
 *  Like the binary operators, there is a group of unary operators which
 *  share the same precedence.  We use a table by token subclass to pick
 *  the AST node type corresponding to the actual operator, and form the
 *  AST.
\*/

/*
 *  Rule: <left_term> ::= unop <left_term>
 */

case 220 :

{

   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "01",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{unary minus operation}
 *  \semcell{expression}
 *  \sembottom
 *
 *  Although unary minus has the same precedence as other unary
 *  operators, we separate it from those since it can also be used as a
 *  placeholder in parallel assignments and as a binary operator.
\*/

/*
 *  Rule: <left_term> ::= - <left_term>
 */

case 221 :

{
   build_ast(SETL_SYSTEM ast_uminus,
             "01",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{unary from operation}
 *  \semcell{expression}
 *  \sembottom
 *
\*/

/*
 *  Rule: <left_term> ::= fromop <left_term>
 */

case 222 :

{
   build_ast(SETL_SYSTEM ast_ufrom,
             "01",
             &(sem_stack[sem_top - 1].sem_file_pos));

   return;

}

/*\
 *  \semact{pointer operation}
 *  \semcell{expression}
 *  \semcell{*}
 *  \sembottom
 *
 *  This is a bit of syntactic sugar.  We map expressions of the form
 *  \verb"^x" into \verb"_memory(x)", where \verb"_memory" is a global
 *  map inaccessible by other means.
\*/

/*
 *  Rule: <left_term> ::= ^ <left_term>
 */

case 223 :

{
ast_ptr_type ast_ptr;                  /* temporary ast pointer             */

   /* replace the ^ by _memory */

   ast_ptr = get_ast(SETL_SYSTEM_VOID);
   ast_ptr->ast_type = ast_symtab;
   ast_ptr->ast_child.ast_symtab_ptr = sym_memory;
   copy_file_pos(&(ast_ptr->ast_file_pos),
                 &(sem_stack[sem_top - 1].sem_file_pos));
   sem_stack[sem_top - 1].sem_type = SEM_AST;
   sem_stack[sem_top - 1].sem_ast_ptr = ast_ptr;

   /* build the argument list, with just one item */

   build_ast(SETL_SYSTEM ast_list,"1",&(sem_stack[sem_top].sem_file_pos));
   build_ast(SETL_SYSTEM ast_of,"11",&(sem_stack[sem_top].sem_file_pos));

   return;

}

/*\
 *  \semact{application operation}
 *  \semcell{expression}
 *  \sembottom
 *
 *  Application operators can be both unary and binary.  If unary, we
 *  have to add a null subtree as the left operand.
\*/

/*
 *  Rule: <left_term> ::= applyop <left_term>
 */

case 224 :

{
   build_ast(SETL_SYSTEM tok_ast_type[sem_stack[sem_top - 1].sem_token_subclass],
             "01",
             &(sem_stack[sem_top - 1].sem_file_pos));

   build_ast(SETL_SYSTEM ast_apply,"1",NULL);

   return;

}

/*\
 *  \semact{literals}
 *  \semcell{literal}
 *  \sembottom
\*/

/*
 *  Rule: <primary> ::= literal
 */

case 226 :

{
ast_ptr_type ast_ptr;

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   ast_ptr = get_ast(SETL_SYSTEM_VOID);
   ast_ptr->ast_type = ast_symtab;
   ast_ptr->ast_child.ast_symtab_ptr =
         (sem_stack[sem_top].sem_namtab_ptr)->nt_symtab_ptr;
   copy_file_pos(&(ast_ptr->ast_file_pos),&(sem_stack[sem_top].sem_file_pos));
   sem_stack[sem_top].sem_type = SEM_AST;
   sem_stack[sem_top].sem_ast_ptr = ast_ptr;

   return;

}

/*\
 *  \semact{enumerated set former}
 *  \semcell{expression list}
 *  \sembottom
 *
 *  This action builds an enumerated set.  All we do is create an
 *  enumerated set node as parent.
\*/

/*
 *  Rule: <primary> ::= { <expression_list> }
 */

case 227 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);

#endif

   sem_stack[sem_top].sem_ast_ptr->ast_type = ast_enum_set;

   return;

}

/*\
 *  \semact{arithmetic iterator sets}
 *  \semcell{initial list}
 *  \semcell{final value}
 *  \sembottom
 *
 *  This rule handles set arithmetic iterators.
\*/

/*
 *  Rule: <primary> ::= { <expression_list> .. <expression> }
 */

case 228 :

{

   build_ast(SETL_SYSTEM ast_arith_set,"11",NULL);

   return;

}

/*\
 *  \semact{general set (without expression)}
 *  \semcell{inclusion condition}
 *  \semcell{iterator}
 *  \sembottom
 *
 *  This action builds an enumerated set.  All we do is create an
 *  enumerated set node as parent.
\*/

/*
 *  Rule: <primary> ::= { <iterator_expression> suchthat <expression> }
 */

case 229 :

{

   build_ast(SETL_SYSTEM ast_genset_noexp,"11",NULL);

   return;

}

/*\
 *  \semact{general set}
 *  \semcell{inclusion condition}
 *  \semcell{iterator list}
 *  \semcell{expression}
 *  \sembottom
 *
 *  This action builds an enumerated set.  All we do is create an
 *  enumerated set node as parent.
\*/

/*
 *  Rule: <primary> ::= { <expression> : <expression_list> suchthat <expression> }
 */

case 230 :

{

   sem_stack[sem_top - 1].sem_ast_ptr->ast_type = ast_iter_list;
   build_ast(SETL_SYSTEM ast_genset,"111",NULL);

   return;

}

/*\
 *  \semact{general set}
 *  \semcell{inclusion condition}
 *  \semcell{iterator list}
 *  \semcell{expression}
 *  \sembottom
 *
 *  This action builds an enumerated set.  All we do is create an
 *  enumerated set node as parent.
\*/

/*
 *  Rule: <primary> ::= { <expression> : <expression_list> }
 */

case 231 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   sem_stack[sem_top].sem_ast_ptr->ast_type = ast_iter_list;
   build_ast(SETL_SYSTEM ast_null,"",&(sem_stack[sem_top].sem_file_pos));
   build_ast(SETL_SYSTEM ast_genset,"111",NULL);

   return;

}

/*\
 *  \semact{empty set expression}
\*/

/*
 *  Rule: <primary> ::= { }
 */

case 232 :

{
ast_ptr_type ast_ptr;                  /* created ast node                  */

   ast_ptr = get_ast(SETL_SYSTEM_VOID);
   ast_ptr->ast_type = ast_symtab;
   ast_ptr->ast_child.ast_symtab_ptr = sym_nullset;
   get_sem;
   sem_stack[sem_top].sem_type = SEM_AST;
   copy_file_pos(&(ast_ptr->ast_file_pos),&(sem_stack[sem_top].sem_file_pos));
   sem_stack[sem_top].sem_ast_ptr = ast_ptr;

   return;

}

/*\
 *  \semact{arithmetic tuple formers}
 *  \semcell{initial list}
 *  \semcell{final value}
 *  \sembottom
 *
 *  This rule handles arithmetic tuple formers.  All we do here is build
 *  an AST node.  We will have to check that the tuple does not contain
 *  placeholders in the semantic check phase.
\*/

/*
 *  Rule: <primary> ::= [ <tuple_list> .. <expression> ]
 */

case 233 :

{

   build_ast(SETL_SYSTEM ast_arith_tup,"11",NULL);

   return;

}

/*\
 *  \semact{general tuple (without expression)}
 *  \semcell{inclusion condition}
 *  \semcell{iterator}
 *  \sembottom
 *
 *  This action builds an enumerated tuple.  All we do is create an
 *  enumerated tuple node as parent.
\*/

/*
 *  Rule: <primary> ::= [ <iterator_expression> suchthat <expression> ]
 */

case 234 :

{

   build_ast(SETL_SYSTEM ast_gentup_noexp,"11",NULL);

   return;

}

/*\
 *  \semact{general tuple}
 *  \semcell{inclusion condition}
 *  \semcell{iterator list}
 *  \semcell{expression}
 *  \sembottom
 *
 *  This action builds an enumerated tuple.  All we do is create an
 *  enumerated tuple node as parent.
\*/

/*
 *  Rule: <primary> ::= [ <expression> : <expression_list> suchthat <expression> ]
 */

case 235 :

{

   sem_stack[sem_top - 1].sem_ast_ptr->ast_type = ast_iter_list;
   build_ast(SETL_SYSTEM ast_gentup,"111",NULL);

   return;

}

/*\
 *  \semact{general tuple}
 *  \semcell{inclusion condition}
 *  \semcell{iterator list}
 *  \semcell{expression}
 *  \sembottom
 *
 *  This action builds an enumerated tuple.  All we do is create an
 *  enumerated tuple node as parent.
\*/

/*
 *  Rule: <primary> ::= [ <expression> : <expression_list> ]
 */

case 236 :

{

   sem_stack[sem_top].sem_ast_ptr->ast_type = ast_iter_list;
   build_ast(SETL_SYSTEM ast_null,"",&(sem_stack[sem_top].sem_file_pos));
   build_ast(SETL_SYSTEM ast_gentup,"111",NULL);

   return;

}

/*\
 *  \semact{empty tuple expression}
\*/

/*
 *  Rule: <primary> ::= [ ]
 */

case 237 :

{
ast_ptr_type ast_ptr;                  /* created ast node                  */

   ast_ptr = get_ast(SETL_SYSTEM_VOID);
   ast_ptr->ast_type = ast_symtab;
   ast_ptr->ast_child.ast_symtab_ptr = sym_nulltup;
   get_sem;
   sem_stack[sem_top].sem_type = SEM_AST;
   copy_file_pos(&(ast_ptr->ast_file_pos),&(sem_stack[sem_top].sem_file_pos));
   sem_stack[sem_top].sem_ast_ptr = ast_ptr;

   return;

}

/*\
 *  \semact{iterator expression}
 *  \semcell{expression}
 *  \sembottom
\*/

/*
 *  Rule: <iterator_expression> ::= <expression>
 */

case 238 :

{

   build_ast(SETL_SYSTEM ast_iter_list,"1",NULL);

   return;

}

/*\
 *  \semact{identifiers}
 *  \semcell{identifier}
 *  \sembottom
\*/

/*
 *  Rule: <primary> ::= identifier
 */

case 240 :

{
ast_ptr_type ast_ptr;

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);

#endif

   ast_ptr = get_ast(SETL_SYSTEM_VOID);
   ast_ptr->ast_type = ast_namtab;
   ast_ptr->ast_child.ast_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   copy_file_pos(&(ast_ptr->ast_file_pos),&(sem_stack[sem_top].sem_file_pos));
   sem_stack[sem_top].sem_type = SEM_AST;
   sem_stack[sem_top].sem_ast_ptr = ast_ptr;

   return;

}

/*\
 *  \semact{self keyword}
 *  \semcell{SELF}
 *  \sembottom
\*/

/*
 *  Rule: <primary> ::= SELF
 */

case 241 :

{
ast_ptr_type ast_ptr;

   if((curr_proctab_ptr->pr_symtab_ptr->st_type==sym_procedure) &&
      (curr_proctab_ptr->pr_symtab_ptr->st_slot_num==0)) {

     ast_ptr = get_ast(SETL_SYSTEM_VOID);
     ast_ptr->ast_type = ast_namtab;
     ast_ptr->ast_child.ast_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
     copy_file_pos(&(ast_ptr->ast_file_pos),&(sem_stack[sem_top].sem_file_pos));
     sem_stack[sem_top].sem_type = SEM_AST;
     sem_stack[sem_top].sem_ast_ptr = ast_ptr;

   } else build_ast(SETL_SYSTEM ast_self,"0",NULL); 

   return;

}

/*\
 *  \semact{selector expression}
 *  \semcell{map or procedure}
 *  \semcell{argument}
 *  \sembottom
 *
 *  This rule handles selector expressions.  We don't know what we are
 *  selecting from at this point, it could be a map, tuple, or a
 *  procedure call.
\*/

/*
 *  Rule: <primary> ::= <primary> ( <expression_list> )
 */

case 242 :

{

   build_ast(SETL_SYSTEM ast_of,"11",NULL);

   return;

}

/*\
 *  \semact{slice expression}
 *  \semcell{last position}
 *  \semcell{first position}
 *  \semcell{expression}
 *  \sembottom
 *
 *  This rule handles slice expression.  It refers to a slice of a string
 *  or tuple.
\*/

/*
 *  Rule: <primary> ::= <primary> ( <expression> .. <expression> )
 */

case 243 :

{

   build_ast(SETL_SYSTEM ast_slice,"111",NULL);

   return;

}

/*\
 *  \semact{slice expression}
 *  \semcell{first position}
 *  \semcell{expression}
 *  \sembottom
 *
 *  This rule handles an alternate form of slice expression, where the
 *  last element of the slice is the end of the string or tuple.
\*/

/*
 *  Rule: <primary> ::= <primary> ( <expression> .. )
 */

case 244 :

{

   build_ast(SETL_SYSTEM ast_end,"11",NULL);

   return;

}

/*\
 *  \semact{selector expression}
 *  \semcell{procedure}
 *  \sembottom
 *
 *  This rule handles selector expressions.  In this case we have no
 *  arguments, so it better turn out to be a procedure call.
\*/

/*
 *  Rule: <primary> ::= <primary> ( )
 */

case 245 :

{

   build_ast(SETL_SYSTEM ast_list,"",&(sem_stack[sem_top].sem_file_pos));
   build_ast(SETL_SYSTEM ast_of,"11",NULL);

   return;

}

/*\
 *  \semact{milti-valued map selectors}
 *  \semcell{argument}
 *  \semcell{expression}
 *  \sembottom
 *
 *  This rule handles expressions returning a set for a multi-valued map.
\*/

/*
 *  Rule: <primary> ::= <primary> { <expression_list> }
 */

case 246 :

{

   build_ast(SETL_SYSTEM ast_ofa,"11",NULL);

   return;

}

/*\
 *  \semact{qualifier expressions}
 *  \semcell{right hand side}
 *  \semcell{left hand side}
 *  \sembottom
 *
 *  This rule actually handles two situations, depending on the oprands
 *  given.  If the left hand operand is the name of an enclosing
 *  procedure or an imported package, the right hand side must be an
 *  identifier hidden by a local declaration.  If the right hand side is
 *  a selector, we can replace the expression by the corresponding
 *  selector expression in the next phase.
 *
 *  The semantic processing of this rule is a little tricky.  We use left
 *  recursion in the grammar, but we want to keep a list of operands all
 *  on one level in the tree.
\*/

/*
 *  Rule: <primary> ::= <primary> . identifier
 */

case 247 :

{
ast_ptr_type ast_ptr;                  /* created AST node                  */

#ifdef TRAPS

   verify_sem(sem_top,SEM_NAMTAB);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   /* first, we make the name table item on the top of stack into an AST */

   ast_ptr = get_ast(SETL_SYSTEM_VOID);
   ast_ptr->ast_type = ast_namtab;
   ast_ptr->ast_child.ast_namtab_ptr = sem_stack[sem_top].sem_namtab_ptr;
   copy_file_pos(&(ast_ptr->ast_file_pos),
                 &(sem_stack[sem_top].sem_file_pos));
   sem_stack[sem_top].sem_type = SEM_AST;
   sem_stack[sem_top].sem_ast_ptr = ast_ptr;

   /* if the left child is a dot, we just append to the list of operands */

   if (sem_stack[sem_top - 1].sem_ast_ptr->ast_type == ast_dot) {

      *(sem_stack[sem_top - 1].sem_ast_tail) =
         sem_stack[sem_top].sem_ast_ptr;
      sem_stack[sem_top - 1].sem_ast_tail =
         &(sem_stack[sem_top].sem_ast_ptr->ast_next);
      sem_top--;

   }

   /* otherwise we start a new list */

   else {

      build_ast(SETL_SYSTEM ast_dot,"11",NULL);
      sem_stack[sem_top].sem_ast_tail =
         &(((sem_stack[sem_top].sem_ast_ptr->
         ast_child.ast_child_ast)->ast_next)->ast_next);

   }

   return;

}

/*\
 *  \semact{enumerated tuple former}
 *  \semcell{expression list}
 *  \sembottom
 *
 *  This action builds an enumerated tuple.  All we do now is create an
 *  enumerated tuple node as parent.  In the next phase, we have to look
 *  for placeholders in the tuple, depending on whether it's used on the
 *  left or the right.
\*/

/*
 *  Rule: <primary> ::= [ <tuple_list> ]
 */

case 248 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);

#endif

   sem_stack[sem_top].sem_ast_ptr->ast_type = ast_enum_tup;

   return;

}

/*\
 *  \semact{tuple expression lists}
 *  \semcell{new expression}
 *  \semcell{expression list}
 *  \sembottom
 *
 *  When this action is invoked, we've just scanned an expression which
 *  must be appended to the current expression list. We use the tail
 *  pointer to update the current tail, then reset the tail pointer.
\*/

/*
 *  Rule: <tuple_list> ::= <tuple_list> , <tuple_element>
 */

case 250 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);
   verify_sem(sem_top - 1,SEM_AST);

#endif

   *(sem_stack[sem_top - 1].sem_ast_tail) =
      sem_stack[sem_top].sem_ast_ptr;
   sem_stack[sem_top - 1].sem_ast_tail =
      &(sem_stack[sem_top].sem_ast_ptr->ast_next);
   sem_top--;

   return;

}

/*\
 *  \semact{first expression in tuple list}
 *  \semcell{expression}
 *  \sembottom
 *
 *  When this action is invoked, we've just scanned the first expression
 *  in a tuple expression list. We have to make it a child of a list node.
\*/

/*
 *  Rule: <tuple_list> ::= <tuple_element>
 */

case 251 :

{

#ifdef TRAPS

   verify_sem(sem_top,SEM_AST);

#endif

   build_ast(SETL_SYSTEM ast_list,"1",NULL);
   sem_stack[sem_top].sem_ast_tail =
      &((sem_stack[sem_top].sem_ast_ptr->ast_child.ast_child_ast)->ast_next);

   return;

}

/*\
 *  \semact{placeholders}
 *
 *  \setl\ allows enumerated tuples to appear on the left hand side of
 *  assignment expressions, indicating a tuple element to be discarded.
 *  All we do here is insert a placeholder node in the AST.
\*/

/*
 *  Rule: <tuple_element> ::= -
 */

case 253 :

{

   /* remove dash from top of stack */

   sem_top--;

   /* build placeholder */

   build_ast(SETL_SYSTEM ast_placeholder,"",&(sem_stack[sem_top].sem_file_pos));

   return;

}


default :

   return;

}}

/*\
 *  \function{init\_semacts()}
 *
 *  This function initializes the semantic actions.  All we do is set the
 *  current procedure to the root.
\*/

void init_semacts()

{

   sem_top = -1;
   unit_proctab_ptr = curr_proctab_ptr = predef_proctab_ptr;
   return;

}

/*\
 *  \function{close\_semacts()}
 *
 *  This function is called after we accept the input file.  If we are
 *  debugging, and a listing of the procedure tree is requested, we print
 *  it.
\*/

void close_semacts(SETL_SYSTEM_PROTO_VOID)

{

#ifdef DEBUG

   if (PROCTAB_DEBUG) {
      print_proctab(SETL_SYSTEM_VOID);
      fputs("\n",DEBUG_FILE);
   }

#endif

}

/*\
 *  \function{push\_token()}
 *
 *  This function pushes a token on the semantic stack.  It is called by
 *  the parser for all `important' tokens.
\*/

void push_token(
   SETL_SYSTEM_PROTO
   token_type *token)                  /* token passed from parser          */

{

   get_sem;
   sem_stack[sem_top].sem_type = SEM_NAMTAB;
   sem_stack[sem_top].sem_namtab_ptr = token->tk_namtab_ptr;
   sem_stack[sem_top].sem_token_subclass = token->tk_token_subclass;
   copy_file_pos(&sem_stack[sem_top].sem_file_pos,&(token->tk_file_pos));

}

/*\
 *  \function{build\_ast()}
 *
 *  This function creates an ast node, with some number of children.  The
 *  top {\em n} items on the semantic stack should all be abstract syntax
 *  trees, and are linked as children of the created node.
\*/

static void build_ast(
   SETL_SYSTEM_PROTO
   int type,                           /* type of node built                */
   char *template,                     /* template of semantic stack        */
   struct file_pos_item *file_pos)     /* root file position                */

{
ast_ptr_type ast_ptr;                  /* pointer to created item           */
ast_ptr_type first_child,*next_child;  /* first child node                  */
int num_children;                      /* number of children                */
char *p;                               /* temporary looping variable        */
int i;                                 /* temporary looping variable        */

   /* save the number of children */

   num_children = strlen(template);

   /* link together the children */

   first_child = NULL;
   next_child = &first_child;
   for (i = sem_top - num_children + 1, p = template; *p; i++, p++) {

      if (*p == '1') {

#ifdef TRAPS

         verify_sem(i,SEM_AST);

#endif
         *next_child = sem_stack[i].sem_ast_ptr;
         next_child = &((*next_child)->ast_next);

      }

#ifdef TRAPS

      else {
         verify_sem(i,SEM_NAMTAB);
      }

#endif

   }

   /* create the new node */

   ast_ptr = get_ast(SETL_SYSTEM_VOID);
   ast_ptr->ast_type = type;

   /* attach children */

   ast_ptr->ast_child.ast_child_ast = first_child;
   ast_ptr->ast_next = NULL;

   /* set the file position */

   if (file_pos != NULL) {

      copy_file_pos(&(ast_ptr->ast_file_pos),file_pos);

   }
   else if (num_children > 0) {

      copy_file_pos(&(ast_ptr->ast_file_pos),
                 &(sem_stack[sem_top - num_children + 1].sem_file_pos));

   }
   else {

      ast_ptr->ast_file_pos.fp_line = 0;
      ast_ptr->ast_file_pos.fp_column = 0;

   }

   if ((type==ast_sub)||(type==ast_uminus)) {
      namtab_ptr_type np; 
      for (i = sem_top - num_children + 1, p = template; *p; i++, p++) {
		 np = sem_stack[i].sem_namtab_ptr;
         if ((*p == '0')&&(np!=nam_dash)) ast_ptr->ast_extension=np;
      } 
   }
   
   
   /* replace the children by the new node, on the semantic stack */

   sem_top -= num_children;
   get_sem;
   sem_stack[sem_top].sem_type = SEM_AST;
   sem_stack[sem_top].sem_ast_ptr = ast_ptr;
   copy_file_pos(&sem_stack[sem_top].sem_file_pos,&(ast_ptr->ast_file_pos));

}

/*\
 *  \function{build\_method()}
 *
 *  This function builds a method from a template.  There are a number of
 *  these with somewhat different syntax, so we use this general function
 *  rather than creating many nearly identical semantic actions.
\*/

static void build_method(
   SETL_SYSTEM_PROTO
   int method_code,                    /* index of built-in method          */
   char *template)                     /* template of semantic stack        */

{
namtab_ptr_type namtab_ptr;            /* internal name of method           */
int sem_length;                        /* length of semantic stack entries  */
proctab_ptr_type new_proc;             /* pointer to new procedure          */
symtab_ptr_type symtab_ptr;            /* formal parameter pointer          */
char *p;                               /* temporary looping variable        */
int i;                                 /* temporary looping variable        */
int ext;                               /* Defining inside error_extension.. */
char extprocname[32];

  
   ext = NO;
   if (strncmp((unit_proctab_ptr->pr_namtab_ptr)->nt_name,
                "ERROR_EXTENSION",15)==0) ext = YES;

   /* save number of relevant entries */

   sem_length = strlen(template);
   if (ext==NO) 
     namtab_ptr = method_name[method_code];
   else {
     sprintf(extprocname,"$ERR_EXT%d",method_code);
     namtab_ptr = get_namtab(SETL_SYSTEM extprocname);
     


   }

   /* if we are not processing a class body, we've found an error */

   if ((unit_proctab_ptr->pr_type != pr_class_body)&&
       ((unit_proctab_ptr->pr_type!= pr_package_body)||(ext!=YES))) {
      

      error_message(SETL_SYSTEM &sem_stack[sem_top - sem_length + 1].sem_file_pos,
                    "Built-in methods are only valid in class bodies");

      return;

   }

   /* open up a new procedure */

   new_proc = get_proctab(SETL_SYSTEM_VOID);
   new_proc->pr_parent = curr_proctab_ptr;
   *(curr_proctab_ptr->pr_tail) = new_proc;
   curr_proctab_ptr->pr_tail = &(new_proc->pr_next);
   if (ext==NO) {
      new_proc->pr_namtab_ptr = namtab_ptr;
      new_proc->pr_type = pr_method;
      new_proc->pr_file_pos.fp_line = 0;
      new_proc->pr_file_pos.fp_column = 0;
   } else {
      new_proc->pr_namtab_ptr = namtab_ptr;
      new_proc->pr_type = pr_procedure;
      copy_file_pos(&(new_proc->pr_file_pos),
                    &(sem_stack[sem_top - sem_length + 1].sem_file_pos));
   }

   /* install the method name */

   new_proc->pr_symtab_ptr =
         enter_symbol(SETL_SYSTEM
                      namtab_ptr,
                      curr_proctab_ptr,
                      &(sem_stack[sem_top - sem_length + 1].sem_file_pos));

   if (new_proc->pr_symtab_ptr != NULL) {

    if (ext==NO) {
      (new_proc->pr_symtab_ptr)->st_type = sym_method;
      (new_proc->pr_symtab_ptr)->st_slot_num = method_code;
      (new_proc->pr_symtab_ptr)->st_class = unit_proctab_ptr;
    } else {
      (new_proc->pr_symtab_ptr)->st_type = sym_procedure;
      (new_proc->pr_symtab_ptr)->st_slot_num = 0;
      (new_proc->pr_symtab_ptr)->st_is_initialized = YES;
    }
    (new_proc->pr_symtab_ptr)->st_aux.st_proctab_ptr = new_proc;
    (new_proc->pr_symtab_ptr)->st_has_rvalue = YES;
    (new_proc->pr_symtab_ptr)->st_needs_stored = YES;
    (new_proc->pr_symtab_ptr)->st_is_declared = YES;
    (new_proc->pr_symtab_ptr)->st_is_public = YES;
   }

   /* install an empty list as initialization code */

   build_ast(SETL_SYSTEM ast_list,"",NULL);
   ast_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   ast_init_tail = &(ast_init_tree->ast_child.ast_child_ast);
   build_ast(SETL_SYSTEM ast_list,"",NULL);
   slot_init_tree = sem_stack[sem_top].sem_ast_ptr;
   sem_top--;
   slot_init_tail = &(slot_init_tree->ast_child.ast_child_ast);
   var_init_tree = NULL;
   var_init_tail = &var_init_tree;

   /* make the new procedure current */

   curr_proctab_ptr = new_proc;

   /* install the formal parameters */

   for (i = sem_top - sem_length + 1, p = template; *p; i++, p++) {

      if ((*p == '1')||((*p == 'S')&&(ext == YES))) {

#ifdef TRAPS

         verify_sem(i,SEM_NAMTAB);

#endif

         symtab_ptr = enter_symbol(SETL_SYSTEM
                                   sem_stack[i].sem_namtab_ptr,
                                   curr_proctab_ptr,
                                   &(sem_stack[i].sem_file_pos));

         if (symtab_ptr != NULL) {

            symtab_ptr->st_type = sym_id;
            symtab_ptr->st_has_lvalue = YES;
            symtab_ptr->st_has_rvalue = YES;
            symtab_ptr->st_is_rparam = YES;
            symtab_ptr->st_needs_stored = YES;

         }

         curr_proctab_ptr->pr_formal_count++;

      }

#ifdef TRAPS

      else {

         verify_sem(i,SEM_NAMTAB);

      }

#endif

   }

   /* pop the semantic stack */

   sem_top -= sem_length;

   return;

}

/*\
 *  \function{alloc\_sem()}
 *
 *  This function allocates a block in the semantic stack.  This table is
 *  organized as an `expanding array'.  That is, we allocate an array of a
 *  given size, then when that is exceeded, we allocate a larger array and
 *  copy the smaller to the larger.  This makes allocations slower than
 *  for the other tables, but makes it easy to reach down the stack, which
 *  we need to do in this table.  We don't expect the speed penalty to be
 *  a problem, since the stack should never get very big.
 *
 *  Notice: this function is only called indirectly, through the macro
 *  \verb"get_sem()".  Most of the time, all we need to do to allocate a
 *  new item is to increment the stack top.  We therefore defined a
 *  macro which did that, and called this function on a stack overflow.
\*/

static int alloc_sem(SETL_SYSTEM_PROTO_VOID)

{
struct sem_stack_item *temp_sem_stack; /* temporary semantic stack          */

   /* expand the table */

   temp_sem_stack = sem_stack;
   sem_stack = (struct sem_stack_item *)malloc((size_t)(
               (sem_max + SEM_BLOCK_SIZE) * sizeof(struct sem_stack_item)));
   if (sem_stack == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   /* copy the old table to the new table, and free the old table */

   if (sem_max > 0) {

      memcpy((void *)sem_stack,
             (void *)temp_sem_stack,
             (size_t)(sem_max * sizeof(struct sem_stack_item)));

      free(temp_sem_stack);

   }

   sem_max += SEM_BLOCK_SIZE;

   return ++sem_top;

}
/*\
 *  \function{verify\_sem()}
 *
 *  This function is used many places, simply to verify that the
 *  semantic stack is reasonable.  We can't actually verify that it is
 *  correct, but we can check whether an expected item is present, and
 *  that it is of the correct type.
\*/

#ifdef TRAPS

static void verify_sem(
   int stack_ptr,                      /* item to be checked                */
   int item_type)                      /* expected item type                */

{

#ifdef DEBUG

   if ((stack_ptr) < 0 || sem_stack[(stack_ptr)].sem_type != (item_type)) {
      print_sem(SETL_SYSTEM_VOID);
      trap(__FILE__,__LINE__,msg_bad_sem_stack);
   }

#else

   if ((stack_ptr) < 0 || sem_stack[(stack_ptr)].sem_type != (item_type))
      trap(__FILE__,__LINE__,msg_bad_sem_stack);

#endif

}

#endif

/*\
 *  \function{print\_sem()}
 *
 *  During debugging, it is frequently useful to print the semantic
 *  stack.  One of the more difficult tasks in building a compiler is
 *  writing the semantic actions.  When the stack isn't as expected, it
 *  helps to be able to easily print it.
\*/

#ifdef DEBUG

static void print_sem(SETL_SYSTEM_PROTO_VOID)

{
int i;                                 /* temporary looping variable        */

   fputs("\nSemantic Stack\n--------------\n\n",DEBUG_FILE);

   for (i = sem_top; i >= 0; i--) {

      if (sem_stack[i].sem_type == SEM_AST) {
         fprintf(DEBUG_FILE,"item %2d: AST =>\n",i);
         print_ast(SETL_SYSTEM sem_stack[i].sem_ast_ptr,NULL);
         fputs("\n",DEBUG_FILE);
      }
      else {
         fprintf(DEBUG_FILE,"item %2d: name => %s\n",
                 i,sem_stack[i].sem_namtab_ptr->nt_name);
      }
   }
}

#endif

