/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{Real Numbers}
\*/

#ifndef REALS_LOADED

/* real node structure */

struct i_real_item {
   int32 r_use_count;                  /* usage count                       */
   double r_value;                     /* real value                        */
};

typedef struct i_real_item *i_real_ptr_type;
                                       /* real pointer                      */

/* global data */

#ifdef TSAFE
#define REAL_NEXT_FREE plugin_instance->real_next_free 
#else
#define REAL_NEXT_FREE real_next_free 

#ifdef SHARED

i_real_ptr_type real_next_free = NULL;
                                       /* next free header                  */

#else

extern i_real_ptr_type real_next_free;
                                       /* next free header                  */

#endif
#endif

/* allocate and free real nodes */

#ifdef HAVE_MPATROL

#define i_get_real(t) {\
   t = (i_real_ptr_type)malloc(sizeof(struct i_real_item));\
   if (t == NULL)\
      giveup(SETL_SYSTEM msg_malloc_error);\
}

#define i_free_real(s) free(s)

#else

#define i_get_real(t) {\
   if (REAL_NEXT_FREE == NULL) i_alloc_reals(SETL_SYSTEM_VOID); \
   t = REAL_NEXT_FREE; \
   REAL_NEXT_FREE = *((i_real_ptr_type *)(REAL_NEXT_FREE)); \
}

#define i_free_real(s) {\
   *((i_real_ptr_type *)(s)) = REAL_NEXT_FREE; \
   REAL_NEXT_FREE = s; \
}

#endif
/* public function declarations */

void init_interp_reals(SETL_SYSTEM_PROTO_VOID);      
                                      /* plant error trap                  */
void i_alloc_reals(SETL_SYSTEM_PROTO_VOID);        
                                      /* allocate a block of header nodes  */
i_real_ptr_type i_copy_real(SETL_SYSTEM_PROTO i_real_ptr_type);
                                       /* copy a real item                  */
double i_real_value(struct specifier_item *);
                                       /* value of real                     */

#define REALS_LOADED 1
#endif


