transcript access();
  comment    'analyzing access relation';
--access(x,y,s) if x is search argument in an associative access on y at s
--domain_access(x,f,f{x}), domain_access(x,f,f(x)) involving assoc. access
--retrieve(x,s,term) if x is retrieved from s within quantier or iterator
--range_retrieve(x,f,term) if x is retrieved from range f
--domain_retrieve is not defined
--scope(cond,point) if uses within cond can reach statements in point
--self_access(x,s,term) if the associative access x in s inside term is
--  a self access (i.e., x was retrieved from s)
--self_domain_access(x,f,term) if assoc. access x in domain f inside term
--  is a self access
--       VALUE FLOW GRAPH
--access_from(x,y) if access(x,y,z)
--access_from_domain(x,y) if domain_access(x,y,z)
--retrieve_from_range(x,y) if range_retrieve(x,y,z)
--retrieve_from(x,y) if retrieve(x,y,z)
--self_domain_accessed is not defined
--self_accesser(x) if self_access(x,y,term)
  rel access, retrieve, range_retrieve,
      domain_retrieve, domain_access, self_access,
      self_domain_access: [tree, tree, node];
      access_from, access_from_domain, retrieve_from_range,
      retrieve_from: [tree, tree];
      scope: [tree, node];
      self_domain_accessed, self_accesser: [tree];
  prompt
    self_access:  [1, 2, 3, ' is a self-access '];
  external down, right: [node, node];
           sub_type0: [typexpr, typexpr];
--           base_link0: [stree, typexpr];
           is_map0: [string];
  key self_access, self_domain_access, 
      domain_access, access, retrieve: [1, 2, 3];
      self_accesser, self_domain_accessed: [1];
begin
   domain_access(.x, .y, .z)
   -> access_from_domain(.x, .y);

   range_retrieve(.x, .y, .z)
   -> retrieve_from_range(.x, .y);

   access(.x, .y, .z)
   -> access_from(.x, .y);

   retrieve(.x, .y, .z)
   -> retrieve_from(.x, .y);

   match(%expr, .x in .y%)
   -> access(.x, .y, %expr, .x in .y%);

--   match(%expr, .x in .y%)  remove 7/7/94
--   -> access(.x, .y, %expr, .x in .y%);

   match(%expr, .x notin .y%)
   -> access(.x, .y, %expr, .x notin .y%);

   match(%statement, .s less:= .x;%)
   -> access(.x, .s, %statement, .s less:= .x;%);

   match(%expr, .f{.x}%)
   -> domain_access(.x, .f, %expr, .f{.x}%);

   match(%lexpr, .f{.x}%)
   -> domain_access(.x, .f, %lexpr, .f{.x}%);

   match(%expr, .f{.x}%)
   | retrieve(.z, %expr, .f{.x}%, .s)
   -> range_retrieve(.z, .f, .s);


   match(%expr, .f(.x)%) | is_map0(.f)
   -> domain_access(.x, .f, %expr, .f(.x)%);

   match(%lexpr, .f(.x)%) | is_map0(.f)
   -> domain_access(.x, .f, %lexpr, .f(.x)%);

   match(%expr, exists .z in .s%)
   -> retrieve(.z, .s, %expr, exists .z in .s%);

   match(%expr, exists .z in .s | .k%)
   -> retrieve(.z, .s, %expr, exists .z in .s | .k%);

   match(%expr, forall .z in .s%)
   -> retrieve(.z, .s, %expr, forall .z in .s%);

   match(%expr, forall .z in .s | .k%)
   -> retrieve(.z, .s, %expr, forall .z in .s | .k%);

   match(%iterator, .x in .s %)
   -> retrieve(.x, .s, %iterator, .x in .s%);

   match(%iter, .x in .s %)
   -> retrieve(.x, .s, %iter, .x in .s%);

   match(%iterator, .x in .s | .z %)
   -> retrieve(.x, .s, %iterator, .x in .s | .z%);

   match(%statement, while .x loop .y end loop;%)
   -> scope(.x, .y);

   match(%statement, if .x then .y end if;%)
   -> scope(.x, .y);

   match(%statement, if .x then .y else .z end if;%)
   -> scope(.x, .y);

   match(%statement, if .x then .y elseif .z end if;%)
   -> scope(.x, .y);

   match(%statement, for .x loop .y end loop;%)
   -> scope(.x, .y);

   scope(.x, .y) and down(.y, .z)
   -> scope(.x, .z);

   scope(.x, .y) and right(.y, .z)
   -> scope(.x, .z);

   self_access(.u, .v, .y)
   -> self_accesser(.u);

   scope(.x, .y) and access(.u, .v, .y) and retrieve(.u, .v, .x)
   -> self_access(.u, .v, .y);


--this rule is never used, because no rules exist for domain_retrieve 
   scope(.x, .y) and domain_access(.u, .v, .y) and domain_retrieve(.u, .v, .x)
   -> self_domain_access(.u, .v, .y);

   self_domain_access(.u, .v, .y)
   -> self_domain_accessed(.u);

end;
