transcript base();
  comment 'structure type analysis';

--is_om is defined in rwub
--is_string is undefined
--is_record(x) if prog. variable x is of record type - same as is_record0?
--is_array(x) if prog. variable x is of array type - same as is_array0?
--is_map(x) if prog. variable x is of map type - same as is_map0
--not_map(x) to distinguish arrays, procs, & records x from maps
--array_type(b,t) if type var b represents a set type as an array with
--  element type t - is identical to array_type0
--subtype(b1,t) if type var b1 is a subtype of type expr t
--cbasible(b) if lfp(e,x) with btype(x,set(b)) or cbasible(b) is inferred
--  from the same sort of rules as basible(b)
--basible(b) if lfp(e,x) with btype(e,set(b)) and cbasible(b), or basible(b)
--  is inferred from the same sort of rules as for cbasible
--base(b) if type var b is a base
--base_link(e,b) if type variable b represents the base type of expression e 
--domain_link1(f,b) type var. b represents the domain type of f
--range_link1(f,b) type var. b represents the range type of f
--btype(e,t) if prog. expr e is of subtype t
--field_index 
--field_index(b,n,b1) if b represents type (q) and b1 is the translated form
--   of the nth suffix of q; augmented from field_indx
--not_variable(x) is copied from not_var in is_proc, and updated here
--  for constants true and false
  rel base_link, domain_link1, range_link1, btype: [tree, typexpr];
      is_om: [string];
      is_string: [tree, string];
      is_record, is_array: [tree];
      is_map: [tree];
      not_variable: [tree];
      not_map: [tree];
      array_type: [typexpr, typexpr];
      subtype: [typexpr, typexpr];
      cbasible, basible, base: [typexpr];
      field_index: [string, string, typexpr];
  prompt
     base_link: [1, ': ', 2];
     domain_link1: ['domain of ', 1, ': [set ', 2, ']'];
     subtype: [1, ' < ', 2];
     btype: [1, ': ', 2];
     range_link1: ['range of ', 1, ': [set ', 2, ']'];
     basible: [1, ': basible'];
     cbasible: [1, ': basible (c)'];
     base: [1, ': base'];
 external free: [tree];
          created: [tree, typexpr];
          sb_array: [typexpr, stree];
          access, retrieve, domain_retrieve, domain_access, self_access,
          self_domain_access: [tree, tree, node];
         access_from_domain, access_from, retrieve_from,
          retrieve_from_range: [tree, tree];
         field_indx: [string, string, typexpr];
         base_link0: [stree, typexpr];
         array_type0, sub_type0: [typexpr, typexpr];
         sb: [string, typexpr];
         is_record0, is_array0, is_proc: [string];
         not_var: [tree];
         is_map0: [string];
 incremental base_link, domain_link1,
             range_link1, btype, subtype: unify;
 key base_link, not_map, is_record, array_type,
     is_array, subtype, basible, is_om, btype, domain_link1,
     range_link1, is_string: [1];
     field_index: [1,2];
begin
--
-- type initialization for experessions
--
-- .e : nil => .e : new(b)     [  base_link(.e,new(b))  ]
--
   match(%expr, .x%)
   | null(z, base_link(.x, z))
   -> base_link(.x, newatom(b));

   match(%bexpr, .x%)
   | null(z, base_link(.x, z))
   ->   base_link(%bexpr, .x%, newatom(b));

   match(%lexpr, .x%)
   | null(z, base_link(.x, z))
   -> base_link(.x, newatom(b));

---------------------------------------------------------------------------

   base_link(.x, .i) and subtype(.i, .j) 
   ->   btype(.x, .j);

   base_link(.x, .i) and btype(.x, .j) 
   ->  subtype(.i, .j);

   access_from_domain(.x, .y) and null(z, domain_link1(.y, z))
   -> domain_link1(.y, newatom(b));

   retrieve_from_range(.x, .y) and null(z, domain_link1(.y, z))
   -> domain_link1(.y, newatom(b));

   null(z,range_link1(.x, z)) and domain_link1(.x, .i) 
   ->   range_link1(.x, newatom(b));

   null(z,domain_link1(.x, z)) and range_link1(.x, .i) 
   ->  domain_link1(.x, newatom(b));

   access_from(.x, .y) and null(z, btype(.y, z))
   -> btype(.y, [set, newatom(b)]);

   retrieve_from(.x, .y) and base_link(.x, .b)
   -> btype(.y, [set, .b]);

   retrieve_from_range(.x, .y) and base_link(.x, .b)
   -> range_link1(.y, .b);


   domain_link1(.x, .b) and null(z, btype(.x, z))
   -> btype(.x, [set, newatom(b)]);

   field_indx(.x,.y,.z) -> field_index(.x,.y,.z);  -- added 5/25/97

   domain_link1(.m, .i) and 
   range_link1(.m, .j) and 
   btype(.m, [set,.k]) 
   ->   subtype(.k, [record, [2, [.i, [.j, []]]]]) and
        field_index(.k, 1, .i) and
        field_index(.k, 2, .j);

   access_from_domain(.x, .y) and 
   domain_link1(.y, .b1) and
   base_link(.x, .b2) and
   basible(.b1) and
   basible(.b2)
   -> domain_link1(.y, .b2) and
      base(.b2);

   access_from(.x, .y) and 
   base_link(.y, .b1) and
   base_link(.x, .b2) and
   basible(.b1) and
   basible(.b2)
   -> subtype(.b1, [set, .b2]) and
      base(.b2);

   base_link0(.x, .b)
   -> base_link(.x, .b);

   sub_type0(.b, .b1)
   -> subtype(.b, .b1);

   subtype(.b, [record, [2, [.b1, .b2]]]) and sb(.b1, .b3)
   -> subtype(.b, [record, [2, [.b3, .b2]]]);

   subtype(.b, [set, .b1]) and sb(.b1, .b2)
   -> subtype(.b, [set, .b2]);

   free(.v) and base_link(.v, .i) 
   ->   basible(.i);

   basible(.i) 
   ->   cbasible(.i);

   basible(.i) and subtype(.i, [set, .j]) 
   ->   basible(.j);

   basible(.i) and field_index(.i, .n, .j) 
   ->   basible(.j);

   basible(.i) and array_type(.i, .j) 
   ->   basible(.j);

   cbasible(.i) and subtype(.i, [set, .j]) 
   ->   cbasible(.j);

   cbasible(.i) and field_index(.i, .n, .j) 
   ->  cbasible(.j);

   match(%expr, .v%)
   |   cnt(%expr, .v%) and base_link(%expr, .v%, .i) 
   ->   basible(.i);

   match(%expr, (.x)%)
   |   base_link(%expr, .x%, .t) 
   ->   base_link(%expr, (.x)%, .t);

   match(%expr, .m{.x}%)
   |   range_link1(%expr, .m%, .i2) 
   ->   btype(%expr, .m{.x}%, [set,.i2]);

   match(%lexpr, .m{.x}%)
   |   range_link1(%expr, .m%, .i2) 
   ->   btype(%lexpr, .m{.x}%, [set,.i2]);

   match(%expr, .m(.x)%)
   |   range_link1(.m, .b) 
   ->  base_link(%expr, .m(.x)%, .b);

   match(%lexpr, .m(.x)%)
   |   range_link1(.m, .b) 
   ->  base_link(%lexpr, .m(.x)%, .b);

   match(%expr, .m(.x)%)
   |   domain_link1(.m, .b) 
   ->  base_link(.x, .b);

   match(%lexpr, .m(.x)%)
   |   domain_link1(.m, .b) 
   ->  base_link(.x, .b);

   match(%expr, .m(.x)%)
   |   sb_array(.b, .m) 
   ->  base_link(%expr, .m(.x)%, .b);

   match(%lexpr, .m(.x)%)
   |   sb_array(.b, .m)
   ->  base_link(%lexpr, .m(.x)%, .b);

   match(%expr, .m(.x)%)
   |   base_link(.m, .b) and field_index(.b, .x, .b1)
   ->  base_link(%expr, .m(.x)%, .b1);

   match(%lexpr, .m(.x)%)
   |   base_link(.m, .b) and field_index(.b, .x, .b1)
   ->  base_link(%lexpr, .m(.x)%, .b1);

   match(%expr, .m[.x]%)
   |   range_link1(%expr, .m%, .i) 
   ->   btype(%expr, .m[.x]%, [set, .i]);

   match(%expr, .m[.x]%)
   |   null(z, btype(%expr, .x%, [set,z])) 
   ->   btype(%expr, .x%, [set,newatom(b)]);

   match(%expr, .m[.x]%)
   |   btype(.x, [set, .b])
   ->   domain_link1(.m, .b);

   match(%expr, .f~%)
   |   range_link1(%expr, .f%, .i) and basible(.i) 
   ->   base(.i);

   match(%expr, domain .m%)
   |   null(z,domain_link1(%expr, .m%, z)) 
   ->   domain_link1(%expr, .m%, newatom(b));

   match(%expr, domain .m%)
   |   domain_link1(%expr, .m%, .i) 
   ->   btype(%expr, domain .m%, [set, .i]);

   match(%expr, range .m%)
   |   range_link1(%expr, .m%, .i) and basible(.i) 
   ->   base(.i);

   match(%expr, range .m%)
   |   null(z,domain_link1(%expr, .m%, z)) 
   ->   domain_link1(%expr, .m%, newatom(b));

   match(%expr, range .m%)
   |   range_link1(%expr, .m%, .i) 
   ->   btype(%expr, range .m%, [set, .i]);

   match(%expr, arb .x%)
   ->   btype(%expr, .x%, [set,newatom(b)]);

   match(%expr, arb .x%)
   |   btype(%expr, .x%, [set,.i]) 
   ->   base_link(%expr, arb .x%, .i);

   match(%expr, {.e1: .x in .e2 | .e3}%)
   |   base_link(%expr, .e1%, .j) 
   ->   btype(%expr, {.e1: .x in .e2 | .e3}%, [set, .j]);

   match(%expr, {.e1: .x in .e2 | .e3}%)
   ->   base_link(%expr, .x%, newatom(b));

   match(%expr, {.e1: .x in .e2 | .e3}%)
   ->   base_link(%expr, .e1%, newatom(b));

   match(%expr, {.e1: .x in .e2 | .e3}%)
   |   base_link(%expr, .e1%, .i) and basible(.i) 
   ->   base(.i);

   match(%expr, .x subset .y%)
   ->   btype(%expr, .x%, [set, newatom(b)]) and  
       btype(%expr, .y%, [set, newatom(b)]);

   match(%expr, .x subset .y%)
   |   btype(%expr, .x%, [set, .i1]) and btype(%expr, .y%, [set, .i2])
       and basible(.i1) and basible(.i2) 
   ->   btype(%expr, .y%, [set, .i1]) and base(.i1);

   match(%expr, .x = .y%)
   |   btype(%expr, .x%, [set, .i1]) and btype(%expr, .y%, [set, .i2])
       and basible(.i1) and basible(.i2) 
   ->   btype(%expr, .y%, [set, .i1]) and base(.i1);

   match(%expr, .x + .y%)
   |   btype(%expr, .x%, [set, .j1]) and btype(%expr, .y%, [set, .j2]) 
       and  basible(.j1) and basible(.j2) 
   ->   btype(%expr, .x + .y%, [set,.j1]) and btype(%expr, .y%, [set, .j1]) 
        and base(.j1);

   match(%expr, .x + .y%)
   |   btype(%expr, .x%, [set, .j1]) and btype(%expr, .y%, [set, .j2]) and 
       btype(%expr, .x+.y%, [set, .j3]) and 
       cbasible(.j1) and cbasible(.j2) 
   ->   cbasible(.j3);

   match(%expr, .x + .y%)
   |   null(z,btype(%expr, .y%, [set, z])) and btype(%expr, .x%, [set, .i]) 
   ->   btype(%expr, .y%, [set, newatom(b)]);

   match(%expr, .x + .y%)
   |   null(z,btype(%expr, .x+.y%, [set, z])) and btype(%expr, .y%, [set, .i]) 
   ->   btype(%expr, .x+.y%, [set, newatom(b)]);

   match(%expr, .x + .y%)
   |   null(z,btype(%expr, .x%, [set, z])) and btype(%expr, .x+.y%, [set, .i]) 
   ->   btype(%expr, .x%, [set, newatom(b)]);

   match(%expr, .x - .y%)
   |   btype(%expr, .x%, [set, .j1]) and btype(%expr, .y%, [set, .j2]) and  
       basible(.j1) and basible(.j2) 
   ->   btype(%expr, .x - .y%, [set,.j1]) and btype(%expr, .y%, [set, .j1])
        and  base(.j1);

   match(%expr, .x - .y%)
   |   btype(%expr, .x%, [set, .j1]) and btype(%expr, .y%, [set, .j2]) and 
       btype(%expr, .x-.y%, [set, .j3]) and cbasible(.j1) and cbasible(.j2) 
   ->   cbasible(.j3);

   match(%expr, .x - .y%)
   |   null(z,btype(%expr, .y%, [set, z])) and btype(%expr, .x%, [set, .i]) 
   ->   btype(%expr, .y%, [set, newatom(b)]);

   match(%expr, .x - .y%)
   |   null(z,btype(%expr, .x-.y%, [set, z])) and btype(%expr, .y%, [set, .i]) 
   ->   btype(%expr, .x-.y%, [set, newatom(b)]);

   match(%expr, .x - .y%)
   |   null(z,btype(%expr, .x%, [set, z])) and btype(%expr, .x-.y%, [set, .i]) 
   ->   btype(%expr, .x%, [set, newatom(b)]);

   match(%expr, .x * .y%)
   |   btype(%expr, .x%, [set, .j1]) and btype(%expr, .y%, [set, .j2]) and  
       basible(.j1) and basible(.j2) 
   ->  btype(%expr, .x * .y%, [set,.j1]) and btype(%expr, .y%, [set, .j1]) and 
       base(.j1);

   match(%expr, .x * .y%)
   |   btype(%expr, .x%, [set, .j1]) and btype(%expr, .y%, [set, .j2]) and 
       btype(%expr, .x*.y%, [set, .j3]) and cbasible(.j1) and cbasible(.j2) 
   ->   cbasible(.j3);

   match(%expr, .x * .y%)
   |   null(z,btype(%expr, .y%, [set, z])) and btype(%expr, .x%, [set, .i]) 
   ->   btype(%expr, .y%, [set, newatom(b)]);

   match(%expr, .x * .y%)
   |   null(z,btype(%expr, .x*.y%, [set, z])) and btype(%expr, .y%, [set, .i]) 
   ->   btype(%expr, .x*.y%, [set, newatom(b)]);

   match(%expr, .x * .y%)
   |   null(z,btype(%expr, .x%, [set, z])) and btype(%expr, .x*.y%, [set, .i]) 
   ->   btype(%expr, .x%, [set, newatom(b)]);

   access_from(.x, .y) and base_link(.y, .i)
   -> basible(.i);

   access_from_domain(.x, .y) and base_link(.y, .i)
   -> basible(.i);

   retrieve_from(.x, .y) and base_link(.y, .i)
   -> basible(.i);

   retrieve_from(.x, .y) and access_from(.x, .y1) and
   btype(.y, [set, .b1]) and btype(.y1, [set,.b2])
   -> btype(.y1, [set, .b1]);

   retrieve_from(.x, .y) and access_from_domain(.x, .y1) and
   btype(.y, [set,.b1]) and domain_link1(.y1, .b2)
   -> btype(.y, [set,.b2]);

   match(%statement, .x with:= .y;%)
   | btype(.x, [set, .b1]) and 
     basible(.b1)
   -> base_link(.y, .b1);
     
   match(%statement, .x with:= .y;%)
   | not is_map(.x)
   -> btype(.x, [set, newatom(b)]);

   match(%expr, stl_open(.x)%)
   -> btype(%expr, stl_open(.x)%, [pointer, file]);   

   match(%expr, stl_close(.x)%)
   -> btype(%expr, stl_cose(.x)%, int);   

   match(%expr, .x%)
   |   eq(lextyp(.x), string)
   -> base_link(%expr, .x%, str);

   match(%expr, .x%)
   |  eq(lextyp(.x), int)
   -> base_link(.x, int);   

   is_map(.v) and 
   btype(.v, [set, .b]) and  
   field_index(.b, 1, .n1) and
   field_index(.b, 2, .n2)
   ->  domain_link1(.v,.n1) and 
       range_link1(.v,.n2);

   match(%statement, .x +:= .y;%)
   | base_link(.y, .b)
   -> base_link(.x, .b);

   match(%statement, .x -:= .y;%)
   | base_link(.y, .b)
   -> base_link(.x, .b);

   match(%statement, .x less:= .y;%)
   |  base_link(.x, .b) and 
      base_link(.y, .b1)
   -> subtype(.b, [set, .b1]);

   not_var(.x) -> not_variable(.x);   -- added 5/25/97

   match(%expr, true%)
   |  base_link(%expr, true%, .b)
   -> subtype(.b, bool) and not_variable(%expr, true%);   

   match(%expr, false%)
   |  base_link(%expr, false%, .b)
   -> subtype(.b, bool) and not_variable(%expr, false%);   

   match(%statement, .x := .y;%)
   | base_link(.y, .b)
   -> base_link(.x, .b);
  
   base_link(.x, .b) and subtype(.b, [record, .t])
   ->  not_map(.x);

   array_type0(.x, .y) 
   -> array_type(.x, .y);

   match(%expr, .x%)
   | is_record0(.x) 
   -> is_record(.x) and not_map(.x);

   match(%lexpr, .x%)
   | is_record0(.x) 
   -> is_record(.x) and not_map(.x);

   match(%expr, .x%)
   | is_array0(.x) 
   -> is_array(.x) and not_map(.x);

   match(%lexpr, .x%)
   | is_array0(.x) 
   -> is_array(.x) and not_map(.x);

   match(%expr, .x%)
   | is_proc(.x) 
   -> not_map(.x);

   match(%lexpr, .x%)
   | is_proc(.x) 
   -> not_map(.x);

   match(%expr, .x%)
   | is_map0(.x) 
   -> is_map(.x);

   match(%lexpr, .x%)
   | is_map0(.x) 
   -> is_map(.x);

   match(%expr, clfp(.x, .y, .z)%)
   |   btype(%expr, .x%, [set, .i]) and cbasible(.i) and
       btype(%expr, .y%, [set, .j]) and cbasible(.j) 
   ->  btype(%expr, clfp(.x, .y, .z)%, [set,.i]) and 
       btype(%expr, .y%, [set, .i]) and 
       btype(%bexpr, .z%, [set, .i]) and 
       base(.i) and basible(.i);

   match(%expr, cgfp(.x, .y, .z)%)
   |   btype(%expr, .x%, [set, .i]) and cbasible(.i) and
       btype(%expr, .y%, [set, .j]) and cbasible(.j) 
   ->  btype(%expr, cgfp(.x, .y, .z)%, [set,.i]) and 
       btype(%expr, .y%, [set, .i]) and 
       btype(%bexpr, .z%, [set, .i]) and 
       base(.i) and basible(.i);

   match(%expr, clfp(.x, .y, .z)%)
   |   btype(%bexpr, .z%, [set, .i]) and 
       null(z, btype(%expr, .x%, [set, z]))
   ->  btype(%expr, .x%, [set, newatom(b)]);

   match(%expr, cgfp(.x, .y, .z)%)
   |   btype(%bexpr, .z%, [set, .i]) and 
       null(z, btype(%expr, .x%, [set, z]))
   ->  btype(%expr, .x%, [set, newatom(b)]);

   match(%expr, clfp(.x, .y, .z)%)
   |   btype(%bexpr, .z%, [set, .i]) 
   ->   cbasible(.i);

   match(%expr, cgfp(.x, .y, .z)%)
   |   btype(%bexpr, .z%, [set, .i]) 
   ->   cbasible(.i);

end;

