transcript basev();
  comment    'finding subtypes of variables';
--key_type is undefined
--input_var(x) if x is a variable in a read statement
--sub_type(b1,b2) is the same as subtype, but augmented with new constraints
--  that take the domains and ranges of maps into account
--domain_link(f,b) where f is a map and b is a new type variable
--range_link(f,b) where f is a map and b is a new type variable
--base_elem(x) if x is an expression that is based
--base_elemof(x,b) if x is an expression, b is base, and e:b
  rel key_type: [tree];
      input_var: [tree];
      sub_type: [typexpr, typexpr];
      domain_link, range_link: [tree, typexpr];
      base_elem: [tree];
      base_elemof: [tree, string];
  external ftype, btype, base_link, domain_link1,
           range_link1: [tree, typexpr];
           subtype: [typexpr, typexpr];
           free: [tree];
           access_from, access_from_domain,
           retrieve_from, retrieve_from_range: [tree, tree]; 
           sb_array: [typexpr, stree];
           transub: [typexpr, typexpr, typexpr];
           based: [typexpr];
  incremental sub_type, domain_link, range_link: unify;
  key  domain_link, range_link, base_elemof,
        key_type, sub_type: [1];
begin

-- take into account the fact that the domain of a map is a set

   domain_link1(.x, .t)
   -> domain_link(.x, newatom(b));

   domain_link1(.x, .t) and domain_link(.x, .b)
   -> sub_type(.b, [set, .t]);

-- and each image set is also a set

   range_link1(.x, .t)
   -> range_link(.x, newatom(b));

   range_link1(.x, .t) and range_link(.x, .b)
   -> sub_type(.b, [set,.t]);

   subtype(.x, .y)
   -> sub_type(.x, .y);

   base_link(.x, .b) and based(.b)
   -> base_elemof(.x, .b) and base_elem(.x);

   btype(.x, .b) and based(.b)
   -> base_elemof(.x, .b) and base_elem(.x);

-- rules to compute the variables in read statements------

   match(%statement, read(.x);%)
   | eq(lchild(.x), nil)
   -> input_var(.x);

   match(%lexpr, .x%)
   |  input_var(.x) and neq(rsyb(.x), nil)
   -> input_var(rsyb(.x));

   match(%statement, read(.x);%)
   | neq(lchild(.x), nil)
   -> input_var(lchild(.x));

end;
