transcript created();
  comment     'finding created objects';
--created(e,type of e) <-> the value of e is created (not found in input, and
--                         hence, not found in any base)
  rel created: [tree, typexpr];
  external is_proc: [string];
  language setl;
  incremental created: semi_unify;
  key created: [1];
begin

-- rules for expressions

  match(%expr, .x+.y%)
  | null(z, created(.x, z)) and null(z, created(.y, z))
  -> created(%expr, .x+.y%, newatom(t));

  match(%expr, .x+.y%)
  | created(.x, .t)
  -> created(%expr, .x+.y%, .t);

  match(%expr, .x+.y%)
  | created(.y, .t)
  -> created(%expr, .x+.y%, .t);

  match(%expr, .p(.x)%)
  | is_proc(.p)
  -> created(%expr, .p(.x)%, newatom(t));

  match(%expr, .x%)  
  |  eq(lextyp(.x), int)
  -> created(.x, int);

-- rules for assignment

  match(%statement, .x .op:= .y; %)  --fix Apr. 7, 1995
  | null(z, created(.y, z))
  -> created(%expr, .x%, newatom(t));

  match(%statement, .x .op:= .y;%)  --fix Apr. 7, 1995
  | created(.y, .t)
  -> created(.x, .t);

  match(%statement, .x with:= .y;%)
  | created(.y, .t)
  -> created(.x, [.t]);

  match(%statement, .x less:= .y;%) --fix Apr. 7, 1995
  | created(.y, .t)
  -> created(.x, [.t]);

  match(%statement, .x := .y;%)
  | created(.y, .t)
  -> created(.x, .t);

  match(%statement, .x from .y;%)
  | created(.y, [.t])
  -> created(.x, .t);


end;
