transcript premono();
  comment 'finding monotone operands';
--monexpr1(x,y) if unary expression x is monotone in y
--monexpr2(x,y,z) if binary expression x is monotone in both its arguments
--                y and z
  rel monexpr1: [tree, tree];      
      monexpr2: [tree, tree, tree];
  language setl;
begin
  match(%expr, #.x%) 
  -> monexpr1(%expr, #.x%, %expr, .x%);
  match(%expr, .x~%) 
  -> monexpr1(%expr, .x~%, %expr, .x%);
  match(%expr, (.x)%) 
  -> monexpr1(%expr, (.x)%, %expr, .x%);
  match(%expr, .x + .y%) 
  ->   monexpr2(%expr, .x + .y%, %expr, .x%, %expr, .y%);
  match(%expr, .x * .y%) 
  ->   monexpr2(%expr, .x * .y%, %expr, .x%, %expr, .y%);
  match(%expr, .x & .y%) 
  ->   monexpr2(%expr, .x & .y%, %expr, .x%, %expr, .y%);
  match(%expr, [.x, .y]%) 
  ->   monexpr2(%expr, [.x, .y]%, %expr, .x%, %expr, .y%);
  match(%expr, .x or .y%) 
  ->   monexpr2(%expr, .x or .y%, %expr, .x%, %expr, .y%);
  match(%expr, .x[.y]%) 
  ->   monexpr2(%expr, .x[.y]%, %expr, .x%, %expr, .y%);
  match(%expr, domain .m%) 
  ->   monexpr1(%expr,  domain .m%, %expr, .m%);
  match(%expr, range .m%) 
  ->   monexpr1(%expr,  range .m %, %expr, .m%);
end;
