semantics srray;
--
-- semantic inference rules for Raytheon program preprocessing
--
transcript typeinfer();
--
-- This transcript produces two main relations - CALLOUT for c
-- callout and HANDLER for SETL2 handler
--
comment 'Preprocessor';
rel type: [tree,string];
    return_type: [string,string];
    smap,done,uses,class,package: [string];
prompt return_type : [1, ' : ', 2];
       type: [1, ' : ', 2];
language setl;
key smap,done,return_type,uses,class,package: [1];
--
-- minimal type inference for Raytheon problem -- augment relation
-- RETURN_TYPE, and produce relation TYPE
--
-- 1.  determine result types of proc calls
--
begin
match(%selector,.f(.y)%) | return_type(.f,.r) -> type(%selector,.f(.y)%,.r);
match(%selector,.f()%) | return_type(.f,.r) -> type(%selector,.f()%,.r);
match(%expr,.x. .f%) | type(.f,.t) -> type(%expr,.x. .f%,.t);
match(%expr,.f(.y)%) | class(.f) -> return_type(.f,object);
match(%expr,.f()%) | class(.f) -> return_type(.f,object);
match(%expr,.f(.y)%) | return_type(.f,.r) -> type(%expr,.f(.y)%,.r);
match(%expr,.f()%) | return_type(.f,.r) -> type(%expr,.f()%,.r);
--
-- 2.  further simple type inference
--
match(%expr,not .x%) | true -> type(.x,bool);
match(%expr,.y and .x%) | true -> type(.y,bool) and type(.x,bool);
match(%thenpart,.x then .b%) | true -> type(.x,bool);
end;

transcript callit();
comment 'generate callout and handler';
rel callout: [string,tree,string,string];
    done_call: [tree];
external type: [tree,string];
         class,package: [string];
prompt callout: ['service code ',1,' call ',2,' type= ',3,4];
language setl;
key callout: [2];
--
-- create service strings for SETL2 callback handler - produce relation
-- CALLOUT
--
-- 1.  0 arguments, 1 results
--
begin
match(%expr,.f(.y)%) | class(.f) and not done_call(%expr,.f(.y)%) ->
  bind(.x,concat(concat('\"',newatom(x)),'\"')) and
  callout(.x,%expr,.f(.y)%,void,object) and done_call(%expr,.f(.y)%);
match(%expr,.f()%) | class(.f) and not done_call(%expr,.f()%) ->
  bind(.x,concat(concat('\"',newatom(t)),'\"')) and
  callout(.x,%expr,.f()%,void,object) and done_call(%expr,.f()%);
match(%expr,.x. .f%) | not done_call(%expr,.x. .f%) and
  type(%expr,.x. .f%,.t) and (class(.x) or package(.x)) ->
  bind(.w,concat(concat('\"',newatom(x)),'\"')) and
  callout(.w,%expr,.x. .f%,void,.t) and done_call(%expr,.x. .f%);
--
-- 2.  0 arguments, 0 results
--
match(%statement,.x. .y;%) | not done_call(%statement,.x. .y;%) and
  (package(.x) or class(.x)) ->
  bind(.w,concat(concat('\"',newatom(x)),'\"')) and
  callout(.w,%statement,.x. .y;%,void,void) and done_call(%statement,.x. .y;%);
--
-- 3.  1 argument, 0 results
--
match(%statement,.x. .y;%) | not done_call(.y) and
  not package(.x) and not class(.x) ->
  bind(.w,concat(concat('\"',newatom(x)),'\"')) and
  callout(.w,.y,object,void) and done_call(.y);
--
--4.  1 argument, 1 result
--
match(%expr,.x. .f%) | not done_call(.f) and
  type(%expr,.x. .f%,.t) and not class(.x) and not package(.x) ->
  bind(.w,concat(concat('\"',newatom(x)),'\"')) and  
  callout(.w,.f,object,.t) and done_call(.f);
end;

transcript handle();
comment 'generate handler';
rel handler: [string,stree];
external callout: [string,tree,string,string];
prompt  handler: ['service code ',1,'handler= ',2];
language setl;
key handler: [1];
--
-- Analysis for SETL2 callback handler - produce relation HANDLER
--
begin
callout(.s,.c,void,void) -> handler(.s,%whenstmt,when .s => 
           .c%);
callout(.s,.c,void,object) ->handler(.s,%whenstmt,when .s =>
           t := newint();
           ^ t := .c;
           return str(t);%);
callout(.s,.c,void,string) ->handler(.s,%whenstmt,when .s =>
           return .c;%);
callout(.s,.c,void,bool) ->handler(.s,%whenstmt,when .s =>
           if .c then
              return "1";
           else
              return "0";
           end if;%);
callout(.s,.c,object,object) ->handler(.s,%whenstmt,when .s =>
           t := newint();
           ^ t := (^ unstr(arg)). .c;
           return str(t);%);
callout(.s,.c,object,bool)  ->handler(.s,%whenstmt,when .s =>
           if (^ unstr(arg)) . .c then
              return "1";
           else
              return "0";
           end if;%);
callout(.s,.c,object,int) ->handler(.s,%whenstmt,when .s =>
           return str((^ unstr(arg)). .c);%);
callout(.s,.c,object,void) ->handler(.s,%whenstmt,when .s =>
           (^ unstr(arg)). .c;%);                
end;
end semantics;

rewriting rwray;
-- rewriting rules to turn a SETL2 program into normal form
begin
-- set and tuple former normal form
        anf4 : match ( %
          expr ,
          { .x in .s | true } 
        %) | true -> rewrite ( %
          expr ,
          .s 
        %) ; 
        anf1 : match ( %
          expr ,
          { .x in .s | .k } 
        %) | true -> rewrite ( %
          expr ,
          { .x : .x in .s | .k } 
        %) ; 
        anf5 : match ( %
          expr ,
          { .x : .x in .s } 
        %) | true -> rewrite ( %
          expr ,
          .s 
        %) ; 
        anf2 : match ( %
          expr ,
          { .x : .x in .s | .k } 
        %) | true -> rewrite ( %
          expr ,
          { .x in .s | .k } 
        %) ; 
        anf6 : match ( %
          expr ,
          { .y : .x in .s } 
        %) | true -> rewrite ( %
          expr ,
          { .y : .x in .s | true } 
        %) ; 
        anf3 : match ( %
          expr ,
          { .y : .x in .s | true } 
        %) | true -> rewrite ( %
          expr ,
          { .y : .x in .s } 
        %) ; 
-- set and tuple former assignment normal form
setassn : match ( % statement,
         .t := {.e: .x in .s | .k};%) 
| true -> rewrite ( %
         block,
         .p := {};
         for .w in .s loop
           if .k then
             .p with:= .e;
           end if;
         end loop; 
         .t := .p; %) 
: where
     genvar(.w) and genvar(.p) and subst(.k,.x,.w) and subst(.e,.x,.w);
tupassn :  match ( % statement,
         .t := [.e: .x in .s | .k ];%) 
| true -> rewrite ( %
         block,
         .p := [];
         for .w in .s loop
           if .k then
             .p with:= .e;
           end if;
         end loop; 
         .t := .p; %) 
: where
     genvar(.w) and genvar(.p) and subst(.k,.x,.w) and subst(.e,.x,.w);
setadd : match ( % statement,
         .t +:= {.e: .x in .s };%) 
| true -> rewrite ( %
         statement,
         for .w in .s loop
             .t with:= .e;
         end loop; %)
: where
     genvar(.w) and subst(.e,.x,.w);
tupadd :  match ( % statement,
         .t +:= [.e: .x in .s ];%) 
| true -> rewrite ( %
         statement,
         for .w in .s loop
             .t with:= .e;
         end loop; %) 
: where
     genvar(.w) and subst(.e,.x,.w);
cleancond : match ( %statement,
         if true then .b end if;%) | true -> rewrite (% block,
             .b%);
-- var elimination
varinit : match(%statement,
           var .v := .e;%)
| true -> rewrite (%
         statement,
         .v := .e;%);
varelim : match(%statement,
           var .v ;%)
| isavar(.v) -> rewrite (%emptytree%);
-- cardinality elimination
cardelim :match(%expr, # .s = 0%) | true ->
          rewrite(%expr, .s /= {}%) :
          where genvar(.x);
--
-- rules for callout
--
-- 1. analysis for packages and classes and removal of declarations
--    produce relations PACKAGE, CLASS, and RETURN_TYPE
--
pc1:  match(%statement,.a : package(.d);%) | true ->
  rewrite(%emptytree%): package(.a);
pc2:  match(%statement,.a : class(.d);%) | true ->
  rewrite(%emptytree%): class(.a);
pc3:  match(%statement,.a: -> .t;%) | true ->
  rewrite(%emptytree%): return_type(.a,.t);
pc4:  match(%statement,.a: .d -> .t;%) | true ->
  rewrite(%emptytree%): return_type(.a,.t);  
pc5:  match(%statement,.a: smap;%) | true ->
  rewrite(%emptytree%): smap(.a);
pc6:  match(%statement,.f with:= [.d,.r];%) | smap(.f) ->
  rewrite(%statement, .f(.d) := .r;%);
--
-- 2. create calls to SETL2 callback handler, and create handler relations
--
-- a.  0 arguments, 1 result
--
call1:  match(%expr,.f(.y)%) | class(.f) and 
  callout(.s,%expr,.f(.y)%,void,.t) ->
  rewrite(%expr,setl2_ir(.s)%);
call2:  match(%expr,.f()%) | class(.f) and callout(.s,%expr,.f()%,void,.t) ->
  rewrite(%expr,setl2_ir(.s)%);
call3:  match(%expr,.x. .f%) | callout(.s,%expr,.x. .f%,void,string) ->
  rewrite(%expr,setl2_callback(.s,NULL)%);
call4:  match(%expr,.x. .f%) | callout(.s,%expr,.x. .f%,void,.u) and 
  neq(.u,string) ->
  rewrite(%expr,setl2_ir(.s)%);
--
-- b.  0 arguments, 0 results
--
call5:  match(%statement,.x. .y;%) | 
  callout(.s,%statement,.x. .y;%,void,void) ->
  rewrite(%statement,setl2_callback(.s,NULL);%);
--
-- c.  1 argument, 0 results
--
call6:  match(%statement,.x. .y;%) | callout(.s,.y,object,void) ->
  rewrite(%statement,setl2_ia(.s,.x);%);
--
--d.  1 argument, 1 result
--
call7:  match(%expr,.x. .f%) | callout(.s,%selector,.f%,object,.u) and 
  neq(.u,string) ->
  rewrite(%expr,setl2_iair(.s,.x)%);
--
-- turn type object into type int
--
type_correct: match(%type,object%) | true -> rewrite(%type,int%);
--
-- elminate uses - produce relation USES
--
useelim:  match(%statement, use .x;%) | true -> rewrite(%emptytree%) :
          uses(.x) ;
--
-- add proc types for callback
--
addtypes: match(%program,program .v; .b end .z;%) | true ->
  rewrite(%program, program .v; setl2_callback: proc;
  setl2_ir: proc; setl2_ia: proc; setl2_iair: proc;
  .b end .z; %);
--
-- create handler
--
-- 0. delete program body and introduce callout
--
hand1: match(%program,program .v; .b end .z;%) | 
 null(z,done(z)) and exists(.s,handler(.s,.c),true) -> 
  rewrite(%program,program .v; 
             var counter := 0;
             callout(1,callback_handler,[]); 
             procedure callback_handler(service,args);
               [arg] := args;
               case service
                 .c
               end case;
             end callback_handler;
             procedure newint();
              counter +:= 1;
              return counter;
             end newint;
             end .z;%) :
  done(.s) ;
--
-- 1.  add use statements
--
hand2: match(%program,program .i; .b end .j;%) | 
  exists(.v,uses(.v),not done(.v)) -> 
  rewrite(%program,program .i; use .v; .b end .j;%):
  done(.v);
hand3: match(%statement,case service .w end case;%) | 
       exists(.s,handler(.s,.c),not done(.s)) ->
       rewrite(%statement,case service .c .w  
                                 end case;%): done(.s);
end;
end rewriting;

closure rcray;
begin
-- turn program into naive normal form
primadd: setassn, tupassn, setadd, tupadd, varelim, varinit, cardelim,
         useelim ,
-- remove package and class declarations after extracting types
-- and computing relations USES, CLASS, PACKAGE, and RETURN_TYPE
         pc1, pc2, pc3, pc4, pc5;
normf: pc6;
-- introduce calls to setl2 callout utilities
gencalls:  call1, call2, call3,call4,call5,call6,call7,type_correct;
-- form handler - re-introduce use statements and case statement
formhandler: hand1, hand2, hand3;
end;
end closure;


commands cmray;
--
-- load Raytheon Preprocessor
--
    procedure rayload ( ) ; 
      loadsn language setl ; 
      loadsn rhs setl ; 
      loadsn lhs setl ; 
      loadrw rwray ; 
      loadrc rcray ; 
      loadsr srray ;
    end procedure ; 
--
-- load and execute Preprocessor
-- .input is input SETL2 Program
-- .output is translated Program (a SETL2 handler called by c)
--  raybnf.src is the SETL procedure to be translated into c
--
    procedure rayx ( .input , .output ) ; 
      rayload ; 
      parse .input;
      addtypes;
      database uses, class, package, return_type, smap;
      primadd;
      normf;
      usedb;
      analyze handler;
      database callout,class,handler,uses,done;
      initsm;
      gencalls;
      unparse raybnf;
      formhandler;
      unparse .output inf;
    end procedure ; 
--
-- Preprocessor test on Raytheon code
--
    procedure testray ( ) ; 
      print 'test Raytheon translator' ; 
      rayx ( rayin, handler.stl ) ; 
    end procedure ; 
end commands;
