syntax imp;

disterms :
aexp,aterm,afactor,loc,bexp,bterm,bfactor,relterm,com;

crterms : com;

lexterms :
patvar;

grammar :
--
-- lexical productions
--
lexeme = filler . (id  | int | patvar | any );
patvar = '.' id ;
filler = span ' \t\n' ;
--
-- syntactic productions
--
com = 'skip' | 'if' bexp 'then' com 'else' com | 'while' bexp 'do' com |
      loc = aexp;
bexp = bterm {'or' bexp};
bterm = bfactor {'and' bterm};
bfactor = 'true' | 'false' | 'not' bfactor | relterm | '(' bexp ')';
relterm = aexp ('=' | '<=') aexp ;
aexp = aterm {('+' | '-') aexp};
aterm = afactor {'*' aterm};
afactor = int | loc | '(' aexp ')' !;
loc = id !;
end syntax;
