syntax rsl;
disterms :
rslspec, srspec,head,ilist,dlist,dec,cdec,rdec, adec,
rdlist,rd,kd,while,end,loop_arg,if_arg,loop_ender,if_ender,if,
rtype,tlist,type,pdec,pdlist,pd,flist,
ftype, format, label, adlist, ad, atype,
cdecop,rdecop,edecop,ddecop,pdecop,ldecop,idecop,adecop,kdecop,
edec,ldec,idec,iodlist,iod,itype,srbody,srlist,srrule,srprocs,srproc,
lhside,match,cond,conj,term,atom,bool,plist,sexpr,par,rhside,
lhss, rhss, rterm, rewrite, commands, rwbody, rcbody, 
rwlist, rwrule, rcrule, rclist, rwname, rwnames,
rule, right, fdinit, init, diff, prediff, fdbody, fdlist,
fdrule, postdiff, farright,cmspec, pbody, commnd,
usercm, userop, zerocm, unarycm, sarg, sarglist, binarycm, misccm,
allarg, aarg, intargs, iarg, listop, loaddb, dparse, otherops,
unloaddb, unarynop, unaryfop, unarynopt, unaryfopt, binaryop, 
binaryopt, arglist, marg, marglist,rwspec,rcspec,fdspec,
submit, fdiff, locate, arg, unarysop, usercm, xproc,xprocs, cmbody, proc,
xbody, xspec,xpack,arglistn,argn,farg,xtype, srtrace,teql,tops,topid,newsyn,
snspec, snbody, snrule, snopa, snops, snopt, snopb, snopc,strmatch,
snopp, snopg, pairt, pairb, pairp, pairc, tclause, trhs, tcphrase, tatom,
pdelim, cender, alter,tclose,closures,rparen,rcurly,lang,pparse;

specsymbs : '->', '@+', '@-' ;

crterms :
dec,srrule, rwrule, rcrule, fdrule, fdinit, diff, rule,
commnd,cmspec,fdspec,srspec,rcspec,rwspec, xspec, xproc,
xspec, snrule, tclause, proc;

indentterms :
dlist, srbody, srlist, rwbody, rcbody, rwlist, 
  rclist, rhside, fdbody, fdlist, pbody, xbody,
xprocs, snbody, cmbody;

lexterms :string,foreign,patvar,fname;


grammar :
--
-- lexical productions
--
lexeme = opener ( include . opener ) * (fname | id | int | string | 
         specop | patvar | foreign | any);
opener = filler . ( comment . filler . ) * ;
string = '\''  break '\'\\' ( '\\' { '\'' | '\\' }  break '\'\\' ) * '\'' ;
include = anchor '#include' . filler .  fname;
patvar = '.' id ;
fname =   ('/' id ) + ('.' id) * |  
                   id  (  ('/' id) + ('.' id)* | ('.' id ) + ) ;
foreign = '%' . filler . ( 'emptytree' filler . | id @ 
                filler . ',' . break '%' ) '%' . @ ;
comment = '--' break '\n' ;
filler = span ' \t\n' ;
--
-- syntactic productions
--
-- rsl modules
--
rslspec = (xspec | cmspec | srspec | rwspec | rcspec | fdspec | snspec ) +;
--
-- interface modules
--
xspec = 'interface' { id } ';' xbody 'end' 'interface' ';' ;
xbody = xpack +;
xpack = 'fpackage' id ';' xprocs 'end' 'fpackage' ';' ;
xprocs = xproc + ;
xproc = 'procedure' id xtype ';' ;
xtype = '(' {arglist} ')' { '->' '('  arglistn ')' } ;
--
-- command modules
--
cmspec = 'commands' { id} ';' cmbody 'end' 'commands' ';';
cmbody = proc + ;
proc = 'procedure' id '(' { arglist } ')' ';' pbody 'end' 'procedure' ';' ;
pbody = commnd + ;
--
-- command formats
--
commnd = (zerocm | unarycm | binarycm | misccm | usercm ) ';' ;
--
-- commands with no arguments
--
zerocm = ( 'cleandb' | 'initax' | 'initfd' | 'initrw' | 'initrc' |
  'initsr' | 'initcm' | 'read' | 'stop' | 'usedb' | 'unusedb' |
  'test' | 'edit' | 'implicate' | 'return' | 'quit' |
  'rdclock' | 'stclock' | 'xcreate' | 'initx' | 'continue' | 'exit' ) ! ;
--
-- commands with at most one argument
--
unarycm = unaryfop farg | unarynop arg | unaryfopt {farg} | 
          unarynopt { arg } | unarysop sarg ;
unaryfop = ( 'loadax' | 'unloadax' | 'loadsm' | 'save' | 'resume' | 
 'unloadsm' ) !;
unarynop = ('analyze' | 'deletesr' | 'deletefd' | 'deleterw' |
 'deleterc' | 'deletecm' | 'deletex' | 'rewrite' | 'define' | 'clock' |
 'loadfd' | 'unloadfd' | 'loadrw' | 'unloadrw' | 'loadrc' | 'unloadrc'
 | 'loadcm' | 'unloadcm' | 'loadsr' | 'unloadsr' | 'loadx' | 'unloadx' |
 'unloadsn' | 'help' | 'trace' | 'untrace' | 'unclock' | 'reset' | 'tdeb' |
 'srlist' ) ! ;
unaryfopt = ('display' | 'rslc'|  'fdunparse' | 'cmunparse' | 'bootrsl' |
  'rcunparse' | 'rwunparse' |  'xunparse' ) ! ;
unarynopt =  ( 'initdb' | 'initsm' ) !;
unarysop = ('print' | 'system' | 'pause' ) ! ;
--
-- commands with at most two arguments
--
binarycm = binaryop arg farg | binaryopt {farg} {arg};
binaryop = 'loadsn' ! ;
binaryopt = ( 'unparse' | 'srunparse' ) !;
--
-- commands with user specified identifiers (e.g., function calls, 
-- transformations, closure rules, etc.
--
usercm = userop  { '(' marglist  ')' } ;
userop = id ! ;
--
-- special purpose commands
--
misccm =  loaddb farg { allarg | 'into' arglist } | 
  unloaddb farg {allarg | 'with' arglist } | listop arglist |
  submit farg { aarg } | fdiff { arglist { 'at' intargs} } | 
  locate { iarg | arg { arg } } | srtrace arg intargs | dparse { rhside } |
  while cond 'loop' pbody loop_ender | if cond 'then' pbody if_ender |
  pparse {farg {arg} | lang};		--addition added Nov. 5, 1994
listop = ('database' | 'maintain' | 'achieve') !;
loop_ender = end loop_arg;
if_ender = end if_arg;
loop_arg = 'loop' !;
if_arg = 'if' !;
loaddb = 'loaddb' !;
while = 'while' !;
if = 'if' !;
end = 'end' !;
dparse = 'dparse' !;
pparse = 'parse' !;		--addition added Nov. 5, 1994
unloaddb = 'unloaddb' !;
srtrace = 'srtrace' ! ;
submit = 'submit' !;
fdiff = 'fdiff' !;
locate = 'locate' !;
--
-- argument formats
--
lang = language !;		--addition added Nov. 5, 1994
sarg = string ! ;		--string
allarg = 'all' !;
aarg = '*' !;
iarg = int ! ;			--int
intargs = iarg +;
arg = id ! ;
arglist = arg ( ',' arg ) * ;
sarglist = sarg ( ',' sarg) * ;
farg = (fname | id ) ! ;	--unix file names
argn = id !;
arglistn = argn (',' argn ) * ;
marg = (arg | iarg | farg) ! ;	--most general format (but excludes strings)
marglist = marg ( ',' marg ) * ;
--
-- syntax modules
--
snspec = 'syntax' {id } ';' snbody 'end' 'syntax' ';' ;
snbody = snrule +;
snrule = snopa ':' arglist ';' | 
         snops ':' sarglist ';'|
         snopt ':' pairt (',' pairt) * ';' |
         snopb ':' pairb (',' pairb) * ';' |
         snopc ':' pairc (',' pairc) * ';' |
         snopp ':' pairp +  |
         snopg ':' tclause + ;
snopa = ('disterms' | 'crterms' | 'indentterms' | 'groupsyn' | 'lexterms') !;
snops = ('runops' | 'lunops' | 'binops' | 'specsymbs' ) !;
snopt = ('utop' | 'btop' ) !;
snopb = 'bracks' !;
snopc = 'convertsyn' !;
snopp = 'prec' !;
snopg = 'grammar' !;
pairt = sarg '>' arg ;
pairb = sarg '>' sarg ;
pairc = arg '>' arg ;
pairp = sarglist pdelim sarglist ';' ;
pdelim = '>' !;
tclause = id teql trhs cender;
teql = '=' ! ;
cender = ';' !;
trhs = tcphrase ( alter tcphrase )* ;
alter = '|' ! ;
tcphrase =  tclose + ;
tclose = tatom { closures };
closures = ('*' | '+' ) ! ;
tatom = ( '(' trhs rparen | '{' trhs rcurly | strmatch |
          newsyn ) % | otherops ;
otherops = ('^' | '!' | '%' | '@' | '.' |'-' | id | string | int ) ! ;
strmatch = tops string ;
newsyn = topid id ;
tops = ('break' | 'span') !;
topid = '#' ! ;
rparen = ')' !;
rcurly = '}' !;
--
-- semantic modules
--
srspec = 'semantics' {id} ';' srprocs 'end' 'semantics' ';' ;
srprocs = srproc + ;
srproc = head dlist srbody ;
head = 'transcript' id '(' { arglist } ')' ';' ;
--idlist =  id ( ',' id )*  ;
dlist =  dec +  ;
dec = cdec | rdec | edec | pdec | ldec | idec | kdec | adec | ddec;
cdec = cdecop sarg ';' ;
cdecop = 'comment' !;
rdec = rdecop rdlist ;
rdecop = 'rel' !;
rdlist = rd +  ;
rd = arglist ':' rtype ';' ;
--rnamelist = id (',' id )* ;
rtype = '[' tlist ']' ;
tlist = type (',' type )* ;
type = ('int' | 'string' | 'typexpr' | 'bool' | 'tree' | 'node' | 'gen'
       | 'stree') ! ; -- int and gen currently not handled
pdec = pdecop pdlist ;
pdecop = 'prompt' !;
pdlist = pd + ;
pd = arg ':' ftype ';' ;    
ftype = '[' flist ']' ;
flist = format (',' format)* ;
format = iarg | sarg | '[' arg ']';
edec = edecop rdlist ;
edecop = 'external' !;
ddec = ddecop rdlist ;
ddecop = 'database' !;
ldec = ldecop arg ';' ;
ldecop = 'language' !;
idec = idecop iodlist ;
idecop = 'incremental' !;
adec = adecop adlist ;
adecop = 'assumption' !;
iodlist = iod + ;
adlist = ad+ ;
iod = arglist ':' itype ';' ;
ad = arglist ':' atype ';' ;
itype = ('semi_unify' | 'unify' | 'replace') ! ;
atype = ('closed_world' | 'open_world') ! ;
kdec = kdecop kdlist ;
kdecop = 'key' !;
kdlist = kd + ;
kd = arglist ':' '[' intlist ']' ';' ;
intlist = iarg ( ',' iarg ) *  ;
srbody = 'begin' srlist 'end' ';' ;
srlist = srrule + ;
srrule = {label} lhside '->'  rhside ';'  ;
--
-- rewriting modules
--
rwspec = 'rewriting'{ id} ';' rwbody 'end' 'rewriting' ';' ;
rwbody = 'begin' rwlist 'end' ';' ;
rwlist = rwrule + ;
rwrule = label lhside '->' rewrite { ':' { rhside } { 'where' commands} } 
  ';' ;
--
-- closure modules
--
rcspec = 'closure'{ id} ';' rcbody 'end' 'closure' ';' ;
rcbody = 'begin' rclist 'end' ';' ;
rclist = rcrule + ;
rcrule = label rwnames ';' ;
rwnames = rwname ( ',' rwname ) * ;
rwname = id ! ;
--
-- invariant modules
--
fdspec = 'invariants' { id} ';' fdbody 'end' 'invariants' ';' ;
fdbody = 'begin' fdlist 'end' ';' ;
fdlist = fdrule + ;
fdrule = label fdinit ',' rule ',' diff + ';' ;
fdinit = init  { farright } ;
init = 'init' '(' rhss ')' ;
diff = ( prediff | postdiff ) { farright } ;
prediff = '@-' '<' lhss '>' '=' rhss ;
postdiff = '@+' '<' lhss '>' '=' rhss ;
rule = lhside '->' right ;
right = rewrite { farright} ;
farright = ':'  rhside  { 'where' commands} | 'where' commands ;
--
-- parts shared by sr, rw, and fd modules
--
label = id ':' ;
lhside = match  { '|' cond } | cond ; -- fix on 7/7/94
match = 'match' '(' lhss ')' ;
lhss = lhs ! ;
rhss = rhs ! ;
rewrite = 'rewrite' '(' rhss ')' ;
cond =  conj ( 'or' conj )* ;
conj = term ('and' term )*  ;
term = { 'not' } atom ;
atom =  '(' cond ')' | ( trterm ! ) | bool ;
trterm = id '(' { plist }  ')' ;
bool = (  'true' | 'false' ) ! ;
plist = par (',' par )* ;
par = cond | arg | iarg | sarg | sexpr  | rhss ;
sexpr = '[' { plist } ']';
rhside = rterm ('and' rterm )* ;
commands = rterm ('and' rterm )* ;
rterm = id '(' plist ')' ;
end syntax;
