semantics srub;
transcript eval();
  comment 'operational semantics for imp';
  external env: [string,string];
  rel eval: [term,string];
      beval: [term,string];
  prompt eval: ['< ',1,' env> ->',2];
  key eval,beval:[1];
  language imp;
begin

--Arithmetic

   match(%afactor,.x%) | eq(lexval(.x),int)-> eval(.x,.x);
   match(%afactor,.x%) | eq(lexval(.x),id) and env(.x,.y) -> eval(.x,.y);
   match(%afactor,( .x )%) | eval(.x,.y) -> eval(loc(),.y);
   match(%aterm,.x * .y%) | eval(.x,.a) and eval(.y,.b) -> 
     eval(loc(),mult(.a,.b));
   match(%aterm,.x%) | neq(syntyp(rchild(.x)),aterm) and eval(rchild(.x),.y) ->
     eval(loc(),.y);
   match(%aexp,.x + .y%) | eval(.x,.a) and eval(.y,.b) ->
     eval(loc(),add(.a,.b));
   match(%aexp,.x - .y%) | eval(.x,.a) and eval(.y,.b) ->
     eval(loc(),sub(.a,.b));   
   match(%aexp, .x%) | neq(syntyp(rchild(.x)),aexp) and eval(rchild(.x),.y) ->
     eval(loc(),.y);

--Booleans

   match(%bfactor,true%) |  -> beval(loc(),true);
   match(%bfactor,false%) |  -> beval(loc(),false);
   match(%bfactor,(.x)%) | beval(.x,.y) -> beval(loc(),.y);
   match(%bfactor,not .x%) | beval(.x,.y) and neg(.x,.w) -> beval(loc(),.w);
   match(%bfactor,.x = .y%) | eval(.x,.a) and eval(.y,.b) -> 
     eval(loc(),eq(.a,.b));
   match(%bfactor,.x <= .y%) | eval(.x,.a) and eval(.y,.b) ->
     eval(loc(),or(eq(.a,.b),gt(.b,.a));
   match(%bexp,.x or .y%) | beval(.x,.a) and beval(.y,.b) ->
     beval(loc(),or(.a,.b));
   match(%bexp,.x%) | neq(syntyp(rchild(.x)),bexp) and beval(.x,.y) ->
     beval(loc(),.y);
   match(%bterm,.x and .y%) | beval(.x,.a) and beval(.y,.b) ->
     beval(loc(),and(.a,.b));
   match(%bterm,.x%) | neq(syntyp(rchild(.x)),bterm) and beval(.x,.y) ->
     beval(loc(),.y);

--Commands
 
   match(%while .b do
   
end;

transcript bool();
  comment 'Boolean package';
  rel not:[string];
      and,or: [string,string];
  prompt not: ['not ',1,' = ',2];
	 and: [1,' and ',2,' = ',3];
         or:  [1,' or ',2,' = ',3];
  key not:[1];
      and,or:[1,2];
begin
  true -> not(true,false);
  true -> not(false,true);
  
  true -> and(false,false,false);
  true -> and(false,true,false);
  true -> and(true,false,false);
  true -> and(true,true,true);

  true -> or(false,false,false);
  true -> or(true,false,true);
  true -> or(false,true,true);
  true -> or(true,true,true);
end;

end semantics;

