semantics srstlc;
transcript SETL_to_C();
   comment 'Low-level SETL to C translation (Nov 14)';

   rel Expr  : [ node, c ];  -- translation from SETL to C expressions  
       Stmt  : [ node, c ];  -- translation from SETL to C statements

   prompt Expr     : [ 'SETL expression = ', 1, 'C expression = ', 2 ]; 
          Stmt     : [ 'SETL statement = ', 1, 'C statement = ', 2 ]; 

   language setl; 

   key Expr, Stmt : [1];   

begin

-- 
--  Translate variables and constants
--

      match (%lexpr, .x %)
  ->  Expr  (loc(), %expr, .x%);

      match (%expr, .var_or_constant %) 
  |   isleaf(.var_or_constant)
  ->  Expr  (loc(), %expr, .var_or_constant %);

      match (%statement, emptys(.set, .base); %)
  |   Expr  (.set,  .c_set)
  and Expr  (.base, .c_base)
  ->  Stmt  (loc(), %statement, .c_base . firsts . .c_set = 0; %);

#include srtest1.spc

end;
end semantics;
