  --
  --  Translate equality tests into C
  --  
      match (%expr, .x = .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a == .b %);

  --
  --  Translate inequality tests into C
  --
      match (%expr, .x /= .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a != .b %);

  --
  --  Translate comparisons
  --
      match (%expr, .x > .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a > .b %);
  
      match (%expr, .x < .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a < .b %);
  
      match (%expr, .x >= .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a >= .b %);
  
      match (%expr, .x <= .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a <= .b %);
  

  --
  --  Translate conjunctive tests into C
  --
      match (%expr, .x and .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a && .b %);

  --
  --  Translate disjunctive tests into C
  --
      match (%expr, .x or .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a || .b %);

  --
  --  Translate negations into C
  --
      match (%expr, not .x %)
  |   Expr  (.x, .a)
  ->  Expr  (loc(), %expr, ! .a %);

  --
  --  Translate addition into C
  --
      match (%expr, .x + .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a + .b %);

  --
  --  Translate subtraction into C
  --
      match (%expr, .x - .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a - .b %);

  --
  --  Translate multiplication into C
  --
      match (%expr, .x * .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a * .b %);

  --
  --  Translate division into C
  --
      match (%expr, .x / .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a / .b %);

  --
  --  Translate negation into C
  --
      match (%expr, - .x %)
  |   Expr  (.x, .a)
  ->  Expr  (loc(), %expr, - .a %);


  --
  --  Translate `ismem', which tests whether an element(i.e. member) is
  --  in a based set.
  --
      match (%expr, ismem( .element, .set, .base ) %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  and Expr  (.base,    .c_base)
  ->  Expr  (loc(), %expr, .c_base . recs[ .c_element ] . .c_set . mem %);
   
  --
  --  Translate `getfirst', which locates the first element
  --  of a base set.
  --
      match (%expr, getfirst( .set, .base ) %)
  |   Expr  (.set,  .c_set)
  and Expr  (.base, .c_base) 
  ->  Expr  (loc(), %expr, .c_base . firsts . .c_set %);

  --
  --  Translate `getnext'
  --
      match (%expr, getnext( .set, .base, .element ) %)
  |   Expr  (.set,     .c_set)
  and Expr  (.base,    .c_base)
  and Expr  (.element, .c_element)
  ->  Expr  (loc(), %expr, .c_base . recs [ .c_element ] . .c_set . next %);

  --
  --  Translate `getimage'
  --
      match (%expr, getimage (.element, .set, .base) %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  and Expr  (.base,    .c_base)
  ->  Expr  (loc(), %expr, .c_base . recs [ .c_element ] . .c_set . image %);

  --
  --  Translate `getkeyimage'
  --
      match (%expr, getkeyimage (.element, .base) %)
  |   Expr  (.element, .c_element)
  and Expr  (.base,    .c_base)
  ->  Expr  (loc(), %expr, .c_base . recs [ .c_element ] . key %);

  --
  --  Translate `is_emptys', which tests whether a base set is
  --  empty.
  --
      match (%expr, is_emptys( .base, .set ) %)
  |   Expr  (.base, .c_base)
  and Expr  (.set,  .c_set)
  ->  Expr  (loc(), %expr, .c_base . firsts . .c_set == 0 %);

  --
  --  Translate `is_emptyw'
  --
      match (%expr, is_emptyw( .set ) %)
  |   Expr  (.set,  .c_set)
  ->  Expr  (loc(), %expr, .c_set -> next == NULL %);

  --
  --  Translate `exists element in set'
  -- 
      match (%expr, exists .element in .set %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  ->  Expr  (loc(), %expr, exists (& .c_element, .c_set) != NULL %);
