   transcript stl_subtype () ; 
      comment 'translating tlisp types to SETL types' ; 
--stl_keytype(b,t) if b is base, b < t, and t is a type variable
--new_atom(t) if t is a generated type variable
      rel stl_keytype: [string, typexpr];
          new_atom, donekey: [string];
      language setl ;
      external sub_type: [typexpr, typexpr];
               range_link, base_link: [tree, typexpr];
               based, fbase: [typexpr];
      incremental stl_keytype: unify;
      key      stl_keytype, new_atom: [1];
      begin 
-- base element can be coerced into set(.s) by pointer dereferencing
       based(.b) and sub_type(.b, [set, .s])
       -> stl_keytype(.b, cellp);
-- base element stores the value
       based(.b) and sub_type(.b, .t) and isavar(.t)
       -> stl_keytype(.b, .t);
-- if a base variable b is not on the left of a subtype constraint, then
--  create a new type variable t, and make b < t
       based(.b) and null(z, sub_type(.b, z))
       -> bind(.t, newatom(t)) and
          new_atom(.t) and
          stl_keytype(.b, .t);

       stl_keytype(.b, .t) and isavar(.t) and new_atom(.t) and
       not donekey(.b)
       -> print('supply type for ') and 
          print(str(.b)) and 
          readstr( .x ) and
          donekey(.b) and
          stl_keytype(.b,  .x);

      end;

