transcript type();
  comment     'type analysis';
--type(e,type of e)
--type3(f,set(type of domain f element))
--type4(f,set(type of range f element))
--ismap(f) if f is a map
--new_atom0(t) if t is a generated type variable
--ref_count is not defined anywhere
  rel type, type3, type4: [tree, typexpr]; 
      ref_count: [tree, tree];
      ismap: [tree];
      new_atom0: [string];
  prompt  type:  [1,' : ', 2];
          type3: [' domain ', 1, ' : ', 2];
          type4: [' range ', 1,' : ', 2];
  incremental type, type3, type4: unify;
  language setl;
  external onemany, manyone: [tree];
           disjoint: [tree, tree];
  key type,type3,type4, ismap, 
	ref_count: [1];
begin
   onemany(.x) and  null(z, type (.x, [set,  z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type(.x, [set, .t]);
   manyone(.x) and null(z, type (.x, [set,  z]))
   -> bind(.t, newatom(t)) and new_atom0(.t) and type(.x, [set, .t]);
   disjoint(.x, .y) and null(z, type (.x, [set,  z]))
   -> bind(.t, newatom(t)) and new_atom0(.t) and type(.x, [set, .t]);
   disjoint(.x, .y) and null(z, type (.y, [set,  z]))
   -> bind(.t, newatom(t)) and new_atom0(.t) and type(.y, [set, .t]);

--initial typing
   match(%expr, .x%) 
   |   null(z, type(%expr, .x%, z))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type(%expr, .x%, .t);
   match(%bexpr, .x%) 
   |   null(z, type(%bexpr, .x%, z))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type(%bexpr, .x%, .t);

--constants
   match(%expr, .x%) 
   |   eq(lextyp(.x), int)
   ->   type(.x, int);
   match(%expr, {}%) 
   |   null(z, type (%expr, {}%, [set,  z]))
   -> bind(.t, newatom(t)) and new_atom0(.t) and
      type(%expr, {}%, [set, .t]);
--universal operations
   match(%expr, (.x)%) 
   |   type(%expr, (.x)%, .t)
   ->   type(%expr, .x%, .t);
   match(%expr, (.x)%) 
   |   type(%expr, .x%, .t)
   ->   type(%expr, (.x)%, .t);
   match(%statement, .x := .y;%)  --added Apr. 7
   |   type(.y,.t)
   ->   type(.x,.t);
--boolean valued set operations
   match(%expr, .x in .y %) 
   |   type(%expr, .x%, .t)
   ->   type(%expr, .y%, [set, .t]);
   match(%expr, .x in .y %) 
   |   type(%expr, .y%, [set, .t])
   ->   type(%expr, .x%, .t);
   match(%expr, .x in .y %) 
   ->   type(%expr, .x in .y%, bool);
   match(%expr, .x notin .y %) 
   |   type(%expr, .x%, .t)
   ->  type(%expr, .y%, [set, .t]);
   match(%expr, .x notin .y %) 
   ->   type(%expr, .x notin .y%, bool);
   match(%iter, .x in .y %) 
   |   type(%bexpr, .x%, .t)
   ->  type(%expr, .y%, [set, .t]);
   match(%expr, .x subset .y%) 
   |   type(%expr, .y%, [set, .t])
   ->  type(%expr, .x%, [set,.t]) and
       type(%expr, .x subset .y%, bool);
   match(%expr, .x subset .y%) 
   |   null(z, type(%expr, .x%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type(%expr, .x%, [set, .t]);
--overloaded comparison
   match(%expr, .x /= .y%) 
   |   type(%expr, .x%, .t)
   ->  type (%expr, .y%, .t) and
       type(%expr, .x /= .y%, bool);
   match(%expr, .x > .y%) 
   |   type(%expr, .x%, .t)
   ->  type (%expr, .y%, .t) and
       type(%expr, .x > .y%, bool);
   match(%expr, .x = .y%) 
   |   type(%expr, .x%, .t)
   ->  type (%expr, .y%, .t) and
       type(%expr, .x = .y%, bool);
   match(%expr, [.x, .y]%) 
   |   type(%expr, .x%, .t1) and type (%expr, .y%, .t2)
   ->   type(%expr, [.x, .y]%, [tuple, [.t1, .t2]]);
--logical operations
   match(%expr, .x or .y%) 
   ->   type(%expr, .x or .y%, bool) and
        type(%expr, .x%, bool) and
        type(%expr, .y%, bool);
   match(%expr, .x & .y%) 
   ->   type(%expr, .x & .y%, bool) and
        type(%expr, .x%, bool) and
        type(%expr, .y%, bool);
   match(%expr, not .x%)              -- added apr. 7
   ->   type(%expr, .x%, bool) and
        type(%expr, not .x%, bool);
--map operations
   match(%expr, .m(.x)%) 
   |   type(%expr, .x%, .t)
   ->   type3(%expr, .m%, [set,.t]);
   match(%expr, .m(.x)%) 
   |   type(%expr, .m(.x)%, .t)
   ->  type4(%expr, .m%, [set, .t]);
   match(%expr, .m{.x}%) 
   |   type(%expr, .x%, .t)
   ->   type3(%expr, .m%, [set,.t]);
   match(%expr, .m{.x}%) 
   |   type(%expr, .m{.x}%, [set, .t])
   ->  type4(%expr, .m%, [set, .t]);
   match(%expr, .m{.x}%) 
   ->  ismap(.m);
   match(%expr, .m[.x]%) 
   ->  ismap(.m);
   match(%expr, .m[.x]%) 
   |   type(%expr, .x%, [set,.t])
   ->  type3(%expr, .m%, [set,.t]);
   match(%expr, .m[.x]%) 
   |   type(%expr, .m[.x]%, [set,.t])
   ->  type4(%expr, .m%, [set,.t]);
   type3(.m, [set,.t1]) and type4(.m, [set,.t2])
   ->  type(.m, [set, [tuple, [.t1, .t2]]]);
   match(%expr, .f~%) 
   |   null(z, type(%expr, .f%, [set, [tuple, [z, z]]]))
   -> bind(.t1, newatom(t)) and new_atom0(.t1) and
      bind(.t2, newatom(t)) and new_atom0(.t2) and
      type(%expr, .f%, [set,  [tuple, [.t1, .t2]]]);
   match(%expr, .f~%) 
   |   type(%expr, .f%, [set, [tuple, [.t1, .t2]]])
   ->  type(%expr, .f~%, [set, [tuple, [.t2, .t1]]]);
   match(%expr, .m[.x]%) 
   |   null(z, type(%expr, .m[.x]%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type(%expr, .m[.x]%, [set, .t]);
   match(%expr, .m[.x]%) 
   |   null(z, type(%expr, .x%, [set,z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type(%expr, .x%, [set, .t]);
   match(%expr, .m{.x}%) 
   |   null(z,type3(%expr, .m%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type3(%expr, .m%, [set, .t]);
   match(%expr, .m{.x}%) 
   |   null(z, type4(%expr, .m%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type4(%expr, .m%, [set, .t]);
   match(%expr, .m(.x)%) 
   |   null(z, type3(%expr, .m%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type3(%expr, .m%, [set,.t]);
   match(%expr, .m(.x)%) 
   |   null(z, type4(%expr, .m%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type4(%expr, .m%, [set, .t]);
   match(%expr, domain .m%) 
   |   null(z, type4(%expr, .m%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type4(%expr, .m%, [set, .t]);
   match(%expr, domain .m%) 
   |   null(z, type3(%expr, .m%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type3(%expr, .m%, [set, .t]);
   match(%expr, range .m%) 
   |   null(z, type4(%expr, .m%, [set, z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type4(%expr, .m%, [set, .t]);
   match(%expr, range .m%) 
   |   null(z, type3(%expr, .m%, [set,z]))
   ->  bind(.t, newatom(t)) and new_atom0(.t) and
       type3(%expr, .m%, [set, .t]);
   match(%expr, domain .m%) 
   |   type(%expr, domain .m%, [set,.t])
   ->  type3(%expr, .m%, [set, .t]);
   match(%expr, range .m%) 
   |   type(%expr, range .m%, [set, .t])
   ->  type4(%expr, .m%, [set, .t]);
-- set operations
   match(%expr, arb(.x)%) 
   |   type(%expr, arb(.x)%, .t)
   ->   type(%expr, .x%, [set, .t]);
   match(%expr, {.e1: .x in .e2  | .e3}%) 
   |   type(%expr, .e1%, .j1)
   ->  type(%expr, {.e1: .x in .e2 | .e3}%, [set, .j1]) and
       type(.e3, bool);
--overloaded integer valued set, tuple, string operations
   match(%expr, #.x%) 
   ->   type(%expr, #.x%, int);
   match(%expr, min/.x%)
   -> type(%expr,min/.x%,int) and
       type(%expr,.x%,[set,int]);
--overloaded operations (set,tuple, arithmetic)
   match(%expr, .x + .y%) 
   |   type(%expr, .x%, .t)
   ->  type(%expr, .x + .y%, .t) and
       type(%expr, .y%, .t);
   match(%expr, .x - .y%) 
   |   type(%expr, .x%, .t)
   ->  type(%expr, .x - .y%, .t) and
       type(%expr, .y%, .t);
   match(%expr, .x * .y%) 
   |   type(%expr, .x%, .t)
   ->   type(%expr, .x * .y%, .t) and
        type(%expr, .y%, .t);
--fixed point operations
   match(%expr, clfp(.x, .y, .z)%) 
   |   type(%expr, .x%, .t)
   ->  type(%expr, .y%, .t) and 
       type(%expr, .z%, .t) and 
       type(%expr, clfp(.x, .y, .z)%, .t);
   match(%expr, lfp(.x, .y)%) 
   |   type(%expr, .x%, .t)
   ->  type(%expr, .y%, .t) and 
       type(%expr, lfp(.x, .y)%, .t);
   match(%expr, cgfp(.x, .y, .z)%) 
   |   type(%expr, .x%, .t)
   ->  type(%expr, .y%, .t) and 
       type(%expr, .z%, .t) and 
       type(%expr, cgfp(.x, .y, .z)%, .t);
   match(%expr, gfp(.x, .y)%) 
   |   type(%expr, .x%, .t)
   ->  type(%expr, .y%, .t) and 
       type(%expr, gfp(.x, .y)%, .t);
--quantifiers
   match(%expr, exists .x | .y%)
   ->   type(%expr, exists .x | .y%, bool) and
        type(%expr, .y%, bool);
   match(%expr, forall .x | .y%)
   ->   type(%expr, forall .x | .y%, bool) and
        type(%expr, .y%, bool);
--arithmetic comparison
   match(%expr, .x < .y%) 
   ->    type(%expr, .x%, int) and
         type(%expr, .y%, int) and
         type(%expr, .x < .y%, bool);
   match(%expr, .x > .y%) 
   ->    type(%expr, .x%, int) and
         type(%expr, .y%, int) and
         type(%expr, .x > .y%, bool);
   match(%expr, .x <= .y%) 
   ->    type(%expr, .x%, int) and
         type(%expr, .y%, int) and
         type(%expr, .x <= .y%, bool);
   match(%expr, .x >= .y%) 
   ->    type(%expr, .x%, int) and
         type(%expr, .y%, int) and
         type(%expr, .x >= .y%, bool);
end;




