#include "jerq.h"

#define	UP	0
#define	DOWN	1

#ifdef JERQ

static short boxcurs_bits[] = {
	0x43FF, 0xE001, 0x7001, 0x3801, 0x1D01, 0x0F01, 0x8701, 0x8F01,
	0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0xFFFF,
};

#else

#define boxcurs_width 16
#define boxcurs_height 16
#define boxcurs_x_hot 7
#define boxcurs_y_hot 7
#if SVR4
static unsigned char boxcurs_bits[] = {
#else
static char boxcurs_bits[] = {
#endif
   0xff, 0x43, 0x01, 0xe0, 0x01, 0x70, 0x01, 0x38, 0x01, 0x1d, 0x01, 0x0f,
   0x01, 0x87, 0x01, 0x8f, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80,
   0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0xff, 0xff};

#define boxcurs_f_width 18
#define boxcurs_f_height 18
#define boxcurs_f_x_hot 8
#define boxcurs_f_y_hot 9
#if SVR4
static unsigned char boxcurs_f_bits[] = {
#else
static char boxcurs_f_bits[] = {
#endif
   0x00, 0x00, 0x00, 0xfe, 0x87, 0x00, 0x02, 0xc0, 0x01, 0x02, 0xe0, 0x00,
   0x02, 0x70, 0x00, 0x02, 0x38, 0x00, 0x02, 0x1d, 0x01, 0x02, 0x0f, 0x01,
   0x02, 0x07, 0x01, 0x02, 0x0f, 0x01, 0x02, 0x00, 0x01, 0x02, 0x00, 0x01,
   0x02, 0x00, 0x01, 0x02, 0x00, 0x01, 0x02, 0x00, 0x01, 0x02, 0x00, 0x01,
   0xfe, 0xff, 0x01, 0x00, 0x00, 0x00};

#define boxcurs_m_width 18
#define boxcurs_m_height 18
#define boxcurs_m_x_hot 8
#define boxcurs_m_y_hot 9
#if SVR4
static unsigned char boxcurs_m_bits[] = {
#else
static char boxcurs_m_bits[] = {
#endif
   0xff, 0x87, 0x00, 0xff, 0xc7, 0x01, 0x03, 0xe0, 0x03, 0x03, 0xf0, 0x01,
   0x03, 0xf8, 0x00, 0x83, 0x7d, 0x00, 0x83, 0x3f, 0x03, 0x83, 0x1f, 0x03,
   0x83, 0x0f, 0x03, 0x83, 0x1f, 0x03, 0x83, 0x1f, 0x03, 0x03, 0x00, 0x03,
   0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03,
   0xff, 0xff, 0x03, 0xff, 0xff, 0x03};

#endif

static Cursor boxcurs;
static int firstime = 1;
#ifdef SVR4
static void outline(Rectangle);
#else
static void outline();
#endif

Rectangle
getrect (n)
int n;
{
	return getrectb(8>>n, 1);
}

/*
	ngetrect:	ultimate getrect routine
			optional clipping rectangle
			optional blocking for mouse routines
			optional minimum width and height
			returns 1 if minimum rectangle is swept
*/
int
ngetrect (r, clip, but, block, minw, minh)
register Rectangle *r;		/* rectangle				*/
register Rectangle *clip;	/* clipping rectangle, can be 0		*/
register int but;		/* button 1, 2, or 3, defaults to 1	*/
register int block;		/* blocking flag 0 or 1			*/
register int minw;		/* minimum width, can be 0		*/
register int minh;		/* minimum height, can be 0		*/
{
	if(but == 0)
		but = 1;
	*r = getrectb(8>>but, block);
	if(r->origin.x == 0 &&
	   r->origin.y == 0 &&
	   r->corner.x == 0 &&
	   r->corner.y == 0)
		return 0;
	if(r->corner.x - r->origin.x < minw ||
	   r->corner.y - r->origin.y < minh)
		return 0;
	if(clip && !rectclip(r, *clip))
		return 0;
	return 1;
}

Rectangle
getrectb (n, block)
int n, block;
{
	Rectangle r, canon();
	Point p1, p2;
	Cursor *prev;

	if (firstime) {
#ifdef JERQ
		boxcurs = ToCursor(boxcurs_bits, boxcurs_bits, 8, 8);
#else
		/* punt */
		boxcurs = _ToCursor(boxcurs_f_bits, boxcurs_m_bits,
				boxcurs_f_width, boxcurs_f_height,
				boxcurs_f_x_hot, boxcurs_f_y_hot);
#endif
		firstime = 0;
	}
	prev = cursswitch(&boxcurs);
	Jscreengrab();
	if(block){
		buttons(UP);
		buttons(DOWN);
	}
	if(!(mouse.buttons&n)){
		r.origin.x=r.origin.y=r.corner.x=r.corner.y=0;
		buttons(UP);
		goto Return;
	}
	p1 = add(mouse.xy, Joffset);
	p2 = p1;
	r = canon(p1, p2);
	outline(r);
	for(; mouse.buttons&n; nap(2)){
		outline(r);
		p2 = add(mouse.xy, Joffset);
		r = canon(p1, p2);
		outline(r);
	}
	outline(r);	/* undraw for the last time */
    Return:
	Jscreenrelease();
	cursswitch(prev);
	r = rsubp(r, Joffset);
	if(!rectclip(&r, Rpt(Drect.org,Drect.cor)))
		r.origin.x = r.origin.y = r.corner.x = r.corner.y = 0;
	return r;
}

buttons (updown)
{
	while((button123()!=0) != updown)
		nap(2);
}

Rectangle
canon (p1, p2)
Point p1, p2;
{
	Rectangle r;
	r.origin.x = min(p1.x, p2.x);
	r.origin.y = min(p1.y, p2.y);
	r.corner.x = max(p1.x, p2.x);
	r.corner.y = max(p1.y, p2.y);
	return(r);
}

static void
outline(r)
Rectangle  r;
{
	segment(&Jfscreen, r.org, Pt(r.cor.x, r.org.y), F_XOR);
	segment(&Jfscreen, Pt(r.cor.x, r.org.y), r.cor, F_XOR);
	segment(&Jfscreen, r.cor, Pt(r.org.x, r.cor.y), F_XOR);
	segment(&Jfscreen, Pt(r.org.x, r.cor.y), r.org, F_XOR);
}

Cursor *
cursswitch (cp)
Cursor *cp;
{
	Cursor *rc;

	if (cp == (Cursor *)0)
		cp = &normalcursor;
	XDefineCursor(dpy, display.dr, *cp);
	rc = P->cursor;
	P->cursor = cp;
	return rc;
}

cursset (p)
Point p;
{
	XWarpPointer(dpy, display.dr, display.dr, mouse.xy.x, mouse.xy.y,
		display.rect.corner.x, display.rect.corner.y, p.x, p.y);
	mouse.xy.x = p.x;
	mouse.xy.y = p.y;
}
