#include "jerq.h"
#include "rcv.h"

#if defined(BSD) || defined(SVR4)
#include <sys/time.h>
#endif

static unsigned alarmtime, alarmstart;

wait (resource)
{
	int maxfd, ret;
#ifdef SVR4
	fd_set smask, emask;
#else
	int smask, emask;
#endif
	unsigned diff;
#if defined(BSD) || defined(SVR4)
	struct timeval tv;
#endif

	maxfd = displayfd + 1;
	for(;;){
		if (alarmtime) {
			diff = realtime() - alarmstart;
			if (diff >= alarmtime) {
				alarmtime = 0;
				P->state |= ALARM;
			} else {
				alarmstart += diff;
				alarmtime -= diff;
			}
		}
		if(P->state & resource)
			break;
		if(XPending(dpy))
			goto xin;
#ifdef SVR4
		FD_ZERO(&smask);
		FD_SET(displayfd, &smask);
		FD_ZERO(&emask);
		if (!Jrcvbuf.blocked && jerqrcvmask) {
			FD_SET(0, &smask);
			FD_SET(0, &emask);
		}
#else
		smask = (1 << displayfd);
		emask = 0;
		if (!Jrcvbuf.blocked) {
			smask |= jerqrcvmask;
			emask |= jerqrcvmask;
		}
#endif
		if (resource & CPU) {
#if defined(BSD) || defined(SVR4)
			tv.tv_sec = 0;
			tv.tv_usec = 0;
			ret = select(maxfd, &smask, 0, &emask, &tv);
#else	/* V9 */
			ret = select(maxfd, &smask, 0, 0);
#endif
			if (ret == 0)
				break;
		} else if (alarmtime) {
#if defined(BSD) || defined(SVR4)
			tv.tv_sec = alarmtime/60;
			tv.tv_usec = (alarmtime%60) * 16666;
			ret = select(maxfd, &smask, 0, &emask, &tv);
#else	/* V9 */
			ret = select(maxfd, &smask, 0, alarmtime*17);
#endif
			if (ret == 0) {
				alarmtime = 0;
				P->state |= ALARM;
				continue;
			}
		} else {
#if defined(BSD) || defined(SVR4)
			ret = select(maxfd, &smask, 0, &emask, 0);
#else	/* V9 */
			ret = select(maxfd, &smask, 0, 0x6fffffff);
#endif
		}
		if (ret == -1)
			continue;
#ifdef SVR4
		if(jerqrcvmask)
			if (FD_ISSET(0, &smask) || FD_ISSET(0, &emask))
				rcvfill();
		if(FD_ISSET(displayfd, &smask)){
#else
		if(smask & jerqrcvmask || emask & jerqrcvmask)
			rcvfill();
		if(smask & (1 << displayfd)){
#endif
xin:
			handleinput();
			if(resource & MOUSE) /* We always have the mouse */
				break;
		}
	}
	return resource & (P->state|MOUSE);
}

nap (n)
int n;
{
	wait(MOUSE);
}

alarm(ticks)
{
	alarmtime = ticks;
	alarmstart = realtime();
	P->state &= ~ALARM;
}

sleep(ticks)
{
#if defined(BSD) || defined(SVR4)
#ifdef SVR4
	fd_set smask;
#else
	int smask;
#endif
	int maxfd, ret;
	unsigned diff = 0, tleft;
	struct timeval tv;
	unsigned start = realtime();

	maxfd = displayfd + 1;
	for(tleft = ticks; diff < tleft; ) {
		tleft -= diff;
		if(XPending(dpy))
			goto xin;
damage:
#ifdef SVR4
		FD_ZERO(&smask);
		FD_SET(displayfd, &smask);
		if (!Jrcvbuf.blocked && jerqrcvmask)
			FD_SET(0, &smask);
#else
		smask = (1 << displayfd);
		if (!Jrcvbuf.blocked)
			smask |= jerqrcvmask;
#endif
		tv.tv_sec = tleft / 60;
		tv.tv_usec = (tleft % 60) * 16666;
		ret = select(maxfd, &smask, 0, 0, &tv);
		if (ret == 0)
			break;
		if (ret == -1)
			goto damage;
#ifdef SVR4
		if(jerqrcvmask && FD_ISSET(0, &smask))
			rcvfill();
		if(FD_ISSET(displayfd, &smask)){
#else
		if(smask & jerqrcvmask)
			rcvfill();
		if(smask & (1 << displayfd)){
#endif
xin:
			handleinput();
		}
		diff = realtime() - start;
		start += diff;
	}
	if (alarmtime) {
		if (ticks >= alarmtime) {
			alarmtime = 0;
			P->state |= ALARM;
		} else {
			alarmstart += ticks;
			alarmtime -= ticks;
		}
	}
#else
	wait(CPU);
#undef nap
	nap(ticks);
	wait(CPU);
	if (alarmtime) {
		int diff = realtime() - alarmstart;
		if (diff >= alarmtime) {
				alarmtime = 0;
				P->state |= ALARM;
		}
		alarmstart += diff;
		alarmtime -= diff;
	}
#endif /* BSD */
}

#if !defined(BSD) || !defined(SVR4)
#include <sys/timeb.h>
#endif
realtime()
{
#if defined(BSD) || defined(mips) || defined(SVR4)
	struct timeval tv;
	gettimeofday(&tv, 0);
	return tv.tv_sec * 60 + (tv.tv_usec * 60 / 1000000);
#else
	struct timeb tb;
	ftime(&tb);
	return tb.time * 60 + (tb.millitm * 60 / 1000);
#endif
}
