#include <pads.pri>
#ifdef __cplusplus
#include <signal.h>
#include <sys/wait.h>
#else
#include <CC/signal.h>
#endif
SRCFILE("popen.c")
static int popen_pid[_NFILE];

#define SIG_ARG_TYP	SIG_TYP

#ifdef DIST
int pipe(int[2]), wait(int*), vfork(), _exit(int);
#endif

FILE *Popen(char *cmd, char *mode)
{
	int parent = (*mode == 'r') ? 0 : 1;
	int child  = (*mode == 'r') ? 1 : 0;
	int p[2];

	if( pipe(p) < 0 ) return NULL;
	pid_t pid = vfork();
	if( pid == 0) {
		dup2(p[child], child);
		setuid(getuid());
		setgid(getgid());
		for( int i = 0; i < _NFILE; ++i )
			if( i != child ) close(i);
		execl("/bin/sh", "sh", "-c", cmd, 0);
		perror("/bin/sh");
		_exit(1);
	}
	if(pid == -1)
		return NULL;
	close(p[child]);
	popen_pid[p[parent]] = (int)pid;
	return(fdopen(p[parent], mode));
}

int Pclose(FILE *ptr)
{
	static SIG_TYP Stat[4];
	static int sig[4] = { SIGINT, SIGQUIT, SIGHUP, SIGPIPE };
	int f, r, status, i;

	f = fileno(ptr);
	fclose(ptr);
	for( i = 0; i < 4; ++i )
		Stat[i] = signal(sig[i], (SIG_ARG_TYP)SIG_IGN);
	while((r = (int)wait(&status)) != popen_pid[f] && r != -1) {}
	if(r == -1)
		status = -1;
	for( i = 0; i < 4; ++i )
		signal(sig[i], (SIG_ARG_TYP)Stat[i]);
	return(status);
}
