#include "univ.h"

#ifdef JERQ

static unsigned short Danger_bits[] = {
	0x0180, 0x0240, 0x0420, 0x0990, 0x1188, 0x2184, 0x4182, 0x8181,
	0x8181, 0x4182, 0x2004, 0x1188, 0x0990, 0x0420, 0x0240, 0x0180 };

static unsigned short Bullseye_bits[] = {
	0x07E0, 0x1FF8, 0x399C, 0x63C6, 0x6FF6, 0xCDB3, 0xD99B, 0xFFFF,
	0xFFFF, 0xD99B, 0xCDB3, 0x6FF6, 0x63C6, 0x399C, 0x1FF8, 0x07E0 };

static unsigned short NoMemory_bits[] = {
	0x2238, 0x2244, 0x3244, 0x2A44, 0x2644, 0x2244, 0x2238, 0x0000,
	0x8BD1, 0xDA1B, 0xAA15, 0xAB95, 0x8A11, 0x8A11, 0x8BD1, 0x0000 };

static unsigned short Coffee_bits[] = {
	0x0000, 0x0380, 0x0400, 0x03E0, 0x0010, 0x07E0, 0x1FFC, 0x1002,
	0x101A, 0x101A, 0x1002, 0x103C, 0x1810, 0x0FE0, 0x0000, 0x3FFC };

static unsigned short HostBusy_bits[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FC0, 0x0FC0,
	0x03C0, 0x07C0, 0x0EC0, 0x1CC0, 0x3800, 0x7000, 0xE0DB, 0xC0DB };

static unsigned short NoGCMemory_bits[] = {
	0x1C38, 0x2244, 0x2040, 0x2E40, 0x2240, 0x2244, 0x1C38, 0x0000,
	0x8BD1, 0xDA1B, 0xAA15, 0x8B91, 0x8A11, 0x8A11, 0x8BD1, 0x0000	};

static unsigned short Grey_bits[]={
	0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA,
	0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA,
};

static unsigned char DarkGrey_bits[] = {
   0x22, 0x22, 0x88, 0x88, 0x22, 0x22, 0x88, 0x88, 0x22, 0x22, 0x88, 0x88,
   0x22, 0x22, 0x88, 0x88, 0x22, 0x22, 0x88, 0x88, 0x22, 0x22, 0x88, 0x88,
   0x22, 0x22, 0x88, 0x88, 0x22, 0x22, 0x88, 0x88};

#else

#include "cursor.h"

#endif

static unsigned short Arrow_bits[] = {
	 0x0040, 0x0060, 0xFFF0, 0xFFF8,
	 0xFFFC, 0xFFFC, 0xFFF8, 0xFFF0,
	 0x0060, 0x0040, 0x0000, 0x0000,
	 0x0000, 0x0000, 0x0000, 0x0000,
};

Cursor Danger, Bullseye, NoMemory, Coffee, HostBusy, NoGCMemory;
Cursor *Pcursor;
Texture Arrow;
Texture Grey;

initcursors()
{
#ifdef JERQ
	Bullseye = ToCursor(Bullseye_bits, Bullseye_bits, 16, 16, 7, 7);
	Danger = ToCursor(Danger_bits, Danger_bits, 16, 16, 7, 7);
	NoMemory = ToCursor(NoMemory_bits, NoMemory_bits, 16, 16, 7, 7);
	Coffee = ToCursor(Coffee_bits, Coffee_bits, 16, 16, 7, 7);
	NoGCMemory = ToCursor(NoGCMemory_bits, NoGCMemory_bits, 16, 16, 7, 7);
	HostBusy = ToCursor(HostBusy_bits, HostBusy_bits, 16, 16, 7, 7);
	Arrow = ToTexture(Arrow_bits);
	Grey = ToTexture(Grey_bits);
#else
	if (cursorSizeOKWithServer(_CURS_W, _CURS_H)) {
#ifdef ARROWCURSOR
		Arrow = _ToCursor(Arrow_f_bits, Arrow_m_bits,
				Arrow_f_width, Arrow_f_height,
				Arrow_f_x_hot, Arrow_f_y_hot);
#endif

		Bullseye = _ToCursor(Bullseye_f_bits, Bullseye_m_bits,
				Bullseye_f_width, Bullseye_f_height,
				Bullseye_f_x_hot, Bullseye_f_y_hot);

		Danger = _ToCursor(Danger_f_bits, Danger_m_bits,
				Danger_f_width, Danger_f_height,
				Danger_f_x_hot, Danger_f_y_hot);

		Coffee = _ToCursor(Coffee_f_bits, Coffee_m_bits,
				Coffee_f_width, Coffee_f_height,
				Coffee_f_x_hot, Coffee_f_y_hot);

		HostBusy = _ToCursor(HostBusy_f_bits, HostBusy_m_bits,
				HostBusy_f_width, HostBusy_f_height,
				HostBusy_f_x_hot, HostBusy_f_y_hot);
	 } else {
#ifdef ARROWCURSOR
		Arrow = _ToCursor(Arrow_bits, Arrow_bits,
				Arrow_width, Arrow_height,
				Arrow_x_hot, Arrow_y_hot);
#endif

		Bullseye = _ToCursor(Bullseye_bits, Bullseye_bits,
				Bullseye_width, Bullseye_height,
				Bullseye_x_hot, Bullseye_y_hot);

		Danger = _ToCursor(Danger_bits, Danger_bits,
				Danger_width, Danger_height,
				Danger_x_hot, Danger_y_hot);

		Coffee = _ToCursor(Coffee_bits, Coffee_bits,
				Coffee_width, Coffee_height,
				Coffee_x_hot, Coffee_y_hot);

		HostBusy = _ToCursor(HostBusy_bits, HostBusy_bits,
				HostBusy_width, HostBusy_height,
				HostBusy_x_hot, HostBusy_y_hot);
	}

	NoGCMemory = ToCursor(NoGCMemory_bits, NoGCMemory_bits,
			NoGCMemory_width, NoGCMemory_height);

	NoMemory = ToCursor(NoMemory_bits, NoMemory_bits,
			NoMemory_width, NoMemory_height);
#endif

	Arrow = ToTexture(Arrow_bits);
	Grey = ToTexture(DarkGrey_bits);
}

#ifdef NEED_CURSORSIZE
int
cursorSizeOKWithServer(wid, ht)
	unsigned int wid, ht;
{
	unsigned int rw, rh;

	if (XQueryBestCursor(dpy, display.dr, wid, ht, &rw, &rh) != (Status)1)
		return (False);

	return (rw >= wid && rh >= ht);
}
#endif
