#include "core.pri"
#include "m68kcore.h"
#include <sys/types.h>
#include <sys/reg.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/user.h>
#include <sys/core.h>
#include <sys/ptrace.h>
#include <sys/wait.h>

#ifdef NEED_BSDCORE

struct Bsdcore {
        int     c_magic;                /* Corefile magic number */
        int     c_len;                  /* Sizeof (struct core) */
        struct  regs c_regs;            /* General purpose registers */
        struct  exec c_aouthdr;         /* A.out header */
        int     c_signo;                /* Killing signal, if any */
        int     c_tsize;                /* Text size (bytes) */
        int     c_dsize;                /* Data size (bytes) */
        int     c_ssize;                /* Stack size (bytes) */
        char    c_cmdname[CORE_NAMELEN + 1]; /* Command name */
#ifdef FPU
        struct  fpu c_fpu;              /* external FPU state */
#endif
        int     c_ucode;                /* Exception no. from u_code */
};

typedef struct Bsdcore	Bsdcore;

#endif

int ptrace(int,int,...);

#define SYSADR		KERNELBASE	/* address of system seg. */
#define USRADR		UADDR		/* start of User page */

char *SignalName(int);
void Wait3();

class HostCore : public M68kCore {
	friend SigMask; friend KernCore;
	friend  HostProcess; friend HostContext;
	friend	WaitList;
	Bsdcore	bsdcore;
	int	pid;
	int 	cursig;
	int	sigmask;
	int	state;
	int	endtext;
	int	startdata;
	int	enddata;
	int	startstack;
	int	kmemfd;
	long	regaddr();
	int	fpvalid(long);
	long	scratchaddr();
	Behavs	behavetype();
	char	*ioctl(int);
	char	*signalmask(long);
	char	*exechang(long);
	char	*clrcurrsig();
	char	*sendsig(long);
	short	ppid()			{ return 0; }
	char	*pswT(long,int);
	char	*dostep(long,long,int);
	char	*waitstop(int);
	int	ptrace(int,int=0,int=0,int=0);
	char	*readwrite(long,char*,int,int);
	char	*regrw(long,char*,int,int);
virtual char	*seekto(int&,long&,int&);
virtual int	instack(long,long);
public:
		HostCore(Process *p, Master *m):(p, m) { kmemfd = -1; }
	Context	*newContext();
	Behavs	behavs();
	char	*eventname();
	char	*destroy();
	char	*laybpt(Trap*);
	char	*open();
	void	close();
	char	*problem();
	char	*readcontrol();
	char	*reopen(char*,char*);
	char	*run();
	char	*stop();
virtual	int	event();
};

class HostContext : public Context { friend HostCore;
	long	regs[18];
	HostCore *core;
	int	pending;
public:
		HostContext()		{}
	void	restore();
};

class KernCore : public HostCore {
	long	sbr;
	long	slr;
	long	intstack;
	pcb	pcb_copy;
	long	pcb_loc;
	char	*seekto(int&,long&,int&);
	int	instack(long,long);
public:
		KernCore(Process *p, Master *m):(p,m) {}
	long	cs_fp;
	long	regloc(int,int=0);
	long	pc();
	long	fp();
	char	*open();
	char	*readcontrol();
	Behavs	behavs();
	char	*eventname();
	int	event();
	char	*getpcb(long);
	char	*specialop(char*);
	char	*special(char*,long);
};

#ifdef SVR4
typedef int	*_wait;
#endif

class WaitMem {
	friend WaitList;
	HostCore	*core;
	WaitMem		*next;
	int		changed;
	_wait		status;
};

class WaitList {
	WaitMem		*head;
public:
	void		add(HostCore*);
	void		remove(HostCore*);
	int		wait(HostCore*, int);
			WaitList()		{ head = 0; }
};

#define WAIT_POLL	0x1
#define	WAIT_PCFIX	0x2
#define	WAIT_DISCARD	0x4

void WaitForExecHang(char*);
