#include "core.pri"
#include "m68kcore.h"

void rtinit(char*);
int rtread(int,char*,int);
int rtwrite(int,char*,int);
void rtwait();
void rtgo();
void rtabort();
void rtstop();
int rtstate();
int rtregaddr();
int rtload(char *);
int rtscratchaddr(int *);

/*
 * Process states
 */
#define	P_DEAD		0
#define	P_RUNNING	1
#define	P_TRACED	2
#define	P_BKPT		3
#define	P_BUSERR	4
#define	P_ADDRERR	5
#define	P_STOPPED	6

class RtCore : public M68kCore { friend  RtProcess; friend RtContext;
	int	state;
	char	*pswT();
	char	*dostep(long,long,int);
	char	*waitstop();
	char	*readwrite(long,char*,int,int);
	int	instack(long,long);
	int	fpvalid(long);
	long	regaddr();
	Behavs	behavetype();
	long	scratchaddr();
public:
		RtCore(Process *p, Master *m):(p, m) {}
	Behavs	behavs();
	char	*eventname();
	char	*destroy();
	char	*laybpt(Trap*);
	char	*open();
	char	*readcontrol();
	char	*reopen(char*,char*);
	char	*run();
	char	*stop();
	int	event();
};
