#include "rtcore.h"
#include "master.pri"
#include "process.pri"
#include <CC/stdio.h>
#include "symtab.pri"
SRCFILE("rtmaster.c")

Process	*RtMaster::domakeproc(char *proc, char *stab, char* comment)
{
	return (Process*) new RtProcess(child, proc, stab, comment);
}

RtMaster::RtMaster(char *board)
{
	Menu m;

	pad = new Pad( (PadRcv*) this );
	pad->options(TRUNCATE|SORTED);
	pad->name( "Rtpi" );
	pad->banner( "Rtpi:" );
	m.last("quit?", (Action)&::exit, 0);
	pad->menu(m);
	pad->makecurrent();
	::rtinit(board);
	refresh();
}

void RtMaster::refresh()
{
	Process *p;

	pad->clear();
	makeproc( "!", "a.out", 0);
	for( p = child; p; p = p->sibling )
		if( p->core || (p->stabpath && !strcmp(p->stabpath,"!")))
			insert(p);
}

char *RtMaster::kbd(char *s)
{
	while( *s == ' ' ) ++s;
	switch( *s ){
	case '!':
		for( ++s; *s==' '; ++s ) {}
		makeproc("!", s, 0);
		break;
	default:
		for(; *s==' '; ++s ) {}
		makeproc(s, s, 0);
		break;
	}
	return 0;
}

char *RtMaster::help()
{
	return "!<cmd> {load program} | cmd {attach to program}";
}
