#include "univ.h"
#include "process.pri"
#include "rtcore.h"
#include "expr.pub"
#include "master.pub"
#include "bpts.pri"
#include "frame.pri"
#include "memory.pub"
#include "symtab.pub"
#include "symbol.h"
#include "srcdir.h"
#include "asm.pub"
#include <CC/stdio.h>
SRCFILE("rtproc.c")

void RtProcess::takeover()
{
	if( pad ){
		open();
		insert(ERRORKEY, "take over: already open");
		return;
	}
	Pick( "take over", (Action)&RtProcess::substitute, (long) this );
}

void RtProcess::substitute(RtProcess *t)
{
	char *error, *oldprocpath, *oldstabpath, *oldcomment;

	insert(ERRORKEY, 0);
	if( !core ){
		insert(ERRORKEY, "that ought to work - but it doesn't");
		return;
	}
	_bpts->lift();
	if( error = core->reopen(0,t->stabpath) ){
		_bpts->lay();
		insert(ERRORKEY, error);
		return;
	}
	oldprocpath = procpath;
	oldstabpath = stabpath;
	oldcomment = comment;
	procpath = t->procpath;
	stabpath = t->stabpath;
	comment = t->comment;
	master->makeproc( oldprocpath, oldstabpath, oldcomment );
	master->insert(t);
	master->insert(this);
	banner();
	if( _asm ) _asm->banner();
	if( _bpts ) _bpts->banner();
	if( memory ) memory->banner();
	if( globals ) globals->banner();
	if( srcdir ) srcdir->banner();
	core->symtab()->banner();
	pad->clear();
	_bpts->lay();
	docycle();
}

void RtProcess::open()
{
	Menu m, s;
	char *error;

	Process::openpad();
	if( core ) return;
	insert(ERRORKEY, "Checking process and symbol table...");
	core = (Core*) new RtCore(this, master);
	if( error = core->open() ){
		delete core;
		core = 0;
		m.last( "open process", (Action)&RtProcess::open);
		pad->menu( m );
		insert(ERRORKEY, error);
		return;
	}
	insert(ERRORKEY, core->symtab()->warn());
	globals = new Globals(core);
	_asm = core->newAsm();
	m.last( "stop", (Action)&RtProcess::stop );
	m.last( "run",  (Action)&Process::go  );
	m.last( "src text",  (Action)&Process::srcfiles    );	/* should check */
	m.last( "Globals",   (Action)&Process::openglobals );
	m.last( "RawMemory", (Action)&Process::openmemory  );
	s.last( "Assembler", (Action)&Process::openasm     );
	s.last( "User Types",(Action)&Process::opentypes   );
	s.last("Journal", (Action)&Process::openjournal);
	s.last("Bpt List", (Action)&RtProcess::openbpts);
	_bpts = new Bpts(core);
	_bpts->lay();
	m.last("kill?",   (Action)&RtProcess::destroy     );
	m.last(s.index("more"));
	pad->menu(m);
	pad->makecurrent();
	docycle();
}

void RtProcess::destroy()
{
	insert(ERRORKEY, core->destroy());
	docycle();
}

Index RtProcess::carte()
{
	Menu m;
	if(!strcmp(procpath,"!") ){
		m.last( "hang & open proc", (Action)&RtProcess::hangopen );
		m.last( "hang & take over", (Action)&RtProcess::hangtakeover );
	} else {
		m.last( "open process",  (Action)&RtProcess::open );
		m.last( "take over",    (Action)&RtProcess::takeover );
	}
	return m.index();
}

void RtProcess::hang()
{
	if( !rtload(stabpath) ) {
		insert(ERRORKEY, "can't load real-time board");
		return;
	}
	procpath = stabpath;
	master->makeproc("!", stabpath);
	master->insert(this);
}

void RtProcess::hangopen()
{
	hang();
	open();
}

void RtProcess::hangtakeover()
{
	hang();
	takeover();
}
