//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 04/11/89 -- Initial design and implementation
//
// This file  contains an enum  definitions  for types day_of_week and months.
// It specifies symbolic constants to be used  as day  and month types.   Note
// that C++  does not distinguish between   an enum  type  and an integer,  so
// function arguments of type `day_of_week' and `month'  are really just `int'
// types.  In addition, ASCII string representations for the  days of the week
// and months  are  provided  in English only.   These can  be  indexed by the
// symbolic enums of the appropriate type.
//
// **NOTE**
// No international  string or  symbolic  representations  are   yet provided.
// These should be added later and can be indexed by the country type.

#ifndef CALENDARH		// If we have not yet defined the CALENDAR type,
#define CALENDARH		// Indicate that type CALENDAR has been included

enum day_of_week {				// Define days type
  SUNDAY,
  MONDAY,
  TUESDAY,
  WEDNESDAY,
  THURSDAY,
  FRIDAY,
  SATURDAY 
  };

enum months {					// Define months type
  JANUARY,
  FEBRUARY,
  MARCH,
  APRIL,
  MAY,
  JUNE,
  JULY,
  AUGUST,
  SEPTEMBER,
  OCTOBER,
  NOVEMBER,
  DECEMBER
  };

static char* day_names[] = {			// Define ASCII day names
  "Sunday",
  "Monday",
  "Tuesday",
  "Wednesday",
  "Thursday",
  "Friday",
  "Saturday",
  };

static char* month_names[] = {			// Define ASCII month names
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December"
  };

static int days_in_month[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

#define SECOND long(1)
#define MINUTE long(60*SECOND)
#define HOUR long(MINUTE*60)
#define DAY long(HOUR*24)
#define WEEK long(DAY*7)
#define YEAR long(WEEK*52)
#define IS_LEAP_YEAR(y) ((((y) % 4) == 0 && \
			  ((y) % 100) != 0 || ((y) % 400) == 0) ? TRUE : FALSE)

#endif						// End #ifdef of CALENDARH
