//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 06/15/89 -- Initial design and implementation.
// Updated: MJF 02/22/90 -- Split into separate file.
// Updated: MJF 02/22/90 -- New constructor for specifying multiple exceptions.

// An overview of the structure of the IGNORE_ERRS macro and the Jump_Handler
// class can be found in the Ignore_Errs.h header file.

#ifndef STDARGH			// If variable args not defined
# if defined(M_XENIX)
#  include <stdarg.hxx>
# else
#  include <stdarg.h>
# endif
#define STDARGH
#endif

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.
#include <cool/Ignore_Errs.h>   // include the Ignore_Errs header file.

// **********************************************************************
// Constructor for the Jump_Handler class
// **********************************************************************

// Jump_Handler(Jump_Handler_Function, Excp_Type)
//              -- a handler constructor which initializes
//                 with a specified Exception type and Handler function.
//
// Input:   An exception handler function and an exception type.
// Output:  None.

Jump_Handler::Jump_Handler(Jump_Handler_Function ehf, int n, Excp_Type et, ...)
{
  this->eh_func = (Excp_Handler_Function) ehf;

  if (n > 0) {
    this->excp_types = (Excp_Type*) new Excp_Type[n+1];
    this->excp_types[0] = et;
    va_list excp_args;
    va_start(excp_args, et);
    for (int i = 1; i < n; i++) {
      this->excp_types[i] = (Excp_Type) va_arg(excp_args, Excp_Type);
    }
    this->excp_types[n] = NULL;  // null terminated array
  } else this->excp_types = NULL;

  if (this->top_handler != this) {
    this->next_handler = this->top_handler;
    this->top_handler = this;
  }
}
