//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <test.h>
#include <cool/Gen_Tem.h>

DECLARE Generic<long>
IMPLEMENT Generic<long>

void test_Object () {
  Generic<long> n = 123;
  static Symbol* testv[4] = {SYM(foo), SYM(bar), SYM(Generic<long>), SYM(baz)};
#if GENERIC_TYPECHECK
  cout << n.type_of() << "  " << SYM(Generic<long>) << "\n";
  TEST ("Generic.type_of", n.type_of(), SYM(Generic<long>));
  TEST ("Generic.is_type_of", n.is_type_of(SYM(Generic<long>)), TRUE);
  TEST ("!Generic.is_type_of", n.is_type_of(SYM(Generic<Long>)), FALSE);
  TEST ("Generic.select_type_of", n.select_type_of(testv), 2);
  TEST ("Generic.describe", TRUE, TRUE);
  n.describe(cout);
#endif // GENERIC_TYPECHECK
  }

int main (void) {
  START("Generic");
  test_Object();
  SUMMARY();
  return 0;
}
