//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 06/06/89 -- Initial implementation
// Updated: LGO 09/19/89 -- Split into one file per method
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Generic.h>
#include <cool/Base_Hash.h>

// remove_error -- Raise exception for Hash_Table::remove()
// Input:          Bad lookup value
// Output:         None

void Hash_Table::remove_error (const char* T1, const char* T2) {
  RAISE (Error, SYM(Hash_Table), SYM(Invalid_Cpos),
	 "Hash_Table<%s,%s>::remove(): Invalid current position", T1, T2);
}
