//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/22/89 -- Initial design and implementation
// Updated: MBN 09/16/89 -- Added conditional exception handling
//

#include <cool/Package.h>

// remove -- Searches for Symbol in package and removes if found. The Symbol
//           entry is destroyed
// Input:    Pointer to Symbol entry
// Output:   Boolean TRUE/FALSE

Boolean Package::remove (Symbol* entry) {
  char* sname = (char*) entry->name();
  if (this->Hash_Table<char*, Symbol*>::remove(sname))
    {
      // Since the symbol may be statically allocated, don't delete it.
      // delete entry;				// If entry found, delete it
      return TRUE;				// And return success status
    }
  else return FALSE;				// Else return failure
}
