//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: LGO 01/05/90 -- Split into seperate files
//

#include <cool/char.h>		// Include char* specification header file


// strndup -- creates a new string and copies everything between
// zero and length of the given char* into it.  Returns the new
// string.

char* strndup (const char* s, long length) {
  if (length<0) return(NULL);
  char* ret = (char*) new char[length+1];
  char* retp = ret;  
  while(length-- > 0 && *s != END_OF_STRING)
    *retp++ = *s++;
  *retp = END_OF_STRING;
  return(ret);
}
