//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 08/31/89 -- Initial design and implementation
// Updated: LGO 09/19/89 -- Split into seperate files
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>			// Include the class header


// void set_alloc_size (int) -- Set the default allocation size growth rate.
// Input:                       Growth size in number of elements, type
// Output:                      None

void Vector::set_alloc_size (int n, const char* Type) {
#if ERROR_CHECKING
  if (n < 0)					// If index out of range
    RAISE (Error, SYM(Vector), SYM(Negative_Size),
	   "Vector<%s>::set_alloc_size(): Negative growth size %d",
	   Type, n);
#endif
  this->alloc_size = n;				// Set growth size
}
