//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Range.h>			        // Include range header file

#if defined(DOS)
extern "C" {
#include <string.h>
}
#else
#include <string.h>
#endif

DECLARE Range<double,2.5,8.8>;			// Declare range of doubles
IMPLEMENT Range<double,2.5,8.8>;		// Implement range of doubles
DECLARE Range<char*,"D", "K">;			// Declare range of strings
IMPLEMENT Range<char*, "D", "K">;		// Implement range of strings

extern int my_compare (const charP& s1, const charP& s2) {
  return (strcmp (s1, s2));
}

int main (void) {
  Range<double,2.5,8.8> r1;			// Range-checked double
  r1.set(4.3);					// Assign value
  cout << "r1 has an inclusive low bound of " << r1.low(); // Output low and
  cout << "an inclusive high bound of " << r1.high() << ",\n"; // High bounds
  cout << "and a value of " << (double)r1 << "\n"; // Output value
  double d1 = 1.9;				// Declare a double
  cout << (double)r1 << " * " << d1 << " = ";	// Output equation
  r1.set (d1 * r1);				// Calculate value
  cout << (double)r1 << "\n";			// And display it
  Range<charP,"D","K"> r2;			// Range-checked string
  r2.set_compare (&my_compare);			// Set compare function
  r2.set("EFG");				// Assign value
  cout << "r2 has an inclusive low bound of " << r2.low();
  cout << "an inclusive high bound of " << r2.high() << ",\n";
  cout << "a value of " << (char*)r2;		// Output string value
  cout << ", and a length of " << strlen (r2) << "\n"; // Output length
  return 0;					// Exit with OK status
}
