//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/D_Node.h>			// Include node class
#include <cool/N_Tree.h>			// Include n-ary tree class
#include <cool/String.h>			// Include COOL String class

DECLARE N_Tree<D_Node,String,3>			// Declare tree type
IMPLEMENT N_Tree<D_Node,String,3>		// Implement tree type
  
int main (void) {
  D_Node<String,3> president (String("President")); // Create president
  N_Tree<D_Node,String,3> org_chart (president);    // Setup top of tree
  D_Node<String,3> sales (String("Sales"));	    // Create sales
  D_Node<String,3> service (String("Service"));	    // Create service
  D_Node<String,3> finance (String("Finance"));	    // Create finance
  D_Node<String,3> legal (String("Legal"));	    // Create legal
  president[0] = &sales;			    // Add sales to chart
  president.insert_after(service, 0);		    // Add service to chart
  president.insert_after(finance, 1);		    // Add finance to chart
  president.insert_after(legal, 2);		    // Add legal to chart
  sales[0] = new D_Node<String,3> (String("Domestic"));	    // Domestic sales
  D_Node<String,3> international (String("International")); // International
  sales.insert_after(international, 0);
  international[0] = new D_Node<String,3> (String("Asia"));
  international.insert_after(*(new D_Node<String,3> (String("Europe"))), 0);
  international.insert_after(*(new D_Node<String,3> (String("Africa"))), 1);
  finance[0] = new D_Node<String,3> (String("Short Term"));
  finance.insert_after(*(new D_Node<String,3> (String("Long Term"))), 0);
  finance.insert_after(*(new D_Node<String,3> (String("Collections"))), 1);
  org_chart.traversal() = PREORDER;		    // Set traversal mode
  for (org_chart.reset (); org_chart.next (); ) {   // For each node in tree
    for (int i = 0; i < org_chart.current_depth (); i++) // Indent level
      cout << "   ";
    cout << org_chart.value () << "\n";
  }
  return (0);					    // Return success
}
