;  DEFINITIONS.EM,  EMACS*>EXTENSIONS>OBSOLETE_SOURCES, TOOLS GROUP, 05/19/82
;  Contains commonly used functions used by many extensions in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Modifications:
;
;   Date      Programmer   Description
;   04/15/82    BMZ        Fill mode no longer default for programmer$
;   04/27/82    BMZ        Viewer no longer defaults on .list, .map, .runo
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; case_on          Case is significant in a search                         ;;;
;;; case_off         Case is ignored in a search                             ;;;
;;; case?            Tells case searching status                             ;;;
;;; create_text_save_buffer$                                                  ;;;
;;;                  Creates a text_save ring like the kill ring             ;;;
;;; looked_at        Exactly like the looking_at function except it is       ;;;
;;;                  used for text that precedes point.                      ;;;
;;; save_position    Retains current place in buffer so after leaving        ;;;
;;;                  buffer, place remains the same                          ;;;
;;; turn_mode_on     a function that inserts a mode name into the mode       ;;;
;;;                  list.  This is used internally.                         ;;;
;;; turn_mode_off    a function that removes a mode name from the mode       ;;;
;;;                  list.  This is used internally.                         ;;;
;;; yesno            a function that returns true when a user reponds        ;;;
;;;                  yes (or a synonym) to a question or false when          ;;;
;;;                  answering no.                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Also contained are the following functions used by the auto load
;;; sequences:
;;;     autoload_lib
;;;     def_auto
;;;     load_lib
;;; Global Variable:

                      (setq text_counter$ 0)


(defcom cobol_on &doc "Turns_on COBOL mode (Autoload)" (autoload_lib cobol_on "cobol"))
(defcom fill_on &doc "Allows character wrapping for this file (Autoload)" (autoload_lib fill_on "fill"))
(defcom fortran_on &doc "Turns on FORTRAN mode (Autoload)" (autoload_lib fortran_on "fortran"))
(defcom overlay_on &doc "Turns on overlay mode (Autoload)" (autoload_lib overlay_on "overlay"))
(defcom rpg_on &doc "Turns on RPG mode (Autoload)" (autoload_lib rpg_on "rpg"))
(defcom compile &doc "Compiles programs from within EMACS (Autoload)" (autoload_lib compile "compile"))
(defcom lisp_on &doc "Turns on LISP mode (Autoload)" (autoload_lib lisp_on "lisp"))

(defun found_file_hook  ()
     (setq file_hook_type$ (list user_type$))
     (if (null (car file_hook_type$))
         (if (null (cdr file_hook_type$))
             (return)))
     (if (= file_hook_type$ '(no_file_hooks))
         (return))
     (eval file_hook_type$))

(defun no_file_hooks$ () )

(defun clerical$ ()
    (select (suffix$)
      "runi"
          (fill_on)
      otherwise
          (fill_on)))

(defun programmer$ ()
      (select (suffix$)
          "runi"
               (fill_on)          ; text mode
          "em"
               (lisp_on)          ; lisp mode
          "cobol"
               (cobol_on)         ; cobol on
          "ftn" "f77"
               (fortran_on)       ; fortran mode
          "rpg"
               (rpg_on)           ; rpg mode
          "vrpg"
               (vrpg_on)          ; vrpg mode
          "pl1"
               (pl1_on)           ; full pl1
          "pl1g"
               (pl1g_on)          ; pl1 subset G
          "como"
               ()
          otherwise
               ()
          ))



(defun rest$ ( &returns string )
  (return suffix$))

(defun suffix$ (&local (suffix string)
                       (pos integer)
              &returns string)
    (setq suffix (buffer_info name))
    (if (= (index suffix ".") 0)
        (return " "))               ;     no suffix then return
    (do_forever                 ; check if more than one period
        (setq pos (index suffix "."))
        (if (= pos 0) (return suffix))
        (setq suffix (substr suffix (1+ pos)))))


(defcom set_user_type
    &doc "Sets a users category"
    &args ((user_type &prompt "What is your user type"
                      &default "clerical$"))
    (setq user_type (trim user_type))
    (if (= user_type "?")
        (print "System defined user categories ")
        (print "       no_file_hooks$          ")
        (print "       clerical$               ")
        (print "       programmer$             ")
        (print "Users can also define their own")
        (print "===============================")
        (set_user_type)
     else
        (if (= user_type "") (setq user_type "clerical$"))
        (setq user_type$ (intern user_type))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; turn_mode_on
;;;     Function that turns a mode on and adds the mode name to
;;;     the buffer mode list.
;;;
;;;        (turn_mode_on dispatch-table optional-string)
;;;
;;;     where dispatch-table is the mode name and string indicates if the
;;;     name should be placed first on the mode list.  For example:
;;;
;;;          (turn_mode_on (find_mode 'lisp) first)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun turn_mode_on ((mode dispatch)
                     &optional &quote (side atom)
                     &local (modes list))
    (turn_mode_off mode)
    (setq modes (buffer_info modes))
    (if (eq side 'first)
        (buffer_info modes (cons mode modes))
     else
        (buffer_info modes (append modes (list mode)))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; turn_mode_off
;;;    Function that turns off a mode.  That is, it removes a mode name
;;;    from the buffer mode list.
;;;
;;;        (turn_mode_off dispatch-table)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun turn_mode_off (se_on
     &doc "Only find text when they are the same case"
     (setq *ignore_case_in_search false)
     (case?))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; case_off                                                                 ;;;
;;;    Sets case variable, *ignore_case_in_search, to true so that case      ;;;
;;;    is not significant in a search.                                       ;;;
;;;                                                                          ;;;
;;;        (case_off)                                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom case_off
     &doc "Ignore case of text when searching"
     (setq *ignore_case_in_search true)
     (case?))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; case?                                                                    ;;;
;;;   Tells whether or not case matching will occur in a search              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom case?
     &doc "Print case matching status"
     (if *ignore_case_in_search
         (info_message "Cases are ignored when searching.")
      else
         (info_message "Cases are looked at when searching.")))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; case_replace_on                                                          ;;;
;;;    Sets case_replace variable, *ignore_case_replace_in_search, to false  ;;;
;;;    so that case is significant in a replace and query_replace            ;;;
;;;                                                                          ;;;
;;;        (case_replace_on)                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom case_replace_on
     &doc "Honor case in replaces"
     (setq *ignore_case_in_replace false)
     (case_replace?))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; case_replace_off                                                         ;;;
;;;    Sets case_replace variable, *ignore_case_replace_in_search, to true   ;;;
;;;    so that case is not significant in a search.                          ;;;
;;;                                                                          ;;;
;;;        (case_replace_off)                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom case_replace_off
     &doc "Ignore case of text when replacing"
     (setq *ignore_case_in_replace true)
     (case_replace?))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Case_replace?                                                            ;;;
;;;   Tells whether or not case matching will occur in a replace             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom case_replace?
     &doc "Print case matching status for replace"
     (if *ignore_case_in_replace
         (info_message "Cases are ignored in replace.")
      else
         (info_message "Cases are looked at in replace.")))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;  FUNCTIONS FOR MAINTENANCE ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;  WARNING  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  If you alter these functions, autoload may not work                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun autoload_lib (&quote (atom atom)
                     &eval  (package string))
     (let ((old (fsymeval atom))
           (new '()))
          (load_lib package)
          (setq new (fsymeval atom))
          (if (eq old new)
              (error_message "Not loaded")
              (set_command_abort_flag)
              (return))
          (if (= (typef new) Type.handler)
               (setq new (handler_info new handler)))
          (eval (list new))))

(defun load_lib (       (package string)
                 &local (lib string)
                        (short string))
    (if (= (index package ">") 0)
        (setq short package)
        (setq lib (catenate "emacs*>extensions>" package))
     else
        (setq short (file_info package entry_name))
        (setq lib package))
    (info_message (catenate "Loading " short " package: " lib))
    (fasload lib)
    (info_message ""))

(defun def_auto (&quote (name atom)         ; name of function to be loaded
                 &eval (doc string)         ; documentation for the function
                       (package string)     ; name of package within EMACS*>
                 &optional                  ;   EXTENSIONS
                       (evaler function)  ; Used by DUMP_PACKAGE
                 &local (the_list list))
  (setq the_list
        `(defcom ,name
                 &doc ,(catenate doc " (Autoload)")
                 (autoload_lib ,name ,package)))
  (if (null evaler)
      (if (not (null (fsymeval name))) (return))
      (eval the_list)
   else
      (print the_list current_cursor)))
(setq definitions_loaded$ true)
