;  OVERLAY.EM,  EMACS*>EXTENSIONS>OBSOLETE_SOURCES, TOOLS GROUP-DNK, 11/05/82
;  Contains functions for the EMACS overlay mode
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; overlay_off      Extended command that turns off overlay mode            ;;;
;;; overlay_on       Extended command that turns on overlay mode             ;;;
;;; overlay_rubout   Rubout used by overlay mode                    {ctrl-h} ;;;
;;; overlayer        Function that performs the overlaying                   ;;;
;;; setup_overlay_mode                                                       ;;;
;;;                  Sets up the character definitions used by               ;;;
;;;                  overlay mode                                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

   (if (null loaded$) (load))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; overlay_on                                                               ;;;
;;;   Extended command that turns on overlay mode                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom overlay_on
     &doc "Turn on overlay mode"
     (overlay_onf$))

(defun overlay_onf$ ()
     (buffer_info (user was_2d)
                  (buffer_info two_dimensional true))
     (turn_mode_on (find_mode 'overlay) first))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; overlay_off                                                              ;;;
;;;   Extended command that turns off overlay mode                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom overlay_off
     &doc "Turns off overlay mode"
     (overlay_offf$))

(defun overlay_offf$ ()
     (buffer_info two_dimensional (buffer_info (user was_2d)))
     (turn_mode_off (find_mode 'overlay)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; overlay_rubout                                                           ;;;
;;;    Command that deletes a character in overlay mode.  It removes         ;;;
;;;    the character but leaves a space there.  This does not accept         ;;;
;;;    arguments.                                                            ;;;
;;;                                                                          ;;;
;;;        (overlay_rubout)                                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom overlay_rubout
        &doc "Rubout previous character in overlay mode"
        (if (^ (bolp))
            (rubout_char)
            (insert " ")
            (back_char)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; setup_overlay_mode                                                       ;;;
;;;    Function used by overlay mode to define how characters are used.      ;;;
;;;                                                                          ;;;
;;;        (setup_overlay_mode)                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun setup_overlay_mode (&local (charcode integer)
                                  (overlay dispatch))
     (setq charcode 32)
     (setq overlay (find_mode 'overlay))
     (do_n_times 95
          (dispatch_info overlay (ItoP charcode) 'overlayer)
          (setq charcode (1+ charcode)))
     (set_mode_key "overlay" "^h" "overlay_rubout"))

(setup_overlay_mode)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; overlayer                                                                ;;;
;;;    Function that actually performs the overlaying in overlay mode        ;;;
;;;                                                                          ;;;
;;;         (overlayer)                                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom overlayer
     &doc "Overlay current character"
     (do_n_times (numeric_argument 1)
          (if (^ (eolp))  (delete_char))
          (insert (character_argument))))

(setq overlay_loaded$ true)
