;  BUFFER_INSERT.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/10/82
;  Contains buffer manipulation extensions in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;  Modifications:
;
;  11/10/82 DNK   Improved error handling in insert_buff (Lou Gross suggestion)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; append_to_buf         takes a region and puts it at end of     ^xa       ;;;
;;;                       named buffer.                                      ;;;
;;; append_to_file        takes a region and puts it at end of a   ^x^z^a    ;;;
;;;                       named file                                         ;;;
;;; insert_buf            save as insert file, but on buffers      ^x^zi     ;;;
;;; prepend_to_buf        takes a region and puts it at beginning  ^xp       ;;;
;;;                       of a named buffer.                                 ;;;
;;; prepend_to_file       takes a region and puts it at beginning  ^x^zp     ;;;
;;;                       of a named file                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 02/03/83 Zane   (if (null loaded$) (load))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; append_to_buf                                                            ;;;
;;;     Command that appends the current region to a buffer (which it        ;;;
;;;     prompts for). Append means put it at the end of the buffer.  If      ;;;
;;;     you use a numerical argument (any value), the region is copied.      ;;;
;;;     Otherwise, the region is deleted.  This is bound as ^xa.             ;;;
;;;                                                                          ;;;
;;;         (append_to_buf integer)                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom append_to_buf
     &doc "Appends current region to a buffer"
     &na (&pass count &default 1)
     (save_position
         (if (= count 1)               ; if arg, kill text
             (kill_region)
          else
             (copy_region))           ; else copy it
         (go_to_cursor (find_buffer (prompt "Buffer name")))
         (move_bottom)
         (yank_region))
     (info_message "Region appended"))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; prepend_to_buf                                                           ;;;
;;;     Command that prepends the current region to a buffer (which it       ;;;
;;;     prompts for). Prepend means put it at the beginning of the buffer.   ;;;
;;;     If you use a numerical argument (any value), the region is copied.   ;;;
;;;     Otherwise, the region is deleted.  This is bound as ^xp.             ;;;
;;;                                                                          ;;;
;;;         (prepend_to_buf integer)                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom prepend_to_buf
     &doc "Prepends current region to a buffer"
     &na (&pass count &default 1)
     (save_position
          (if (= count 1)
              (kill_region)
           else
              (copy_region))
          (go_to_cursor (find_buffer (prompt "Buffer name")))
          (yank_region))
      (info_message "Region prepended"))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; append_to_file                                                           ;;;
;;;     Command that appends the current region to a file (which it          ;;;
;;;     prompts for).  Append means put it at the end of the file.  If       ;;;
;;;     you use a numerical argument (any value), the region is copied.      ;;;
;;;     Otherwise, the region is deleted.  This is bound as ^x^za.           ;;;
;;;                                                                          ;;;
;;;         (append_to_file integer)                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom append_to_file
     &doc "Appends current region to a file"
     &na (&pass count &default 1)
     (save_position
        (let ((place (prompt "What file do you want to append to")))
             (if (= count 1)               ; no arg or 1 is kill before
                 (kill_region)
              else
                 (copy_region))           ; else copy
             (with_no_redisplay
                 (if (file_info place exists)  ;check if file exists
                     (find_file place)
                  else                         ; if it doesn't, create it
                     (go_to_cursor (find_buffer place))
                     (write_file place))
                 (move_bottom)
                 (yank_region)
                 (save_file))))
      (info_message "Region appended"))





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; prepend_to_file                                                          ;;;
;;;      Command that prepends the current region to a file (which it        ;;;
;;;      prompts for).  Prepend means put it at the beginning of th file.    ;;;
;;;      if you use a numerical argument (any value), the region is copied.  ;;;
;;;      Otherwise, the region is deleted.  This is bound as ^x^zp.          ;;;
;;;                                                                          ;;;
;;;         (prepend_to_file integer)                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom prepend_to_file
   &doc "Prepends current region to a file"
   &na (&pass count &default 1)
   (save_position
     (let ((place (prompt "What file do you want to prepend to")))
          (if (= count 1)
              (kill_region)      ; if no arg, kill
           else
              (copy_region))     ; else copy
          (with_no_redisplay
              (if (file_info place exists) ; check if file exists
                  (find_file place)
               else
                  (go_to_cursor 